/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol.events;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PrepareAnvilEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected final Object transaction;
    protected ItemStack[] topContents;
    protected ItemStack[] bottomContents;
    protected final String textEntry;
    private Event.Result prepareAnvil;

    public PrepareAnvilEvent(@Nonnull Object transaction, @Nonnull String textEntry) {
        this.transaction = transaction;
        this.textEntry = textEntry;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    private void saveContents() {
        if (this.topContents == null && this.bottomContents == null) {
            int itr = 0;
            this.topContents = CompatUtils.getTopInventory(this.transaction).getContents();
            this.bottomContents = CompatUtils.getBottomInventory(this.transaction).getContents();
            for (ItemStack stack : this.topContents) {
                if (this.topContents[itr] != null) {
                    this.topContents[itr] = stack.clone();
                }
                ++itr;
            }
            itr = 0;
            for (ItemStack stack : this.bottomContents) {
                if (this.bottomContents[itr] != null) {
                    this.bottomContents[itr] = stack.clone();
                }
                ++itr;
            }
        }
    }

    @Nonnull
    public final Player getPlayer() {
        this.saveContents();
        return CompatUtils.getPlayer(this.transaction);
    }

    @Nonnull
    public ItemStack[] getPreviousContents(boolean isTop) {
        return isTop ? this.topContents : this.bottomContents;
    }

    @Nonnull
    public ItemStack[] getTopContents() {
        return CompatUtils.getTopInventory(this.transaction).getContents();
    }

    @Nonnull
    public ItemStack[] getBottomContents() {
        return CompatUtils.getBottomInventory(this.transaction).getContents();
    }

    @Nonnull
    public Inventory getTopInventory() {
        return CompatUtils.getTopInventory(this.transaction);
    }

    @Nonnull
    public Inventory getInventory() {
        return CompatUtils.getTopInventory(this.transaction);
    }

    @Nonnull
    public List<HumanEntity> getViewers() {
        return CompatUtils.getTopInventory(this.transaction).getViewers();
    }

    public Object getView() {
        return this.transaction;
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return CompatUtils.getTopInventory(this.transaction).getItem(slot);
    }

    @Nonnull
    public String getRenameText() {
        return this.textEntry;
    }

    public void removeItem(@Nonnull ItemStack stack, int slot) {
        stack.setAmount(0);
        stack.setType(Material.AIR);
        try {
            CompatUtils.getTopInventory(this.transaction).setItem(slot, new ItemStack(Material.AIR));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setResult(@Nonnull ItemStack stack) {
        CompatUtils.getTopInventory(this.transaction).setItem(2, stack.clone());
    }

    public boolean isCancelled() {
        return this.prepareAnvil() == Event.Result.DENY;
    }

    public void setCancelled(boolean cancel) {
        this.prepareAnvil(cancel ? Event.Result.DENY : (this.prepareAnvil() == Event.Result.DENY ? Event.Result.DEFAULT : this.prepareAnvil()));
    }

    @Nonnull
    public Event.Result prepareAnvil() {
        return this.prepareAnvil;
    }

    public void prepareAnvil(@Nonnull Event.Result prepareAnvil) {
        this.prepareAnvil = prepareAnvil;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

