/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.CoreData;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;

abstract class Controller {
    protected Connection connection;
    protected String dataFolder;

    Controller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Connection getConnection(boolean ... force) throws SQLException {
        String string = "CC_SQL";
        synchronized ("CC_SQL") {
            if (this.isClosed(this.connection) || force.length > 0 && force[0]) {
                ServerUtils.logDebug("{SQL} Connection was detected as being closed, initializing... isClosed: " + this.connection + " " + (this.connection == null || this.connection.isClosed()) + " forced: " + (force.length > 0 && force[0]));
                if (Core.getCore().getData().sqlEnabled()) {
                    ServerUtils.logDebug("{SQL} Detected MySQL configuration, setting up!");
                    try {
                        long start;
                        block25: {
                            Class<?> driverClass;
                            CoreData data = Core.getCore().getData();
                            String database = this.jdbc(data, true);
                            try {
                                driverClass = Class.forName("com.mysql.cj.jdbc.Driver");
                            }
                            catch (ClassNotFoundException e) {
                                driverClass = Class.forName("com.mysql.jdbc.Driver");
                            }
                            Driver driver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            ServerUtils.logInfo("Loading SQL driver: " + driver.getMajorVersion() + "." + driver.getMinorVersion() + " (" + driverClass.getName() + ")");
                            start = System.nanoTime();
                            try {
                                this.connection = DriverManager.getConnection(database, data.getSQLUser(), data.getSQLPass());
                                try (Statement statement = this.connection.createStatement();){
                                    statement.executeUpdate("SET NAMES 'utf8'");
                                }
                            }
                            catch (Exception e) {
                                if (!StringUtils.containsIgnoreCase(e.getMessage(), "unknown database")) break block25;
                                Statement ps = null;
                                try {
                                    String newDatabase = this.jdbc(data, false);
                                    this.connection = DriverManager.getConnection(newDatabase, data.getSQLUser(), data.getSQLPass());
                                    ps = this.connection.createStatement();
                                    ps.executeUpdate("CREATE DATABASE IF NOT EXISTS " + data.getSQLDatabase() + ";");
                                    this.close(ps, null, this.connection, true);
                                }
                                catch (Exception e2) {
                                    ServerUtils.logSevere("{SQL} [1] Failed to create the database, please manually create the database defined in your config.yml Database settings.");
                                    ServerUtils.sendSevereTrace(e);
                                }
                                finally {
                                    this.close(ps, null, this.connection, true);
                                }
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return this.getConnection(new boolean[0]);
                            }
                        }
                        long end = System.nanoTime();
                        double durationMs = (double)(end - start) / 1000000.0;
                        ServerUtils.logInfo(String.format("Connected to MySQL database successfully (%.1f ms).", durationMs));
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{SQL} Unable to connect to the defined MySQL database, check your settings.");
                        ServerUtils.sendSevereTrace(e);
                    }
                } else {
                    try {
                        ServerUtils.logDebug("{SQL} Detected SQLite configuration, setting up!");
                        File dataFolder = new File(Core.getCore().getPlugin().getDataFolder(), this.dataFolder + ".db");
                        String database = "jdbc:sqlite:" + dataFolder.getAbsolutePath();
                        ReflectionUtils.getCanonicalClass("org.sqlite.JDBC");
                        this.connection = DriverManager.getConnection(database);
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{SQL} SQLite exception on initialize.");
                        ServerUtils.sendSevereTrace(e);
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.connection;
        }
    }

    private String jdbc(CoreData data, boolean database) {
        String base = "jdbc:mysql://" + data.getSQLHost() + ":" + data.getSQLPort();
        if (database) {
            base = base + "/" + data.getSQLDatabase();
        }
        return base + "?useUnicode=true&characterEncoding=utf-8&connectTimeout=20000&socketTimeout=20000&useSSL=false&allowPublicKeyRetrieval=true&useCursorFetch=true&useLocalSessionState=true&rewriteBatchedStatements=true&maintainTimeStats=false";
    }

    protected boolean isClosed(@Nullable Statement object) {
        try {
            if (object == null || object.isClosed()) {
                return true;
            }
        }
        catch (AbstractMethodError | NoClassDefFoundError e) {
            return true;
        }
        catch (SQLException e) {
            ServerUtils.logSevere("{SQL} [11] Failed to check if the Statement connection is closed.");
            ServerUtils.sendDebugTrace(e);
            return true;
        }
        return false;
    }

    protected boolean isClosed(@Nonnull ResultSet object) {
        try {
            if (object.isClosed()) {
                return true;
            }
        }
        catch (AbstractMethodError | NoClassDefFoundError e) {
            return true;
        }
        catch (SQLException e) {
            ServerUtils.logSevere("{SQL} [11] Failed to check if the ResultSet connection is closed.");
            ServerUtils.sendDebugTrace(e);
            return true;
        }
        return false;
    }

    protected boolean isClosed(@Nullable Connection object) {
        try {
            if (object == null || object.isClosed()) {
                return true;
            }
        }
        catch (AbstractMethodError | NoClassDefFoundError e) {
            return true;
        }
        catch (SQLException e) {
            ServerUtils.logSevere("{SQL} [11] Failed to check if the Database connection is closed.");
            ServerUtils.sendDebugTrace(e);
            return true;
        }
        return false;
    }

    protected void close(@Nullable Statement ps, @Nullable ResultSet rs, @Nullable Connection conn, boolean force) {
        try {
            if (ps != null && !this.isClosed(ps)) {
                ps.close();
            }
            if (rs != null && !this.isClosed(rs)) {
                rs.close();
            }
            if (conn != null && !this.isClosed(conn) && force) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    ServerUtils.logSevere("{SQL} [10] Failed to close database connection.");
                    ServerUtils.sendDebugTrace(e);
                }
            }
        }
        catch (SQLException e) {
            ServerUtils.logSevere("{SQL} [10] Failed to close database connection(s).");
            ServerUtils.sendDebugTrace(e);
        }
    }
}

