/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.sql.Controller;

public class Database
extends Controller {
    private static Database data;

    public Database(@Nonnull String databaseName) {
        this.dataFolder = databaseName;
    }

    public static void kill() {
        if (data != null) {
            data.closeConnection(true);
            data = null;
        }
    }

    @Nonnull
    public static Database getDatabase() {
        if (data == null || !Database.data.dataFolder.equalsIgnoreCase("database")) {
            data = new Database("database");
            try {
                data.getConnection(new boolean[0]);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{SQL} [1] Failed to open database connection.");
                ServerUtils.sendDebugTrace(e);
            }
        }
        return data;
    }

    @Nonnull
    public static Database getDatabase(@Nonnull String baseName) {
        if (data == null || !Database.data.dataFolder.equalsIgnoreCase(baseName)) {
            data = new Database(baseName);
            try {
                data.getConnection(new boolean[0]);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{SQL} [2] Failed to open database connection.");
                ServerUtils.sendDebugTrace(e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(@Nonnull String statement) {
        Connection conn = null;
        Statement ps = null;
        try {
            Object[] executed = this.executeStatement(statement, false, new boolean[0]);
            conn = (Connection)executed[0];
            ps = (Statement)executed[1];
        }
        catch (Exception e) {
            try {
                ServerUtils.logSevere("{SQL} [1] Failed to execute database statement.");
                if (conn != null) {
                    try {
                        ServerUtils.logSevere("{SQL} [1] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                    }
                    catch (Exception e2) {
                        ServerUtils.logSevere("{SQL} [1] Failed to determine the Database Status.");
                    }
                }
                ServerUtils.logSevere("{SQL} [1] Statement: " + statement);
                ServerUtils.sendSevereTrace(e);
            }
            catch (Throwable throwable) {
                this.close(ps, null, conn, false);
                throw throwable;
            }
            this.close(ps, null, conn, false);
        }
        this.close(ps, null, conn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object queryValue(@Nonnull String statement, @Nonnull String row) {
        Object returnValue;
        ResultSet rs;
        Statement ps;
        Connection conn;
        block7: {
            conn = null;
            ps = null;
            rs = null;
            returnValue = null;
            try {
                Object[] executed = this.executeStatement(statement, true, new boolean[0]);
                conn = (Connection)executed[0];
                ps = (Statement)executed[1];
                rs = (ResultSet)executed[2];
                if (!rs.next()) break block7;
                returnValue = rs.getObject(row);
            }
            catch (Exception e) {
                try {
                    ServerUtils.logSevere("{SQL} [2] Failed to execute database statement.");
                    if (conn != null) {
                        try {
                            ServerUtils.logSevere("{SQL} [2] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                        }
                        catch (Exception e2) {
                            ServerUtils.logSevere("{SQL} [2] Failed to determine the Database Status.");
                        }
                    }
                    ServerUtils.logSevere("{SQL} [2] Statement: " + statement);
                    ServerUtils.sendSevereTrace(e);
                }
                catch (Throwable throwable) {
                    this.close(ps, rs, conn, false);
                    throw throwable;
                }
                this.close(ps, rs, conn, false);
            }
        }
        this.close(ps, rs, conn, false);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Object> queryRow(@Nonnull String statement, @Nonnull String row) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            Object[] executed = this.executeStatement(statement, true, new boolean[0]);
            conn = (Connection)executed[0];
            ps = (Statement)executed[1];
            rs = (ResultSet)executed[2];
            while (rs.next()) {
                objects.add(rs.getObject(row));
            }
        }
        catch (Exception e) {
            try {
                ServerUtils.logSevere("{SQL} [3] Failed to execute database statement.");
                if (conn != null) {
                    try {
                        ServerUtils.logSevere("{SQL} [3] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                    }
                    catch (Exception e2) {
                        ServerUtils.logSevere("{SQL} [3] Failed to determine the Database Status.");
                    }
                }
                ServerUtils.logSevere("{SQL} [3] Statement: " + statement);
                ServerUtils.sendSevereTrace(e);
            }
            catch (Throwable throwable) {
                this.close(ps, rs, conn, false);
                throw throwable;
            }
            this.close(ps, rs, conn, false);
        }
        this.close(ps, rs, conn, false);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<HashMap<String, String>> queryTableData(@Nonnull String statement, @Nonnull String rows) {
        ArrayList<HashMap<String, String>> existingData = new ArrayList<HashMap<String, String>>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            Object[] executed = this.executeStatement(statement, true, new boolean[0]);
            conn = (Connection)executed[0];
            ps = (Statement)executed[1];
            rs = (ResultSet)executed[2];
            while (rs.next()) {
                HashMap<String, String> columnData = new HashMap<String, String>();
                for (String singleRow : rows.split(", ")) {
                    if (this.isClosed(rs) || this.isClosed(conn)) continue;
                    columnData.put(singleRow, rs.getString(singleRow));
                }
                existingData.add(columnData);
            }
        }
        catch (Exception e) {
            try {
                ServerUtils.logSevere("{SQL} [4] Failed to execute database statement.");
                if (conn != null) {
                    try {
                        ServerUtils.logSevere("{SQL} [4] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                    }
                    catch (Exception e2) {
                        ServerUtils.logSevere("{SQL} [4] Failed to determine the Database Status.");
                    }
                }
                ServerUtils.logSevere("{SQL} [4] Statement: " + statement);
                ServerUtils.sendSevereTrace(e);
            }
            catch (Throwable throwable) {
                this.close(ps, rs, conn, false);
                throw throwable;
            }
            this.close(ps, rs, conn, false);
        }
        this.close(ps, rs, conn, false);
        return existingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Map<String, List<Object>> queryMultipleRows(@Nonnull String statement, String ... row) {
        ArrayList<Object> objects = new ArrayList<Object>();
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            Object[] executed = this.executeStatement(statement, true, new boolean[0]);
            conn = (Connection)executed[0];
            ps = (Statement)executed[1];
            rs = (ResultSet)executed[2];
            while (rs.next()) {
                for (String singleRow : row) {
                    objects.add(rs.getObject(singleRow));
                }
                for (String singleRow : row) {
                    map.put(singleRow, objects);
                }
            }
        }
        catch (Exception e) {
            try {
                ServerUtils.logSevere("{SQL} [5] Failed to execute database statement.");
                if (conn != null) {
                    try {
                        ServerUtils.logSevere("{SQL} [5] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                    }
                    catch (Exception e2) {
                        ServerUtils.logSevere("{SQL} [5] Failed to determine the Database Status.");
                    }
                }
                ServerUtils.logSevere("{SQL} [5] Statement: " + statement);
                ServerUtils.sendSevereTrace(e);
            }
            catch (Throwable throwable) {
                this.close(ps, rs, conn, false);
                throw throwable;
            }
            this.close(ps, rs, conn, false);
        }
        this.close(ps, rs, conn, false);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(@Nonnull String statement) {
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        boolean columnExists = false;
        try {
            Object[] executed = this.executeStatement(statement, true, new boolean[0]);
            conn = (Connection)executed[0];
            ps = (Statement)executed[1];
            rs = (ResultSet)executed[2];
            columnExists = true;
        }
        catch (Exception e) {
            block7: {
                try {
                    if (StringUtils.containsIgnoreCase(e.getCause().getMessage(), "no such column") || StringUtils.containsIgnoreCase(e.getCause().getMessage(), "unknown column") || StringUtils.containsIgnoreCase(e.getCause().getMessage(), "unknown error")) break block7;
                    ServerUtils.logSevere("{SQL} [6] Failed to execute database statement.");
                    if (conn != null) {
                        try {
                            ServerUtils.logSevere("{SQL} [6] Database Status: Open: " + !this.isClosed(conn) + "! Writable: " + !conn.isReadOnly() + "!");
                        }
                        catch (Exception e2) {
                            ServerUtils.logSevere("{SQL} [6] Failed to determine the Database Status.");
                        }
                    }
                    ServerUtils.logSevere("{SQL} [6] Statement: " + statement);
                    ServerUtils.sendSevereTrace(e);
                }
                catch (Throwable throwable) {
                    this.close(ps, rs, conn, false);
                    throw throwable;
                }
            }
            this.close(ps, rs, conn, false);
        }
        this.close(ps, rs, conn, false);
        return columnExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(@Nonnull String tableName) {
        boolean tExists = false;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(new boolean[0]);
            rs = conn.getMetaData().getTables(null, null, tableName, null);
            while (rs.next()) {
                String tName;
                if (this.isClosed(rs) || this.isClosed(conn) || (tName = rs.getString("TABLE_NAME")) == null || !tName.equals(tableName)) continue;
                tExists = true;
                break;
            }
        }
        catch (Exception e) {
            try {
                ServerUtils.logSevere("{SQL} [9] Failed to check if the table " + tableName + " exists.");
                ServerUtils.sendDebugTrace(e);
            }
            catch (Throwable throwable) {
                this.close(null, rs, conn, false);
                throw throwable;
            }
            this.close(null, rs, conn, false);
        }
        this.close(null, rs, conn, false);
        return tExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataExists(@Nonnull String statement) {
        boolean dataExists;
        ResultSet rs;
        Statement ps;
        Connection conn;
        block5: {
            conn = null;
            ps = null;
            rs = null;
            dataExists = false;
            try {
                Object[] executed = this.executeStatement(statement, true, new boolean[0]);
                conn = (Connection)executed[0];
                ps = (Statement)executed[1];
                rs = (ResultSet)executed[2];
                if (rs != null && !rs.isBeforeFirst()) {
                    ServerUtils.logDebug("{SQL} Result set is empty.");
                    break block5;
                }
                ServerUtils.logDebug("{SQL} Result set is not empty.");
                dataExists = true;
            }
            catch (Exception e) {
                try {
                    ServerUtils.logSevere("{SQL} Could not read from the " + Database.data.dataFolder + ".db file, some " + Core.getCore().getPlugin().getName() + " features have been disabled!");
                    ServerUtils.sendSevereTrace(e);
                }
                catch (Throwable throwable) {
                    this.close(ps, rs, conn, false);
                    throw throwable;
                }
                this.close(ps, rs, conn, false);
            }
        }
        this.close(ps, rs, conn, false);
        return dataExists;
    }

    private Object[] executeStatement(@Nonnull String statement, boolean isQuery, boolean ... retry) {
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(retry.length > 0 && retry[0]);
            ps = conn.createStatement();
            if (isQuery) {
                rs = ps.executeQuery(statement);
            } else {
                ps.executeUpdate(statement);
            }
            return new Object[]{conn, ps, rs};
        }
        catch (SQLException e) {
            if (StringUtils.containsIgnoreCase(e.getMessage(), "SQLNonTransientConnectionException") || StringUtils.containsIgnoreCase(e.getMessage(), "CommunicationsException") || StringUtils.containsIgnoreCase(e.getMessage(), "The database has been closed") || StringUtils.containsIgnoreCase(e.getMessage(), "Communications link failure")) {
                ServerUtils.logDebug("{SQL} Failed to execute statement: " + statement);
                ServerUtils.logDebug("{SQL} Attempting to restart database connection and retry...");
                if (retry.length == 0) {
                    this.close(ps, rs, conn, true);
                    return this.executeStatement(statement, isQuery, true);
                }
                ServerUtils.logSevere("{SQL} [Retry] An attempt was made to restart the connection but failed, this is likely a connection issue!");
                throw new IllegalStateException("{SQL} [Retry] Failed to execute statement: " + statement);
            }
            throw new IllegalStateException("{SQL} Failed to execute statement: " + statement, e);
        }
    }

    public void closeConnection(boolean force) {
        this.close(null, null, this.connection, force);
    }
}

