/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.sql.Database;

public class SQL {
    private static SQL data;
    private static boolean initialized;
    private Map<String, List<Object>> databaseData = new HashMap<String, List<Object>>();

    public SQL() {
        initialized = false;
        Database.kill();
        Database.getDatabase();
        this.createTables();
        initialized = true;
        ServerUtils.logDebug("{SQL} Database Connected.");
    }

    @Nonnull
    public static SQL getSQL() {
        if (data == null) {
            data = new SQL();
        }
        return data;
    }

    public void load() {
        this.loadData();
    }

    public void purgeDatabase() {
        SchedulerUtils.runSingleAsync(() -> {
            Iterator<String> iterator = Core.getCore().getData().getDatabaseData().keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.databaseData.clear();
                    return;
                }
                String table = iterator.next();
                String string = "CC_SQL";
                // MONITORENTER : "CC_SQL"
                if (Database.getDatabase().tableExists(Core.getCore().getData().getTablePrefix() + table)) {
                    Database.getDatabase().executeStatement("DROP TABLE IF EXISTS " + Core.getCore().getData().getTablePrefix() + table);
                }
                // MONITOREXIT : string
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveData(@Nonnull Object object) {
        try {
            List<Object> h1;
            String tableName = (String)object.getClass().getMethod("getTableName", new Class[0]).invoke(object, new Object[0]);
            String tableHeaders = (String)object.getClass().getMethod("getTableHeaders", new Class[0]).invoke(object, new Object[0]);
            String tableInserts = (String)object.getClass().getMethod("getInsertValues", new Class[0]).invoke(object, new Object[0]);
            if (Core.getCore().getPlugin().isEnabled()) {
                SchedulerUtils.runSingleAsync(() -> {
                    String string = "CC_SQL";
                    synchronized ("CC_SQL") {
                        Database.getDatabase().executeStatement("INSERT INTO " + Core.getCore().getData().getTablePrefix() + tableName + " (" + tableHeaders + ") VALUES (" + tableInserts + ")");
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                });
            } else {
                String string = "CC_SQL";
                // MONITORENTER : "CC_SQL"
                Database.getDatabase().executeStatement("INSERT INTO " + Core.getCore().getData().getTablePrefix() + tableName + " (" + tableHeaders + ") VALUES (" + tableInserts + ")");
                // MONITOREXIT : string
            }
            if (this.databaseData.get(tableName) != null) {
                h1 = this.databaseData.get(tableName);
                h1.add(object);
                this.databaseData.put(tableName, h1);
                return;
            }
            h1 = new ArrayList<Object>();
            h1.add(object);
            this.databaseData.put(tableName, h1);
            return;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeData(@Nonnull Object object, boolean ... ignoreValues) {
        try {
            String tableName = (String)object.getClass().getMethod("getTableName", new Class[0]).invoke(object, new Object[0]);
            if (this.databaseData.get(tableName) == null) return;
            if (this.databaseData.get(tableName).isEmpty()) return;
            Iterator<Object> dataSet = this.databaseData.get(tableName).iterator();
            while (dataSet.hasNext()) {
                boolean requireData;
                Object dataObject = dataSet.next();
                String dataSetName = (String)dataObject.getClass().getMethod("getTableName", new Class[0]).invoke(dataObject, new Object[0]);
                String tableRemoval = (String)dataObject.getClass().getMethod("getTableRemoval", new Class[0]).invoke(dataObject, new Object[0]);
                String tableRemovals = (String)dataObject.getClass().getMethod("getRemovalValues", new Class[0]).invoke(dataObject, new Object[0]);
                if (!tableName.equals(dataSetName)) continue;
                Boolean equalsDate = (Boolean)object.getClass().getMethod("equalsData", Object.class, Object.class).invoke(object, object, dataObject);
                boolean bl = requireData = ignoreValues == null || ignoreValues.length == 0 || !ignoreValues[0];
                if (!equalsDate.booleanValue() && requireData) continue;
                if (Core.getCore().getPlugin().isEnabled()) {
                    SchedulerUtils.runSingleAsync(() -> {
                        String string = "CC_SQL";
                        synchronized ("CC_SQL") {
                            Database.getDatabase().executeStatement("DELETE FROM " + Core.getCore().getData().getTablePrefix() + dataSetName + (requireData ? " WHERE (" + tableRemoval + ") = (" + tableRemovals + ")" : ""));
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return;
                        }
                    });
                } else {
                    String string = "CC_SQL";
                    // MONITORENTER : "CC_SQL"
                    Database.getDatabase().executeStatement("DELETE FROM " + Core.getCore().getData().getTablePrefix() + dataSetName + (requireData ? " WHERE (" + tableRemoval + ") = (" + tableRemovals + ")" : ""));
                    // MONITOREXIT : string
                }
                dataSet.remove();
            }
            return;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    @Nullable
    public Object getData(@Nonnull Object object) {
        try {
            String tableName = (String)object.getClass().getMethod("getTableName", new Class[0]).invoke(object, new Object[0]);
            if (this.databaseData.get(tableName) != null && !this.databaseData.get(tableName).isEmpty()) {
                for (Object dataObject : this.databaseData.get(tableName)) {
                    String dataSetName = (String)dataObject.getClass().getMethod("getTableName", new Class[0]).invoke(dataObject, new Object[0]);
                    Boolean equalsData = (Boolean)object.getClass().getMethod("equalsData", Object.class, Object.class).invoke(object, object, dataObject);
                    if (!dataSetName.equals(tableName) || !equalsData.booleanValue()) continue;
                    return dataObject;
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
        return null;
    }

    @Nonnull
    public List<Object> getDataList(@Nonnull Object object) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        try {
            String tableName = (String)object.getClass().getMethod("getTableName", new Class[0]).invoke(object, new Object[0]);
            if (this.databaseData.get(tableName) != null && !this.databaseData.get(tableName).isEmpty()) {
                for (Object dataObject : this.databaseData.get(tableName)) {
                    Boolean isTemporary = (Boolean)object.getClass().getMethod("isTemporary", new Class[0]).invoke(object, new Object[0]);
                    String dataSetName = (String)dataObject.getClass().getMethod("getTableName", new Class[0]).invoke(dataObject, new Object[0]);
                    Boolean equalsDate = (Boolean)object.getClass().getMethod("equalsData", Object.class, Object.class).invoke(object, object, dataObject);
                    if (!dataSetName.equals(tableName) || !isTemporary.booleanValue() && !equalsDate.booleanValue()) continue;
                    dataList.add(dataObject);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
        return dataList;
    }

    public boolean hasDataSet(@Nonnull Object object) {
        try {
            String tableName = (String)object.getClass().getMethod("getTableName", new Class[0]).invoke(object, new Object[0]);
            for (Object dataObject : this.databaseData.get(tableName)) {
                String dataSetName = (String)dataObject.getClass().getMethod("getTableName", new Class[0]).invoke(dataObject, new Object[0]);
                Boolean equalsDate = (Boolean)object.getClass().getMethod("equalsData", Object.class, Object.class).invoke(object, object, dataObject);
                if (!dataSetName.equals(tableName) || !equalsDate.booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
        return false;
    }

    private void loadData() {
        this.databaseData = Core.getCore().getData().getDatabaseData();
    }

    public void createTables() {
        Core.getCore().getData().getCreateTables().run();
        Core.getCore().getData().getAlterTables().run();
    }

    public boolean refresh() {
        try {
            data = new SQL();
            return true;
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return false;
        }
    }

    public static boolean initialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

