/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.types;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.utils.api.LanguageAPI;

public class PlaceHolder {
    private final Map<Holder, String> keys = new HashMap<Holder, String>();

    public PlaceHolder() {
        this.with(Holder.PREFIX, LanguageAPI.getLang().getPrefix());
    }

    public PlaceHolder with(@Nonnull Holder holder, @Nonnull String key) {
        if (this.keys.containsKey((Object)holder) && this.keys.get((Object)holder) != null && !this.keys.get((Object)holder).trim().isEmpty()) {
            return this;
        }
        this.keys.put(holder, key);
        return this;
    }

    public Map<Holder, String> keys() {
        return this.keys;
    }

    @Nonnull
    public String setPlaceholders(@Nonnull String message) {
        HashMap<String, String> holderMap = new HashMap<String, String>();
        for (Holder holder : Holder.values()) {
            String value = this.keys().get((Object)holder);
            holderMap.put(holder.ph().toLowerCase(), value != null && !value.trim().isEmpty() ? value : "&lNULL");
        }
        Pattern pattern = Pattern.compile("%\\s*(\\w+?)\\s*%", 2);
        Matcher matcher = pattern.matcher(message);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String ph = holderMap.getOrDefault("%" + matcher.group(1).trim().toLowerCase() + "%", "%" + matcher.group(1) + "%");
            matcher.appendReplacement(result, Matcher.quoteReplacement(ph));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static enum Holder {
        PLAYERS("%players%"),
        PLAYER("%player%"),
        PLAYER_UUID("%player_uuid%"),
        PLAYER_KILLS("%player_kills%"),
        PLAYER_DEATHS("%player_deaths%"),
        PLAYER_FOOD("%player_food%"),
        PLAYER_HEALTH("%player_health%"),
        PLAYER_LEVEL("%player_level%"),
        PLAYER_LOCATION("%player_location%"),
        PLAYER_INTERACT("%player_interact%"),
        PLAYER_HIT("%player_hit%"),
        TARGET_PLAYER("%target_player%"),
        WORLD("%world%"),
        targetWorld("%target_world%"),
        MOB_KILLS("%mob_kills%"),
        FAIL_COUNT("%fail_count%"),
        AMOUNT("%amount%"),
        ITEM("%item%"),
        ITEM_TYPE("%item_type%"),
        ITEM_SLOT("%item_slot%"),
        ITEM_PERMISSION("%item_permission%"),
        BALANCE("%balance%"),
        COST("%cost%"),
        COMMAND("%command%"),
        PURGE_DATA("%purge_data%"),
        TIME_LEFT("%time_left%"),
        INPUT("%input%"),
        INPUT_EXAMPLE("%input_example%"),
        GAMEMODE("%gamemode%"),
        HOTBAR("%hotbar%"),
        STATE("%state%"),
        PREFIX("%prefix%");

        private final String name;

        private Holder(String name) {
            this.name = name;
        }

        @Nonnull
        public String ph() {
            return this.name;
        }
    }
}

