/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.listeners.Clicking;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemAnimation {
    private final ItemMap itemMap;
    private List<String> dynamicNames = null;
    private List<List<String>> dynamicLores = null;
    private List<String> dynamicMaterials = null;
    private List<String> dynamicOwners = null;
    private List<String> dynamicTextures = null;
    private List<String> dynamicPages = null;
    private boolean stopAnimations = false;
    private boolean menu = false;
    private List<List<String>> menuLores = null;

    public ItemAnimation(ItemMap item) {
        this.itemMap = item;
        if (item.getDynamicNames() != null && !item.getDynamicNames().isEmpty()) {
            this.dynamicNames = item.getDynamicNames();
        }
        if (item.getDynamicLores() != null && !item.getDynamicLores().isEmpty()) {
            this.dynamicLores = item.getDynamicLores();
        }
        if (item.getDynamicMaterials() != null && !item.getDynamicMaterials().isEmpty()) {
            this.dynamicMaterials = item.getDynamicMaterials();
        }
        if (this.itemMap.getMaterial().toString().equalsIgnoreCase("WRITTEN_BOOK") && item.getPages() != null && !item.getPages().isEmpty()) {
            this.dynamicPages = item.getPages();
        }
        if (item.getDynamicOwners() != null && !item.getDynamicOwners().isEmpty()) {
            this.dynamicOwners = item.getDynamicOwners();
        } else if (item.getDynamicTextures() != null && !item.getDynamicTextures().isEmpty()) {
            this.dynamicTextures = item.getDynamicTextures();
        }
    }

    public void openAnimation(Player player) {
        SchedulerUtils.runAsync(() -> {
            if (!this.stopAnimations && player.isOnline() && !player.isDead()) {
                if (this.dynamicNames != null) {
                    this.nameTasks(player);
                }
                if (this.dynamicLores != null) {
                    this.loreTasks(player);
                }
                if (this.dynamicMaterials != null) {
                    this.materialTasks(player);
                }
                if (this.dynamicPages != null) {
                    this.pagesTasks(player);
                }
                if (this.dynamicOwners != null) {
                    this.ownerTasks(player);
                } else if (this.dynamicTextures != null) {
                    this.textureTasks(player);
                }
            }
        });
    }

    public void closeAnimation(Player player) {
        this.stopAnimations = true;
        ServerUtils.logDebug("{Animation} Successfully closed all animations for the item " + this.itemMap.getConfigName() + " with the instanced player " + player.getName() + ".");
    }

    private void nameTasks(Player player) {
        long ticks = 0L;
        Iterator<String> it = this.dynamicNames.iterator();
        while (it.hasNext()) {
            Integer delay;
            String name;
            this.AnimateTask(player, it.hasNext(), name, null, null, null, null, null, ticks += (long)((delay = StringUtils.returnInteger(ItemHandler.getDelayFormat(name = it.next()))) != null ? delay : 180), 0);
        }
    }

    private void loreTasks(Player player) {
        long ticks = 0L;
        int position = 0;
        Iterator<List<String>> it = this.dynamicLores.iterator();
        while (it.hasNext()) {
            Integer delay;
            List<String> lore;
            this.AnimateTask(player, it.hasNext(), null, lore, null, null, null, null, ticks += (long)((delay = StringUtils.returnInteger(ItemHandler.getDelayFormat((lore = it.next()).get(0)))) != null ? delay : 180), position);
            ++position;
        }
    }

    private void materialTasks(Player player) {
        long ticks = 0L;
        Iterator<String> it = this.dynamicMaterials.iterator();
        while (it.hasNext()) {
            Integer delay;
            String mat;
            this.AnimateTask(player, it.hasNext(), null, null, mat, null, null, null, ticks += (long)((delay = StringUtils.returnInteger(ItemHandler.getDelayFormat(mat = it.next()))) != null ? delay : 180), 0);
        }
    }

    private void pagesTasks(Player player) {
        long ticks = 0L;
        Integer delay = StringUtils.returnInteger(ItemHandler.getDelayFormat(this.dynamicPages.get(0)));
        this.AnimateTask(player, false, null, null, null, null, null, this.dynamicPages, ticks += (long)(delay != null ? delay : 180), 0);
    }

    private void ownerTasks(Player player) {
        long ticks = 0L;
        Iterator<String> it = this.dynamicOwners.iterator();
        while (it.hasNext()) {
            Integer delay;
            String owner;
            this.AnimateTask(player, it.hasNext(), null, null, null, owner, null, null, ticks += (long)((delay = StringUtils.returnInteger(ItemHandler.getDelayFormat(owner = it.next()))) != null ? delay : 180), 0);
        }
    }

    private void textureTasks(Player player) {
        long ticks = 0L;
        Iterator<String> it = this.dynamicTextures.iterator();
        while (it.hasNext()) {
            Integer delay;
            String texture = it.next();
            this.AnimateTask(player, it.hasNext(), null, null, null, null, texture, null, ticks += (long)((delay = StringUtils.returnInteger(ItemHandler.getDelayFormat(this.dynamicTextures.get(0)))) != null ? delay : 180), 0);
        }
    }

    private void AnimateTask(Player player, boolean hasNext, String nameString, List<String> loreString, String materialString, String ownerString, String textureString, List<String> pagesString, long UpdateDelay, int position) {
        ItemMap itemMap = this.itemMap;
        SchedulerUtils.runAsyncLater(UpdateDelay, () -> {
            if (this.stopAnimations) return;
            for (ItemStack inPlayerInventory : player.getInventory().getContents()) {
                boolean heldAnimations = ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.HeldItem-Animations");
                if (inPlayerInventory == null || itemMap.getTempItem() == null || !itemMap.isReal(inPlayerInventory) || !heldAnimations && itemMap.isReal(PlayerHandler.getHandItem(player))) continue;
                SchedulerUtils.run(() -> {
                    if (!this.stopAnimations && player.isOnline() && !player.isDead()) {
                        if (nameString != null) {
                            this.setNameData(player, inPlayerInventory, nameString);
                        } else if (loreString != null) {
                            this.setLoreData(player, inPlayerInventory, loreString);
                        } else if (materialString != null) {
                            this.setMaterialData(inPlayerInventory, materialString);
                        } else if (pagesString != null) {
                            this.setPagesData(player, inPlayerInventory, pagesString);
                        } else if (ownerString != null || textureString != null) {
                            this.setSkull(player, inPlayerInventory, ownerString, textureString);
                        }
                    }
                });
            }
            for (ItemStack inPlayerInventory : player.getInventory().getArmorContents()) {
                if (inPlayerInventory == null || itemMap.getTempItem() == null || !itemMap.isReal(inPlayerInventory)) continue;
                SchedulerUtils.run(() -> {
                    if (!this.stopAnimations && player.isOnline() && !player.isDead()) {
                        if (nameString != null) {
                            this.setNameData(player, inPlayerInventory, nameString);
                        } else if (loreString != null) {
                            this.setLoreData(player, inPlayerInventory, loreString);
                        } else if (materialString != null) {
                            this.setMaterialData(inPlayerInventory, materialString);
                        } else if (pagesString != null) {
                            this.setPagesData(player, inPlayerInventory, pagesString);
                        } else if (ownerString != null || textureString != null) {
                            this.setSkull(player, inPlayerInventory, ownerString, textureString);
                        }
                    }
                });
            }
            for (ItemStack inPlayerInventory : CompatUtils.getTopInventory(player).getContents()) {
                if (inPlayerInventory == null || itemMap.getTempItem() == null || !itemMap.isReal(inPlayerInventory)) continue;
                SchedulerUtils.run(() -> {
                    if (!this.stopAnimations && player.isOnline() && !player.isDead()) {
                        if (nameString != null) {
                            this.setNameData(player, inPlayerInventory, nameString);
                        } else if (loreString != null) {
                            if (this.menu) {
                                this.setLoreData(player, inPlayerInventory, this.menuLores.get(position));
                            } else {
                                this.setLoreData(player, inPlayerInventory, loreString);
                            }
                        } else if (materialString != null) {
                            this.setMaterialData(inPlayerInventory, materialString);
                        } else if (pagesString != null) {
                            this.setPagesData(player, inPlayerInventory, pagesString);
                        } else if (ownerString != null || textureString != null) {
                            this.setSkull(player, inPlayerInventory, ownerString, textureString);
                        }
                    }
                });
            }
            if (player.getItemOnCursor().getType() != Material.AIR && itemMap.getTempItem() != null && itemMap.isReal(player.getItemOnCursor())) {
                SchedulerUtils.run(() -> {
                    if (!this.stopAnimations && player.isOnline() && !player.isDead()) {
                        ItemStack item = new ItemStack(player.getItemOnCursor());
                        if (Clicking.getCursor(PlayerHandler.getPlayerID(player)) != null && itemMap.isReal(Clicking.getCursor(PlayerHandler.getPlayerID(player)))) {
                            item = new ItemStack(Clicking.getCursor(PlayerHandler.getPlayerID(player)));
                        }
                        if (nameString != null) {
                            this.setNameData(player, player.getItemOnCursor(), nameString);
                        } else if (loreString != null) {
                            this.setLoreData(player, player.getItemOnCursor(), loreString);
                        } else if (materialString != null) {
                            this.setMaterialData(player.getItemOnCursor(), materialString);
                        } else if (pagesString != null) {
                            this.setPagesData(player, player.getItemOnCursor(), pagesString);
                        } else if (ownerString != null || textureString != null) {
                            this.setSkull(player, player.getItemOnCursor(), ownerString, textureString);
                        }
                        Clicking.putCursor(PlayerHandler.getPlayerID(player), item);
                    }
                });
            }
            if (StringUtils.getSlotConversion(itemMap.getSlot()) != -1 && !ServerUtils.hasSpecificUpdate("1_13")) {
                LegacyAPI.updateInventory(player);
            } else {
                String string = "IJ_ANIMATE";
                // MONITORENTER : "IJ_ANIMATE"
                ItemStack updatedItem = itemMap.getItemStack(player);
                if (updatedItem != null) {
                    PlayerHandler.updateInventory(player, updatedItem.clone(), 1L);
                }
                // MONITOREXIT : string
            }
            if (hasNext) return;
            if (nameString != null) {
                this.nameTasks(player);
                return;
            }
            if (loreString != null) {
                this.loreTasks(player);
                return;
            }
            if (materialString != null) {
                this.materialTasks(player);
                return;
            }
            if (pagesString != null) {
                this.pagesTasks(player);
                return;
            }
            if (ownerString != null) {
                this.ownerTasks(player);
                return;
            }
            if (textureString == null) return;
            this.textureTasks(player);
        });
    }

    private void setNameData(Player player, ItemStack reviseItem, String nameString) {
        ItemMeta tempMeta = reviseItem.getItemMeta();
        if (tempMeta != null && reviseItem.getType() != Material.AIR) {
            String encodeData;
            tempMeta = tempMeta.clone();
            String itemData = "";
            if (this.itemMap.getLegacySecret() != null && !this.itemMap.getLegacySecret().isEmpty() && !(encodeData = Objects.requireNonNull(StringUtils.colorEncode(new ItemStack(Material.STICK), this.itemMap.getLegacySecret()).getItemMeta()).getDisplayName()).isEmpty()) {
                itemData = "\u00a7r" + encodeData;
            }
            tempMeta.setDisplayName(StringUtils.translateLayout(ItemHandler.cutDelay(nameString), player, new PlaceHolder[0]) + itemData);
            reviseItem.setItemMeta(tempMeta);
            if (this.itemMap.isDynamicCount()) {
                reviseItem.setAmount(this.itemMap.getCount(player).intValue());
            }
        }
    }

    private void setLoreData(Player player, ItemStack reviseItem, List<String> loreString) {
        ItemMeta tempMeta = reviseItem.getItemMeta();
        if (tempMeta != null && reviseItem.getType() != Material.AIR) {
            tempMeta = tempMeta.clone();
            ArrayList<String> loreFormatList = new ArrayList<String>();
            for (String s : loreString) {
                String formatLore = ItemHandler.cutDelay(s);
                formatLore = StringUtils.translateLayout(formatLore, player, new PlaceHolder[0]);
                loreFormatList.add(formatLore);
            }
            tempMeta.setLore(loreFormatList);
            reviseItem.setItemMeta(tempMeta);
        }
    }

    private void setMaterialData(ItemStack reviseItem, String material) {
        SchedulerUtils.runAsync(() -> {
            String materialString = ItemHandler.cutDelay(material);
            if (materialString.contains(":") && reviseItem != null && reviseItem.getType() != Material.AIR) {
                String[] parts = materialString.split(":");
                if (ServerUtils.hasSpecificUpdate("1_13")) {
                    Material mat;
                    if (!StringUtils.isInt(parts[0])) {
                        parts[0] = "LEGACY_" + parts[0];
                    }
                    if ((mat = !StringUtils.isInt(parts[0]) ? LegacyAPI.getMaterial(Material.getMaterial((String)parts[0].toUpperCase()), (byte)Integer.parseInt(parts[1])) : LegacyAPI.getMaterial(Integer.parseInt(parts[0]), (byte)Integer.parseInt(parts[1]))) != Material.AIR) {
                        Material type = mat;
                        SchedulerUtils.run(() -> reviseItem.setType(type));
                    }
                } else {
                    Material mat = ItemHandler.getMaterial(parts[0], null);
                    if (mat != Material.AIR) {
                        Material type = mat;
                        SchedulerUtils.run(() -> reviseItem.setType(type));
                    }
                    LegacyAPI.setDurability(reviseItem, (byte)Integer.parseInt(parts[1]));
                }
            } else {
                Material mat = ItemHandler.getMaterial(materialString, null);
                if (mat != Material.AIR) {
                    Material type = mat;
                    SchedulerUtils.run(() -> {
                        if (reviseItem != null) {
                            reviseItem.setType(type);
                        }
                    });
                }
            }
        });
    }

    private void setPagesData(Player player, ItemStack reviseItem, List<String> pagesString) {
        if (reviseItem != null && reviseItem.getType() != Material.AIR) {
            reviseItem.setItemMeta(this.itemMap.setJSONBookPages(player, reviseItem, pagesString).getItemMeta());
        }
    }

    private void setSkull(Player player, ItemStack reviseItem, String ownerString, String textureString) {
        ItemMeta tempMeta = reviseItem.getItemMeta();
        if (tempMeta != null && reviseItem.getType() != Material.AIR) {
            tempMeta = tempMeta.clone();
            if (ownerString != null) {
                ItemHandler.setSkullOwner(tempMeta, player, StringUtils.translateLayout(ItemHandler.cutDelay(ownerString), player, new PlaceHolder[0]));
            } else if (textureString != null && !textureString.contains("hdb-") && !this.itemMap.isHeadDatabase()) {
                ItemHandler.setSkullTexture(player, tempMeta, ItemHandler.cutDelay(StringUtils.toTextureUUID(player, this.itemMap.getConfigName(), textureString)));
            }
            reviseItem.setItemMeta(tempMeta);
        }
    }

    public void setMenu(boolean bool, int stage) {
        this.menu = bool;
        if (bool && this.dynamicLores != null) {
            this.menuLores = new ArrayList<List<String>>();
            for (List<String> lores : this.dynamicLores) {
                ArrayList<String> tempLores = new ArrayList<String>(lores);
                tempLores.add("&7");
                tempLores.add("&6---------------------------");
                if (stage == 1) {
                    tempLores.add("&7*Click to set as a swap-item.");
                } else {
                    tempLores.add("&7*Click to modify this custom item.");
                }
                tempLores.add("&9&lNode: &a" + this.itemMap.getConfigName());
                tempLores.add("&7");
                this.menuLores.add(tempLores);
            }
        }
    }
}

