/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import com.vk2gpz.tokenenchant.api.TokenEnchantAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;

public class ItemStatistics {
    private final Map<ItemMap, Map<String, Integer>> itemEnchants = new HashMap<ItemMap, Map<String, Integer>>();

    public ItemStatistics(Player player, List<ItemMap> items) {
        for (ItemMap itemMap : items) {
            this.setEnchantments(player, itemMap);
        }
    }

    private void setEnchantments(Player player, ItemMap itemMap) {
        String enchants;
        ConfigurationSection itemNode = itemMap.getNodeLocation();
        String string = enchants = itemNode.getString(".enchantments") != null ? itemNode.getString(".enchantments") : itemNode.getString(".enchantment");
        if (enchants != null) {
            String enchantList = enchants.replace(" ", "");
            String[] enchantments = enchantList.split(",");
            HashMap<String, Integer> listEnchants = new HashMap<String, Integer>();
            for (String enchantment : enchantments) {
                String[] parts = enchantment.split(":");
                String name = StringUtils.translateLayout(parts[0], player, new PlaceHolder[0]).toUpperCase();
                String levelPart = StringUtils.translateLayout(parts[1], player, new PlaceHolder[0]);
                Enchantment enchantName = ItemHandler.getEnchantByName(name);
                int level = 1;
                if (StringUtils.containsIgnoreCase(enchantment, ":")) {
                    try {
                        level = Integer.parseInt(levelPart);
                    }
                    catch (NumberFormatException e) {
                        ServerUtils.logSevere("{ItemStatistics} An error occurred in the config, " + levelPart + " is not a number and a number was expected!");
                        ServerUtils.logWarn("{ItemStatistics} Enchantment: " + name + " will now be enchanted by level 1.");
                        ServerUtils.sendDebugTrace(e);
                    }
                }
                if (level > 0 && enchantName != null) {
                    listEnchants.put(name, level);
                    continue;
                }
                if (level > 0 && ItemJoin.getCore().getDependencies().tokenEnchantEnabled() && TokenEnchantAPI.getInstance().getEnchantment(name) != null) {
                    listEnchants.put(name, level);
                    continue;
                }
                if (level <= 0 || ItemJoin.getCore().getDependencies().tokenEnchantEnabled()) continue;
                ServerUtils.logSevere("{ItemStatistics} An error occurred in the config, " + name + " is not a proper enchant name!");
                ServerUtils.logWarn("{ItemStatistics} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/enchantments/Enchantment.html for a list of correct enchantment names.");
            }
            this.itemEnchants.put(itemMap, listEnchants);
        }
    }

    public Map<String, Integer> getEnchantments(ItemMap itemMap) {
        return this.itemEnchants.get(itemMap);
    }
}

