/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.TimerUtils;
import me.RockinChaos.itemjoin.core.utils.keys.CompositeKey;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemCommand;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemStatistics;
import me.RockinChaos.itemjoin.utils.api.GuardAPI;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemUtilities {
    private static ItemUtilities utilities;
    private final HashMap<Integer, Integer> failCount = new HashMap();
    private final HashMap<String, ItemStatistics> itemStats = new HashMap();
    private List<ItemMap> items = new ArrayList<ItemMap>();
    private List<ItemMap> craftingItems = new ArrayList<ItemMap>();
    private List<ItemMap> recipeItems = new ArrayList<ItemMap>();
    private List<ItemMap> protectItems = new ArrayList<ItemMap>();
    private final HashMap<Player, List<String>> clearRegions = new HashMap();

    public static ItemUtilities getUtilities() {
        if (utilities == null) {
            utilities = new ItemUtilities();
        }
        return utilities;
    }

    public boolean isAllowed(Player player, ItemStack item, String itemflag) {
        if (player == null || item == null) {
            return true;
        }
        ItemMap itemMap = this.getItemMap(item);
        return itemMap == null || !itemMap.isAllowedItem(player, item, itemflag);
    }

    public ItemMap getItemMap(ItemStack itemStack) {
        for (ItemMap itemMap : this.getItems()) {
            if (!itemMap.isSimilar(null, itemStack)) continue;
            return itemMap;
        }
        return null;
    }

    public ItemMap getItemMap(String configName) {
        for (ItemMap itemMap : this.getItems()) {
            if (!itemMap.getConfigName().equalsIgnoreCase(configName)) continue;
            return itemMap;
        }
        return null;
    }

    public ItemMap getItemMap(String slot, List<ItemMap> items) {
        ArrayList<String> configMap = new ArrayList<String>();
        for (ItemMap item : items) {
            configMap.add(item.getConfigName());
        }
        configMap.sort(String::compareToIgnoreCase);
        ItemMap itemMap = null;
        boolean located = false;
        block1: for (String configName : configMap) {
            if (located) break;
            for (ItemMap item : items) {
                if (located) continue block1;
                if (!item.getConfigName().equalsIgnoreCase(configName) || !item.getUISlot().equalsIgnoreCase(slot)) continue;
                itemMap = item;
                located = true;
            }
        }
        return itemMap;
    }

    public void closeAnimations() {
        PlayerHandler.forOnlinePlayers(this::closeAnimations);
    }

    public void delToggleCommands() {
        for (ItemMap item : this.getItems()) {
            item.delToggleCommands();
        }
    }

    public void closeAnimations(Player player) {
        for (ItemMap item : this.getItems()) {
            if ((!item.isAnimated() || item.getAnimationHandler().get(player) == null) && (!item.isDynamic() || item.getAnimationHandler().get(player) == null)) continue;
            item.getAnimationHandler().get(player).closeAnimation(player);
            item.removeFromAnimationHandler(player);
        }
    }

    public void updateItems() {
        PlayerHandler.forOnlinePlayers(this::updateItems);
    }

    private void updateItems(Player player) {
        for (ItemMap item : this.getItems()) {
            item.updateItem(player, new boolean[0]);
            item.setAnimations(player);
        }
    }

    public void setAuthenticating(final Player player, final World world, final TriggerType type, final GameMode newMode, final String targetRegion, final List<String> regions) {
        if (ItemJoin.getCore().getDependencies().authMeEnabled()) {
            new BukkitRunnable(){

                public void run() {
                    try {
                        if (ItemJoin.getCore().getDependencies().isAuthenticated(player)) {
                            ItemUtilities.this.setItems(player, world, type, newMode, targetRegion, regions);
                            this.cancel();
                        } else if (!player.isOnline()) {
                            this.cancel();
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        ServerUtils.logSevere("{ItemMap} You are using an outdated version of AuthMe, custom items will not be given after login.");
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ItemJoin.getCore().getPlugin(), 0L, 20L);
        } else {
            this.setItems(player, world, type, newMode, targetRegion, regions);
        }
    }

    public void setItems(Player player, World world, TriggerType type, GameMode newMode, String targetRegion, List<String> regions) {
        this.setStatistics(player);
        this.safeSet(player, world, type, targetRegion, regions);
        if (this.getItemDelay() != 0L && type != TriggerType.LIMIT_SWITCH && type != TriggerType.REGION_ENTER && type != TriggerType.REGION_LEAVE) {
            SchedulerUtils.runLater(this.getItemDelay(), () -> {
                PluginData.getInfo().restoreCraftItems(player, type);
                this.handleItems(player, world, type, player.getGameMode(), targetRegion, regions);
            });
        } else {
            PluginData.getInfo().restoreCraftItems(player, type);
            this.handleItems(player, world, type, type == TriggerType.LIMIT_SWITCH ? newMode : player.getGameMode(), targetRegion, regions);
        }
    }

    private void handleItems(Player player, World world, TriggerType type, GameMode gameMode, String targetRegion, List<String> regions) {
        ItemMap probable = null;
        for (Object itemMap : ItemJoin.getCore().getChances().getItems().keySet()) {
            if (!((ItemMap)itemMap).hasItem(player, true)) continue;
            probable = (ItemMap)itemMap;
        }
        if (probable == null) {
            probable = (ItemMap)ItemJoin.getCore().getChances().getRandom(player);
        }
        int session = me.RockinChaos.itemjoin.core.utils.StringUtils.getRandom(1, 100000);
        boolean hasActioned = false;
        boolean removed = false;
        if (type.equals((Object)TriggerType.WORLD_SWITCH) || type.equals((Object)TriggerType.JOIN)) {
            world = player.getWorld();
        }
        ArrayList<String> multiSlots = new ArrayList<String>();
        for (ItemMap item : this.getItems()) {
            item.setAnimations(player);
            if ((type.equals((Object)TriggerType.JOIN) && item.isGiveOnJoin() && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.equals((Object)TriggerType.TELEPORT) && item.isGiveOnTeleport() && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.equals((Object)TriggerType.RESPAWN_POINT) && (item.isGiveOnRespawnPoint() || item.isGiveOnRespawn()) && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.equals((Object)TriggerType.RESPAWN_WILD) && (item.isGiveOnRespawnWild() || item.isGiveOnRespawn()) && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.equals((Object)TriggerType.WORLD_SWITCH) && item.isGiveOnWorldSwitch() && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.equals((Object)TriggerType.PERMISSION_SWITCH) && item.isGiveOnPermissionSwitch() && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue()) || type.name().startsWith("REGION") && (item.isGiveOnRegionEnter() || item.isGiveOnRegionAccess()) && item.inRegion(targetRegion).booleanValue() || type.name().startsWith("REGION") && (item.isGiveOnRegionLeave() || item.isGiveOnRegionEgress()) && item.inRegion(targetRegion).booleanValue() && !item.inRegion(regions).booleanValue() || type.equals((Object)TriggerType.LIMIT_SWITCH) && item.isUseOnLimitSwitch() && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(regions, "IJ_WORLD") || item.inRegion(regions).booleanValue())) && item.inWorld(world) && item.isLimitMode(gameMode) && (probable != null && item.getConfigName().equals(probable.getConfigName()) || item.getProbability() == -1) && item.conditionMet(player, "trigger-conditions", true, false) && PluginData.getInfo().isEnabled(player, item.getConfigName()) && item.hasPermission(player, world) && this.isObtainable(player, item, session, type, targetRegion, multiSlots)) {
                item.giveTo(player, new int[0]);
                hasActioned = true;
                if (item.getMultipleSlots().isEmpty() || multiSlots.contains(item.getConfigName())) continue;
                multiSlots.add(item.getConfigName());
                continue;
            }
            if ((type.equals((Object)TriggerType.LIMIT_SWITCH) && item.isUseOnLimitSwitch() && !item.isLimitMode(gameMode) || type.equals((Object)TriggerType.PERMISSION_SWITCH) && !item.hasPermission(player, world) || type.name().startsWith("REGION") && item.isGiveOnRegionAccess() && (item.inRegion(targetRegion) != false && item.inRegion(regions) == false || item.inRegion(targetRegion) == false && item.inRegion(regions) == false) || type.name().startsWith("REGION") && item.isGiveOnRegionEgress() && item.inRegion(targetRegion).booleanValue() && item.inRegion(regions).booleanValue()) && item.hasItem(player, false)) {
                item.removeFrom(player, new int[0]);
                hasActioned = true;
                removed = true;
                continue;
            }
            if (!item.isAutoRemove() || item.inWorld(world) && item.isLimitMode(gameMode) && (!type.equals((Object)TriggerType.REGION_ENTER) && !type.equals((Object)TriggerType.REGION_LEAVE) || (!item.isGiveOnRegionLeave() || !item.inRegion(targetRegion).booleanValue() || !item.inRegion(regions).booleanValue()) && (!item.isGiveOnRegionEnter() || !item.inRegion(targetRegion).booleanValue() || item.inRegion(regions).booleanValue())) || !item.hasItem(player, true)) continue;
            item.removeFrom(player, new int[0]);
            hasActioned = true;
            removed = true;
        }
        this.sendFailCount(player, session, type, targetRegion);
        if (hasActioned) {
            PlayerHandler.updateInventory(player, 15L);
        }
        if (removed) {
            TimerUtils.removeExpiry("wg_items", new CompositeKey(player.getUniqueId(), targetRegion), true);
            TimerUtils.removeExpiry("wg_failed", new CompositeKey(player.getUniqueId(), targetRegion), true);
        }
    }

    public void handleRegions(Player player, World world, TriggerType type, GameMode newMode) {
        String regions = ItemJoin.getCore().getDependencies().getGuard().getRegionAtLocation(player.getLocation());
        List<String> regionSetFull = Arrays.asList(regions.replace(" ", "").trim().split(","));
        if (regionSetFull.isEmpty() || regionSetFull.toString().replace("[", "").replace("]", "").isEmpty()) {
            this.setAuthenticating(player, world, type, newMode, "IJ_WORLD", Collections.singletonList("IJ_WORLD"));
        } else {
            for (String region : regionSetFull) {
                if (region == null || region.isEmpty()) continue;
                this.setAuthenticating(player, world, type, newMode, region, regionSetFull);
            }
        }
    }

    public void setStatistics(Player player) {
        this.itemStats.remove(PlayerHandler.getPlayerID(player));
        this.itemStats.put(PlayerHandler.getPlayerID(player), new ItemStatistics(player, this.getItems()));
    }

    private void safeSet(Player player, World world, TriggerType type, String targetRegion, List<String> regions) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.splitIgnoreCase(PluginData.getInfo().getHotbarTriggers(), type.name, ",")) {
            PlayerHandler.setHotbarSlot(player, PluginData.getInfo().getHotbarSlot());
        }
        if (type.equals((Object)TriggerType.REGION_ENTER) && (this.clearRegions.get(player) == null || !this.clearRegions.get(player).contains(targetRegion))) {
            ArrayList<String> regionList = this.clearRegions.get(player) != null ? this.clearRegions.get(player) : new ArrayList<String>();
            regionList.add(targetRegion);
            this.clearEvent(type, player, "", targetRegion);
            this.clearRegions.put(player, regionList);
        }
        if (type.equals((Object)TriggerType.QUIT)) {
            this.clearRegions.remove(player);
            this.clearEvent(type, player, world.getName(), "");
        }
        if (this.getClearDelay() != 0L) {
            SchedulerUtils.runLater(this.getClearDelay(), () -> {
                if (type.equals((Object)TriggerType.JOIN) || type.equals((Object)TriggerType.WORLD_SWITCH) || type.equals((Object)TriggerType.TELEPORT)) {
                    this.clearEvent(type, player, player.getWorld().getName(), "");
                }
                this.triggerCommands(player, type);
            });
        } else {
            if (type.equals((Object)TriggerType.JOIN) || type.equals((Object)TriggerType.WORLD_SWITCH) || type.equals((Object)TriggerType.TELEPORT) || type.equals((Object)TriggerType.QUIT)) {
                this.clearEvent(type, player, player.getWorld().getName(), "");
            }
            this.triggerCommands(player, type);
        }
        SchedulerUtils.runLater(this.getItemDelay(), () -> {
            if (type.equals((Object)TriggerType.REGION_LEAVE) && !regions.contains(targetRegion)) {
                ArrayList regionList = this.clearRegions.get(player) != null ? this.clearRegions.get(player) : new ArrayList();
                regionList.remove(targetRegion);
                GuardAPI.pasteReturnItems(player, targetRegion);
                this.clearRegions.put(player, regionList);
            }
            if (type.equals((Object)TriggerType.WORLD_SWITCH)) {
                this.pasteReturnItems(type, player, world.getName());
            }
        });
    }

    private void clearEvent(TriggerType type, Player player, String world, String region) {
        String clearEvent = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items." + type.name);
        if (player != null && clearEvent != null && (region != null && !region.isEmpty() && me.RockinChaos.itemjoin.core.utils.StringUtils.containsLocation(region, clearEvent.replace(" ", "")) || me.RockinChaos.itemjoin.core.utils.StringUtils.containsLocation(world, clearEvent.replace(" ", "")))) {
            boolean ignorable;
            boolean bl = ignorable = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options") != null && me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options"), "PROTECT_OP") && player.isOp() || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options"), "PROTECT_CREATIVE") && PlayerHandler.isCreativeMode(player);
            if (!ignorable) {
                String clearType = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Type");
                if (clearType != null && (clearType.equalsIgnoreCase("ALL") || clearType.equalsIgnoreCase("GLOBAL"))) {
                    this.clearItems(type, player, region, type.name, 0);
                } else if (clearType != null && clearType.equalsIgnoreCase("VANILLA")) {
                    this.clearItems(type, player, region, type.name, 1);
                } else if (clearType != null && clearType.equalsIgnoreCase("ITEMJOIN")) {
                    this.clearItems(type, player, region, type.name, 2);
                } else if (clearType != null) {
                    ServerUtils.logSevere("{ItemMap} " + clearType + " for Clear-Items in the config.yml is not a valid option.");
                }
            }
        }
    }

    private void clearItems(TriggerType type, Player player, String event, String region, int clearType) {
        this.protectItems = this.getProtectItems();
        PlayerInventory inventory = player.getInventory();
        Inventory topInventory = CompatUtils.getTopInventory(player);
        GuardAPI.saveReturnItems(player, event, region, topInventory, inventory, 0);
        this.saveReturnItems(type, player, player.getWorld().getName(), topInventory, inventory, 0);
        for (int i = 0; i < (!this.protectItems.isEmpty() ? this.protectItems.size() : 1); ++i) {
            if (this.canClear(inventory.getHelmet(), "Helmet", i, clearType)) {
                inventory.setHelmet(new ItemStack(Material.AIR));
            }
            if (this.canClear(inventory.getChestplate(), "Chestplate", i, clearType)) {
                inventory.setChestplate(new ItemStack(Material.AIR));
            }
            if (this.canClear(inventory.getLeggings(), "Leggings", i, clearType)) {
                inventory.setLeggings(new ItemStack(Material.AIR));
            }
            if (this.canClear(inventory.getBoots(), "Boots", i, clearType)) {
                inventory.setBoots(new ItemStack(Material.AIR));
            }
            if (this.canClear(player.getItemOnCursor(), "Cursor", i, clearType)) {
                player.setItemOnCursor(new ItemStack(Material.AIR));
            }
            if (ServerUtils.hasSpecificUpdate("1_9") && this.canClear(inventory.getItemInOffHand(), "OffHand", i, clearType)) {
                PlayerHandler.setOffHandItem(player, new ItemStack(Material.AIR));
            }
            if (PlayerHandler.isCraftingInv(player)) {
                for (int k = 0; k < topInventory.getSize(); ++k) {
                    if (!this.canClear(topInventory.getItem(k), "CRAFTING[" + k + "]", i, clearType)) continue;
                    topInventory.setItem(k, new ItemStack(Material.AIR));
                }
            }
            for (int f = 0; f < 36; ++f) {
                if (!this.canClear(inventory.getItem(f), Integer.toString(f), i, clearType)) continue;
                inventory.setItem(f, new ItemStack(Material.AIR));
            }
        }
    }

    public boolean canClear(ItemStack item, String slot, int i, int clearType) {
        return item != null && !this.isBlacklisted(slot, item) && !this.isProtected(i, item) && (clearType == 0 || clearType == 1 && !ItemHandler.containsNBTData(item, PluginData.getInfo().getNBTList()) || clearType == 2 && ItemHandler.containsNBTData(item, PluginData.getInfo().getNBTList()));
    }

    private boolean isBlacklisted(String slot, ItemStack item) {
        String[] blacklist = null;
        String list = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist");
        if (list != null && list.contains("{") && list.contains("}")) {
            blacklist = list.split(",");
        }
        try {
            if (blacklist != null) {
                ItemMeta itemMeta = item.getItemMeta();
                for (String value : blacklist) {
                    String valType = me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{id") ? "id" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{slot") ? "slot" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{name") ? "name" : ""));
                    String inputResult = StringUtils.substringBetween((String)value, (String)("{" + valType + ":"), (String)"}");
                    if (valType.equalsIgnoreCase("id") && item.getType() == ItemHandler.getMaterial(inputResult.trim(), null)) {
                        return true;
                    }
                    if (valType.equalsIgnoreCase("slot") && slot.trim().equalsIgnoreCase(inputResult.trim())) {
                        return true;
                    }
                    if (!valType.equalsIgnoreCase("name") || itemMeta == null || !itemMeta.hasDisplayName() || !ChatColor.stripColor((String)itemMeta.getDisplayName()).trim().equalsIgnoreCase(inputResult.trim())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemMap} It looks like the Blacklist section is missing quotations or apostrophes.");
            ServerUtils.logSevere("{ItemMap} Include quotations or apostrophes at the beginning and the end or this error will persist.");
            ServerUtils.logSevere("{ItemMap} The blacklist should look like '{id:DIAMOND}, {slot:0}' or \"{id:DIAMOND}, {slot:0}\".");
        }
        return false;
    }

    public boolean isObtainable(Player player, ItemMap itemMap, int session, TriggerType type, String region, List<String> multiSlots) {
        boolean canSend = this.canSend(player, type, region);
        if (!itemMap.hasItem(player, false) || itemMap.isAlwaysGive() || multiSlots.contains(itemMap.getConfigName())) {
            DataObject ipLimit;
            DataObject firstJoin = (itemMap.isOnlyFirstLife() || itemMap.isOnlyFirstWild()) && type.equals((Object)TriggerType.JOIN) || itemMap.isOnlyFirstJoin() ? (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_JOIN, PlayerHandler.getPlayerID(player), "", itemMap.getConfigName())) : null;
            DataObject firstWorld = itemMap.isOnlyFirstWorld() ? (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_WORLD, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName())) : null;
            DataObject dataObject = ipLimit = itemMap.isIpLimited() ? (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.IP_LIMITS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName(), Objects.requireNonNull(player.getAddress()).getHostString())) : null;
            if ((firstJoin == null || itemMap.isOnlyFirstLife() && (type.equals((Object)TriggerType.RESPAWN_POINT) || type.equals((Object)TriggerType.RESPAWN_WILD)) || itemMap.isOnlyFirstWild() && type.equals((Object)TriggerType.RESPAWN_WILD)) && firstWorld == null && (ipLimit == null || ipLimit.getPlayerId().equalsIgnoreCase(PlayerHandler.getPlayerID(player))) && this.canOverwrite(player, itemMap)) {
                return true;
            }
            if (firstJoin == null && firstWorld == null && ipLimit == null) {
                if (session != 0 && this.failCount.get(session) != null) {
                    this.failCount.put(session, this.failCount.get(session) + 1);
                } else if (session != 0) {
                    this.failCount.put(session, 1);
                }
                if (canSend) {
                    ServerUtils.logDebug("{ItemMap} " + player.getName() + " has failed to receive item: " + itemMap.getConfigName() + (!this.canOverwrite(player, itemMap) ? ", cannot overwrite items!" : "."));
                }
                return false;
            }
            if (firstJoin != null) {
                if (canSend) {
                    ServerUtils.logDebug("{ItemMap} " + player.getName() + " has already received first-join " + itemMap.getConfigName() + ", they can no longer receive this.");
                }
                return false;
            }
            if (firstWorld != null) {
                if (canSend) {
                    ServerUtils.logDebug("{ItemMap} " + player.getName() + " has already received first-world " + itemMap.getConfigName() + ", they can no longer receive this in " + player.getWorld().getName() + ".");
                }
                return false;
            }
            if (!ipLimit.getPlayerId().equalsIgnoreCase(PlayerHandler.getPlayerID(player))) {
                if (canSend) {
                    ServerUtils.logDebug("{ItemMap} " + player.getName() + " has already received ip-limited " + itemMap.getConfigName() + ", they will only receive this on their dedicated ip.");
                }
                return false;
            }
        }
        if (canSend) {
            ServerUtils.logDebug("{ItemMap} " + player.getName() + " already has item: " + itemMap.getConfigName() + ".");
        }
        return false;
    }

    private boolean canSend(Player player, TriggerType type, String region) {
        if (TimerUtils.isExpired("wg_items", new CompositeKey(player.getUniqueId(), region))) {
            if (type == TriggerType.REGION_ENTER || type == TriggerType.REGION_LEAVE) {
                TimerUtils.setExpiry("wg_items", new CompositeKey(player.getUniqueId(), region), 20, TimeUnit.MINUTES);
            }
            return true;
        }
        return false;
    }

    public boolean canOverwrite(Player player, ItemMap itemMap) {
        try {
            if (itemMap.isCraftingItem() && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(itemMap.getSlot()) == 0 || this.isOverwritable(player, itemMap) || itemMap.isAlwaysGive() || itemMap.isDropFull() || (itemMap.isGiveNext() || itemMap.isMoveNext()) && player.getInventory().firstEmpty() != -1) {
                return true;
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return false;
    }

    private boolean isOverwritable(Player player, ItemMap itemMap) {
        try {
            String overWrite = ItemJoin.getCore().getConfig("items.yml").getString("items-Overwrite");
            if (itemMap.isOverwritable() || overWrite == null || me.RockinChaos.itemjoin.core.utils.StringUtils.containsLocation(player.getWorld().getName(), overWrite.replace(" ", "")) || ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Overwrite")) {
                return true;
            }
            if (CustomSlot.ARBITRARY.isSlot(itemMap.getSlot()) && player.getInventory().firstEmpty() == -1) {
                return false;
            }
            if (CustomSlot.HELMET.isSlot(itemMap.getSlot()) && player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getType() != Material.AIR) {
                return false;
            }
            if (CustomSlot.CHESTPLATE.isSlot(itemMap.getSlot()) && player.getInventory().getChestplate() != null && player.getInventory().getChestplate().getType() != Material.AIR) {
                return false;
            }
            if (CustomSlot.LEGGINGS.isSlot(itemMap.getSlot()) && player.getInventory().getLeggings() != null && player.getInventory().getLeggings().getType() != Material.AIR) {
                return false;
            }
            if (CustomSlot.BOOTS.isSlot(itemMap.getSlot()) && player.getInventory().getBoots() != null && player.getInventory().getBoots().getType() != Material.AIR) {
                return false;
            }
            if (ServerUtils.hasSpecificUpdate("1_9") && CustomSlot.OFFHAND.isSlot(itemMap.getSlot()) ? player.getInventory().getItemInOffHand().getType() != Material.AIR : me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(itemMap.getSlot()) && player.getInventory().getItem(Integer.parseInt(itemMap.getSlot())) != null && player.getInventory().getItem(Integer.parseInt(itemMap.getSlot())).getType() != Material.AIR) {
                return false;
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return true;
    }

    public void sendFailCount(Player player, int session, TriggerType type, String region) {
        SchedulerUtils.runAsync(() -> {
            if (this.failCount.get(session) != null && this.failCount.get(session) != 0) {
                String overWrite = ItemJoin.getCore().getConfig("items.yml").getString("items-Overwrite");
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.FAIL_COUNT, this.failCount.get(session).toString());
                if (TimerUtils.isExpired("wg_failed", new CompositeKey(player.getUniqueId(), region))) {
                    if (type == TriggerType.REGION_ENTER || type == TriggerType.REGION_LEAVE) {
                        TimerUtils.setExpiry("wg_failed", new CompositeKey(player.getUniqueId(), region), 20, TimeUnit.MINUTES);
                    }
                    if (overWrite != null && me.RockinChaos.itemjoin.core.utils.StringUtils.containsLocation(player.getWorld().getName(), overWrite.replace(" ", ""))) {
                        ItemJoin.getCore().getLang().sendLangMessage("general.failedInventory", (CommandSender)player, placeHolders);
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("general.failedOverwrite", (CommandSender)player, placeHolders);
                    }
                }
                this.failCount.remove(session);
            }
        });
    }

    public void saveReturnItems(TriggerType type, Player player, String world, Inventory craftView, PlayerInventory inventory, int clearType) {
        boolean doReturn = me.RockinChaos.itemjoin.core.utils.StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options"), "RETURN_SWITCH", ",");
        List<ItemMap> protectItems = this.getProtectItems();
        if (type == TriggerType.WORLD_SWITCH && doReturn) {
            Inventory saveInventory = Bukkit.createInventory(null, (int)54);
            for (int i = 0; i <= 47; ++i) {
                for (int k = 0; k < (!protectItems.isEmpty() ? protectItems.size() : 1); ++k) {
                    ItemStack item;
                    if (i <= 41 && inventory.getSize() >= i && this.canClear(inventory.getItem(i), String.valueOf(i), k, clearType)) {
                        item = inventory.getItem(i);
                        if (item == null || item.getType() == Material.AIR) continue;
                        saveInventory.setItem(i, item.clone());
                        continue;
                    }
                    if (i < 42 || !this.canClear(craftView.getItem(i - 42), "CRAFTING[" + (i - 42) + "]", k, clearType) || !PlayerHandler.isCraftingInv(player) || (item = craftView.getItem(i - 42)) == null || item.getType() == Material.AIR) continue;
                    saveInventory.setItem(i, item.clone());
                }
            }
            ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.RETURN_SWITCH_ITEMS, PlayerHandler.getPlayerID(player), world, ItemHandler.serializeInventory(saveInventory)));
        }
    }

    public void pasteReturnItems(TriggerType type, Player player, String world) {
        String clearOptions = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options");
        if (type == TriggerType.WORLD_SWITCH && clearOptions != null && !clearOptions.isEmpty() && me.RockinChaos.itemjoin.core.utils.StringUtils.splitIgnoreCase(clearOptions.replace(" ", ""), "RETURN_SWITCH", ",")) {
            DataObject dataObject = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.RETURN_SWITCH_ITEMS, PlayerHandler.getPlayerID(player), world, ""));
            Inventory inventory = dataObject != null ? ItemHandler.deserializeInventory(dataObject.getInventory64()) : null;
            for (int i = 47; i >= 0; --i) {
                ItemStack item;
                if (inventory != null && (item = inventory.getItem(i)) != null && item.getType() != Material.AIR) {
                    if (i <= 41) {
                        player.getInventory().setItem(i, item.clone());
                    } else if (PlayerHandler.isCraftingInv(player)) {
                        CompatUtils.getTopInventory(player).setItem(i - 42, item.clone());
                        PlayerHandler.updateInventory(player, 1L);
                    }
                }
                ItemJoin.getCore().getSQL().removeData(new DataObject(DataObject.Table.RETURN_SWITCH_ITEMS, PlayerHandler.getPlayerID(player), world, ""), new boolean[0]);
            }
        }
    }

    public void setInvSlots(Player player, ItemMap itemMap, int size) {
        boolean overWrite;
        boolean isGiven = false;
        ItemStack item = itemMap.getItem(player).clone();
        ItemStack existingItem = ItemHandler.getItem(player, itemMap.getSlot()).clone();
        this.shiftItem(player, itemMap);
        int nextSlot = this.nextItem(player, itemMap);
        boolean bl = overWrite = itemMap.isOverwritable() || ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Overwrite");
        if (size > 1) {
            item.setAmount(size);
        }
        if ((size > 1 || itemMap.isAlwaysGive()) && !overWrite && existingItem.getType() != Material.AIR) {
            isGiven = true;
            player.getInventory().addItem(new ItemStack[]{item});
        } else if (nextSlot != 0) {
            isGiven = true;
            player.getInventory().setItem(nextSlot, item);
        } else if (player.getInventory().firstEmpty() != -1 || overWrite) {
            if (itemMap.getSlot().contains("%")) {
                String slot = me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(itemMap.getSlot(), player, new PlaceHolder[0]);
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(slot)) {
                    isGiven = true;
                    player.getInventory().setItem(Integer.parseInt(slot), item);
                }
            } else {
                isGiven = true;
                player.getInventory().setItem(Integer.parseInt(itemMap.getSlot()), item);
            }
        } else if (itemMap.isDropFull()) {
            isGiven = true;
            player.getWorld().dropItem(player.getLocation(), item);
        }
        if (isGiven) {
            ServerUtils.logDebug("{ItemMap} " + player.getName() + " has been given the item " + itemMap.getConfigName() + " in the world [" + player.getWorld().getName() + "].");
            DataObject firstJoin = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_JOIN, PlayerHandler.getPlayerID(player), "", itemMap.getConfigName()));
            DataObject firstWorld = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_WORLD, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName()));
            DataObject ipLimit = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.IP_LIMITS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName(), Objects.requireNonNull(player.getAddress()).getHostString()));
            if ((itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstLife() || itemMap.isOnlyFirstWild()) && firstJoin == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.FIRST_JOIN, PlayerHandler.getPlayerID(player), "", itemMap.getConfigName()));
            }
            if (itemMap.isOnlyFirstWorld() && firstWorld == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.FIRST_WORLD, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName()));
            }
            if (itemMap.isIpLimited() && ipLimit == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.IP_LIMITS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName(), player.getAddress().getHostString()));
            }
        }
    }

    public void setCustomSlots(Player player, ItemMap itemMap, int size) {
        boolean overWrite;
        boolean isGiven = false;
        int craftSlot = me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(itemMap.getSlot());
        ItemStack existingItem = ItemHandler.getItem(player, itemMap.getSlot()).clone();
        ItemStack item = itemMap.getItem(player).clone();
        this.shiftItem(player, itemMap);
        int nextSlot = this.nextItem(player, itemMap);
        boolean bl = overWrite = itemMap.isOverwritable() || ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Overwrite");
        if (size > 1) {
            item.setAmount(size);
        }
        if ((size > 1 || itemMap.isAlwaysGive()) && !overWrite && existingItem.getType() != Material.AIR) {
            isGiven = true;
            player.getInventory().addItem(new ItemStack[]{item});
        } else if (nextSlot != 0) {
            isGiven = true;
            player.getInventory().setItem(nextSlot, item);
        } else if (CustomSlot.ARBITRARY.isSlot(itemMap.getSlot()) && player.getInventory().firstEmpty() != -1) {
            isGiven = true;
            if (itemMap.getMultipleSlots() != null && !itemMap.getMultipleSlots().isEmpty()) {
                player.getInventory().setItem(player.getInventory().firstEmpty(), item);
            } else {
                player.getInventory().addItem(new ItemStack[]{item});
            }
        } else if (CustomSlot.HELMET.isSlot(itemMap.getSlot()) && (existingItem.getType() == Material.AIR || overWrite)) {
            isGiven = true;
            Objects.requireNonNull(player.getEquipment()).setHelmet(item);
        } else if (CustomSlot.CHESTPLATE.isSlot(itemMap.getSlot()) && (existingItem.getType() == Material.AIR || overWrite)) {
            isGiven = true;
            Objects.requireNonNull(player.getEquipment()).setChestplate(item);
        } else if (CustomSlot.LEGGINGS.isSlot(itemMap.getSlot()) && (existingItem.getType() == Material.AIR || overWrite)) {
            isGiven = true;
            Objects.requireNonNull(player.getEquipment()).setLeggings(item);
        } else if (CustomSlot.BOOTS.isSlot(itemMap.getSlot()) && (existingItem.getType() == Material.AIR || overWrite)) {
            isGiven = true;
            Objects.requireNonNull(player.getEquipment()).setBoots(item);
        } else if (ServerUtils.hasSpecificUpdate("1_9") && CustomSlot.OFFHAND.isSlot(itemMap.getSlot()) && (existingItem.getType() == Material.AIR || overWrite)) {
            isGiven = true;
            PlayerHandler.setOffHandItem(player, item);
        } else if (craftSlot != -1 && (existingItem.getType() == Material.AIR || overWrite || craftSlot == 0)) {
            isGiven = true;
            SchedulerUtils.runLater(6L, () -> this.setCraftingSlots(player, item, craftSlot, 240));
        } else if (itemMap.isDropFull()) {
            isGiven = true;
            player.getWorld().dropItem(player.getLocation(), item);
        }
        if (isGiven) {
            ServerUtils.logDebug("{ItemMap} " + player.getName() + " has been given the item " + itemMap.getConfigName() + " in the world [" + player.getWorld().getName() + "].");
            DataObject firstJoin = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_JOIN, PlayerHandler.getPlayerID(player), "", itemMap.getConfigName()));
            DataObject firstWorld = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_WORLD, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName()));
            DataObject ipLimit = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.IP_LIMITS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName(), Objects.requireNonNull(player.getAddress()).getHostString()));
            if ((itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstLife() || itemMap.isOnlyFirstWild()) && firstJoin == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.FIRST_JOIN, PlayerHandler.getPlayerID(player), "", itemMap.getConfigName()));
            }
            if (itemMap.isOnlyFirstWorld() && firstWorld == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.FIRST_WORLD, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName()));
            }
            if (itemMap.isIpLimited() && ipLimit == null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.IP_LIMITS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), itemMap.getConfigName(), player.getAddress().getHostString()));
            }
        }
    }

    private void setCraftingSlots(Player player, ItemStack itemStack, int craftSlot, int attempts) {
        if (attempts != 0) {
            Inventory topInventory = CompatUtils.getTopInventory(player);
            if (craftSlot == 0) {
                SchedulerUtils.runLater(2L, () -> {
                    if (PlayerHandler.isCraftingInv(player)) {
                        topInventory.setItem(craftSlot, itemStack);
                        PlayerHandler.updateInventory(player, 1L);
                    } else {
                        SchedulerUtils.runLater(20L, () -> this.setCraftingSlots(player, itemStack, craftSlot, attempts - 1));
                    }
                });
            } else if (PlayerHandler.isCraftingInv(player)) {
                ItemStack item = topInventory.getItem(0);
                if (item != null && !item.getType().equals((Object)Material.AIR)) {
                    ItemHandler.returnCraftingItem(player, 0, item.clone(), 0L);
                }
                topInventory.setItem(craftSlot, itemStack);
            } else {
                SchedulerUtils.runLater(20L, () -> this.setCraftingSlots(player, itemStack, craftSlot, attempts - 1));
            }
        }
    }

    public void shiftItem(Player player, ItemMap itemMap) {
        ItemStack existingItem = ItemHandler.getItem(player, itemMap.getSlot());
        if (itemMap.isMoveNext() && !itemMap.isSimilar(player, existingItem) && player.getInventory().firstEmpty() != -1) {
            for (int i = 0; i <= 35; ++i) {
                ItemStack itemMain = player.getInventory().getItem(i);
                if (itemMain == null || itemMain.getType() == Material.AIR) {
                    player.getInventory().setItem(i, existingItem.clone());
                    existingItem.setAmount(0);
                    existingItem.setType(Material.AIR);
                    return;
                }
                if (i != 35) continue;
                for (int k = 0; k == 0; --k) {
                    ItemStack item = player.getInventory().getItem(k);
                    if (item != null && item.getType() != Material.AIR) continue;
                    player.getInventory().setItem(k, existingItem.clone());
                    existingItem.setAmount(0);
                    existingItem.setType(Material.AIR);
                    return;
                }
            }
        }
    }

    public int nextItem(Player player, ItemMap itemMap) {
        if (itemMap.isGiveNext() && player.getInventory().firstEmpty() != -1) {
            for (int i = 0; i <= 35; ++i) {
                ItemStack itemMain = player.getInventory().getItem(i);
                if (itemMain == null || itemMain.getType() == Material.AIR) {
                    return i;
                }
                if (i != 35) continue;
                for (int k = 0; k == 0; --k) {
                    ItemStack item = player.getInventory().getItem(k);
                    if (item != null && item.getType() != Material.AIR) continue;
                    return k;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCommands(Player player, TriggerType triggerRef) {
        String enableWorlds = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds");
        String triggers = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.triggers");
        if (enableWorlds != null && !enableWorlds.equalsIgnoreCase("DISABLED") && !enableWorlds.equalsIgnoreCase("FALSE") && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.JOIN.name) && triggerRef.equals((Object)TriggerType.JOIN) || (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.FIRST_JOIN.name) || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.FIRST_WORLD.name)) && triggerRef.equals((Object)TriggerType.JOIN) || (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.WORLD_SWITCH.name) || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.FIRST_WORLD.name)) && triggerRef.equals((Object)TriggerType.WORLD_SWITCH) || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.RESPAWN.name) && (triggerRef.equals((Object)TriggerType.RESPAWN) || triggerRef.equals((Object)TriggerType.RESPAWN_WILD) || triggerRef.equals((Object)TriggerType.RESPAWN_POINT)) || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.TELEPORT.name) && triggerRef.equals((Object)TriggerType.TELEPORT))) {
            String[] compareWorlds;
            String commandsWorlds = enableWorlds.replace(", ", ",");
            TriggerType trigger = triggerRef;
            if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.FIRST_JOIN.name) && trigger.equals((Object)TriggerType.JOIN)) {
                trigger = TriggerType.FIRST_JOIN;
            } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, TriggerType.FIRST_WORLD.name) && (trigger.equals((Object)TriggerType.JOIN) || trigger.equals((Object)TriggerType.WORLD_SWITCH))) {
                trigger = TriggerType.FIRST_WORLD;
            }
            for (String compareWorld : compareWorlds = commandsWorlds.split(",")) {
                if (!compareWorld.equalsIgnoreCase(player.getWorld().getName()) && !compareWorld.equalsIgnoreCase("ALL") && !compareWorld.equalsIgnoreCase("GLOBAL")) continue;
                ArrayList<String> commandArray = new ArrayList<String>(ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands"));
                List<String> commandList = this.getRandomMap(commandArray, player);
                for (String commands : commandList) {
                    HashMap<ItemCommand.Executor, String> commandMap = this.getCommandMap(commands);
                    for (ItemCommand.Executor executor : commandMap.keySet()) {
                        String formatCommand = me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(commandMap.get((Object)executor), player, new PlaceHolder[0]);
                        boolean isFirstJoin = trigger.equals((Object)TriggerType.FIRST_JOIN) || trigger.equals((Object)TriggerType.FIRST_WORLD) || executor.equals((Object)ItemCommand.Executor.FIRSTJOIN);
                        DataObject dataObject = isFirstJoin ? (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.FIRST_COMMANDS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), formatCommand)) : null;
                        if (dataObject != null) continue;
                        if (isFirstJoin) {
                            ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.FIRST_COMMANDS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), formatCommand));
                        }
                        if (executor.equals((Object)ItemCommand.Executor.DEFAULT) || executor.equals((Object)ItemCommand.Executor.CONSOLE) || executor.equals((Object)ItemCommand.Executor.FIRSTJOIN)) {
                            try {
                                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(formatCommand, "[close]")) {
                                    PlayerHandler.safeInventoryClose(player);
                                    continue;
                                }
                                PluginData.getInfo().setLoggable("/" + formatCommand);
                                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formatCommand);
                            }
                            catch (Exception e) {
                                ServerUtils.logSevere("{ItemUtilities} There was an error executing a command as console, if this continues report it to the developer.");
                                ServerUtils.sendDebugTrace(e);
                            }
                            continue;
                        }
                        if (executor.equals((Object)ItemCommand.Executor.OP)) {
                            try {
                                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(formatCommand, "[close]")) {
                                    PlayerHandler.safeInventoryClose(player);
                                    continue;
                                }
                                if (!player.isOp()) {
                                    try {
                                        player.setOp(true);
                                        PluginData.getInfo().setLoggable("/" + formatCommand);
                                        player.chat("/" + formatCommand);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        ServerUtils.sendDebugTrace(e);
                                        player.setOp(false);
                                        ServerUtils.logSevere("{ItemUtilities} An critical error has occurred while setting " + player.getName() + " status on the OP list, to maintain server security they have been removed as an OP.");
                                        continue;
                                    }
                                    finally {
                                        player.setOp(false);
                                        continue;
                                    }
                                }
                                try {
                                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(formatCommand, "[close]")) {
                                        PlayerHandler.safeInventoryClose(player);
                                        continue;
                                    }
                                    PluginData.getInfo().setLoggable("/" + formatCommand);
                                    player.chat("/" + formatCommand);
                                }
                                catch (Exception e) {
                                    ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command as a player, if this continues report it to the developer.");
                                    ServerUtils.sendDebugTrace(e);
                                }
                            }
                            catch (Exception e) {
                                ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command as an op, if this continues report it to the developer.");
                                ServerUtils.sendDebugTrace(e);
                            }
                            continue;
                        }
                        if (executor.equals((Object)ItemCommand.Executor.PLAYER)) {
                            try {
                                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(formatCommand, "[close]")) {
                                    PlayerHandler.safeInventoryClose(player);
                                    continue;
                                }
                                PluginData.getInfo().setLoggable("/" + formatCommand);
                                player.chat("/" + formatCommand);
                            }
                            catch (Exception e) {
                                ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command as a player, if this continues report it to the developer.");
                                ServerUtils.sendDebugTrace(e);
                            }
                            continue;
                        }
                        if (executor.equals((Object)ItemCommand.Executor.SERVERSWITCH)) {
                            try {
                                ItemJoin.getCore().getBungee().SwitchServers(player, formatCommand);
                            }
                            catch (Exception e) {
                                ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command to switch servers, if this continues report it to the developer.");
                                ServerUtils.sendDebugTrace(e);
                            }
                            continue;
                        }
                        if (executor.equals((Object)ItemCommand.Executor.BUNGEE)) {
                            try {
                                ItemJoin.getCore().getBungee().ExecuteCommand(player, formatCommand);
                            }
                            catch (Exception e) {
                                ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command to BungeeCord, if this continues report it to the developer.");
                                ServerUtils.sendDebugTrace(e);
                            }
                            continue;
                        }
                        if (!executor.equals((Object)ItemCommand.Executor.MESSAGE)) continue;
                        try {
                            String jsonMessage = PluginData.getInfo().getJSONMessage(formatCommand, "Active-Commands");
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "minecraft:tellraw " + player.getName() + " " + jsonMessage);
                        }
                        catch (Exception e) {
                            ServerUtils.logSevere("{ItemUtilities} There was an error executing an item's command to send a message, if this continues report it to the developer.");
                            ServerUtils.sendDebugTrace(e);
                        }
                    }
                }
                break;
            }
        }
    }

    private HashMap<ItemCommand.Executor, String> getCommandMap(String input) {
        input = input.trim();
        ItemCommand.Executor type = ItemCommand.Executor.DEFAULT;
        HashMap<ItemCommand.Executor, String> commandMap = new HashMap<ItemCommand.Executor, String>();
        if (input.startsWith("default:")) {
            input = input.substring(8);
        } else if (input.startsWith("console:")) {
            input = input.substring(8);
            type = ItemCommand.Executor.CONSOLE;
        } else if (input.startsWith("op:")) {
            input = input.substring(3);
            type = ItemCommand.Executor.OP;
        } else if (input.startsWith("player:")) {
            input = input.substring(7);
            type = ItemCommand.Executor.PLAYER;
        } else if (input.startsWith("server:")) {
            input = input.substring(7);
            type = ItemCommand.Executor.SERVERSWITCH;
        } else if (input.startsWith("bungee:")) {
            input = input.substring(7);
            type = ItemCommand.Executor.BUNGEE;
        } else if (input.startsWith("message:")) {
            input = input.substring(8);
            type = ItemCommand.Executor.MESSAGE;
        } else if (input.startsWith("first-join:")) {
            input = input.substring(11);
            type = ItemCommand.Executor.FIRSTJOIN;
        }
        input = input.trim();
        commandMap.put(type, input);
        return commandMap;
    }

    private List<String> getRandomMap(ArrayList<String> commands, Player player) {
        String dedicatedMap;
        String commandSequence = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.commands-sequence");
        if (commandSequence != null && commandSequence.replace(" ", "").equalsIgnoreCase("RANDOM_SINGLE") && !(dedicatedMap = (String)me.RockinChaos.itemjoin.core.utils.StringUtils.randomEntry(commands)).isEmpty() && player != null) {
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.add(dedicatedMap);
            return returnList;
        }
        return ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands");
    }

    private long getItemDelay() {
        if (this.getClearDelay() / 20L >= (long)(ItemJoin.getCore().getConfig("items.yml").getInt("items-Delay") / 2) && this.getClearDelay() != -1L) {
            return this.getClearDelay() + 1L;
        }
        return (long)ItemJoin.getCore().getConfig("items.yml").getInt("items-Delay") * 10L;
    }

    public long getClearDelay() {
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Join"), "DISABLED") && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Join"), "FALSE") || !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Quit"), "DISABLED") && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Quit"), "FALSE") || !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.World-Switch"), "DISABLED") && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.World-Switch"), "FALSE") || !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Region-Enter"), "DISABLED") && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Region-Enter"), "FALSE")) {
            return ItemJoin.getCore().getConfig("config.yml").getInt("Clear-Items.Delay-Tick");
        }
        return -1L;
    }

    public boolean isProtected(int i, ItemStack item) {
        return !this.protectItems.isEmpty() && this.protectItems.get(i).isSimilar(null, item) && i == this.protectItems.size() - 1;
    }

    public List<ItemMap> getProtectItems() {
        ArrayList<ItemMap> protectItems = new ArrayList<ItemMap>();
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options"), "PROTECT")) {
            for (ItemMap item : this.getItems()) {
                if (!item.isOnlyFirstJoin() && !item.isOnlyFirstLife() && !item.isOnlyFirstWild() && !item.isOnlyFirstWorld()) continue;
                protectItems.add(item);
            }
        }
        return protectItems;
    }

    public void clearRecipes() {
        if (!this.recipeItems.isEmpty()) {
            Iterator recipes = Bukkit.getServer().recipeIterator();
            ArrayList recipeList = new ArrayList();
            if (!ServerUtils.hasSpecificUpdate("1_16")) {
                Bukkit.getServer().recipeIterator().forEachRemaining(recipeList::add);
            }
            while (recipes.hasNext()) {
                Recipe nextRecipe = (Recipe)recipes.next();
                if (!(nextRecipe instanceof ShapedRecipe)) continue;
                ItemStack result = nextRecipe.getResult();
                for (ItemMap itemMap : this.recipeItems) {
                    if (!itemMap.isSimilar(null, result) && (!ServerUtils.hasSpecificUpdate("1_12") || !((ShapedRecipe)nextRecipe).getKey().getKey().contains(itemMap.getConfigName()))) continue;
                    if (recipeList.isEmpty()) {
                        Bukkit.getServer().removeRecipe(((ShapedRecipe)nextRecipe).getKey());
                        continue;
                    }
                    recipeList.remove(nextRecipe);
                }
            }
            if (!recipeList.isEmpty()) {
                Bukkit.getServer().clearRecipes();
                for (Recipe recipe : recipeList) {
                    try {
                        Bukkit.getServer().addRecipe(recipe);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    public List<ItemMap> copyItems() {
        ArrayList<ItemMap> itemsCopy = new ArrayList<ItemMap>();
        for (ItemMap itemMap : this.items) {
            itemsCopy.add(itemMap.clone());
        }
        return itemsCopy;
    }

    public void addItem(ItemMap itemMap) {
        this.items.add(itemMap);
    }

    public void addCraftingItem(ItemMap itemMap) {
        if (itemMap.isCraftingItem()) {
            this.craftingItems.add(itemMap);
        }
    }

    public void addRecipeItem(ItemMap itemMap) {
        if (itemMap.getIngredients() != null && !itemMap.getIngredients().isEmpty()) {
            this.recipeItems.add(itemMap);
        }
    }

    public List<ItemMap> getItems() {
        return this.items;
    }

    public int getArbitrary(ItemMap itemMap) {
        if (itemMap.getSlot().equalsIgnoreCase("ARBITRARY")) {
            int arbitraryCount = 0;
            for (ItemMap item : this.items) {
                if (!item.getSlot().equalsIgnoreCase("ARBITRARY") || !item.getConfigName().equals(itemMap.getConfigName())) continue;
                ++arbitraryCount;
            }
            return arbitraryCount;
        }
        return 0;
    }

    public List<ItemMap> getCraftingItems() {
        return this.craftingItems;
    }

    public void clearItems() {
        this.clearRecipes();
        this.items = new ArrayList<ItemMap>();
        this.craftingItems = new ArrayList<ItemMap>();
        this.recipeItems = new ArrayList<ItemMap>();
    }

    public ItemStatistics getStatistics(Player player) {
        if (player != null && !this.itemStats.containsKey(PlayerHandler.getPlayerID(player))) {
            this.itemStats.put(PlayerHandler.getPlayerID(player), new ItemStatistics(player, this.getItems()));
        }
        return player != null ? this.itemStats.get(PlayerHandler.getPlayerID(player)) : null;
    }

    public static enum TriggerType {
        FIRST_JOIN("First-Join"),
        FIRST_WORLD("First-World"),
        JOIN("Join"),
        QUIT("Quit"),
        RESPAWN("Respawn"),
        RESPAWN_WILD("Respawn-Wild"),
        RESPAWN_POINT("Respawn-Point"),
        TELEPORT("Teleport"),
        WORLD_SWITCH("World-Switch"),
        PERMISSION_SWITCH("Permission-Switch"),
        LIMIT_SWITCH("Limit-Modes"),
        REGION_ENTER("Region-Enter"),
        REGION_LEAVE("Region-Leave"),
        DEFAULT("DEFAULT");

        private final String name;

        private TriggerType(String name) {
            this.name = name;
        }
    }

    public static enum CustomSlot {
        HELMET("Helmet"),
        CHESTPLATE("Chestplate"),
        LEGGINGS("Leggings"),
        BOOTS("Boots"),
        OFFHAND("Offhand"),
        CRAFTING("Crafting"),
        ARBITRARY("Arbitrary");

        private final String name;

        private CustomSlot(String name) {
            this.name = name;
        }

        public boolean isSlot(String slot) {
            return this.name.equalsIgnoreCase(slot);
        }
    }
}

