/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.TimerUtils;
import me.RockinChaos.itemjoin.core.utils.keys.CompositeKey;
import me.RockinChaos.itemjoin.core.utils.keys.PrimaryKey;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Commands
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    private void onCreativeCraft(PrepareItemCraftEvent event) {
        Player player = CompatUtils.getPlayer(event.getView());
        if (PlayerHandler.isCreativeMode(player) && PlayerHandler.isCraftingInv(player)) {
            TimerUtils.setExpiry("cc_destroy", player.getUniqueId(), 20, new TimeUnit[0]);
        }
    }

    @EventHandler
    private void onInventory(InventoryClickEvent event) {
        String slot;
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR ? event.getCurrentItem().clone() : (event.getCursor() != null && event.getCursor().getType() != Material.AIR ? event.getCursor().clone() : event.getCurrentItem());
        String action = event.getAction().name();
        String string = slot = event.getSlotType().name().equalsIgnoreCase("CRAFTING") ? "CRAFTING[" + event.getSlot() + "]" : String.valueOf(event.getSlot());
        if (!PlayerHandler.isCreativeMode(player)) {
            this.runCommands(player, null, item, action, event.getClick().name(), slot);
        } else {
            SchedulerUtils.run(() -> {
                if (TimerUtils.isExpired("cc_destroy", player.getUniqueId())) {
                    this.runCommands(player, null, item, action, "CREATIVE", slot);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onDeath(PlayerDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        for (ItemStack item : event.getDrops()) {
            this.runCommands(event.getEntity(), null, item, "ON_DEATH", "DEAD", null);
        }
        if (killer != null) {
            for (ItemStack item : killer.getInventory()) {
                this.runCommands(event.getEntity(), null, item, "ON_KILL", "KILLER", null);
            }
            if (PlayerHandler.isCraftingInv(killer)) {
                for (ItemStack item : CompatUtils.getTopInventory(killer)) {
                    this.runCommands(event.getEntity(), null, item, "ON_KILL", "KILLER", null);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        this.runCommands(event.getPlayer(), null, item, "ON_DROP", "DROP", String.valueOf(event.getPlayer().getInventory().getHeldItemSlot()));
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        this.runCommands(event.getPlayer(), null, item, "ON_CONSUME", "CONSUME", String.valueOf(event.getPlayer().getInventory().getHeldItemSlot()));
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onFire(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            ItemStack bow = event.getBow() != null ? event.getBow().clone() : event.getBow();
            this.runCommands((Player)event.getEntity(), null, bow, "ON_FIRE", "FIRE", String.valueOf(((Player)event.getEntity()).getInventory().getHeldItemSlot()));
            if (ServerUtils.hasSpecificUpdate("1_16")) {
                ItemStack arrow = event.getConsumable() != null ? event.getConsumable().clone() : event.getConsumable();
                this.runCommands((Player)event.getEntity(), null, arrow, "ON_FIRE", "FIRE", null);
            }
        }
    }

    @EventHandler
    private void onHold(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getNewSlot());
        String slot = String.valueOf(event.getNewSlot());
        this.runCommands(player, null, item, "ON_HOLD", "HELD", slot);
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        if (ItemJoin.getCore().getDependencies().authMeEnabled()) {
            new BukkitRunnable(){

                public void run() {
                    try {
                        if (ItemJoin.getCore().getDependencies().isAuthenticated(player)) {
                            Commands.this.handleJoin(player);
                            this.cancel();
                        } else if (!player.isOnline()) {
                            this.cancel();
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        ServerUtils.logSevere("{Commands} You are using an outdated version of AuthMe, ON_JOIN commands will not be executed.");
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)ItemJoin.getCore().getPlugin(), 0L, 20L);
        } else {
            this.handleJoin(player);
        }
    }

    private void handleJoin(Player player) {
        ItemStack item;
        int i;
        for (i = 0; i < player.getInventory().getSize(); ++i) {
            item = player.getInventory().getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            this.runCommands(player, null, item, "ON_JOIN", "JOINED", String.valueOf(i));
        }
        if (PlayerHandler.isCraftingInv(player)) {
            for (i = 0; i < CompatUtils.getTopInventory(player).getSize(); ++i) {
                item = CompatUtils.getTopInventory(player).getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                this.runCommands(player, null, item, "ON_JOIN", "JOINED", String.valueOf(i));
            }
        }
    }

    @EventHandler
    private void onEquipClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory bottomInventory = CompatUtils.getBottomInventory(event);
        if (PlayerHandler.isCraftingInv(event.getView())) {
            ItemStack hotItem;
            if (StringUtils.containsIgnoreCase(event.getAction().name(), "HOTBAR") && bottomInventory.getSize() >= event.getHotbarButton() && event.getHotbarButton() >= 0 && !event.getClick().name().equalsIgnoreCase("MIDDLE") && event.getSlotType() == InventoryType.SlotType.ARMOR && (hotItem = bottomInventory.getItem(event.getHotbarButton())) != null && hotItem.getType() != Material.AIR) {
                this.equipCommands(player, hotItem, "ON_EQUIP", "EQUIPPED", String.valueOf(event.getSlot()));
            }
            if (!event.getClick().name().equalsIgnoreCase("MIDDLE") && event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR) {
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    this.equipCommands(player, event.getCurrentItem(), "UN_EQUIP", "UNEQUIPPED", String.valueOf(event.getSlot()));
                } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                    String[] itemType;
                    String[] stringArray = event.getCurrentItem().getType().name().equalsIgnoreCase("ELYTRA") ? "ELYTRA_CHESTPLATE".split("_") : (itemType = ItemHandler.isSkull(event.getCurrentItem().getType()) || StringUtils.splitIgnoreCase(event.getCurrentItem().getType().name(), "HEAD", "_") ? "SKULL_HELMET".split("_") : event.getCurrentItem().getType().name().split("_"));
                    if (itemType.length >= 2 && itemType[1] != null && !itemType[1].isEmpty() && StringUtils.isInt(StringUtils.getArmorSlot(itemType[1], true)) && player.getInventory().getItem(Integer.parseInt(StringUtils.getArmorSlot(itemType[1], true))) == null) {
                        this.equipCommands(player, event.getCurrentItem(), "ON_EQUIP", "SHIFT_EQUIPPED", String.valueOf(event.getSlot()));
                    }
                }
            }
            if (!event.getClick().name().equalsIgnoreCase("MIDDLE") && !event.getClick().name().contains("SHIFT") && event.getSlotType() == InventoryType.SlotType.ARMOR && event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
                this.equipCommands(player, event.getCursor(), "ON_EQUIP", "EQUIPPED", String.valueOf(event.getSlot()));
            }
        }
    }

    @EventHandler
    private void onEquipDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        Set slideSlots = event.getInventorySlots();
        int slot = 0;
        Iterator iterator = slideSlots.iterator();
        if (iterator.hasNext()) {
            int actualSlot;
            slot = actualSlot = ((Integer)iterator.next()).intValue();
        }
        if (event.getOldCursor().getType() != Material.AIR && PlayerHandler.isCraftingInv(event.getView())) {
            this.equipCommands(player, event.getOldCursor(), "ON_EQUIP", "EQUIPPED", String.valueOf(slot));
        }
    }

    @EventHandler
    private void onEquip(PlayerInteractEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        Action action = event.getAction();
        ItemStack itemStack = item = event.getItem() != null ? event.getItem().clone() : event.getItem();
        if (item != null && item.getType() != Material.AIR && PlayerHandler.isCraftingInv(player) && !PlayerHandler.isMenuClick(player, event.getAction())) {
            String[] itemType;
            String[] stringArray = item.getType().name().equalsIgnoreCase("ELYTRA") ? "ELYTRA_CHESTPLATE".split("_") : (itemType = ItemHandler.isSkull(item.getType()) || StringUtils.splitIgnoreCase(item.getType().name(), "HEAD", "_") ? "SKULL_HELMET".split("_") : item.getType().name().split("_"));
            if (itemType.length >= 2 && itemType[1] != null && !itemType[1].isEmpty() && StringUtils.isInt(StringUtils.getArmorSlot(itemType[1], true)) && !itemType[0].equalsIgnoreCase("SKULL")) {
                ItemStack existingItem = player.getInventory().getItem(Integer.parseInt(StringUtils.getArmorSlot(itemType[1], true)));
                if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
                    this.equipCommands(player, item, "ON_EQUIP", "EQUIPPED", StringUtils.getArmorSlot(itemType[1], true));
                } else if ((action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) && existingItem != null && existingItem.getType() != Material.AIR) {
                    this.equipCommands(player, item, "UN_EQUIP", "UNEQUIPPED", StringUtils.getArmorSlot(itemType[1], true));
                }
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Player player;
        Object object = event.getEntity() instanceof Player ? (Player)event.getEntity() : (player = event.getDamager() instanceof Player ? (Player)event.getDamager() : null);
        if (player != null) {
            int i;
            for (i = 0; i < player.getInventory().getSize(); ++i) {
                this.handleOnDamage(player, event.getEntity() instanceof Player ? (Player)event.getEntity() : null, String.valueOf(i));
            }
            if (PlayerHandler.isCraftingInv(player)) {
                for (i = 0; i < CompatUtils.getTopInventory(player).getSize(); ++i) {
                    this.handleOnDamage(player, event.getEntity() instanceof Player ? (Player)event.getEntity() : null, "CR" + i);
                }
            }
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        Player player;
        Player player2 = player = event.getDamager() instanceof Player ? (Player)event.getDamager() : null;
        if (player != null) {
            ItemStack item = PlayerHandler.getHandItem(player);
            int slot = player.getInventory().getHeldItemSlot();
            if (item.getType() != Material.AIR && !PlayerHandler.isMenuClick(player, Action.LEFT_CLICK_AIR)) {
                this.runCommands(player, event.getEntity() instanceof Player ? (Player)event.getEntity() : null, item, "ON_HIT", "HIT", Integer.toString(slot));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Player player;
        Projectile projectile = event.getEntity();
        Player player2 = player = projectile.getShooter() instanceof Player ? (Player)projectile.getShooter() : null;
        if (player != null) {
            ItemStack item = PlayerHandler.getMainHandItem(player).clone();
            if (item.getAmount() == 0) {
                item.setAmount(1);
            }
            TimerUtils.setExpiry("pj_teleport", new PrimaryKey(projectile.getEntityId()).addMetaData("projectile", item.clone()), 2, TimeUnit.MINUTES);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Entity entity;
        Iterator iterator;
        Entity hitEntity;
        Player player = event.getEntity().getShooter() instanceof Player ? (Player)event.getEntity().getShooter() : null;
        Entity entity2 = hitEntity = ServerUtils.hasSpecificUpdate("1_12") ? event.getHitEntity() : null;
        if (!ServerUtils.hasSpecificUpdate("1_12") && (iterator = event.getEntity().getNearbyEntities(2.0, 2.0, 2.0).iterator()).hasNext() && (entity = (Entity)iterator.next()) instanceof Player) {
            hitEntity = entity;
        }
        Player altPlayer = hitEntity instanceof Player ? (Player)hitEntity : null;
        Object projectile = TimerUtils.getAlive("pj_teleport", new PrimaryKey(event.getEntity().getEntityId()));
        if (player != null && hitEntity != null && projectile != null) {
            int slot = player.getInventory().getHeldItemSlot();
            ItemStack item = (ItemStack)((PrimaryKey)projectile).getMetaData("projectile");
            if (item != null && item.getType() != Material.AIR && !PlayerHandler.isMenuClick(player, Action.LEFT_CLICK_AIR)) {
                this.runCommands(player, altPlayer, item, "ON_HIT", "HIT", Integer.toString(slot));
            }
        }
    }

    @EventHandler
    private void onEntity(PlayerInteractEntityEvent event) {
        try {
            if (event.getRightClicked() instanceof ItemFrame) {
                ItemStack item = ServerUtils.hasSpecificUpdate("1_9") ? PlayerHandler.getPerfectHandItem(event.getPlayer(), event.getHand().name()) : PlayerHandler.getPerfectHandItem(event.getPlayer(), "");
                Player player = event.getPlayer();
                String action = Action.RIGHT_CLICK_BLOCK.name();
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(PlayerHandler.getHandItem(player));
                if (itemMap != null && itemMap.isSimilar(player, item)) {
                    this.runCommands(player, null, item, action, action.split("_")[0], String.valueOf(player.getInventory().getHeldItemSlot()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    private void onTargetEntity(PlayerInteractAtEntityEvent event) {
        try {
            if (event.getRightClicked().toString().equalsIgnoreCase("CraftArmorStand")) {
                ItemStack item = ServerUtils.hasSpecificUpdate("1_9") ? PlayerHandler.getPerfectHandItem(event.getPlayer(), event.getHand().name()) : PlayerHandler.getPerfectHandItem(event.getPlayer(), "");
                Player player = event.getPlayer();
                String action = Action.RIGHT_CLICK_BLOCK.name();
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(PlayerHandler.getHandItem(player));
                if (itemMap != null && itemMap.isSimilar(player, item)) {
                    this.runCommands(player, null, item, action, action.split("_")[0], String.valueOf(player.getInventory().getHeldItemSlot()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onHandDrop(PlayerDropItemEvent event) {
        if (TimerUtils.isExpired("dd_drop", event.getPlayer().getUniqueId())) {
            TimerUtils.setExpiry("dd_drop", event.getPlayer().getUniqueId(), 900, TimeUnit.MILLISECONDS);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem() != null ? event.getItem().clone() : (event.getAction() == Action.PHYSICAL ? PlayerHandler.getMainHandItem(player) : event.getItem());
        String action = event.getAction().name();
        SchedulerUtils.runLater(ServerUtils.isFolia() ? 4L : 0L, () -> {
            if ((PlayerHandler.isAdventureMode(player) && !action.contains("LEFT") || !PlayerHandler.isAdventureMode(player)) && TimerUtils.isExpired("dd_drop", player.getUniqueId())) {
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(PlayerHandler.getHandItem(player));
                if (!PlayerHandler.isMenuClick(player, event.getAction()) && itemMap != null && itemMap.isSimilar(player, item) && TimerUtils.isExpired("dd_interact", new CompositeKey(player.getUniqueId(), item))) {
                    TimerUtils.setExpiry("dd_interact", new CompositeKey(player.getUniqueId(), item), 30, TimeUnit.MILLISECONDS);
                    String slot = ServerUtils.hasSpecificUpdate("1_9") && PlayerHandler.getOffHandItem(player).equals((Object)item) ? "OFFHAND" : String.valueOf(player.getInventory().getHeldItemSlot());
                    this.runCommands(player, null, item, action, action.equals(Action.PHYSICAL.name()) ? "INTERACTED" : action.split("_")[0], slot);
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onSwingArm(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        ItemStack item = PlayerHandler.getHandItem(player);
        SchedulerUtils.runLater(ServerUtils.isFolia() ? 4L : 0L, () -> {
            if (PlayerHandler.isAdventureMode(player) && TimerUtils.isExpired("dd_drop", player.getUniqueId()) && (!PlayerHandler.isMenuClick(player, Action.LEFT_CLICK_AIR) || PlayerHandler.isMenuClick(player, Action.LEFT_CLICK_BLOCK))) {
                this.runCommands(player, null, item, "LEFT_CLICK_AIR", "LEFT", String.valueOf(player.getInventory().getHeldItemSlot()));
            }
        });
    }

    public void handleOnDamage(Player player, Player altPlayer, String slot) {
        ItemStack item;
        ItemStack itemStack = item = slot.startsWith("CR") ? CompatUtils.getTopInventory(player).getItem(Integer.parseInt(slot.replace("CR", ""))) : player.getInventory().getItem(Integer.parseInt(slot));
        if (item != null && item.getType() != Material.AIR && !PlayerHandler.isMenuClick(player, Action.LEFT_CLICK_AIR)) {
            this.runCommands(player, altPlayer, item, "ON_DAMAGE", "DAMAGED", slot.replace("CR", ""));
        }
    }

    private void equipCommands(Player player, ItemStack item, String action, String clickType, String slot) {
        String[] itemType;
        String[] stringArray = item.getType().name().equalsIgnoreCase("ELYTRA") ? "ELYTRA_CHESTPLATE".split("_") : (itemType = ItemHandler.isSkull(item.getType()) || StringUtils.splitIgnoreCase(item.getType().name(), "HEAD", "_") ? "SKULL_HELMET".split("_") : item.getType().name().split("_"));
        if (itemType.length >= 2 && itemType[1] != null && !itemType[1].isEmpty() && (clickType.equalsIgnoreCase("SHIFT_EQUIPPED") || itemType[1].equalsIgnoreCase(StringUtils.getArmorSlot(slot, false)))) {
            if (!PlayerHandler.isCreativeMode(player)) {
                this.runCommands(player, null, item, action, clickType.equalsIgnoreCase("SHIFT_EQUIPPED") ? "EQUIPPED" : clickType, slot);
            } else {
                SchedulerUtils.run(() -> {
                    if (TimerUtils.isExpired("cc_destroy", player.getUniqueId())) {
                        this.runCommands(player, null, item, action, clickType.equalsIgnoreCase("SHIFT_EQUIPPED") ? "EQUIPPED" : clickType, slot);
                    }
                });
            }
        }
    }

    private void runCommands(Player player, Player altPlayer, ItemStack item, String action, String clickType, String slot) {
        ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(item);
        if (itemMap != null && itemMap.inWorld(player.getWorld()) && itemMap.hasPermission(player, player.getWorld())) {
            itemMap.executeCommands(player, altPlayer, item, action, clickType, slot == null ? itemMap.getSlot() : slot);
        }
    }
}

