/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerAutoCraftEvent;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Crafting
implements Listener {
    private final HashMap<String, Long> closeDupe = new HashMap();
    private final HashMap<String, Boolean> pendingZero = new HashMap();
    private final List<String> whiteList = Collections.singletonList("GraphicalQuests");

    @EventHandler(priority=EventPriority.LOW)
    private void onAutoCraft(PlayerAutoCraftEvent event) {
        ItemStack[] craftingContents = event.getContents();
        if (craftingContents == null) {
            return;
        }
        ServerUtils.logDebug("{CRAFTING} Protocol-Packet auto recipe was triggered for the player " + event.getPlayer().getName() + ".");
        for (ItemStack craftItem : craftingContents) {
            if (event.isCancelled()) {
                return;
            }
            for (ItemMap itemMap : ItemUtilities.getUtilities().getCraftingItems()) {
                if (!event.isCancelled() && !this.hasRecipePlugin() && itemMap.isReal(craftItem)) {
                    event.setCancelled(true);
                    continue;
                }
                if (!event.isCancelled()) continue;
                return;
            }
        }
    }

    private boolean hasRecipePlugin() {
        for (String plugin : this.whiteList) {
            if (!Bukkit.getServer().getPluginManager().isPluginEnabled(plugin) || StringUtils.containsIgnoreCase(ItemJoin.getCore().getDependencies().getIgnoreList(), plugin)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onCraftingOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        if (!PlayerHandler.getOpenCraftItems().containsKey(PlayerHandler.getPlayerID(player))) {
            ServerUtils.logDebug("{CRAFTING} Bukkit inventory was opened for the player " + event.getPlayer().getName() + ".");
            PlayerHandler.addOpenCraftItems(player, PlayerHandler.getTopContents(player));
            ItemHandler.removeCraftItems(player);
            SchedulerUtils.runLater(1L, () -> {
                if (PlayerHandler.isCraftingInv(player)) {
                    PlayerHandler.updateInventory(player);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onCraftingClose(InventoryCloseEvent event) {
        long dupeDuration;
        long l = dupeDuration = !this.closeDupe.isEmpty() && this.closeDupe.get(PlayerHandler.getPlayerID((Player)event.getPlayer())) != null ? System.currentTimeMillis() - this.closeDupe.get(PlayerHandler.getPlayerID((Player)event.getPlayer())) : -1L;
        if (!PlayerHandler.isCraftingInv(event.getView()) || PlayerHandler.isCraftingInv(event.getView()) && (dupeDuration == -1L || dupeDuration > 30L)) {
            Inventory topInventory = CompatUtils.getTopInventory(event.getView());
            ServerUtils.logDebug("{CRAFTING} Bukkit inventory was closed for the player " + event.getPlayer().getName() + ".");
            ItemStack[] topContents = ItemHandler.cloneContents(topInventory.getContents());
            this.handleClose(slot -> topInventory.setItem(slot.intValue(), new ItemStack(Material.AIR)), (Player)event.getPlayer(), event.getView(), topContents, true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onCraftingClose(me.RockinChaos.itemjoin.core.utils.protocol.events.InventoryCloseEvent event) {
        if (PlayerHandler.isCraftingInv(event.getView())) {
            ServerUtils.logDebug("{CRAFTING} Protocol-Packet inventory was closed for the player " + event.getPlayer().getName() + ".");
            this.closeDupe.put(PlayerHandler.getPlayerID(event.getPlayer()), System.currentTimeMillis());
            this.handleClose(slot -> {
                if (!event.isCancelled()) {
                    event.setCancelled(true);
                }
            }, event.getPlayer(), event.getView(), event.getPreviousContents(true), false);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onCraftingClick(InventoryClickEvent event) {
        block6: {
            ItemStack[] craftingContents;
            Player player;
            block7: {
                ItemMap itemMap;
                player = (Player)event.getWhoClicked();
                craftingContents = (ItemStack[])CompatUtils.getTopInventory(event.getView()).getContents().clone();
                if (!PlayerHandler.isCraftingInv(event.getView()) || event.getSlot() > 4) break block6;
                if (event.getSlot() == 0 || event.getSlotType() != InventoryType.SlotType.CRAFTING) break block7;
                if (craftingContents[0] == null || craftingContents[0].getType() == Material.AIR || (itemMap = ItemUtilities.getUtilities().getItemMap(craftingContents[0])) == null || !itemMap.isCraftingItem()) break block6;
                ItemHandler.returnCraftingItem(player, 0, craftingContents[0], 1L);
                break block6;
            }
            if (event.getSlot() != 0 || event.getSlotType() != InventoryType.SlotType.RESULT) break block6;
            if (craftingContents[0] != null && craftingContents[0].getType() != Material.AIR) {
                for (ItemMap itemMap : ItemUtilities.getUtilities().getCraftingItems()) {
                    if (itemMap.isMovement() || !itemMap.isSimilar(player, craftingContents[0])) continue;
                    for (int i = 1; i <= 4; ++i) {
                        ItemHandler.returnCraftingItem(player, i, craftingContents[i].clone(), 1L);
                    }
                    SchedulerUtils.runLater(1L, () -> CompatUtils.getTopInventory(player).setItem(0, new ItemStack(Material.AIR)));
                    break;
                }
            } else if (event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
                for (ItemMap itemMap : ItemUtilities.getUtilities().getCraftingItems()) {
                    if (itemMap.isMovement() || !itemMap.isSimilar(player, event.getCursor())) continue;
                    ItemStack cursor = event.getCursor().clone();
                    player.setItemOnCursor(new ItemStack(Material.AIR));
                    ItemHandler.returnCraftingItem(player, 0, cursor, 1L);
                    break;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onCraftingDrop(PlayerDropItemEvent event) {
        double health;
        Player player = event.getPlayer();
        World world = player.getWorld();
        ItemStack itemCopy = event.getItemDrop().getItemStack().clone();
        ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(itemCopy);
        try {
            health = player.getHealth();
        }
        catch (Exception e) {
            health = !player.isDead() ? 1 : 0;
        }
        if (health > 0.0 && itemMap != null && itemMap.isCraftingItem()) {
            event.getItemDrop().remove();
            SchedulerUtils.runLater(2L, () -> {
                if (!world.equals(player.getWorld()) && itemMap.inWorld(player.getWorld())) {
                    itemMap.giveTo(player, itemCopy.getAmount());
                    if (StringUtils.getSlotConversion(itemMap.getSlot()) != 0) {
                        this.returnSlotZero(player);
                    }
                } else if (world.equals(player.getWorld())) {
                    if (player.isOnline() && itemMap.isSelfDroppable()) {
                        itemMap.giveTo(player, itemCopy.getAmount());
                        if (StringUtils.getSlotConversion(itemMap.getSlot()) != 0) {
                            this.returnSlotZero(player);
                        }
                    } else if (player.isOnline()) {
                        PlayerHandler.dropItem(player, itemCopy);
                    }
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onCraftingWorldSwitch(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        ItemStack[] inventory = player.getInventory().getContents();
        if (ItemHandler.isContentsEmpty(inventory)) {
            for (int i = 0; i < inventory.length; ++i) {
                for (ItemMap itemMap : ItemUtilities.getUtilities().getCraftingItems()) {
                    if (!itemMap.isCraftingItem() || !itemMap.isReal(inventory[i])) continue;
                    player.getInventory().setItem(i, new ItemStack(Material.AIR));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    private void onSwitchGamemode(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (event.getNewGameMode() == GameMode.CREATIVE) {
            PlayerHandler.addCreativeCraftItems(player, PlayerHandler.getCraftItems().get(PlayerHandler.getPlayerID(player)));
            ItemHandler.removeCraftItems(player);
        } else if (event.getNewGameMode() != GameMode.CREATIVE && PlayerHandler.getCreativeCraftItems().containsKey(PlayerHandler.getPlayerID(player))) {
            this.returnCrafting(event.getPlayer(), PlayerHandler.getCreativeCraftItems().get(PlayerHandler.getPlayerID(player)), 1L, false);
            PlayerHandler.addCraftItems(player, PlayerHandler.getCreativeCraftItems().get(PlayerHandler.getPlayerID(player)));
            PlayerHandler.addCraftItems(player, PlayerHandler.getCreativeCraftItems().get(PlayerHandler.getPlayerID(player)));
            PlayerHandler.removeCreativeCraftItems(player);
        }
        SchedulerUtils.runLater(1L, () -> {
            if (PlayerHandler.isCraftingInv(player)) {
                PlayerHandler.updateInventory(player);
            }
        });
    }

    private void handleClose(Consumer<Integer> input, Player player, Object view, ItemStack[] inventory, boolean slotZero) {
        if (PlayerHandler.isCraftingInv(view)) {
            Inventory topInventory = CompatUtils.getTopInventory(player);
            if (ItemHandler.isContentsEmpty(inventory)) {
                int i;
                boolean isCrafting = false;
                for (i = 0; i <= 4; ++i) {
                    for (ItemMap itemMap : ItemUtilities.getUtilities().getCraftingItems()) {
                        if (!itemMap.isCraftingItem() || !itemMap.isReal(inventory[i])) continue;
                        isCrafting = true;
                        input.accept(i);
                    }
                }
                for (i = 0; i <= 4; ++i) {
                    ItemMap itemMap;
                    if (!isCrafting || i == 0 || inventory[i] == null || inventory[i].getType() == Material.AIR || (itemMap = ItemUtilities.getUtilities().getItemMap(inventory[i])) != null && itemMap.isCraftingItem() && itemMap.isReal(inventory[i])) continue;
                    int k = i;
                    ItemStack drop = inventory[i].clone();
                    SchedulerUtils.run(() -> {
                        double health;
                        try {
                            health = player.getHealth();
                        }
                        catch (Exception e) {
                            health = !player.isDead() ? 1 : 0;
                        }
                        if (health > 0.0) {
                            topInventory.setItem(k, new ItemStack(Material.AIR));
                            if (player.getInventory().firstEmpty() != -1) {
                                player.getInventory().addItem(new ItemStack[]{drop});
                                ServerUtils.logDebug("{CRAFTING} An item was flagged as non-crafting, adding it back to the player " + player.getName());
                            } else {
                                Item itemDropped = player.getWorld().dropItem(player.getLocation(), drop);
                                itemDropped.setPickupDelay(40);
                                ServerUtils.logDebug("{CRAFTING} An item was flagged as non-crafting and the player " + player.getName() + " has a full inventory, item will instead be self-dropped.");
                            }
                        }
                    });
                    inventory[i] = new ItemStack(Material.AIR);
                }
                if (isCrafting) {
                    if (!slotZero || ItemUtilities.getUtilities().getItemMap(inventory[0]) != null) {
                        this.returnCrafting(player, inventory, 1L, !slotZero);
                    } else {
                        SchedulerUtils.runLater(1L, () -> {
                            topInventory.setItem(0, new ItemStack(Material.AIR));
                            SchedulerUtils.runLater(1L, () -> {
                                if (PlayerHandler.isCraftingInv(player)) {
                                    PlayerHandler.updateInventory(player, new ItemStack(Material.AIR), 0L);
                                }
                            });
                        });
                    }
                }
            }
        } else {
            SchedulerUtils.run(() -> {
                ItemStack[] openCraftContents;
                double health;
                try {
                    health = player.getHealth();
                }
                catch (Exception e) {
                    health = !player.isDead() ? 1 : 0;
                }
                if (health > 0.0 && PlayerHandler.isCraftingInv(player) && PlayerHandler.getOpenCraftItems().containsKey(PlayerHandler.getPlayerID(player)) && (openCraftContents = PlayerHandler.getOpenCraftItems().get(PlayerHandler.getPlayerID(player))) != null && openCraftContents.length != 0) {
                    this.returnCrafting(player, openCraftContents, 1L, false);
                    PlayerHandler.addCraftItems(player, PlayerHandler.getOpenCraftItems().get(PlayerHandler.getPlayerID(player)));
                    PlayerHandler.removeOpenCraftItems(player);
                }
            });
        }
    }

    private void returnSlotZero(Player player) {
        if (this.pendingZero.get(PlayerHandler.getPlayerID(player)) != null && !this.pendingZero.get(PlayerHandler.getPlayerID(player)).booleanValue() || this.pendingZero.get(PlayerHandler.getPlayerID(player)) == null) {
            this.pendingZero.put(PlayerHandler.getPlayerID(player), true);
            SchedulerUtils.runLater(4L, () -> {
                for (ItemMap craftMap : ItemUtilities.getUtilities().getCraftingItems()) {
                    if (StringUtils.getSlotConversion(craftMap.getSlot()) != 0 || !craftMap.inWorld(player.getWorld()) || !craftMap.hasPermission(player, player.getWorld())) continue;
                    craftMap.giveTo(player, new int[0]);
                    this.pendingZero.remove(PlayerHandler.getPlayerID(player));
                }
            });
        }
    }

    private void returnCrafting(Player player, ItemStack[] contents, long delay, boolean slotZero) {
        SchedulerUtils.runLater(delay, () -> {
            if (!player.isOnline()) {
                return;
            }
            if (!PlayerHandler.isCraftingInv(player)) {
                this.returnCrafting(player, contents, 10L, slotZero);
                return;
            }
            Inventory topInventory = CompatUtils.getTopInventory(player);
            if (!slotZero && contents != null) {
                for (int i = 4; i >= 0; --i) {
                    ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(contents[i]);
                    if (contents[i] == null || itemMap == null) continue;
                    topInventory.setItem(i, contents[i]);
                    SchedulerUtils.runLater(1L, () -> {
                        if (PlayerHandler.isCraftingInv(player)) {
                            PlayerHandler.updateInventory(player, itemMap.getItemStack(player), 0L);
                        }
                    });
                }
            } else if (contents != null) {
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(contents[0]);
                if (contents[0] != null && itemMap != null) {
                    topInventory.setItem(0, contents[0]);
                    SchedulerUtils.runLater(1L, () -> {
                        if (PlayerHandler.isCraftingInv(player)) {
                            PlayerHandler.updateInventory(player, itemMap.getItemStack(player), 0L);
                        }
                    });
                }
            }
        });
    }
}

