/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Drops
implements Listener {
    private final Map<String, Boolean> isDropping = new HashMap<String, Boolean>();
    private final Map<String, Boolean> possibleDropping = new HashMap<String, Boolean>();

    @EventHandler(ignoreCancelled=true)
    private void onGlobalDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (PluginData.getInfo().isPreventString(player, "Self-Drops") && PluginData.getInfo().isPreventBypass(player)) {
            if (!player.isDead()) {
                if (PlayerHandler.isCreativeMode(player)) {
                    player.closeInventory();
                }
                event.setCancelled(true);
            } else if (player.isDead()) {
                event.getItemDrop().remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onGlobalClickDrop(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlotType() == InventoryType.SlotType.OUTSIDE && PluginData.getInfo().isPreventString(player, "Self-Drops") && PluginData.getInfo().isPreventBypass(player) && !player.isDead()) {
            if (PlayerHandler.isCreativeMode(player)) {
                player.closeInventory();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onGlobalDeathDrops(PlayerDeathEvent event) {
        Player player = event.getEntity();
        ItemUtilities.getUtilities().closeAnimations(player);
        if (PluginData.getInfo().isPreventString(player, "Death-Drops") && PluginData.getInfo().isPreventBypass(player) && !LegacyAPI.hasGameRule(player.getWorld(), "keepInventory")) {
            player.getInventory().clear();
            CompatUtils.getTopInventory(player).clear();
            event.getDrops().clear();
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        Player player = event.getPlayer();
        if (!(player.isDead() || ItemUtilities.getUtilities().isAllowed(player, item, "self-drops") && ItemUtilities.getUtilities().isAllowed(player, item, "erase-drops") || ItemUtilities.getUtilities().getItemMap(item).isCraftingItem())) {
            if (!this.possibleDropping.containsKey(PlayerHandler.getPlayerID(player)) && !ItemUtilities.getUtilities().isAllowed(player, item, "self-drops")) {
                event.setCancelled(true);
            } else if (!this.possibleDropping.containsKey(PlayerHandler.getPlayerID(player))) {
                event.getItemDrop().remove();
            }
            if (PlayerHandler.isCreativeMode(player) && this.possibleDropping.containsKey(PlayerHandler.getPlayerID(player)) && this.possibleDropping.get(PlayerHandler.getPlayerID(player)).booleanValue()) {
                player.closeInventory();
                event.getItemDrop().remove();
                this.isDropping.put(PlayerHandler.getPlayerID(player), true);
                this.possibleDropping.remove(PlayerHandler.getPlayerID(player));
                this.delayedSafety(player, 1);
            } else if (PlayerHandler.isCreativeMode(player)) {
                player.closeInventory();
            }
        } else if (!(!player.isDead() || ItemUtilities.getUtilities().isAllowed(player, item, "self-drops") && ItemUtilities.getUtilities().isAllowed(player, item, "erase-drops"))) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onClickDrop(InventoryClickEvent event) {
        ItemStack item = event.getCursor();
        Player player = (Player)event.getWhoClicked();
        if (!(event.getSlotType() != InventoryType.SlotType.OUTSIDE || player.isDead() || ItemUtilities.getUtilities().isAllowed(player, item, "self-drops") && ItemUtilities.getUtilities().isAllowed(player, item, "erase-drops"))) {
            if (!ItemUtilities.getUtilities().isAllowed(player, item, "self-drops")) {
                event.setCancelled(true);
            } else if (item != null) {
                item.setType(Material.AIR);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onCreativeDrop(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (PlayerHandler.isCreativeMode(player) && this.isDropping.containsKey(PlayerHandler.getPlayerID(player)) && this.isDropping.get(PlayerHandler.getPlayerID(player)).booleanValue() && (!ItemUtilities.getUtilities().isAllowed(player, event.getCurrentItem(), "self-drops") || !ItemUtilities.getUtilities().isAllowed(player, event.getCurrentItem(), "erase-drops"))) {
            if (!ItemUtilities.getUtilities().isAllowed(player, event.getCurrentItem(), "self-drops")) {
                event.setCancelled(true);
            }
            player.closeInventory();
            PlayerHandler.updateInventory(player, 1L);
            this.isDropping.remove(PlayerHandler.getPlayerID(player));
        }
        if (PlayerHandler.isCreativeMode(player) && event.getSlot() == -999 && !this.possibleDropping.containsKey(PlayerHandler.getPlayerID(player))) {
            this.possibleDropping.put(PlayerHandler.getPlayerID(player), true);
            this.delayedSafety(player, 2);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onDeathDrops(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Inventory topInventory = CompatUtils.getTopInventory(player);
        Inventory bottomInventory = CompatUtils.getBottomInventory(player);
        ItemStack helmetItem = player.getInventory().getHelmet();
        ItemStack chestItem = player.getInventory().getChestplate();
        ItemStack legsItem = player.getInventory().getLeggings();
        ItemStack bootsItem = player.getInventory().getBoots();
        ItemStack offHandItem = PlayerHandler.getOffHandItem(player);
        ItemUtilities.getUtilities().closeAnimations(player);
        if (!LegacyAPI.hasGameRule(player.getWorld(), "keepInventory")) {
            if (!CompatUtils.isInventoryEmpty(bottomInventory)) {
                for (int playerInventory = 0; playerInventory < bottomInventory.getSize(); ++playerInventory) {
                    this.handleKeepItem(player, bottomInventory.getItem(playerInventory), playerInventory, "bottom_inventory");
                }
            }
            this.handleKeepItem(player, helmetItem, -1, "helmet");
            this.handleKeepItem(player, chestItem, -1, "chest");
            this.handleKeepItem(player, legsItem, -1, "legs");
            this.handleKeepItem(player, bootsItem, -1, "boots");
            this.handleKeepItem(player, offHandItem, -1, "offhand");
            ArrayList drops = new ArrayList(event.getDrops());
            for (ItemStack stack : drops) {
                if (stack == null || ItemUtilities.getUtilities().isAllowed(player, stack, "death-drops") && ItemUtilities.getUtilities().isAllowed(player, stack, "erase-drops") && ItemUtilities.getUtilities().isAllowed(player, stack, "death-keep")) continue;
                player.getInventory().remove(stack);
                event.getDrops().remove(stack);
            }
            if (!CompatUtils.isInventoryEmpty(topInventory)) {
                int craftInventory = 0;
                while (craftInventory < topInventory.getSize()) {
                    ItemStack stack;
                    stack = topInventory.getItem(craftInventory);
                    if (!(stack == null || ItemUtilities.getUtilities().isAllowed(player, stack, "death-drops") && ItemUtilities.getUtilities().isAllowed(player, stack, "erase-drops") && ItemUtilities.getUtilities().isAllowed(player, stack, "death-keep"))) {
                        topInventory.remove(stack);
                    }
                    int setSlot = craftInventory++;
                    AtomicInteger cycleTask = new AtomicInteger();
                    cycleTask.set(SchedulerUtils.runAsyncAtInterval(20L, 40L, () -> {
                        if (player.isOnline() && !player.isDead() && PlayerHandler.isCraftingInv(player)) {
                            this.handleKeepItem(player, stack, setSlot, "top_inventory");
                            SchedulerUtils.cancelTask(cycleTask.get());
                        }
                    }));
                }
            }
        }
    }

    private void handleKeepItem(Player player, ItemStack item, int slot, String itemType) {
        if (item != null && !ItemUtilities.getUtilities().isAllowed(player, item, "death-keep")) {
            ItemStack keepItem = item.clone();
            SchedulerUtils.run(() -> {
                if (player.isOnline()) {
                    ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(keepItem);
                    switch (itemType) {
                        case "helmet": {
                            player.getInventory().setHelmet(keepItem);
                            break;
                        }
                        case "chest": {
                            player.getInventory().setChestplate(keepItem);
                            break;
                        }
                        case "legs": {
                            player.getInventory().setLeggings(keepItem);
                            break;
                        }
                        case "boots": {
                            player.getInventory().setBoots(keepItem);
                            break;
                        }
                        case "offhand": {
                            player.getInventory().setItemInOffHand(keepItem);
                            break;
                        }
                        case "bottom_inventory": {
                            CompatUtils.getBottomInventory(player).setItem(slot, keepItem);
                            break;
                        }
                        case "top_inventory": {
                            CompatUtils.getTopInventory(player).setItem(slot, keepItem);
                        }
                    }
                    itemMap.setAnimations(player);
                    ServerUtils.logDebug("{Drops} " + player.getName() + " has triggered the DEATH-KEEP itemflag for " + itemMap.getConfigName() + ".");
                }
            });
        }
    }

    private void delayedSafety(Player player, int integer) {
        SchedulerUtils.runLater(1L, () -> {
            switch (integer) {
                case 1: {
                    this.isDropping.remove(PlayerHandler.getPlayerID(player));
                    break;
                }
                case 2: {
                    this.possibleDropping.remove(PlayerHandler.getPlayerID(player));
                }
            }
        });
    }
}

