/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemRecipe;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Recipes
implements Listener {
    @EventHandler(ignoreCancelled=true)
    private void onPlayerCraft(PrepareItemCraftEvent event) {
        Player player = (Player)event.getInventory().getHolder();
        if (player != null) {
            Inventory topInventory = CompatUtils.getTopInventory(player);
            for (int i = 0; i < topInventory.getSize(); ++i) {
                ItemStack item = topInventory.getItem(i);
                if (item == null || item.getType() == Material.AIR || ItemUtilities.getUtilities().isAllowed(player, item, "item-craftable")) continue;
                ItemStack reAdd = item.clone();
                topInventory.setItem(i, null);
                player.getInventory().addItem(new ItemStack[]{reAdd});
                PlayerHandler.updateInventory(player, 1L);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onRepairAnvil(InventoryClickEvent event) {
        boolean isAnvil = event.getInventory().getType().toString().contains("ANVIL");
        boolean isGrindstone = event.getInventory().getType().toString().contains("GRINDSTONE");
        if (isAnvil || isGrindstone) {
            Player player = (Player)event.getWhoClicked();
            int rSlot = event.getSlot();
            ItemStack invItem = event.getInventory().getItem(1);
            if (rSlot == 2 && invItem != null && invItem.getType() != Material.AIR) {
                ItemStack item = event.getInventory().getItem(2);
                if ((isGrindstone || !StringUtils.containsIgnoreCase(invItem.getType().toString(), "PAPER") && !StringUtils.containsIgnoreCase(invItem.getType().toString(), "NAME_TAG")) && !ItemUtilities.getUtilities().isAllowed(player, item, "item-repairable") || !ItemUtilities.getUtilities().isAllowed(player, invItem, "item-repairable")) {
                    event.setCancelled(true);
                    PlayerHandler.updateExperienceLevels(player);
                    PlayerHandler.updateInventory(player, 1L);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPrepareRecipe(PrepareItemCraftEvent event) {
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() != Material.AIR) {
            Player player = CompatUtils.getPlayer(event.getView());
            ArrayList<ItemMap> mapList = new ArrayList<ItemMap>();
            ItemMap checkMap = ItemUtilities.getUtilities().getItemMap(event.getRecipe().getResult());
            if (checkMap == null || !checkMap.isRecipe()) {
                return;
            }
            mapList.add(checkMap);
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                if (itemMap == null || !itemMap.isRecipe()) continue;
                mapList.add(itemMap);
            }
            Inventory inventoryClone = Bukkit.createInventory(null, (int)9);
            int setSlot = 0;
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (setSlot >= 9) break;
                if (i <= 0 && checkMap.isSimilar(player, item)) continue;
                if (item != null) {
                    inventoryClone.setItem(setSlot, item);
                }
                ++setSlot;
            }
            if (!mapList.isEmpty()) {
                ItemMap itemMap;
                Iterator iterator = mapList.iterator();
                while (iterator.hasNext() && !this.handleRecipe(itemMap = (ItemMap)iterator.next(), event.getInventory(), inventoryClone, player, false, false, null)) {
                }
            } else {
                this.handleRecipe(checkMap, event.getInventory(), inventoryClone, player, false, false, null);
            }
        }
    }

    @EventHandler
    public void onCraftRecipe(CraftItemEvent event) {
        ItemMap checkMap = ItemUtilities.getUtilities().getItemMap(event.getRecipe().getResult());
        if (checkMap != null && checkMap.isRecipe()) {
            Inventory inventoryClone = Bukkit.createInventory(null, (int)18);
            int setSlot = 0;
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (setSlot >= 9) break;
                if (checkMap.isSimilar(CompatUtils.getPlayer(event.getView()), item)) continue;
                if (item != null) {
                    inventoryClone.setItem(setSlot, item.clone());
                }
                ++setSlot;
            }
            this.handleRecipe(checkMap, event.getInventory(), inventoryClone, CompatUtils.getPlayer(event.getView()), true, event.isShiftClick(), event);
        }
    }

    private boolean handleRecipe(ItemMap itemMap, CraftingInventory craftInventory, Inventory inventoryClone, Player player, boolean isCrafted, boolean isShiftClick, CraftItemEvent event) {
        if (!itemMap.hasPermission(player, player.getWorld())) {
            craftInventory.setResult(new ItemStack(Material.AIR));
        } else {
            ItemStack result = craftInventory.getResult() != null ? craftInventory.getResult().clone() : new ItemStack(Material.AIR);
            boolean isLegacy = !ServerUtils.hasSpecificUpdate("1_13");
            boolean success = false;
            for (List<Character> tempRecipe : itemMap.getRecipe()) {
                if (success) continue;
                boolean removed = false;
                int resultSize = 0;
                int ingredientSize = 0;
                int confirmations = 0;
                for (Character character : tempRecipe) {
                    if (character.charValue() == 'X') continue;
                    ++ingredientSize;
                }
                if (!isCrafted) {
                    confirmations = this.getConfirmations(itemMap, player, inventoryClone);
                } else {
                    boolean cycleShift = true;
                    while (this.getConfirmations(itemMap, player, inventoryClone) == ingredientSize && cycleShift) {
                        cycleShift = isShiftClick;
                        for (int i = 0; i < inventoryClone.getSize(); ++i) {
                            ItemStack item = inventoryClone.getItem(i);
                            if (item == null) continue;
                            for (Character ingredient : itemMap.getIngredients().keySet()) {
                                ItemRecipe itemRecipe = itemMap.getIngredients().get(ingredient);
                                ItemMap ingredMap = ItemUtilities.getUtilities().getItemMap(itemRecipe.getMap());
                                if ((ingredMap != null || !itemRecipe.getMaterial().equals((Object)item.getType()) || isLegacy && LegacyAPI.getDataValue(item) != itemRecipe.getData()) && (ingredMap == null || !ingredMap.isSimilar(player, item)) || item.getAmount() < itemRecipe.getCount()) continue;
                                int removal = item.getAmount() - itemRecipe.getCount();
                                if (removal <= 0) {
                                    craftInventory.setItem(i + 1, new ItemStack(Material.AIR));
                                    inventoryClone.setItem(i, new ItemStack(Material.AIR));
                                } else {
                                    ItemStack craftItem = craftInventory.getItem(i + 1);
                                    if (craftItem != null) {
                                        craftItem.setAmount(removal);
                                        item.setAmount(removal);
                                    }
                                }
                                removed = true;
                            }
                        }
                        ++resultSize;
                    }
                }
                if (!isCrafted && confirmations == ingredientSize) {
                    craftInventory.setResult(itemMap.getItem(player));
                    return true;
                }
                if (!isCrafted) {
                    craftInventory.setResult(new ItemStack(Material.AIR));
                    continue;
                }
                if (!removed) continue;
                if (resultSize > 0 && isShiftClick) {
                    result.setAmount(resultSize);
                }
                event.setCancelled(true);
                if (isShiftClick) {
                    success = true;
                    player.getInventory().addItem(new ItemStack[]{result});
                    continue;
                }
                if (CompatUtils.getCursor(player).getType() != Material.AIR && CompatUtils.getCursor(player).isSimilar(result)) {
                    success = true;
                    CompatUtils.getCursor(player).setAmount(CompatUtils.getCursor(player).getAmount() + result.getAmount());
                    continue;
                }
                success = true;
                CompatUtils.setCursor(player, result);
            }
        }
        return false;
    }

    private int getConfirmations(ItemMap itemMap, Player player, Inventory inventoryClone) {
        int confirmations = 0;
        for (int i = 0; i < inventoryClone.getSize(); ++i) {
            ItemStack item = inventoryClone.getItem(i);
            if (item == null) continue;
            for (Character ingredient : itemMap.getIngredients().keySet()) {
                ItemRecipe itemRecipe = itemMap.getIngredients().get(ingredient);
                ItemMap ingredMap = ItemUtilities.getUtilities().getItemMap(itemRecipe.getMap());
                if ((ingredMap != null || !itemRecipe.getMaterial().equals((Object)item.getType())) && (ingredMap == null || !ingredMap.isSimilar(player, item)) || item.getAmount() < itemRecipe.getCount()) continue;
                ++confirmations;
            }
        }
        return confirmations;
    }
}

