/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.utils.api;

import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

public class EffectAPI {
    public static void spawnParticle(Player player, String commandParticle) {
        if (StringUtils.containsIgnoreCase(commandParticle, "FIREWORK")) {
            EffectAPI.particleFirework(player, commandParticle);
        } else {
            try {
                String[] particleParts = commandParticle.split(":");
                int particleLife = 1;
                Particle particle = Particle.valueOf((String)particleParts[0]);
                if (particleParts[1] != null && !particleParts[1].isEmpty() && StringUtils.isInt(particleParts[1])) {
                    particleLife = Integer.parseInt(particleParts[1]);
                }
                player.getWorld().spawnParticle(particle, player.getLocation(), particleLife);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{EffectAPI} There was an issue executing the commands-particle you defined.");
                ServerUtils.logWarn("{EffectAPI} " + commandParticle + " is not a particle in " + ReflectionUtils.getServerVersion() + ".");
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private static void particleFirework(Player player, String commandParticle) {
        String[] projectileParts = commandParticle.split(":");
        Color startColor = Color.PURPLE;
        Color endColor = Color.GREEN;
        FireworkEffect.Type effectType = FireworkEffect.Type.STAR;
        int detonationDelay = 0;
        if (projectileParts[1] != null && !projectileParts[1].isEmpty()) {
            startColor = DyeColor.valueOf((String)projectileParts[1].toUpperCase()).getFireworkColor();
        }
        if (projectileParts[2] != null && !projectileParts[2].isEmpty()) {
            endColor = DyeColor.valueOf((String)projectileParts[2].toUpperCase()).getFireworkColor();
        }
        if (projectileParts[3] != null && !projectileParts[3].isEmpty()) {
            effectType = FireworkEffect.Type.valueOf((String)projectileParts[3]);
        }
        if (projectileParts[4] != null && !projectileParts[4].isEmpty() && StringUtils.isInt(projectileParts[4])) {
            detonationDelay = Integer.parseInt(projectileParts[4]);
        }
        FireworkEffect effect = FireworkEffect.builder().withColor(startColor).withFade(endColor).with(effectType).trail(true).flicker(true).build();
        Firework fw = !ServerUtils.hasPreciseUpdate("1_20_5") ? (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.valueOf((String)"FIREWORK")) : (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.FIREWORK_ROCKET);
        FireworkMeta meta = fw.getFireworkMeta();
        meta.addEffect(effect);
        meta.setPower(1);
        fw.setFireworkMeta(meta);
        SchedulerUtils.runLater((long)detonationDelay * 20L, () -> ((Firework)fw).detonate());
    }
}

