/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.utils.menus;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.interfaces.Interface;
import me.RockinChaos.itemjoin.core.utils.interfaces.Query;
import me.RockinChaos.itemjoin.core.utils.interfaces.types.Button;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemCommand;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemRecipe;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Menu {
    private static final ItemStack fillerPaneBItem = ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLACK_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:15", 1, false, false, "&7", "");
    private static final ItemStack fillerPaneGItem = ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRAY_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:7", 1, false, false, "&7", "");
    private static final ItemStack fillerPaneItem = ItemHandler.getItem("GLASS_PANE", 1, false, false, "&7", "");
    private static final ItemStack exitItem = ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nExit", "&7", "&7*Returns you to the game");
    private static final List<String> modifyMenu = new ArrayList<String>();
    private static final Button exitButton = new Button(exitItem, event -> Menu.startMenu((CommandSender)event.getWhoClicked()));
    private static final Map<String, Interface> typingMenu = new HashMap<String, Interface>();
    private static String GUIName = me.RockinChaos.itemjoin.core.utils.StringUtils.colorFormat("&7           &0&n ItemJoin Menu");
    private static int failCycle = 0;

    public static void startMenu(CommandSender sender) {
        Player player = (Player)sender;
        Interface pagedPane = new Interface(false, 1, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            pagedPane.addButton(new Button(exitItem, event -> player.closeInventory()));
            pagedPane.addButton(new Button(ItemHandler.getItem("ENDER_CHEST", 1, false, false, "&b&l&nConfig Settings", "&7", "&7*Change the GLOBAL plugin", "&7configuration settings."), event -> Menu.configSettings(player)));
            pagedPane.addButton(new Button(fillerPaneBItem));
            pagedPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&a&l&nCreate", "&7", "&7*Create a new item from scratch."), event -> Menu.materialPane(player, new ItemMap("item_" + PluginData.getInfo().getPath(1), "ARBITRARY"), 0, 0)));
            pagedPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&l&nSave", "&7", "&7*Save an existing item as a custom item."), event -> Menu.startHopper(player)));
            pagedPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&c&l&nModify", "&7", "&7*Modify an existing custom item"), event -> Menu.startModify(player, null, 0)));
            pagedPane.addButton(new Button(fillerPaneBItem));
            pagedPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&b&l&nItem Settings", "&7", "&7*Change the GLOBAL custom items", "&7configuration settings."), event -> Menu.itemSettings(player)));
            pagedPane.addButton(new Button(exitItem, event -> player.closeInventory()));
        });
        pagedPane.open(player);
    }

    private static void itemSettings(Player player) {
        Interface itemPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&bTrigger Delay", "&7", "&7*This is the delay in half-seconds", "&7that ItemJoin will wait", "&7to give you the items.", "&7", "&cNOTE: &7It is recommended to", "&7set this to 2 or 3 half-seconds.", "&9&lDELAY: &a" + String.valueOf(ItemJoin.getCore().getConfig("items.yml").getString("items-Delay")).toUpperCase() + " half-second(s)"), event -> Menu.numberPane(player, 1)));
            itemPane.addButton(new Button(fillerPaneBItem));
            String defaultTriggers = ItemJoin.getCore().getConfig("config.yml").getString("Settings.Default-Triggers");
            itemPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&bDefault Triggers", "&7", "&7*This will be the default", "&7triggers used if a custom", "&7item is defined without", "&7specifying any triggers.", "&9&lENABLED: &a" + (defaultTriggers != null && !defaultTriggers.isEmpty() && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(defaultTriggers, "DISABLE") ? defaultTriggers : "FALSE").toUpperCase()), event -> Menu.triggerPane(player, 0)));
            itemPane.addButton(new Button(fillerPaneBItem));
            itemPane.addButton(new Button(ItemHandler.getItem("COOKIE", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items"), false, "&bItem Permissions", "&7", "&7*If custom items should require", "&7the player to have specific", "&7permissions to receive the item.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Permissions.Obtain-Items", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(fillerPaneBItem));
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "33", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items-OP"), false, "&bItem Permissions &c&l[OP PLAYERS]", "&7", "&7*If custom items should require", "&7the &c&lOP player(s)&7 to have specific", "&7permissions to receive the item.", "&c&lNOTE: &7This only applies to &c&lOP player(s)&7.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items-OP")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Permissions.Obtain-Items-OP", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items-OP") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(fillerPaneBItem));
            itemPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Overwrite"), false, "&bOverwrite", "&7", "&7*Setting this to true will allow", "&7all custom items to overwrite", "&7any custom or vanilla items.", "&7", "&cNOTE: &7If set to false, false, the", "&7overwrite itemflag will still", "&7function normally.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("items.yml").getString("items-Overwrite")).toUpperCase()), event -> Menu.overwritePane(player)));
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_FENCE" : "85", 1, ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Spamming"), false, "&bSpamming", "&7", "&7*Setting this to false will prevent", "&7players from macro spamming", "&7the use of item commands.", "&7", "&cNOTE: &7It is recommended to", "&7leave this set to false.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Spamming")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("items-Spamming", (Object)(!ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Spamming") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "items.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, ItemJoin.getCore().getConfig("items.yml").getBoolean("items-RestrictCount"), false, "&bRestrict Count", "&7", "&7*Settings this to true will", "&7allow players to have their items", "&7refreshed (topped up) if they have", "&7used/consumed some of the given", "&7stack of custom items.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("items.yml").getBoolean("items-RestrictCount")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("items-RestrictCount", (Object)(!ItemJoin.getCore().getConfig("items.yml").getBoolean("items-RestrictCount") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "items.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_WOOD" : "17", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Log-Commands"), false, "&bLog Commands", "&7", "&7*If the plugin prevent CONSOLE", "&7from logging any executed", "&7command from the custom items.", "&7This only works for item command(s).", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Log-Commands")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("General.Log-Commands", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Log-Commands") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(ItemHandler.getItem("IRON_HELMET", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.HeldItem-Animations"), false, "&bHeld Item Animations", "&7", "&7*If the animate or dynamic", "&7itemflags should update the item", "&7while the player is holding the item.", "&7", "&7This essentially prevents the", "&7glitch held item animation", "&7from the item constantly updating.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.HeldItem-Animations")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Settings.HeldItem-Animations", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.HeldItem-Animations") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().hardReload(true);
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            int heldSlot = ItemJoin.getCore().getConfig("config.yml").getInt("Settings.HeldItem-Slot");
            itemPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", heldSlot > 0 ? heldSlot : 1, false, false, "&bHeld Item Slot", "&7", "&7*This is the hotbar slot that", "&7the player will automatically", "&7have selected upon performing", "&7one of the held item triggers.", "&9&lSLOT: &a" + (heldSlot >= 0 ? Integer.valueOf(heldSlot) : "NONE")), event -> Menu.numberPane(player, 2)));
            String heldTriggers = ItemJoin.getCore().getConfig("config.yml").getString("Settings.HeldItem-Triggers");
            itemPane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&bHeld Item Triggers", "&7", "&7*When these trigger(s)", "&7are performed, the held item", "&7slot will be set.", "&9&lENABLED: &a" + (heldTriggers != null && !heldTriggers.isEmpty() && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(heldTriggers, "DISABLE") ? heldTriggers : "FALSE").toUpperCase()), event -> Menu.triggerPane(player, 1)));
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTING_TABLE" : "116", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.DataTags"), false, "&bDataTags", "&7", "&7*If custom items should use", "&7data tags (NBTTags) to distinguish", "&7each custom item, making them unique.", "&c&lNOTE: &7It is recommended to keep", "&7this set to TRUE.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.DataTags")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Settings.DataTags", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.DataTags") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().hardReload(true);
                SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
            }));
            itemPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&bClear Items", "&7", "&7*Modify settings for clearing", "&7specific items when a player", "&7performed a specified action."), event -> Menu.clearPane(player)));
            itemPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, false, false, "&bPrevent Actions", "&7", "&7*Disable certain actions", "&7with items for players."), event -> Menu.preventPane(player)));
            itemPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
            itemPane.addButton(new Button(fillerPaneBItem), 7);
            itemPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
        });
        itemPane.open(player);
    }

    private static void configSettings(Player player) {
        Interface configPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            configPane.addButton(new Button(fillerPaneBItem), 3);
            configPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&6Language", "&7", "&7*The selected lang.yml language.", "&7This is for messages sent", "&7from the plugin to the player.", "&9&lLANG: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getString("Language")).toUpperCase()), event -> Menu.languagePane(player)));
            configPane.addButton(new Button(fillerPaneBItem));
            configPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL"), false, "&bMySQL Database", "&7", "&7*If the plugin should use", "&7a MySQL Database instead", "&7of the locale SQLite Database.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL")).toUpperCase()), event -> Menu.databasePane(player)));
            configPane.addButton(new Button(fillerPaneBItem), 3);
            configPane.addButton(new Button(ItemHandler.getItem("BUCKET", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("General.CheckforUpdates"), false, "&bCheck for Updates", "&7", "&7*If the plugin should check", "&7for updates at start-up.", "&7This includes the use of the", "&7/itemjoin updates/upgrade command(s).", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.CheckforUpdates")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("General.CheckforUpdates", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.CheckforUpdates") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("COMPASS", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Metrics-Logging"), false, "&bMetrics Logging", "&7", "&7*If the plugin is allowed", "&7to log plugin data such as", "&7the server(s) Java version.", "&7It is recommended to keep this", "&7set to true as it improves", "&7the quality of plugin updates.", "&7", "&7You can view the logged data", "&7Here: https://bstats.org/plugin/bukkit/ItemJoin", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Metrics-Logging")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("General.Metrics-Logging", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Metrics-Logging") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("STICK", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Debugging"), false, "&bDebugging", "&7", "&7*Allows for more detailed", "&7CONSOLE messages from the plugin.", "&7Typically only used by the", "&7plugin developer to determine", "&7issues or bugs with the plugin.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Debugging")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("General.Debugging", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Debugging") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("General.ignoreErrors"), false, "&bIgnore Errors", "&7", "&7*Disables the sending of errors", "&7to all admins upon joining the server.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.ignoreErrors")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("General.ignoreErrors", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.ignoreErrors") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(fillerPaneBItem));
            configPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, !ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands").isEmpty() && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds"), "DISABLED"), false, "&bActive Commands", "&7", "&7*Specify a list of commands", "&7to be executed upon performing a trigger.", "&7These commands are not related to", "&7custom items, rather the server itself.", "&9&lENABLED: &a" + (!ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands").isEmpty() && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds"), "DISABLED") ? "YES" : "NO")), event -> Menu.activeCommands(player)));
            configPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_APPLE" : "322", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-OP"), false, "&bPlugin Commands &c&l[OP PLAYERS]", "&7", "&7*If the plugin should check", "&7if the OP player has the", "&7proper permissions set to", "&7use the plugin commands.", "&7OP Players will no longer get", "&7access to all plugin commands", "&7by default.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-OP")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Permissions.Commands-OP", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-OP") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("BOOK", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-Get"), false, "&bGet Commands", "&7", "&7*If the get and getAll", "&7commands should check for item", "&c&lpermissions &7before giving the item.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-Get")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Permissions.Commands-Get", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-Get") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("BEDROCK", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Movement-Bypass"), false, "&bMovement Bypass", "&7", "&7*Enables the use of the", "&aitemjoin.bypass.inventorymodify", "&7permission-node, used to ignore", "&7the global itemMovement prevention", "&7or a custom items itemflag.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Movement-Bypass")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Permissions.Movement-Bypass", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Movement-Bypass") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.configSettings(player));
            }));
            configPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
            configPane.addButton(new Button(fillerPaneBItem), 7);
            configPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
        });
        configPane.open(player);
    }

    private static void startModify(Player player, ItemMap itemMap, int k) {
        Interface modifyPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            try {
                Menu.setPage(player, modifyPane, ItemUtilities.getUtilities().copyItems(), null, itemMap, k);
            }
            catch (Exception e) {
                if (failCycle != 6) {
                    ++failCycle;
                    SchedulerUtils.runLater(2L, () -> Menu.startModify(player, itemMap, k));
                }
                failCycle = 0;
                ServerUtils.sendSevereTrace(e);
            }
        });
        modifyPane.open(player);
    }

    private static void startHopper(Player player) {
        Interface dragDrop = new Interface(false, 1, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            dragDrop.allowClick(true);
            dragDrop.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
            dragDrop.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&a&lAutosave", "&7", "&7*Click me to save your whole", "&7inventory to the items.yml as-is,", "&7including current slot positions!", "&7", "&c&l[&nALL&c&l ITEMS]"), event -> {
                PlayerInventory playerInv = event.getWhoClicked().getInventory();
                ItemStack offItem = PlayerHandler.getOffHandItem(player);
                for (int i = 0; i <= 35; ++i) {
                    ItemStack item = playerInv.getItem(i);
                    if (item == null || item.getType() == Material.AIR) continue;
                    Menu.convertStack(player, item, Integer.toString(i));
                }
                if (playerInv.getHelmet() != null && playerInv.getHelmet().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getHelmet(), "HELMET");
                }
                if (playerInv.getChestplate() != null && playerInv.getChestplate().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getChestplate(), "CHESTPLATE");
                }
                if (playerInv.getLeggings() != null && playerInv.getLeggings().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getLeggings(), "LEGGINGS");
                }
                if (playerInv.getBoots() != null && playerInv.getBoots().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getBoots(), "BOOTS");
                }
                if (ServerUtils.hasSpecificUpdate("1_9") && offItem.getType() != Material.AIR) {
                    Menu.convertStack(player, offItem, "OFFHAND");
                }
                PluginData.getInfo().hardReload(true);
                Menu.startMenu((CommandSender)player);
            }));
            dragDrop.addButton(new Button(fillerPaneGItem), 2);
            dragDrop.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&a&lDrop an Item", "&7", "&7*Click an item from your inventory", "&7to save and drop it in this", "&7friendly little hopper!", "&7", "&a&l[&nSINGLE&a&l ITEM]"), event -> {
                ItemStack cursorItem = event.getCursor();
                if (cursorItem != null && cursorItem.getType() != Material.AIR) {
                    ItemStack item = cursorItem.clone();
                    event.getWhoClicked().setItemOnCursor(null);
                    event.getWhoClicked().getInventory().addItem(new ItemStack[]{item});
                    Menu.convertStack(player, item, null);
                    dragDrop.allowClick(false);
                }
            }));
            dragDrop.addButton(new Button(fillerPaneGItem), 2);
            dragDrop.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&a&lAutosave", "&7", "&7*Click me to save your whole", "&7inventory to the items.yml as-is,", "&7including current slot positions!", "&7", "&c&l[&nALL&c&l ITEMS]"), event -> {
                PlayerInventory playerInv = event.getWhoClicked().getInventory();
                ItemStack offItem = PlayerHandler.getOffHandItem(player);
                for (int i = 0; i <= 35; ++i) {
                    ItemStack item = playerInv.getItem(i);
                    if (item == null || item.getType() == Material.AIR) continue;
                    Menu.convertStack(player, item, Integer.toString(i));
                }
                if (playerInv.getHelmet() != null && playerInv.getHelmet().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getHelmet(), "HELMET");
                }
                if (playerInv.getChestplate() != null && playerInv.getChestplate().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getChestplate(), "CHESTPLATE");
                }
                if (playerInv.getLeggings() != null && playerInv.getLeggings().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getLeggings(), "LEGGINGS");
                }
                if (playerInv.getBoots() != null && playerInv.getBoots().getType() != Material.AIR) {
                    Menu.convertStack(player, playerInv.getBoots(), "BOOTS");
                }
                if (ServerUtils.hasSpecificUpdate("1_9") && offItem.getType() != Material.AIR) {
                    Menu.convertStack(player, offItem, "OFFHAND");
                }
                PluginData.getInfo().hardReload(true);
                Menu.startMenu((CommandSender)player);
            }));
            dragDrop.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Returns you to the main menu."), event -> Menu.startMenu((CommandSender)player)));
        });
        dragDrop.open(player);
    }

    private static void setButton(Player player, ItemMap itemMap, Interface modifyPane, ItemMap contents, ItemMap refMap, int k) {
        ItemStack item = itemMap.getTempItem().clone();
        if (item.getType() == Material.AIR) {
            item.setType(fillerPaneItem.getType());
        }
        if (itemMap.isAnimated() || itemMap.isDynamic()) {
            Menu.setModifyMenu(true, player);
            if (itemMap.getAnimationHandler().get(player) != null) {
                itemMap.getAnimationHandler().get(player).setMenu(true, 0);
            }
        }
        String lore = contents == null && refMap == null ? "&7*Click to modify this custom item." : (refMap != null ? "&7*Click to set this custom item as an ingredient." : "&7*Click to add into the contents of " + contents.getConfigName() + ".");
        String space = contents == null ? "&6---------------------------" : "&6----------------------------------";
        modifyPane.addButton(new Button(ItemHandler.addLore(item, "&7", space, lore, "&9&lNode: &a" + itemMap.getConfigName(), "&7", contents != null ? "&9&lENABLED: " + (contents.getContents().contains(itemMap.getConfigName()) ? "&aYES" : "&aNO") : ""), event -> {
            if (refMap != null) {
                Menu.setIngredients(player, refMap, itemMap.getConfigName(), k);
            } else if (contents == null) {
                Menu.choicePane(player, itemMap, item);
            } else {
                List<String> contentList = contents.getContents();
                if (contents.getContents().contains(itemMap.getConfigName())) {
                    contentList.remove(itemMap.getConfigName());
                } else {
                    contentList.add(itemMap.getConfigName());
                }
                contents.setContents(contentList);
                Interface contentsPane = new Interface(true, 6, exitButton, GUIName, player);
                SchedulerUtils.runAsync(() -> Menu.setPage(player, contentsPane, ItemUtilities.getUtilities().copyItems(), contents, null, k));
                contentsPane.open(player);
            }
        }));
    }

    private static void setPage(Player player, Interface modifyPane, List<ItemMap> items, ItemMap contents, ItemMap itemMap, int k) {
        boolean crafting = false;
        boolean arbitrary = false;
        if (contents != null) {
            modifyPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to the item definition menu."), event -> Menu.creatingPane(player, contents)));
        } else if (itemMap != null) {
            modifyPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to the recipe menu."), event -> Menu.recipePane(player, itemMap)));
        }
        Interface craftingPane = new Interface(false, 4, exitButton, GUIName, player);
        craftingPane.addButton(new Button(fillerPaneGItem), 3);
        ItemMap currentItem = ItemUtilities.getUtilities().getItemMap("CRAFTING[1]", items);
        if (currentItem != null) {
            crafting = true;
            Menu.setButton(player, currentItem, craftingPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            craftingPane.addButton(new Button(fillerPaneGItem));
        }
        craftingPane.addButton(new Button(fillerPaneGItem));
        currentItem = ItemUtilities.getUtilities().getItemMap("CRAFTING[2]", items);
        if (currentItem != null) {
            crafting = true;
            Menu.setButton(player, currentItem, craftingPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            craftingPane.addButton(new Button(fillerPaneGItem));
        }
        craftingPane.addButton(new Button(fillerPaneGItem), 10);
        currentItem = ItemUtilities.getUtilities().getItemMap("CRAFTING[0]", items);
        if (currentItem != null) {
            crafting = true;
            Menu.setButton(player, currentItem, craftingPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            craftingPane.addButton(new Button(fillerPaneGItem));
        }
        craftingPane.addButton(new Button(fillerPaneGItem), 4);
        currentItem = ItemUtilities.getUtilities().getItemMap("CRAFTING[3]", items);
        if (currentItem != null) {
            crafting = true;
            Menu.setButton(player, currentItem, craftingPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            craftingPane.addButton(new Button(fillerPaneGItem));
        }
        craftingPane.addButton(new Button(fillerPaneGItem));
        currentItem = ItemUtilities.getUtilities().getItemMap("CRAFTING[4]", items);
        if (currentItem != null) {
            crafting = true;
            Menu.setButton(player, currentItem, craftingPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            craftingPane.addButton(new Button(fillerPaneGItem));
        }
        craftingPane.addButton(new Button(fillerPaneGItem), 3);
        String lore = contents == null ? "&7the modifying selection menu" : "&7the contents selection menu.";
        craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", lore), event -> modifyPane.open(player)));
        craftingPane.addButton(new Button(fillerPaneBItem), 7);
        craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", lore), event -> modifyPane.open(player)));
        Interface arbitraryPane = new Interface(true, 6, exitButton, GUIName, player);
        arbitraryPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", lore), event -> modifyPane.open(player)));
        ArrayList<ItemMap> tempList = new ArrayList<ItemMap>(items);
        for (ItemMap item : tempList) {
            if (!item.getSlot().equalsIgnoreCase("ARBITRARY")) continue;
            Menu.setButton(player, item, arbitraryPane, contents, itemMap, k);
            items.remove(item);
            arbitrary = true;
        }
        modifyPane.addButton(new Button(fillerPaneGItem));
        if (arbitrary) {
            modifyPane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&fArbitrary", "&7", "&7*Click to view the existing", "&7Arbitrary slot items."), event -> arbitraryPane.open(player)));
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        if (crafting) {
            modifyPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, false, false, "&fCrafting", "&7", "&7*Click to view the existing", "&7crafting slot items."), event -> craftingPane.open(player)));
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        currentItem = ItemUtilities.getUtilities().getItemMap("HELMET", items);
        if (currentItem != null) {
            Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        currentItem = ItemUtilities.getUtilities().getItemMap("CHESTPLATE", items);
        if (currentItem != null) {
            Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        currentItem = ItemUtilities.getUtilities().getItemMap("LEGGINGS", items);
        if (currentItem != null) {
            Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        currentItem = ItemUtilities.getUtilities().getItemMap("BOOTS", items);
        if (currentItem != null) {
            Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        currentItem = ItemUtilities.getUtilities().getItemMap("OFFHAND", items);
        if (currentItem != null) {
            Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
            items.remove(currentItem);
        } else {
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        modifyPane.addButton(new Button(fillerPaneGItem));
        for (int i = 9; i < 36; ++i) {
            currentItem = ItemUtilities.getUtilities().getItemMap(i + "", items);
            if (currentItem != null) {
                Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
                items.remove(currentItem);
                continue;
            }
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        for (int j = 0; j < 9; ++j) {
            currentItem = ItemUtilities.getUtilities().getItemMap(j + "", items);
            if (currentItem != null) {
                Menu.setButton(player, currentItem, modifyPane, contents, itemMap, k);
                items.remove(currentItem);
                continue;
            }
            modifyPane.addButton(new Button(fillerPaneGItem));
        }
        if (!items.isEmpty()) {
            Menu.setPage(player, modifyPane, items, contents, itemMap, k);
        }
    }

    private static void convertStack(Player player, ItemStack item, String slot) {
        ItemMeta itemMeta;
        ItemMap itemMap = new ItemMap("item_" + PluginData.getInfo().getPath(1), "ARBITRARY");
        itemMap.setMaterial(item.getType());
        if (!ServerUtils.hasSpecificUpdate("1_13")) {
            itemMap.setDataValue((short)LegacyAPI.getDataValue(item));
        }
        itemMap.setCount(String.valueOf(item.getAmount()));
        if (item.getType().getMaxDurability() > 30 && ItemHandler.getDurability(item) != 0 && ItemHandler.getDurability(item) != item.getType().getMaxDurability()) {
            itemMap.setDurability(ItemHandler.getDurability(item));
        }
        if (item.hasItemMeta()) {
            itemMeta = item.getItemMeta();
            if (itemMeta != null && itemMeta.hasDisplayName()) {
                itemMap.setCustomName(itemMeta.getDisplayName().replace('\u00a7', '&'));
            }
            if (itemMeta != null && itemMeta.getLore() != null) {
                ArrayList<String> newLore = new ArrayList<String>();
                for (String lore : itemMeta.getLore()) {
                    newLore.add(lore.replace('\u00a7', '&'));
                }
                itemMap.setCustomLore(newLore);
            }
            if (ServerUtils.hasSpecificUpdate("1_14") && itemMeta != null && itemMeta.hasCustomModelData()) {
                itemMap.setModelData(String.valueOf(itemMeta.getCustomModelData()));
            }
            if (item.getItemMeta().hasEnchants()) {
                HashMap<String, Integer> enchantList = new HashMap<String, Integer>();
                for (Enchantment e : item.getItemMeta().getEnchants().keySet()) {
                    enchantList.put(ItemHandler.getEnchantName(e).toUpperCase(), (Integer)item.getItemMeta().getEnchants().get(e));
                }
                itemMap.setEnchantments(enchantList);
            }
        }
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(item.getType().toString(), "LEATHER_")) {
            DyeColor dyeColor;
            LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
            if (meta != null && (dyeColor = DyeColor.getByColor((Color)meta.getColor())) != null) {
                itemMap.setLeatherColor(dyeColor.name());
            }
        } else if (item.getType().toString().equalsIgnoreCase("SKULL_ITEM") || item.getType().toString().equalsIgnoreCase("PLAYER_HEAD")) {
            if (!PlayerHandler.getSkullOwner(item).equalsIgnoreCase("NULL")) {
                itemMap.setSkull(PlayerHandler.getSkullOwner(item));
            } else if (item.getItemMeta() != null && !ItemHandler.getSkullTexture(item.getItemMeta()).isEmpty()) {
                itemMap.setSkullTexture(ItemHandler.getSkullTexture(item.getItemMeta()));
            }
        } else if (itemMap.getMaterial().toString().contains("CHARGE") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_STAR")) {
            itemMap.setChargeColor(DyeColor.getByFireworkColor((Color)((Color)Objects.requireNonNull(((FireworkEffectMeta)Objects.requireNonNull(item.getItemMeta())).getEffect()).getColors().get(0))));
        } else if (itemMap.getMaterial().toString().contains("BANNER")) {
            itemMap.setBannerPatterns(((BannerMeta)Objects.requireNonNull(item.getItemMeta())).getPatterns());
        } else if (itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_ROCKET")) {
            itemMeta = item.getItemMeta();
            if (itemMeta != null) {
                ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
                for (Color color : ((FireworkEffect)((FireworkMeta)itemMeta).getEffects().get(0)).getColors()) {
                    colors.add(DyeColor.getByFireworkColor((Color)color));
                }
                itemMap.setFirework((FireworkEffect)((FireworkMeta)itemMeta).getEffects().get(0));
                itemMap.setFireworkColor(colors);
                itemMap.setFireworkFlicker(((FireworkEffect)((FireworkMeta)itemMeta).getEffects().get(0)).hasFlicker());
                itemMap.setFireworkTrail(((FireworkEffect)((FireworkMeta)itemMeta).getEffects().get(0)).hasTrail());
                itemMap.setFireworkType(((FireworkEffect)((FireworkMeta)itemMeta).getEffects().get(0)).getType());
                itemMap.setFireworkPower(((FireworkMeta)itemMeta).getPower());
            }
        } else if (itemMap.getMaterial() == Material.WRITTEN_BOOK && (itemMeta = item.getItemMeta()) != null) {
            itemMap.setAuthor(Objects.requireNonNull(((BookMeta)itemMeta).getAuthor()).replace('\u00a7', '&'));
            itemMap.setTitle(Objects.requireNonNull(((BookMeta)itemMeta).getTitle()).replace('\u00a7', '&'));
            if (ServerUtils.hasSpecificUpdate("1_10")) {
                itemMap.setGeneration(((BookMeta)itemMeta).getGeneration());
            }
            ArrayList<String> newPages = new ArrayList<String>();
            for (String page : ((BookMeta)itemMeta).getPages()) {
                newPages.add(page.replace('\u00a7', '&'));
            }
            itemMap.setPages(newPages);
            ArrayList<List<String>> savePages = new ArrayList<List<String>>();
            for (String page : ((BookMeta)itemMeta).getPages()) {
                ArrayList<String> pageList = new ArrayList<String>();
                for (String splitPage : page.split("\n")) {
                    pageList.add(splitPage.replace('\u00a7', '&'));
                }
                savePages.add(pageList);
            }
            itemMap.setListPages(savePages);
        }
        if (slot == null) {
            Menu.switchPane(player, itemMap, 0);
        } else {
            itemMap.setSlot(slot);
            itemMap.saveToConfig();
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, item.hasItemMeta() && Objects.requireNonNull(item.getItemMeta()).hasDisplayName() ? item.getItemMeta().getDisplayName() : itemMap.getConfigName());
            ItemJoin.getCore().getLang().sendLangMessage("commands.menu.itemSaved", (CommandSender)player, placeHolders);
        }
        Map<Object, Object> properties = Menu.getNBTProperties(item);
        if (properties != null && !properties.isEmpty()) {
            itemMap.setNBTProperties(properties);
        }
        itemMap.renderItemStack();
    }

    public static Map<Object, Object> getNBTProperties(ItemStack item) {
        try {
            Object tag = null;
            ItemStack itemCopy = item.clone();
            Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
            Object nms = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, itemCopy);
            if (ServerUtils.hasPreciseUpdate("1_20_5")) {
                Object componentMap = ReflectionUtils.getMethod(itemClass, ReflectionUtils.MinecraftMethod.getComponents.getMethod(), new Class[0]).invoke(nms, new Object[0]);
                Object customDataType = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("DataComponents"), ReflectionUtils.MinecraftField.CustomData.getField()).get(null);
                Object customDataOptional = ReflectionUtils.getMethod(ReflectionUtils.getMinecraftClass(ServerUtils.hasPreciseUpdate("1_21_5") ? "DataComponentGetter" : "DataComponentMap"), ReflectionUtils.MinecraftMethod.get.getMethod(), ReflectionUtils.getMinecraftClass("DataComponentType")).invoke(componentMap, customDataType);
                if (customDataOptional != null) {
                    tag = ReflectionUtils.getMethod(customDataOptional.getClass(), ReflectionUtils.MinecraftMethod.copyTag.getMethod(), new Class[0]).invoke(customDataOptional, new Object[0]);
                }
            } else {
                tag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0]);
            }
            if (tag == null) {
                return null;
            }
            HashMap<Object, Object> nbtData = new HashMap<Object, Object>();
            Menu.extractNBTData(tag, "", nbtData);
            return nbtData;
        }
        catch (Exception e) {
            ServerUtils.logSevere("{Menu} Failed to extract NBT Properties from the ItemStack!");
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    private static void extractNBTData(Object tag, String parentKey, Map<Object, Object> nbtData) throws Exception {
        for (String key : (Set)tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.getKeys.getMethod(), new Class[0]).invoke(tag, new Object[0])) {
            String fullKey;
            if (Menu.isVanillaTag(key)) continue;
            Object nbtBase = tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.getBase.getMethod(), String.class).invoke(tag, key);
            byte typeId = (Byte)nbtBase.getClass().getMethod(ReflectionUtils.MinecraftMethod.getTypeId.getMethod(), new Class[0]).invoke(nbtBase, new Object[0]);
            String string = fullKey = parentKey.isEmpty() ? key : parentKey + "." + key;
            if (typeId == 10) {
                Menu.extractNBTData(nbtBase, fullKey, nbtData);
                continue;
            }
            nbtData.put(fullKey, nbtBase);
        }
    }

    private static boolean isVanillaTag(String key) {
        ServerUtils.logDebug("{Menu} Checking if NBT key is Vanilla: " + key);
        return new HashSet<String>(Arrays.asList("display", "damage", "enchantments", "ench", "unbreakable", "custommodeldata", "hideflags", "attributemodifiers", "blockentitytag", "blockstatetag", "trim", "chargedprojectiles", "bookpages", "pages", "title", "author", "generation", "resolved", "map", "explosion", "potion", "custompotioneffects", "fireworks", "skullowner", "itemjoin name")).contains(key.toLowerCase());
    }

    private static void choicePane(Player player, ItemMap itemMap, ItemStack item) {
        Interface choicePane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            choicePane.addButton(new Button(fillerPaneBItem), 4);
            choicePane.addButton(new Button(item));
            choicePane.addButton(new Button(fillerPaneBItem), 4);
            choicePane.addButton(new Button(fillerPaneBItem), 3);
            choicePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, true, false, "&b&lSettings", "&7", "&7*Change the settings for this item.", "&7Make changes to the item name, lore,", "&7permissions, enabled-worlds, and more."), event -> Menu.creatingPane(player, itemMap)));
            choicePane.addButton(new Button(fillerPaneBItem));
            choicePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, true, false, "&c&lDelete", "&7", "&7*Delete this item.", "&7This will remove the item from the", "&7items.yml and will no longer be usable.", "&c&lWARNING: &7This &lCANNOT &7be undone!"), event -> {
                itemMap.removeFromConfig();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, itemMap.getConfigName());
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.itemRemoved", (CommandSender)player, placeHolders);
                PluginData.getInfo().hardReload(true);
                SchedulerUtils.runLater(4L, () -> Menu.startModify(player, null, 0));
            }));
            choicePane.addButton(new Button(fillerPaneBItem), 3);
            choicePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the modify menu"), event -> Menu.startModify(player, null, 0)));
            choicePane.addButton(new Button(fillerPaneBItem), 7);
            choicePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the modify menu"), event -> Menu.startModify(player, null, 0)));
        });
        choicePane.open(player);
    }

    private static void creatingPane(Player player, ItemMap itemMap) {
        Interface creatingPane = new Interface(false, 5, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            StringBuilder slotList = new StringBuilder();
            StringBuilder slotString = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getMultipleSlots().toString()).equals("NONE")) {
                for (String slot : itemMap.getMultipleSlots()) {
                    slotString.append(slot).append(", ");
                }
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(slotString.toString()))) {
                    slotList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder itemflagsList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemFlags()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(itemMap.getItemFlags())) {
                    itemflagsList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder triggersList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggers()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(itemMap.getTriggers())) {
                    triggersList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder disabledList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()))) {
                    disabledList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder enabledList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()))) {
                    enabledList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder enabledRegionList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()))) {
                    enabledRegionList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder disabledRegionList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()))) {
                    disabledRegionList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder enchantList = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()).equals("NONE")) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()))) {
                    enchantList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder potionList = new StringBuilder();
            StringBuilder potionString = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
                for (PotionEffect potions : itemMap.getPotionEffect()) {
                    potionString.append(CompatUtils.getName(potions)).append(":").append(potions.getAmplifier()).append(":").append(potions.getDuration()).append(", ");
                }
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionString.substring(0, potionString.length())))) {
                    potionList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder attributeList = new StringBuilder();
            StringBuilder attributeString = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAttributes().toString()).equals("NONE")) {
                for (String attribute : itemMap.getAttributes().keySet()) {
                    attributeString.append(attribute).append(":").append(itemMap.getAttributes().get(attribute)).append(", ");
                }
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeString.substring(0, attributeString.length())))) {
                    attributeList.append("&a").append(split).append(" /n ");
                }
            }
            StringBuilder patternList = new StringBuilder();
            StringBuilder patternString = new StringBuilder();
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getBannerPatterns().toString()).equals("NONE")) {
                for (Pattern patterns : itemMap.getBannerPatterns()) {
                    patternString.append(patterns.getColor()).append(":").append(ItemHandler.getPatternName(patterns)).append(", ");
                }
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(patternString.substring(0, patternString.length())))) {
                    patternList.append("&a").append(split).append(" /n ");
                }
            }
            creatingPane.addButton(new Button(fillerPaneGItem), 4);
            creatingPane.addButton(new Button(Menu.headerStack(player, itemMap)));
            creatingPane.addButton(new Button(fillerPaneGItem), 4);
            creatingPane.addButton(new Button(ItemHandler.getItem(itemMap.getMaterial().toString() + (itemMap.getDataValue() != null && itemMap.getDataValue() != 0 ? ":" + itemMap.getDataValue() : ""), 1, false, false, "&c&lMaterial", "&7", "&7*Set the material of the item.", "&9&lMATERIAL: &a" + itemMap.getMaterial().toString() + (itemMap.getDataValue() != null && itemMap.getDataValue() != 0 ? ":" + itemMap.getDataValue() : "")), event -> {
                if (itemMap.getDynamicMaterials() != null && !itemMap.getDynamicMaterials().isEmpty()) {
                    Menu.animateMaterialPane(player, itemMap);
                } else {
                    Menu.materialPane(player, itemMap, 1, 0);
                }
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem("GLASS", 1, false, false, "&c&lSlot", "&7", "&7*Set the slot that the", "&7item will be given in.", itemMap.getMultipleSlots() != null && !itemMap.getMultipleSlots().isEmpty() ? "&9&lSlot(s): &a" + slotList : "&9&lSLOT: &a" + itemMap.getSlot().toUpperCase()), event -> Menu.switchPane(player, itemMap, 1)));
            creatingPane.addButton(new Button(ItemHandler.getItem("DIAMOND", itemMap.getCount(player), false, false, "&b&lCount", "&7", "&7*Set the amount of the", "&7item to be given.", "&9&lCOUNT: &a" + (itemMap.getCount(player) != 1 ? itemMap.getRawCount() : "1")), event -> Menu.countPane(player, itemMap, 0)));
            creatingPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&b&lName", "&7", "&7*Set the name of the item.", "&9&lNAME: &f" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomName())), event -> {
                InventoryHolder inventoryHolder = event.getInventory().getHolder();
                if (itemMap.getDynamicNames() != null && itemMap.isAnimated()) {
                    Menu.animatedNamePane(player, itemMap);
                } else if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomName()).equals("NONE")) {
                    itemMap.setCustomName((String)null);
                    Menu.creatingPane(player, itemMap);
                } else if (inventoryHolder != null) {
                    ((Interface)inventoryHolder).onTyping(CompatUtils.getPlayer(event.getView()));
                    Menu.setTypingMenu(true, player, (Interface)inventoryHolder);
                }
            }, query -> query.onClose(stateSnapshot -> Menu.creatingPane(stateSnapshot.getPlayer(), itemMap)).onClick((slot, stateSnapshot) -> {
                if (slot != 2) {
                    return Collections.emptyList();
                }
                itemMap.setCustomName(me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(stateSnapshot.getText()));
                Menu.setTypingMenu(false, player, null);
                Menu.creatingPane(stateSnapshot.getPlayer(), itemMap);
                return Collections.singletonList(Query.ResponseAction.close());
            }).itemLeft(ItemHandler.getItem("NAME_TAG", 1, false, true, " ", "&bThis is what the raw data looks like.")).itemRight(ItemHandler.getItem("GOLD_NUGGET", 1, true, true, "&c&n&lTips", "&aType your answer into the query box!", "&7", ItemJoin.getCore().getLang().getLangMessage("commands.menu.inputType").replace("%input%", "NAME").replace("%prefix% ", "").replace("%prefix%", ""), ItemJoin.getCore().getLang().getLangMessage("commands.menu.inputExample").replace("%input_example%", "&bUltimate Sword").replace("%prefix% ", "").replace("%prefix%", ""))).itemOutput(ItemHandler.getItem("IRON_INGOT", 1, false, true, "&bStart typing...", "&aThis is what the text will look like.")).title("Type the item name:"), 0));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&b&lLore", "&7", "&7*Set the lore of the item.", "&9&lLORE: &f" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomLore().toString())), event -> {
                if (itemMap.getDynamicLores() != null && !itemMap.getDynamicLores().isEmpty()) {
                    Menu.animatedLorePane(player, itemMap);
                } else {
                    Menu.lorePane(player, itemMap);
                }
            }, event -> {
                itemMap.setCustomLore(me.RockinChaos.itemjoin.core.utils.StringUtils.split(me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage())));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "LORE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.creatingPane(event.getPlayer(), itemMap);
            }));
            creatingPane.addButton(new Button(ItemHandler.setDurability(ItemHandler.getItem("DIAMOND_BOOTS", 1, false, false, "&e&lData", "&7", "&7*Set the damage or the", "&7custom texture of the item."), 160), event -> Menu.dataPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem("BOOK", 1, false, false, "&e&lCommand Settings", "&7", "&7*Define commands for the item", "&7which execute upon being", "&7interacted with."), event -> Menu.commandPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem("ENCHANTED_BOOK", 1, false, false, "&b&lEnchantments", "&7", "&7*Add enchants to make the", "&7item sparkle and powerful.", "&9&lENCHANTMENTS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()).equals("NONE") ? "&a" + enchantList : "NONE")), event -> Menu.enchantPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&b&lItemflags", "&7", "&7*Special flags that will give", "&7the item abilities and", "&7custom features.", "&9&lITEMFLAGS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemFlags()).equals("NONE") ? "&a" + itemflagsList : "NONE")), event -> Menu.flagPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&b&lTriggers", "&7", "&7*When the players act upon these", "&7events, the item will be given.", "&9&lTRIGGERS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggers()).equals("NONE") ? "&a" + triggersList : "NONE")), event -> Menu.triggerPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REDSTONE_TORCH" : "76", 1, false, false, "&b&lPermission Node", "&7", "&7*Custom permission node that", "&7will be required by a permission", "&7plugin to receive the item.", "&7", "&c&lNote: &7You can use a &c&l! &7symbol", "&7to invert the requirement such", "&7as !fish.cakes, do NOT include any", "&7other special characters or spaces.", "&7", "&7Setting this bypasses the", "&7config.yml Permissions Settings.", "&7", "&9&lPERMISSION-NODE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPermissionNode())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPermissionNode()).equals("NONE")) {
                    itemMap.setPerm(null);
                    Menu.creatingPane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "CUSTOM PERMISSION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "itemjoin.ultra");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setPerm(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "CUSTOM PERMISSION");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.creatingPane(event.getPlayer(), itemMap);
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BEDROCK" : "7", 1, false, false, "&b&lDisabled Worlds", "&7", "&7*Define the world(s) that the", "&7item will &l&nNOT&7 be given in.", "&9&lDISABLED-WORLDS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()).equals("NONE") ? "&a" + disabledList : "NONE")), event -> Menu.worldPane(player, itemMap, 0)));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, false, false, "&b&lEnabled Worlds", "&7", "&7*Define the world(s) that the", "&7item will be given in.", "&9&lENABLED-WORLDS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()).equals("NONE") ? "&a" + enabledList : "NONE")), event -> Menu.worldPane(player, itemMap, 1)));
            creatingPane.addButton(new Button(ItemHandler.getItem("REDSTONE_BLOCK", 1, true, false, "&b&lDisabled Regions", "&7", "&7*Define the region(s) that the", "&7item will &l&nNOT&7 be given in.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "&9&lDISABLED-REGIONS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()).equals("NONE") ? "&a" + disabledRegionList : "NONE") : "", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&c&lERROR: &7WorldGuard was NOT found.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7This button will do nothing..."), event -> {
                if (ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
                    Menu.regionPane(player, itemMap, 0);
                }
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem("GOLD_BLOCK", 1, true, false, "&b&lEnabled Regions", "&7", "&7*Define the region(s) that the", "&7item will be given in.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "&9&lENABLED-REGIONS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()).equals("NONE") ? "&a" + enabledRegionList : "NONE") : "", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&c&lERROR: &7WorldGuard was NOT found.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7This button will do nothing..."), event -> {
                if (ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
                    Menu.regionPane(player, itemMap, 1);
                }
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STICKY_PISTON" : "29", 1, false, false, "&e&lAnimation Settings", "&7", "&7*Define animations for the item", "&7Example: Custom iterations for the", "&7items name, lore, and material type"), event -> Menu.animationPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_FENCE" : "FENCE", 1, false, false, "&b&lLimit-Modes", "&7", "&7*Define the gamemode(s) that the", "&7item will be limited to.", "&9&lLIMIT-MODES: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLimitModes())), event -> Menu.limitPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem("NETHER_STAR", 1, false, false, "&b&lProbability", "&7", "&7*Define the chance that the", "&7item will be given to the player.", "&7", "&c&lNOTICE:&7 Only ONE item defined with", "&7a probability value will be selected.", "&7Probability is the same as a dice roll.", "&7", "&9&lPROBABILITY: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getProbability() + "&a%")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getProbability() + "&a%").equals("NONE")) {
                    itemMap.setProbability(-1);
                    Menu.creatingPane(player, itemMap);
                } else {
                    Menu.probabilityPane(player, itemMap);
                }
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem("ICE", 1, false, false, "&b&lUsage Cooldown", "&7", "&7*Define the cooldown for", "&7interacting with the item.", "&9&lUSE-COOLDOWN: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getInteractCooldown() + "&7")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getInteractCooldown() + "&7").equals("NONE")) {
                    itemMap.setInteractCooldown(0);
                    Menu.creatingPane(player, itemMap);
                } else {
                    Menu.usePane(player, itemMap);
                }
            }));
            creatingPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&b&lConditions", "&7", "&7*Define conditions for triggers", "&7and the disposable itemflag.", "&9Enabled: &a" + (itemMap.getTriggerConditions() != null && !itemMap.getTriggerConditions().isEmpty() || itemMap.getDisposableConditions() != null && !itemMap.getDisposableConditions().isEmpty() || itemMap.getCommandConditions() != null && !itemMap.getCommandConditions().isEmpty() ? "YES" : "NONE")), event -> Menu.conditionsPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REPEATER" : "356", 1, false, false, "&b&lToggle", "&7", "&7*Specify command(s) players can", "&7execute to enable or disable the", "&7custom item for themselves.", "&9Enabled: &a" + (itemMap.getToggleCommands() != null && !itemMap.getToggleCommands().isEmpty() ? "YES" : "NONE")), event -> Menu.togglePane(player, itemMap)));
            creatingPane.addButton(new Button(fillerPaneGItem));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, false, false, "&b&lRecipe", "&7", "&7*Define the recipe to be", "&7able to craft this item.", "&9Enabled: &a" + (itemMap.getIngredients() != null && !itemMap.getIngredients().isEmpty() ? "YES" : "NONE")), event -> Menu.recipePane(player, itemMap)));
            if (ServerUtils.hasSpecificUpdate("1_20") && ItemHandler.isArmor(itemMap.getMaterial().toString())) {
                String trimPattern = "NONE";
                if (itemMap.getTrimPattern() != null && !itemMap.getTrimPattern().isEmpty()) {
                    Map.Entry<String, String> entry = itemMap.getTrimPattern().entrySet().iterator().next();
                    trimPattern = entry.getKey() + ":" + entry.getValue();
                }
                String trimEnabled = trimPattern;
                creatingPane.addButton(new Button(ItemHandler.getItem("DUNE_ARMOR_TRIM_SMITHING_TEMPLATE", 1, false, true, "&b&lTrim Pattern", "&7", "&7*Define the pattern to be", "&7set to the armor.", "&9&lArmor Meta: &a" + trimPattern), event -> {
                    if (trimEnabled.equalsIgnoreCase("NONE")) {
                        Menu.trimPane(player, itemMap);
                    } else {
                        HashMap<String, String> trimMap = new HashMap<String, String>();
                        itemMap.setTrimPattern(trimMap);
                        Menu.creatingPane(player, itemMap);
                    }
                }));
            } else {
                creatingPane.addButton(new Button(fillerPaneGItem));
            }
            creatingPane.addButton(new Button(ItemHandler.getItem("GOLD_INGOT", 1, false, false, "&e&lDrop Chances", "&7", "&7*Define the drop chance for receiving", "&7this item from mobs or breaking blocks."), event -> Menu.dropsPane(player, itemMap)));
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, false, false, "&c&lNBT Properties", "&7", "&7*Define specific NBT Properties", "&7to be set to the item.", "&9Enabled: &a" + (itemMap.getNBTProperties() != null && !itemMap.getNBTProperties().isEmpty() ? "YES" : "NONE")), event -> Menu.nbtPane(player, itemMap)));
            if (itemMap.getMaterial().toString().contains("MAP")) {
                creatingPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&e&lMap Image", "&7", "&7*Adds a custom map image that", "&7will be displayed when held.", "&7", "&7Place the custom map image", "&7in the MAIN ItemJoin folder.", "&7", "&7The map CAN be a GIF but", "&7must be a 128x128 pixel image.", "&9&lImage: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getMapImage())), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getMapImage()).equals("NONE")) {
                        itemMap.setMapImage(null);
                        Menu.creatingPane(player, itemMap);
                    } else {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MAP IMAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "minecraft.png OR minecraft-dance.gif");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }
                }, event -> {
                    itemMap.setMapImage(ChatColor.stripColor((String)event.getMessage()));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MAP IMAGE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.creatingPane(event.getPlayer(), itemMap);
                }));
            } else if (itemMap.getMaterial().toString().contains("ARROW") && !itemMap.getMaterial().toString().contains("TIPPED_ARROW")) {
                creatingPane.addButton(new Button(ItemHandler.getItem("ENDER_PEARL", 1, false, false, "&e&lTeleport", "&7", "&7*Set the arrow to teleport", "&7the player upon landing.", "&9&lEnabled: &a" + String.valueOf(itemMap.isTeleport()).toUpperCase()), event -> Menu.teleportPane(player, itemMap, 0)));
            } else if (itemMap.getMaterial().toString().contains("CHARGE") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_STAR")) {
                Interface colorPane = new Interface(true, 6, exitButton, GUIName, player);
                colorPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu"), event -> Menu.creatingPane(player, itemMap)));
                for (DyeColor color : DyeColor.values()) {
                    colorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? color.name() + "_DYE" : "351:8", 1, false, false, "&f" + color.name(), "&7", "&7*This will be the color", "&7of your firework charge."), event -> {
                        itemMap.setChargeColor(color);
                        Menu.creatingPane(player, itemMap);
                    }));
                }
                creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_DYE" : "351:9", 1, false, false, "&e&lCharge Color", "&7", "&7*Set the color of", "&7the firework star.", "&9&lColor: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getChargeColor() + "")), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getChargeColor() + "").equals("NONE")) {
                        itemMap.setChargeColor(null);
                        Menu.creatingPane(player, itemMap);
                    } else {
                        colorPane.open(player);
                    }
                }));
            } else if (itemMap.getMaterial().isEdible() || itemMap.getMaterial().toString().equalsIgnoreCase("POTION")) {
                creatingPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, false, "&e&lEffects", "&7", "&7*Add custom effects after", "&7consuming the item.", "&9&lPotion-Effects: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionList.toString())), event -> Menu.potionPane(player, itemMap, 0)));
            } else if (itemMap.getMaterial().toString().contains("BANNER")) {
                creatingPane.addButton(new Button(ItemHandler.getItem("CLAY_BALL", 1, false, false, "&e&lBanner Patterns", "&7", "&7*Set custom patterns that", "&7will appear on the item.", "&9&lBanner-Meta: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(patternList.toString())), event -> Menu.bannerPane(player, itemMap)));
            } else if (!ItemHandler.getDesignatedSlot(itemMap.getMaterial()).equalsIgnoreCase("noslot") && !itemMap.getMaterial().toString().contains("LEATHER_")) {
                creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&a&lAttributes", "&7", "&7*Add a custom attribute to", "&7your armor or weapon.", !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeList.toString()).equals("NONE") ? "&9&lAttributes: &a" + attributeList : ""), event -> Menu.attributePane(player, itemMap, false)));
            } else if (itemMap.getMaterial().toString().contains("SHULKER")) {
                creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PURPLE_SHULKER_BOX" : "229", 1, false, false, "&a&lContents", "&7", "&7*Add existing custom items into", "&7the contents of this box.", "&9Enabled: &a" + (itemMap.getContents() != null && !itemMap.getContents().isEmpty() ? "YES" : "NONE")), event -> {
                    Interface contentsPane = new Interface(true, 6, exitButton, GUIName, player);
                    SchedulerUtils.runAsync(() -> Menu.setPage(player, contentsPane, ItemUtilities.getUtilities().copyItems(), itemMap, null, 0));
                    contentsPane.open(player);
                }));
            } else {
                creatingPane.addButton(new Button(ItemHandler.getItem("MAGMA_CREAM", 1, false, false, "&e&lOther Settings", "&7", "&7*Settings that are specific", "&7to the item's material type.", Menu.specialItem(itemMap) ? "" : "&7", Menu.specialItem(itemMap) ? "" : "&c&lERROR: &7A " + itemMap.getMaterial().name() + " &7is NOT", Menu.specialItem(itemMap) ? "" : "&7a special material type."), event -> {
                    if (Menu.specialItem(itemMap)) {
                        Menu.otherPane(player, itemMap);
                    }
                }));
            }
            creatingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Cancel and return to the main menu.", "&7", "&c&lWARNING: &7This item has NOT been saved!"), event -> Menu.returnConfirm(player, itemMap)));
            creatingPane.addButton(new Button(fillerPaneBItem), 3);
            creatingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIME_WOOL" : "WOOL:5", 1, false, false, "&a&l&nSave to Config", "&7", "&7*Saves the custom item", "&7settings to the items.yml file."), event -> {
                itemMap.saveToConfig();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, itemMap.getConfigName());
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.itemSaved", (CommandSender)player, placeHolders);
                PluginData.getInfo().hardReload(true);
                player.closeInventory();
            }));
            creatingPane.addButton(new Button(fillerPaneBItem), 3);
            creatingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Cancel and return you to the main menu.", "&7", "&c&lWARNING: &7This item has NOT been saved!"), event -> Menu.returnConfirm(player, itemMap)));
        });
        creatingPane.open(player);
    }

    private static void returnConfirm(Player player, ItemMap itemMap) {
        Interface returnPane = new Interface(false, 1, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            returnPane.addButton(new Button(fillerPaneBItem));
            returnPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "RED_WOOL" : "WOOL:14", 1, false, false, "&c&l&nMain Menu", "&7", "&7*Cancel and return to the", "&7main menu, all modified", "&7settings will be lost.", "&7", "&c&lWARNING: &cThis item has &lNOT&c been saved!"), event -> Menu.startMenu((CommandSender)player)));
            returnPane.addButton(new Button(fillerPaneBItem), 2);
            returnPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIME_WOOL" : "WOOL:5", 1, false, false, "&a&l&nSave to Config", "&7", "&7*Saves the custom item", "&7settings to the items.yml file."), event -> {
                itemMap.saveToConfig();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM, itemMap.getConfigName());
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.itemSaved", (CommandSender)player, placeHolders);
                PluginData.getInfo().hardReload(true);
                Menu.startMenu((CommandSender)player);
            }));
            returnPane.addButton(new Button(fillerPaneBItem), 2);
            returnPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_WOOL" : "WOOL:4", 1, false, false, "&e&l&nModify Settings", "&7", "&7*Continue modifying the", "&7custom item settings."), event -> Menu.creatingPane(player, itemMap)));
            returnPane.addButton(new Button(fillerPaneBItem));
        });
        returnPane.open(player);
    }

    private static void numberPane(Player player, int stage) {
        Interface numberPane = new Interface(stage != 2, stage == 2 ? 2 : 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            numberPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> {
                if (stage == 1) {
                    Menu.itemSettings(player);
                } else if (stage == 3) {
                    Menu.clearPane(player);
                }
            }));
            for (int i = 0; i <= (stage == 1 || stage == 3 ? 64 : (stage == 2 ? 8 : 0)); ++i) {
                int k = i;
                if (stage == 1) {
                    numberPane.addButton(new Button(ItemHandler.getItem(i == 0 ? (ServerUtils.hasSpecificUpdate("1_13") ? "RED_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:14") : (ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11"), i == 0 ? 1 : i, false, false, "&9&lDelay: &a&l" + i, "&7", "&7*Click to set the trigger", "&7delay for giving custom items.", "&aSecond(s): &e" + (i == 0 ? 0.0 : Double.parseDouble(String.valueOf(i)) / 2.0)), event -> {
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("items-Delay", (Object)k);
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "items.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
                    }));
                    continue;
                }
                if (stage == 2) {
                    numberPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", i == 0 ? 1 : i, false, false, "&9&lSlot: &a&l" + i + " &9&l[HOTBAR]", "&7", "&7*Click to set the held item slot", "&7that is automatically selected", "&7when performing a held item trigger.", "&aSlot: &e" + k), event -> {
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("Settings.HeldItem-Slot", (Object)k);
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.itemSettings(player));
                    }));
                    continue;
                }
                if (stage != 3) continue;
                numberPane.addButton(new Button(ItemHandler.getItem(i == 0 ? (ServerUtils.hasSpecificUpdate("1_13") ? "RED_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:14") : (ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11"), i == 0 ? 1 : i, false, false, "&9&lDelay: &a&l" + i, "&7", "&7*Click to set the trigger", "&7delay for clearing items.", "&aSecond(s): &e" + (i == 0 ? 0.0 : Double.parseDouble(String.valueOf(i)))), event -> {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Delay-Tick", (Object)k);
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.clearPane(player));
                }));
            }
            if (stage == 2) {
                numberPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
                numberPane.addButton(new Button(fillerPaneBItem), 7);
                numberPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
            }
        });
        numberPane.open(player);
    }

    private static void languagePane(Player player) {
        Interface languagePane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            String lang = ItemJoin.getCore().getConfig("config.yml").getString("Language");
            String language = lang != null && !lang.isEmpty() ? lang.replace(" ", "") : "ENGLISH";
            languagePane.addButton(new Button(fillerPaneBItem), 4);
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, language.equalsIgnoreCase("ENGLISH"), false, "&6&l&nEnglish", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lEnglish&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("ENGLISH") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("ENGLISH")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"ENGLISH");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(fillerPaneBItem), 4);
            languagePane.addButton(new Button(ItemHandler.getItem("SAND", 1, language.equalsIgnoreCase("SPANISH"), false, "&6&l&nSpanish", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lSpanish&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("SPANISH") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("SPANISH")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"SPANISH");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SNOW_BLOCK" : "80", 1, language.equalsIgnoreCase("RUSSIAN"), false, "&6&l&nRussian", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lRussian&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("RUSSIAN") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("RUSSIAN")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"RUSSIAN");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE_BRICKS" : "98", 1, language.equalsIgnoreCase("FRENCH"), false, "&6&l&nFrench", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lFrench&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("FRENCH") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("FRENCH")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"FRENCH");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "DIORITE" : "1:3", 1, language.equalsIgnoreCase("TRADITIONALCHINESE"), false, "&6&l&nTraditional Chinese", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lTraditional Chinese&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("TRADITIONALCHINESE") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("TRADITIONALCHINESE")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"TRADITIONAL CHINESE");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "POLISHED_DIORITE" : "1:4", 1, language.equalsIgnoreCase("SIMPLIFIEDCHINESE"), false, "&6&l&nSimplified Chinese", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lSimplified Chinese&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("SIMPLIFIEDCHINESE") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("SIMPLIFIEDCHINESE")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"SIMPLIFIED CHINESE");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRAVEL" : "13", 1, language.equalsIgnoreCase("PORTUGUESE"), false, "&6&l&nPortuguese", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lPortuguese&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("PORTUGUESE") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("PORTUGUESE")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"PORTUGUESE");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PRISMARINE" : "168", 1, language.equalsIgnoreCase("POLISH"), false, "&6&l&nPolish", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lPolish&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("POLISH") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("POLISH")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"POLISH");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SANDSTONE" : "24", 1, language.equalsIgnoreCase("DUTCH"), false, "&6&l&nDutch", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lDutch&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("DUTCH") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("DUTCH")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"DUTCH");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SMOOTH_STONE" : "43:8", 1, language.equalsIgnoreCase("ITALIAN"), false, "&6&l&nItalian", "&7", "&7*Sets the messages sent by", "&7the plugin to the player", "&7to be written in &c&lItalian&7.", "&7This is the type of lang.yml file", "&7generated in the plugin folder.", "&9&lENABLED: &a" + (language.equalsIgnoreCase("ITALIAN") + "").toUpperCase()), event -> {
                if (!language.equalsIgnoreCase("ITALIAN")) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Language", (Object)"ITALIAN");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.languagePane(player));
                }
            }));
            languagePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
            languagePane.addButton(new Button(fillerPaneBItem), 7);
            languagePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
        });
        languagePane.open(player);
    }

    private static void activeCommands(Player player) {
        Interface activePane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            String triggers = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.triggers");
            String enabledList = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds");
            activePane.addButton(new Button(fillerPaneBItem), 4);
            activePane.addButton(new Button(ItemHandler.getItem("BOOK", 1, !ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands").isEmpty(), false, "&b&l&nCommands", "&7", "&7*Specify a list of commands to be", "&7executed upon performing a trigger.", "&9&lENABLED: &a" + (!ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands").isEmpty() ? "YES" : "NO")), event -> Menu.altCommandPane(player, null, 4)));
            activePane.addButton(new Button(fillerPaneBItem), 6);
            activePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REPEATER" : "356", 1, false, false, "&a&lSequence", "&7", "&7*The order that the command lines", "&7will be executed in.", "&9&lCOMMANDS-SEQUENCE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.commands-sequence"))), event -> Menu.sequencePane(player, null, 4)));
            activePane.addButton(new Button(fillerPaneBItem));
            activePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&bTriggers", "&7", "&7*This will be the triggers", "&7that will cause the command lines", "&7to execute.", "&9&lENABLED: &a" + (triggers != null && !triggers.isEmpty() && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(triggers, "DISABLE") ? triggers : "FALSE").toUpperCase()), event -> Menu.triggerPane(player, 4)));
            activePane.addButton(new Button(fillerPaneBItem));
            activePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, false, false, "&b&lEnabled Worlds", "&7", "&7*Define the world(s) that the", "&7commands will be executed in.", "&9&lENABLED-WORLDS: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(enabledList).equals("NONE") ? "&a" + enabledList : "NONE")), event -> Menu.worldPane(player, null, 4)));
            activePane.addButton(new Button(fillerPaneBItem), 2);
            activePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
            activePane.addButton(new Button(fillerPaneBItem), 7);
            activePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
        });
        activePane.open(player);
    }

    private static void databasePane(Player player) {
        Interface databasePane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            databasePane.addButton(new Button(fillerPaneBItem), 4);
            databasePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL"), false, "&b&l&nMySQL", "&7", "&7*If the plugin should use a", "&7MySQL connection instead of the", "&7local SQLite database inside", "&7the plugin folder.", "&7", "&c&lNote: &7Keep this set to false", "&7if you do not know what", "&7you are doing.", "&7", "&c&l&nWARNING: &7Changing this value requires", "&7a server restart for the", "&7changes to take affect.", "&9&lENABLED: &a" + String.valueOf(ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL")).toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Database.MySQL", (Object)(!ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL") ? 1 : 0));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(fillerPaneBItem), 4);
            databasePane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&a&lHost", "&7", "&7*Set the &c&lHost &7for", "&7the MySQL database connection.", "&9&lHOST: &a" + ItemJoin.getCore().getConfig("config.yml").getString("Database.host")), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "HOST ADDRESS").with(PlaceHolder.Holder.INPUT_EXAMPLE, "localhost");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "HOST ADDRESS");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Database.host", (Object)ChatColor.stripColor((String)event.getMessage()));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(ItemHandler.getItem("STONE_BUTTON", 1, false, false, "&a&lPort", "&7", "&7*Set the &c&lPort &7for", "&7the MySQL database connection.", "&9&lPORT: &a" + ItemJoin.getCore().getConfig("config.yml").getString("Database.port")), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ADDRESS PORT").with(PlaceHolder.Holder.INPUT_EXAMPLE, "3306");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ADDRESS PORT");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Database.port", (Object)Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(fillerPaneBItem));
            String databaseString = ItemJoin.getCore().getConfig("config.yml").getString("Database.table") != null ? "Database.table" : "Database.database";
            databasePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_WOOD" : "17", 1, false, false, "&a&lTable", "&7", "&7*Set the &c&lTable &7for", "&7the MySQL database connection.", "&9&lTABLE: &a" + ItemJoin.getCore().getConfig("config.yml").getString(databaseString)), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TABLE NAME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "ITEMJOIN_LOCAL");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TABLE NAME");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(databaseString, (Object)ChatColor.stripColor((String)event.getMessage()));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(fillerPaneBItem));
            databasePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&lPrefix", "&7", "&7*Set the &c&lTable &7for", "&7the MySQL database connection.", "&9&lTABLE: &a" + ItemJoin.getCore().getConfig("config.yml").getString("Database.prefix")), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TABLE PREFIX").with(PlaceHolder.Holder.INPUT_EXAMPLE, "IJ_");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TABLE PREFIX");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Database.prefix", (Object)ChatColor.stripColor((String)event.getMessage()));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(fillerPaneBItem));
            databasePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_STAIRS" : "53", 1, false, false, "&a&lUser", "&7", "&7*Set the &c&lUser &7for", "&7the MySQL database connection.", "&9&lUSER: &a***********"), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "USER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "rockinchaos");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "USER");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Database.user", (Object)ChatColor.stripColor((String)event.getMessage()));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&a&lPassword", "&7", "&7*Set the &c&lPassword &7for", "&7the MySQL database connection.", "&9&lPORT: &a****"), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PASSWORD").with(PlaceHolder.Holder.INPUT_EXAMPLE, "cooldude6");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PASSWORD");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Database.pass", (Object)ChatColor.stripColor((String)event.getMessage()));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.databasePane(player));
            }));
            databasePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
            databasePane.addButton(new Button(fillerPaneBItem), 7);
            databasePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the config settings menu."), event -> Menu.configSettings(player)));
        });
        databasePane.open(player);
    }

    private static void triggerPane(Player player, int stage) {
        String triggerOption;
        Interface triggerPane = new Interface(false, 3, exitButton, GUIName, player);
        String string = stage == 4 ? "&7*Executes the commands when the" : (triggerOption = stage == 0 ? "&7*Gives the custom item when the" : "&7*Sets the held item slot when the");
        String triggerString = stage == 4 ? "Active-Commands.triggers" : (stage == 0 ? "Settings.Default-Triggers" : "Settings.HeldItem-Triggers");
        SchedulerUtils.runAsync(() -> {
            ArrayList<String> triggers = new ArrayList<String>();
            try {
                String triggerSet = ItemJoin.getCore().getConfig("config.yml").getString(triggerString);
                if (triggerSet != null && !triggerSet.isEmpty()) {
                    for (String trigger : triggerSet.replace(" ", "").split(",")) {
                        if (trigger.isEmpty()) continue;
                        triggers.add(trigger);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            triggerPane.addButton(new Button(fillerPaneBItem), 3);
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "FILLED_MAP" : "MAP", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-JOIN"), false, "&e&l&nFirst Join", "&7", triggerOption, "&7player logs into the server", "&7for the first time only.", "&7This will overwrite any triggers", "&7such as respawn, and world-switch.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-JOIN") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-JOIN")) {
                    triggers.remove("FIRST-JOIN");
                } else {
                    triggers.add("FIRST-JOIN");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("STONE_SWORD", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-WORLD"), false, "&e&l&nFirst World", "&7", triggerOption, "&7player enters each of the defined", "&7worlds for the first time.", "&7", "&7This flag overwrites any triggers", "&7such as respawn, and join.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-WORLD") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-WORLD")) {
                    triggers.remove("FIRST-WORLD");
                } else {
                    triggers.add("FIRST-WORLD");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "TOTEM_OF_UNDYING" : "322:1", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-LIFE"), false, "&e&l&nFirst Life", "&7", triggerOption, "&7player logs into the server", "&7for the first time only,", "&7but will give the item", "&7EVERY TIME on player RESPAWN.", "&7This flag overwrites any triggers", "&7such as respawn, and join.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-LIFE") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "FIRST-LIFE")) {
                    triggers.remove("FIRST-LIFE");
                } else {
                    triggers.add("FIRST-LIFE");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(fillerPaneBItem), 3);
            triggerPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED"), false, "&c&l&nDISABLED", "&7", "&7*Disables the use of triggers", "&7for this section.", "&7", "&9&lENABLED: &a" + ((me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                    triggers.remove("DISABLE");
                } else if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE") && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.clear();
                    triggers.add("DISABLED");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "JOIN"), false, "&e&l&nJoin", "&7", triggerOption, "&7player logs into the server.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "JOIN") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "JOIN")) {
                    triggers.remove("JOIN");
                } else {
                    triggers.add("JOIN");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "RESPAWN"), false, "&e&l&nRespawn", "&7", triggerOption, "&7player respawns from a death event.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "RESPAWN") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "RESPAWN")) {
                    triggers.remove("RESPAWN");
                } else {
                    triggers.add("RESPAWN");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("STONE_BUTTON", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "WORLD-SWITCH"), false, "&e&l&nWorld Switch", "&7", triggerOption, "&7player teleports to one", "&7of the specified worlds.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "WORLD-SWITCH") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "WORLD-SWITCH")) {
                    triggers.remove("WORLD-SWITCH");
                } else {
                    triggers.add("WORLD-SWITCH");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("LEVER", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "GAMEMODE-SWITCH"), false, "&e&l&nGamemode Switch", "&7", triggerOption, "&7player changes gamemodes to any", "&7of the defined limit-modes.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "GAMEMODE-SWITCH") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "GAMEMODE-SWITCH")) {
                    triggers.remove("GAMEMODE-SWITCH");
                } else {
                    triggers.add("GAMEMODE-SWITCH");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("MINECART", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ENTER"), false, "&e&l&nRegion Enter", "&7", triggerOption, "&7player enters any of the enabled-regions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ENTER") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ENTER")) {
                    triggers.remove("REGION-ENTER");
                } else {
                    triggers.add("REGION-ENTER");
                    triggers.add("REGION-ACCESS");
                    triggers.add("REGION-EGRESS");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "HOPPER_MINECRAFT" : "408", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-LEAVE"), false, "&e&l&nRegion Leave", "&7", triggerOption.replace("Gives", "Removes"), "&7player leaves any of the enabled-regions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-LEAVE") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-LEAVE")) {
                    triggers.remove("REGION-LEAVE");
                } else {
                    triggers.add("REGION-LEAVE");
                    triggers.remove("REGION-ACCESS");
                    triggers.remove("REGION-EGRESS");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "TNT_MINECART" : "407", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ACCESS"), false, "&e&l&nRegion Access", "&7", triggerOption, "&7player enters any of the enabled-regions", "&7and removes the item when leaving", "&7any of the enabled-regions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ACCESS") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-ACCESS")) {
                    triggers.remove("REGION-ACCESS");
                } else {
                    triggers.add("REGION-ACCESS");
                    triggers.remove("REGION-ENTER");
                    triggers.remove("REGION-LEAVE");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CHEST_MINECART" : "342", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-EGRESS"), false, "&e&l&nRegion Egress", "&7", triggerOption.replace("Gives", "Removes"), "&7player enters any of the enabled-regions", "&7and gives the item when leaving", "&7any of the enabled-regions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-EGRESS") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "REGION-EGRESS")) {
                    triggers.remove("REGION-EGRESS");
                } else {
                    triggers.add("REGION-EGRESS");
                    triggers.remove("REGION-ENTER");
                    triggers.remove("REGION-LEAVE");
                }
                if (triggers.isEmpty()) {
                    triggers.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLED")) {
                    triggers.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(triggers, "DISABLE")) {
                    triggers.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set(triggerString, (Object)triggers.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.triggerPane(player, stage));
            }));
            if (stage == 4) {
                triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
            }
            triggerPane.addButton(new Button(fillerPaneBItem), 7);
            if (stage == 4) {
                triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
            }
        });
        triggerPane.open(player);
    }

    private static void preventPane(Player player) {
        Interface preventPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            ArrayList<String> bypassList = new ArrayList<String>();
            String bypassSet = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Bypass");
            if (bypassSet != null) {
                for (String bypass : bypassSet.replace(" ", "").split(",")) {
                    if (bypass.isEmpty()) continue;
                    bypassList.add(bypass);
                }
            }
            preventPane.addButton(new Button(fillerPaneBItem), 3);
            preventPane.addButton(new Button(ItemHandler.getItem(me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "CREATIVE") ? (ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1") : (ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_APPLE" : "322"), 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "CREATIVE"), false, "&bCreative Bypass", "&7", "&7*Players in creative mode", "&7will ignore the prevent actions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "CREATIVE") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "CREATIVE")) {
                    bypassList.remove("CREATIVE");
                } else {
                    bypassList.add("CREATIVE");
                }
                if (bypassList.isEmpty()) {
                    bypassList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "DISABLED")) {
                    bypassList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "DISABLE")) {
                    bypassList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Prevent.Bypass", (Object)bypassList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.preventPane(player));
            }));
            preventPane.addButton(new Button(fillerPaneBItem));
            preventPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "OP"), false, "&bOP Bypass", "&7", "&7*Players that are OP", "&7will ignore the prevent actions.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "OP") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "OP")) {
                    bypassList.remove("OP");
                } else {
                    bypassList.add("OP");
                }
                if (bypassList.isEmpty()) {
                    bypassList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "DISABLED")) {
                    bypassList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(bypassList, "DISABLE")) {
                    bypassList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Prevent.Bypass", (Object)bypassList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.preventPane(player));
            }));
            preventPane.addButton(new Button(fillerPaneBItem), 3);
            String chat = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Chat") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Chat") : "DISABLE";
            String pickups = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Pickups") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Pickups") : "DISABLE";
            String itemMovement = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.itemMovement") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Prevent.itemMovement") : "DISABLE";
            String selfDrops = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Self-Drops") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Self-Drops") : "DISABLE";
            String deathDrops = ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Death-Drops") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Death-Drops") : "DISABLE";
            preventPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&c&l&nPrevent Chat", "&7", "&7*Prevent players from being able", "&7to send chat messages.", "&7", "&7Useful if you are using BungeeChat.", "&9&lENABLED: &a" + (chat != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(chat, "DISABLE") ? chat : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Prevent.Chat")));
            preventPane.addButton(new Button(fillerPaneBItem));
            preventPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&c&l&nPrevent Pickups", "&7", "&7*Prevent players from picking up", "&7ANY items, not just custom items.", "&9&lENABLED: &a" + (pickups != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(pickups, "DISABLE") ? pickups : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Prevent.Pickups")));
            preventPane.addButton(new Button(fillerPaneBItem));
            preventPane.addButton(new Button(ItemHandler.getItem("BEDROCK", 1, false, false, "&c&l&nPrevent Movement", "&7", "&7*Prevent players from moving", "&7ANY items around in their", "&7inventory, not just custom items.", "&9&lENABLED: &a" + (itemMovement != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMovement, "DISABLE") ? itemMovement : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Prevent.itemMovement")));
            preventPane.addButton(new Button(fillerPaneBItem));
            preventPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&c&l&nPrevent Drops", "&7", "&7*Prevent players from dropping", "&7ANY items, not just custom items.", "&9&lENABLED: &a" + (selfDrops != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(selfDrops, "DISABLE") ? selfDrops : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Prevent.Self-Drops")));
            preventPane.addButton(new Button(fillerPaneBItem));
            preventPane.addButton(new Button(ItemHandler.getItem("BONE", 1, false, false, "&c&l&nPrevent Death Drops", "&7", "&7*Prevent players from dropping", "&7ANY items on death, not just custom items.", "&9&lENABLED: &a" + (deathDrops != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(deathDrops, "DISABLE") ? deathDrops : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Prevent.Death-Drops")));
            preventPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
            preventPane.addButton(new Button(fillerPaneBItem), 7);
            preventPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
        });
        preventPane.open(player);
    }

    private static void clearPane(Player player) {
        Interface clearPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            String clearType = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Type");
            if (clearType != null) {
                clearPane.addButton(new Button(fillerPaneBItem), 3);
                clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, clearType.equalsIgnoreCase("ALL"), false, "&bType: &a&lALL", "&7", "&7*ALL items including other plugin(s)", "&7and vanilla items should be cleared", "&7upon performing a trigger.", "&9&lENABLED: &a" + (clearType.equalsIgnoreCase("ALL") + "").toUpperCase()), event -> {
                    if (!clearType.equalsIgnoreCase("ALL")) {
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("Clear-Items.Type", (Object)"ALL");
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.clearPane(player));
                    }
                }));
                clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "DANDELION" : "37", 1, clearType.equalsIgnoreCase("VANILLA"), false, "&bType: &a&lVANILLA", "&7", "&7*Only Vanilla items", "&7NOT (Custom ItemJoin item)", "&7should be cleared upon", "&7performing a trigger.", "&9&lENABLED: &a" + (clearType.equalsIgnoreCase("VANILLA") + "").toUpperCase()), event -> {
                    if (!clearType.equalsIgnoreCase("VANILLA")) {
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("Clear-Items.Type", (Object)"VANILLA");
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.clearPane(player));
                    }
                }));
                clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "33", 1, clearType.equalsIgnoreCase("ITEMJOIN"), false, "&bType: &a&lITEMJOIN", "&7", "&7*Only ItemJoin (custom items)", "&7should be cleared upon", "&7performing a trigger.", "&9&lENABLED: &a" + (clearType.equalsIgnoreCase("ITEMJOIN") + "").toUpperCase()), event -> {
                    if (!clearType.equalsIgnoreCase("ITEMJOIN")) {
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("Clear-Items.Type", (Object)"ITEMJOIN");
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.clearPane(player));
                    }
                }));
                clearPane.addButton(new Button(fillerPaneBItem), 3);
            }
            String join = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Join") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Join") : "DISABLE";
            String quit = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Quit") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Quit") : "DISABLE";
            String worldSwitch = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.World-Switch") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.World-Switch") : "DISABLE";
            String regionEnter = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Region-Enter") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Region-Enter") : "DISABLE";
            String delayTick = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Delay-Tick") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Delay-Tick") : "DISABLE";
            String options = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options") : "DISABLE";
            String blackList = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist") : "DISABLE";
            boolean guardEnabled = ItemJoin.getCore().getDependencies().getGuard().guardEnabled();
            clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&c&l&nJoin", "&7", "&7*Clears the items from the", "&7player upon joining the server.", "&9&lENABLED: &a" + (join != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(join, "DISABLE") ? join : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Clear-Items.Join")));
            clearPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&c&l&nQuit", "&7", "&7*Clears the items from the", "&7player upon quiting the server.", "&9&lENABLED: &a" + (quit != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(quit, "DISABLE") ? quit : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Clear-Items.Quit")));
            clearPane.addButton(new Button(fillerPaneBItem));
            clearPane.addButton(new Button(ItemHandler.getItem("STONE_BUTTON", 1, false, false, "&c&l&nWorld-Switch", "&7", "&7*Clears the items from the", "&7player upon changing worlds.", "&9&lENABLED: &a" + (worldSwitch != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(worldSwitch, "DISABLE") ? worldSwitch : "FALSE").toUpperCase()), event -> Menu.worldPane(player, "Clear-Items.World-Switch")));
            clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "342", 1, false, false, "&b&lClear Delay", "&7", "&7*The number of second(s)", "&7to wait before clearing", "&7items from the player inventory.", "&9&lDelay: &a" + (delayTick != null ? delayTick.toUpperCase() : "0")), event -> Menu.numberPane(player, 3)));
            clearPane.addButton(new Button(ItemHandler.getItem("MINECART", 1, false, false, "&c&l&nRegion-Enter", "&7", "&7*Clears the items from the", "&7player upon entering", "&7a WorldGuard region.", guardEnabled ? "&9&lENABLED: &a" + (regionEnter != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(regionEnter, "DISABLE") ? regionEnter : "FALSE").toUpperCase() : "", guardEnabled ? "" : "&7", guardEnabled ? "" : "&c&lERROR: &7WorldGuard was NOT found.", guardEnabled ? "" : "&7This button will do nothing..."), event -> {
                if (ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
                    Menu.worldPane(player, "Clear-Items.Region-Enter");
                }
            }));
            clearPane.addButton(new Button(fillerPaneBItem));
            clearPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, false, false, "&b&lOptions", "&7", "&7*Actions to apply to", "&7the clear items triggers", "&7such as OP bypass.", "&9&lENABLED: &a" + (options != null && !me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(options, "DISABLE") ? options : "FALSE").toUpperCase()), event -> Menu.optionPane(player)));
            clearPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&b&lBlackList", "&7", "&7*Materials, Slots, or Item Names", "&7to be blacklisted from being", "&7cleared upon performing a trigger.", "&9&lENABLED: &a" + ((blackList != null && !blackList.isEmpty()) + "").toUpperCase()), event -> Menu.blacklistPane(player)));
            clearPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
            clearPane.addButton(new Button(fillerPaneBItem), 7);
            clearPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item settings menu."), event -> Menu.itemSettings(player)));
        });
        clearPane.open(player);
    }

    private static void blacklistPane(Player player) {
        Interface blacklistPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            ArrayList<String> materials = new ArrayList<String>();
            ArrayList<String> slots = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            try {
                String blacklist = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist");
                if (blacklist != null) {
                    for (String value : blacklist.split(",")) {
                        String valType = me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{id") ? "id" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{slot") ? "slot" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{name") ? "name" : ""));
                        String inputResult = StringUtils.substringBetween((String)value, (String)("{" + valType + ":"), (String)"}");
                        if (valType.equalsIgnoreCase("id") && ItemHandler.getMaterial(inputResult.trim(), null) != Material.AIR) {
                            materials.add(inputResult.trim().toUpperCase());
                            continue;
                        }
                        if (valType.equalsIgnoreCase("slot")) {
                            slots.add(inputResult.trim().toUpperCase());
                            continue;
                        }
                        if (!valType.equalsIgnoreCase("name")) continue;
                        names.add(inputResult.trim());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            blacklistPane.addButton(new Button(fillerPaneBItem), 3);
            blacklistPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, false, false, "&b&l&nMaterials", "&7", "&7*The material to be blacklisted", "&7from being cleared.", "&7", "&9&lMaterials: &a" + (!materials.isEmpty() ? me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(((Object)materials).toString().replaceFirst("\\[", ""), "]", "") : "NONE")), event -> Menu.blacklistMatPane(player)));
            blacklistPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLASS" : "20", 1, false, false, "&b&l&nSlots", "&7", "&7*The inventory slots to be", "&7blacklisted from being cleared.", "&7", "&9&lSlots: &a" + (!slots.isEmpty() ? me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(((Object)slots).toString().replaceFirst("\\[", ""), "]", "") : "NONE")), event -> Menu.blacklistSlotPane(player)));
            blacklistPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&b&l&nNames", "&7", "&7*The items display names to", "&7be blacklisted from being cleared.", "&7", "&9&lNames: &a" + (!names.isEmpty() ? me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(((Object)names).toString().replaceFirst("\\[", ""), "]", "") : "NONE")), event -> Menu.blacklistNamePane(player)));
            blacklistPane.addButton(new Button(fillerPaneBItem), 3);
            blacklistPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the clear settings."), event -> Menu.clearPane(player)));
            blacklistPane.addButton(new Button(fillerPaneBItem), 7);
            blacklistPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the clear settings."), event -> Menu.clearPane(player)));
        });
        blacklistPane.open(player);
    }

    private static void blacklistMatPane(Player player) {
        Interface materialPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            materialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blacklist menu."), event -> Menu.blacklistPane(player)));
            ArrayList<String> materials = new ArrayList<String>();
            ArrayList<String> saveList = new ArrayList<String>();
            try {
                String blacklist = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist");
                if (blacklist != null) {
                    for (String string : blacklist.split(",")) {
                        String valType = me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(string, "{id") ? "id" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(string, "{slot") ? "slot" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(string, "{name") ? "name" : ""));
                        String inputResult = StringUtils.substringBetween((String)string, (String)("{" + valType + ":"), (String)"}");
                        if (valType.equalsIgnoreCase("id") && ItemHandler.getMaterial(inputResult.trim(), null) != Material.AIR) {
                            materials.add(inputResult.trim().toUpperCase());
                            continue;
                        }
                        if (valType.equalsIgnoreCase("id") || string.isEmpty()) continue;
                        saveList.add(string.trim());
                    }
                }
            }
            catch (Exception blacklist) {
                // empty catch block
            }
            materialPane.addButton(new Button(ItemHandler.getItem("STICK", 1, true, false, "&b&lBukkit Material", "&7", "&7*If you know the name", "&7of the BUKKIT material type", "&7simply click and type it."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "IRON_SWORD");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null) != Material.AIR) {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(materials, ChatColor.stripColor((String)event.getMessage()))) {
                        materials.add(ChatColor.stripColor((String)event.getMessage()).toUpperCase());
                    } else {
                        materials.remove(ChatColor.stripColor((String)event.getMessage()).toUpperCase());
                    }
                    for (String mat : materials) {
                        saveList.add("{id:" + mat + "}");
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.blacklistMatPane(player));
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noMaterial", (CommandSender)player, placeHolders);
                    Menu.blacklistMatPane(player);
                }
            }));
            Inventory inventoryCheck = Bukkit.getServer().createInventory(null, 9, GUIName);
            for (String string : Material.values()) {
                if (string.name().contains("LEGACY") || string.name().equals("AIR") || !Menu.safeMaterial(ItemHandler.getItem(string.toString(), 1, false, false, "", ""), inventoryCheck)) continue;
                materialPane.addButton(new Button(ItemHandler.getItem(string.toString(), 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(materials, string.name()), false, "", "&7", "&7*Click to set the material.", "&7to be blacklisted from clearing.", "&7", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(materials, string.name()) ? "&a&l&nENABLED: &e&lYES" : ""), arg_0 -> Menu.lambda$blacklistMatPane$257(materials, (Material)string, saveList, player, arg_0)));
            }
            inventoryCheck.clear();
        });
        materialPane.open(player);
    }

    private static void blacklistSlotPane(Player player) {
        Interface slotPane = new Interface(true, 6, exitButton, GUIName, player);
        Interface craftingPane = new Interface(false, 4, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            int slot;
            slotPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blacklist menu."), event -> Menu.blacklistPane(player)));
            ArrayList<String> slots = new ArrayList<String>();
            ArrayList<String> saveList = new ArrayList<String>();
            try {
                String blacklist = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist");
                if (blacklist != null) {
                    for (String value : blacklist.split(",")) {
                        String valType = me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{id") ? "id" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{slot") ? "slot" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{name") ? "name" : ""));
                        String inputResult = StringUtils.substringBetween((String)value, (String)("{" + valType + ":"), (String)"}");
                        if (valType.equalsIgnoreCase("slot")) {
                            slots.add(inputResult.trim().toUpperCase());
                            continue;
                        }
                        if (value.isEmpty()) continue;
                        saveList.add(value.trim());
                    }
                }
            }
            catch (Exception blacklist) {
                // empty catch block
            }
            boolean[] isCrafting = new boolean[5];
            for (String slot2 : slots) {
                if (!ItemHandler.isCraftingSlot(slot2)) continue;
                isCrafting[me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion((String)slot2)] = true;
            }
            craftingPane.addButton(new Button(fillerPaneGItem), 3);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, isCrafting[1], false, "&9&lSlot: &7&lCRAFTING&a&l[1]", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", isCrafting[1] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!isCrafting[1]) {
                    slots.add("CRAFTING[1]");
                } else {
                    slots.remove("CRAFTING[1]");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            craftingPane.addButton(new Button(fillerPaneGItem));
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 2, isCrafting[2], false, "&9&lSlot: &7&lCRAFTING&a&l[2]", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", isCrafting[2] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!isCrafting[2]) {
                    slots.add("CRAFTING[2]");
                } else {
                    slots.remove("CRAFTING[2]");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 10);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, isCrafting[0], false, "&9&lSlot: &7&lCRAFTING&a&l[0]", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", isCrafting[0] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!isCrafting[0]) {
                    slots.add("CRAFTING[0]");
                } else {
                    slots.remove("CRAFTING[0]");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 4);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 3, isCrafting[3], false, "&9&lSlot: &7&lCRAFTING&a&l[3]", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", isCrafting[3] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!isCrafting[3]) {
                    slots.add("CRAFTING[3]");
                } else {
                    slots.remove("CRAFTING[3]");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            craftingPane.addButton(new Button(fillerPaneGItem));
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 4, isCrafting[4], false, "&9&lSlot: &7&lCRAFTING&a&l[4]", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", isCrafting[4] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!isCrafting[4]) {
                    slots.add("CRAFTING[4]");
                } else {
                    slots.remove("CRAFTING[4]");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 3);
            craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the slot blacklist menu"), event -> Menu.blacklistSlotPane(player)));
            craftingPane.addButton(new Button(fillerPaneBItem), 7);
            craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the slot blacklist menu"), event -> Menu.blacklistSlotPane(player)));
            slotPane.addButton(new Button(fillerPaneGItem));
            slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, false, false, "&9&lSlot: &a&lCRAFTING", "&7", "&7*Click to see a list of crafting slots"), event -> craftingPane.open(player)));
            slotPane.addButton(new Button(fillerPaneGItem));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_HELMET", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "HELMET"), false, "&9&lSlot: &a&lHELMET", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "HELMET") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "HELMET")) {
                    slots.add("HELMET");
                } else {
                    slots.remove("HELMET");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_CHESTPLATE", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "CHESTPLATE"), false, "&9&lSlot: &a&lCHESTPLATE", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "CHESTPLATE") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "CHESTPLATE")) {
                    slots.add("CHESTPLATE");
                } else {
                    slots.remove("CHESTPLATE");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_LEGGINGS", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "LEGGINGS"), false, "&9&lSlot: &a&lLEGGINGS", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "LEGGINGS") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "LEGGINGS")) {
                    slots.add("LEGGINGS");
                } else {
                    slots.remove("LEGGINGS");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_BOOTS", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "BOOTS"), false, "&9&lSlot: &a&lBOOTS", "&7", "&7*Click to prevent this slot", "&7from having its items cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "BOOTS") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "BOOTS")) {
                    slots.add("BOOTS");
                } else {
                    slots.remove("BOOTS");
                }
                for (String slot : slots) {
                    saveList.add("{slot:" + slot + "}");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
            }));
            if (ServerUtils.hasSpecificUpdate("1_9")) {
                slotPane.addButton(new Button(ItemHandler.getItem("SHIELD", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "OFFHAND"), false, "&9&lSlot: &a&lOFFHAND", "&7", "&7*Click to prevent this slot", "&7from having its item cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "OFFHAND") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, "OFFHAND")) {
                        slots.add("OFFHAND");
                    } else {
                        slots.remove("OFFHAND");
                    }
                    for (String slot : slots) {
                        saveList.add("{slot:" + slot + "}");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
                }));
            } else {
                slotPane.addButton(new Button(fillerPaneGItem));
            }
            slotPane.addButton(new Button(fillerPaneGItem));
            for (int i = 9; i < 36; ++i) {
                slot = i;
                slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:3", i, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot)), false, "&9&lSlot: &a&l" + i, "&7", "&7*Click to prevent this slot", "&7from having its item cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot)) ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot))) {
                        slots.add(String.valueOf(slot));
                    } else {
                        slots.remove(String.valueOf(slot));
                    }
                    for (String slotS : slots) {
                        saveList.add("{slot:" + slotS + "}");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
                }));
            }
            for (int j = 0; j < 9; ++j) {
                slot = j;
                int count = j;
                if (slot == 0) {
                    count = 1;
                }
                slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", count, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot)), false, "&9&lSlot: &a&l" + j, "&7", "&7*Click to prevent this slot", "&7from having its item cleared.", me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot)) ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(slots, String.valueOf(slot))) {
                        slots.add(String.valueOf(slot));
                    } else {
                        slots.remove(String.valueOf(slot));
                    }
                    for (String slotS : slots) {
                        saveList.add("{slot:" + slotS + "}");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.blacklistSlotPane(player));
                }));
            }
            slotPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blacklist menu."), event -> Menu.blacklistPane(player)));
            slotPane.addButton(new Button(fillerPaneBItem), 7);
            slotPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blacklist menu."), event -> Menu.blacklistPane(player)));
        });
        slotPane.open(player);
    }

    private static void blacklistNamePane(Player player) {
        Interface namePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            namePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blacklist menu."), event -> Menu.blacklistPane(player)));
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> saveList = new ArrayList<String>();
            try {
                String blacklist = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Blacklist");
                if (blacklist != null) {
                    for (String value : blacklist.split(",")) {
                        String valType = me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{id") ? "id" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{slot") ? "slot" : (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(value, "{name") ? "name" : ""));
                        String inputResult = StringUtils.substringBetween((String)value, (String)("{" + valType + ":"), (String)"}");
                        if (valType.equalsIgnoreCase("name")) {
                            names.add(inputResult.trim().toUpperCase());
                            continue;
                        }
                        if (value.isEmpty()) continue;
                        saveList.add(value.trim());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            namePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&b&lAdd Name", "&7", "&7*Add an items display", "&7name to be blacklisted", "&7simply click and type it.", "&7", "&c&l&nNOTE:&7 Do NOT include any", "&7color codes as these are excluded."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ITEM NAME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "ULTRA ITEM");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(names, ChatColor.stripColor((String)event.getMessage()))) {
                    names.add(ChatColor.stripColor((String)event.getMessage()));
                } else {
                    names.remove(ChatColor.stripColor((String)event.getMessage()));
                }
                for (String name : names) {
                    saveList.add("{name:" + name + "}");
                }
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ITEM NAME");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.blacklistNamePane(player));
            }));
            for (String itemName : names) {
                namePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&f" + itemName, "&7", "&7*Click to remove this item name", "&7from the clearing blacklist.", "&7", "&c&l&nNOTE:&7 Do NOT include any", "&7color codes as these are excluded."), event -> {
                    names.remove(itemName);
                    for (String name : names) {
                        saveList.add("{name:" + name + "}");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.blacklistNamePane(player));
                }));
            }
        });
        namePane.open(player);
    }

    private static void optionPane(Player player) {
        Interface optionPane = new Interface(false, 2, exitButton, GUIName, player);
        ArrayList<String> optionList = new ArrayList<String>();
        String options = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items.Options");
        if (options != null) {
            for (String option : options.replace(" ", "").split(",")) {
                if (option.isEmpty()) continue;
                optionList.add(option);
            }
        }
        SchedulerUtils.runAsync(() -> {
            optionPane.addButton(new Button(ItemHandler.getItem("DIAMOND_CHESTPLATE", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT"), false, "&e&lProtect", "&7", "&7*Prevents ALL players from", "&7having their first-join and", "&7first-world items cleared.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT")) {
                    optionList.remove("PROTECT");
                } else {
                    optionList.add("PROTECT");
                }
                if (optionList.isEmpty()) {
                    optionList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLED")) {
                    optionList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLE")) {
                    optionList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Options", (Object)optionList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.optionPane(player));
            }));
            optionPane.addButton(new Button(fillerPaneBItem));
            optionPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_OP"), false, "&e&lProtect OP", "&7", "&7*Prevents OP players from", "&7having their first-join and", "&7first-world items cleared.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_OP") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_OP")) {
                    optionList.remove("PROTECT_OP");
                } else {
                    optionList.add("PROTECT_OP");
                }
                if (optionList.isEmpty()) {
                    optionList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLED")) {
                    optionList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLE")) {
                    optionList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Options", (Object)optionList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.optionPane(player));
            }));
            optionPane.addButton(new Button(fillerPaneBItem));
            optionPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_APPLE" : "322", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_CREATIVE"), false, "&e&lProtect Creative", "&7", "&7*Prevents players in creative mode", "&7from having their first-join", "&7and first-world items cleared.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_CREATIVE") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "PROTECT_CREATIVE")) {
                    optionList.remove("PROTECT_CREATIVE");
                } else {
                    optionList.add("PROTECT_CREATIVE");
                }
                if (optionList.isEmpty()) {
                    optionList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLED")) {
                    optionList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLE")) {
                    optionList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Options", (Object)optionList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.optionPane(player));
            }));
            optionPane.addButton(new Button(fillerPaneBItem));
            optionPane.addButton(new Button(ItemHandler.getItem("GOLD_BLOCK", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN") && ItemJoin.getCore().getDependencies().getGuard().guardEnabled(), false, "&e&lReturn Regions", "&7*Returns the cleared player inventory", "&7when exiting a cleared region", "&7or entering a region which is", "&7not listed as clearable.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN") ? "true" : "false") : "", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&c&lERROR: &7WorldGuard was NOT found.", ItemJoin.getCore().getDependencies().getGuard().guardEnabled() ? "" : "&7This button will do nothing..."), event -> {
                if (ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN")) {
                        optionList.remove("RETURN");
                    } else {
                        optionList.add("RETURN");
                    }
                    if (optionList.isEmpty()) {
                        optionList.add("DISABLED");
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLED")) {
                        optionList.remove("DISABLED");
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLE")) {
                        optionList.remove("DISABLE");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Clear-Items.Options", (Object)optionList.toString().replace("[", "").replace("]", ""));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.optionPane(player));
                }
            }));
            optionPane.addButton(new Button(fillerPaneBItem));
            optionPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN_SWITCH"), false, "&e&lReturn Worlds", "&7", "&7*Returns the prior cleared", "&7player inventory from the", "&7prior world upon returning", "&7to that prior world.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN_SWITCH") + "").toUpperCase()), event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "RETURN_SWITCH")) {
                    optionList.remove("RETURN_SWITCH");
                } else {
                    optionList.add("RETURN_SWITCH");
                }
                if (optionList.isEmpty()) {
                    optionList.add("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLED")) {
                    optionList.remove("DISABLED");
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(optionList, "DISABLE")) {
                    optionList.remove("DISABLE");
                }
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                dataFile.set("Clear-Items.Options", (Object)optionList.toString().replace("[", "").replace("]", ""));
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.optionPane(player));
            }));
            optionPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the clear settings."), event -> Menu.clearPane(player)));
            optionPane.addButton(new Button(fillerPaneBItem), 7);
            optionPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the clear settings."), event -> Menu.clearPane(player)));
        });
        optionPane.open(player);
    }

    private static void worldPane(Player player, String section) {
        Interface preventPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            preventPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the prevent menu."), event -> {
                if (section.contains("Prevent")) {
                    Menu.preventPane(player);
                } else {
                    Menu.clearPane(player);
                }
            }));
            ArrayList<String> enabledWorlds = new ArrayList<String>();
            String configSection = ItemJoin.getCore().getConfig("config.yml").getString(section);
            String[] enabledParts = configSection != null ? configSection.replaceAll("\\s*,\\s*", ",").split(",") : new String[1];
            for (String enabledWorld : enabledParts) {
                if (enabledWorld != null && (enabledWorld.equalsIgnoreCase("ALL") || enabledWorld.equalsIgnoreCase("GLOBAL"))) {
                    enabledWorlds.add("ALL");
                    continue;
                }
                if (enabledWorld == null) continue;
                for (World world : Bukkit.getServer().getWorlds()) {
                    if (!enabledWorld.equalsIgnoreCase(world.getName())) continue;
                    enabledWorlds.add(world.getName());
                }
            }
            if (enabledWorlds.isEmpty() && ItemJoin.getCore().getConfig("config.yml").getBoolean(section)) {
                enabledWorlds.add("ALL");
            }
            preventPane.addButton(new Button(ItemHandler.getItem("OBSIDIAN", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL"), false, "&a&l&nGLOBAL", "&7", "&7*Click to enable &lALL WORLDS.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL") + "").toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL")) {
                    dataFile.set(section, (Object)false);
                } else {
                    dataFile.set(section, (Object)true);
                }
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.worldPane(player, section));
            }));
            for (World world : Bukkit.getServer().getWorlds()) {
                String worldMaterial;
                String string = worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2";
                if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                    worldMaterial = "NETHERRACK";
                } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                    worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "END_STONE" : "121";
                }
                preventPane.addButton(new Button(ItemHandler.getItem(worldMaterial, 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName()), false, "&f&l" + world.getName(), "&7", "&7*Click to enable this world.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName()) + "").toUpperCase()), event -> {
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName())) {
                        enabledWorlds.remove(world.getName());
                    } else {
                        enabledWorlds.add(world.getName());
                    }
                    if (!enabledWorlds.isEmpty() && enabledWorlds.size() > 1) {
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL")) {
                            enabledWorlds.remove("ALL");
                        } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "GLOBAL")) {
                            enabledWorlds.remove("GLOBAL");
                        }
                    }
                    StringBuilder worldList = new StringBuilder();
                    for (String worldName : enabledWorlds) {
                        worldList.append(worldName).append(", ");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    if (enabledWorlds.isEmpty()) {
                        dataFile.set(section, (Object)false);
                    } else {
                        dataFile.set(section, (Object)worldList.substring(0, worldList.length() - 2));
                    }
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.worldPane(player, section));
                }));
            }
        });
        preventPane.open(player);
    }

    private static void overwritePane(Player player) {
        Interface overwritePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            overwritePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the configuration menu."), event -> Menu.itemSettings(player)));
            ArrayList<String> enabledWorlds = new ArrayList<String>();
            String overwrite = ItemJoin.getCore().getConfig("items.yml").getString("items-Overwrite");
            if (overwrite != null) {
                String[] enabledParts;
                for (String enabledWorld : enabledParts = overwrite.replaceAll("\\s*,\\s*", ",").split(",")) {
                    if (enabledWorld.equalsIgnoreCase("ALL") || enabledWorld.equalsIgnoreCase("GLOBAL")) {
                        enabledWorlds.add("ALL");
                        continue;
                    }
                    for (World world : Bukkit.getServer().getWorlds()) {
                        if (!enabledWorld.equalsIgnoreCase(world.getName())) continue;
                        enabledWorlds.add(world.getName());
                    }
                }
            }
            if (enabledWorlds.isEmpty() && ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Overwrite")) {
                enabledWorlds.add("ALL");
            }
            overwritePane.addButton(new Button(ItemHandler.getItem("OBSIDIAN", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL"), false, "&a&l&nGLOBAL", "&7", "&7*Click to enable item", "&7overwriting in &lALL WORLDS.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL") + "").toUpperCase()), event -> {
                File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
                YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL")) {
                    dataFile.set("items-Overwrite", (Object)false);
                } else {
                    dataFile.set("items-Overwrite", (Object)true);
                }
                ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "items.yml");
                PluginData.getInfo().softReload();
                SchedulerUtils.runLater(2L, () -> Menu.overwritePane(player));
            }));
            for (World world : Bukkit.getServer().getWorlds()) {
                String worldMaterial;
                String string = worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2";
                if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                    worldMaterial = "NETHERRACK";
                } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                    worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "END_STONE" : "121";
                }
                overwritePane.addButton(new Button(ItemHandler.getItem(worldMaterial, 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName()), false, "&f&l" + world.getName(), "&7", "&7*Click to enable item", "&7overwriting in this world.", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName()) + "").toUpperCase()), event -> {
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, world.getName())) {
                        enabledWorlds.remove(world.getName());
                    } else {
                        enabledWorlds.add(world.getName());
                    }
                    if (!enabledWorlds.isEmpty() && enabledWorlds.size() > 1) {
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "ALL")) {
                            enabledWorlds.remove("ALL");
                        } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(enabledWorlds, "GLOBAL")) {
                            enabledWorlds.remove("GLOBAL");
                        }
                    }
                    StringBuilder worldList = new StringBuilder();
                    for (String worldName : enabledWorlds) {
                        worldList.append(worldName).append(", ");
                    }
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    if (enabledWorlds.isEmpty()) {
                        dataFile.set("items-Overwrite", (Object)false);
                    } else {
                        dataFile.set("items-Overwrite", (Object)worldList.substring(0, worldList.length() - 2));
                    }
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "items.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.overwritePane(player));
                }));
            }
        });
        overwritePane.open(player);
    }

    private static boolean safeMaterial(ItemStack item, Inventory inventoryCheck) {
        inventoryCheck.setItem(0, item);
        ItemStack getItem = inventoryCheck.getItem(0);
        return getItem != null && !getItem.getType().name().equals("AIR");
    }

    private static void materialPane(Player player, ItemMap itemMap, int stage, int position) {
        Interface materialPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 0 && stage != 2 && stage != 3) {
                materialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            } else if (stage == 2) {
                materialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the commands menu."), event -> Menu.commandPane(player, itemMap)));
            } else if (stage == 3) {
                materialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the recipe menu."), event -> Menu.recipePane(player, itemMap)));
            }
            materialPane.addButton(new Button(ItemHandler.getItem("STICK", 1, true, false, "&b&lBukkit Material", "&7", "&7*If you know the name", "&7of the BUKKIT material type", "&7simply click and type it."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 2 ? "ITEM COST" : "BUKKIT MATERIAL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "IRON_SWORD");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ItemHandler.getMaterial(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]), null) != Material.AIR) {
                    if (stage == 2) {
                        itemMap.setItemCost(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]).toUpperCase());
                    } else if (stage != 3) {
                        String[] dataValue;
                        itemMap.setMaterial(ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null));
                        if (!ServerUtils.hasSpecificUpdate("1_13") && ChatColor.stripColor((String)event.getMessage()).contains(":") && me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout((dataValue = ChatColor.stripColor((String)event.getMessage()).split(":"))[1], player, new PlaceHolder[0]))) {
                            itemMap.setDataValue((short)Integer.parseInt(dataValue[1]));
                        }
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 2 ? "ITEM COST" : "BUKKIT MATERIAL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    if (stage == 3) {
                        Menu.setIngredients(event.getPlayer(), itemMap, Objects.requireNonNull(ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null)).name(), position);
                    } else if (stage == 2) {
                        Menu.commandPane(event.getPlayer(), itemMap);
                    } else {
                        Menu.creatingPane(event.getPlayer(), itemMap);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noMaterial", (CommandSender)player, placeHolders);
                    Menu.materialPane(player, itemMap, stage, position);
                }
            }));
            Inventory inventoryCheck = Bukkit.getServer().createInventory(null, 9, GUIName);
            for (Material material : Material.values()) {
                if (material.name().contains("LEGACY") || material.name().equals("AIR") || !Menu.safeMaterial(ItemHandler.getItem(material.toString(), 1, false, false, "", ""), inventoryCheck)) continue;
                if (!ServerUtils.hasSpecificUpdate("1_13") && LegacyAPI.getDataValue(material) != 0) {
                    for (int i = 0; i <= LegacyAPI.getDataValue(material); ++i) {
                        if (material.toString().equalsIgnoreCase("STEP") && (!material.toString().equalsIgnoreCase("STEP") || i == 2)) continue;
                        int dataValue = i;
                        materialPane.addButton(new Button(ItemHandler.getItem(material + ":" + dataValue, 1, false, false, "", "&7", "&7*Click to set the material."), event -> {
                            if (stage == 2) {
                                itemMap.setItemCost(material.toString());
                            } else if (stage != 3) {
                                itemMap.setMaterial(material);
                                if (dataValue != 0) {
                                    itemMap.setDataValue((short)dataValue);
                                }
                            }
                            if (stage == 0) {
                                Menu.switchPane(player, itemMap, 0);
                            } else if (stage == 2) {
                                Menu.commandPane(player, itemMap);
                            } else if (stage == 3) {
                                Menu.setIngredients(player, itemMap, material.name(), position);
                            } else {
                                Menu.creatingPane(player, itemMap);
                            }
                        }));
                    }
                    continue;
                }
                materialPane.addButton(new Button(ItemHandler.getItem(material.toString(), 1, false, false, "", "&7", "&7*Click to set the material."), event -> {
                    if (stage == 2) {
                        itemMap.setItemCost(material.toString());
                    } else if (stage != 3) {
                        itemMap.setMaterial(material);
                    }
                    if (stage == 0) {
                        Menu.switchPane(player, itemMap, 0);
                    } else if (stage == 2) {
                        Menu.commandPane(player, itemMap);
                    } else if (stage == 3) {
                        Menu.setIngredients(player, itemMap, material.name(), position);
                    } else {
                        Menu.creatingPane(player, itemMap);
                    }
                }));
            }
            inventoryCheck.clear();
        });
        materialPane.open(player);
    }

    private static void switchPane(Player player, ItemMap itemMap, int stage) {
        Interface switchPane = new Interface(false, 1, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage == 0) {
                switchPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the material selection menu."), event -> Menu.materialPane(player, itemMap, 0, 0)));
            } else {
                switchPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            }
            switchPane.addButton(new Button(fillerPaneBItem), 2);
            switchPane.addButton(new Button(ItemHandler.getItem("GLASS", 1, false, false, "&a&lSingle Slot", "&7", "&7*Define a single dedicated", "&7 slot for the item."), event -> Menu.slotPane(player, itemMap, stage, 0)));
            switchPane.addButton(new Button(fillerPaneBItem), 1);
            switchPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "DISPENSER" : "23", 1, false, false, "&b&lMultiple Slots", "&7", "&7*Define multiple slots for the item."), event -> Menu.slotPane(player, itemMap, stage, 1)));
            switchPane.addButton(new Button(fillerPaneBItem), 2);
            if (stage == 0) {
                switchPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the material selection menu."), event -> Menu.materialPane(player, itemMap, 0, 0)));
            } else {
                switchPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            }
        });
        switchPane.open(player);
    }

    private static void slotPane(Player player, ItemMap itemMap, int stage, int type) {
        Interface slotPane = new Interface(false, 6, exitButton, GUIName, player);
        Interface craftingPane = new Interface(false, 4, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            boolean[] isCrafting = new boolean[5];
            for (String slot : itemMap.getMultipleSlots()) {
                if (!ItemHandler.isCraftingSlot(slot)) continue;
                isCrafting[me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion((String)slot)] = true;
            }
            craftingPane.addButton(new Button(fillerPaneGItem), 3);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, type > 0 && isCrafting[1], false, "&9&lSlot: &7&lCRAFTING&a&l[1]", "&7", "&7*Click to set the custom item", "&7to appear in the &lCRAFTING &7slot &a&l[1]&7", type > 0 && isCrafting[1] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CRAFTING[1]");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (isCrafting[1]) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.removeIf(slot -> ItemHandler.isCraftingSlot(slot) && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(slot) == 1);
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CRAFTING[1]");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                }
            }));
            craftingPane.addButton(new Button(fillerPaneGItem));
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 2, type > 0 && isCrafting[2], false, "&9&lSlot: &7&lCRAFTING&a&l[2]", "&7", "&7*Click to set the custom item", "&7to appear in the &lCRAFTING &7slot &a&l[2]&7", type > 0 && isCrafting[2] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CRAFTING[2]");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (isCrafting[2]) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.removeIf(slot -> ItemHandler.isCraftingSlot(slot) && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(slot) == 2);
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CRAFTING[2]");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                }
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 10);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, type > 0 && isCrafting[0], false, "&9&lSlot: &7&lCRAFTING&a&l[0]", "&7", "&7*Click to set the custom item", "&7to appear in the &lCRAFTING &7slot &a&l[0]&7", type > 0 && isCrafting[0] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CRAFTING[0]");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (isCrafting[0]) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.removeIf(slot -> ItemHandler.isCraftingSlot(slot) && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(slot) == 0);
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CRAFTING[0]");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                }
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 4);
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 3, type > 0 && isCrafting[3], false, "&9&lSlot: &7&lCRAFTING&a&l[3]", "&7", "&7*Click to set the custom item", "&7to appear in the &lCRAFTING &7slot &a&l[3]&7", type > 0 && isCrafting[3] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CRAFTING[3]");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (isCrafting[3]) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.removeIf(slot -> ItemHandler.isCraftingSlot(slot) && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(slot) == 3);
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CRAFTING[3]");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                }
            }));
            craftingPane.addButton(new Button(fillerPaneGItem));
            craftingPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 4, type > 0 && isCrafting[4], false, "&9&lSlot: &7&lCRAFTING&a&l[4]", "&7", "&7*Click to set the custom item", "&7to appear in the &lCRAFTING &7slot &a&l[4]&7", type > 0 && isCrafting[4] ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CRAFTING[4]");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (isCrafting[4]) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.removeIf(slot -> ItemHandler.isCraftingSlot(slot) && me.RockinChaos.itemjoin.core.utils.StringUtils.getSlotConversion(slot) == 4);
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CRAFTING[4]");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 2);
                }
            }));
            craftingPane.addButton(new Button(fillerPaneGItem), 3);
            craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the main slot selection menu"), event -> slotPane.open(player)));
            if (type > 0) {
                craftingPane.addButton(new Button(fillerPaneBItem), 3);
                craftingPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&a&lFinish Selecting", "&7", "&7*Saves the chosen slots", "&7to the item definition."), event -> Menu.creatingPane(player, itemMap)));
                craftingPane.addButton(new Button(fillerPaneBItem), 3);
            } else {
                craftingPane.addButton(new Button(fillerPaneBItem), 7);
            }
            craftingPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the main slot selection menu"), event -> slotPane.open(player)));
            slotPane.addButton(new Button(fillerPaneGItem));
            slotPane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "ARBITRARY"), false, "&9&lSlot: &a&lARBITRARY", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lArbitrary&7", "&7", "&7*Arbitrary is defined as giving the", "&7item in the first available slot.", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "ARBITRARY") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("ARBITRARY");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "ARBITRARY")) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.remove("ARBITRARY");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("ARBITRARY");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                }
            }));
            slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, false, false, "&9&lSlot: &a&lCRAFTING", "&7", "&7*Click to see a list of crafting slots"), event -> craftingPane.open(player)));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_HELMET", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "HELMET"), false, "&9&lSlot: &a&lHELMET", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lHELMET&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "HELMET") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("HELMET");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "HELMET")) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.remove("HELMET");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("HELMET");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                }
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_CHESTPLATE", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "CHESTPLATE"), false, "&9&lSlot: &a&lCHESTPLATE", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lCHESTPLATE&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "CHESTPLATE") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("CHESTPLATE");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "CHESTPLATE")) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.remove("CHESTPLATE");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("CHESTPLATE");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                }
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_LEGGINGS", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "LEGGINGS"), false, "&9&lSlot: &a&lLEGGINGS", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lLEGGINGS&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "LEGGINGS") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("LEGGINGS");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "LEGGINGS")) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.remove("LEGGINGS");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("LEGGINGS");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                }
            }));
            slotPane.addButton(new Button(ItemHandler.getItem("LEATHER_BOOTS", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "BOOTS"), false, "&9&lSlot: &a&lBOOTS", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lBOOTS&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "BOOTS") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                if (type == 0) {
                    itemMap.setSlot("BOOTS");
                    itemMap.setMultipleSlots(new ArrayList<String>());
                    Menu.creatingPane(player, itemMap);
                } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "BOOTS")) {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.remove("BOOTS");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                } else {
                    List<String> slots = itemMap.getMultipleSlots();
                    slots.add("BOOTS");
                    itemMap.setMultipleSlots(slots);
                    Menu.slotPane(player, itemMap, stage, 1);
                }
            }));
            if (ServerUtils.hasSpecificUpdate("1_9")) {
                slotPane.addButton(new Button(ItemHandler.getItem("SHIELD", 1, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "OFFHAND"), false, "&9&lSlot: &a&lOFFHAND", "&7", "&7*Click to set the custom item", "&7to appear in slot &a&lOFFHAND&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "OFFHAND") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (type == 0) {
                        itemMap.setSlot("OFFHAND");
                        itemMap.setMultipleSlots(new ArrayList<String>());
                        Menu.creatingPane(player, itemMap);
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), "OFFHAND")) {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.remove("OFFHAND");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    } else {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.add("OFFHAND");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    }
                }));
            } else {
                slotPane.addButton(new Button(fillerPaneGItem));
            }
            slotPane.addButton(new Button(fillerPaneGItem));
            for (int i = 9; i < 36; ++i) {
                int slot = i;
                slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:3", i, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + ""), false, "&9&lSlot: &a&l" + i, "&7", "&7*Click to set the custom item", "&7to appear in slot &a&l" + i + "&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + "") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (type == 0) {
                        itemMap.setSlot(slot + "");
                        itemMap.setMultipleSlots(new ArrayList<String>());
                        Menu.creatingPane(player, itemMap);
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + "")) {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.remove(slot + "");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    } else {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.add(slot + "");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    }
                }));
            }
            for (int j = 0; j < 9; ++j) {
                int slot = j;
                int count = j;
                if (slot == 0) {
                    count = 1;
                }
                slotPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", count, type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + ""), false, "&9&lSlot: &a&l" + j, "&7", "&7*Click to set the custom item", "&7to appear in slot &a&l" + j + "&7", type > 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + "") ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (type == 0) {
                        itemMap.setSlot(slot + "");
                        itemMap.setMultipleSlots(new ArrayList<String>());
                        Menu.creatingPane(player, itemMap);
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getMultipleSlots(), slot + "")) {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.remove(slot + "");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    } else {
                        List<String> slots = itemMap.getMultipleSlots();
                        slots.add(slot + "");
                        itemMap.setMultipleSlots(slots);
                        Menu.slotPane(player, itemMap, stage, 1);
                    }
                }));
            }
            slotPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the slot(s) selection menu."), event -> Menu.switchPane(player, itemMap, stage)));
            if (type > 0) {
                slotPane.addButton(new Button(fillerPaneBItem), 3);
                slotPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&a&lFinish Selecting", "&7", "&7*Saves the chosen slots", "&7to the item definition."), event -> Menu.creatingPane(player, itemMap)));
                slotPane.addButton(new Button(fillerPaneBItem), 3);
            } else {
                slotPane.addButton(new Button(fillerPaneBItem), 7);
            }
            slotPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you back to", "&7the slot(s) selection menu."), event -> Menu.switchPane(player, itemMap, stage)));
        });
        if (type == 2) {
            craftingPane.open(player);
        } else {
            slotPane.open(player);
        }
    }

    private static void countPane(Player player, ItemMap itemMap, int type) {
        Interface countPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            countPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the " + (type == 0 ? "item definition" : "model components") + " menu."), event -> {
                if (type == 0) {
                    Menu.creatingPane(player, itemMap);
                } else if (type == 1) {
                    Menu.modelComponentsPane(player, itemMap);
                }
            }));
            countPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom " + (type == 0 ? "Count" : "Float"), "&7", "&7*Click to set a custom " + (type == 0 ? "count" : "model components float"), "&7value for the item.", "&7", "&c&lNote: &7You can use placeholders", "&7as long as they parse to a number."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, type == 0 ? "ITEM COUNT" : "COMPONENTS FLOAT").with(PlaceHolder.Holder.INPUT_EXAMPLE, "48");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                String count = ChatColor.stripColor((String)event.getMessage());
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, count);
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(count)) {
                    if (type == 0) {
                        itemMap.setCount(count);
                    } else if (type == 1) {
                        ArrayList<Float> floats = new ArrayList<Float>();
                        if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null) {
                            for (String _float : itemMap.getModelComponents().get(3).replaceAll("\\s*,\\s*", ",").split(",")) {
                                try {
                                    floats.add(Float.valueOf(Float.parseFloat(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(_float, player, new PlaceHolder[0]).toUpperCase())));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (floats.contains(Float.valueOf(count))) {
                            floats.remove(Float.valueOf(count));
                        } else {
                            floats.add(Float.valueOf(count));
                        }
                        List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                        modelComponents.set(3, floats.stream().map(String::valueOf).collect(Collectors.joining(", ")));
                        itemMap.setModelComponents(modelComponents);
                        Menu.countPane(player, itemMap, type);
                    }
                    PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.INPUT, type == 0 ? "ITEM COUNT" : "COMPONENTS FLOAT");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolder);
                } else if (count.contains("%")) {
                    String translateCount = me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(count, player, new PlaceHolder[0]).replaceAll("[^\\d.]", "").replace("-", "").replace(".", "").replace(" ", "");
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(translateCount)) {
                        if (type == 0) {
                            itemMap.setCount(count);
                        } else if (type == 1) {
                            String floats = itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null ? itemMap.getModelComponents().get(3) : "";
                            List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                            modelComponents.set(3, (floats.isEmpty() ? ", " : "") + count);
                            itemMap.setModelComponents(modelComponents);
                            Menu.countPane(player, itemMap, type);
                        }
                        PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.INPUT, type == 0 ? "ITEM COUNT" : "COMPONENTS FLOAT");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolder);
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    }
                } else {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                if (type == 0) {
                    Menu.creatingPane(event.getPlayer(), itemMap);
                } else if (type == 1) {
                    Menu.countPane(event.getPlayer(), itemMap, type);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                boolean typeEnabled = type == 1 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null ? Arrays.asList(itemMap.getModelComponents().get(3).replaceAll("\\s*,\\s*", ",").split(",")) : new ArrayList(), Float.valueOf(k) + "");
                countPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, typeEnabled, false, "&9&l" + (type == 0 ? "Count" : "Float") + ": &a&l" + k, "&7", "&7*Click to set the", "&7" + (type == 0 ? "count" : "model components float") + " of the item.", typeEnabled ? "&7" : "", typeEnabled ? "&9&lENABLED: &aTRUE" : ""), event -> {
                    if (type == 0) {
                        itemMap.setCount(k + "");
                        Menu.creatingPane(player, itemMap);
                    } else if (type == 1) {
                        ArrayList<Float> floats = new ArrayList<Float>();
                        if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null) {
                            for (String _float : itemMap.getModelComponents().get(3).replaceAll("\\s*,\\s*", ",").split(",")) {
                                try {
                                    floats.add(Float.valueOf(Float.parseFloat(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(_float, player, new PlaceHolder[0]).toUpperCase())));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (floats.contains(Float.valueOf(k))) {
                            floats.remove(Float.valueOf(k));
                        } else {
                            floats.add(Float.valueOf(k));
                        }
                        List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                        modelComponents.set(3, floats.stream().map(String::valueOf).collect(Collectors.joining(", ")));
                        itemMap.setModelComponents(modelComponents);
                        Menu.countPane(player, itemMap, type);
                    }
                }));
            }
        });
        countPane.open(player);
    }

    private static void dataPane(Player player, ItemMap itemMap) {
        Interface dataPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            dataPane.addButton(new Button(fillerPaneBItem));
            dataPane.addButton(new Button(ItemHandler.setDurability(ItemHandler.getItem("BOW", 1, false, false, "&b&lDamage", "&7", "&7*Set the damage of the item.", itemMap.getMaterial().getMaxDurability() != 0 ? "&9&lDURABILITY: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDurability() + "&7") : "&c&lERROR: &7This item is NOT damageable."), 50), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDurability() + "&7").equals("NONE")) {
                    itemMap.setDurability(null);
                    Menu.dataPane(player, itemMap);
                } else if (itemMap.getMaterial().getMaxDurability() != 0) {
                    Menu.damagePane(player, itemMap);
                }
            }));
            dataPane.addButton(new Button(fillerPaneBItem));
            dataPane.addButton(new Button(ItemHandler.getItem("STICK", 1, false, false, "&a&lDamage Data", "&7", "&7*Set the custom data of the item.", "&7This is the damage value assigned", "&7to the custom resource texture.", ServerUtils.hasSpecificUpdate("1_14") ? "&7" : "", ServerUtils.hasSpecificUpdate("1_14") ? "&c&l&nWARNING:&e This setting is only for" : "", ServerUtils.hasSpecificUpdate("1_14") ? "&eMinecraft versions below 1.14." : "", ServerUtils.hasSpecificUpdate("1_14") ? "&eYou are using a newer version of Minecraft" : "", ServerUtils.hasSpecificUpdate("1_14") ? "&eso things may not function as expected." : "", ServerUtils.hasSpecificUpdate("1_14") ? "&7" : "", ServerUtils.hasSpecificUpdate("1_14") ? "&eIt is highly recommended to use &l&nModel Data." : "", "&9&lDAMAGE DATA: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getData() + "&7")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getData() + "&7").equals("NONE")) {
                    itemMap.setData(null);
                    Menu.dataPane(player, itemMap);
                } else {
                    Menu.durabilityDataPane(player, itemMap);
                }
            }));
            dataPane.addButton(new Button(fillerPaneBItem));
            dataPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&e&lModel Data", "&7", "&7*Set the custom model data of the item.", "&7This is the custom texture.", !ServerUtils.hasSpecificUpdate("1_14") ? "&c&l[ERROR] &7This version of Minecraft does" : "", !ServerUtils.hasSpecificUpdate("1_14") ? "&7not support custom model data." : "", !ServerUtils.hasSpecificUpdate("1_14") ? "&7This was implemented in 1.14+." : "", "&9&lMODEL DATA: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelData() + "&7")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelData() + "&7").equals("NONE") && ServerUtils.hasSpecificUpdate("1_14")) {
                    itemMap.setModelData((String)null);
                    Menu.dataPane(player, itemMap);
                } else if (ServerUtils.hasSpecificUpdate("1_14")) {
                    Menu.modelDataPane(player, itemMap);
                }
            }));
            dataPane.addButton(new Button(fillerPaneBItem));
            dataPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COMPARATOR" : "404", 1, false, false, "&e&lModel Components", "&7", "&7*Set the custom model components of the item.", "&7This is the texture strings, colors, flags, and floats.", !ServerUtils.hasPreciseUpdate("1_21_5") ? "&c&l[ERROR] &7This version of Minecraft does" : "", !ServerUtils.hasPreciseUpdate("1_21_5") ? "&7not support custom model components." : "", !ServerUtils.hasPreciseUpdate("1_21_5") ? "&7This was implemented in 1.21.5+." : "", "&9&lMODEL COMPONENTS: &a" + (itemMap.getModelComponents() != null ? "YES" : "NONE")), event -> {
                if (ServerUtils.hasPreciseUpdate("1_21_5")) {
                    Menu.modelComponentsPane(player, itemMap);
                }
            }));
            dataPane.addButton(new Button(fillerPaneBItem));
            dataPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu"), event -> Menu.creatingPane(player, itemMap)));
            dataPane.addButton(new Button(fillerPaneBItem), 7);
            dataPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu"), event -> Menu.creatingPane(player, itemMap)));
        });
        dataPane.open(player);
    }

    private static void durabilityDataPane(Player player, ItemMap itemMap) {
        Interface texturePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            texturePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.dataPane(player, itemMap)));
            texturePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&lCustom Texture", "&7", "&7*Click to set a custom texture", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DURABILITY DATA").with(PlaceHolder.Holder.INPUT_EXAMPLE, "1193");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setData(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DURABILITY DATA");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.dataPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 2000; ++i) {
                int k = i;
                ItemStack item = ItemHandler.getItem(itemMap.getMaterial().name(), 1, false, false, "&9&lData: &a&l" + k, "&7", "&7*Click to set the", "&7durability data of the item.");
                ItemMeta itemMeta = item.getItemMeta();
                if (ServerUtils.hasSpecificUpdate("1_13") && itemMeta != null) {
                    ((Damageable)itemMeta).setDamage(k);
                    item.setItemMeta(itemMeta);
                } else {
                    LegacyAPI.setDurability(item, (short)k);
                }
                texturePane.addButton(new Button(item, event -> {
                    itemMap.setData(k);
                    Menu.dataPane(player, itemMap);
                }));
            }
        });
        texturePane.open(player);
    }

    private static void modelDataPane(Player player, ItemMap itemMap) {
        Interface texturePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            texturePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu."), event -> Menu.dataPane(player, itemMap)));
            texturePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&lCustom Model Data", "&7", "&7*Click to set the custom model data", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MODEL DATA").with(PlaceHolder.Holder.INPUT_EXAMPLE, ServerUtils.hasPreciseUpdate("1_21_4") ? "example:custom_sword" : "1193");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0])) || ServerUtils.hasPreciseUpdate("1_21_4")) {
                    itemMap.setModelData(ChatColor.stripColor((String)event.getMessage()));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MODEL DATA");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.dataPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 2000; ++i) {
                int k = i;
                ItemStack item = ItemHandler.getItem(itemMap.getMaterial().name(), 1, false, false, "&9&lModel Data: &a&l" + k, "&7", "&7*Click to set the", "&7custom model data for the item.");
                ItemMeta itemMeta = item.getItemMeta();
                if (itemMeta != null) {
                    itemMeta.setCustomModelData(Integer.valueOf(k));
                    item.setItemMeta(itemMeta);
                }
                texturePane.addButton(new Button(item, event -> {
                    itemMap.setModelData(String.valueOf(k));
                    Menu.dataPane(player, itemMap);
                }));
            }
        });
        texturePane.open(player);
    }

    private static void modelComponentsPane(Player player, ItemMap itemMap) {
        Interface componentsPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            componentsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu."), event -> Menu.dataPane(player, itemMap)));
            componentsPane.addButton(new Button(fillerPaneBItem));
            String[] stringArray = new String[4];
            stringArray[0] = "&7";
            stringArray[1] = "&7*Define the individual strings of the";
            stringArray[2] = "&7custom model components.";
            stringArray[3] = "&9&LStrings(s): &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelComponents() != null && itemMap.getModelComponents().get(0) != null ? itemMap.getModelComponents().get(0).toString() : null).equals("NONE") ? (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(0) != null ? itemMap.getModelComponents().get(0).toString() : null) : "NONE");
            componentsPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&LStrings(s)", stringArray), event -> Menu.componentsStringsPane(player, itemMap)));
            componentsPane.addButton(new Button(fillerPaneBItem));
            String[] stringArray2 = new String[4];
            stringArray2[0] = "&7";
            stringArray2[1] = "&7*Define the individual colors of the";
            stringArray2[2] = "&7custom model components.";
            stringArray2[3] = "&9&lColor(s): &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelComponents() != null && itemMap.getModelComponents().get(1) != null ? itemMap.getModelComponents().get(1).toString() : null).equals("NONE") ? (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(1) != null ? itemMap.getModelComponents().get(1).toString() : null) : "NONE");
            componentsPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIME_DYE" : "351:10", 1, false, false, "&a&lColor(s)", stringArray2), event -> Menu.colorPane(player, itemMap, 1)));
            componentsPane.addButton(new Button(fillerPaneBItem));
            String[] stringArray3 = new String[4];
            stringArray3[0] = "&7";
            stringArray3[1] = "&7*Define the individual flags of the";
            stringArray3[2] = "&7custom model components.";
            stringArray3[3] = "&9&lFlags(s): &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelComponents() != null && itemMap.getModelComponents().get(2) != null ? itemMap.getModelComponents().get(2).toString() : null).equals("NONE") ? (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(2) != null ? itemMap.getModelComponents().get(2).toString() : null) : "NONE");
            componentsPane.addButton(new Button(ItemHandler.getItem("LEVER", 1, false, false, "&a&lFlags(s)", stringArray3), event -> Menu.componentsFlagPane(player, itemMap)));
            componentsPane.addButton(new Button(fillerPaneBItem));
            String[] stringArray4 = new String[4];
            stringArray4[0] = "&7";
            stringArray4[1] = "&7*Define the individual floats of the";
            stringArray4[2] = "&7custom model components.";
            stringArray4[3] = "&9&lFloats(s): &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null ? itemMap.getModelComponents().get(3).toString() : null).equals("NONE") ? (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(3) != null ? itemMap.getModelComponents().get(3).toString() : null) : "NONE");
            componentsPane.addButton(new Button(ItemHandler.getItem("GLASS_BOTTLE", 1, false, false, "&a&lFloats(s)", stringArray4), event -> Menu.countPane(player, itemMap, 1)));
            componentsPane.addButton(new Button(fillerPaneBItem));
            componentsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu"), event -> Menu.dataPane(player, itemMap)));
            componentsPane.addButton(new Button(fillerPaneBItem), 7);
            componentsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu"), event -> Menu.dataPane(player, itemMap)));
        });
        componentsPane.open(player);
    }

    private static void componentsStringsPane(Player player, ItemMap itemMap) {
        Interface stringsPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            stringsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu."), event -> Menu.modelComponentsPane(player, itemMap)));
            stringsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&eAdd String", "&7", "&7*Add a new string", "&7to the component strings."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMPONENTS STRING").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bcustom_sword");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                String input;
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMPONENTS STRING");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> strings = new ArrayList<String>();
                if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(0) != null) {
                    for (String string : itemMap.getModelComponents().get(0).replaceAll("\\s*,\\s*", ",").split(",")) {
                        try {
                            strings.add(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(strings, input = ChatColor.stripColor((String)event.getMessage()))) {
                    strings.remove(input);
                } else {
                    strings.add(input);
                }
                List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                modelComponents.set(0, String.join((CharSequence)", ", strings));
                itemMap.setModelComponents(modelComponents);
                Menu.componentsStringsPane(player, itemMap);
            }));
            ArrayList<String> strings = new ArrayList<String>();
            if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(0) != null) {
                for (String string : itemMap.getModelComponents().get(0).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        strings.add(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < strings.size(); ++i) {
                int index = i;
                String string = (String)strings.get(index);
                if (string == null) continue;
                stringsPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&l" + string, "&7", "&7*Click to &4&nremove&7 this string", "&7from the custom model components."), event -> {
                    strings.remove(index);
                    List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                    modelComponents.set(0, String.join((CharSequence)", ", strings));
                    itemMap.setModelComponents(modelComponents);
                    Menu.componentsStringsPane(player, itemMap);
                }));
            }
        });
        stringsPane.open(player);
    }

    private static void componentsFlagPane(Player player, ItemMap itemMap) {
        Interface flagsPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            flagsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the data definition menu."), event -> Menu.modelComponentsPane(player, itemMap)));
            flagsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&a&lAdd Flag", "&7", "&7*Add a true / false flag", "&7for the custom model components."), event -> {
                Interface boolPane = new Interface(true, 2, exitButton, GUIName, player);
                SchedulerUtils.runAsync(() -> {
                    boolPane.addButton(new Button(fillerPaneBItem), 3);
                    boolPane.addButton(new Button(ItemHandler.getItem("GREEN_WOOL", 1, false, false, "&a&lTrue", "&7", "&7*Add the true flag", "&7to the custom model components."), event_2 -> {
                        ArrayList<Boolean> flags = new ArrayList<Boolean>();
                        if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(2) != null) {
                            for (String flag : itemMap.getModelComponents().get(2).replaceAll("\\s*,\\s*", ",").split(",")) {
                                try {
                                    flags.add(Boolean.valueOf(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(flag, player, new PlaceHolder[0]).toUpperCase()));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                        flags.add(true);
                        List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                        modelComponents.set(2, flags.stream().map(String::valueOf).collect(Collectors.joining(", ")));
                        itemMap.setModelComponents(modelComponents);
                        Menu.componentsFlagPane(player, itemMap);
                    }));
                    boolPane.addButton(new Button(fillerPaneBItem));
                    boolPane.addButton(new Button(ItemHandler.getItem("RED_WOOL", 1, false, false, "&4&LFalse", "&7", "&7*Add the false flag", "&7to the custom model components."), event_2 -> {
                        ArrayList<Boolean> flags = new ArrayList<Boolean>();
                        if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(2) != null) {
                            for (String flag : itemMap.getModelComponents().get(2).replaceAll("\\s*,\\s*", ",").split(",")) {
                                try {
                                    flags.add(Boolean.valueOf(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(flag, player, new PlaceHolder[0]).toUpperCase()));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                        flags.add(false);
                        List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                        modelComponents.set(2, flags.stream().map(String::valueOf).collect(Collectors.joining(", ")));
                        itemMap.setModelComponents(modelComponents);
                        Menu.componentsFlagPane(player, itemMap);
                    }));
                    boolPane.addButton(new Button(fillerPaneBItem), 3);
                    boolPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the components flags definition menu"), event_2 -> flagsPane.open(player)));
                    boolPane.addButton(new Button(fillerPaneBItem), 7);
                    boolPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the components flags definition menu"), event_2 -> flagsPane.open(player)));
                });
                boolPane.open(player);
            }));
            ArrayList<Boolean> flags = new ArrayList<Boolean>();
            if (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(2) != null) {
                for (String flag : itemMap.getModelComponents().get(2).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        flags.add(Boolean.valueOf(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(flag, player, new PlaceHolder[0]).toUpperCase()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < flags.size(); ++i) {
                int index = i;
                boolean flag = (Boolean)flags.get(index);
                if (flags.get(index) == null) continue;
                flagsPane.addButton(new Button(ItemHandler.getItem(flag ? "GREEN_WOOL" : "RED_WOOL", 1, false, false, flag ? "&a&lTrue" : "&4&LFalse", "&7", "&7*Click to &4&nremove&7 the " + (flag ? "true" : "false") + " flag", "&7from the custom model components."), event -> {
                    flags.remove(index);
                    List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                    modelComponents.set(2, flags.stream().map(String::valueOf).collect(Collectors.joining(", ")));
                    itemMap.setModelComponents(modelComponents);
                    Menu.componentsFlagPane(player, itemMap);
                }));
            }
        });
        flagsPane.open(player);
    }

    private static void damagePane(Player player, ItemMap itemMap) {
        Interface damagePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            damagePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.dataPane(player, itemMap)));
            damagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Damage", "&7", "&7*Click to set a custom damage", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DAMAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "1893");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setDurability((short)Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DAMAGE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.dataPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= itemMap.getMaterial().getMaxDurability(); ++i) {
                int k = i;
                damagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:6", 1, false, false, "&9&lDamage: &a&l" + k, "&7", "&7*Click to set the", "&7damage of the item."), event -> {
                    itemMap.setDurability((short)k);
                    Menu.dataPane(player, itemMap);
                }));
            }
        });
        damagePane.open(player);
    }

    private static void commandPane(Player player, ItemMap itemMap) {
        Interface commandPane = new Interface(false, 4, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            commandPane.addButton(new Button(fillerPaneGItem), 4);
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&e&lCommands", "&7", "&7*Click to define the custom command lines", "&7for the item and click type.", "&7", "&9&lCOMMANDS: &a" + (itemMap.getCommands().length > 0 ? "YES" : "NONE")), event -> Menu.actionPane(player, itemMap)));
            commandPane.addButton(new Button(fillerPaneGItem), 7);
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LAVA_BUCKET" : "327", 1, false, false, "&a&lWarmup", "&7", "&7*The time it will take before", "&7the commands are executed.", "&7Player movement will cancel the", "&7pending commands execution.", "&7", "&9&lCOMMANDS-WARMUP: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getWarmDelay() + "&7") + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getWarmDelay() + "&7").equals("NONE") ? "&a second(s)" : "")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getWarmDelay() + "&7").equals("NONE")) {
                    itemMap.setWarmDelay(0);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.warmPane(player, itemMap);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("ICE", 1, false, false, "&a&lCooldown", "&7", "&7*The time that the commands will", "&7be on cooldown for.", "&7", "&9&lCOMMANDS-COOLDOWN: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandCooldown() + "&7") + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandCooldown() + "&7").equals("NONE") ? "&a second(s)" : "")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandCooldown() + "&7").equals("NONE")) {
                    itemMap.setCommandCooldown(0);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.cooldownPane(player, itemMap);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&a&lCooldown Message", "&7", "&7*Optional cooldown message", "&7to be displayed when", "&7the items commands are", "&7on cooldown.", "&7", "&9&lCOOLDOWN-MESSAGE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCooldownMessage())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCooldownMessage()).equals("NONE")) {
                    itemMap.setCooldownMessage(null);
                    Menu.commandPane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COOLDOWN MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&cThis item is on cooldown for &a%timeleft%&c seconds..");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setCooldownMessage(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COOLDOWN MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandPane(event.getPlayer(), itemMap);
            }));
            commandPane.addButton(new Button(fillerPaneGItem), 3);
            commandPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&a&lParticle", "&7", "&7*Custom particle(s) that will be", "&7displayed when the commands", "&7are successfully executed.", "&7", "&9&lCOMMANDS-PARTICLE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandParticle())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandParticle()).equals("NONE")) {
                    itemMap.setCommandParticle(null);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.particlePane(player, itemMap, 3);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&a&lItem Cost", "&7", "&7*Material that will", "&7be charged upon successfully", "&7executing the commands.", "&7", "&9&lCOMMANDS-ITEM: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemCost())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemCost()).equals("NONE")) {
                    itemMap.setItemCost(null);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.materialPane(player, itemMap, 2, 0);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, false, false, "&a&lCost", "&7", "&7*Amount that the player will", "&7be charged upon successfully", "&7executing the commands.", "&7", "&9&lCOMMANDS-COST: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getRawCost() + "&7")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getRawCost() + "&7").equals("NONE")) {
                    itemMap.setCommandCost("0");
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.costPane(player, itemMap);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("STONE_BUTTON", 1, false, false, "&a&lReceive", "&7", "&7*The number of times the", "&7commands will execute when", "&7receiving the custom item.", "&cNOTE: &7Only functions with", "&7the on-receive command action.", "&7", "&9&lCOMMANDS-RECEIVE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandReceive() + "&7")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandReceive() + "&7").equals("NONE")) {
                    itemMap.setCommandReceive(0);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.receivePane(player, itemMap);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("JUKEBOX", 1, false, false, "&a&lSound", "&7", "&7*The sound that will be", "&7played after a successful", "&7command execution.", "&7", "&9&lCOMMANDS-SOUND: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandSound() + ""), "&9&lVOLUME: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandSound() + "").equals("NONE") ? itemMap.getCommandVolume() : "0"), "&9&lPITCH: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandSound() + "").equals("NONE") ? itemMap.getCommandPitch() : "0")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandSound() + "").equals("NONE")) {
                    itemMap.setCommandSound(null);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.soundPane(player, itemMap, 3);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REPEATER" : "356", 1, false, false, "&a&lSequence", "&7", "&7*The order that the command lines", "&7will be executed in.", "&7", "&9&lCOMMANDS-SEQUENCE: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck((Object)((Object)itemMap.getCommandSequence()) + "")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck((Object)((Object)itemMap.getCommandSequence()) + "").equals("NONE")) {
                    itemMap.setCommandSequence(null);
                    Menu.commandPane(player, itemMap);
                } else {
                    Menu.sequencePane(player, itemMap, 0);
                }
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REDSTONE_TORCH" : "76", 1, false, false, "&b&lPermissions", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + String.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions() + "").equals("NONE")).toUpperCase()), event -> Menu.commandPermissionPane(player, itemMap)));
            commandPane.addButton(new Button(ItemHandler.getItem("BOOK", 1, false, false, "&b&lConditions", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + String.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions() + "").equals("NONE")).toUpperCase()), event -> Menu.commandActionPane(player, itemMap)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLOWSTONE_DUST" : "348", 1, false, false, "&b&lFail Messages", "&7", "&7*Define messages for each command action", "&7that will be sent when either", "&7permissions or conditions requirements", "&7are not met.", "&7", "&9&lENABLED: &a" + String.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages() + "").equals("NONE")).toUpperCase()), event -> Menu.commandFailPane(player, itemMap)));
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            commandPane.addButton(new Button(fillerPaneBItem), 7);
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        commandPane.open(player);
    }

    private static void actionPane(Player player, ItemMap itemMap) {
        Interface clickPane = new Interface(false, 5, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            clickPane.addButton(new Button(fillerPaneGItem), 2);
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract", "&7", "&7*Commands that will execute only", "&7when left and right clicking.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_ALL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_ALL)));
            clickPane.addButton(new Button(fillerPaneGItem));
            clickPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory", "&7", "&7*Commands that will execute only", "&7when cursor clicking the item", "&7with the players inventory open.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_ALL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_ALL)));
            clickPane.addButton(new Button(fillerPaneGItem));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "PISTON_BASE", 1, false, false, "&e&lPhysical", "&7", "&7*Commands that will execute", "&7when held in the player hand", "&7and they interact with a object", "&7such as a pressure plate.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.PHYSICAL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.PHYSICAL)));
            clickPane.addButton(new Button(fillerPaneGItem), 2);
            clickPane.addButton(new Button(ItemHandler.getItem("DIAMOND_HELMET", 1, false, true, "&e&lOn-Equip", "&7", "&7*Commands that will execute only", "&7when the item is placed", "&7in an armor slot.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_EQUIP)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_EQUIP)));
            clickPane.addButton(new Button(ItemHandler.getItem("IRON_HELMET", 1, false, true, "&e&lUn-Equip", "&7", "&7*Commands that will execute only", "&7when the item is removed", "&7from an armor slot.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.UN_EQUIP)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.UN_EQUIP)));
            clickPane.addButton(new Button(ItemHandler.getItem("TORCH", 1, false, false, "&e&lOn-Hold", "&7", "&7*Commands that will execute only", "&7when holding the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_HOLD)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_HOLD)));
            clickPane.addButton(new Button(ItemHandler.getItem("ARROW", 1, false, false, "&e&lOn-Fire", "&7", "&7*Commands that will execute only", "&7when an arrow or bow is fired.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_FIRE)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_FIRE)));
            clickPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&lOn-Drop", "&7", "&7*Commands that will execute only", "&7when you drop the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_DROP)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_DROP)));
            clickPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, true, "&e&lOn-Consume", "&7", "&7*Commands that will execute only", "&7when you consume the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_CONSUME)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_CONSUME)));
            clickPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&e&lOn-Receive", "&7", "&7*Commands that will execute only", "&7when you are given the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_RECEIVE)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_RECEIVE)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SKELETON_SKULL" : "397", 1, false, false, "&e&lOn-Death", "&7", "&7*Commands that will execute only", "&7when dying with the", "&7item in your inventory.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_DEATH)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_DEATH)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PLAYER_HEAD" : "397:3", 1, false, false, "&e&lOn-Kill", "&7", "&7*Commands that will execute only", "&7when killing a player with the", "&7item in your inventory.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_KILL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_KILL)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLASS" : "20", 1, false, false, "&e&lInteract-Air", "&7", "&7*Commands that will execute only", "&7when left and right", "&7clicking the air.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_AIR)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_AIR)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS" : "95:3", 1, false, false, "&e&lInteract-Air-Left", "&7", "&7*Commands that will execute only", "&7when left clicking the air.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_LEFT_AIR)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_AIR)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS" : "95:6", 1, false, false, "&e&lInteract-Air-Right", "&7", "&7*Commands that will execute only", "&7when right clicking the air.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_RIGHT_AIR)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_AIR)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, false, false, "&e&lInteract-Block", "&7", "&7*Commands that will execute only", "&7when left and right", "&7clicking a block.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_BLOCK)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_BLOCK)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE" : "1", 1, false, false, "&e&lInteract-Block-Left", "&7", "&7*Commands that will execute only", "&7when left clicking a block.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_LEFT_BLOCK)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_BLOCK)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE" : "4", 1, false, false, "&e&lInteract-Block-Right", "&7", "&7*Commands that will execute only", "&7when right clicking a block.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_RIGHT_BLOCK)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_BLOCK)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_DOOR" : "330", 1, false, false, "&e&lInteract-Left", "&7", "&7*Commands that will execute only", "&7when left clicking.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_LEFT_ALL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_ALL)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract-Right", "&7", "&7*Commands that will execute only", "&7when right clicking.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INTERACT_RIGHT_ALL)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_ALL)));
            clickPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&e&lInventory-Swap-Cursor", "&7", "&7*Commands that will execute only", "&7when cursor swapping with another item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_SWAP_CURSOR)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_SWAP_CURSOR)));
            if (!ServerUtils.hasSpecificUpdate("1_21")) {
                clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SNOWBALL" : "SNOW_BALL", 8, false, false, "&e&lInventory-Middle", "&7", "&7*Commands that will execute only", "&7when cursor middle clicking the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_MIDDLE)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_MIDDLE)));
            } else {
                clickPane.addButton(new Button(fillerPaneBItem));
            }
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&e&lInventory-Creative", "&7", "&7*Commands that will execute only", "&7when cursor clicking the item in creative mode.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_CREATIVE)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_CREATIVE)));
            clickPane.addButton(new Button(ItemHandler.getItem("ENDER_CHEST", 1, false, false, "&e&lInventory-Left", "&7", "&7*Commands that will execute only", "&7when cursor left clicking the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_LEFT)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_LEFT)));
            clickPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory-Right", "&7", "&7*Commands that will execute only", "&7when cursor right clicking the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_RIGHT)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_RIGHT)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE_SLAB" : "44", 2, false, false, "&e&lInventory-Shift-Left", "&7", "&7*Commands that will execute only", "&7when cursor shift left clicking the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_SHIFT_LEFT)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_LEFT)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE_SLAB" : "44:3", 2, false, false, "&e&lInventory-Shift-Right", "&7", "&7*Commands that will execute only", "&7when cursor shift right clicking the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.INVENTORY_SHIFT_RIGHT)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_RIGHT)));
            clickPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&e&lOn-Join", "&7", "&7*Commands that will execute only", "&7when the player joins the server", "&7and they already have the item.", "&7", "&7Note: This will not be triggered", "&7after the user receives the item", "&7they must already have the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_JOIN)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_JOIN)));
            clickPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&e&lOn-Damage", "&7", "&7*Commands that will execute only", "&7when the player damages an", "&7entity or is damaged by an", "&7entity with the item in", "&7their inventory.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_DAMAGE)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_DAMAGE)));
            clickPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, false, true, "&e&lOn-Hit", "&7", "&7*Commands that will execute only", "&7when the player damages an", "&7entity while holding the item.", "&7", "&9&lCommands: &a" + Menu.listCommands(itemMap, ItemCommand.Action.ON_HIT)), event -> Menu.commandListPane(player, itemMap, ItemCommand.Action.ON_HIT)));
            clickPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            clickPane.addButton(new Button(fillerPaneBItem), 7);
            clickPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
        });
        clickPane.open(player);
    }

    private static String listCommands(ItemMap itemMap, ItemCommand.Action action) {
        StringBuilder commands = new StringBuilder();
        String commandReturn = "NONE";
        for (ItemCommand command : itemMap.getCommands()) {
            if (!command.matchAction(action)) continue;
            commands.append(command.getRawCommand()).append(" /n ");
        }
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(commands.toString()).equals("NONE")) {
            commandReturn = commands.toString();
        }
        return commandReturn;
    }

    private static void modifyCommands(ItemMap itemMap, ItemCommand itemCommand, boolean newCommand) {
        ArrayList<ItemCommand> arrayCommands = new ArrayList<ItemCommand>(Arrays.asList(itemMap.getCommands()));
        if (newCommand) {
            arrayCommands.add(itemCommand);
        } else {
            arrayCommands.remove(itemCommand);
        }
        ItemCommand[] commands = new ItemCommand[arrayCommands.size()];
        for (int i = 0; i < arrayCommands.size(); ++i) {
            commands[i] = (ItemCommand)arrayCommands.get(i);
        }
        itemMap.setCommands(commands);
    }

    private static int getCommandSize(ItemMap itemMap, ItemCommand.Action action) {
        int l = 0;
        for (ItemCommand command : itemMap.getCommands()) {
            if (!command.matchAction(action)) continue;
            ++l;
        }
        return l;
    }

    private static void commandListPane(Player player, ItemMap itemMap, ItemCommand.Action action) {
        Interface commandListPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            commandListPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the click type menu."), event -> Menu.actionPane(player, itemMap)));
            commandListPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&lNew Line", "&7", "&7*Add a new command to be executed", "&7by &9&l" + action.name()), event -> Menu.executorPane(player, itemMap, action)));
            ItemCommand[] commandList = itemMap.getCommands();
            int l = 1;
            for (ItemCommand command : commandList) {
                if (!command.matchAction(action)) continue;
                int k = l++;
                commandListPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&f" + command.getRawCommand(), "&7", "&7*Click to&l modify &7this command.", "&9&lOrder Number: &a" + k), event -> Menu.modifyCommandsPane(player, itemMap, action, command, k)));
            }
        });
        commandListPane.open(player);
    }

    private static void orderPane(Player player, ItemMap itemMap, ItemCommand.Action action, ItemCommand command, int orderNumber) {
        Interface orderPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            orderPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command modify menu."), event -> Menu.modifyCommandsPane(player, itemMap, action, command, orderNumber)));
            for (int i = 1; i <= Menu.getCommandSize(itemMap, action); ++i) {
                int k = i;
                orderPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:3", k, false, false, "&9&lOrder Number: &a&l" + k, "&7", "&7*Click to set the order", "&7number of the command."), event -> {
                    ArrayList<ItemCommand> arrayCommands = new ArrayList<ItemCommand>();
                    int l = 0;
                    for (ItemCommand Command2 : itemMap.getCommands()) {
                        if (Command2.matchAction(action)) {
                            if (l + 1 == k) {
                                arrayCommands.add(command);
                            }
                            ++l;
                        }
                        if (Command2.equals(command)) continue;
                        arrayCommands.add(Command2);
                    }
                    ItemCommand[] commands = new ItemCommand[arrayCommands.size()];
                    for (int j = 0; j < arrayCommands.size(); ++j) {
                        commands[j] = (ItemCommand)arrayCommands.get(j);
                    }
                    itemMap.setCommands(commands);
                    Menu.commandListPane(player, itemMap, action);
                }));
            }
        });
        orderPane.open(player);
    }

    private static void modifyCommandsPane(Player player, ItemMap itemMap, ItemCommand.Action action, ItemCommand command, int orderNumber) {
        Interface modPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modPane.addButton(new Button(fillerPaneGItem), 4);
            modPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&f" + command.getRawCommand(), "&7", "&7*You are modifying this command.", "&9&lOrder Number: &a" + orderNumber)));
            modPane.addButton(new Button(fillerPaneGItem), 4);
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REPEATER" : "356", 1, false, false, "&fIdentifier", "&7", "&7*Set a custom identifier", "&7for this command line.", "&7", "&cNOTE: &7This is in order to set", "&7a random command list sequence.", "&7Only use this if", "&7the commands sequence is", "&7set to &aRANDOM_LIST&7.", "&7", "&9&lIDENTIFIER: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(command.getSection())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(command.getSection()).equals("NONE")) {
                    ItemCommand[] commands;
                    for (ItemCommand Command2 : commands = itemMap.getCommands()) {
                        if (!Command2.equals(command)) continue;
                        Command2.setSection(null);
                    }
                    itemMap.setCommands(commands);
                    command.setSection(null);
                    Menu.modifyCommandsPane(player, itemMap, action, command, orderNumber);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND IDENTIFIER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "winner");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                ItemCommand[] commands;
                for (ItemCommand Command2 : commands = itemMap.getCommands()) {
                    if (!Command2.equals(command)) continue;
                    Command2.setSection(ChatColor.stripColor((String)event.getMessage()));
                }
                itemMap.setCommands(commands);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND IDENTIFIER");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&fModify", "&7", "&7*Sets the command to", "&7another text entry."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MODIFIED COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, "gamemode creative");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                ItemCommand[] commands;
                for (ItemCommand Command2 : commands = itemMap.getCommands()) {
                    if (!Command2.equals(command)) continue;
                    Command2.setCommand(ChatColor.stripColor((String)event.getMessage()));
                }
                itemMap.setCommands(commands);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MODIFIED COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem("STICK", 1, false, false, "&fOrder", "&7", "&7*Changes the order of execution", "&7for this command line.", "&7", "&7This will simply set the order", "&7number and push the", "&7other commands down by one."), event -> Menu.orderPane(player, itemMap, action, command, orderNumber)));
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&fDelete", "&7", "&7*Click to&c delete &7this command."), event -> {
                Menu.modifyCommands(itemMap, command, false);
                Menu.commandListPane(player, itemMap, action);
            }));
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command lines menu."), event -> Menu.commandListPane(player, itemMap, action)));
            modPane.addButton(new Button(fillerPaneBItem), 7);
            modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command lines menu."), event -> Menu.commandListPane(player, itemMap, action)));
        });
        modPane.open(player);
    }

    private static void executorPane(Player player, ItemMap itemMap, ItemCommand.Action action) {
        Interface executorPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            executorPane.addButton(new Button(ItemHandler.getItem("BOOK", 1, false, false, "&e&lPlayer", "&7", "&7*Executes the command", "&7as the player."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PLAYER COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, "spawn");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("player: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PLAYER COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem("BOOK", 1, true, false, "&e&lOp", "&7", "&7*Executes the command as if the", "&7player has /op (admin permissions)."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ADMIN COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, "broadcast I am &cADMIN!");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("op: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ADMIN COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&e&lConsole", "&7", "&7*Executes the command", "&7in the console window."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "CONSOLE COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, "gamemode creative %player%");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("console: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "CONSOLE COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&lServer", "&7", "&7*Switches the player to", "&7the defined server name.", "&7", "&7&lNote: &7This is the name", "&7defined in the BungeeCord config."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SERVER SWITCH").with(PlaceHolder.Holder.INPUT_EXAMPLE, "survival");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("server: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SERVER SWITCH");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem("OBSIDIAN", 1, false, false, "&e&lBungee", "&7", "&7*Executes a BungeeCord specific command."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUNGEE COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, "survival");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("bungee: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUNGEE COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&e&lMessage", "&7", "&7*Sends the player a custom message."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&eWelcome to the Server!");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.modifyCommands(itemMap, ItemCommand.fromString("message: " + ChatColor.stripColor((String)event.getMessage()), action, itemMap, 0L, null), true);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            executorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ANVIL" : "145", 1, false, false, "&e&lDamage", "&7", "&7*Damages the item (x) amount."), event -> Menu.damageExecutorPane(player, itemMap, action)));
            executorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "REPEATER" : "356", 1, false, false, "&e&lSwap-Item", "&7", "&7*Swaps the item to another defined item."), event -> Menu.swapPane(player, itemMap, action)));
            executorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&e&lDelay", "&7", "&7*Adds a delay between command lines."), event -> Menu.delayPane(player, itemMap, action)));
            executorPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command lines menu."), event -> Menu.commandListPane(player, itemMap, action)));
            executorPane.addButton(new Button(fillerPaneBItem), 7);
            executorPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command lines menu."), event -> Menu.commandListPane(player, itemMap, action)));
        });
        executorPane.open(player);
    }

    private static void swapPane(Player player, ItemMap itemMap, ItemCommand.Action action) {
        Interface swapPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            swapPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the executors menu."), event -> Menu.executorPane(player, itemMap, action)));
            for (ItemMap item : ItemUtilities.getUtilities().copyItems()) {
                if (item.getNodeLocation() == itemMap.getNodeLocation()) continue;
                if (itemMap.isAnimated() || itemMap.isDynamic()) {
                    Menu.setModifyMenu(true, player);
                    if (itemMap.getAnimationHandler().get(player) != null) {
                        itemMap.getAnimationHandler().get(player).setMenu(true, 1);
                    }
                }
                swapPane.addButton(new Button(ItemHandler.addLore(item.getTempItem(), "&7", "&6---------------------------", "&7*Click to set as a swap-item.", "&9&lNode: &a" + item.getConfigName(), "&7"), event -> {
                    Menu.modifyCommands(itemMap, ItemCommand.fromString("swap-item: " + item.getConfigName(), action, itemMap, 0L, null), true);
                    Menu.commandListPane(player, itemMap, action);
                }));
            }
        });
        swapPane.open(player);
    }

    private static void delayPane(Player player, ItemMap itemMap, ItemCommand.Action action) {
        Interface delayPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            delayPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the executors menu."), event -> Menu.executorPane(player, itemMap, action)));
            delayPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Cooldown", "&7", "&7*Click to set a custom", "&7delay for the next command."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DELAY").with(PlaceHolder.Holder.INPUT_EXAMPLE, "180");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    Menu.modifyCommands(itemMap, ItemCommand.fromString("delay: " + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())), action, itemMap, Integer.parseInt(ChatColor.stripColor((String)event.getMessage())), null), true);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DELAY");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                delayPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_GRAY_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:8", k, false, false, "&9&lDelay: &a&l" + k + " Tick(s)", "&7", "&7*Click to set the", "&7delay of the next command."), event -> {
                    Menu.modifyCommands(itemMap, ItemCommand.fromString("delay: " + k, action, itemMap, k, null), true);
                    Menu.commandListPane(player, itemMap, action);
                }));
            }
        });
        delayPane.open(player);
    }

    private static void damageExecutorPane(Player player, ItemMap itemMap, ItemCommand.Action action) {
        Interface damagePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            damagePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the executors menu."), event -> Menu.executorPane(player, itemMap, action)));
            damagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Cooldown", "&7", "&7*Click to set a custom", "&7delay for the next command."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DAMAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "180");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    Menu.modifyCommands(itemMap, ItemCommand.fromString("damage: " + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())), action, itemMap, Integer.parseInt(ChatColor.stripColor((String)event.getMessage())), null), true);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DAMAGE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandListPane(event.getPlayer(), itemMap, action);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                damagePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_GRAY_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:8", k, false, false, "&9&lDamage: &a&l" + k, "&7", "&7*Click to set the", "&7damage the item should take."), event -> {
                    Menu.modifyCommands(itemMap, ItemCommand.fromString("damage: " + k, action, itemMap, k, null), true);
                    Menu.commandListPane(player, itemMap, action);
                }));
            }
        });
        damagePane.open(player);
    }

    private static void cooldownPane(Player player, ItemMap itemMap) {
        Interface cooldownPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            cooldownPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            cooldownPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Cooldown", "&7", "&7*Click to set a custom commands-cooldown", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND COOLDOWN").with(PlaceHolder.Holder.INPUT_EXAMPLE, "180");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setCommandCooldown(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND COOLDOWN");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                cooldownPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Second(s)", "&7", "&7*Click to set the", "&7commands-cooldown of the item."), event -> {
                    itemMap.setCommandCooldown(k);
                    Menu.commandPane(player, itemMap);
                }));
            }
        });
        cooldownPane.open(player);
    }

    private static void warmPane(Player player, ItemMap itemMap) {
        Interface warmPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            warmPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            warmPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Warmup", "&7", "&7*Click to set a custom commands-warmup", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND WARMUP").with(PlaceHolder.Holder.INPUT_EXAMPLE, "12");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setWarmDelay(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND WARMUP");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                warmPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lWarming: &a&l" + k + " Second(s)", "&7", "&7*Click to set the", "&7commands-warmup of the item."), event -> {
                    itemMap.setWarmDelay(k);
                    Menu.commandPane(player, itemMap);
                }));
            }
        });
        warmPane.open(player);
    }

    private static void costPane(Player player, ItemMap itemMap) {
        Interface costPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            costPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            costPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Cost", "&7", "&7*Click to set a custom commands-cost", "&7value for the item.", "&7", "&c&lNote: &7You can use placeholders", "&7as long as they parse to a number."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND COST").with(PlaceHolder.Holder.INPUT_EXAMPLE, "340");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                String cost = ChatColor.stripColor((String)event.getMessage());
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, cost);
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(cost) || me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(cost)) {
                    itemMap.setCommandCost(cost);
                    PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND COST");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolder);
                } else if (cost.contains("%")) {
                    String translateCost = me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(cost, player, new PlaceHolder[0]).replaceAll("[^\\d.]", "").replace("-", "").replace(".", "").replace(" ", "");
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(translateCost) || me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(translateCost)) {
                        itemMap.setCommandCost(cost);
                        PlaceHolder placeHolder = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND COST");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolder);
                    } else {
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    }
                } else {
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandPane(event.getPlayer(), itemMap);
            }));
            for (int i = 0; i <= 384; ++i) {
                int k = i;
                costPane.addButton(new Button(ItemHandler.getItem(k == 0 ? (ServerUtils.hasSpecificUpdate("1_13") ? "LIME_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:5") : (ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11"), k == 0 ? 1 : k, false, false, "&9&lCost: &a$&l" + k, "&7", "&7*Click to set the", "&7commands-cost of the item."), event -> {
                    itemMap.setCommandCost(String.valueOf(k));
                    Menu.commandPane(player, itemMap);
                }));
            }
        });
        costPane.open(player);
    }

    private static void receivePane(Player player, ItemMap itemMap) {
        Interface receivePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            receivePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            receivePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Receive", "&7", "&7*Click to set a custom commands-receive", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND RECEIVE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "10");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setCommandReceive(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "COMMAND RECEIVE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.commandPane(event.getPlayer(), itemMap);
            }));
            for (int i = 0; i <= 64; ++i) {
                int k = i;
                receivePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k == 0 ? 1 : k, false, false, "&9&lReceive: &a#&l" + k, "&7", "&7*Click to set the", "&7commands-receive of the item."), event -> {
                    itemMap.setCommandReceive(k);
                    Menu.commandPane(player, itemMap);
                }));
            }
        });
        receivePane.open(player);
    }

    private static void sequencePane(Player player, ItemMap itemMap, int stage) {
        Interface sequencePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage == 4) {
                sequencePane.addButton(new Button(fillerPaneGItem));
            }
            sequencePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&a&lSequential", "&7", "&7*Executes the command lines", "&7in order from top to bottom."), event -> {
                if (stage == 4) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands-sequence", (Object)"SEQUENTIAL");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.activeCommands(player));
                } else {
                    itemMap.setCommandSequence(ItemCommand.CommandSequence.SEQUENTIAL);
                    Menu.commandPane(player, itemMap);
                }
            }));
            sequencePane.addButton(new Button(fillerPaneGItem));
            sequencePane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, false, false, "&a&lRandom Single", "&7", "&7*Executes one of the command lines", "&7randomly with equal values."), event -> {
                if (stage == 4) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands-sequence", (Object)"RANDOM_SINGLE");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.activeCommands(player));
                } else {
                    itemMap.setCommandSequence(ItemCommand.CommandSequence.RANDOM_SINGLE);
                    Menu.commandPane(player, itemMap);
                }
            }));
            sequencePane.addButton(new Button(fillerPaneGItem));
            sequencePane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&a&lRandom List", "&7", "&7*Randomly selects from a list", "&7of commands to execute."), event -> {
                if (stage == 4) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands-sequence", (Object)"RANDOM_LIST");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.activeCommands(player));
                } else {
                    itemMap.setCommandSequence(ItemCommand.CommandSequence.RANDOM_LIST);
                    Menu.commandPane(player, itemMap);
                }
            }));
            sequencePane.addButton(new Button(fillerPaneGItem));
            sequencePane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&a&lRandom", "&7", "&7*Executes each command line in a", "&7random order with equal values."), event -> {
                if (stage == 4) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands-sequence", (Object)"RANDOM");
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.activeCommands(player));
                } else {
                    itemMap.setCommandSequence(ItemCommand.CommandSequence.RANDOM);
                    Menu.commandPane(player, itemMap);
                }
            }));
            sequencePane.addButton(new Button(fillerPaneGItem));
            if (stage != 4) {
                sequencePane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&a&lRemain", "&7", "&7*Executes each command only if", "&7the item exists in the player", "&7inventory at the time of executing", "&7a delayed command line.", "&7The commands will be sent in", "&7order from top to bottom."), event -> {
                    itemMap.setCommandSequence(ItemCommand.CommandSequence.REMAIN);
                    Menu.commandPane(player, itemMap);
                }));
            }
            if (stage == 4) {
                sequencePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                sequencePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
            sequencePane.addButton(new Button(fillerPaneBItem), 7);
            if (stage == 4) {
                sequencePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                sequencePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
        });
        sequencePane.open(player);
    }

    private static void soundPane(Player player, ItemMap itemMap, int stage) {
        Interface soundPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 3) {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the teleport menu."), event -> Menu.teleportPane(player, itemMap, stage)));
            } else {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
            for (Sound sound : CompatUtils.values(Sound.class)) {
                if (stage != 3) {
                    soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "MUSIC_DISC_MELLOHI" : "2262", 1, false, false, "&f" + CompatUtils.getName(sound), "&7", "&7*Click to set the", "&7teleport-sound of the item."), event -> {
                        itemMap.setTeleportSound(CompatUtils.getName(sound));
                        Menu.soundVolumePane(player, itemMap, stage);
                    }));
                    continue;
                }
                soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "MUSIC_DISC_MELLOHI" : "2262", 1, false, false, "&f" + CompatUtils.getName(sound), "&7", "&7*Click to set the", "&7commands-sound of the item."), event -> {
                    itemMap.setCommandSound(CompatUtils.getName(sound));
                    Menu.soundVolumePane(player, itemMap, stage);
                }));
            }
        });
        soundPane.open(player);
    }

    private static void soundVolumePane(Player player, ItemMap itemMap, int stage) {
        Interface soundPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 3) {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the teleport menu."), event -> Menu.teleportPane(player, itemMap, stage)));
            } else {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
            soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Volume", "&7", "&7*Click to set a custom sound volume value."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SOUND VOLUME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "1.4");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(ChatColor.stripColor((String)event.getMessage()))) {
                    if (stage != 3) {
                        itemMap.setTeleportVolume(Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                    } else {
                        itemMap.setCommandVolume(Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                    }
                    Menu.soundPitchPane(player, itemMap, stage);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SOUND VOLUME");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.soundVolumePane(event.getPlayer(), itemMap, stage);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GREEN_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:13", k, false, false, "&9&lVolume: &a&l" + k, "&7", "&7*Click to set the sound volume."), event -> {
                    if (stage != 3) {
                        itemMap.setTeleportVolume(Double.valueOf(k));
                    } else {
                        itemMap.setCommandVolume(Double.valueOf(k));
                    }
                    Menu.soundPitchPane(player, itemMap, stage);
                }));
            }
        });
        soundPane.open(player);
    }

    private static void soundPitchPane(Player player, ItemMap itemMap, int stage) {
        Interface soundPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 3) {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the teleport menu."), event -> Menu.teleportPane(player, itemMap, stage)));
            } else {
                soundPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
            soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Pitch", "&7", "&7*Click to set a custom sound pitch", "&7value for the command sound."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SOUND PITCH").with(PlaceHolder.Holder.INPUT_EXAMPLE, "0.8");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(ChatColor.stripColor((String)event.getMessage()))) {
                    if (stage != 3) {
                        itemMap.setTeleportPitch(Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                        Menu.teleportPane(player, itemMap, stage);
                    } else {
                        itemMap.setCommandPitch(Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                        Menu.commandPane(player, itemMap);
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SOUND PITCH");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.soundPitchPane(event.getPlayer(), itemMap, stage);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                soundPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lPitch: &a&l" + k, "&7", "&7*Click to set the sound pitch", "&7for the command sound."), event -> {
                    if (stage != 3) {
                        itemMap.setTeleportPitch(Double.valueOf(k));
                        Menu.teleportPane(player, itemMap, stage);
                    } else {
                        itemMap.setCommandPitch(Double.valueOf(k));
                        Menu.commandPane(player, itemMap);
                    }
                }));
            }
        });
        soundPane.open(player);
    }

    private static void particlePane(Player player, ItemMap itemMap, int stage) {
        Interface particlePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 3) {
                particlePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the teleport menu."), event -> Menu.teleportPane(player, itemMap, stage)));
            } else {
                particlePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            }
            if (stage == 3) {
                particlePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&fFIREWORK_FAKE", "&7", "&7*Click to set the lifetime", "&7commands-particle of the item."), event -> Menu.lifePane(player, itemMap, "FIREWORK", 1)));
            }
            if (ServerUtils.hasSpecificUpdate("1_9")) {
                for (Particle particle : Particle.values()) {
                    if (stage != 3) {
                        particlePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&f" + particle.name(), "&7", "&7*Click to set the", "&7teleport-effect of the item."), event -> {
                            itemMap.setTeleportEffect(particle.name());
                            Menu.teleportPane(player, itemMap, stage);
                        }));
                        continue;
                    }
                    particlePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&f" + particle.name(), "&7", "&7*Click to set the", "&7commands-particle of the item."), event -> Menu.lifePane(player, itemMap, particle.name(), 0)));
                }
            } else {
                for (Effect effect : Effect.values()) {
                    if (stage != 3) {
                        particlePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&f" + effect.name(), "&7", "&7*Click to set the", "&7teleport-effect of the item."), event -> {
                            itemMap.setTeleportEffect(effect.name());
                            Menu.teleportPane(player, itemMap, stage);
                        }));
                        continue;
                    }
                    particlePane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&f" + effect.name(), "&7", "&7*Click to set the", "&7commands-particle of the item."), event -> Menu.lifePane(player, itemMap, effect.name(), 0)));
                }
            }
        });
        particlePane.open(player);
    }

    private static void lifePane(Player player, ItemMap itemMap, String particle, int stage) {
        Interface lifePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            lifePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the particle menu."), event -> Menu.particlePane(player, itemMap, 3)));
            lifePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom LifeTime", "&7", "&7*Click to set a lifetime (duration)", "&7value for particle effect."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PARTICLE LIFETIME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "170");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    if (stage == 0) {
                        itemMap.setCommandParticle(particle + ":" + ChatColor.stripColor((String)event.getMessage()));
                    } else {
                        Menu.explosionPane(player, itemMap, particle, Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PARTICLE LIFETIME");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.particlePane(event.getPlayer(), itemMap, 3);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                lifePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CYAN_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:9", k, false, false, "&9&lLifeTime: &a&l" + k + " Tick(s)", "&7", "&7*Click to set the lifetime", "&7(duration) of the particle effect."), event -> {
                    if (stage == 0) {
                        itemMap.setCommandParticle(particle + ":" + k);
                        Menu.commandPane(player, itemMap);
                    } else {
                        Menu.explosionPane(player, itemMap, particle, k);
                    }
                }));
            }
        });
        lifePane.open(player);
    }

    private static void explosionPane(Player player, ItemMap itemMap, String particle, int lifetime) {
        Interface patternPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            patternPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the particle menu."), event -> Menu.particlePane(player, itemMap, 3)));
            for (FireworkEffect.Type explosion : FireworkEffect.Type.values()) {
                patternPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&f" + explosion.name(), "&7", "&7*Click to set the pattern", "&7of the firework explosion effect."), event -> Menu.colorParticlePane(player, itemMap, particle, lifetime, explosion, null)));
            }
        });
        patternPane.open(player);
    }

    private static void colorParticlePane(Player player, ItemMap itemMap, String particle, int lifetime, FireworkEffect.Type explosion, DyeColor color1) {
        Interface colorPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            colorPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the particle menu."), event -> Menu.particlePane(player, itemMap, 3)));
            for (DyeColor color : DyeColor.values()) {
                colorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? color.name() + "_DYE" : "351:8", 1, false, false, "&f" + color.name(), "&7", "&7*Click to set the " + (color1 != null ? "&c&lend color" : "&9&lstart color"), "&7of the firework explosion effect."), event -> {
                    if (color1 != null) {
                        itemMap.setCommandParticle(particle + ":" + color1.name() + ":" + color.name() + ":" + explosion.name() + ":" + lifetime);
                        Menu.commandPane(player, itemMap);
                    } else {
                        Menu.colorParticlePane(player, itemMap, particle, lifetime, explosion, color);
                    }
                }));
            }
        });
        colorPane.open(player);
    }

    private static void enchantPane(Player player, ItemMap itemMap) {
        Interface enchantPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            enchantPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            for (Enchantment enchant : ItemHandler.getEnchants()) {
                boolean containsKey = itemMap.getEnchantments() != null && itemMap.getEnchantments().containsKey(ItemHandler.getEnchantName(enchant).toUpperCase());
                ItemStack enchantItem = ItemHandler.getItem(containsKey ? "ENCHANTED_BOOK" : "BOOK", 1, false, false, "&f" + ItemHandler.getEnchantName(enchant).toUpperCase(), "&7", "&7*Click to add this enchantment", "&7to the custom item.", "&7", "&9&lENABLED: &a" + (containsKey + "").toUpperCase(), containsKey ? "&7" : "", containsKey ? "&9&lLEVEL: &a" + itemMap.getEnchantments().get(ItemHandler.getEnchantName(enchant).toUpperCase()) : "");
                enchantPane.addButton(new Button(enchantItem, event -> {
                    if (containsKey) {
                        Map<String, Integer> enchantments = itemMap.getEnchantments();
                        enchantments.remove(ItemHandler.getEnchantName(enchant).toUpperCase());
                        itemMap.setEnchantments(enchantments);
                        Menu.enchantPane(player, itemMap);
                    } else {
                        Menu.enchantLevelPane(player, itemMap, enchant);
                    }
                }));
            }
        });
        enchantPane.open(player);
    }

    private static void enchantLevelPane(Player player, ItemMap itemMap, Enchantment enchant) {
        Interface enchantLevelPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            enchantLevelPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the enchant selection menu."), event -> Menu.enchantPane(player, itemMap)));
            enchantLevelPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Count", "&7", "&7*Click to set a custom damage", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ENCHANT LEVEL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "86");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    HashMap<String, Integer> enchantments = itemMap.getEnchantments() != null ? itemMap.getEnchantments() : new HashMap<String, Integer>();
                    enchantments.put(ItemHandler.getEnchantName(enchant).toUpperCase(), Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    itemMap.setEnchantments(enchantments);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ENCHANT LEVEL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.enchantPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                enchantLevelPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lLevel: &a&l" + k, "&7", "&7*Click to set the", "&7level of the item enchantment.", "&7", "&7This will be &l" + ItemHandler.getEnchantName(enchant).toUpperCase() + ":" + k), event -> {
                    HashMap<String, Integer> enchantments = itemMap.getEnchantments() != null ? itemMap.getEnchantments() : new HashMap<String, Integer>();
                    enchantments.put(ItemHandler.getEnchantName(enchant).toUpperCase(), k);
                    itemMap.setEnchantments(enchantments);
                    Menu.enchantPane(player, itemMap);
                }));
            }
        });
        enchantLevelPane.open(player);
    }

    private static void flagPane(Player player, ItemMap itemMap) {
        Interface flagPane = new Interface(true, 5, exitButton, GUIName, player);
        flagPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> {
            Menu.setItemFlags(itemMap);
            Menu.creatingPane(player, itemMap);
        }));
        SchedulerUtils.runAsync(() -> {
            flagPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, itemMap.isOpBypass(), false, "&a&l&nAllowOpBypass", "&7", "&a&lTrue&f:&7 Allows players who are OP to", "&7bypass any itemflags that add", "&7restrictions for this item.", "&7", "&c&lFalse&f:&7 Players who are OP will be", "&7restricted by itemflags that add", "&7restrictions for this item.", "&7", "&9&lENABLED: &a" + (itemMap.isOpBypass() + "").toUpperCase()), event -> {
                itemMap.setOpBypass(!itemMap.isOpBypass());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(itemMap.isCreativeBypass() ? (ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1") : "GOLDEN_APPLE", 1, itemMap.isCreativeBypass(), false, "&a&l&nCreativeBypass", "&7", "&a&lTrue&f:&7 Allows players who are in Creative", "&7to bypass any itemflags that add", "&7restrictions for this item.", "&7", "&c&lFalse&f:&7 Players who are in Creative will", "&7be restricted by itemflags that add", "&7restrictions for this item.", "&7", "&9&lENABLED: &a" + (itemMap.isCreativeBypass() + "").toUpperCase()), event -> {
                itemMap.setCreativeBypass(!itemMap.isCreativeBypass());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LAPIS_LAZULI" : "351:4", 1, itemMap.isGlowing(), false, "&a&l&nGlowing", "&7", "&a&lTrue&f:&7 The item will glow as if it was enchanted!", "&7", "&c&lFalse&f:&7 The item will not glow.", "&7", "&9&lENABLED: &a" + (itemMap.isGlowing() + "").toUpperCase()), event -> {
                itemMap.setGlowing(!itemMap.isGlowing());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "DIAMOND_SHOVEL" : "277", 7, itemMap.isStackable(), false, "&a&l&nStackable", "&7", "&a&lTrue&f:&7 The item will be stackable with itself!", "&7", "&c&lFalse&f:&7 The item stack only if it did in vanilla.", "&7", "&9&lENABLED: &a" + (itemMap.isStackable() + "").toUpperCase()), event -> {
                itemMap.setStackable(!itemMap.isStackable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_HELMET" : "306", 1, itemMap.isNotHat(), false, "&a&l&nNot Hat", "&7", "&a&lTrue&f:&7 Prevents the item from being worn as a hat", "&7using the command /hat from plugins", "&7such as Essentials or CMI.", "&7", "&c&lFalse&f:&7 Allows the item to be worn as a /hat.", "&7", "&9&lENABLED: &a" + (itemMap.isNotHat() + "").toUpperCase()), event -> {
                itemMap.setNotHat(!itemMap.isNotHat());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LAVA_BUCKET" : "327", 1, itemMap.isNoClear(), false, "&a&l&nNo Clear", "&7", "&a&lTrue&f:&7 Prevents the item from being cleared", "&7using the command /clear from plugins", "&7such as Essentials or CMI.", "&7", "&c&lFalse&f:&7 Allows the item to be cleared.", "&7", "&9&lENABLED: &a" + (itemMap.isNoClear() + "").toUpperCase()), event -> {
                itemMap.setNoClear(!itemMap.isNoClear());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "POPPY" : "38", 1, itemMap.isInventoryClose(), false, "&a&l&nInventory Close", "&7", "&a&lTrue&f:&7 Closes the players current", "&7inventory when clicking the item.", "&7", "&c&lFalse&f:&7 The current inventory will not", "&7be closed when clicking the item.", "&7", "&9&lENABLED: &a" + (itemMap.isInventoryClose() + "").toUpperCase()), event -> {
                itemMap.setCloseInventory(!itemMap.isInventoryClose());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, itemMap.isAutoRemove(), false, "&a&l&nAuto Remove", "&7", "&a&lTrue&f:&7 Automatically removes the", "&7item from the players inventory", "&7when entering or joining a", "&7world that is not defined", "&7under the enabled-worlds.", "&7", "&c&lFalse&f:&7 The player will keep the", "&7item when entering or joining", "&7an undefined world.", "&7", "&9&lENABLED: &a" + (itemMap.isAutoRemove() + "").toUpperCase()), event -> {
                itemMap.setAutoRemove(!itemMap.isAutoRemove());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, itemMap.isOverwritable(), false, "&a&l&nOverwrite", "&7", "&a&lTrue&f: &7Allows the item to overwrite", "&7any existing items in the defined slot.", "&7", "&c&lFalse&f:&7 The item will not overwrite other items.", "&7When the slot is full it", "&7will fail to give the item, unless", "&7the give-next or move-next flag is set to &a&lTrue&7.", "&7", "&9&lENABLED: &a" + (itemMap.isOverwritable() + "").toUpperCase()), event -> {
                itemMap.setOverwritable(!itemMap.isOverwritable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("CACTUS", 1, itemMap.isDisposable(), false, "&a&l&nDisposable", "&7", "&a&lTrue&f:&7 If the item has a command", "&7defined, running the command", "&7will remove x1 of the item.", "&7", "&c&lFalse&f:&7 Running item commands will", "&7not lower the items count.", "&7", "&9&lENABLED: &a" + (itemMap.isDisposable() + "").toUpperCase()), event -> {
                itemMap.setDisposable(!itemMap.isDisposable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WOODEN_SWORD" : "268", 1, itemMap.isVanilla(), false, "&a&l&nVanilla", "&7", "&a&lTrue&f:&7 The item will be given as a default no-name item.", "&cNOTE: &7Itemflags and commands will NOT work", "&7unless the vanilla-status or vanilla-control", "&7itemflags are defined.", "&7", "&c&lFalse&f:&7 The item will be given", "&7as an custom item, allowing all", "&7ItemJoin properties to continue working.", "&7", "&9&lENABLED: &a" + (itemMap.isVanilla() + "").toUpperCase()), event -> {
                itemMap.setVanilla(!itemMap.isVanilla());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("LEATHER_CHESTPLATE", 1, itemMap.isVanillaStatus(), false, "&a&l&nVanilla Status", "&7", "&a&lTrue&f: &7Allows the Vanilla itemflag to retain", "&7ItemJoin properties without", "&7making it only a ItemJoin specific item.", "&cNOTE: &7Useful for trying to implement", "&7ItemJoin items into other plugins.", "&7", "&c&lFalse&f:&7 The item will be given", "&7as a custom item, allowing all", "&7ItemJoin properties to continue working.", "&7", "&9&lENABLED: &a" + (itemMap.isVanillaStatus() + "").toUpperCase()), event -> {
                itemMap.setVanillaStatus(!itemMap.isVanillaStatus());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WOODEN_PICKAXE" : "270", 1, itemMap.isVanillaControl(), false, "&a&l&nVanilla Control", "&7", "&a&lTrue&f: &7Allows the Vanilla itemflag to retain", "&7the use of commands and itemflags.", "&7", "&c&lFalse&f:&7 The item will be given", "&7as an custom item, allowing all", "&7ItemJoin properties to continue working.", "&7", "&9&lENABLED: &a" + (itemMap.isVanillaControl() + "").toUpperCase()), event -> {
                itemMap.setVanillaControl(!itemMap.isVanillaControl());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, itemMap.isIpLimited(), false, "&a&l&nIP Limit", "&7", "&a&lTrue&f:&7 The item will be tied to the players IP.", "&7No other players using the same IP will receive the item.", "&7Useful to prevent item duplication.", "&7", "&c&lFalse&f:&7 The item will not be tied to a players IP.", "&7Other player accounts using the same IP will receive the item.", "&7", "&9&lENABLED: &a" + (itemMap.isIpLimited() + "").toUpperCase()), event -> {
                itemMap.setIpLimited(!itemMap.isIpLimited());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(itemMap.isUnbreakable() ? "ENCHANTED_BOOK" : "BOOK", 1, itemMap.isUnbreakable(), false, "&a&l&nUnbreakable", "&7", "&a&lTrue&f:&7 Allows the item to be unbreakable or INDESTRUCTIBLE!", "&7", "&c&lFalse&f:&7 The item will be damageable when being used.", "&7", "&7This flag only takes effect on items which have durability.", "&7", "&9&lENABLED: &a" + (itemMap.isUnbreakable() + "").toUpperCase()), event -> {
                itemMap.setUnbreakable(!itemMap.isUnbreakable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "FILLED_MAP" : "358", 1, itemMap.isFlagsInfo(), false, "&a&l&nHide Flags", "&7", "&a&lTrue&f: &7Hides all information tags from the item", "&7such as firework colors, damage values, enchants, etc.", "&7", "&c&lFalse&f:&7 The item will have information tags visible.", "&7", "&9&lENABLED: &a" + (itemMap.isFlagsInfo() + "").toUpperCase()), event -> {
                itemMap.setFlagsInfo(!itemMap.isFlagsInfo());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? (itemMap.isEnchantmentsInfo() ? "EXPERIENCE_BOTTLE" : "GLASS_BOTTLE") : (itemMap.isEnchantmentsInfo() ? "384" : "374"), 1, itemMap.isEnchantmentsInfo(), false, "&a&l&nHide Enchantments", "&7", "&a&lTrue&f: &7Hides all enchantments on an item.", "&7", "&c&lFalse&f:&7 The item will have enchantments visible.", "&7", "&9&lENABLED: &a" + (itemMap.isEnchantmentsInfo() + "").toUpperCase()), event -> {
                itemMap.setEnchantmentsInfo(!itemMap.isEnchantmentsInfo());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENDER_EYE" : "381", 1, itemMap.isAttributesInfo(), false, "&a&l&nHide Attributes", "&7", "&a&lTrue&f: &7Hides all attribute tags from the item", "&7such damage values, attack speed, hit points, etc.", "&7Typically this is the information that", "&7starts with (When in Main Hand:).", "&7", "&c&lFalse&f:&7 The item will have information tags visible.", "&7", "&9&lENABLED: &a" + (itemMap.isAttributesInfo() + "").toUpperCase()), event -> {
                itemMap.setAttributesInfo(!itemMap.isAttributesInfo());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("IRON_SWORD", 1, itemMap.isDurabilityBar(), false, "&a&l&nHide Durability", "&7", "&a&lTrue&f:&7 The durability bar of the damageable ", "&7item will be hidden.", "&cNOTE: &7Items with this flag will still break,", "&7unless the unbreakable flag is set to &a&lTrue&7.", "&7", "&c&lFalse&f:&7 The durability bar of the", "&7damageable item will be shown as normal.", "&7", "&9&lENABLED: &a" + (itemMap.isDurabilityBar() + "").toUpperCase()), event -> {
                itemMap.setDurabilityBar(!itemMap.isDurabilityBar());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("COBBLESTONE", 1, itemMap.isPlaceable(), false, "&a&l&nPlacement", "&7", "&a&lTrue&f: &7Prevents the item from being", "&7placed on the ground,", "&7in any item-frames, and entities.", "&7", "&c&lFalse&f: &7Item will be able to be placed.", "&7", "&9&lENABLED: &a" + (itemMap.isPlaceable() + "").toUpperCase()), event -> {
                itemMap.setPlaceable(!itemMap.isPlaceable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("BEDROCK", 1, itemMap.isMovement(), false, "&a&l&nInventory Modify", "&7", "&a&lTrue&f: &7Prevents the item from being", "&7moved or switched to other slots", "&7and blocks placement in item-frames.", "&7", "&c&lFalse&f:&7 Allows the item to be moved", "&7freely inside the players inventory.", "&7", "&9&lENABLED: &a" + (itemMap.isMovement() + "").toUpperCase()), event -> {
                itemMap.setMovement(!itemMap.isMovement());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("DIAMOND_BOOTS", 1, itemMap.isEquip(), false, "&a&l&nCancel Equip", "&7", "&a&lTrue&f: &7Prevents the item from being", "&7moved or switched to armor slots.", "&7", "&c&lFalse&f:&7 Allows the item to be moved", "&7freely inside the players inventory.", "&7", "&9&lENABLED: &a" + (itemMap.isEquip() + "").toUpperCase()), event -> {
                itemMap.setEquip(!itemMap.isEquip());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("EGG", 1, itemMap.isAnimated(), false, "&a&l&nAnimate", "&7", "&a&lTrue&f: &7Allows the item to animate between", "&7its different iterations defined", "&7under the animations tab.", "&7", "&c&lFalse&f: &7Item will not animate.", "&7", "&9&lENABLED: &a" + (itemMap.isAnimated() + "").toUpperCase()), event -> {
                if (itemMap.isAnimated()) {
                    itemMap.setAnimate(false);
                    if (itemMap.getDynamicNames() != null && !itemMap.getDynamicNames().isEmpty()) {
                        itemMap.setCustomName(ItemHandler.cutDelay(itemMap.getDynamicNames().get(0)));
                        itemMap.setDynamicNames(new ArrayList<String>());
                    }
                } else {
                    itemMap.setAnimate(true);
                    if (itemMap.getCustomName() != null && !itemMap.getCustomName().isEmpty()) {
                        ArrayList<String> names = new ArrayList<String>();
                        names.add(itemMap.getCustomName());
                        itemMap.setDynamicNames(names);
                    }
                }
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, itemMap.isDynamic(), false, "&a&l&nDynamic", "&7", "&a&lTrue&f: &7Allows the item to dynamically", "&7update every 100 ticks", "&7Useful for updating placeholders.", "&7", "&c&lFalse&f: &7Item will not update its name, lore, etc.", "&7", "&9&lENABLED: &a" + (itemMap.isDynamic() + "").toUpperCase()), event -> {
                itemMap.setDynamic(!itemMap.isDynamic());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 4, itemMap.isDynamicCount(), false, "&a&l&nDynamic Count", "&7", "&a&lTrue&f: &7When an item dynamically updates", "&7the items count will be reset to its default.", "&7Only functions with the dynamic or animate itemflag.", "&7", "&c&lFalse&f: &7The item will keep its existing count.", "&7", "&9&lENABLED: &a" + (itemMap.isDynamicCount() + "").toUpperCase()), event -> {
                itemMap.setDynamicCount(!itemMap.isDynamicCount());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CHEST_MINECART" : "342", 1, itemMap.isItemStore(), false, "&a&l&nItem Store", "&7", "&a&lTrue&f:&7 Prevents the storage of the item in any containers.", "&7Such as chests, armor stands, anvils, etc.", "&7", "&c&lFalse&f:&7 The item can be stored in containers.", "&7", "&9&lENABLED: &a" + (itemMap.isItemStore() + "").toUpperCase()), event -> {
                itemMap.setItemStore(!itemMap.isItemStore());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, itemMap.isCountLock(), false, "&a&l&nCount Lock", "&7", "&a&lTrue&f:&7 The item can be used indefinitely.", "&7Useful to give a player infinite apples.", "&cNOTE: &7This will overwrite the disposable flag.", "&7", "&c&lFalse&f:&7 The item will be removed from the inventory on use.", "&7", "&9&lENABLED: &a" + (itemMap.isCountLock() + "").toUpperCase()), event -> {
                itemMap.setCountLock(!itemMap.isCountLock());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, itemMap.isDeathKeepable(), false, "&a&l&nDeath Keep", "&7", "&a&lTrue&f:&7 On death, the item will remain", "&7in players inventory on respawn.", "&7", "&c&lFalse&f:&7 On death, the item will be dropped", "&7at the death location as normal.", "&7", "&9&lENABLED: &a" + (itemMap.isDeathKeepable() + "").toUpperCase()), event -> {
                itemMap.setDeathKeepable(!itemMap.isDeathKeepable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("BONE", 1, itemMap.isDeathDroppable(), false, "&a&l&nDeath Drops", "&7", "&a&lTrue&f:&7 On death, the item will be removed", "&7from the players inventory.", "&7", "&c&lFalse&f:&7 On death, the item will be dropped", "&7at the death location as normal.", "&7", "&9&lENABLED: &a" + (itemMap.isDeathDroppable() + "").toUpperCase()), event -> {
                itemMap.setDeathDroppable(!itemMap.isDeathDroppable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, itemMap.isSelfDroppable(), false, "&a&l&nSelf Drops", "&7", "&a&lTrue&f: &7Prevents the item from being dropped", "&7by the player, returns it back to their inventory.", "&7", "&c&lFalse&f: &7Allows the item to be dropped.", "&7", "&9&lENABLED: &a" + (itemMap.isSelfDroppable() + "").toUpperCase()), event -> {
                itemMap.setSelfDroppable(!itemMap.isSelfDroppable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "FLINT_AND_STEEL" : "259", 1, itemMap.isEraseDroppable(), false, "&a&l&nErase Drops", "&7", "&a&lTrue&f: &7Deletes the item if it is", "&7dropped by the player.", "&7", "&c&lFalse&f: &7Allows the item to be dropped.", "&7", "&e&nNote: &eThis is similar to self-drops", "&eand death-drops, but instead the", "&eitem is entirely deleted.", "&7", "&9&lENABLED: &a" + (itemMap.isEraseDroppable() + "").toUpperCase()), event -> {
                itemMap.setEraseDroppable(!itemMap.isEraseDroppable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("FURNACE", 1, itemMap.isItemModify(), false, "&a&l&nItem Modifiable", "&7", "&a&lTrue&f: &7Blocks the item from being", "&7repaired or enchanted in-game.", "&7", "&c&lFalse&f: &7Allows items to", "&7be repaired and enchanted.", "&7", "&9&lENABLED: &a" + (itemMap.isItemModify() + "").toUpperCase()), event -> {
                itemMap.setItemModify(!itemMap.isItemModify());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("ANVIL", 1, itemMap.isItemRepairable(), false, "&a&l&nItem Repairable", "&7", "&a&lTrue&f: &7Blocks the item from being", "&7used in an anvil or repaired.", "&7", "&c&lFalse&f: &7Allows the item to be repaired.", "&7", "&9&lENABLED: &a" + (itemMap.isItemRepairable() + "").toUpperCase()), event -> {
                itemMap.setItemRepairable(!itemMap.isItemRepairable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CRAFTING_TABLE" : "58", 1, itemMap.isItemCraftable(), false, "&a&l&nItem Craftable", "&7", "&a&lTrue&f: &7Blocks the item from being", "&7used in a crafting recipe.", "&7", "&c&lFalse&f: &7Item will be usable in", "&7a crafting recipe.", "&7", "&9&lENABLED: &a" + (itemMap.isItemCraftable() + "").toUpperCase()), event -> {
                itemMap.setItemCraftable(!itemMap.isItemCraftable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("BOW", 1, itemMap.isCancelEvents(), false, "&a&l&nCancel Events", "&7", "&a&lTrue&f: &7Prevents almost any event from executing", "&7when right-clicking the item.", "&7", "&c&lFalse&f: &7Allows item events to be executed freely.", "&7", "&9&lENABLED: &a" + (itemMap.isCancelEvents() + "").toUpperCase()), event -> {
                itemMap.setCancelEvents(!itemMap.isCancelEvents());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WHEAT_SEEDS" : "295", 1, itemMap.isAlwaysGive(), false, "&a&l&nAlways Give", "&7", "&a&lTrue&f: &7Gives the item every time the player", "&7performs one of the triggers actions.", "&7regardless of already having the item.", "&7", "&cNOTE: &7Don't use this if you want only ONE instance of the item.", "&7", "&c&lFalse&f: &7Normal item restrictions will apply.", "&7", "&9&lENABLED: &a" + (itemMap.isAlwaysGive() + "").toUpperCase()), event -> {
                itemMap.setAlwaysGive(!itemMap.isAlwaysGive());
                Menu.flagPane(player, itemMap);
            }));
            if (itemMap.getMaterial().toString().contains("TIPPED_ARROW") || itemMap.getMaterial().toString().contains("ARROW")) {
                flagPane.addButton(new Button(ItemHandler.getItem("ENDER_PEARL", 1, itemMap.isTeleport(), false, "&a&l&nTeleport", "&7", "&a&lTrue&f: &7Teleports the Player to the location", "&7that the arrow landed.", "&cNOTE: &7This only works if the arrow is fired by a Bow.", "&9&lENABLED: &a" + (itemMap.isTeleport() + "").toUpperCase()), event -> {
                    itemMap.setTeleport(!itemMap.isTeleport());
                    Menu.flagPane(player, itemMap);
                }));
            } else {
                flagPane.addButton(new Button(ItemHandler.getItem("ENDER_PEARL", 1, false, false, "&c&l&nX", "&7", "&c*Not Available")));
            }
            flagPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTING_TABLE" : "116", 1, itemMap.isItemChangeable(), false, "&a&l&nAllow Modifications", "&7", "&a&lTrue&f: &7Allows the players to modify the item", "&7while retaining all properties.", "&7", "&c&lFalse&f: &7Item will not be modifiable.", "&7", "&9&lENABLED: &a" + (itemMap.isItemChangeable() + "").toUpperCase()), event -> {
                itemMap.setItemChangeable(!itemMap.isItemChangeable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("ITEM_FRAME", 1, itemMap.isGiveNext(), false, "&a&l&nGive Next", "&7", "&a&lTrue&f: &7Gives the item to the next available slot", "&7only if the defined slot already has an existing item.", "&cNOTE: &7The overwrite flag will not work.", "&7", "&c&lFalse&f:&7 The item will be only given in the defined slot.", "&7If an item is already in the slot the", "&7item wont be given, unless the overwrite", "&7flag is set to &l&aTrue&7.", "&7", "&9&lENABLED: &a" + (itemMap.isGiveNext() + "").toUpperCase()), event -> {
                itemMap.setGiveNext(!itemMap.isGiveNext());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("MINECART", 1, itemMap.isMoveNext(), false, "&a&l&nMove Next", "&7", "&a&lTrue&f: &7Moves the existing item to the next available slot", "&7only if the defined slot already has an existing item.", "&cNOTE: &7The overwrite flag will not work.", "&7", "&c&lFalse&f: &7The item will be only given in the defined slot.", "&7If an item is already in the slot the", "&7item wont be given, unless the overwrite", "&7flag is set to &l&aTrue&7.", "&7", "&9&lENABLED: &a" + (itemMap.isMoveNext() + "").toUpperCase()), event -> {
                itemMap.setMoveNext(!itemMap.isMoveNext());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, itemMap.isDropFull(), false, "&a&l&nDrop Full", "&7", "&a&lTrue&f: &7Drops the item on the ground if", "&7the players inventory is full.", "&7", "&c&lFalse&f: &7Fails to give the item", "&7if the players inventory is full.", "&7", "&9&lENABLED: &a" + (itemMap.isDropFull() + "").toUpperCase()), event -> {
                itemMap.setDropFull(!itemMap.isDropFull());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, itemMap.isSelectable(), false, "&a&l&nSelectable", "&7", "&a&lTrue&f: &7Prevents the item from being", "&7held in the players hand.", "&7", "&c&lFalse&f: &7Allows the item to be selected.", "&7", "&9&lENABLED: &a" + (itemMap.isSelectable() + "").toUpperCase()), event -> {
                itemMap.setSelectable(!itemMap.isSelectable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(ItemHandler.getItem("DIRT", 64, itemMap.isSplittable(), false, "&a&l&nSplittable", "&7", "&a&lTrue&f: &7Prevents the item from being", "&7split into multiple stacks via", "&7right-click or click dragging.", "&7", "&c&lFalse&f: &7Allows the item to be split", "&7into multiple stacks.", "&7", "&9&lENABLED: &a" + (itemMap.isSplittable() + "").toUpperCase()), event -> {
                itemMap.setSplittable(!itemMap.isSplittable());
                Menu.flagPane(player, itemMap);
            }));
            flagPane.addButton(new Button(fillerPaneBItem), 29);
        });
        flagPane.open(player);
    }

    private static void setItemFlags(ItemMap itemMap) {
        String itemflags = "";
        if (itemMap.isVanilla()) {
            itemflags = itemflags + "VANILLA, ";
        }
        if (itemMap.isVanillaStatus()) {
            itemflags = itemflags + "VANILLA-STATUS, ";
        }
        if (itemMap.isVanillaControl()) {
            itemflags = itemflags + "VANILLA-CONTROL, ";
        }
        if (itemMap.isIpLimited()) {
            itemflags = itemflags + "IP-LIMIT, ";
        }
        if (itemMap.isUnbreakable()) {
            itemflags = itemflags + "UNBREAKABLE, ";
        }
        if (itemMap.isAttributesInfo()) {
            itemflags = itemflags + "HIDE-ATTRIBUTES, ";
        }
        if (itemMap.isEnchantmentsInfo()) {
            itemflags = itemflags + "HIDE-ENCHANTS, ";
        }
        if (itemMap.isNotHat()) {
            itemflags = itemflags + "NOT-HAT, ";
        }
        if (itemMap.isNoClear()) {
            itemflags = itemflags + "NO-CLEAR, ";
        }
        if (itemMap.isFlagsInfo()) {
            itemflags = itemflags + "HIDE-FLAGS, ";
        }
        if (itemMap.isDurabilityBar()) {
            itemflags = itemflags + "HIDE-DURABILITY, ";
        }
        if (itemMap.isPlaceable()) {
            itemflags = itemflags + "PLACEMENT, ";
        }
        if (itemMap.isEquip()) {
            itemflags = itemflags + "CANCEL-EQUIP, ";
        }
        if (itemMap.isMovement()) {
            itemflags = itemflags + "INVENTORY-MODIFY, ";
        }
        if (itemMap.isInventoryClose()) {
            itemflags = itemflags + "INVENTORY-CLOSE, ";
        }
        if (itemMap.isDynamic()) {
            itemflags = itemflags + "DYNAMIC, ";
        }
        if (itemMap.isDynamicCount()) {
            itemflags = itemflags + "DYNAMIC-COUNT, ";
        }
        if (itemMap.isAnimated()) {
            itemflags = itemflags + "ANIMATE, ";
        }
        if (itemMap.isGlowing()) {
            itemflags = itemflags + "GLOWING, ";
        }
        if (itemMap.isStackable()) {
            itemflags = itemflags + "STACKABLE, ";
        }
        if (itemMap.isSelectable()) {
            itemflags = itemflags + "SELECTABLE, ";
        }
        if (itemMap.isSplittable()) {
            itemflags = itemflags + "SPLITTABLE, ";
        }
        if (itemMap.isItemStore()) {
            itemflags = itemflags + "ITEM-STORE, ";
        }
        if (itemMap.isCancelEvents()) {
            itemflags = itemflags + "CANCEL-EVENTS, ";
        }
        if (itemMap.isCountLock()) {
            itemflags = itemflags + "COUNT-LOCK, ";
        }
        if (itemMap.isDeathKeepable()) {
            itemflags = itemflags + "DEATH-KEEP, ";
        }
        if (itemMap.isDeathDroppable()) {
            itemflags = itemflags + "DEATH-DROPS, ";
        }
        if (itemMap.isSelfDroppable()) {
            itemflags = itemflags + "SELF-DROPS, ";
        }
        if (itemMap.isEraseDroppable()) {
            itemflags = itemflags + "ERASE-DROPS, ";
        }
        if (itemMap.isDisposable()) {
            itemflags = itemflags + "DISPOSABLE, ";
        }
        if (itemMap.isItemModify()) {
            itemflags = itemflags + "ITEM-MODIFIABLE, ";
        }
        if (itemMap.isItemRepairable()) {
            itemflags = itemflags + "ITEM-REPAIRABLE, ";
        }
        if (itemMap.isItemCraftable()) {
            itemflags = itemflags + "ITEM-CRAFTABLE, ";
        }
        if (itemMap.isAlwaysGive()) {
            itemflags = itemflags + "ALWAYS-GIVE, ";
        }
        if (itemMap.isItemChangeable()) {
            itemflags = itemflags + "ITEM-CHANGEABLE, ";
        }
        if (itemMap.isTeleport()) {
            itemflags = itemflags + "TELEPORT, ";
        }
        if (itemMap.isGiveNext()) {
            itemflags = itemflags + "GIVE-NEXT, ";
        }
        if (itemMap.isMoveNext()) {
            itemflags = itemflags + "MOVE-NEXT, ";
        }
        if (itemMap.isDropFull()) {
            itemflags = itemflags + "DROP-FULL, ";
        }
        if (itemMap.isOverwritable()) {
            itemflags = itemflags + "OVERWRITE, ";
        }
        if (itemMap.isOpBypass()) {
            itemflags = itemflags + "ALLOWOPBYPASS, ";
        }
        if (itemMap.isAutoRemove()) {
            itemflags = itemflags + "AUTO-REMOVE, ";
        }
        if (itemMap.isCreativeBypass()) {
            itemflags = itemflags + "CREATIVEBYPASS, ";
        }
        if (itemflags.endsWith(", ")) {
            itemflags = itemflags.substring(0, itemflags.length() - 2);
        }
        itemMap.setItemFlags(itemflags);
    }

    private static void triggerPane(Player player, ItemMap itemMap) {
        Interface triggerPane = new Interface(false, 4, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, itemMap.isGiveOnDisabled(), false, "&c&l&nDISABLED", "&7", "&7*Prevents the item from given", "&7through the use of triggers.", "&7", "&7Useful to only get the item", "&7using &l/itemjoin get <item>", "&9&lENABLED: &a" + (itemMap.isGiveOnDisabled() + "").toUpperCase()), event -> {
                if (itemMap.isGiveOnDisabled()) {
                    itemMap.setGiveOnDisabled(false);
                } else {
                    itemMap.setGiveOnJoin(false);
                    itemMap.setOnlyFirstJoin(false, true);
                    itemMap.setOnlyFirstWorld(false, true);
                    itemMap.setOnlyFirstLife(false, true);
                    itemMap.setOnlyFirstWild(false, true);
                    itemMap.setGiveOnRespawn(false);
                    itemMap.setGiveOnRespawnWild(false);
                    itemMap.setGiveOnRespawnPoint(false);
                    itemMap.setGiveOnWorldSwitch(false);
                    itemMap.setUseOnLimitSwitch(false);
                    itemMap.setGiveOnRegionEnter(false);
                    itemMap.setGiveOnRegionLeave(false);
                    itemMap.setGiveOnRegionAccess(false);
                    itemMap.setGiveOnRegionEgress(false);
                    itemMap.setGiveOnDisabled(true);
                }
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, itemMap.isGiveOnJoin() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife() && !itemMap.isOnlyFirstJoin() && !itemMap.isOnlyFirstWorld(), false, "&a&l&nJoin", "&7", "&7*Gives the item when the", "&7player logs into the server.", "&9&lENABLED: &a" + ((itemMap.isGiveOnJoin() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife() && !itemMap.isOnlyFirstJoin() && !itemMap.isOnlyFirstWorld()) + "").toUpperCase()), event -> {
                itemMap.setGiveOnJoin(!itemMap.isGiveOnJoin());
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, itemMap.isGiveOnWorldSwitch() && !itemMap.isOnlyFirstWorld(), false, "&a&l&nWorld Switch", "&7", "&7*Gives the item when the", "&7player teleports to one", "&7of the specified worlds.", "&9&lENABLED: &a" + ((itemMap.isGiveOnWorldSwitch() && !itemMap.isOnlyFirstWorld()) + "").toUpperCase()), event -> {
                itemMap.setGiveOnWorldSwitch(!itemMap.isGiveOnWorldSwitch());
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, itemMap.isGiveOnRespawn() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife(), false, "&a&l&nRespawn", "&7", "&7*Gives the item when the", "&7player respawns from a death event.", "&9&lENABLED: &a" + ((itemMap.isGiveOnRespawn() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife()) + "").toUpperCase()), event -> {
                itemMap.setGiveOnRespawn(!itemMap.isGiveOnRespawn());
                itemMap.setGiveOnRespawnWild(false);
                itemMap.setGiveOnRespawnPoint(false);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "FILLED_MAP" : "MAP", 1, itemMap.isOnlyFirstJoin(), true, "&e&l&nFirst Join", "&7", "&7*Gives the item when the", "&7player logs into the server", "&7for the first time only.", "&7This will overwrite any triggers", "&7such as respawn, and world-switch.", "&9&lENABLED: &a" + (itemMap.isOnlyFirstJoin() + "").toUpperCase()), event -> {
                itemMap.setOnlyFirstJoin(!itemMap.isOnlyFirstJoin(), true);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("STONE_SWORD", 1, itemMap.isOnlyFirstWorld(), false, "&e&l&nFirst World", "&7", "&7*Gives the item when the", "&7player enters each of the defined", "&7worlds for the first time.", "&7", "&7This flag overwrites any triggers", "&7such as respawn, and join.", "&9&lENABLED: &a" + (itemMap.isOnlyFirstWorld() + "").toUpperCase()), event -> {
                itemMap.setOnlyFirstWorld(!itemMap.isOnlyFirstWorld(), true);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "TOTEM_OF_UNDYING" : "322:1", 1, itemMap.isOnlyFirstLife(), false, "&e&l&nFirst Life", "&7", "&7*Gives the item when the", "&7player logs into the server", "&7for the first time only,", "&7but will give the item", "&7EVERY TIME on player RESPAWN.", "&7This flag overwrites any triggers", "&7such as respawn, and join.", "&9&lENABLED: &a" + (itemMap.isOnlyFirstLife() + "").toUpperCase()), event -> {
                itemMap.setOnlyFirstLife(!itemMap.isOnlyFirstLife(), true);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SAPLING" : "6", 1, itemMap.isOnlyFirstWild(), false, "&e&l&nFirst Wild", "&7", "&7*Gives the item when the", "&7player logs into the server", "&7for the first time only,", "&7but will give the item", "&7EVERY TIME on player RESPAWN.", "&c&nException:&7 The item will not be given if", "&7spawning in a &lBED&7, &lANCHOR&7, or &lSPAWN-POINT&7.", "&7This flag overwrites any triggers", "&7such as respawn, and join.", "&9&lENABLED: &a" + (itemMap.isOnlyFirstWild() + "").toUpperCase()), event -> {
                itemMap.setOnlyFirstWild(!itemMap.isOnlyFirstWild(), true);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_DOOR" : "330", 1, itemMap.isGiveOnPermissionSwitch(), false, "&e&l&nPermission Switch", "&7", "&7*Gives the item when the", "&7player is granted permission", "&7to receive the item.", "&7", "&7Removes the item when the", "&7player has the permission revoked.", "&9&lENABLED: &a" + (itemMap.isGiveOnPermissionSwitch() + "").toUpperCase()), event -> {
                itemMap.setGiveOnPermissionSwitch(!itemMap.isGiveOnPermissionSwitch());
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("COAL", 1, itemMap.isGiveOnRespawnWild() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife(), false, "&e&l&nRespawn Wild", "&7", "&7*Gives the item when the", "&7player respawns from a death event.", "&7", "&c&nException:&7 The item will &lNOT&7 be given if", "&7spawning in a &lBED&7, &lANCHOR&7, or &lSPAWN-POINT&7.", "&9&lENABLED: &a" + ((itemMap.isGiveOnRespawnWild() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife()) + "").toUpperCase()), event -> {
                itemMap.setGiveOnRespawnWild(!itemMap.isGiveOnRespawnWild());
                itemMap.setGiveOnRespawn(false);
                itemMap.setGiveOnRespawnPoint(false);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("TORCH", 1, itemMap.isGiveOnRespawnPoint() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife(), false, "&e&l&nRespawn Point", "&7", "&7*Gives the item when the", "&7player respawns from a death event.", "&7", "&c&nException:&7 The item will &lONLY&7 be given if", "&7spawning in a &lBED&7, &lANCHOR&7, or &lSPAWN-POINT&7.", "&9&lENABLED: &a" + ((itemMap.isGiveOnRespawnPoint() && !itemMap.isOnlyFirstWild() && !itemMap.isOnlyFirstLife()) + "").toUpperCase()), event -> {
                itemMap.setGiveOnRespawnPoint(!itemMap.isGiveOnRespawnPoint());
                itemMap.setGiveOnRespawn(false);
                itemMap.setGiveOnRespawnWild(false);
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENDER_PEARL" : "368", 1, itemMap.isGiveOnTeleport(), false, "&e&l&nTeleport", "&7", "&7*Gives the item when the", "&7player teleports to a new location.", "&9&lENABLED: &a" + (itemMap.isGiveOnTeleport() + "").toUpperCase()), event -> {
                itemMap.setGiveOnTeleport(!itemMap.isGiveOnTeleport());
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(ItemHandler.getItem("LEVER", 1, itemMap.isUseOnLimitSwitch(), false, "&e&l&nGamemode Switch", "&7", "&7*Gives the item when the", "&7player changes gamemodes to any", "&7of the defined limit-modes.", "&9&lENABLED: &a" + (itemMap.isUseOnLimitSwitch() + "").toUpperCase()), event -> {
                itemMap.setUseOnLimitSwitch(!itemMap.isUseOnLimitSwitch());
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem("MINECART", 1, itemMap.isGiveOnRegionEnter(), false, "&e&l&nRegion Enter", "&7", "&7*Gives the item when the", "&7player enters any of the enabled-regions.", "&9&lENABLED: &a" + (itemMap.isGiveOnRegionEnter() + "").toUpperCase()), event -> {
                if (itemMap.isGiveOnRegionEnter()) {
                    itemMap.setGiveOnRegionEnter(false);
                } else {
                    itemMap.setGiveOnRegionEnter(true);
                    itemMap.setGiveOnRegionAccess(false);
                    itemMap.setGiveOnRegionEgress(false);
                }
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "HOPPER_MINECART" : "408", 1, itemMap.isGiveOnRegionLeave(), false, "&e&l&nRegion Leave", "&7", "&7*Gives the item when the", "&7player leaves any of the enabled-regions.", "&9&lENABLED: &a" + (itemMap.isGiveOnRegionLeave() + "").toUpperCase()), event -> {
                if (itemMap.isGiveOnRegionLeave()) {
                    itemMap.setGiveOnRegionLeave(false);
                } else {
                    itemMap.setGiveOnRegionLeave(true);
                    itemMap.setGiveOnRegionAccess(false);
                    itemMap.setGiveOnRegionEgress(false);
                }
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "TNT_MINECART" : "407", 1, itemMap.isGiveOnRegionAccess(), false, "&e&l&nRegion Access", "&7", "&7*Gives the item when the", "&7player enters any of the enabled-regions", "&7and removes the item when leaving", "&7any of the enabled-regions.", "&9&lENABLED: &a" + (itemMap.isGiveOnRegionAccess() + "").toUpperCase()), event -> {
                if (itemMap.isGiveOnRegionAccess()) {
                    itemMap.setGiveOnRegionAccess(false);
                } else {
                    itemMap.setGiveOnRegionAccess(true);
                    itemMap.setGiveOnRegionEnter(false);
                    itemMap.setGiveOnRegionLeave(false);
                }
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CHEST_MINECART" : "342", 1, itemMap.isGiveOnRegionEgress(), false, "&e&l&nRegion Egress", "&7", "&7*Removes the item when the", "&7player enters any of the enabled-regions", "&7and gives the item when leaving", "&7any of the enabled-regions.", "&9&lENABLED: &a" + (itemMap.isGiveOnRegionEgress() + "").toUpperCase()), event -> {
                if (itemMap.isGiveOnRegionEgress()) {
                    itemMap.setGiveOnRegionEgress(false);
                } else {
                    itemMap.setGiveOnRegionEgress(true);
                    itemMap.setGiveOnRegionEnter(false);
                    itemMap.setGiveOnRegionLeave(false);
                }
                Menu.triggerPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem));
            triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu"), event -> {
                Menu.setTriggers(itemMap);
                Menu.creatingPane(player, itemMap);
            }));
            triggerPane.addButton(new Button(fillerPaneBItem), 7);
            triggerPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu"), event -> {
                Menu.setTriggers(itemMap);
                Menu.creatingPane(player, itemMap);
            }));
        });
        triggerPane.open(player);
    }

    private static void setTriggers(ItemMap itemMap) {
        String triggers = "";
        if (itemMap.isGiveOnDisabled()) {
            triggers = triggers + "DISABLED, ";
        }
        if (!(!itemMap.isGiveOnJoin() || itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstWorld() || itemMap.isOnlyFirstWild() || itemMap.isOnlyFirstLife())) {
            triggers = triggers + "JOIN, ";
        }
        if (itemMap.isOnlyFirstJoin()) {
            triggers = triggers + "FIRST-JOIN, ";
        }
        if (itemMap.isOnlyFirstWorld()) {
            triggers = triggers + "FIRST-WORLD, ";
        }
        if (itemMap.isOnlyFirstWild()) {
            triggers = triggers + "FIRST-WILD, ";
        }
        if (itemMap.isOnlyFirstLife()) {
            triggers = triggers + "FIRST-LIFE, ";
        }
        if (itemMap.isGiveOnTeleport() && !itemMap.isOnlyFirstJoin() && !itemMap.isOnlyFirstWorld() && !itemMap.isOnlyFirstWild()) {
            triggers = triggers + "TELEPORT, ";
        }
        if (!(!itemMap.isGiveOnRespawn() || itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstWorld() || itemMap.isOnlyFirstWild() || itemMap.isOnlyFirstLife())) {
            triggers = triggers + "RESPAWN, ";
        }
        if (!(!itemMap.isGiveOnRespawnWild() || itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstWorld() || itemMap.isOnlyFirstWild() || itemMap.isOnlyFirstLife())) {
            triggers = triggers + "RESPAWN-WILD, ";
        }
        if (!(!itemMap.isGiveOnRespawnPoint() || itemMap.isOnlyFirstJoin() || itemMap.isOnlyFirstWorld() || itemMap.isOnlyFirstWild() || itemMap.isOnlyFirstLife())) {
            triggers = triggers + "RESPAWN-POINT, ";
        }
        if (itemMap.isGiveOnWorldSwitch() && !itemMap.isOnlyFirstWorld()) {
            triggers = triggers + "WORLD-SWITCH, ";
        }
        if (itemMap.isGiveOnPermissionSwitch()) {
            triggers = triggers + "PERMISSION-SWITCH, ";
        }
        if (itemMap.isUseOnLimitSwitch()) {
            triggers = triggers + "GAMEMODE-SWITCH, ";
        }
        if (itemMap.isGiveOnRegionEnter()) {
            triggers = triggers + "REGION-ENTER, ";
        }
        if (itemMap.isGiveOnRegionLeave()) {
            triggers = triggers + "REGION-LEAVE, ";
        }
        if (itemMap.isGiveOnRegionAccess()) {
            triggers = triggers + "REGION-ACCESS, ";
        }
        if (itemMap.isGiveOnRegionEgress()) {
            triggers = triggers + "REGION-EGRESS, ";
        }
        if (triggers.endsWith(", ")) {
            triggers = triggers.substring(0, triggers.length() - 2);
        }
        itemMap.setTriggers(triggers);
    }

    private static void worldPane(Player player, ItemMap itemMap, int stage) {
        Interface worldPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage == 4) {
                worldPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                worldPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            }
            List<Object> listWorlds = stage == 4 ? new ArrayList() : (stage == 0 ? itemMap.getDisabledWorlds() : itemMap.getEnabledWorlds());
            String worlds = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds");
            if (stage == 4 && worlds != null) {
                listWorlds.addAll(Arrays.asList(worlds.replace(" ", "").split(",")));
            }
            worldPane.addButton(new Button(ItemHandler.getItem("OBSIDIAN", 1, stage == 4 ? me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "ALL") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "GLOBAL") : itemMap.containsWorld("ALL", stage == 0), false, "&a&l&nGLOBAL", "&7", "&7*Click to " + (stage == 0 ? "disable" : "enable") + " the", "&7custom item in &lALL WORLDS.", (stage == 0 ? "&9&lDISABLED:" : "&9&lENABLED:") + " &a" + (stage == 4 ? Boolean.valueOf(me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "ALL") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "GLOBAL")) : itemMap.containsWorld("ALL", stage == 0) + "")), event -> {
                if (stage == 4 && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "ALL") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "GLOBAL")) || stage != 4 && itemMap.containsWorld("ALL", stage == 0)) {
                    listWorlds.clear();
                    listWorlds.add("DISABLED");
                } else {
                    listWorlds.clear();
                    listWorlds.add("GLOBAL");
                }
                if (stage == 4) {
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.enabled-worlds", (Object)(listWorlds.isEmpty() ? "DISABLED" : "GLOBAL"));
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.worldPane(player, itemMap, stage));
                } else if (stage == 0) {
                    itemMap.setDisabledWorlds(listWorlds);
                    Menu.worldPane(player, itemMap, stage);
                } else {
                    itemMap.setEnabledWorlds(listWorlds);
                    Menu.worldPane(player, itemMap, stage);
                }
            }));
            for (World world : Bukkit.getServer().getWorlds()) {
                String worldMaterial;
                String string = worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2";
                if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                    worldMaterial = "NETHERRACK";
                } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                    String string2 = worldMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "END_STONE" : "121";
                }
                worldPane.addButton(new Button(ItemHandler.getItem(worldMaterial, 1, stage == 4 ? me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, world.getName()) : itemMap.containsWorld(world.getName(), stage == 0), false, "&f&l" + world.getName(), "&7", "&7*Click to " + (stage == 0 ? "disable" : "enable") + " the", "&7custom item in this world.", (stage == 0 ? "&9&lDISABLED:" : "&9&lENABLED:") + " &a" + (stage == 4 ? Boolean.valueOf(me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, world.getName())) : itemMap.containsWorld(world.getName(), stage == 0) + "")), event -> {
                    if (stage == 4 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, world.getName()) || stage != 4 && itemMap.containsWorld(world.getName(), stage == 0)) {
                        listWorlds.remove(world.getName());
                    } else {
                        listWorlds.add(world.getName());
                    }
                    if (listWorlds.isEmpty()) {
                        listWorlds.add("DISABLED");
                    } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "DISABLED") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(listWorlds, "DISABLE")) {
                        listWorlds.remove("DISABLED");
                    }
                    if (stage == 4) {
                        StringBuilder worldList = new StringBuilder();
                        for (String worldString : listWorlds) {
                            worldList.append(worldString).append(", ");
                        }
                        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.isEmpty(worldList)) {
                            worldList = new StringBuilder(worldList.substring(0, worldList.length() - 2));
                        }
                        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                        dataFile.set("Active-Commands.enabled-worlds", (Object)worldList.toString());
                        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                        PluginData.getInfo().softReload();
                        SchedulerUtils.runLater(2L, () -> Menu.worldPane(player, itemMap, stage));
                    } else if (stage == 0) {
                        itemMap.setDisabledWorlds(listWorlds);
                        Menu.worldPane(player, itemMap, stage);
                    } else {
                        itemMap.setEnabledWorlds(listWorlds);
                        Menu.worldPane(player, itemMap, stage);
                    }
                }));
            }
        });
        worldPane.open(player);
    }

    private static void regionPane(Player player, ItemMap itemMap, int stage) {
        Interface regionPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            regionPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            List<String> regions = stage == 0 ? itemMap.getDisabledRegions() : itemMap.getEnabledRegions();
            regionPane.addButton(new Button(ItemHandler.getItem("OBSIDIAN", 1, itemMap.containsRegion("UNDEFINED", stage == 0), false, "&c&l&nUNDEFINED", "&7", "&7*Click to " + (stage == 0 ? "disable" : "enable") + " the", "&7custom item in &lALL REGIONS.", (stage == 0 ? "&9&lDISABLED: &a" : "&9&lENABLED: &a") + (itemMap.containsRegion("UNDEFINED", stage == 0) + "").toUpperCase()), event -> {
                if (itemMap.containsRegion("UNDEFINED", stage == 0)) {
                    regions.remove("UNDEFINED");
                } else {
                    regions.add("UNDEFINED");
                }
                if (stage == 0) {
                    itemMap.setDisabledRegions(regions);
                } else {
                    itemMap.setEnabledRegions(regions);
                }
                Menu.regionPane(player, itemMap, stage);
            }));
            for (World world : Bukkit.getServer().getWorlds()) {
                for (String region : ItemJoin.getCore().getDependencies().getGuard().getRegions(world).keySet()) {
                    String regionMaterial;
                    String string = regionMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2";
                    if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                        regionMaterial = "NETHERRACK";
                    } else if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                        regionMaterial = ServerUtils.hasSpecificUpdate("1_13") ? "END_STONE" : "121";
                    }
                    regionPane.addButton(new Button(ItemHandler.getItem(regionMaterial, 1, itemMap.containsRegion(region, stage == 0) && itemMap.containsWorld(world.getName(), false), false, "&f&l" + region, "&7", "&a&lWORLD: &f" + world.getName(), "&7", "&7*Click to " + (stage == 0 ? "disable" : "enable") + " the", "&7custom item in this region.", (stage == 0 ? "&9&lDISABLED: &a" : "&9&lENABLED: &a") + ((itemMap.containsRegion(region, stage == 0) && itemMap.containsWorld(world.getName(), false)) + "").toUpperCase()), event -> {
                        if (itemMap.containsRegion(region, stage == 0) && itemMap.containsWorld(world.getName(), false)) {
                            regions.remove(region);
                            Menu.clearWorlds(itemMap, stage);
                        } else {
                            Menu.clearWorlds(itemMap, stage);
                            if (!itemMap.containsRegion(region, stage == 0)) {
                                regions.add(region);
                            }
                            if (!itemMap.containsWorld(world.getName(), false)) {
                                List<String> worldList = itemMap.getEnabledWorlds();
                                worldList.add(world.getName().toUpperCase());
                                itemMap.setEnabledWorlds(worldList);
                            }
                        }
                        if (stage == 0) {
                            itemMap.setDisabledRegions(regions);
                        } else {
                            itemMap.setEnabledRegions(regions);
                        }
                        Menu.regionPane(player, itemMap, stage);
                    }));
                }
            }
        });
        regionPane.open(player);
    }

    private static void clearWorlds(ItemMap itemMap, int stage) {
        for (World worldRemoval : Bukkit.getServer().getWorlds()) {
            if (!itemMap.containsWorld(worldRemoval.getName(), false)) continue;
            boolean hasRegion = false;
            for (String regionExists : ItemJoin.getCore().getDependencies().getGuard().getRegions(worldRemoval).keySet()) {
                if (!itemMap.containsRegion(regionExists, stage == 0)) continue;
                hasRegion = true;
            }
            if (hasRegion) continue;
            List<String> worldList = itemMap.getEnabledWorlds();
            worldList.removeIf(s -> s.equalsIgnoreCase(worldRemoval.getName()));
            itemMap.setEnabledWorlds(worldList);
        }
    }

    private static void lorePane(Player player, ItemMap itemMap) {
        Interface lorePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            lorePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            lorePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Lore Line", "&7", "&7*Add a new lore line", "&7to the item lore."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "LORE LINE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bThis is a new lore line.");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "LORE LINE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> lore = new ArrayList<String>();
                if (itemMap.getCustomLore() != null) {
                    lore = itemMap.getCustomLore();
                }
                lore.add(me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage()));
                itemMap.setCustomLore(lore);
                Menu.lorePane(player, itemMap);
            }));
            if (itemMap.getCustomLore() != null && !itemMap.getCustomLore().isEmpty()) {
                int i = 1;
                while (i <= itemMap.getCustomLore().size()) {
                    int k = i++;
                    lorePane.addButton(new Button(ItemHandler.getItem("WRITABLE_BOOK", 1, false, false, "&fLore " + k, "&7", "&7*Click modify this lore line.", "&9&lLore: &a" + itemMap.getCustomLore().get(k - 1)), event -> Menu.modifyLoreLinePane(player, itemMap, k - 1)));
                }
            }
        });
        lorePane.open(player);
    }

    private static void modifyLoreLinePane(Player player, ItemMap itemMap, int position) {
        Interface modifyLorePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modifyLorePane.addButton(new Button(fillerPaneGItem), 3);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("WRITABLE_BOOK", 1, false, false, "&e&l&nModify", "&7", "&7*Change the lore line.", "&9&lLore: &a" + itemMap.getCustomLore().get(position)), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "LORE LINE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bThis is a new lore line.");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                List<String> lore = itemMap.getCustomLore();
                lore.set(position, me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage()));
                itemMap.setCustomLore(lore);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "LORE LINE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.modifyLoreLinePane(event.getPlayer(), itemMap, position);
            }));
            modifyLorePane.addButton(new Button(fillerPaneGItem));
            modifyLorePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this lore line."), event -> {
                List<String> lore = itemMap.getCustomLore();
                lore.remove(position);
                itemMap.setCustomLore(lore);
                Menu.lorePane(player, itemMap);
            }));
            modifyLorePane.addButton(new Button(fillerPaneGItem), 3);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.lorePane(player, itemMap)));
            modifyLorePane.addButton(new Button(fillerPaneBItem), 7);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.lorePane(player, itemMap)));
        });
        modifyLorePane.open(player);
    }

    private static void animateMaterialPane(Player player, ItemMap itemMap) {
        Interface animateMaterialPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            animateMaterialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animation menu."), event -> {
                if (!itemMap.getDynamicMaterials().isEmpty()) {
                    itemMap.setAnimate(true);
                    if (ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(0)).contains(":")) {
                        String[] material = ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(0)).split(":");
                        itemMap.setMaterial(ItemHandler.getMaterial(material[0], null));
                        itemMap.setDataValue((short)Integer.parseInt(material[1]));
                    } else {
                        itemMap.setMaterial(ItemHandler.getMaterial(ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(0)), null));
                    }
                }
                Menu.animationPane(player, itemMap);
            }));
            animateMaterialPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Material", "&7", "&7*Add a new material", "&7to be animated between."), event -> Menu.selectMaterialPane(player, itemMap, 0, true)));
            for (int i = 1; i <= itemMap.getDynamicMaterials().size(); ++i) {
                int k = i;
                Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicMaterials().get(k - 1)));
                animateMaterialPane.addButton(new Button(ItemHandler.getItem(ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(k - 1)), 1, false, false, "&fMaterial " + k, "&7", "&7*Click modify this animated material.", "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.modifyMaterialPane(player, itemMap, k - 1)));
            }
        });
        animateMaterialPane.open(player);
    }

    private static void selectMaterialPane(Player player, ItemMap itemMap, int position, boolean isNew) {
        Interface selectMaterialPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            selectMaterialPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated material menu."), event -> Menu.animateMaterialPane(player, itemMap)));
            selectMaterialPane.addButton(new Button(ItemHandler.getItem("STICK", 1, true, false, "&b&lBukkit Material", "&7", "&7*If you know the name", "&7of the BUKKIT material type", "&7simply click and type it."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "IRON_SWORD");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null) != Material.AIR) {
                    if (isNew) {
                        Menu.durationMaterialPane(player, itemMap, position, true, ChatColor.stripColor((String)event.getMessage()).toUpperCase());
                    } else {
                        List<String> mats = itemMap.getDynamicMaterials();
                        mats.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(mats.get(position))) + ">" + ChatColor.stripColor((String)event.getMessage()).toUpperCase());
                        itemMap.setDynamicMaterials(mats);
                        Menu.modifyMaterialPane(player, itemMap, position);
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noMaterial", (CommandSender)player, placeHolders);
                    Menu.selectMaterialPane(player, itemMap, position, isNew);
                }
            }));
            Inventory inventoryCheck = Bukkit.getServer().createInventory(null, 9, GUIName);
            for (Material material : Material.values()) {
                if (material.name().contains("LEGACY") || material.name().equals("AIR") || !Menu.safeMaterial(ItemHandler.getItem(material.toString(), 1, false, false, "", ""), inventoryCheck)) continue;
                if (!ServerUtils.hasSpecificUpdate("1_13") && LegacyAPI.getDataValue(material) != 0) {
                    for (int i = 0; i <= LegacyAPI.getDataValue(material); ++i) {
                        if (material.toString().equalsIgnoreCase("STEP") && (!material.toString().equalsIgnoreCase("STEP") || i == 2)) continue;
                        int dataValue = i;
                        selectMaterialPane.addButton(new Button(ItemHandler.getItem(material + ":" + dataValue, 1, false, false, "", "&7", "&7*Click to set the", "&7material of the item."), event -> {
                            if (isNew) {
                                if (dataValue != 0) {
                                    Menu.durationMaterialPane(player, itemMap, position, true, material.name() + ":" + dataValue);
                                } else {
                                    Menu.durationMaterialPane(player, itemMap, position, true, material.name());
                                }
                            } else {
                                List<String> mats = itemMap.getDynamicMaterials();
                                if (dataValue != 0) {
                                    mats.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(mats.get(position))) + ">" + material.name() + ":" + dataValue);
                                } else {
                                    mats.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(mats.get(position))) + ">" + material.name());
                                }
                                itemMap.setDynamicMaterials(mats);
                                Menu.modifyMaterialPane(player, itemMap, position);
                            }
                        }));
                    }
                    continue;
                }
                selectMaterialPane.addButton(new Button(ItemHandler.getItem(material.toString(), 1, false, false, "", "&7", "&7*Click to set the", "&7material of the item."), event -> {
                    if (isNew) {
                        Menu.durationMaterialPane(player, itemMap, position, true, material.name());
                    } else {
                        List<String> mats = itemMap.getDynamicMaterials();
                        mats.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(mats.get(position))) + ">" + material.name());
                        itemMap.setDynamicMaterials(mats);
                        Menu.modifyMaterialPane(player, itemMap, position);
                    }
                }));
            }
            inventoryCheck.clear();
        });
        selectMaterialPane.open(player);
    }

    private static void durationMaterialPane(Player player, ItemMap itemMap, int position, boolean isNew, String value) {
        Interface durationPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            durationPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated menu."), event -> Menu.animateMaterialPane(player, itemMap)));
            durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Duration", "&7", "&7*Click to set a custom duration", "&7value for the animation."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "110");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    List<String> mats = itemMap.getDynamicMaterials();
                    if (isNew) {
                        if (itemMap.getDynamicMaterials().isEmpty()) {
                            mats.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + itemMap.getMaterial());
                        }
                        mats.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + value);
                    } else {
                        mats.set(position, "<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + ItemHandler.cutDelay(mats.get(position)));
                    }
                    itemMap.setDynamicMaterials(mats);
                    if (isNew) {
                        Menu.animateMaterialPane(player, itemMap);
                    } else {
                        Menu.modifyMaterialPane(player, itemMap, position);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.durationMaterialPane(player, itemMap, position, isNew, value);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Ticks(s)", "&7", "&7*Click to set the", "&7duration of the animation."), event -> {
                    List<String> mats = itemMap.getDynamicMaterials();
                    if (isNew) {
                        if (itemMap.getDynamicMaterials().isEmpty()) {
                            mats.add("<delay:" + k + ">" + itemMap.getMaterial());
                        }
                        mats.add("<delay:" + k + ">" + value);
                    } else {
                        mats.set(position, "<delay:" + k + ">" + ItemHandler.cutDelay(mats.get(position)));
                    }
                    itemMap.setDynamicMaterials(mats);
                    if (isNew) {
                        Menu.animateMaterialPane(player, itemMap);
                    } else {
                        Menu.modifyMaterialPane(player, itemMap, position);
                    }
                }));
            }
        });
        durationPane.open(player);
    }

    private static void modifyMaterialPane(Player player, ItemMap itemMap, int position) {
        Interface modifyMaterialPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modifyMaterialPane.addButton(new Button(fillerPaneGItem), 3);
            modifyMaterialPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&l&nMaterial", "&7", "&7*Change the animated material type.", "&9&lMaterial: &a" + ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(position))), event -> Menu.selectMaterialPane(player, itemMap, position, false)));
            Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicMaterials().get(position)));
            modifyMaterialPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&e&l&nDuration", "&7", "&7*Change the duration of the animation.", "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.durationMaterialPane(player, itemMap, position, false, ItemHandler.cutDelay(itemMap.getDynamicMaterials().get(position)))));
            modifyMaterialPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this animated material."), event -> {
                List<String> mats = itemMap.getDynamicMaterials();
                mats.remove(position);
                itemMap.setDynamicMaterials(mats);
                Menu.animateMaterialPane(player, itemMap);
            }));
            modifyMaterialPane.addButton(new Button(fillerPaneGItem), 3);
            modifyMaterialPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated material menu."), event -> Menu.animateMaterialPane(player, itemMap)));
            modifyMaterialPane.addButton(new Button(fillerPaneBItem), 7);
            modifyMaterialPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated material menu."), event -> Menu.animateMaterialPane(player, itemMap)));
        });
        modifyMaterialPane.open(player);
    }

    private static void animatedNamePane(Player player, ItemMap itemMap) {
        Interface animatedNamePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            animatedNamePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animation menu."), event -> {
                if (!itemMap.getDynamicNames().isEmpty()) {
                    itemMap.setAnimate(true);
                    itemMap.setCustomName(ItemHandler.cutDelay(itemMap.getDynamicNames().get(0)));
                }
                Menu.animationPane(player, itemMap);
            }));
            animatedNamePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Name Line", "&7", "&7*Add a new name line", "&7to be animated between."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NAME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bUltimate Sword");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                Menu.durationNamePane(player, itemMap, 0, true, me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NAME");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
            }));
            for (int i = 1; i <= itemMap.getDynamicNames().size(); ++i) {
                int k = i;
                Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicNames().get(k - 1)));
                animatedNamePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&fName " + k, "&7", "&7*Click modify this animated name.", "&9&lName: &a" + ItemHandler.cutDelay(itemMap.getDynamicNames().get(k - 1)), "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.modifyNamePane(player, itemMap, k - 1)));
            }
        });
        animatedNamePane.open(player);
    }

    private static void durationNamePane(Player player, ItemMap itemMap, int position, boolean isNew, String value) {
        Interface durationPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            durationPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated menu."), event -> Menu.animatedNamePane(player, itemMap)));
            durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Duration", "&7", "&7*Click to set a custom duration", "&7value for the animation."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "110");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    List<String> names = itemMap.getDynamicNames();
                    if (isNew) {
                        if (itemMap.getDynamicNames().isEmpty() && itemMap.getCustomName() != null && !itemMap.getCustomName().isEmpty()) {
                            names.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + itemMap.getCustomName());
                        }
                        names.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + value);
                    } else {
                        names.set(position, "<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + ItemHandler.cutDelay(names.get(position)));
                    }
                    itemMap.setDynamicNames(names);
                    if (isNew) {
                        Menu.animatedNamePane(player, itemMap);
                    } else {
                        Menu.modifyNamePane(player, itemMap, position);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.durationNamePane(player, itemMap, position, isNew, value);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Ticks(s)", "&7", "&7*Click to set the", "&7duration of the animation."), event -> {
                    List<String> names = itemMap.getDynamicNames();
                    if (isNew) {
                        if (itemMap.getDynamicNames().isEmpty() && itemMap.getCustomName() != null && !itemMap.getCustomName().isEmpty()) {
                            names.add("<delay:" + k + ">" + itemMap.getCustomName());
                        }
                        names.add("<delay:" + k + ">" + value);
                    } else {
                        names.set(position, "<delay:" + k + ">" + ItemHandler.cutDelay(names.get(position)));
                    }
                    itemMap.setDynamicNames(names);
                    if (isNew) {
                        Menu.animatedNamePane(player, itemMap);
                    } else {
                        Menu.modifyNamePane(player, itemMap, position);
                    }
                }));
            }
        });
        durationPane.open(player);
    }

    private static void modifyNamePane(Player player, ItemMap itemMap, int position) {
        Interface modifyNamePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modifyNamePane.addButton(new Button(fillerPaneGItem), 3);
            modifyNamePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&l&nName", "&7", "&7*Change the animated name line.", "&9&lName: &a" + ItemHandler.cutDelay(itemMap.getDynamicNames().get(position))), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NAME").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bUltimate Sword");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                List<String> names = itemMap.getDynamicNames();
                names.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(names.get(position))) + ">" + me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage()));
                itemMap.setDynamicNames(names);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NAME");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.modifyNamePane(event.getPlayer(), itemMap, position);
            }));
            Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicNames().get(position)));
            modifyNamePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&e&l&nDuration", "&7", "&7*Change the duration of the animation.", "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.durationNamePane(player, itemMap, position, false, ItemHandler.cutDelay(itemMap.getDynamicNames().get(position)))));
            modifyNamePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this animated name."), event -> {
                List<String> names = itemMap.getDynamicNames();
                names.remove(position);
                itemMap.setDynamicNames(names);
                Menu.animatedNamePane(player, itemMap);
            }));
            modifyNamePane.addButton(new Button(fillerPaneGItem), 3);
            modifyNamePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated name menu."), event -> Menu.animatedNamePane(player, itemMap)));
            modifyNamePane.addButton(new Button(fillerPaneBItem), 7);
            modifyNamePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated name menu."), event -> Menu.animatedNamePane(player, itemMap)));
        });
        modifyNamePane.open(player);
    }

    private static void animatedLorePane(Player player, ItemMap itemMap) {
        Interface animatedLorePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            animatedLorePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animation menu."), event -> {
                if (!itemMap.getDynamicLores().isEmpty()) {
                    itemMap.setAnimate(true);
                    itemMap.setCustomLore(ItemHandler.cutDelay(itemMap.getDynamicLores().get(0)));
                }
                Menu.animationPane(player, itemMap);
            }));
            animatedLorePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Lore Line", "&7", "&7*Add a new lore line", "&7to be animated between."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATED LORE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bThis is line 1, &cThis is line 2, &6This is line 3");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATED LORE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.durationLorePane(event.getPlayer(), itemMap, 0, true, me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage()));
            }));
            for (int i = 1; i <= itemMap.getDynamicLores().size(); ++i) {
                int k = i;
                Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicLores().get(k - 1).get(0)));
                animatedLorePane.addButton(new Button(ItemHandler.getItem("WRITABLE_BOOK", 1, false, false, "&fLore " + k, "&7", "&7*Click modify this animated lore.", "&9&lLore: &a" + ItemHandler.cutDelay(itemMap.getDynamicLores().get(k - 1)), "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.modifyLorePane(player, itemMap, k - 1)));
            }
        });
        animatedLorePane.open(player);
    }

    private static void durationLorePane(Player player, ItemMap itemMap, int position, boolean isNew, String value) {
        Interface durationPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            durationPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated menu."), event -> Menu.animatedLorePane(player, itemMap)));
            durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Duration", "&7", "&7*Click to set a custom duration", "&7value for the animation."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "110");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    List<List<String>> lores = itemMap.getDynamicLores();
                    if (isNew) {
                        if (itemMap.getDynamicLores().isEmpty() && itemMap.getCustomLore() != null && !itemMap.getCustomLore().isEmpty()) {
                            List<String> loreCut = itemMap.getCustomLore();
                            loreCut.set(0, "<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + loreCut.get(0));
                            lores.add(loreCut);
                        }
                        lores.add(me.RockinChaos.itemjoin.core.utils.StringUtils.split("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + value));
                    } else {
                        List<String> loreCut = ItemHandler.cutDelay(lores.get(position));
                        loreCut.set(0, "<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + loreCut.get(0));
                        lores.set(position, loreCut);
                    }
                    itemMap.setDynamicLores(lores);
                    if (isNew) {
                        Menu.animatedLorePane(player, itemMap);
                    } else {
                        Menu.modifyLorePane(player, itemMap, position);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.durationLorePane(player, itemMap, position, isNew, value);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Ticks(s)", "&7", "&7*Click to set the", "&7duration of the animation."), event -> {
                    List<List<String>> lores = itemMap.getDynamicLores();
                    if (isNew) {
                        if (itemMap.getDynamicLores().isEmpty() && itemMap.getCustomLore() != null && !itemMap.getCustomLore().isEmpty()) {
                            List<String> loreCut = itemMap.getCustomLore();
                            loreCut.set(0, "<delay:" + k + ">" + loreCut.get(0));
                            lores.add(loreCut);
                        }
                        lores.add(me.RockinChaos.itemjoin.core.utils.StringUtils.split("<delay:" + k + ">" + value));
                    } else {
                        List<String> loreCut = ItemHandler.cutDelay(lores.get(position));
                        loreCut.set(0, "<delay:" + k + ">" + loreCut.get(0));
                        lores.set(position, loreCut);
                    }
                    itemMap.setDynamicLores(lores);
                    if (isNew) {
                        Menu.animatedLorePane(player, itemMap);
                    } else {
                        Menu.modifyLorePane(player, itemMap, position);
                    }
                }));
            }
        });
        durationPane.open(player);
    }

    private static void modifyLorePane(Player player, ItemMap itemMap, int position) {
        Interface modifyLorePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modifyLorePane.addButton(new Button(fillerPaneGItem), 3);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("WRITABLE_BOOK", 1, false, false, "&a&l&nLore", "&7", "&7*Change the animated lore line.", "&9&lLore: &a" + ItemHandler.cutDelay(itemMap.getDynamicLores().get(position))), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATED LORE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&bThis is line 1, &cThis is line 2, &6This is line 3");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                List<List<String>> lores = itemMap.getDynamicLores();
                lores.set(position, me.RockinChaos.itemjoin.core.utils.StringUtils.split("<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(lores.get(position).get(0))) + ">" + me.RockinChaos.itemjoin.core.utils.StringUtils.restoreColor(event.getMessage())));
                itemMap.setDynamicLores(lores);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATED LORE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.modifyLorePane(event.getPlayer(), itemMap, position);
            }));
            Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicLores().get(position).get(0)));
            modifyLorePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&e&l&nDuration", "&7", "&7*Change the duration of the animation.", "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.durationLorePane(player, itemMap, position, false, "")));
            modifyLorePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this animated lore."), event -> {
                List<List<String>> lores = itemMap.getDynamicLores();
                lores.remove(position);
                itemMap.setDynamicLores(lores);
                Menu.animatedLorePane(player, itemMap);
            }));
            modifyLorePane.addButton(new Button(fillerPaneGItem), 3);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated lore menu."), event -> Menu.animatedLorePane(player, itemMap)));
            modifyLorePane.addButton(new Button(fillerPaneBItem), 7);
            modifyLorePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated lore menu."), event -> Menu.animatedLorePane(player, itemMap)));
        });
        modifyLorePane.open(player);
    }

    private static void animatedSkullPane(Player player, ItemMap itemMap, boolean owner) {
        Interface animatedSkullPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (owner) {
                animatedSkullPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animation menu."), event -> {
                    if (!itemMap.getDynamicOwners().isEmpty()) {
                        itemMap.setAnimate(true);
                        itemMap.setSkullTexture("");
                        itemMap.setDynamicTextures(new ArrayList<String>());
                        itemMap.setSkull(ItemHandler.cutDelay(itemMap.getDynamicOwners().get(0)));
                    }
                    Menu.animationPane(player, itemMap);
                }));
                animatedSkullPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Skull Owner", "&7", "&7*Add a new skull owner", "&7to be animated between."), event -> {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "RockinChaos");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }, event -> {
                    Menu.durationSkullPane(player, itemMap, 0, true, ChatColor.stripColor((String)event.getMessage()), true);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                }));
                for (int i = 1; i <= itemMap.getDynamicOwners().size(); ++i) {
                    int k = i;
                    Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicOwners().get(k - 1)));
                    animatedSkullPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_HELMET" : "314", 1, false, false, "&fSkull Owner " + k, "&7", "&7*Click modify this animated skull owner.", "&9&lSkull Owner: &a" + ItemHandler.cutDelay(itemMap.getDynamicOwners().get(k - 1)), "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.modifySkullPane(player, itemMap, k - 1, true)));
                }
            } else {
                animatedSkullPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animation menu."), event -> {
                    if (!itemMap.getDynamicTextures().isEmpty()) {
                        itemMap.setAnimate(true);
                        itemMap.setSkull("");
                        itemMap.setDynamicOwners(new ArrayList<String>());
                        itemMap.setSkullTexture(ItemHandler.cutDelay(itemMap.getDynamicTextures().get(0)));
                    }
                    Menu.animationPane(player, itemMap);
                }));
                animatedSkullPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&eNew Skull Texture", "&7", "&7*Add a new skull texture", "&7to be animated between."), event -> {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "eyJ0ZXh0dYMGQVlN2FjZmU3OSJ9fX0=");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }, event -> {
                    Menu.durationSkullPane(player, itemMap, 0, true, ChatColor.stripColor((String)event.getMessage()), false);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                }));
                for (int i = 1; i <= itemMap.getDynamicTextures().size(); ++i) {
                    int k = i;
                    Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(itemMap.getDynamicTextures().get(k - 1)));
                    animatedSkullPane.addButton(new Button(ItemHandler.getItem("STRING", 1, false, false, "&fSkull Texture " + k, "&7", "&7*Click modify this animated skull texture.", "&9&lSkull Texture: &a" + (ItemHandler.cutDelay(itemMap.getDynamicTextures().get(k - 1)).length() > 40 ? ItemHandler.cutDelay(itemMap.getDynamicTextures().get(k - 1)).substring(0, 40) : ItemHandler.cutDelay(itemMap.getDynamicTextures().get(k - 1))), "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.modifySkullPane(player, itemMap, k - 1, false)));
                }
            }
        });
        animatedSkullPane.open(player);
    }

    private static void durationSkullPane(Player player, ItemMap itemMap, int position, boolean isNew, String value, boolean owner) {
        Interface durationPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            durationPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated menu."), event -> Menu.animatedSkullPane(player, itemMap, owner)));
            durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Duration", "&7", "&7*Click to set a custom duration", "&7value for the animation."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "110");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "ANIMATION DURATION");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    List<String> skulls = itemMap.getDynamicOwners();
                    if (!owner) {
                        skulls = itemMap.getDynamicTextures();
                    }
                    if (isNew) {
                        if (itemMap.getDynamicOwners().isEmpty() && owner && itemMap.getSkull() != null && !itemMap.getSkull().isEmpty()) {
                            skulls.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + itemMap.getSkull());
                        } else if (itemMap.getDynamicTextures().isEmpty() && !owner && itemMap.getSkullTexture() != null && !itemMap.getSkullTexture().isEmpty()) {
                            skulls.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + itemMap.getSkullTexture());
                        }
                        skulls.add("<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + value);
                    } else {
                        skulls.set(position, "<delay:" + Integer.parseInt(ChatColor.stripColor((String)event.getMessage())) + ">" + ItemHandler.cutDelay(skulls.get(position)));
                    }
                    if (owner) {
                        itemMap.setDynamicOwners(skulls);
                    } else {
                        itemMap.setDynamicTextures(skulls);
                    }
                    if (isNew) {
                        Menu.animatedSkullPane(player, itemMap, owner);
                    } else {
                        Menu.modifySkullPane(player, itemMap, position, owner);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.durationSkullPane(player, itemMap, position, isNew, value, owner);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Ticks(s)", "&7", "&7*Click to set the", "&7duration of the animation."), event -> {
                    List<String> skulls = itemMap.getDynamicOwners();
                    if (!owner) {
                        skulls = itemMap.getDynamicTextures();
                    }
                    if (isNew) {
                        if (itemMap.getDynamicOwners().isEmpty() && owner && itemMap.getSkull() != null && !itemMap.getSkull().isEmpty()) {
                            skulls.add("<delay:" + k + ">" + itemMap.getSkull());
                        } else if (itemMap.getDynamicTextures().isEmpty() && !owner && itemMap.getSkullTexture() != null && !itemMap.getSkullTexture().isEmpty()) {
                            skulls.add("<delay:" + k + ">" + itemMap.getSkullTexture());
                        }
                        skulls.add("<delay:" + k + ">" + value);
                    } else {
                        skulls.set(position, "<delay:" + k + ">" + ItemHandler.cutDelay(skulls.get(position)));
                    }
                    if (owner) {
                        itemMap.setDynamicOwners(skulls);
                    } else {
                        itemMap.setDynamicTextures(skulls);
                    }
                    if (isNew) {
                        Menu.animatedSkullPane(player, itemMap, owner);
                    } else {
                        Menu.modifySkullPane(player, itemMap, position, owner);
                    }
                }));
            }
        });
        durationPane.open(player);
    }

    private static void modifySkullPane(Player player, ItemMap itemMap, int position, boolean owner) {
        Interface modifySkullPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modifySkullPane.addButton(new Button(fillerPaneGItem), 3);
            if (owner) {
                modifySkullPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_HELMET" : "314", 1, false, false, "&a&l&nSkull Owner", "&7", "&7*Change the animated skull owner.", "&9&lSkull Owner: &a" + ItemHandler.cutDelay(itemMap.getDynamicOwners().get(position))), event -> {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "RockinChaos");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }, event -> {
                    List<String> skulls = itemMap.getDynamicOwners();
                    skulls.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(skulls.get(position))) + ">" + ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setDynamicOwners(skulls);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.modifySkullPane(event.getPlayer(), itemMap, position, true);
                }));
            } else {
                modifySkullPane.addButton(new Button(ItemHandler.getItem("STRING", 1, false, false, "&a&l&nSkull Texture", "&7", "&7*Change the animated skull texture.", "&9&lSkull Texture: &a" + ItemHandler.cutDelay(itemMap.getDynamicTextures().get(position))), event -> {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "eyJ0ZXh0dYMGQVlN2FjZmU3OSJ9fX0=");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }, event -> {
                    List<String> skulls = itemMap.getDynamicTextures();
                    skulls.set(position, "<delay:" + me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(skulls.get(position))) + ">" + ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setDynamicTextures(skulls);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.modifySkullPane(event.getPlayer(), itemMap, position, false);
                }));
            }
            Integer delay = me.RockinChaos.itemjoin.core.utils.StringUtils.returnInteger(ItemHandler.getDelayFormat(owner ? itemMap.getDynamicOwners().get(position) : itemMap.getDynamicTextures().get(position)));
            modifySkullPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "CLOCK" : "347", 1, false, false, "&e&l&nDuration", "&7", "&7*Change the duration of the animation.", "&9&lAnimation Ticks: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(String.valueOf(delay)).equals("NONE") ? String.valueOf(delay) : "20")), event -> Menu.durationSkullPane(player, itemMap, position, false, ItemHandler.cutDelay(owner ? itemMap.getDynamicOwners().get(position) : itemMap.getDynamicTextures().get(position)), owner)));
            modifySkullPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this animated skull " + (owner ? "owner." : "texture.")), event -> {
                List<String> skulls = itemMap.getDynamicOwners();
                if (!owner) {
                    skulls = itemMap.getDynamicTextures();
                }
                skulls.remove(position);
                if (owner) {
                    itemMap.setDynamicOwners(skulls);
                } else {
                    itemMap.setDynamicTextures(skulls);
                }
                Menu.animatedSkullPane(player, itemMap, owner);
            }));
            modifySkullPane.addButton(new Button(fillerPaneGItem), 3);
            modifySkullPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated skull menu."), event -> Menu.animatedSkullPane(player, itemMap, owner)));
            modifySkullPane.addButton(new Button(fillerPaneBItem), 7);
            modifySkullPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the animated skull menu."), event -> Menu.animatedSkullPane(player, itemMap, owner)));
        });
        modifySkullPane.open(player);
    }

    private static void animationPane(Player player, ItemMap itemMap) {
        Interface animationPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (itemMap.getMaterial().toString().contains("PLAYER_HEAD") || itemMap.getMaterial().toString().contains("SKULL_ITEM")) {
                animationPane.addButton(new Button(fillerPaneGItem), 2);
            } else {
                animationPane.addButton(new Button(fillerPaneGItem), 3);
            }
            animationPane.addButton(new Button(ItemHandler.getItem(itemMap.getMaterial().toString(), 1, false, false, "&c&l&nMaterial", "&7", "&7*Add additional material types", "&7to have the item change between.", "&9&lAnimated Materials: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDynamicMaterials() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.animateMaterialPane(player, itemMap)));
            animationPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&a&l&nName", "&7", "&7*Add additional custom names", "&7to have the item change between.", "&9&lAnimated Names: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDynamicNames() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.animatedNamePane(player, itemMap)));
            animationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&b&l&nLore", "&7", "&7*Add additional custom lores", "&7to have the item change between.", "&9&lAnimated Lores: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDynamicLores() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.animatedLorePane(player, itemMap)));
            if (itemMap.getMaterial().toString().contains("PLAYER_HEAD") || itemMap.getMaterial().toString().contains("SKULL_ITEM")) {
                animationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_HELMET" : "314", 1, false, false, "&a&lSkull Owner", "&7", "&7*Add additional skull owners", "&7to have the item change between.", "&7", "&7You can only define skull owner", "&7or skull texture, this will", "&7remove any skull textures.", "&9&lAnimated Owners: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDynamicOwners() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.animatedSkullPane(player, itemMap, true)));
                animationPane.addButton(new Button(ItemHandler.getItem("STRING", 1, false, false, "&b&lSkull Texture", "&7", "&7*Add additional skull textures", "&7to have the item change between.", "&7", "&7You can only define skull texture", "&7or skull owner, this will", "&7remove any skull owners.", "&7", "&7Skull textures can be found", "&7at websites like&a minecraft-heads.com", "&7and the value is listed under", "&7the OTHER section.", "&9&lAnimated Textures: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDynamicTextures() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.animatedSkullPane(player, itemMap, false)));
                animationPane.addButton(new Button(fillerPaneGItem), 2);
            } else {
                animationPane.addButton(new Button(fillerPaneGItem), 3);
            }
            animationPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            animationPane.addButton(new Button(fillerPaneBItem), 7);
            animationPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        animationPane.open(player);
    }

    private static void limitPane(Player player, ItemMap itemMap) {
        Interface limitPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            ArrayList<String> limitModes = new ArrayList<String>();
            if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getLimitModes(), "ADVENTURE")) {
                limitModes.add("ADVENTURE");
            }
            if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getLimitModes(), "SURVIVAL")) {
                limitModes.add("SURVIVAL");
            }
            if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getLimitModes(), "CREATIVE")) {
                limitModes.add("CREATIVE");
            }
            limitPane.addButton(new Button(fillerPaneGItem), 3);
            limitPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "FILLED_MAP" : "MAP", 1, limitModes.contains("ADVENTURE"), false, "&a&l&nADVENTURE", "&7", "&7*Limits the item to ADVENTURE mode.", "&9&lENABLED: &a" + (limitModes.contains("ADVENTURE") + "").toUpperCase()), event -> {
                if (limitModes.contains("ADVENTURE")) {
                    limitModes.remove("ADVENTURE");
                } else {
                    limitModes.add("ADVENTURE");
                }
                itemMap.setLimitModes(limitModes.toString().substring(0, limitModes.toString().length() - 1).substring(1));
                Menu.limitPane(player, itemMap);
            }));
            limitPane.addButton(new Button(ItemHandler.getItem("STONE_SWORD", 1, limitModes.contains("SURVIVAL"), false, "&b&l&nSURVIVAL", "&7", "&7*Limits the item to SURVIVAL mode.", "&9&lENABLED: &a" + (limitModes.contains("SURVIVAL") + "").toUpperCase()), event -> {
                if (limitModes.contains("SURVIVAL")) {
                    limitModes.remove("SURVIVAL");
                } else {
                    limitModes.add("SURVIVAL");
                }
                itemMap.setLimitModes(limitModes.toString().substring(0, limitModes.toString().length() - 1).substring(1));
                Menu.limitPane(player, itemMap);
            }));
            limitPane.addButton(new Button(ItemHandler.getItem(limitModes.contains("CREATIVE") ? (ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1") : "GOLDEN_APPLE", 1, false, false, "&6&l&nCREATIVE", "&7", "&7*Limits the item to CREATIVE mode.", "&9&lENABLED: &a" + (limitModes.contains("CREATIVE") + "").toUpperCase()), event -> {
                if (limitModes.contains("CREATIVE")) {
                    limitModes.remove("CREATIVE");
                } else {
                    limitModes.add("CREATIVE");
                }
                itemMap.setLimitModes(limitModes.toString().substring(0, limitModes.toString().length() - 1).substring(1));
                Menu.limitPane(player, itemMap);
            }));
            limitPane.addButton(new Button(fillerPaneGItem), 3);
            limitPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            limitPane.addButton(new Button(fillerPaneBItem), 7);
            limitPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        limitPane.open(player);
    }

    private static void probabilityPane(Player player, ItemMap itemMap) {
        Interface probabilityPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            probabilityPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            for (int i = 1; i < 100; ++i) {
                int k = i;
                probabilityPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", 1, false, false, "&9&lChance: &a&l" + k + "%", "&7", "&7*Click to set the", "&7probability of the item."), event -> {
                    itemMap.setProbability(k);
                    Menu.creatingPane(player, itemMap);
                }));
            }
        });
        probabilityPane.open(player);
    }

    private static void usePane(Player player, ItemMap itemMap) {
        Interface usePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            usePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            usePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Usage", "&7", "&7*Click to set a custom usage cooldown", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "USAGE COOLDOWN").with(PlaceHolder.Holder.INPUT_EXAMPLE, "120");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setInteractCooldown(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "USAGE COOLDOWN");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.creatingPane(event.getPlayer(), itemMap);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                usePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Second(s)", "&7", "&7*Click to set the", "&7use-cooldown of the item."), event -> {
                    itemMap.setInteractCooldown(k);
                    Menu.creatingPane(player, itemMap);
                }));
            }
        });
        usePane.open(player);
    }

    private static void dropsPane(Player player, ItemMap itemMap) {
        Interface dropsPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            StringBuilder mobs = new StringBuilder();
            StringBuilder blocks = new StringBuilder();
            for (EntityType entity : itemMap.getMobsDrop().keySet()) {
                mobs.append(entity.name()).append(", ");
            }
            for (Material material : itemMap.getBlocksDrop().keySet()) {
                blocks.append(material.name()).append(", ");
            }
            dropsPane.addButton(new Button(fillerPaneBItem), 12);
            dropsPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ZOMBIE_SPAWN_EGG" : "383:54", 1, false, false, "&b&lMobs Drop", "&7", "&7*Define mobs that are", "&7allowed to drop the item.", !me.RockinChaos.itemjoin.core.utils.StringUtils.isEmpty(mobs) ? "&9&lMobs: &a" + mobs.substring(0, mobs.length() - 2) : ""), event -> Menu.mobsPane(player, itemMap)));
            dropsPane.addButton(new Button(fillerPaneBItem));
            dropsPane.addButton(new Button(ItemHandler.getItem("DIAMOND_ORE", 1, false, false, "&b&lBlocks Drop", "&7", "&7*Define blocks that are", "&7allowed to drop the item.", !me.RockinChaos.itemjoin.core.utils.StringUtils.isEmpty(blocks) ? "&9&lBlocks: &a" + blocks.substring(0, blocks.length() - 2) : ""), event -> Menu.blocksPane(player, itemMap)));
            dropsPane.addButton(new Button(fillerPaneBItem), 3);
            dropsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            dropsPane.addButton(new Button(fillerPaneBItem), 7);
            dropsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        dropsPane.open(player);
    }

    private static void mobsPane(Player player, ItemMap itemMap) {
        Interface dropsPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            dropsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the drop chances menu."), event -> Menu.dropsPane(player, itemMap)));
            for (EntityType entity : EntityType.values()) {
                if (!itemMap.getMobsDrop().containsKey(entity) || !entity.isAlive()) continue;
                dropsPane.addButton(new Button(ItemHandler.getItem("EGG", 1, itemMap.getMobsDrop().containsKey(entity), false, "&f" + entity.name(), "&7", "&7*Click to add this as", "&7a banner pattern.", itemMap.getMobsDrop().containsKey(entity) ? "&9&lChance: &a" + itemMap.getMobsDrop().get(entity) : ""), event -> {
                    if (itemMap.getMobsDrop().containsKey(entity)) {
                        Map<EntityType, Double> mobsDrop = itemMap.getMobsDrop();
                        mobsDrop.remove(entity);
                        itemMap.setMobsDrop(mobsDrop);
                        Menu.mobsPane(player, itemMap);
                    } else {
                        Menu.chancePane(player, itemMap, entity, null);
                    }
                }));
            }
            for (EntityType entity : EntityType.values()) {
                if (itemMap.getMobsDrop().containsKey(entity) || !entity.isAlive()) continue;
                dropsPane.addButton(new Button(ItemHandler.getItem("EGG", 1, itemMap.getMobsDrop().containsKey(entity), false, "&f" + entity.name(), "&7", "&7*Click to add this as", "&7a banner pattern.", itemMap.getMobsDrop().containsKey(entity) ? "&9&lChance: &a" + itemMap.getMobsDrop().get(entity) : ""), event -> {
                    if (itemMap.getMobsDrop().containsKey(entity)) {
                        Map<EntityType, Double> mobsDrop = itemMap.getMobsDrop();
                        mobsDrop.remove(entity);
                        itemMap.setMobsDrop(mobsDrop);
                        Menu.mobsPane(player, itemMap);
                    } else {
                        Menu.chancePane(player, itemMap, entity, null);
                    }
                }));
            }
        });
        dropsPane.open(player);
    }

    private static void blocksPane(Player player, ItemMap itemMap) {
        Interface blockPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            int i;
            blockPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the drop chances menu."), event -> Menu.dropsPane(player, itemMap)));
            blockPane.addButton(new Button(ItemHandler.getItem("STICK", 1, true, false, "&b&lBukkit Material", "&7", "&7*If you know the name", "&7of the BUKKIT material type", "&7simply click and type it."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "IRON_SWORD");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null) != Material.AIR) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "BUKKIT MATERIAL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.chancePane(player, itemMap, null, ItemHandler.getMaterial(ChatColor.stripColor((String)event.getMessage()), null));
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noMaterial", (CommandSender)player, placeHolders);
                    Menu.blocksPane(player, itemMap);
                }
            }));
            Inventory inventoryCheck = Bukkit.getServer().createInventory(null, 9, GUIName);
            for (Material material : Material.values()) {
                if (!material.isBlock() || !itemMap.getBlocksDrop().containsKey(material) || material.name().contains("LEGACY") || material.name().equals("AIR") || !Menu.safeMaterial(ItemHandler.getItem(material.toString(), 1, false, false, "", ""), inventoryCheck)) continue;
                if (!ServerUtils.hasSpecificUpdate("1_13") && LegacyAPI.getDataValue(material) != 0) {
                    for (i = 0; i <= LegacyAPI.getDataValue(material); ++i) {
                        if (material.toString().equalsIgnoreCase("STEP") && (!material.toString().equalsIgnoreCase("STEP") || i == 2)) continue;
                        blockPane.addButton(new Button(ItemHandler.getItem(material + ":" + i, 1, itemMap.getBlocksDrop().containsKey(material), false, "", "&7", "&7*Click to set the material.", itemMap.getBlocksDrop().containsKey(material) ? "&9&lChance: &a" + itemMap.getBlocksDrop().get(material) : ""), event -> {
                            if (itemMap.getBlocksDrop().containsKey(material)) {
                                Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                                blocksDrop.remove(material);
                                itemMap.setBlocksDrop(blocksDrop);
                                Menu.blocksPane(player, itemMap);
                            } else {
                                Menu.chancePane(player, itemMap, null, material);
                            }
                        }));
                    }
                    continue;
                }
                blockPane.addButton(new Button(ItemHandler.getItem(material.toString(), 1, itemMap.getBlocksDrop().containsKey(material), false, "", "&7", "&7*Click to set the material.", itemMap.getBlocksDrop().containsKey(material) ? "&9&lChance: &a" + itemMap.getBlocksDrop().get(material) : ""), event -> {
                    if (itemMap.getBlocksDrop().containsKey(material)) {
                        Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                        blocksDrop.remove(material);
                        itemMap.setBlocksDrop(blocksDrop);
                        Menu.blocksPane(player, itemMap);
                    } else {
                        Menu.chancePane(player, itemMap, null, material);
                    }
                }));
            }
            for (Material material : Material.values()) {
                if (!material.isBlock() || itemMap.getBlocksDrop().containsKey(material) || material.name().contains("LEGACY") || material.name().equals("AIR") || !Menu.safeMaterial(ItemHandler.getItem(material.toString(), 1, false, false, "", ""), inventoryCheck)) continue;
                if (!ServerUtils.hasSpecificUpdate("1_13") && LegacyAPI.getDataValue(material) != 0) {
                    for (i = 0; i <= LegacyAPI.getDataValue(material); ++i) {
                        if (material.toString().equalsIgnoreCase("STEP") && (!material.toString().equalsIgnoreCase("STEP") || i == 2)) continue;
                        blockPane.addButton(new Button(ItemHandler.getItem(material + ":" + i, 1, itemMap.getBlocksDrop().containsKey(material), false, "", "&7", "&7*Click to set the material.", itemMap.getBlocksDrop().containsKey(material) ? "&9&lChance: &a" + itemMap.getBlocksDrop().get(material) : ""), event -> {
                            if (itemMap.getBlocksDrop().containsKey(material)) {
                                Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                                blocksDrop.remove(material);
                                itemMap.setBlocksDrop(blocksDrop);
                                Menu.blocksPane(player, itemMap);
                            } else {
                                Menu.chancePane(player, itemMap, null, material);
                            }
                        }));
                    }
                    continue;
                }
                blockPane.addButton(new Button(ItemHandler.getItem(material.toString(), 1, itemMap.getBlocksDrop().containsKey(material), false, "", "&7", "&7*Click to set the material.", itemMap.getBlocksDrop().containsKey(material) ? "&9&lChance: &a" + itemMap.getBlocksDrop().get(material) : ""), event -> {
                    if (itemMap.getBlocksDrop().containsKey(material)) {
                        Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                        blocksDrop.remove(material);
                        itemMap.setBlocksDrop(blocksDrop);
                        Menu.blocksPane(player, itemMap);
                    } else {
                        Menu.chancePane(player, itemMap, null, material);
                    }
                }));
            }
            inventoryCheck.clear();
        });
        blockPane.open(player);
    }

    private static void chancePane(Player player, ItemMap itemMap, EntityType entity, Material material) {
        Interface chancePane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (entity != null) {
                chancePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the mobs drop menu."), event -> Menu.mobsPane(player, itemMap)));
            } else {
                chancePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the blocks drop menu."), event -> Menu.blocksPane(player, itemMap)));
            }
            chancePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRAY_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:7", 1, false, false, "&e&lCustom Drop Chance", "&7", "&7*Click to set a custom drop chance", "&7value for the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DROP CHANCE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "0.001");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(ChatColor.stripColor((String)event.getMessage()))) {
                    if (entity != null) {
                        Map<EntityType, Double> mobsDrop = itemMap.getMobsDrop();
                        mobsDrop.put(entity, Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                        itemMap.setMobsDrop(mobsDrop);
                    } else {
                        Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                        blocksDrop.put(material, Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                        itemMap.setBlocksDrop(blocksDrop);
                    }
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DROP CHANCE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                if (entity != null) {
                    Menu.mobsPane(event.getPlayer(), itemMap);
                } else {
                    Menu.blocksPane(event.getPlayer(), itemMap);
                }
            }));
            for (double i = 0.01; i < 1.0; i += 0.01) {
                double k = Double.parseDouble(new DecimalFormat("#.##").format(Double.parseDouble(Double.toString(i).replace(",", "."))).replace(",", "."));
                chancePane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PURPLE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:10", 1, false, false, "&9&lCost: &a$&l" + k, "&7", "&7*Click to set the", "&7drop chance of the item."), event -> {
                    if (entity != null) {
                        Map<EntityType, Double> mobsDrop = itemMap.getMobsDrop();
                        mobsDrop.put(entity, k);
                        itemMap.setMobsDrop(mobsDrop);
                        Menu.mobsPane(player, itemMap);
                    } else {
                        Map<Material, Double> blocksDrop = itemMap.getBlocksDrop();
                        blocksDrop.put(material, k);
                        itemMap.setBlocksDrop(blocksDrop);
                        Menu.blocksPane(player, itemMap);
                    }
                }));
            }
        });
        chancePane.open(player);
    }

    private static void conditionsPane(Player player, ItemMap itemMap) {
        Interface conditionsPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            conditionsPane.addButton(new Button(fillerPaneBItem), 3);
            conditionsPane.addButton(new Button(ItemHandler.getItem("CACTUS", 1, false, false, "&b&l&nDisposable&b&l Conditions", "&7", "&7*Condition(s) that must be met", "&7in order for the disposable", "&7itemflag to function.", "&7", "&c&l&nNOTE:&7 The disposable itemflag", "&7must be defined for this", "&7condition to function.", "&7", "&9&lENABLED: &a" + String.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisposableConditions() + "").equals("NONE")).toUpperCase()), event -> Menu.disposableCPane(player, itemMap)));
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&b&l&nTrigger&b&l Conditions", "&7", "&7*Condition(s) that must be met", "&7in order to to receive the", "&7item when performing a trigger.", "&7", "&9&lENABLED: &a" + String.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggerConditions() + "").equals("NONE")).toUpperCase()), event -> Menu.triggerCPane(player, itemMap)));
            conditionsPane.addButton(new Button(fillerPaneBItem), 3);
            conditionsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            conditionsPane.addButton(new Button(fillerPaneBItem), 7);
            conditionsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        conditionsPane.open(player);
    }

    private static void commandActionPane(Player player, ItemMap itemMap) {
        Interface commandPane = new Interface(false, 5, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_ALL)));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_ALL)));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "PISTON_BASE", 1, false, false, "&e&lPhysical", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.PHYSICAL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.PHYSICAL)));
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_HELMET", 1, false, true, "&e&lOn-Equip", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_EQUIP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_EQUIP)));
            commandPane.addButton(new Button(ItemHandler.getItem("IRON_HELMET", 1, false, true, "&e&lUn-Equip", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.UN_EQUIP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.UN_EQUIP)));
            commandPane.addButton(new Button(ItemHandler.getItem("TORCH", 1, false, false, "&e&lOn-Hold", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_HOLD.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_HOLD)));
            commandPane.addButton(new Button(ItemHandler.getItem("ARROW", 1, false, false, "&e&lOn-Fire", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_FIRE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_FIRE)));
            commandPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&lOn-Drop", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_DROP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_DROP)));
            commandPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, true, "&e&lOn-Consume", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_CONSUME.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_CONSUME)));
            commandPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&e&lOn-Receive", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_RECEIVE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_RECEIVE)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SKELETON_SKULL" : "397", 1, false, false, "&e&lOn-Death", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_DEATH.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_DEATH)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PLAYER_HEAD" : "397:3", 1, false, false, "&e&lOn-Kill", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_KILL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_KILL)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLASS" : "20", 1, false, false, "&e&lInteract-Air", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS" : "95:3", 1, false, false, "&e&lInteract-Air-Left", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_LEFT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS" : "95:6", 1, false, false, "&e&lInteract-Air-Right", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_RIGHT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2:4", 1, false, false, "&e&lInteract-Block", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE" : "1", 1, false, false, "&e&lInteract-Block-Left", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_LEFT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE" : "4", 1, false, false, "&e&lInteract-Block-Right", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_DOOR" : "330", 1, false, false, "&e&lInteract-Left", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_LEFT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_ALL)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract-Right", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INTERACT_RIGHT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_ALL)));
            commandPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&e&lInventory-Swap-Cursor", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_SWAP_CURSOR)));
            if (!ServerUtils.hasSpecificUpdate("1_21")) {
                commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SNOWBALL" : "SNOW_BALL", 8, false, false, "&e&lInventory-Middle", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_MIDDLE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_MIDDLE)));
            } else {
                commandPane.addButton(new Button(fillerPaneBItem));
            }
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&e&lInventory-Creative", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_CREATIVE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_CREATIVE)));
            commandPane.addButton(new Button(ItemHandler.getItem("ENDER_CHEST", 1, false, false, "&e&lInventory-Left", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_LEFT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_LEFT)));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory-Right", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_RIGHT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_RIGHT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE_SLAB" : "44", 2, false, false, "&e&lInventory-Shift-Left", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_LEFT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE_SLAB" : "44:3", 2, false, false, "&e&lInventory-Shift-Right", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_RIGHT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&e&lOn-Join", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_JOIN.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_JOIN)));
            commandPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&e&lOn-Damage", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_DAMAGE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_DAMAGE)));
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, false, true, "&e&lOn-Hit", "&7", "&7*Condition(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions().get(ItemCommand.Action.ON_HIT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandCPane(player, itemMap, ItemCommand.Action.ON_HIT)));
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item conditions menu."), event -> Menu.commandPane(player, itemMap)));
            commandPane.addButton(new Button(fillerPaneBItem), 7);
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item conditions menu."), event -> Menu.commandPane(player, itemMap)));
        });
        commandPane.open(player);
    }

    private static void commandPermissionPane(Player player, ItemMap itemMap) {
        Interface commandPane = new Interface(false, 5, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_ALL)));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_ALL)));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "PISTON_BASE", 1, false, false, "&e&lPhysical", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.PHYSICAL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.PHYSICAL)));
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_HELMET", 1, false, true, "&e&lOn-Equip", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_EQUIP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_EQUIP)));
            commandPane.addButton(new Button(ItemHandler.getItem("IRON_HELMET", 1, false, true, "&e&lUn-Equip", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.UN_EQUIP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.UN_EQUIP)));
            commandPane.addButton(new Button(ItemHandler.getItem("TORCH", 1, false, false, "&e&lOn-Hold", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_HOLD.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_HOLD)));
            commandPane.addButton(new Button(ItemHandler.getItem("ARROW", 1, false, false, "&e&lOn-Fire", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_FIRE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_FIRE)));
            commandPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&lOn-Drop", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_DROP.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_DROP)));
            commandPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, true, "&e&lOn-Consume", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_CONSUME.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_CONSUME)));
            commandPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&e&lOn-Receive", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_RECEIVE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_RECEIVE)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SKELETON_SKULL" : "397", 1, false, false, "&e&lOn-Death", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_DEATH.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_DEATH)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PLAYER_HEAD" : "397:3", 1, false, false, "&e&lOn-Kill", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_KILL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_KILL)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLASS" : "20", 1, false, false, "&e&lInteract-Air", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS" : "95:3", 1, false, false, "&e&lInteract-Air-Left", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_LEFT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS" : "95:6", 1, false, false, "&e&lInteract-Air-Right", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_RIGHT_AIR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_AIR)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2:4", 1, false, false, "&e&lInteract-Block", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE" : "1", 1, false, false, "&e&lInteract-Block-Left", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_LEFT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE" : "4", 1, false, false, "&e&lInteract-Block-Right", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_BLOCK)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_DOOR" : "330", 1, false, false, "&e&lInteract-Left", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_LEFT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_LEFT_ALL)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract-Right", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INTERACT_RIGHT_ALL.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INTERACT_RIGHT_ALL)));
            commandPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&e&lInventory-Swap-Cursor", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_SWAP_CURSOR)));
            if (!ServerUtils.hasSpecificUpdate("1_21")) {
                commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SNOWBALL" : "SNOW_BALL", 8, false, false, "&e&lInventory-Middle", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_MIDDLE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_MIDDLE)));
            } else {
                commandPane.addButton(new Button(fillerPaneBItem));
            }
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&e&lInventory-Creative", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_CREATIVE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_CREATIVE)));
            commandPane.addButton(new Button(ItemHandler.getItem("ENDER_CHEST", 1, false, false, "&e&lInventory-Left", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_LEFT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_LEFT)));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory-Right", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_RIGHT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_RIGHT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE_SLAB" : "44", 2, false, false, "&e&lInventory-Shift-Left", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_LEFT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE_SLAB" : "44:3", 2, false, false, "&e&lInventory-Shift-Right", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.INVENTORY_SHIFT_RIGHT)));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&e&lOn-Join", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_JOIN.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_JOIN)));
            commandPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&e&lOn-Damage", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_DAMAGE.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_DAMAGE)));
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, false, true, "&e&lOn-Hit", "&7", "&7*Permissions(s) that must be met", "&7in order to execute item commands.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions().get(ItemCommand.Action.ON_HIT.config()) + "").equals("NONE") ? "YES" : "NO")), event -> Menu.commandPPane(player, itemMap, ItemCommand.Action.ON_HIT)));
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            commandPane.addButton(new Button(fillerPaneBItem), 7);
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
        });
        commandPane.open(player);
    }

    private static void commandFailPane(Player player, ItemMap itemMap) {
        Interface commandPane = new Interface(false, 5, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_ALL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_ALL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_ALL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_ALL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagesMap = itemMap.getCommandMessages();
                messagesMap.put(ItemCommand.Action.INTERACT_ALL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagesMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_ALL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_ALL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_ALL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_ALL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_ALL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(fillerPaneGItem));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PISTON" : "PISTON_BASE", 1, false, false, "&e&lPhysical", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.PHYSICAL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.PHYSICAL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.PHYSICAL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.PHYSICAL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.PHYSICAL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(fillerPaneGItem), 2);
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_HELMET", 1, false, true, "&e&lOn-Equip", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_EQUIP.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_EQUIP.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_EQUIP.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_EQUIP.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_EQUIP.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("IRON_HELMET", 1, false, true, "&e&lUn-Equip", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.UN_EQUIP.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.UN_EQUIP.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.UN_EQUIP.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.UN_EQUIP.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.UN_EQUIP.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("TORCH", 1, false, false, "&e&lOn-Hold", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_HOLD.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_HOLD.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_HOLD.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_HOLD.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_HOLD.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("ARROW", 1, false, false, "&e&lOn-Fire", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_FIRE.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_FIRE.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_FIRE.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_FIRE.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_FIRE.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("HOPPER", 1, false, false, "&e&lOn-Drop", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_DROP.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_DROP.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_DROP.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_DROP.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_DROP.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, true, "&e&lOn-Consume", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_CONSUME.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_CONSUME.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_CONSUME.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_CONSUME.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_CONSUME.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, false, false, "&e&lOn-Receive", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_RECEIVE.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_RECEIVE.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_RECEIVE.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_RECEIVE.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_RECEIVE.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SKELETON_SKULL" : "397", 1, false, false, "&e&lOn-Death", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_DEATH.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_DEATH.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_DEATH.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_DEATH.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_DEATH.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PLAYER_HEAD" : "397:3", 1, false, false, "&e&lOn-Kill", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_KILL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_KILL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_KILL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_KILL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_KILL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GLASS" : "20", 1, false, false, "&e&lInteract-Air", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_AIR.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_AIR.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_AIR.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_AIR.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_AIR.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIGHT_BLUE_STAINED_GLASS" : "95:3", 1, false, false, "&e&lInteract-Air-Left", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_AIR.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_AIR.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_AIR.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_LEFT_AIR.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_LEFT_AIR.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS" : "95:6", 1, false, false, "&e&lInteract-Air-Right", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_AIR.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_AIR.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_AIR.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_RIGHT_AIR.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_RIGHT_AIR.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2:4", 1, false, false, "&e&lInteract-Block", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_BLOCK.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_BLOCK.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_BLOCK.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_BLOCK.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_BLOCK.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE" : "1", 1, false, false, "&e&lInteract-Block-Left", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_BLOCK.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_BLOCK.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_BLOCK.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_LEFT_BLOCK.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_LEFT_BLOCK.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE" : "4", 1, false, false, "&e&lInteract-Block-Right", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_RIGHT_BLOCK.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "IRON_DOOR" : "330", 1, false, false, "&e&lInteract-Left", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_ALL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_ALL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_LEFT_ALL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_LEFT_ALL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_LEFT_ALL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_DOOR" : "324", 1, false, false, "&e&lInteract-Right", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_ALL.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_ALL.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INTERACT_RIGHT_ALL.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INTERACT_RIGHT_ALL.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INTERACT_RIGHT_ALL.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&e&lInventory-Swap-Cursor", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_SWAP_CURSOR.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            if (!ServerUtils.hasSpecificUpdate("1_21")) {
                commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "SNOWBALL" : "SNOW_BALL", 8, false, false, "&e&lInventory-Middle", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_MIDDLE.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_MIDDLE.config()) : "NONE")), event -> {
                    if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_MIDDLE.config()) == null) {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    } else {
                        Map<String, String> messagesMap = itemMap.getCommandMessages();
                        messagesMap.remove(ItemCommand.Action.INVENTORY_MIDDLE.config());
                        itemMap.setCommandMessages(messagesMap);
                        Menu.commandFailPane(player, itemMap);
                    }
                }, event -> {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Map<String, String> messagessMap = itemMap.getCommandMessages();
                    messagessMap.put(ItemCommand.Action.INVENTORY_MIDDLE.config(), ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setCommandMessages(messagessMap);
                    Menu.commandFailPane(player, itemMap);
                }));
            } else {
                commandPane.addButton(new Button(fillerPaneBItem));
            }
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&e&lInventory-Creative", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_CREATIVE.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_CREATIVE.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_CREATIVE.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_CREATIVE.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_CREATIVE.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("ENDER_CHEST", 1, false, false, "&e&lInventory-Left", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_LEFT.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_LEFT.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_LEFT.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_LEFT.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_LEFT.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&e&lInventory-Right", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_RIGHT.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_RIGHT.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_RIGHT.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_RIGHT.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_RIGHT.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STONE_SLAB" : "44", 2, false, false, "&e&lInventory-Shift-Left", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_SHIFT_LEFT.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "COBBLESTONE_SLAB" : "44:3", 2, false, false, "&e&lInventory-Shift-Right", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.INVENTORY_SHIFT_RIGHT.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_SIGN" : "323", 1, false, false, "&e&lOn-Join", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_JOIN.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_JOIN.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_JOIN.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_JOIN.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_JOIN.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("LAVA_BUCKET", 1, false, false, "&e&lOn-Damage", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_DAMAGE.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_DAMAGE.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_DAMAGE.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_DAMAGE.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_DAMAGE.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("DIAMOND_SWORD", 1, false, true, "&e&lOn-Hit", "&7", "&7*Message that will be sent when", "&7either the permission or conditions", "&7requirements are not met.", "&7", "&9&lENABLED: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandMessages().get(ItemCommand.Action.ON_HIT.config())).equals("NONE") ? itemMap.getCommandMessages().get(ItemCommand.Action.ON_HIT.config()) : "NONE")), event -> {
                if (itemMap.getCommandMessages().get(ItemCommand.Action.ON_HIT.config()) == null) {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "You do not meet the requirements to execute this command.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                } else {
                    Map<String, String> messagesMap = itemMap.getCommandMessages();
                    messagesMap.remove(ItemCommand.Action.ON_HIT.config());
                    itemMap.setCommandMessages(messagesMap);
                    Menu.commandFailPane(player, itemMap);
                }
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Map<String, String> messagessMap = itemMap.getCommandMessages();
                messagessMap.put(ItemCommand.Action.ON_HIT.config(), ChatColor.stripColor((String)event.getMessage()));
                itemMap.setCommandMessages(messagessMap);
                Menu.commandFailPane(player, itemMap);
            }));
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
            commandPane.addButton(new Button(fillerPaneBItem), 7);
            commandPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item commands menu."), event -> Menu.commandPane(player, itemMap)));
        });
        commandPane.open(player);
    }

    private static void commandPPane(Player player, ItemMap itemMap, ItemCommand.Action commandAction) {
        Interface permissionsPane = new Interface(true, 2, exitButton, GUIName, player);
        permissionsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command actions menu."), event -> Menu.commandPermissionPane(player, itemMap)));
        SchedulerUtils.runAsync(() -> {
            permissionsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&b&lAdd Permission", "&7", "&7*Permissions(s) that must be met", "&7in order to execute the", "&7" + commandAction.config().replace("-", " ").replace(".", "") + " item commands.", "&7", "&c&lNote: &7You can use a &c&l! &7symbol", "&7to invert the requirement", "&7such as !fish.cakes"), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PERMISSION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "fish.cakes");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PERMISSION");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> permissions = itemMap.getCommandPermissions().get(commandAction.config()) != null ? itemMap.getCommandPermissions().get(commandAction.config()) : new ArrayList<String>();
                permissions.add(ChatColor.stripColor((String)event.getMessage()));
                Map<String, List<String>> permissionsMap = itemMap.getCommandPermissions();
                permissionsMap.put(commandAction.config(), permissions);
                itemMap.setCommandPermissions(permissionsMap);
                Menu.commandPPane(player, itemMap, commandAction);
            }));
            if (itemMap.getCommandPermissions().get(commandAction.config()) != null) {
                for (String permission : itemMap.getCommandPermissions().get(commandAction.config())) {
                    permissionsPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&f" + permission, "&7", "&7*Click to remove this permission."), event -> {
                        Map<String, List<String>> commands = itemMap.getCommandPermissions();
                        List<String> permissions = commands.get(commandAction.config());
                        permissions.remove(permission);
                        if (!permissions.isEmpty()) {
                            commands.put(commandAction.config(), permissions);
                        } else {
                            commands.remove(commandAction.config());
                        }
                        itemMap.setCommandPermissions(commands);
                        Menu.commandPPane(player, itemMap, commandAction);
                    }));
                }
            }
        });
        permissionsPane.open(player);
    }

    private static void commandCPane(Player player, ItemMap itemMap, ItemCommand.Action commandAction) {
        Interface conditionsPane = new Interface(true, 2, exitButton, GUIName, player);
        conditionsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the command actions menu."), event -> Menu.commandActionPane(player, itemMap)));
        SchedulerUtils.runAsync(() -> {
            conditionsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&b&lAdd Condition", "&7", "&7*Condition(s) that must be met", "&7in order to execute the", "&7" + commandAction.config().replace("-", " ").replace(".", "") + " item commands."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "100");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.addConditionPane(event.getPlayer(), itemMap, commandAction, commandAction.config(), ChatColor.stripColor((String)event.getMessage()));
            }));
            if (itemMap.getCommandConditions().get(commandAction.config()) != null) {
                for (String condition : itemMap.getCommandConditions().get(commandAction.config())) {
                    conditionsPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&f" + condition, "&7", "&7*Click to remove this condition."), event -> {
                        Map<String, List<String>> commands = itemMap.getCommandConditions();
                        List<String> conditions = commands.get(commandAction.config());
                        conditions.remove(condition);
                        if (!conditions.isEmpty()) {
                            commands.put(commandAction.config(), conditions);
                        } else {
                            commands.remove(commandAction.config());
                        }
                        itemMap.setCommandConditions(commands);
                        Menu.commandCPane(player, itemMap, commandAction);
                    }));
                }
            }
        });
        conditionsPane.open(player);
    }

    private static void disposableCPane(Player player, ItemMap itemMap) {
        Interface conditionsPane = new Interface(true, 2, exitButton, GUIName, player);
        conditionsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item conditions menu."), event -> Menu.conditionsPane(player, itemMap)));
        SchedulerUtils.runAsync(() -> {
            conditionsPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisposableMessage()).equals("NONE"), false, "&c&lDisposable Fail Message", "&7", "&7*An optional message to be", "&7sent when the player does not", "&7meet the disposable conditions.", "&7", "&9&lMESSAGE: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisposableMessage()).equals("NONE") ? itemMap.getDisposableMessage() : "NONE")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisposableMessage()).equals("NONE")) {
                    itemMap.setDisposableMessage(null);
                    Menu.disposableCPane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DISPOSABLE FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&cYou do not meet the conditions to dispose of this item.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setDisposableMessage(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "DISPOSABLE FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.disposableCPane(event.getPlayer(), itemMap);
            }));
            conditionsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&b&lAdd Condition", "&7", "&7*Condition(s) that must be met", "&7in order to dispose of the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "100");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.addConditionPane(event.getPlayer(), itemMap, null, "disposable-conditions", ChatColor.stripColor((String)event.getMessage()));
            }));
            for (String condition : itemMap.getDisposableConditions()) {
                conditionsPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&f" + condition, "&7", "&7*Click to remove this condition."), event -> {
                    List<String> conditions = itemMap.getDisposableConditions();
                    conditions.remove(condition);
                    itemMap.setDisposableConditions(conditions);
                    Menu.disposableCPane(player, itemMap);
                }));
            }
        });
        conditionsPane.open(player);
    }

    private static void triggerCPane(Player player, ItemMap itemMap) {
        Interface conditionsPane = new Interface(true, 2, exitButton, GUIName, player);
        conditionsPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item conditions menu."), event -> Menu.conditionsPane(player, itemMap)));
        SchedulerUtils.runAsync(() -> {
            conditionsPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggerMessage()).equals("NONE"), false, "&c&lTrigger Fail Message", "&7", "&7*An optional message to be", "&7sent when the player does not", "&7meet the trigger conditions.", "&7", "&9&lMESSAGE: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggerMessage()).equals("NONE") ? itemMap.getTriggerMessage() : "NONE")), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggerMessage()).equals("NONE")) {
                    itemMap.setTriggerMessage(null);
                    Menu.triggerCPane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TRIGGER FAIL MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&cYou do not meet the conditions to receive this item.");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setTriggerMessage(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TRIGGER FAIL MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.triggerCPane(event.getPlayer(), itemMap);
            }));
            conditionsPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&b&lAdd Condition", "&7", "&7*Condition(s) that must be met", "&7in order to receive the item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "100");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIRST VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.addConditionPane(event.getPlayer(), itemMap, null, "trigger-conditions", ChatColor.stripColor((String)event.getMessage()));
            }));
            for (String condition : itemMap.getTriggerConditions()) {
                conditionsPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&f" + condition, "&7", "&7*Click to remove this condition."), event -> {
                    List<String> conditions = itemMap.getTriggerConditions();
                    conditions.remove(condition);
                    itemMap.setTriggerConditions(conditions);
                    Menu.triggerCPane(player, itemMap);
                }));
            }
        });
        conditionsPane.open(player);
    }

    private static void addConditionPane(Player player, ItemMap itemMap, ItemCommand.Action commandAction, String condition, String value) {
        Interface conditionsPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem("MINECART", 1, false, false, "&b&lEQUAL", "&7", "&7*The first value must be", "&7EQUAL to the second value", "&7for the condition to be met."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "400");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> conditions = condition.equalsIgnoreCase("disposable-conditions") ? itemMap.getDisposableConditions() : (condition.equalsIgnoreCase("trigger-conditions") ? itemMap.getTriggerConditions() : (itemMap.getCommandConditions().get(condition) != null ? itemMap.getCommandConditions().get(condition) : new ArrayList<String>()));
                conditions.add(value + ":EQUAL:" + ChatColor.stripColor((String)event.getMessage()));
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    itemMap.setDisposableConditions(conditions);
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    itemMap.setTriggerConditions(conditions);
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Map<String, List<String>> conditions2 = itemMap.getCommandConditions();
                    conditions2.put(condition.replace("-conditions", ""), conditions);
                    itemMap.setCommandConditions(conditions2);
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_FENCE" : "85", 1, false, false, "&b&lNOTEQUAL", "&7", "&7*The first value must be", "&7NOTEQUAL to the second value", "&7for the condition to be met."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "400");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> conditions = condition.equalsIgnoreCase("disposable-conditions") ? itemMap.getDisposableConditions() : (condition.equalsIgnoreCase("trigger-conditions") ? itemMap.getTriggerConditions() : (itemMap.getCommandConditions().get(condition) != null ? itemMap.getCommandConditions().get(condition) : new ArrayList<String>()));
                conditions.add(value + ":NOTEQUAL:" + ChatColor.stripColor((String)event.getMessage()));
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    itemMap.setDisposableConditions(conditions);
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    itemMap.setTriggerConditions(conditions);
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Map<String, List<String>> conditions2 = itemMap.getCommandConditions();
                    conditions2.put(condition.replace("-conditions", ""), conditions);
                    itemMap.setCommandConditions(conditions2);
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_STAIRS" : "53", 1, false, false, "&b&lOVER", "&7", "&7*The first value must be", "&7OVER the second value", "&7for the condition to be met.", "&7", "&c&l&nNOTE:&7 This only works if both", "&7values referenced are integers."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "400");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> conditions = condition.equalsIgnoreCase("disposable-conditions") ? itemMap.getDisposableConditions() : (condition.equalsIgnoreCase("trigger-conditions") ? itemMap.getTriggerConditions() : (itemMap.getCommandConditions().get(condition) != null ? itemMap.getCommandConditions().get(condition) : new ArrayList<String>()));
                conditions.add(value + ":OVER:" + ChatColor.stripColor((String)event.getMessage()));
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    itemMap.setDisposableConditions(conditions);
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    itemMap.setTriggerConditions(conditions);
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Map<String, List<String>> conditions2 = itemMap.getCommandConditions();
                    conditions2.put(condition.replace("-conditions", ""), conditions);
                    itemMap.setCommandConditions(conditions2);
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "OAK_BOAT" : "333", 1, false, false, "&b&lUNDER", "&7", "&7*The first value must be", "&7UNDER to the second value", "&7for the condition to be met.", "&7", "&c&l&nNOTE:&7 This only works if both", "&7values referenced are integers."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "400");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SECOND VALUE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                ArrayList<String> conditions = condition.equalsIgnoreCase("disposable-conditions") ? itemMap.getDisposableConditions() : (condition.equalsIgnoreCase("trigger-conditions") ? itemMap.getTriggerConditions() : (itemMap.getCommandConditions().get(condition) != null ? itemMap.getCommandConditions().get(condition) : new ArrayList<String>()));
                conditions.add(value + ":UNDER:" + ChatColor.stripColor((String)event.getMessage()));
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    itemMap.setDisposableConditions(conditions);
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    itemMap.setTriggerConditions(conditions);
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Map<String, List<String>> conditions2 = itemMap.getCommandConditions();
                    conditions2.put(condition.replace("-conditions", ""), conditions);
                    itemMap.setCommandConditions(conditions2);
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
            conditionsPane.addButton(new Button(fillerPaneBItem));
            conditionsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the " + condition.replace("-", " ").replace(".", "") + " condition menu."), event -> {
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
            conditionsPane.addButton(new Button(fillerPaneBItem), 7);
            conditionsPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the " + condition.replace("-", " ").replace(".", "") + " condition menu."), event -> {
                if (condition.equalsIgnoreCase("disposable-conditions")) {
                    Menu.disposableCPane(player, itemMap);
                } else if (condition.equalsIgnoreCase("trigger-conditions")) {
                    Menu.triggerCPane(player, itemMap);
                } else {
                    Menu.commandCPane(player, itemMap, commandAction);
                }
            }));
        });
        conditionsPane.open(player);
    }

    private static void altCommandPane(Player player, ItemMap itemMap, int stage) {
        Interface commandListPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage == 4) {
                commandListPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.activeCommands(player)));
            } else {
                commandListPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the click type menu."), event -> Menu.togglePane(player, itemMap)));
            }
            commandListPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&lNew Line", "&7", "&7*Add a new command to be executed."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 4 ? "ACTIVE COMMAND" : "TOGGLE COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, stage == 4 ? "gamemode creative %player%" : "pvp");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (stage == 4) {
                    List commands = ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands");
                    commands.add(ChatColor.stripColor((String)event.getMessage()));
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands", (Object)commands);
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.altCommandPane(player, itemMap, stage));
                } else {
                    List<String> toggleCommands = itemMap.getToggleCommands();
                    toggleCommands.add(ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setToggleCommands(toggleCommands);
                }
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 4 ? "ACTIVE COMMAND" : "TOGGLE COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.altCommandPane(event.getPlayer(), itemMap, stage);
            }));
            List commandsList = stage == 4 ? ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands") : itemMap.getToggleCommands();
            for (String command : commandsList) {
                commandListPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&f" + command, "&7", "&7*Click to&l modify &7this command."), event -> Menu.modifyAltCommandsPane(player, itemMap, command, stage)));
            }
        });
        commandListPane.open(player);
    }

    private static void modifyAltCommandsPane(Player player, ItemMap itemMap, String command, int stage) {
        Interface modPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            modPane.addButton(new Button(fillerPaneGItem), 4);
            modPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&f" + command, "&7", "&7*You are modifying this command.")));
            modPane.addButton(new Button(fillerPaneGItem), 7);
            modPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, false, false, "&fModify", "&7", "&7*Sets the command to", "&7another text entry."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 4 ? "MODIFIED ACTIVE COMMAND" : "MODIFIED TOGGLE COMMAND").with(PlaceHolder.Holder.INPUT_EXAMPLE, stage == 4 ? "gamemode survival %player%" : "pvp on");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (stage == 4) {
                    List commands = ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands");
                    commands.remove(command);
                    commands.add(ChatColor.stripColor((String)event.getMessage()));
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands", (Object)commands);
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.altCommandPane(player, itemMap, stage));
                } else {
                    List<String> toggleCommands = itemMap.getToggleCommands();
                    toggleCommands.remove(command);
                    toggleCommands.add(ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setToggleCommands(toggleCommands);
                }
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, stage == 4 ? "MODIFIED ACTIVE COMMAND" : "MODIFIED TOGGLE COMMAND");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.altCommandPane(player, itemMap, stage);
            }));
            modPane.addButton(new Button(fillerPaneGItem));
            modPane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&fDelete", "&7", "&7*Click to&c delete &7this command."), event -> {
                if (stage == 4) {
                    List commands = ItemJoin.getCore().getConfig("config.yml").getStringList("Active-Commands.commands");
                    commands.remove(command);
                    File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
                    YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
                    dataFile.set("Active-Commands.commands", (Object)commands);
                    ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
                    PluginData.getInfo().softReload();
                    SchedulerUtils.runLater(2L, () -> Menu.altCommandPane(player, itemMap, stage));
                } else {
                    List<String> toggleCommands = itemMap.getToggleCommands();
                    toggleCommands.remove(command);
                    itemMap.setToggleCommands(toggleCommands);
                }
                Menu.altCommandPane(player, itemMap, stage);
            }));
            modPane.addButton(new Button(fillerPaneGItem), 3);
            if (stage == 4) {
                modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.altCommandPane(player, itemMap, stage)));
            } else {
                modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the toggle commands menu."), event -> Menu.altCommandPane(player, itemMap, stage)));
            }
            modPane.addButton(new Button(fillerPaneBItem), 7);
            if (stage == 4) {
                modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the active commands menu."), event -> Menu.altCommandPane(player, itemMap, stage)));
            } else {
                modPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the toggle commands menu."), event -> Menu.altCommandPane(player, itemMap, stage)));
            }
        });
        modPane.open(player);
    }

    private static void togglePane(Player player, ItemMap itemMap) {
        Interface togglePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            togglePane.addButton(new Button(fillerPaneBItem), 2);
            togglePane.addButton(new Button(ItemHandler.getItem("BOOK", 1, false, false, "&e&lCommands", "&7", "&7*Define specific commands which", "&7players can use to enable or disable", "&7the custom item upon execution."), event -> Menu.altCommandPane(player, itemMap, 0)));
            togglePane.addButton(new Button(fillerPaneBItem));
            togglePane.addButton(new Button(ItemHandler.getItem("PAPER", 1, !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleMessage()).equals("NONE"), false, "&b&lMessage", "&7", "&7*Set a custom message that", "&7will be sent to the player", "&7upon executing a toggle command.", "&9&lMESSAGE: &f" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleMessage())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleMessage()).equals("NONE")) {
                    itemMap.setToggleMessage(null);
                    Menu.togglePane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TOGGLE MESSAGE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&a%item% has been toggled!");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setToggleMessage(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TOGGLE MESSAGE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.togglePane(event.getPlayer(), itemMap);
            }));
            togglePane.addButton(new Button(fillerPaneBItem));
            togglePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleNode()).equals("NONE"), false, "&b&lPermissions", "&7", "&7*Set a custom permissions node", "&7that each player needs in order", "&7to execute the toggle commands.", "&9&lPERMISSIONS: &f" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleNode())), event -> {
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getToggleNode()).equals("NONE")) {
                    itemMap.setTogglePerm(null);
                    Menu.togglePane(player, itemMap);
                } else {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TOGGLE PERMISSION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "itemjoin.toggle");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }
            }, event -> {
                itemMap.setTogglePerm(ChatColor.stripColor((String)event.getMessage()));
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "TOGGLE PERMISSION");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.togglePane(event.getPlayer(), itemMap);
            }));
            togglePane.addButton(new Button(fillerPaneBItem), 2);
            togglePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            togglePane.addButton(new Button(fillerPaneBItem), 7);
            togglePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        togglePane.open(player);
    }

    private static void trimPane(Player player, ItemMap itemMap) {
        Interface trimPane = new Interface(true, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            trimPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            for (TrimMaterial material : Objects.requireNonNull(ItemHandler.getTrimMaterials())) {
                trimPane.addButton(new Button(ItemHandler.getItem(ItemHandler.TrimMaterial.valueOf(CompatUtils.getKey(material).toString().replace("minecraft:", "").toUpperCase()).getMaterial().name(), 1, false, false, "&f" + StringUtils.capitalize((String)CompatUtils.getKey(material).toString().replace("minecraft:", "")), "&7", "&7*Click to set this as", "&7the armor trim material."), event -> Menu.trimPatternPane(player, itemMap, material)));
            }
        });
        trimPane.open(player);
    }

    private static void trimPatternPane(Player player, ItemMap itemMap, TrimMaterial material) {
        Interface trimPatternPane = new Interface(true, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            trimPatternPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the trim material menu."), event -> Menu.trimPane(player, itemMap)));
            for (TrimPattern pattern : Objects.requireNonNull(ItemHandler.getTrimPatterns())) {
                trimPatternPane.addButton(new Button(ItemHandler.getItem(ItemHandler.getMaterial(CompatUtils.getKey(pattern).toString().replace("minecraft:", "").toUpperCase() + "_ARMOR_TRIM_SMITHING_TEMPLATE", null).name(), 1, false, false, "&f" + StringUtils.capitalize((String)CompatUtils.getKey(pattern).toString().replace("minecraft:", "")), "&7", "&7*Click to set this as", "&7the armor trim pattern."), event -> {
                    HashMap<String, String> trimPattern = new HashMap<String, String>();
                    trimPattern.put(CompatUtils.getKey(material).toString().replace("minecraft:", "").toUpperCase(), CompatUtils.getKey(pattern).toString().replace("minecraft:", "").toUpperCase());
                    itemMap.setTrimPattern(trimPattern);
                    Menu.creatingPane(player, itemMap);
                }));
            }
        });
        trimPatternPane.open(player);
    }

    private static void recipePane(Player player, ItemMap itemMap) {
        Interface recipePane = new Interface(false, 4, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            recipePane.addButton(new Button(fillerPaneBItem), 3);
            for (int i = 0; i < 9; ++i) {
                ItemRecipe itemRecipe;
                int k = i;
                String stack = "CHEST";
                ItemStack stack1 = null;
                if (itemMap.getRecipe().get(0).size() > i && itemMap.getRecipe().get(0).get(i).charValue() != 'X' && (itemRecipe = itemMap.getIngredients().get(itemMap.getRecipe().get(0).get(i))) != null) {
                    ItemMap copyMap = ItemUtilities.getUtilities().getItemMap(itemRecipe.getMap());
                    if (copyMap != null) {
                        stack1 = copyMap.getItemStack(player);
                        stack1.setAmount(itemRecipe.getCount());
                    } else {
                        stack = itemRecipe.getMaterial().name() + (itemRecipe.getData() > 0 ? ":" + itemRecipe.getData() : "") + "#" + itemRecipe.getCount();
                    }
                }
                if (stack1 != null) {
                    ItemMeta meta = stack1.getItemMeta();
                    if (meta != null) {
                        ItemHandler.addLore(stack1, "&9&lDISPLAY: &f" + meta.getDisplayName(), "&7", "&7*Create a recipe that can be used.");
                        meta.setDisplayName(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(itemMap.getRecipe().get(0).size() > i ? "&e&l" + itemMap.getRecipe().get(0).get(i) : "&e&lX", player, new PlaceHolder[0]));
                        stack1.setItemMeta(meta);
                        recipePane.addButton(new Button(stack1, event -> {
                            if (itemMap.getRecipe().get(0).size() > k && itemMap.getRecipe().get(0).get(k).charValue() != 'X') {
                                Menu.setIngredients(player, itemMap, "AIR", k);
                            } else {
                                Menu.ingredientPane(player, itemMap, k);
                            }
                        }));
                    }
                } else {
                    recipePane.addButton(new Button(ItemHandler.getItem(stack.contains("#") ? stack.split("#")[0] : stack, stack.contains("#") ? Integer.parseInt(stack.split("#")[1]) : 1, false, false, itemMap.getRecipe().get(0).size() > i ? "&e&l" + itemMap.getRecipe().get(0).get(i) : "&e&lX", "&7", "&7*Create a recipe that can be used."), event -> {
                        if (itemMap.getRecipe().get(0).size() > k && itemMap.getRecipe().get(0).get(k).charValue() != 'X') {
                            Menu.setIngredients(player, itemMap, "AIR", k);
                        } else {
                            Menu.ingredientPane(player, itemMap, k);
                        }
                    }));
                }
                if (i == 2) {
                    recipePane.addButton(new Button(fillerPaneBItem), 6);
                    continue;
                }
                if (i == 5) {
                    recipePane.addButton(new Button(fillerPaneBItem));
                    recipePane.addButton(new Button(Menu.headerStack(player, itemMap)));
                    recipePane.addButton(new Button(fillerPaneBItem), 4);
                    continue;
                }
                if (i != 8) continue;
                recipePane.addButton(new Button(fillerPaneBItem), 3);
            }
            recipePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            recipePane.addButton(new Button(fillerPaneBItem), 7);
            recipePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        recipePane.open(player);
    }

    private static void ingredientPane(Player player, ItemMap itemMap, int k) {
        Interface ingredientPane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            ingredientPane.addButton(new Button(fillerPaneBItem), 3);
            ingredientPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GRASS_BLOCK" : "2", 1, false, false, "&b&lMaterial", "&7", "&7*Select a material type", "&7to be defined in the recipe."), event -> Menu.materialPane(player, itemMap, 3, k)));
            ingredientPane.addButton(new Button(fillerPaneBItem));
            ingredientPane.addButton(new Button(ItemHandler.getItem("CHEST", 1, false, false, "&b&lCustom Item", "&7", "&7*Select a custom item", "&7to be defined in the recipe."), event -> Menu.startModify(player, itemMap, k)));
            ingredientPane.addButton(new Button(fillerPaneBItem), 3);
            ingredientPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the recipe menu."), event -> Menu.recipePane(player, itemMap)));
            ingredientPane.addButton(new Button(fillerPaneBItem), 7);
            ingredientPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the recipe menu."), event -> Menu.recipePane(player, itemMap)));
        });
        ingredientPane.open(player);
    }

    private static void nbtPane(Player player, ItemMap itemMap) {
        Interface nbtPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            Map<Object, Object> properties = itemMap.getNBTProperties();
            nbtPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            nbtPane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, true, false, "&e&l&nNew Property", "&7", "&7*Add a new NBT Property to the custom item."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NBT PROPERTY").with(PlaceHolder.Holder.INPUT_EXAMPLE, "TranslatableDisplayName:&aUltra &cItem");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ChatColor.stripColor((String)event.getMessage()).contains(":")) {
                    String[] propertyParts = ChatColor.stripColor((String)event.getMessage()).split(":");
                    properties.put(propertyParts[0], propertyParts[1]);
                }
                itemMap.setNBTProperties(properties);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NBT PROPERTY");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.nbtPane(event.getPlayer(), itemMap);
            }));
            for (Object key : properties.keySet()) {
                nbtPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "STRUCTURE_BLOCK" : "137", 1, false, false, "&f" + key + ":" + properties.get(key), "&7", "&7*Click to modify or delete", "&7this custom NBT Property."), event -> Menu.modifyProperty(player, itemMap, key)));
            }
        });
        nbtPane.open(player);
    }

    private static void modifyProperty(Player player, ItemMap itemMap, Object key) {
        Interface modifyProperty = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            Map<Object, Object> properties = itemMap.getNBTProperties();
            modifyProperty.addButton(new Button(fillerPaneGItem), 3);
            modifyProperty.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&c&l&nModify", "&7", "&7*Modify this NBT Property.", "&7", "&9&lProperty: &a&f" + key + ":" + properties.get(key)), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NBT PROPERTY").with(PlaceHolder.Holder.INPUT_EXAMPLE, "TranslatableDisplayName:&aUltra &cItem");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (ChatColor.stripColor((String)event.getMessage()).contains(":")) {
                    properties.remove(key);
                    String[] propertyParts = ChatColor.stripColor((String)event.getMessage()).split(":");
                    properties.put(propertyParts[0], propertyParts[1]);
                }
                itemMap.setNBTProperties(properties);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "NBT PROPERTY");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.nbtPane(event.getPlayer(), itemMap);
            }));
            modifyProperty.addButton(new Button(fillerPaneGItem));
            modifyProperty.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this custom NBT Property.", "&7", "&9&lProperty: &a&f" + key + ":" + properties.get(key)), event -> {
                properties.remove(key);
                itemMap.setNBTProperties(properties);
                Menu.nbtPane(player, itemMap);
            }));
            modifyProperty.addButton(new Button(fillerPaneGItem), 3);
            modifyProperty.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the NBT Properties menu."), event -> Menu.nbtPane(player, itemMap)));
            modifyProperty.addButton(new Button(fillerPaneBItem), 7);
            modifyProperty.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the NBT Properties menu."), event -> Menu.nbtPane(player, itemMap)));
        });
        modifyProperty.open(player);
    }

    private static void setIngredients(Player player, ItemMap itemMap, String material, int position) {
        Map<Character, ItemRecipe> ingredients = itemMap.getIngredients();
        List<Character> recipe = itemMap.getRecipe().get(0);
        char character = 'A';
        for (char alphabet = 'A'; alphabet <= 'Z'; alphabet = (char)(alphabet + '\u0001')) {
            if (alphabet == 88 || ingredients.containsKey(Character.valueOf(alphabet))) continue;
            character = alphabet;
            break;
        }
        boolean containsMaterial = false;
        char existingCharacter = character;
        for (Character characters : ingredients.keySet()) {
            ItemRecipe itemRecipe = ingredients.get(characters);
            if ((itemRecipe.getMaterial() == null || !itemRecipe.getMaterial().name().equalsIgnoreCase(material)) && (itemRecipe.getMaterial() != null || !itemRecipe.getMap().equalsIgnoreCase(material))) continue;
            character = characters.charValue();
            containsMaterial = true;
            existingCharacter = characters.charValue();
            break;
        }
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(material, "AIR")) {
            char finalCharacter = !containsMaterial ? character : existingCharacter;
            Interface ingredPane = new Interface(true, 6, exitButton, GUIName, player);
            SchedulerUtils.runAsync(() -> {
                ingredPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item recipe menu."), event -> Menu.creatingPane(player, itemMap)));
                for (int i = 1; i <= 64; ++i) {
                    int k = i;
                    ingredPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lCount: &a&l" + k, "&7", "&7*Click to set the", "&7ingredient count (stack size)."), event -> {
                        ItemMap ingredMap = ItemUtilities.getUtilities().getItemMap(material);
                        if (ingredMap == null) {
                            ingredients.put(Character.valueOf(finalCharacter), new ItemRecipe(null, ItemHandler.getMaterial(material, null), 0, k));
                        } else {
                            ingredients.put(Character.valueOf(finalCharacter), new ItemRecipe(material, null, 0, k));
                        }
                        while (position >= recipe.size()) {
                            recipe.add(Character.valueOf('X'));
                        }
                        recipe.set(position, Character.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(material, "AIR") ? finalCharacter : (char)'X'));
                        itemMap.setRecipe(recipe);
                        itemMap.setIngredients(ingredients);
                        Menu.recipePane(player, itemMap);
                    }));
                }
            });
            ingredPane.open(player);
        } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(material, "AIR")) {
            int count = 0;
            for (Character recipes : recipe) {
                if (!recipes.equals(recipe.get(position))) continue;
                ++count;
            }
            if (count == 1) {
                ingredients.remove(recipe.get(position));
            }
            while (position >= recipe.size()) {
                recipe.add(Character.valueOf('X'));
            }
            recipe.set(position, Character.valueOf(!me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(material, "AIR") ? character : (char)'X'));
            itemMap.setRecipe(recipe);
            itemMap.setIngredients(ingredients);
            Menu.recipePane(player, itemMap);
        }
    }

    private static void bannerPane(Player player, ItemMap itemMap) {
        Interface bannerPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            bannerPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            for (PatternType pattern : ItemHandler.getPatterns()) {
                String checkPattern;
                String patternString = "NONE";
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getBannerPatterns().toString()).equals("NONE")) {
                    for (Pattern patterns : itemMap.getBannerPatterns()) {
                        if (patterns.getPattern() != pattern) continue;
                        patternString = patterns.getColor() + ":" + ItemHandler.getPatternName(patterns);
                        break;
                    }
                }
                bannerPane.addButton(new Button(ItemHandler.getItem("PAPER", 1, !(checkPattern = patternString).equals("NONE"), false, "&f" + ItemHandler.getPatternName(pattern), "&7", "&7*Click to add this as", "&7a banner pattern.", !checkPattern.equals("NONE") ? "&9&lInformation: &a" + checkPattern : ""), event -> {
                    if (!checkPattern.equals("NONE")) {
                        List<Pattern> patternList = itemMap.getBannerPatterns();
                        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getBannerPatterns().toString()).equals("NONE")) {
                            for (Pattern patterns : patternList) {
                                if (patterns.getPattern() != pattern) continue;
                                patternList.remove(patterns);
                                itemMap.setBannerPatterns(patternList);
                                break;
                            }
                        }
                        Menu.bannerPane(player, itemMap);
                    } else {
                        Menu.patternPane(player, itemMap, pattern);
                    }
                }));
            }
        });
        bannerPane.open(player);
    }

    private static void patternPane(Player player, ItemMap itemMap, PatternType pattern) {
        Interface colorPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            colorPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the banner patterns menu."), event -> Menu.bannerPane(player, itemMap)));
            for (DyeColor color : DyeColor.values()) {
                colorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? color.name() + "_DYE" : "351:8", 1, false, false, "&f" + color.name(), "&7", "&7*This will be the color", "&7of your banner pattern."), event -> {
                    List<Pattern> patterns = itemMap.getBannerPatterns();
                    patterns.add(new Pattern(color, pattern));
                    itemMap.setBannerPatterns(patterns);
                    Menu.bannerPane(player, itemMap);
                }));
            }
        });
        colorPane.open(player);
    }

    private static void potionPane(Player player, ItemMap itemMap, int stage) {
        Interface potionPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage != 1) {
                potionPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            } else {
                potionPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the other settings menu."), event -> Menu.otherPane(player, itemMap)));
            }
            for (PotionEffectType potion : CompatUtils.values(PotionEffectType.class)) {
                String checkPotion;
                if (potion == null) continue;
                String potionString = "NONE";
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
                    for (PotionEffect potions : itemMap.getPotionEffect()) {
                        if (potions.getType() != potion) continue;
                        potionString = CompatUtils.getName(potions) + ":" + potions.getAmplifier() + ":" + potions.getDuration();
                        break;
                    }
                }
                potionPane.addButton(new Button(ItemHandler.getItem(!(checkPotion = potionString).equals("NONE") ? "POTION" : "GLASS_BOTTLE", 1, !checkPotion.equals("NONE"), true, "&f" + CompatUtils.getName(potion), "&7", "&7*Add this potion effect", "&7to the item.", !checkPotion.equals("NONE") ? "&9&lInformation: &a" + checkPotion : ""), event -> {
                    if (!checkPotion.equals("NONE")) {
                        List<PotionEffect> potionEffects = itemMap.getPotionEffect();
                        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
                            for (PotionEffect potions : potionEffects) {
                                if (potions.getType() != potion) continue;
                                potionEffects.remove(potions);
                                itemMap.setPotionEffect(potionEffects);
                                break;
                            }
                        }
                        Menu.potionPane(player, itemMap, stage);
                    } else {
                        Menu.levelPane(player, itemMap, potion, stage);
                    }
                }));
            }
        });
        potionPane.open(player);
    }

    private static void teleportPane(Player player, ItemMap itemMap, int stage) {
        Interface teleportPane = new Interface(false, 1, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (stage == 1) {
                teleportPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the other settings menu."), event -> {
                    Menu.setItemFlags(itemMap);
                    Menu.otherPane(player, itemMap);
                }));
            } else {
                teleportPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> {
                    Menu.setItemFlags(itemMap);
                    Menu.creatingPane(player, itemMap);
                }));
            }
            teleportPane.addButton(new Button(fillerPaneGItem), 2);
            teleportPane.addButton(new Button(ItemHandler.getItem("BLAZE_POWDER", 1, false, false, "&b&lTeleport Effect", "&7", "&7*The effect to play at the", "&7arrow landed location when", "&7the player is teleported.", "&9&lTeleport-Effect: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTeleportEffect())), event -> Menu.particlePane(player, itemMap, stage)));
            teleportPane.addButton(new Button(ItemHandler.getItem("ENDER_PEARL", 1, itemMap.isTeleport(), false, "&a&l&nTeleport", "&7", "&a&lTrue&f: &7Teleports the Player to the location", "&7that the arrow landed.", "&cNOTE: &7This only works if the arrow is fired by a Bow.", "&9&lENABLED: &a" + String.valueOf(itemMap.isTeleport()).toUpperCase()), event -> {
                itemMap.setTeleport(!itemMap.isTeleport());
                Menu.teleportPane(player, itemMap, stage);
            }));
            teleportPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "MUSIC_DISC_MELLOHI" : "2262", 1, false, false, "&a&lTeleport Sound", "&7", "&7*The sound to play at the", "&7arrow landed location when", "&7the player is teleported.", "&9&lTeleport-Sound: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTeleportSound()), "&9&lVolume: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTeleportSound()).equals("NONE") ? itemMap.getTeleportVolume() : "NONE"), "&9&lPitch: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTeleportSound()).equals("NONE") ? itemMap.getTeleportPitch() : "NONE")), event -> {
                Menu.soundPane(player, itemMap, stage);
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTeleportSound()).equals("NONE")) {
                    itemMap.setTeleportSound(null);
                    Menu.teleportPane(player, itemMap, stage);
                } else {
                    Menu.soundPane(player, itemMap, stage);
                }
            }));
            teleportPane.addButton(new Button(fillerPaneGItem), 2);
            if (stage == 1) {
                teleportPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the other settings menu."), event -> {
                    Menu.setItemFlags(itemMap);
                    Menu.otherPane(player, itemMap);
                }));
            } else {
                teleportPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> {
                    Menu.setItemFlags(itemMap);
                    Menu.creatingPane(player, itemMap);
                }));
            }
        });
        teleportPane.open(player);
    }

    private static void levelPane(Player player, ItemMap itemMap, PotionEffectType potion, int stage) {
        Interface levelPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            levelPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the potion effect menu."), event -> Menu.potionPane(player, itemMap, stage)));
            levelPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Level", "&7", "&7*Click to set a custom level (strength)", "&7value for the potion effect.", "&7", "&c&lNote: &7Any duration LONGER than", "&71800 seconds (30 minutes) will", "&7result in an infinite duration."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "EFFECT LEVEL").with(PlaceHolder.Holder.INPUT_EXAMPLE, "16");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "EFFECT LEVEL");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.durationPane(event.getPlayer(), itemMap, potion, Integer.parseInt(ChatColor.stripColor((String)event.getMessage())), stage);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.levelPane(event.getPlayer(), itemMap, potion, stage);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                levelPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:6", k, false, false, "&d&lLevel: &a&l" + k, "&7", "&7*Click to set the", "&7level (strength) of the potion effect."), event -> {
                    itemMap.setInteractCooldown(k);
                    Menu.durationPane(player, itemMap, potion, k, stage);
                }));
            }
        });
        levelPane.open(player);
    }

    private static void durationPane(Player player, ItemMap itemMap, PotionEffectType potion, int level, int stage) {
        Interface durationPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            durationPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the potion effect menu."), event -> Menu.potionPane(player, itemMap, stage)));
            durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Duration", "&7", "&7*Click to set a custom duration", "&7value for the potion effect."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "EFFECT DURATION").with(PlaceHolder.Holder.INPUT_EXAMPLE, "110");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "EFFECT DURATION");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.potionPane(event.getPlayer(), itemMap, stage);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                    Menu.durationPane(event.getPlayer(), itemMap, potion, level, stage);
                }
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                durationPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lDuration: &a&l" + k + " Second(s)", "&7", "&7*Click to set the", "&7duration of the potion effect."), event -> {
                    List<PotionEffect> effects = itemMap.getPotionEffect();
                    effects.add(new PotionEffect(potion, k, level));
                    itemMap.setPotionEffect(effects);
                    Menu.potionPane(player, itemMap, stage);
                }));
            }
        });
        durationPane.open(player);
    }

    private static void powerPane(Player player, ItemMap itemMap) {
        Interface powerPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            powerPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the special settings menu."), event -> Menu.otherPane(player, itemMap)));
            powerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Power", "&7", "&7*Click to set a custom power", "&7value for the firework."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIREWORK POWER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "96");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    itemMap.setFireworkPower(Integer.parseInt(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "FIREWORK POWER");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.otherPane(player, itemMap);
            }));
            for (int i = 1; i <= 64; ++i) {
                int k = i;
                powerPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "BLUE_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:11", k, false, false, "&9&lPower Level: &a&l" + k, "&7", "&7*Click to set the", "&7power level of the firework."), event -> {
                    itemMap.setFireworkPower(k);
                    Menu.otherPane(player, itemMap);
                }));
            }
        });
        powerPane.open(player);
    }

    private static void colorPane(Player player, ItemMap itemMap, int type) {
        Interface colorPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            colorPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the " + (type == 0 ? "special settings" : "model components") + " menu."), event -> {
                if (type == 0) {
                    Menu.otherPane(player, itemMap);
                } else {
                    Menu.modelComponentsPane(player, itemMap);
                }
            }));
            for (DyeColor color : DyeColor.values()) {
                colorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? color.name() + "_DYE" : "351:8", 1, me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(type == 0 ? itemMap.getFireworkColor() : (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(1) != null ? Arrays.asList(itemMap.getModelComponents().get(1).replaceAll("\\s*,\\s*", ",").split(",")) : new ArrayList()), color.name()), false, "&f" + color.name(), "&7", "&7*This will be the color", "&7of your " + (type == 0 ? "firework charge" : "model components") + ".", "&9&lENABLED: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(type == 0 ? itemMap.getFireworkColor() : (itemMap.getModelComponents() != null && itemMap.getModelComponents().get(1) != null ? Arrays.asList(itemMap.getModelComponents().get(1).replaceAll("\\s*,\\s*", ",").split(",")) : new ArrayList()), color.name()) + "").toUpperCase()), event -> {
                    ArrayList<DyeColor> colors;
                    ArrayList<DyeColor> arrayList = colors = type == 0 ? itemMap.getFireworkColor() : new ArrayList<DyeColor>();
                    if (type == 1 && itemMap.getModelComponents() != null && itemMap.getModelComponents().get(1) != null) {
                        for (String _color : itemMap.getModelComponents().get(1).replaceAll("\\s*,\\s*", ",").split(",")) {
                            try {
                                colors.add(DyeColor.valueOf((String)me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(_color, player, new PlaceHolder[0]).toUpperCase()));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                    if (type == 0 && me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getFireworkColor().toString(), color.name()) || type == 1 && colors.contains(color)) {
                        colors.remove(color);
                    } else {
                        colors.add(color);
                        if (type == 0) {
                            itemMap.setFireworkColor(colors);
                        } else {
                            List<String> modelComponents = itemMap.getModelComponents() != null ? itemMap.getModelComponents() : Arrays.asList(null, null, null, null);
                            modelComponents.set(1, colors.stream().map(Enum::name).collect(Collectors.joining(", ")));
                            itemMap.setModelComponents(modelComponents);
                        }
                    }
                    Menu.colorPane(player, itemMap, type);
                }));
            }
        });
        colorPane.open(player);
    }

    private static void designPane(Player player, ItemMap itemMap) {
        Interface designPane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            designPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the special settings menu."), event -> Menu.otherPane(player, itemMap)));
            for (FireworkEffect.Type type : FireworkEffect.Type.values()) {
                designPane.addButton(new Button(ItemHandler.getItem("EGG", 1, false, false, "&f" + type.name(), "&7", "&7*This will be the type (pattern)", "&7of your firework."), event -> {
                    itemMap.setFireworkType(type);
                    Menu.otherPane(player, itemMap);
                }));
            }
        });
        designPane.open(player);
    }

    private static void pagePane(Player player, ItemMap itemMap) {
        Interface pagePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            pagePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the special settings menu."), event -> Menu.otherPane(player, itemMap)));
            pagePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&l&nNew Page", "&7", "&7*Add a new page to the book."), event -> Menu.linePane(player, itemMap, true, itemMap.getListPages().size())));
            for (int i = 1; i <= itemMap.getListPages().size(); ++i) {
                int k = i;
                pagePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&b&lPage " + i, "&7", "&7*Click to modify the contents", "&7of this book page."), event -> Menu.linePane(player, itemMap, false, k - 1)));
            }
        });
        pagePane.open(player);
    }

    private static void linePane(Player player, ItemMap itemMap, boolean isNew, int page) {
        Interface linePane = new Interface(true, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            List<List<String>> pages = itemMap.getListPages();
            linePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the book pages menu."), event -> Menu.pagePane(player, itemMap)));
            if (isNew) {
                linePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&l&nNew Line", "&7", "&7*Add a new line to the book page.", "&7", "&9&lPage: &a" + (page + 1)), event -> {
                    player.closeInventory();
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&eWelcome to the Server!");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                }, event -> {
                    ArrayList<String> newPage = new ArrayList<String>();
                    newPage.add(ChatColor.stripColor((String)event.getMessage()));
                    pages.add(newPage);
                    itemMap.setListPages(pages);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.linePane(event.getPlayer(), itemMap, false, page);
                }));
            } else {
                List<String> selectPage = pages.get(page);
                linePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this page from the book.", "&7", "&9&lPage: &a" + (page + 1)), event -> {
                    pages.remove(page);
                    itemMap.setListPages(pages);
                    Menu.pagePane(player, itemMap);
                }));
                if (selectPage.size() < 14) {
                    linePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, true, false, "&e&l&nNew Line", "&7", "&7*Add a new line to the book page.", "&7", "&9&lLine: &a" + (selectPage.size() + 1) + "    &9&lPage: &a" + (page + 1)), event -> {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&eWelcome to the Server!");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }, event -> {
                        selectPage.add(ChatColor.stripColor((String)event.getMessage()));
                        pages.set(page, selectPage);
                        itemMap.setListPages(pages);
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                        Menu.linePane(event.getPlayer(), itemMap, false, page);
                    }));
                }
                int i = 1;
                while (i <= selectPage.size()) {
                    int k = i++;
                    linePane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&f" + selectPage.get(k - 1), "&7", "&7*Click to modify or delete", "&7this line in the book page.", "&7", "&9&lLine: &a" + k + "    &9&lPage: &a" + (page + 1)), event -> Menu.modifyPagesPane(player, itemMap, k - 1, page)));
                }
            }
        });
        linePane.open(player);
    }

    private static void modifyPagesPane(Player player, ItemMap itemMap, int line, int page) {
        Interface linePane = new Interface(false, 2, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            List<List<String>> pages = itemMap.getListPages();
            List<String> selectPage = pages.get(page);
            linePane.addButton(new Button(fillerPaneGItem), 3);
            linePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, false, false, "&c&l&nModify", "&7", "&7*Modify this line in the page.", "&7", "&9&lLine: &a" + (line + 1) + "    &9&lPage: &a" + (page + 1)), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "&eWelcome to the Server!");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                selectPage.set(line, ChatColor.stripColor((String)event.getMessage()));
                pages.set(page, selectPage);
                itemMap.setListPages(pages);
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "PAGE LINE");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                Menu.linePane(event.getPlayer(), itemMap, false, page);
            }));
            linePane.addButton(new Button(fillerPaneGItem));
            linePane.addButton(new Button(ItemHandler.getItem("REDSTONE", 1, false, false, "&c&l&nDelete", "&7", "&7*Delete this line in the page.", "&7", "&9&lLine: &a" + (line + 1) + "    &9&lPage: &a" + (page + 1)), event -> {
                selectPage.remove(selectPage.get(line));
                pages.set(page, selectPage);
                itemMap.setListPages(pages);
                Menu.linePane(player, itemMap, false, page);
            }));
            linePane.addButton(new Button(fillerPaneGItem), 3);
            linePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the book lines menu."), event -> Menu.linePane(player, itemMap, false, page)));
            linePane.addButton(new Button(fillerPaneBItem), 7);
            linePane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the book lines menu."), event -> Menu.linePane(player, itemMap, false, page)));
        });
        linePane.open(player);
    }

    private static void attributePane(Player player, ItemMap itemMap, boolean isLeather) {
        Interface attributePane = new Interface(true, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            if (isLeather) {
                attributePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the other settings menu."), event -> Menu.otherPane(player, itemMap)));
            } else {
                attributePane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            }
            if (ServerUtils.hasSpecificUpdate("1_9")) {
                for (Attribute attribute : CompatUtils.values(Attribute.class)) {
                    String checkAttribute = itemMap.getAttributes().containsKey(CompatUtils.getName(attribute)) ? CompatUtils.getName(attribute) + ":" + itemMap.getAttributes().get(CompatUtils.getName(attribute)) : "NONE";
                    attributePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, itemMap.getAttributes().containsKey(CompatUtils.getName(attribute)), false, "&f" + CompatUtils.getName(attribute), "&7", "&7*Add this custom attribute to the item.", !checkAttribute.equals("NONE") ? "&9&lInformation: &a" + checkAttribute : ""), event -> {
                        if (itemMap.getAttributes().containsKey(CompatUtils.getName(attribute))) {
                            Map<String, Double> attributeList = itemMap.getAttributes();
                            attributeList.remove(CompatUtils.getName(attribute));
                            Menu.attributePane(player, itemMap, isLeather);
                        } else {
                            Menu.strengthPane(player, itemMap, CompatUtils.getName(attribute), isLeather);
                        }
                    }));
                }
            } else {
                String[] attributes;
                for (String attribute : attributes = new String[]{"GENERIC_ATTACK_DAMAGE", "GENERIC_FOLLOW_RANGE", "GENERIC_MAX_HEALTH", "GENERIC_MOVEMENT_SPEED"}) {
                    String checkAttribute = itemMap.getAttributes().containsKey(attribute) ? attribute + ":" + itemMap.getAttributes().get(attribute) : "NONE";
                    attributePane.addButton(new Button(ItemHandler.getItem("NAME_TAG", 1, itemMap.getAttributes().containsKey(attribute), false, "&f" + attribute, "&7", "&7*Add this custom attribute to the item.", !checkAttribute.equals("NONE") ? "&9&lInformation: &a" + checkAttribute : ""), event -> {
                        if (itemMap.getAttributes().containsKey(attribute)) {
                            Map<String, Double> attributeList = itemMap.getAttributes();
                            attributeList.remove(attribute);
                            Menu.attributePane(player, itemMap, isLeather);
                        } else {
                            Menu.strengthPane(player, itemMap, attribute, isLeather);
                        }
                    }));
                }
            }
        });
        attributePane.open(player);
    }

    private static void strengthPane(Player player, ItemMap itemMap, String attribute, boolean isLeather) {
        Interface strengthPane = new Interface(true, 6, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            strengthPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the custom attributes menu."), event -> Menu.attributePane(player, itemMap, isLeather)));
            strengthPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:4", 1, false, false, "&e&lCustom Strength", "&7", "&7*Click to set a custom strength", "&7value for the custom attribute."), event -> {
                player.closeInventory();
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "STRENGTH").with(PlaceHolder.Holder.INPUT_EXAMPLE, "14.0");
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
            }, event -> {
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0])) || me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(ChatColor.stripColor((String)event.getMessage()), player, new PlaceHolder[0]))) {
                    Map<String, Double> attributeList = itemMap.getAttributes();
                    attributeList.put(attribute, Double.parseDouble(ChatColor.stripColor((String)event.getMessage())));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "STRENGTH");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, ChatColor.stripColor((String)event.getMessage()));
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.noInteger", (CommandSender)player, placeHolders);
                }
                Menu.attributePane(event.getPlayer(), itemMap, isLeather);
            }));
            for (double i = 1.0; i < 90.0; i += 1.0) {
                double k = i;
                strengthPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "PINK_STAINED_GLASS_PANE" : "STAINED_GLASS_PANE:6", 1, false, false, "&9&lStrength: &a&l" + k, "&7", "&7*Click to set the strength", "&7 of the custom attribute."), event -> {
                    Map<String, Double> attributeList = itemMap.getAttributes();
                    attributeList.put(attribute, k);
                    Menu.attributePane(player, itemMap, isLeather);
                }));
            }
        });
        strengthPane.open(player);
    }

    private static void otherPane(Player player, ItemMap itemMap) {
        Interface otherPane = new Interface(false, 3, exitButton, GUIName, player);
        SchedulerUtils.runAsync(() -> {
            otherPane.addButton(new Button(fillerPaneGItem), 4);
            otherPane.addButton(new Button(Menu.headerStack(player, itemMap)));
            otherPane.addButton(new Button(fillerPaneGItem), 4);
            if (itemMap.getMaterial().toString().contains("WRITTEN_BOOK")) {
                otherPane.addButton(new Button(fillerPaneGItem), 3);
                otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&e&lPages", "&7", "&7*Define custom pages for the book.", "&9&lPages: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPages() + "").equals("NONE") ? "YES" : "NONE")), event -> Menu.pagePane(player, itemMap)));
                otherPane.addButton(new Button(fillerPaneGItem));
                otherPane.addButton(new Button(ItemHandler.getItem("FEATHER", 1, false, false, "&a&lAuthor", "&7", "&7*Define the author of the book.", "&9&lAuthor: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAuthor())), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAuthor()).equals("NONE")) {
                        itemMap.setAuthor(null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "AUTHOR").with(PlaceHolder.Holder.INPUT_EXAMPLE, "RockinChaos");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }
                }, event -> {
                    itemMap.setAuthor(ChatColor.stripColor((String)event.getMessage()));
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "AUTHOR");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.otherPane(event.getPlayer(), itemMap);
                }));
                otherPane.addButton(new Button(fillerPaneGItem), 3);
            } else if (itemMap.getMaterial().toString().contains("PLAYER_HEAD") || itemMap.getMaterial().toString().contains("SKULL_ITEM")) {
                StringBuilder potionList = new StringBuilder();
                StringBuilder potionString = new StringBuilder();
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
                    for (PotionEffect potions : itemMap.getPotionEffect()) {
                        potionString.append(CompatUtils.getName(potions)).append(":").append(potions.getAmplifier()).append(":").append(potions.getDuration()).append(", ");
                    }
                    for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionString.toString()))) {
                        potionList.append("&a").append(split).append(" /n ");
                    }
                }
                otherPane.addButton(new Button(fillerPaneGItem), 2);
                otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "GOLDEN_HELMET" : "314", 1, false, false, "&b&lSkull Owner", "&7", "&7*Define a skull owner for the", "&7head adding that persons skin.", "&7", "&7You can only define skull owner", "&7or skull texture, this will", "&7remove any skull textures.", "&9&lSkull-Owner: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkull())), event -> {
                    if (itemMap.getDynamicOwners() != null && !itemMap.getDynamicOwners().isEmpty()) {
                        Menu.animatedSkullPane(player, itemMap, true);
                    } else if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkull()).equals("NONE")) {
                        itemMap.setSkull((String)null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER").with(PlaceHolder.Holder.INPUT_EXAMPLE, "RockinChaos");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }
                }, event -> {
                    itemMap.setSkull(ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setSkullTexture(null);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL OWNER");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.otherPane(event.getPlayer(), itemMap);
                }));
                otherPane.addButton(new Button(fillerPaneGItem));
                String[] stringArray = new String[13];
                stringArray[0] = "&7";
                stringArray[1] = "&7*Add a skull texture for the";
                stringArray[2] = "&7head as a custom skin.";
                stringArray[3] = "&7";
                stringArray[4] = "&7You can only define skull texture";
                stringArray[5] = "&7or skull owner, this will";
                stringArray[6] = "&7remove any skull owners.";
                stringArray[7] = "&7";
                stringArray[8] = "&7Skull textures can be found";
                stringArray[9] = "&7at websites like&a minecraft-heads.com";
                stringArray[10] = "&7and the value is listed under";
                stringArray[11] = "&7the OTHER section.";
                stringArray[12] = "&9&lSkull-Texture: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkullTexture()).equals("NONE") ? (itemMap.getSkullTexture().length() > 40 ? itemMap.getSkullTexture().substring(0, 40) : itemMap.getSkullTexture()) : "");
                otherPane.addButton(new Button(ItemHandler.getItem("STRING", 1, false, false, "&a&lSkull Texture", stringArray), event -> {
                    if (itemMap.getDynamicTextures() != null && !itemMap.getDynamicTextures().isEmpty()) {
                        Menu.animatedSkullPane(player, itemMap, false);
                    } else if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkullTexture()).equals("NONE")) {
                        itemMap.setSkullTexture(null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE").with(PlaceHolder.Holder.INPUT_EXAMPLE, "eyJ0ZXh0dYMGQVlN2FjZmU3OSJ9fX0=");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }
                }, event -> {
                    itemMap.setSkullTexture(ChatColor.stripColor((String)event.getMessage()));
                    itemMap.setSkull((String)null);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "SKULL TEXTURE");
                    ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                    Menu.otherPane(event.getPlayer(), itemMap);
                }));
                otherPane.addButton(new Button(fillerPaneGItem));
                otherPane.addButton(new Button(ItemHandler.getItem("POTION", 1, false, false, "&e&lEffects", "&7", "&7*Add custom effects after", "&7consuming the item.", "&9&lPotion-Effects: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionList.toString())), event -> Menu.potionPane(player, itemMap, 1)));
                otherPane.addButton(new Button(fillerPaneGItem), 2);
            } else if (itemMap.getMaterial().toString().contains("TIPPED_ARROW")) {
                StringBuilder potionList = new StringBuilder();
                StringBuilder potionString = new StringBuilder();
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
                    for (PotionEffect potions : itemMap.getPotionEffect()) {
                        potionString.append(CompatUtils.getName(potions)).append(":").append(potions.getAmplifier()).append(":").append(potions.getDuration()).append(", ");
                    }
                    for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionString.substring(0, potionString.length())))) {
                        potionList.append("&a").append(split).append(" /n ");
                    }
                }
                otherPane.addButton(new Button(fillerPaneGItem), 3);
                otherPane.addButton(new Button(ItemHandler.getItem("BLAZE_POWDER", 1, false, false, "&e&lEffects", "&7", "&7*Add custom effects", "&7to the arrow tip.", "&9&lTipped-Effect: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionList.toString())), event -> Menu.potionPane(player, itemMap, 1)));
                otherPane.addButton(new Button(fillerPaneGItem));
                otherPane.addButton(new Button(ItemHandler.getItem("ENDER_PEARL", 1, false, false, "&e&lTeleport", "&7", "&7*Set the arrow to teleport", "&7the player upon landing.", "&9&lEnabled: &a" + String.valueOf(itemMap.isTeleport()).toUpperCase()), event -> Menu.teleportPane(player, itemMap, 1)));
                otherPane.addButton(new Button(fillerPaneGItem), 3);
            } else if (itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_ROCKET")) {
                StringBuilder colorList = new StringBuilder();
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkColor().toString()).equals("NONE")) {
                    for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkColor().toString()))) {
                        colorList.append("&a").append(split).append(" /n ");
                    }
                }
                otherPane.addButton(new Button(fillerPaneGItem), 2);
                otherPane.addButton(new Button(ItemHandler.getItem("EGG", 1, false, false, "&a&lType", "&7", "&7*Set the style of the explosion.", "&9&lType: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkType() + "")), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkType() + "").equals("NONE")) {
                        itemMap.setFireworkType(null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        Menu.designPane(player, itemMap);
                    }
                }));
                otherPane.addButton(new Button(ItemHandler.getItem("DIAMOND", 1, itemMap.getFireworkFlicker(), false, "&a&lFlicker", "&7", "&7*Show the flicker effect as", "&7the firework particles dissipate", "&7after the explosion.", "&9&lENABLED: &a" + itemMap.getFireworkFlicker()), event -> {
                    itemMap.setFireworkFlicker(!itemMap.getFireworkFlicker());
                    Menu.otherPane(player, itemMap);
                }));
                otherPane.addButton(new Button(ItemHandler.getItem("EMERALD", 1, itemMap.getFireworkTrail(), false, "&a&lTrail", "&7", "&7*Show the trail (smoke) of", "&7the firework when launched.", "&9&lENABLED: &a" + itemMap.getFireworkTrail()), event -> {
                    itemMap.setFireworkTrail(!itemMap.getFireworkTrail());
                    Menu.otherPane(player, itemMap);
                }));
                otherPane.addButton(new Button(ItemHandler.getItem("SUGAR", 1, false, false, "&a&lPower", "&7", "&7*Set the power (distance)", "&7that the firework travels.", "&9&lPower: &a" + me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkPower() + "&7")), event -> {
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkPower() + "&7").equals("NONE")) {
                        itemMap.setFireworkPower(0);
                        Menu.otherPane(player, itemMap);
                    } else {
                        Menu.powerPane(player, itemMap);
                    }
                }));
                otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "LIME_DYE" : "351:10", 1, false, false, "&a&lColor(s)", "&7", "&7*Define the individual colors of the", "&7firework effect type.", "&9&lColor(s): &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(colorList.toString()).equals("NONE") ? colorList.toString() : "NONE")), event -> Menu.colorPane(player, itemMap, 0)));
                otherPane.addButton(new Button(fillerPaneGItem), 2);
            } else if (itemMap.getMaterial().toString().contains("LEATHER_") && (ServerUtils.hasSpecificUpdate("1_14") || !itemMap.getMaterial().toString().equalsIgnoreCase("LEATHER_HORSE_ARMOR"))) {
                Interface colorPane = new Interface(true, 6, exitButton, GUIName, player);
                colorPane.setReturnButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the special settings menu."), event -> Menu.otherPane(player, itemMap)));
                for (DyeColor color : DyeColor.values()) {
                    colorPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? color.name() + "_DYE" : "351:8", 1, false, false, "&f" + color.name(), "&7", "&7*This will be the color", "&7of your leather armor."), event -> {
                        itemMap.setLeatherColor(color.name());
                        itemMap.setLeatherHex(null);
                        Menu.otherPane(player, itemMap);
                    }));
                }
                otherPane.addButton(new Button(fillerPaneGItem), 3);
                otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "YELLOW_DYE" : "351:11", 1, false, false, "&a&lDye", "&7", "&7*Add a custom color to", "&7your leather armor.", "&9&lLeather-Color: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherColor()).equals("NONE") ? me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherColor()) : me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherHex()))), event -> {
                    if (itemMap.getLeatherColor() != null) {
                        itemMap.setLeatherColor(null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        colorPane.open(player);
                    }
                }));
                if (!ItemHandler.getDesignatedSlot(itemMap.getMaterial()).equalsIgnoreCase("noslot")) {
                    StringBuilder attributeList = new StringBuilder();
                    StringBuilder attributeString = new StringBuilder();
                    if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAttributes().toString()).equals("NONE")) {
                        for (String attribute : itemMap.getAttributes().keySet()) {
                            attributeString.append(attribute).append(":").append(itemMap.getAttributes().get(attribute)).append(", ");
                        }
                        for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeString.substring(0, attributeString.length())))) {
                            attributeList.append("&a").append(split).append(" /n ");
                        }
                    }
                    otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "ENCHANTED_GOLDEN_APPLE" : "322:1", 1, false, false, "&a&lAttributes", "&7", "&7*Add a custom attribute to", "&7your armor or weapon.", !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeList.toString()).equals("NONE") ? "&9&lAttributes: &a" + attributeList : ""), event -> Menu.attributePane(player, itemMap, true)));
                } else {
                    otherPane.addButton(new Button(fillerPaneGItem));
                }
                otherPane.addButton(new Button(ItemHandler.getItem(ServerUtils.hasSpecificUpdate("1_13") ? "WRITABLE_BOOK" : "386", 1, false, false, "&a&lHex Color", "&7", "&7*Add a custom hex color", "&7to your leather armor.", "&9&lLeather-Color: &a" + (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherHex()).equals("NONE") ? me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherHex()) : me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherColor()))), event -> {
                    if (itemMap.getLeatherHex() != null) {
                        itemMap.setLeatherHex(null);
                        Menu.otherPane(player, itemMap);
                    } else {
                        player.closeInventory();
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "HEX COLOR").with(PlaceHolder.Holder.INPUT_EXAMPLE, "#033dfc");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputType", (CommandSender)player, placeHolders);
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputExample", (CommandSender)player, placeHolders);
                    }
                }, event -> {
                    if (itemMap.getLeatherHex() == null) {
                        itemMap.setLeatherHex(ChatColor.stripColor((String)event.getMessage()));
                        itemMap.setLeatherColor(null);
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.INPUT, "HEX COLOR");
                        ItemJoin.getCore().getLang().sendLangMessage("commands.menu.inputSet", (CommandSender)player, placeHolders);
                        Menu.otherPane(event.getPlayer(), itemMap);
                    }
                }));
                otherPane.addButton(new Button(fillerPaneGItem), 3);
            }
            otherPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
            otherPane.addButton(new Button(fillerPaneBItem), 7);
            otherPane.addButton(new Button(ItemHandler.getItem("BARRIER", 1, false, false, "&c&l&nReturn", "&7", "&7*Returns you to the item definition menu."), event -> Menu.creatingPane(player, itemMap)));
        });
        otherPane.open(player);
    }

    /*
     * WARNING - void declaration
     */
    private static ItemStack headerStack(Player player, ItemMap itemMap) {
        ItemMeta itemMeta;
        StringBuilder slotList = new StringBuilder();
        StringBuilder slotString = new StringBuilder();
        itemMap.renderItemStack();
        ItemStack item = new ItemStack(Material.STONE);
        String itemMaterial = ItemHandler.getMaterialName(itemMap.getTempItem());
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getMultipleSlots().toString()).equals("NONE")) {
            for (String slot : itemMap.getMultipleSlots()) {
                slotString.append(slot).append(", ");
            }
            if (slotString.length() >= 2) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(slotString.substring(0, slotString.length() - 2)))) {
                    slotList.append("&a").append(split).append(" /n ");
                }
            }
        }
        StringBuilder itemflagsList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemFlags()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(itemMap.getItemFlags())) {
                itemflagsList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder triggersList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggers()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(itemMap.getTriggers())) {
                triggersList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder disabledList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()))) {
                disabledList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder enabledList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()))) {
                enabledList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder enabledRegionList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()))) {
                enabledRegionList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder disabledRegionList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()))) {
                disabledRegionList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder enchantList = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()).equals("NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()))) {
                enchantList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder potionList = new StringBuilder();
        StringBuilder potionString = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPotionEffect().toString()).equals("NONE")) {
            for (PotionEffect potions : itemMap.getPotionEffect()) {
                potionString.append(CompatUtils.getName(potions)).append(":").append(potions.getAmplifier()).append(":").append(potions.getDuration()).append(", ");
            }
            if (potionString.length() >= 2) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionString.substring(0, potionString.length() - 2)))) {
                    potionList.append("&a").append(split).append(" /n ");
                }
            }
        }
        StringBuilder attributeList = new StringBuilder();
        StringBuilder attributeString = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAttributes().toString()).equals("NONE")) {
            for (String attribute : itemMap.getAttributes().keySet()) {
                attributeString.append(attribute).append(":").append(itemMap.getAttributes().get(attribute)).append(", ");
            }
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeString.toString()))) {
                attributeList.append("&a").append(split).append(" /n ");
            }
        }
        StringBuilder patternList = new StringBuilder();
        StringBuilder patternString = new StringBuilder();
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getBannerPatterns().toString()).equals("NONE")) {
            for (Pattern patterns : itemMap.getBannerPatterns()) {
                patternString.append(patterns.getColor()).append(":").append(ItemHandler.getPatternName(patterns)).append(", ");
            }
            if (patternString.length() >= 2) {
                for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(patternString.substring(0, patternString.length() - 2)))) {
                    patternList.append("&a").append(split).append(" /n ");
                }
            }
        }
        StringBuilder colorList = new StringBuilder();
        if (!Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkColor().toString()), "NONE")) {
            for (String split : me.RockinChaos.itemjoin.core.utils.StringUtils.softSplit(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkColor().toString()))) {
                colorList.append("&a").append(split).append(" /n ");
            }
        }
        boolean useCommands = true;
        if (itemMap.getCommands().length > 0) {
            for (ItemCommand itemCommand : itemMap.getCommands()) {
                if (!itemCommand.getRawCommand().equalsIgnoreCase("default: ")) continue;
                useCommands = false;
            }
        } else if (itemMap.getCommands().length <= 0) {
            useCommands = false;
        }
        boolean useToggle = itemMap.getToggleCommands() != null && !itemMap.getToggleCommands().isEmpty();
        StringBuilder mobs = new StringBuilder();
        for (EntityType entityType : itemMap.getMobsDrop().keySet()) {
            mobs.append(entityType.name()).append(", ");
        }
        StringBuilder blocks = new StringBuilder();
        for (Material material : itemMap.getBlocksDrop().keySet()) {
            blocks.append(material.name()).append(", ");
        }
        String string = "";
        if (ServerUtils.hasSpecificUpdate("1_20") && ItemHandler.isArmor(itemMap.getMaterial().toString()) && itemMap.getTrimPattern() != null && !itemMap.getTrimPattern().isEmpty()) {
            Map.Entry<String, String> entry = itemMap.getTrimPattern().entrySet().iterator().next();
            String string2 = entry.getKey() + ":" + entry.getValue();
        }
        try {
            void var24_79;
            String[] stringArray = new String[62];
            stringArray[0] = "&7";
            stringArray[1] = "&9&lNode: &a" + itemMap.getConfigName();
            stringArray[2] = "&9&lMaterial: &a" + itemMap.getMaterial().toString() + (itemMap.getDataValue() != null && itemMap.getDataValue() != 0 ? ":" + itemMap.getDataValue() : "");
            stringArray[3] = itemMap.getMultipleSlots() != null && !itemMap.getMultipleSlots().isEmpty() ? "&9&lSlot(s): &a" + slotList : "&9&lSlot: &a" + itemMap.getSlot().toUpperCase();
            stringArray[4] = itemMap.getCount(player) != 1 && itemMap.getCount(player) != 0 ? "&9&lCount: &a" + itemMap.getCount(player) : "";
            String string3 = stringArray[5] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomName()).equals("NONE") && !itemMaterial.equalsIgnoreCase(itemMap.getCustomName()) ? "&9&lName: &a" + itemMap.getCustomName() : "";
            stringArray[6] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomLore().toString()), "NONE") ? "&9&lLore: &a" + (me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomLore().toString()).replace(",,", ",").replace(", ,", ",").length() > 40 ? me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomLore().toString()).replace(",,", ",").replace(", ,", ",").substring(0, 40) : me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCustomLore().toString()).replace(",,", ",").replace(", ,", ",")) : "";
            stringArray[7] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDurability() + "&7").equals("NONE") ? "&9&lDurability: &a" + itemMap.getDurability() : "";
            stringArray[8] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getData() + "&7"), "NONE") ? "&9&lTexture Data: &a" + itemMap.getData() : "";
            stringArray[9] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getModelData() + "&7"), "NONE") ? "&9&LModel Data: &a" + itemMap.getModelData() : "";
            stringArray[10] = itemMap.getModelComponents() != null ? "&9&lModel Components: &aYES" : "";
            stringArray[11] = useCommands ? "&9&lCommands: &aYES" : "";
            stringArray[12] = useToggle ? "&9&lToggleable: &aYES" : "";
            stringArray[13] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemCost()).equals("NONE") ? "&9&lCommands-Item: &a" + itemMap.getItemCost() : "";
            stringArray[14] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getRawCost() + "&7"), "NONE") ? "&9&lCommands-Cost: &a" + itemMap.getRawCost() : "";
            stringArray[15] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandReceive() + "&7").equals("NONE") ? "&9&lCommands-Receive: &a" + itemMap.getCommandReceive() : "";
            stringArray[16] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck((Object)((Object)itemMap.getCommandSequence()) + "").equals("NONE") ? "&9&lCommands-Sequence: &a" + (Object)((Object)itemMap.getCommandSequence()) : "";
            stringArray[17] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandCooldown() + "&7"), "NONE") ? "&9&lCommands-Cooldown: &a" + itemMap.getCommandCooldown() + " second(s)" : "";
            stringArray[18] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCooldownMessage()).equals("NONE") ? "&9&lCooldown-Message: &a" + itemMap.getCooldownMessage() : "";
            stringArray[19] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandSound() + ""), "NONE") ? "&9&lCommands-Sound: &a" + itemMap.getCommandSound() : "";
            stringArray[20] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandParticle()).equals("NONE") ? "&9&lCommands-Particle: &a" + itemMap.getCommandParticle() : "";
            stringArray[21] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnchantments().toString()), "NONE") ? "&9&lEnchantments: &a" + enchantList : "";
            stringArray[22] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getItemFlags()).equals("NONE") ? "&9&lItemflags: &a" + itemflagsList : "";
            stringArray[23] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggers()), "NONE") ? "&9&lTriggers: &a" + triggersList : "";
            stringArray[24] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPermissionNode()).equals("NONE") ? "&9&lPermission Node: &a" + itemMap.getPermissionNode() : "";
            stringArray[25] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledWorlds().toString()).equals("NONE") ? "&9&lDisabled Worlds: &a" + disabledList : "";
            stringArray[26] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledWorlds().toString()), "NONE") ? "&9&lEnabled Worlds: &a" + enabledList : "";
            stringArray[27] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisabledRegions().toString()).equals("NONE") ? "&9&lDisabled Regions: &a" + disabledRegionList : "";
            stringArray[28] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getEnabledRegions().toString()).equals("NONE") ? "&9&lEnabled Regions: &a" + enabledRegionList : "";
            stringArray[29] = !itemMap.getDynamicMaterials().isEmpty() ? "&9&lMaterial Animations: &aYES" : "";
            stringArray[30] = !itemMap.getDynamicNames().isEmpty() ? "&9&lName Animations: &aYES" : "";
            stringArray[31] = !itemMap.getDynamicLores().isEmpty() ? "&9&lLore Animations: &aYES" : "";
            stringArray[32] = !itemMap.getDynamicOwners().isEmpty() || !itemMap.getDynamicTextures().isEmpty() ? "&9&lSkull Animations: &aYES" : "";
            stringArray[33] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLimitModes()), "NONE") ? "&9&lLimit-Modes: &a" + itemMap.getLimitModes() : "";
            stringArray[34] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getProbability() + "&a%").equals("NONE") ? "&9&lProbability: &a" + itemMap.getProbability() + "%" : "";
            stringArray[35] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getInteractCooldown() + "&7").equals("NONE") ? "&9&lUse-Cooldown: &a" + itemMap.getInteractCooldown() : "";
            stringArray[36] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherColor()).equals("NONE") ? "&9&lLeather Color: &a" + itemMap.getLeatherColor() : "";
            stringArray[37] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getLeatherHex()), "NONE") ? "&9&lLeather Color: &a" + itemMap.getLeatherHex() : "";
            stringArray[38] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getMapImage()).equals("NONE") ? "&9&lMap-Image: &a" + itemMap.getMapImage() : "";
            stringArray[39] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getChargeColor() + ""), "NONE") ? "&9&lCharge Color: &a" + itemMap.getChargeColor() : "";
            stringArray[40] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(patternList.toString()).equals("NONE") ? "&9&lBanner Meta: &a" + patternList : "";
            stringArray[41] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck((String)var24_79).equals("NONE") ? "&9&lArmor Meta: &a" + (String)var24_79 : "";
            stringArray[42] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(potionList.toString()), "NONE") ? "&9&lPotion-Effects: &a" + potionList : "";
            stringArray[43] = itemMap.getIngredients() != null && !itemMap.getIngredients().isEmpty() ? "&9&lRecipe: &aYES" : "";
            stringArray[44] = !me.RockinChaos.itemjoin.core.utils.StringUtils.isEmpty(mobs) ? "&9&lMobs Drop: &a" + mobs.substring(0, mobs.length() - 2) : "";
            stringArray[45] = !me.RockinChaos.itemjoin.core.utils.StringUtils.isEmpty(blocks) ? "&9&lBlocks Drop: &a" + blocks.substring(0, blocks.length() - 2) : "";
            stringArray[46] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandConditions() + "").equals("NONE") ? "&9&lCommand Conditions: &aYES" : "";
            stringArray[47] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getCommandPermissions() + "").equals("NONE") ? "&9&lCommand Permissions: &aYES" : "";
            stringArray[48] = !Objects.equals(me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getDisposableConditions() + ""), "NONE") ? "&9&lDisposable Conditions: &aYES" : "";
            stringArray[49] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getTriggerConditions() + "").equals("NONE") ? "&9&lTrigger Conditions: &aYES" : "";
            stringArray[50] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getNBTProperties() + "").equals("NONE") ? "&9&lNBT Properties: &aYES" : "";
            stringArray[51] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getContents() + "").equals("NONE") ? "&9&lContents: &aYES" : "";
            stringArray[52] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(attributeList.toString()).equals("NONE") ? "&9&lAttributes: &a" + attributeList : "";
            stringArray[53] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getPages() + "").equals("NONE") ? "&9&lBook Pages: &aYES" : "";
            stringArray[54] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getAuthor()).equals("NONE") ? "&9&lBook Author: &a" + itemMap.getAuthor() : "";
            String string4 = stringArray[55] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkull()).equals("NONE") ? "&9&lSkull-Owner: &a" + itemMap.getSkull() : "";
            stringArray[56] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getSkullTexture()).equals("NONE") ? "&9&lSkull-Texture: &a" + (itemMap.getSkullTexture().length() > 40 ? itemMap.getSkullTexture().substring(0, 40) : itemMap.getSkullTexture()) : "";
            stringArray[57] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkType() + "").equals("NONE") ? "&9&lFirework Type: &a" + itemMap.getFireworkType().name() : "";
            stringArray[58] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(itemMap.getFireworkPower() + "&7").equals("NONE") ? "&9&lFirework Power: &a" + itemMap.getFireworkPower() : "";
            stringArray[59] = !me.RockinChaos.itemjoin.core.utils.StringUtils.nullCheck(colorList.toString()).equals("NONE") ? "&9&lFirework Color(s): &a" + colorList : "";
            stringArray[60] = itemMap.getFireworkTrail() ? "&9&lFirework Trail: &aENABLED" : "";
            stringArray[61] = itemMap.getFireworkFlicker() ? "&9&lFirework Flicker: &aENABLED" : "";
            item = ItemHandler.getItem(itemMap.getMaterial().toString() + (itemMap.getDataValue() != null && itemMap.getDataValue() != 0 ? ":" + itemMap.getDataValue() : ""), 1, false, true, "&7*&6&l&nItem Information", stringArray);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        if (ServerUtils.hasSpecificUpdate("1_14") && itemMap.getModelData() != null) {
            if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(itemMap.getModelData())) {
                int modelData = Integer.parseInt(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(itemMap.getModelData(), player, new PlaceHolder[0]));
                ItemMeta itemMeta2 = item.getItemMeta();
                if (modelData != 0 && itemMeta2 != null) {
                    itemMeta2.setCustomModelData(Integer.valueOf(modelData));
                    item.setItemMeta(itemMeta2);
                }
            } else if (ServerUtils.hasPreciseUpdate("1_21_3") && (itemMeta = item.getItemMeta()) != null) {
                itemMeta.setItemModel(NamespacedKey.fromString((String)me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(itemMap.getModelData(), player, new PlaceHolder[0])));
                item.setItemMeta(itemMeta);
            }
        } else if (ServerUtils.hasPreciseUpdate("1_21_4") && itemMap.getModelComponents() != null) {
            itemMeta = item.getItemMeta();
            CustomModelDataComponent component = itemMeta.getCustomModelDataComponent();
            if (itemMap.getModelComponents().get(0) != null) {
                ArrayList<String> strings = new ArrayList<String>();
                for (String string5 : itemMap.getModelComponents().get(0).replaceAll("\\s*,\\s*", ",").split(",")) {
                    strings.add(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(string5.trim(), player, new PlaceHolder[0]));
                }
                component.setStrings(strings);
            }
            if (itemMap.getModelComponents().get(1) != null) {
                ArrayList<Color> colors = new ArrayList<Color>();
                for (String color : itemMap.getModelComponents().get(1).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        colors.add(DyeColor.valueOf((String)me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(color, player, new PlaceHolder[0]).toUpperCase()).getColor());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                component.setColors(colors);
            }
            if (itemMap.getModelComponents().get(2) != null) {
                ArrayList<Boolean> flags = new ArrayList<Boolean>();
                for (String bool : itemMap.getModelComponents().get(2).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        flags.add(Boolean.parseBoolean(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(bool, player, new PlaceHolder[0]).trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                component.setFlags(flags);
            }
            if (itemMap.getModelComponents().get(3) != null) {
                ArrayList<Float> floats = new ArrayList<Float>();
                for (String _float : itemMap.getModelComponents().get(3).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        floats.add(Float.valueOf(Float.parseFloat(me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(_float, player, new PlaceHolder[0]).trim())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                component.setFloats(floats);
            }
            itemMeta.setCustomModelDataComponent(component);
            item.setItemMeta(itemMeta);
        }
        if (itemMap.getDurability() != null && (itemMap.getData() == null || itemMap.getData() == 0)) {
            ItemMeta itemMeta3 = item.getItemMeta();
            if (ServerUtils.hasSpecificUpdate("1_13") && itemMeta3 != null) {
                ((Damageable)itemMeta3).setDamage((int)itemMap.getDurability().shortValue());
                item.setItemMeta(itemMeta3);
            } else {
                LegacyAPI.setDurability(item, itemMap.getDurability());
            }
        }
        if (itemMap.getData() != null && itemMap.getData() > 0) {
            ItemMeta itemMeta4 = item.getItemMeta();
            if (ServerUtils.hasSpecificUpdate("1_13") && itemMeta4 != null) {
                ((Damageable)itemMeta4).setDamage(itemMap.getData().intValue());
                item.setItemMeta(itemMeta4);
            } else {
                LegacyAPI.setDurability(item, Short.parseShort(itemMap.getData() + ""));
            }
        }
        if (ItemHandler.isSkull(itemMap.getMaterial())) {
            ItemMeta itemMeta5 = item.getItemMeta();
            if (itemMap.getSkull() != null && itemMeta5 != null) {
                ItemHandler.setSkullOwner(itemMeta5, player, me.RockinChaos.itemjoin.core.utils.StringUtils.translateLayout(itemMap.getSkull(), player, new PlaceHolder[0]));
            } else if (itemMap.getSkullTexture() != null && !itemMap.isHeadDatabase()) {
                try {
                    if (itemMeta5 != null) {
                        UUID uuid = UUID.randomUUID();
                        GameProfile gameProfile = new GameProfile(uuid, uuid.toString().replaceAll("_", "").replaceAll("-", "").substring(0, 16));
                        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", itemMap.getSkullTexture()));
                        Field declaredField = itemMeta5.getClass().getDeclaredField("profile");
                        declaredField.setAccessible(true);
                        declaredField.set(itemMeta5, gameProfile);
                    }
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
            } else if (itemMap.isHeadDatabase() && itemMap.getSkullTexture() != null) {
                HeadDatabaseAPI api = new HeadDatabaseAPI();
                ItemStack sk = api.getItemHead(itemMap.getSkullTexture());
                item = sk != null ? sk : item.clone();
            }
            item.setItemMeta(itemMeta5);
        }
        if (ServerUtils.hasSpecificUpdate("1_20") && ItemHandler.isArmor(itemMap.getMaterial().toString()) && itemMap.getTrimPattern() != null && !itemMap.getTrimPattern().isEmpty()) {
            Map.Entry<String, String> entry = itemMap.getTrimPattern().entrySet().iterator().next();
            ItemHandler.setArmorTrim(item, entry.getKey(), entry.getValue());
        }
        item.setAmount(itemMap.getCount(player).intValue());
        return item;
    }

    private static boolean specialItem(ItemMap itemMap) {
        return itemMap.getMaterial().toString().contains("WRITTEN_BOOK") || itemMap.getMaterial().toString().contains("PLAYER_HEAD") || itemMap.getMaterial().toString().contains("SKULL_ITEM") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_ROCKET") || itemMap.getMaterial().toString().contains("TIPPED_ARROW") || itemMap.getMaterial().toString().contains("LEATHER_") || !ItemHandler.getDesignatedSlot(itemMap.getMaterial()).equalsIgnoreCase("noslot");
    }

    public static void closeMenu() {
        PlayerHandler.forOnlinePlayers(player -> {
            if (Menu.isOpen(player) || Menu.modifyMenu(player)) {
                player.closeInventory();
            } else if (Menu.typingMenu(player)) {
                typingMenu.get(PlayerHandler.getPlayerID(player)).closeQuery((Player)player);
            }
        });
    }

    public static void setModifyMenu(boolean bool, Player player) {
        SchedulerUtils.run(() -> {
            if (bool) {
                modifyMenu.add(PlayerHandler.getPlayerID(player));
            } else if (!modifyMenu.isEmpty()) {
                modifyMenu.remove(PlayerHandler.getPlayerID(player));
            }
        });
    }

    public static void setTypingMenu(boolean bool, Player player, Interface interFace) {
        SchedulerUtils.run(() -> {
            if (bool) {
                typingMenu.put(PlayerHandler.getPlayerID(player), interFace);
            } else if (!typingMenu.isEmpty()) {
                typingMenu.remove(PlayerHandler.getPlayerID(player));
            }
        });
    }

    public static boolean modifyMenu(Player player) {
        return modifyMenu.contains(PlayerHandler.getPlayerID(player));
    }

    public static boolean typingMenu(Player player) {
        return typingMenu.get(PlayerHandler.getPlayerID(player)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpen(Player player) {
        if (GUIName == null) {
            GUIName = me.RockinChaos.itemjoin.core.utils.StringUtils.colorFormat("&7           &0&n ItemJoin Menu");
        }
        Class<CompatUtils> clazz = CompatUtils.class;
        synchronized (CompatUtils.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return player != null && CompatUtils.getInventoryTitle(player).equalsIgnoreCase(me.RockinChaos.itemjoin.core.utils.StringUtils.colorFormat(GUIName));
        }
    }

    private static /* synthetic */ void lambda$blacklistMatPane$257(List materials, Material material, List saveList, Player player, InventoryClickEvent event) {
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsValue(materials, material.name())) {
            materials.add(material.name());
        } else {
            materials.remove(material.name());
        }
        for (String mat : materials) {
            saveList.add("{id:" + mat + "}");
        }
        File fileFolder = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "config.yml");
        YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)fileFolder);
        dataFile.set("Clear-Items.Blacklist", (Object)me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(saveList.toString().replaceFirst("\\[", ""), "]", ""));
        ItemJoin.getCore().getConfiguration().saveFile((FileConfiguration)dataFile, fileFolder, "config.yml");
        PluginData.getInfo().softReload();
        SchedulerUtils.runLater(2L, () -> Menu.blacklistMatPane(player));
    }
}

