/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.utils.sql;

import java.sql.Timestamp;

public class DataObject {
    private final Table table;
    private Boolean isTemporary = false;
    private String playerId = "";
    private String regionName = "";
    private String worldName = "";
    private String cooldown = "";
    private String ipAddress = "";
    private String duration = "";
    private String command = "";
    private String inventory64 = "";
    private String mapImage = "";
    private String mapId = "";
    private String item = "";
    private String isEnabled = "";
    private String timeStamp = "";

    public DataObject(Table table) {
        this.table = table;
        this.isTemporary = true;
    }

    public DataObject(Table table, String playerId, String worldName, String object) {
        if (playerId != null && !playerId.isEmpty()) {
            this.playerId = playerId;
        } else if (table.equals((Object)Table.ENABLED_PLAYERS)) {
            this.playerId = "ALL";
        }
        if (table.equals((Object)Table.FIRST_JOIN) || table.equals((Object)Table.FIRST_WORLD)) {
            this.item = object;
        } else if (table.equals((Object)Table.RETURN_CRAFTITEMS) || table.equals((Object)Table.RETURN_SWITCH_ITEMS)) {
            this.inventory64 = object;
        } else if (table.equals((Object)Table.FIRST_COMMANDS)) {
            this.command = object;
        }
        this.table = table;
        this.worldName = worldName;
        this.timeStamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public DataObject(Table table, String playerId, String worldName, String object1, String object2) {
        if (playerId != null && !playerId.isEmpty()) {
            this.playerId = playerId;
        } else if (table.equals((Object)Table.ENABLED_PLAYERS)) {
            this.playerId = "ALL";
        }
        if (table.equals((Object)Table.MAP_IDS)) {
            this.mapImage = object1;
            this.mapId = object2;
        } else if (table.equals((Object)Table.RETURN_ITEMS)) {
            this.regionName = object1;
            this.inventory64 = object2;
        } else if (table.equals((Object)Table.IP_LIMITS)) {
            this.item = object1;
            this.ipAddress = object2;
        } else if (table.equals((Object)Table.ENABLED_PLAYERS)) {
            this.item = object1;
            this.isEnabled = object2;
        }
        this.table = table;
        this.worldName = worldName;
        this.timeStamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public DataObject(Table table, String playerId, String worldName, String object1, String object2, String object3) {
        if (playerId != null && !playerId.isEmpty()) {
            this.playerId = playerId;
        } else if (table.equals((Object)Table.ENABLED_PLAYERS)) {
            this.playerId = "ALL";
        }
        if (table.equals((Object)Table.ON_COOLDOWN)) {
            this.item = object1;
            this.cooldown = object2;
            this.duration = object3;
        }
        this.table = table;
        this.worldName = worldName != null && !worldName.isEmpty() ? worldName : "Global";
        this.timeStamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public String getWorld() {
        return this.worldName;
    }

    public String getRegion() {
        return this.regionName;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getMapIMG() {
        return this.mapImage;
    }

    public String getMapID() {
        return this.mapId;
    }

    public String getCooldown() {
        return this.cooldown;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getEnabled() {
        return this.isEnabled;
    }

    public String getInventory64() {
        return this.inventory64;
    }

    public String getCommand() {
        return this.command;
    }

    public String getItem() {
        return this.item;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String stamp) {
        this.timeStamp = stamp;
    }

    public String getTableName() {
        return this.table.tableName();
    }

    public String getTableRemoval() {
        return this.table.removal();
    }

    public String getTableHeaders() {
        return this.table.headers();
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean equalsData(Object obj1, Object obj2) {
        DataObject object1 = (DataObject)obj1;
        DataObject object2 = (DataObject)obj2;
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1.getTable().equals((Object)Table.FIRST_JOIN)) {
            return object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) && (object1.getItem().isEmpty() || object1.getItem().equalsIgnoreCase(object2.getItem()));
        }
        if (object1.getTable().equals((Object)Table.FIRST_WORLD)) {
            return !(!object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) || !object1.getWorld().isEmpty() && !object1.getWorld().equalsIgnoreCase(object2.getWorld()) || !object1.getItem().isEmpty() && !object1.getItem().equalsIgnoreCase(object2.getItem()));
        }
        if (object1.getTable().equals((Object)Table.IP_LIMITS)) {
            return object1.getItem().isEmpty() && object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) || object1.getWorld().equalsIgnoreCase(object2.getWorld()) && object1.getItem().equalsIgnoreCase(object2.getItem()) && object1.getIPAddress().equalsIgnoreCase(object2.getIPAddress());
        }
        if (object1.getTable().equals((Object)Table.FIRST_COMMANDS)) {
            return !(!object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) || !object1.getWorld().isEmpty() && !object1.getWorld().equalsIgnoreCase(object2.getWorld()) || !object1.getCommand().isEmpty() && !object1.getCommand().equalsIgnoreCase(object2.getCommand()));
        }
        if (object1.getTable().equals((Object)Table.ENABLED_PLAYERS)) {
            return object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) && (object1.getWorld().isEmpty() || object1.getWorld().equalsIgnoreCase(object2.getWorld()) || object2.getWorld().equalsIgnoreCase("Global")) && object1.getItem().equalsIgnoreCase(object2.getItem());
        }
        if (object1.getTable().equals((Object)Table.RETURN_ITEMS)) {
            return object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) && object1.getRegion().equalsIgnoreCase(object2.getRegion());
        }
        if (object1.getTable().equals((Object)Table.RETURN_SWITCH_ITEMS)) {
            return object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId()) && object1.getWorld().equalsIgnoreCase(object2.getWorld());
        }
        if (object1.getTable().equals((Object)Table.RETURN_CRAFTITEMS)) {
            return object1.getPlayerId().equalsIgnoreCase(object2.getPlayerId());
        }
        if (object1.getTable().equals((Object)Table.ON_COOLDOWN)) {
            return object1.getItem().equalsIgnoreCase(object2.getItem()) && object1.getCooldown().equalsIgnoreCase(object2.getCooldown());
        }
        if (object1.getTable().equals((Object)Table.MAP_IDS)) {
            return object1.getMapIMG().equalsIgnoreCase(object2.getMapIMG());
        }
        return false;
    }

    public String getRemovalValues() {
        StringBuilder removal = new StringBuilder();
        for (String column : this.table.removal().split(", ")) {
            if (column.equalsIgnoreCase("Player_UUID")) {
                removal.append("'").append(this.getPlayerId()).append("',");
                continue;
            }
            if (column.equalsIgnoreCase("World_Name")) {
                removal.append("'").append(this.getWorld()).append("',");
                continue;
            }
            if (column.equalsIgnoreCase("Region_Name")) {
                removal.append("'").append(this.getRegion()).append("',");
                continue;
            }
            if (column.equalsIgnoreCase("Map_IMG")) {
                removal.append("'").append(this.getMapIMG()).append("',");
                continue;
            }
            if (!column.equalsIgnoreCase("Item_Name")) continue;
            removal.append("'").append(this.getItem()).append("',");
        }
        return removal.substring(0, removal.length() - 1);
    }

    public String getInsertValues() {
        return (this.getWorld() != null && !this.getWorld().isEmpty() ? "'" + this.getWorld() + "'," : "") + (this.getRegion() != null && !this.getRegion().isEmpty() ? "'" + this.getRegion() + "'," : "") + (this.getPlayerId() != null && !this.getPlayerId().isEmpty() ? "'" + this.getPlayerId() + "'," : "") + (this.getItem() != null && !this.getItem().isEmpty() ? "'" + this.getItem() + "'," : "") + (this.getIPAddress() != null && !this.getIPAddress().isEmpty() ? "'" + this.getIPAddress() + "'," : "") + (this.getCooldown() != null && !this.getCooldown().isEmpty() ? "'" + this.getCooldown() + "'," : "") + (this.getDuration() != null && !this.getDuration().isEmpty() ? "'" + this.getDuration() + "'," : "") + (this.getEnabled() != null && !this.getEnabled().isEmpty() ? "'" + this.getEnabled() + "'," : "") + (this.getInventory64() != null && !this.getInventory64().isEmpty() ? "'" + this.getInventory64() + "'," : "") + (this.getCommand() != null && !this.getCommand().isEmpty() ? "'" + this.getCommand() + "'," : "") + (this.getMapIMG() != null && !this.getMapIMG().isEmpty() ? "'" + this.getMapIMG() + "'," : "") + (this.getMapID() != null && !this.getMapID().isEmpty() ? "'" + this.getMapID() + "'," : "") + "'" + new Timestamp(System.currentTimeMillis()) + "'";
    }

    public static enum Table {
        FIRST_JOIN("first_join", "`Player_UUID`, `Item_Name`, `Time_Stamp`", "Player_UUID"),
        FIRST_WORLD("first_world", "`World_Name`, `Player_UUID`, `Item_Name`, `Time_Stamp`", "Player_UUID"),
        IP_LIMITS("ip_limits", "`World_Name`, `Player_UUID`, `Item_Name`, `IP_Address`, `Time_Stamp`", "Player_UUID"),
        FIRST_COMMANDS("first_commands", "`World_Name`, `Player_UUID`, `Command_String`, `Time_Stamp`", "Player_UUID"),
        ENABLED_PLAYERS("enabled_players", "`World_Name`, `Player_UUID`, `Item_Name`, `isEnabled`, `Time_Stamp`", "Player_UUID, World_Name"),
        RETURN_ITEMS("return_items", "`World_Name`, `Region_Name`, `Player_UUID`, `Inventory64`, `Time_Stamp`", "Player_UUID, World_Name, Region_Name"),
        RETURN_SWITCH_ITEMS("return_switch_items", "`World_Name`, `Player_UUID`, `Inventory64`, `Time_Stamp`", "Player_UUID, World_Name"),
        RETURN_CRAFTITEMS("return_craftitems", "`Player_UUID`, `Inventory64`, `Time_Stamp`", "Player_UUID"),
        ON_COOLDOWN("on_cooldown", "`World_Name`, `Player_UUID`, `Item_Name`, `Cooldown`, `Duration`, `Time_Stamp`", "Item_Name"),
        MAP_IDS("map_ids", "`Map_IMG`, `Map_ID`, `Time_Stamp`", "Map_IMG");

        private final String tableName;
        private final String header;
        private final String removal;

        private Table(String tableName, String header, String removal) {
            this.tableName = tableName;
            this.header = header;
            this.removal = removal;
        }

        public String tableName() {
            return this.tableName;
        }

        public String headers() {
            return this.header;
        }

        public String removal() {
            return this.removal;
        }
    }
}

