/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.RockinChaos.itemjoin.ChatExecutor;
import me.RockinChaos.itemjoin.ChatTab;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.listeners.Interfaces;
import me.RockinChaos.itemjoin.core.listeners.PlayerLogin;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.MetricsAPI;
import me.RockinChaos.itemjoin.core.utils.api.ProtocolAPI;
import me.RockinChaos.itemjoin.core.utils.protocol.ProtocolManager;
import me.RockinChaos.itemjoin.core.utils.sql.Database;
import me.RockinChaos.itemjoin.item.ItemDesigner;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.RockinChaos.itemjoin.listeners.Breaking;
import me.RockinChaos.itemjoin.listeners.Chat;
import me.RockinChaos.itemjoin.listeners.Clicking;
import me.RockinChaos.itemjoin.listeners.Commands;
import me.RockinChaos.itemjoin.listeners.Consumes;
import me.RockinChaos.itemjoin.listeners.Crafting;
import me.RockinChaos.itemjoin.listeners.Drops;
import me.RockinChaos.itemjoin.listeners.Entities;
import me.RockinChaos.itemjoin.listeners.Interact;
import me.RockinChaos.itemjoin.listeners.Interface;
import me.RockinChaos.itemjoin.listeners.Offhand;
import me.RockinChaos.itemjoin.listeners.Pickups;
import me.RockinChaos.itemjoin.listeners.Placement;
import me.RockinChaos.itemjoin.listeners.Processes;
import me.RockinChaos.itemjoin.listeners.Projectile;
import me.RockinChaos.itemjoin.listeners.Recipes;
import me.RockinChaos.itemjoin.listeners.Splittable;
import me.RockinChaos.itemjoin.listeners.Stackable;
import me.RockinChaos.itemjoin.listeners.Storable;
import me.RockinChaos.itemjoin.listeners.Trade;
import me.RockinChaos.itemjoin.listeners.plugins.ChestSortAPI;
import me.RockinChaos.itemjoin.listeners.plugins.legacy.Legacy_ChestSortAPI;
import me.RockinChaos.itemjoin.listeners.triggers.LimitSwitch;
import me.RockinChaos.itemjoin.listeners.triggers.PermissionSwitch;
import me.RockinChaos.itemjoin.listeners.triggers.PlayerGuard;
import me.RockinChaos.itemjoin.listeners.triggers.PlayerJoin;
import me.RockinChaos.itemjoin.listeners.triggers.PlayerQuit;
import me.RockinChaos.itemjoin.listeners.triggers.PlayerTeleport;
import me.RockinChaos.itemjoin.listeners.triggers.Respawn;
import me.RockinChaos.itemjoin.listeners.triggers.WorldSwitch;
import me.RockinChaos.itemjoin.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class PluginData {
    private static PluginData info;
    private final List<String> nbtInfo = Collections.singletonList("ItemJoin Name");
    private int listLength = 1;
    private int permissionLength = 2;

    public static PluginData getInfo() {
        if (info == null) {
            info = new PluginData();
        }
        return info;
    }

    public int getListPages() {
        return this.listLength;
    }

    public int getPermissionPages() {
        return this.permissionLength;
    }

    public int getPath(int i) {
        if (ItemJoin.getCore().getConfig("items.yml").getString("items.item_" + i) != null) {
            return this.getPath(i + 1);
        }
        return i;
    }

    public List<String> getNBTList() {
        return this.nbtInfo;
    }

    public boolean isPreventBypass(Player player) {
        return !(StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Bypass"), "OP") && player.isOp() || StringUtils.containsIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Bypass"), "CREATIVE") && PlayerHandler.isCreativeMode(player));
    }

    public boolean isPreventString(Player player, String preventName) {
        String preventString = ItemJoin.getCore().getConfig("config.yml").getString("Prevent." + preventName);
        return StringUtils.splitIgnoreCase(preventString, "TRUE", ",") || StringUtils.splitIgnoreCase(preventString, player.getWorld().getName(), ",") || StringUtils.splitIgnoreCase(preventString, "ALL", ",") || StringUtils.splitIgnoreCase(preventString, "GLOBAL", ",");
    }

    public boolean triggerEnabled(String type) {
        String triggers = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.triggers");
        String enabledWorlds = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds");
        return StringUtils.containsIgnoreCase(triggers, type) && enabledWorlds != null && !enabledWorlds.equalsIgnoreCase("DISABLED") && !enabledWorlds.equalsIgnoreCase("FALSE");
    }

    public boolean clearEnabled(String type) {
        String clearType = ItemJoin.getCore().getConfig("config.yml").getString("Clear-Items." + type);
        return clearType != null && !clearType.equalsIgnoreCase("DISABLED") && !clearType.equalsIgnoreCase("FALSE");
    }

    public int getHotbarSlot() {
        String heldItemSlot = ItemJoin.getCore().getConfig("config.yml").getString("Settings.HeldItem-Slot");
        if (heldItemSlot != null && !heldItemSlot.equalsIgnoreCase("DISABLED") && StringUtils.isInt(heldItemSlot)) {
            return ItemJoin.getCore().getConfig("config.yml").getInt("Settings.HeldItem-Slot");
        }
        return -1;
    }

    public String getHotbarTriggers() {
        String triggers = ItemJoin.getCore().getConfig("config.yml").getString("Settings.HeldItem-Triggers");
        if (triggers != null && !triggers.equalsIgnoreCase("DISABLED") && !triggers.equalsIgnoreCase("FALSE")) {
            return triggers;
        }
        return "";
    }

    public void setLoggable(String logCommand) {
        if (!ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Log-Commands")) {
            ArrayList<String> temp = new ArrayList<String>();
            if (ItemJoin.getCore().getFilter().getHidden().get("commands-list") != null && !ItemJoin.getCore().getFilter().getHidden().get("commands-list").contains(logCommand)) {
                temp = ItemJoin.getCore().getFilter().getHidden().get("commands-list");
            }
            temp.add(logCommand);
            ItemJoin.getCore().getFilter().addHidden("commands-list", temp);
        }
    }

    public String getJSONMessage(String message, String configName) {
        StringBuilder textBuilder = new StringBuilder("[\"\"");
        HashMap<Integer, String> JSONBuilder = new HashMap<Integer, String>();
        String formatLine = message;
        if (ItemHandler.containsJSONEvent(formatLine)) {
            while (ItemHandler.containsJSONEvent(formatLine)) {
                for (ItemHandler.JSONEvent jsonType : ItemHandler.JSONEvent.values()) {
                    Matcher matchPattern = Pattern.compile(jsonType.matchType + "(.*?)>").matcher(formatLine);
                    if (!matchPattern.find()) continue;
                    String inputResult = matchPattern.group(1);
                    JSONBuilder.put(JSONBuilder.size(), jsonType != ItemHandler.JSONEvent.TEXT && jsonType != ItemHandler.JSONEvent.COLOR ? ",\"" + jsonType.event + "\":{\"action\":\"" + jsonType.action + "\",\"value\":\"" + inputResult + "\"}" : "," + (jsonType != ItemHandler.JSONEvent.COLOR ? "{" : "") + "\"" + jsonType.action + "\":\"" + inputResult + "\"");
                    formatLine = formatLine.replace(jsonType.matchType + inputResult + ">", "<JSONEvent>");
                    ItemHandler.safetyCheckURL(configName, jsonType, inputResult);
                }
            }
            if (!formatLine.isEmpty() && !formatLine.trim().isEmpty()) {
                boolean definingText = false;
                String[] JSONEvents = formatLine.split("<JSONEvent>");
                if (org.apache.commons.lang.StringUtils.countMatches((String)formatLine, (String)"<JSONEvent>") > JSONEvents.length) {
                    StringBuilder adjustLine = new StringBuilder();
                    for (String s : formatLine.split("JSONEvent>")) {
                        adjustLine.append(s).append("JSONEvent> ");
                    }
                    JSONEvents = adjustLine.toString().split("<JSONEvent>");
                }
                for (int i = 0; i < JSONEvents.length; ++i) {
                    if (!JSONEvents[i].isEmpty() && !JSONEvents[i].trim().isEmpty()) {
                        textBuilder.append(i == 0 ? "," : "},").append("{\"").append("text").append("\":\"").append(JSONEvents[i]).append(JSONBuilder.get(i) != null && ((String)JSONBuilder.get(i)).contains("\"text\"") ? "\"}" : "\"").append(JSONBuilder.get(i) != null ? (String)JSONBuilder.get(i) : "");
                        continue;
                    }
                    if (JSONBuilder.get(i) == null) continue;
                    if (((String)JSONBuilder.get(i)).contains("\"text\"") && !definingText) {
                        textBuilder.append((String)JSONBuilder.get(i));
                        definingText = true;
                        continue;
                    }
                    if (((String)JSONBuilder.get(i)).contains("\"text\"") && definingText) {
                        textBuilder.append("}").append((String)JSONBuilder.get(i));
                        definingText = false;
                        continue;
                    }
                    textBuilder.append((String)JSONBuilder.get(i));
                }
                textBuilder.append("}");
            }
        } else {
            if (message.contains("raw:")) {
                return message.replace("raw: ", "").replace("raw:", "");
            }
            if (formatLine.contains("&#")) {
                String[] hexFormat;
                for (String line : hexFormat = formatLine.split("&#")) {
                    if (line.isEmpty()) continue;
                    if (line.length() > 6 && line.substring(0, 6).matches("^[0-9a-fA-F]+$")) {
                        textBuilder.append(",{\"text\":\"").append(line.substring(6)).append("\",").append("\"color\":\"#").append(line, 0, 6).append("\"}");
                        continue;
                    }
                    textBuilder.append(",{\"text\":\"").append(line).append("\"}");
                }
            } else {
                textBuilder.append(",{\"text\":\"").append(formatLine).append("\"}");
            }
        }
        return textBuilder + "]";
    }

    public void purgeCraftItems(boolean saveCrafting) {
        PlayerHandler.forOnlinePlayers(player -> {
            Inventory inventory;
            if (saveCrafting && (inventory = ItemHandler.getCraftInventory(player)) != null) {
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.RETURN_CRAFTITEMS, PlayerHandler.getPlayerID(player), "", ItemHandler.serializeInventory(inventory)));
            }
            ItemHandler.removeCraftItems(player);
        });
    }

    public void restoreCraftItems(Player player, ItemUtilities.TriggerType type) {
        if (!type.equals((Object)ItemUtilities.TriggerType.QUIT)) {
            Inventory inventory;
            DataObject dataObject = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.RETURN_CRAFTITEMS, PlayerHandler.getPlayerID(player), "", ""));
            Inventory inventory2 = inventory = dataObject != null ? ItemHandler.deserializeInventory(dataObject.getInventory64()) : null;
            if (dataObject != null && ItemHandler.restoreCraftItems(player, inventory)) {
                ItemJoin.getCore().getSQL().removeData(dataObject, new boolean[0]);
            }
        }
    }

    public void saveCooldowns() {
        for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
            for (String key : itemMap.getPlayersOnCooldown().keySet()) {
                if (System.currentTimeMillis() - itemMap.getPlayersOnCooldown().get(key) > (long)(itemMap.getCommandCooldown() * 1000)) continue;
                ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.ON_COOLDOWN, key, "GLOBAL", itemMap.getConfigName(), itemMap.getCommandCooldown().toString(), itemMap.getPlayersOnCooldown().get(key).toString()));
            }
        }
    }

    public boolean isEnabled(Player player, String item) {
        boolean enabled;
        DataObject dataItem = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), item, Boolean.toString(true)));
        DataObject dataPlayer = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), player.getWorld().getName(), "ALL", Boolean.toString(true)));
        DataObject dataGlobal = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, PlayerHandler.getPlayerID(player), "Global", "ALL", Boolean.toString(true)));
        DataObject dataALL = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.ENABLED_PLAYERS, null, "Global", "ALL", Boolean.toString(true)));
        boolean bl = dataItem != null ? Boolean.parseBoolean(dataItem.getEnabled()) : (dataPlayer != null ? Boolean.parseBoolean(dataPlayer.getEnabled()) : (dataGlobal != null ? Boolean.parseBoolean(dataGlobal.getEnabled()) : (enabled = dataALL == null || Boolean.parseBoolean(dataALL.getEnabled()))));
        if (!enabled) {
            ServerUtils.logDebug("{ItemMap} " + player.getName() + " will not receive any items, they have custom items are disabled.");
        }
        return enabled;
    }

    public void setPages() {
        SchedulerUtils.runAsync(() -> {
            int customItems;
            ConfigurationSection itemsPath = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection("items");
            int n = customItems = itemsPath != null ? itemsPath.getKeys(false).size() : 0;
            if (customItems > 15) {
                this.permissionLength = (int)Math.ceil((double)customItems / 15.0) + 1;
            }
            int listCount = 0;
            for (World world : Bukkit.getWorlds()) {
                ArrayList<String> listItems = new ArrayList<String>();
                ++listCount;
                List<ItemMap> list = ItemUtilities.getUtilities().getItems();
                synchronized (list) {
                    for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                        if (listItems.contains(itemMap.getConfigName()) || !itemMap.inWorld(world)) continue;
                        ++listCount;
                        listItems.add(itemMap.getConfigName());
                    }
                }
            }
            if (listCount > 15) {
                this.listLength = (int)Math.ceil((double)listCount / 15.0);
            }
        });
    }

    public Map<String, List<Object>> getDatabaseData() {
        HashMap<String, List<Object>> databaseData = new HashMap<String, List<Object>>();
        for (DataObject.Table tableEnum : DataObject.Table.values()) {
            String table = tableEnum.tableName();
            List<HashMap<String, String>> selectTable = Database.getDatabase().queryTableData("SELECT * FROM " + ItemJoin.getCore().getData().getTablePrefix() + table, tableEnum.headers().replace("`", ""));
            if (selectTable.isEmpty()) continue;
            for (HashMap<String, String> sl1 : selectTable) {
                DataObject dataObject = null;
                if (tableEnum.equals((Object)DataObject.Table.FIRST_JOIN)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), "", sl1.get("Item_Name"));
                } else if (tableEnum.equals((Object)DataObject.Table.FIRST_WORLD)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Item_Name"));
                } else if (tableEnum.equals((Object)DataObject.Table.IP_LIMITS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Item_Name"), sl1.get("IP_Address"));
                } else if (tableEnum.equals((Object)DataObject.Table.FIRST_COMMANDS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Command_String"));
                } else if (tableEnum.equals((Object)DataObject.Table.ENABLED_PLAYERS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Item_Name"), sl1.get("isEnabled"));
                } else if (tableEnum.equals((Object)DataObject.Table.RETURN_ITEMS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Region_Name"), sl1.get("Inventory64"));
                } else if (tableEnum.equals((Object)DataObject.Table.RETURN_CRAFTITEMS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), "", sl1.get("Inventory64"));
                } else if (tableEnum.equals((Object)DataObject.Table.RETURN_SWITCH_ITEMS)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Inventory64"));
                } else if (tableEnum.equals((Object)DataObject.Table.ON_COOLDOWN)) {
                    dataObject = new DataObject(tableEnum, sl1.get("Player_UUID"), sl1.get("World_Name"), sl1.get("Item_Name"), sl1.get("Cooldown"), sl1.get("Duration"));
                } else if (tableEnum.equals((Object)DataObject.Table.MAP_IDS)) {
                    dataObject = new DataObject(tableEnum, null, null, sl1.get("Map_IMG"), sl1.get("Map_ID"));
                }
                List<DataObject> dataSet = databaseData.get(table) != null ? (List)databaseData.get(table) : new ArrayList();
                dataSet.add(dataObject);
                databaseData.put(table, dataSet);
            }
        }
        return databaseData;
    }

    private void warnExploitUsers() {
        FileConfiguration exploitConfig;
        if (ItemJoin.getCore().getDependencies().exploitFixerEnabled() && (exploitConfig = Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("ExploitFixer")).getConfig()).getString("itemsfix.enabled") != null && exploitConfig.getBoolean("itemsfix.enabled")) {
            ServerUtils.logSevere("{DependAPI} ExploitFixer has been detected with itemsfix enabled! ItemJoin and other custom items plugins WILL BREAK with this feature enabled.Please set itemsfix.enabled to false in the config.yml of ExploitFixer to resolve this conflict.");
        }
    }

    public void registerEvents() {
        Objects.requireNonNull(ItemJoin.getCore().getPlugin().getCommand("itemjoin")).setExecutor((CommandExecutor)new ChatExecutor());
        Objects.requireNonNull(ItemJoin.getCore().getPlugin().getCommand("itemjoin")).setTabCompleter((TabCompleter)new ChatTab());
        ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerLogin(), (Plugin)ItemJoin.getCore().getPlugin());
        ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Interfaces(), (Plugin)ItemJoin.getCore().getPlugin());
        ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Interface(), (Plugin)ItemJoin.getCore().getPlugin());
    }

    public void registerClasses(boolean silent) {
        boolean isRunning = ItemJoin.getCore().isStarted();
        ServerUtils.clearErrorStatements();
        ItemJoin.getCore().getData().refresh();
        ItemJoin.getCore().getFilter().refresh();
        ItemJoin.getCore().getBungee().refresh();
        ItemJoin.getCore().getData().setStarted(false);
        ItemJoin.getCore().getData().setPluginPrefix("&7[&eItemJoin&7]");
        ItemJoin.getCore().getData().setConfig((Map<String, Integer>)ImmutableMap.of((Object)"config.yml", (Object)8, (Object)"items.yml", (Object)8, (Object)"lang.yml", (Object)8));
        ItemJoin.getCore().getData().setLanguages(Arrays.asList("English", "Spanish", "Russian", "French", "Dutch", "Portuguese", "Polish", "Italian", "Chinese", "SimplifiedChinese", "TraditionalChinese", "TwChinese", "CnChinese"));
        ItemJoin.getCore().getData().setPermissions(Arrays.asList("itemjoin.use", "itemjoin.dump", "itemjoin.reload", "itemjoin.updates", "itemjoin.upgrade", "itemjoin.menu", "itemjoin.purge", "itemjoin.get", "itemjoin.get.others", "itemjoin.remove", "itemjoin.remove.others", "itemjoin.disable", "itemjoin.disable.others", "itemjoin.enable", "itemjoin.enable.others", "itemjoin.list", "itemjoin.query"));
        ItemJoin.getCore().getData().setUpdateConfig(this.generateItemsFile(), "items.yml");
        ItemJoin.getCore().getConfiguration().reloadFiles();
        ItemJoin.getCore().getData().setCheckforUpdates(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.CheckforUpdates"));
        ItemJoin.getCore().getData().setDebug(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Debugging"));
        ItemJoin.getCore().getData().setIgnoreErrors(ItemJoin.getCore().getConfig("config.yml").getBoolean("General.ignoreErrors"));
        ItemJoin.getCore().getData().setDataTags(ItemJoin.getCore().getConfig("config.yml").getBoolean("Settings.DataTags"));
        ItemJoin.getCore().getData().setSQL(ItemJoin.getCore().getConfig("config.yml").getString("Database.MySQL") != null && ItemJoin.getCore().getConfig("config.yml").getBoolean("Database.MySQL"));
        ItemJoin.getCore().getData().setTablePrefix(ItemJoin.getCore().getConfig("config.yml").getString("Database.prefix") != null ? ItemJoin.getCore().getConfig("config.yml").getString("Database.prefix") : "ij_");
        ItemJoin.getCore().getData().setSQLHost(ItemJoin.getCore().getConfig("config.yml").getString("Database.host"));
        ItemJoin.getCore().getData().setSQLPort(ItemJoin.getCore().getConfig("config.yml").getString("Database.port"));
        ItemJoin.getCore().getData().setSQLUser(ItemJoin.getCore().getConfig("config.yml").getString("Database.user"));
        ItemJoin.getCore().getData().setSQLPass(ItemJoin.getCore().getConfig("config.yml").getString("Database.pass"));
        ItemJoin.getCore().getData().setSQLDatabase(ItemJoin.getCore().getConfig("config.yml").getString("Database.database"));
        ItemJoin.getCore().getData().setAlterTables(this.getAlterTables());
        ItemJoin.getCore().getData().setCreateTables(this.getCreateTables());
        ItemJoin.getCore().getDependencies().refresh();
        SchedulerUtils.runAsync(() -> {
            String compileVersion = Objects.requireNonNull(YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(ItemJoin.getCore().getPlugin().getResource("plugin.yml")))).getString("nms-version")).split("-")[0].replace(".", "_");
            String serverVersion = ServerUtils.getVersion();
            if (!silent) {
                if (StringUtils.containsIgnoreCase(compileVersion, "spigot_version")) {
                    ServerUtils.logInfo("Running a developer version ... skipping NMS check.");
                } else if (!compileVersion.equalsIgnoreCase(serverVersion) && ServerUtils.hasPreciseUpdate(compileVersion)) {
                    ServerUtils.logSevere("Detected a unsupported version of Minecraft, expected: " + compileVersion.replace("_", ".") + " or older!");
                    ServerUtils.logSevere("Attempting to run in NMS compatibility mode...");
                    ServerUtils.logSevere("Things may not work as expected, please check for plugin updates.");
                }
                ItemJoin.getCore().getDependencies().sendUtilityDepends();
                this.warnExploitUsers();
            }
            this.registerPrevent();
            if (isRunning && ItemJoin.getCore().getSQL().refresh()) {
                ItemJoin.getCore().getData().setDatabaseData(this.getDatabaseData());
                ItemJoin.getCore().getSQL().load();
            }
        });
        if (!isRunning) {
            ItemJoin.getCore().getSQL();
            ItemJoin.getCore().getData().setDatabaseData(this.getDatabaseData());
            ItemJoin.getCore().getSQL().load();
        }
        new ItemDesigner();
        SchedulerUtils.run(() -> {
            PlayerHandler.forOnlinePlayers(player -> ItemUtilities.getUtilities().setStatistics((Player)player));
            this.setPages();
            ConfigurationSection itemsPath = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection("items");
            int loadedItems = 0;
            int customItems = 0;
            if (itemsPath != null) {
                customItems = itemsPath.getKeys(false).size();
                for (String configName : itemsPath.getKeys(false)) {
                    if (ItemUtilities.getUtilities().getItemMap(configName) == null) continue;
                    ++loadedItems;
                }
            }
            ServerUtils.logInfo(loadedItems + "/" + customItems + " Custom item(s) loaded!");
            ItemJoin.getCore().getData().setStarted(true);
        });
        SchedulerUtils.runAsyncLater(100L, () -> {
            if (ItemJoin.getCore().getConfig("config.yml").getBoolean("General.Metrics-Logging")) {
                MetricsAPI metrics = new MetricsAPI(ItemJoin.getCore().getPlugin(), 4115);
                metrics.addCustomChart(new MetricsAPI.SimplePie("items", () -> ItemUtilities.getUtilities().getItems().size() + " "));
                metrics.addCustomChart(new MetricsAPI.SimplePie("itemPermissions", () -> ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items") ? "True" : "False"));
                ItemJoin.getCore().getDependencies().addCustomCharts(metrics);
                ServerUtils.sendErrorStatements(null);
            }
        });
    }

    private void registerPrevent() {
        if ((this.clearEnabled("Join") || this.triggerEnabled("Join") || this.triggerEnabled("First-Join") || StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "JOIN")) && StringUtils.isRegistered(PlayerJoin.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((this.clearEnabled("World-Switch") || this.triggerEnabled("World-Switch") || StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "WORLD-SWITCH")) && StringUtils.isRegistered(WorldSwitch.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new WorldSwitch(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((this.clearEnabled("Quit") || this.triggerEnabled("Quit") || StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "QUIT")) && StringUtils.isRegistered(PlayerQuit.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerQuit(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "RESPAWN") || this.triggerEnabled("Respawn")) && StringUtils.isRegistered(Respawn.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Respawn(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "GAMEMODE-SWITCH") && StringUtils.isRegistered(LimitSwitch.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new LimitSwitch(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((this.clearEnabled("Region-Enter") || StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "REGION-ENTER")) && StringUtils.isRegistered(PlayerGuard.class.getSimpleName()) && ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerGuard(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (StringUtils.containsIgnoreCase(this.getHotbarTriggers(), "REGION-LEAVE") && StringUtils.isRegistered(PlayerGuard.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerGuard(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (!StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Chat"), "FALSE", ",") && !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Chat"), "DISABLED", ",") && StringUtils.isRegistered(Chat.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Chat(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (!StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Pickups"), "FALSE", ",") && !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Pickups"), "DISABLED", ",")) {
            if (ServerUtils.hasSpecificUpdate("1_12") && ReflectionUtils.getBukkitClass("event.entity.EntityPickupItemEvent") != null && StringUtils.isRegistered(Pickups.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Pickups(), (Plugin)ItemJoin.getCore().getPlugin());
            } else {
                LegacyAPI.registerPickups();
            }
        }
        if (!StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.itemMovement"), "FALSE", ",") && !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.itemMovement"), "DISABLED", ",") && StringUtils.isRegistered(Clicking.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Clicking(), (Plugin)ItemJoin.getCore().getPlugin());
            if (!ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolManager.isDead()) {
                ProtocolManager.handleProtocols();
            } else if (ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolAPI.isHandling()) {
                ProtocolAPI.handleProtocols();
            }
        }
        if ((!StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Self-Drops"), "FALSE", ",") && !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Self-Drops"), "DISABLED", ",") || !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Death-Drops"), "FALSE", ",") && !StringUtils.splitIgnoreCase(ItemJoin.getCore().getConfig("config.yml").getString("Prevent.Death-Drops"), "DISABLED", ",")) && StringUtils.isRegistered(Drops.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Drops(), (Plugin)ItemJoin.getCore().getPlugin());
        }
    }

    public void registerListeners(ItemMap itemMap) {
        String enabledWorlds = ItemJoin.getCore().getConfig("config.yml").getString("Active-Commands.enabled-worlds");
        if ((!itemMap.isGiveOnDisabled() && itemMap.isGiveOnJoin() || itemMap.isAutoRemove() || enabledWorlds != null && !enabledWorlds.equalsIgnoreCase("DISABLED") && !enabledWorlds.equalsIgnoreCase("FALSE")) && StringUtils.isRegistered(PlayerJoin.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((!itemMap.isGiveOnDisabled() && (itemMap.isGiveOnRespawn() || itemMap.isGiveOnRespawnPoint() || itemMap.isGiveOnRespawnWild()) || itemMap.isDeathKeepable() || itemMap.isAutoRemove()) && StringUtils.isRegistered(Respawn.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Respawn(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((!itemMap.isGiveOnDisabled() && itemMap.isGiveOnTeleport() || itemMap.isAutoRemove()) && StringUtils.isRegistered(PlayerTeleport.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerTeleport(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((!itemMap.isGiveOnDisabled() && itemMap.isGiveOnWorldSwitch() || itemMap.isAutoRemove()) && StringUtils.isRegistered(WorldSwitch.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new WorldSwitch(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (!itemMap.isGiveOnDisabled() && itemMap.isGiveOnPermissionSwitch() && StringUtils.isRegistered(PermissionSwitch.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PermissionSwitch(), (Plugin)ItemJoin.getCore().getPlugin());
            ProtocolManager.handlePermissions();
        }
        if (!itemMap.isGiveOnDisabled() && (itemMap.isGiveOnRegionEnter() || itemMap.isGiveOnRegionLeave() || itemMap.isGiveOnRegionAccess() || itemMap.isGiveOnRegionEgress()) && StringUtils.isRegistered(PlayerGuard.class.getSimpleName()) && ItemJoin.getCore().getDependencies().getGuard().guardEnabled()) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerGuard(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (!itemMap.isGiveOnDisabled() && itemMap.isUseOnLimitSwitch() && StringUtils.isRegistered(LimitSwitch.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new LimitSwitch(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isAnimated() || itemMap.isDynamic()) && StringUtils.isRegistered(PlayerQuit.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerQuit(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.mobsDrop() && StringUtils.isRegistered(Entities.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Entities(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.blocksDrop() && StringUtils.isRegistered(Breaking.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Breaking(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.isCraftingItem() && StringUtils.isRegistered(Crafting.class.getSimpleName())) {
            PlayerHandler.cycleCrafting();
            SchedulerUtils.runLater(40L, () -> {
                PlayerHandler.forOnlinePlayers(player -> this.restoreCraftItems((Player)player, ItemUtilities.TriggerType.DEFAULT));
                if (!ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolManager.isDead()) {
                    ProtocolManager.handleProtocols();
                } else if (ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolAPI.isHandling()) {
                    ProtocolAPI.handleProtocols();
                }
            });
            if (StringUtils.isRegistered(PlayerQuit.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new PlayerQuit(), (Plugin)ItemJoin.getCore().getPlugin());
            }
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Crafting(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.isMovement() || itemMap.isEquip() || itemMap.isInventoryClose()) {
            if (StringUtils.isRegistered(Clicking.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Clicking(), (Plugin)ItemJoin.getCore().getPlugin());
                if (!ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolManager.isDead()) {
                    ProtocolManager.handleProtocols();
                } else if (ItemJoin.getCore().getDependencies().protocolEnabled() && ProtocolAPI.isHandling()) {
                    ProtocolAPI.handleProtocols();
                }
            }
            if (ItemJoin.getCore().getDependencies().chestSortEnabled()) {
                boolean newAPI = true;
                try {
                    ReflectionUtils.getCanonicalClass("de.jeff_media.chestsort.api.ChestSortEvent");
                }
                catch (IllegalArgumentException e) {
                    ReflectionUtils.getCanonicalClass("de.jeff_media.ChestSortAPI.ChestSortEvent");
                    newAPI = false;
                }
                if (newAPI && StringUtils.isRegistered(ChestSortAPI.class.getSimpleName())) {
                    ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new ChestSortAPI(), (Plugin)ItemJoin.getCore().getPlugin());
                } else if (!newAPI && StringUtils.isRegistered(Legacy_ChestSortAPI.class.getSimpleName())) {
                    ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Legacy_ChestSortAPI(), (Plugin)ItemJoin.getCore().getPlugin());
                }
            }
        }
        if (ServerUtils.hasSpecificUpdate("1_12") && itemMap.isStackable() && StringUtils.isRegistered(Stackable.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Stackable(), (Plugin)ItemJoin.getCore().getPlugin());
        } else if (itemMap.isStackable()) {
            LegacyAPI.registerStackable();
        }
        if (itemMap.isSplittable() && StringUtils.isRegistered(Splittable.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Splittable(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isNotHat() || itemMap.isNoClear()) && StringUtils.isRegistered(Processes.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Processes(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isDeathKeepable() || itemMap.isDeathDroppable() || itemMap.isSelfDroppable() || itemMap.isEraseDroppable()) && StringUtils.isRegistered(Drops.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Drops(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.getCommands() != null && itemMap.getCommands().length != 0 && StringUtils.isRegistered(Commands.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Commands(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isCancelEvents() || itemMap.isSelectable() || itemMap.getInteractCooldown() != 0) && StringUtils.isRegistered(Interact.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Interact(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isPlaceable() || itemMap.isCountLock()) && StringUtils.isRegistered(Placement.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Placement(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if ((itemMap.isCountLock() || itemMap.isTeleport()) && StringUtils.isRegistered(Projectile.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Projectile(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.isCountLock() || itemMap.isCustomConsumable()) {
            if (ServerUtils.hasSpecificUpdate("1_11") && StringUtils.isRegistered(Consumes.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Consumes(), (Plugin)ItemJoin.getCore().getPlugin());
            } else {
                LegacyAPI.registerConsumes();
            }
        }
        if ((itemMap.isItemRepairable() || itemMap.isItemCraftable() || itemMap.getIngredients() != null || !itemMap.getIngredients().isEmpty()) && StringUtils.isRegistered(Recipes.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Recipes(), (Plugin)ItemJoin.getCore().getPlugin());
        }
        if (itemMap.isItemStore() || itemMap.isItemModify() || itemMap.isDisposable()) {
            if (StringUtils.isRegistered(Storable.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Storable(), (Plugin)ItemJoin.getCore().getPlugin());
            }
            if (StringUtils.isRegistered(Trade.class.getSimpleName())) {
                ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Trade(), (Plugin)ItemJoin.getCore().getPlugin());
            }
        }
        if (itemMap.isMovement() && ServerUtils.hasSpecificUpdate("1_9") && ReflectionUtils.getBukkitClass("event.player.PlayerSwapHandItemsEvent") != null && StringUtils.isRegistered(Offhand.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Offhand(), (Plugin)ItemJoin.getCore().getPlugin());
        }
    }

    public Runnable generateItemsFile() {
        return () -> {
            File itemsFile = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
            YamlConfiguration itemsData = YamlConfiguration.loadConfiguration((File)itemsFile);
            if (ServerUtils.hasPreciseUpdate("1_21_3")) {
                itemsData.set("items.devine-item.commands-sound", (Object)"BLOCK.NOTE_BLOCK.PLING");
                itemsData.set("items.devine-item.attributes", (Object)"{ATTACK_DAMAGE:15.2}, {ATTACK_SPEED:19.0}");
                itemsData.set("items.map-item.id", (Object)"FILLED_MAP");
                itemsData.set("items.gamemode-token.id", (Object)"FIREWORK_STAR");
                itemsData.set("items.gamemode-token.commands-sound", (Object)"BLOCK.NOTE_BLOCK.PLING");
                itemsData.set("items.bungeecord-item.id", (Object)"PURPLE_STAINED_GLASS");
                itemsData.set("items.bungeecord-item.commands-sound", (Object)"BLOCK.NOTE_BLOCK.PLING");
                itemsData.set("items.animated-panes.id.1", (Object)"<delay:40>BLACK_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.2", (Object)"<delay:20>BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.3", (Object)"<delay:20>GREEN_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.4", (Object)"<delay:20>MAGENTA_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.5", (Object)"<delay:20>ORANGE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.6", (Object)"<delay:20>RED_STAINED_GLASS_PANE");
                itemsData.set("items.banner-item.id", (Object)"WHITE_BANNER");
                itemsData.set("items.animated-sign.id", (Object)"OAK_SIGN");
                itemsData.set("items.skull-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.potion-arrow.id", (Object)"TIPPED_ARROW");
                itemsData.set("items.potion-arrow.name", (Object)"&fDeath Arrow");
                itemsData.set("items.potion-arrow.potion-effect", (Object)"WITHER:1:20");
                itemsData.set("items.firework-item.id", (Object)"FIREWORK_ROCKET");
                itemsData.set("items.firework-item.firework.colors", (Object)"GRAY, WHITE, PURPLE, LIGHT_GRAY, GREEN");
                itemsData.set("items.potion-apple.potion-effect", (Object)"JUMP:2:120, NIGHT_VISION:2:400, GLOWING:1:410, REGENERATION:1:160");
                itemsData.set("items.profile-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.random-pane-1.id", (Object)"YELLOW_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-2.id", (Object)"BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-3.id", (Object)"PINK_STAINED_GLASS_PANE");
            } else if (ServerUtils.hasSpecificUpdate("1_14")) {
                itemsData.set("items.devine-item.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.devine-item.attributes", (Object)"{GENERIC_ATTACK_DAMAGE:15.2}, {GENERIC_ATTACK_SPEED:19.0}");
                itemsData.set("items.map-item.id", (Object)"FILLED_MAP");
                itemsData.set("items.gamemode-token.id", (Object)"FIREWORK_STAR");
                itemsData.set("items.gamemode-token.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.bungeecord-item.id", (Object)"PURPLE_STAINED_GLASS");
                itemsData.set("items.bungeecord-item.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.animated-panes.id.1", (Object)"<delay:40>BLACK_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.2", (Object)"<delay:20>BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.3", (Object)"<delay:20>GREEN_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.4", (Object)"<delay:20>MAGENTA_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.5", (Object)"<delay:20>ORANGE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.6", (Object)"<delay:20>RED_STAINED_GLASS_PANE");
                itemsData.set("items.banner-item.id", (Object)"WHITE_BANNER");
                itemsData.set("items.animated-sign.id", (Object)"OAK_SIGN");
                itemsData.set("items.skull-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.potion-arrow.id", (Object)"TIPPED_ARROW");
                itemsData.set("items.potion-arrow.name", (Object)"&fDeath Arrow");
                itemsData.set("items.potion-arrow.potion-effect", (Object)"WITHER:1:20");
                itemsData.set("items.firework-item.id", (Object)"FIREWORK_ROCKET");
                itemsData.set("items.firework-item.firework.colors", (Object)"GRAY, WHITE, PURPLE, LIGHT_GRAY, GREEN");
                itemsData.set("items.potion-apple.potion-effect", (Object)"JUMP:2:120, NIGHT_VISION:2:400, GLOWING:1:410, REGENERATION:1:160");
                itemsData.set("items.profile-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.random-pane-1.id", (Object)"YELLOW_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-2.id", (Object)"BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-3.id", (Object)"PINK_STAINED_GLASS_PANE");
            } else if (ServerUtils.hasSpecificUpdate("1_13")) {
                itemsData.set("items.devine-item.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.devine-item.attributes", (Object)"{GENERIC_ATTACK_DAMAGE:15.2}, {GENERIC_ATTACK_SPEED:19.0}");
                itemsData.set("items.map-item.id", (Object)"FILLED_MAP");
                itemsData.set("items.gamemode-token.id", (Object)"FIREWORK_STAR");
                itemsData.set("items.gamemode-token.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.bungeecord-item.id", (Object)"PURPLE_STAINED_GLASS");
                itemsData.set("items.bungeecord-item.commands-sound", (Object)"BLOCK_NOTE_BLOCK_PLING");
                itemsData.set("items.animated-panes.id.1", (Object)"<delay:40>BLACK_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.2", (Object)"<delay:20>BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.3", (Object)"<delay:20>GREEN_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.4", (Object)"<delay:20>MAGENTA_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.5", (Object)"<delay:20>ORANGE_STAINED_GLASS_PANE");
                itemsData.set("items.animated-panes.id.6", (Object)"<delay:20>RED_STAINED_GLASS_PANE");
                itemsData.set("items.banner-item.id", (Object)"WHITE_BANNER");
                itemsData.set("items.animated-sign.id", (Object)"SIGN");
                itemsData.set("items.skull-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.potion-arrow.id", (Object)"TIPPED_ARROW");
                itemsData.set("items.potion-arrow.name", (Object)"&fDeath Arrow");
                itemsData.set("items.potion-arrow.potion-effect", (Object)"WITHER:1:20");
                itemsData.set("items.firework-item.id", (Object)"FIREWORK_ROCKET");
                itemsData.set("items.firework-item.firework.colors", (Object)"GRAY, WHITE, PURPLE, LIGHT_GRAY, GREEN");
                itemsData.set("items.potion-apple.potion-effect", (Object)"JUMP:2:120, NIGHT_VISION:2:400, GLOWING:1:410, REGENERATION:1:160");
                itemsData.set("items.profile-item.id", (Object)"PLAYER_HEAD");
                itemsData.set("items.random-pane-1.id", (Object)"YELLOW_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-2.id", (Object)"BLUE_STAINED_GLASS_PANE");
                itemsData.set("items.random-pane-3.id", (Object)"PINK_STAINED_GLASS_PANE");
            } else if (ServerUtils.hasSpecificUpdate("1_9")) {
                itemsData.set("items.devine-item.commands-sound", (Object)"BLOCK_NOTE_PLING");
                itemsData.set("items.devine-item.attributes", (Object)"{GENERIC_ATTACK_DAMAGE:15.2}, {GENERIC_ATTACK_SPEED:19.0}");
                itemsData.set("items.map-item.id", (Object)"MAP");
                itemsData.set("items.gamemode-token.id", (Object)"FIREWORK_CHARGE");
                itemsData.set("items.gamemode-token.commands-sound", (Object)"BLOCK_NOTE_PLING");
                itemsData.set("items.bungeecord-item.id", (Object)"STAINED_GLASS:12");
                itemsData.set("items.bungeecord-item.commands-sound", (Object)"BLOCK_NOTE_PLING");
                itemsData.set("items.animated-panes.id.1", (Object)"<delay:40>STAINED_GLASS_PANE:15");
                itemsData.set("items.animated-panes.id.2", (Object)"<delay:20>STAINED_GLASS_PANE:11");
                itemsData.set("items.animated-panes.id.3", (Object)"<delay:20>STAINED_GLASS_PANE:13");
                itemsData.set("items.animated-panes.id.4", (Object)"<delay:20>STAINED_GLASS_PANE:2");
                itemsData.set("items.animated-panes.id.5", (Object)"<delay:20>STAINED_GLASS_PANE:1");
                itemsData.set("items.animated-panes.id.6", (Object)"<delay:20>STAINED_GLASS_PANE:14");
                itemsData.set("items.banner-item.id", (Object)"BANNER");
                itemsData.set("items.animated-sign.id", (Object)"SIGN");
                itemsData.set("items.skull-item.id", (Object)"SKULL_ITEM:3");
                itemsData.set("items.potion-arrow.id", (Object)"TIPPED_ARROW");
                itemsData.set("items.potion-arrow.name", (Object)"&fDeath Arrow");
                itemsData.set("items.potion-arrow.potion-effect", (Object)"WITHER:1:20");
                itemsData.set("items.firework-item.id", (Object)"FIREWORK");
                itemsData.set("items.firework-item.firework.colors", (Object)"GRAY, WHITE, PURPLE, SILVER, GREEN");
                itemsData.set("items.potion-apple.potion-effect", (Object)"JUMP:2:120, NIGHT_VISION:2:400, GLOWING:1:410, REGENERATION:1:160");
                itemsData.set("items.profile-item.id", (Object)"SKULL_ITEM:3");
                itemsData.set("items.random-pane-1.id", (Object)"STAINED_GLASS_PANE:4");
                itemsData.set("items.random-pane-2.id", (Object)"STAINED_GLASS_PANE:4");
                itemsData.set("items.random-pane-3.id", (Object)"STAINED_GLASS_PANE:6");
            } else {
                itemsData.set("items.devine-item.commands-sound", (Object)"NOTE_PLING");
                itemsData.set("items.devine-item.attributes", null);
                itemsData.set("items.map-item.id", (Object)"MAP");
                itemsData.set("items.gamemode-token.id", (Object)"FIREWORK_CHARGE");
                itemsData.set("items.gamemode-token.commands-sound", (Object)"NOTE_PLING");
                itemsData.set("items.bungeecord-item.id", (Object)"STAINED_GLASS:12");
                itemsData.set("items.bungeecord-item.commands-sound", (Object)"NOTE_PLING");
                itemsData.set("items.animated-panes.id.1", (Object)"<delay:40>STAINED_GLASS_PANE:15");
                itemsData.set("items.animated-panes.id.2", (Object)"<delay:20>STAINED_GLASS_PANE:11");
                itemsData.set("items.animated-panes.id.3", (Object)"<delay:20>STAINED_GLASS_PANE:13");
                itemsData.set("items.animated-panes.id.4", (Object)"<delay:20>STAINED_GLASS_PANE:2");
                itemsData.set("items.animated-panes.id.5", (Object)"<delay:20>STAINED_GLASS_PANE:1");
                itemsData.set("items.animated-panes.id.6", (Object)"<delay:20>STAINED_GLASS_PANE:14");
                itemsData.set("items.banner-item.id", (Object)"BANNER");
                itemsData.set("items.animated-sign.id", (Object)"SIGN");
                itemsData.set("items.skull-item.id", (Object)"SKULL_ITEM:3");
                itemsData.set("items.potion-arrow.id", (Object)"ARROW");
                itemsData.set("items.potion-arrow.name", (Object)"&fArrow");
                itemsData.set("items.potion-arrow.potion-effect", null);
                itemsData.set("items.firework-item.id", (Object)"FIREWORK");
                itemsData.set("items.firework-item.firework.colors", (Object)"GRAY, WHITE, PURPLE, SILVER, GREEN");
                itemsData.set("items.potion-apple.potion-effect", (Object)"JUMP:2:120, NIGHT_VISION:2:400, INVISIBILITY:1:410, REGENERATION:1:160");
                itemsData.set("items.profile-item.id", (Object)"SKULL_ITEM:3");
                itemsData.set("items.random-pane-1.id", (Object)"STAINED_GLASS_PANE:4");
                itemsData.set("items.random-pane-2.id", (Object)"STAINED_GLASS_PANE:3");
                itemsData.set("items.random-pane-3.id", (Object)"STAINED_GLASS_PANE:6");
                itemsData.set("items.offhand-item", null);
            }
            try {
                itemsData.save(itemsFile);
                ItemJoin.getCore().getConfiguration().getSource("items.yml");
                ItemJoin.getCore().getConfig("items.yml").options().copyDefaults(false);
            }
            catch (Exception e) {
                ItemJoin.getCore().getPlugin().getServer().getLogger().severe("Could not save important data changes to the data file items.yml!");
                ServerUtils.sendSevereTrace(e);
            }
        };
    }

    public Runnable getCreateTables() {
        String prefix = ItemJoin.getCore().getData().getTablePrefix();
        return () -> {
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "first_join (`Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "first_world (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "ip_limits (`World_Name` varchar(512), `IP_Address` varchar(32), `Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "first_commands (`World_Name` varchar(512), `Player_UUID` varchar(64), `Command_String` varchar(1024), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "enabled_players (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `isEnabled` varchar(16), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "return_items (`World_Name` varchar(512), `Region_Name` varchar(256), `Player_UUID` varchar(64), `Inventory64` text, `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "return_craftitems (`Player_UUID` varchar(64), `Inventory64` text, `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "return_switch_items (`World_Name` varchar(512), `Player_UUID` varchar(64), `Inventory64` text, `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "on_cooldown (`World_Name` varchar(512), `Item_Name` varchar(512), `Player_UUID` varchar(64), `Cooldown` varchar(128), `Duration` varchar(128), `Time_Stamp` varchar(64));");
            Database.getDatabase().executeStatement("CREATE TABLE IF NOT EXISTS " + prefix + "map_ids (`Map_IMG` varchar(512), `Map_ID` varchar(12), `Time_Stamp` varchar(64));");
        };
    }

    public Runnable getAlterTables() {
        String prefix = ItemJoin.getCore().getData().getTablePrefix();
        return () -> {
            if (Database.getDatabase().tableExists(prefix + "first_join") && Database.getDatabase().columnExists("SELECT Player_Name FROM " + prefix + "first_join")) {
                Database.getDatabase().executeStatement("CREATE TEMPORARY TABLE " + prefix + "first_join_backup (`Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
                Database.getDatabase().executeStatement("INSERT INTO " + prefix + "first_join_backup SELECT Player_UUID,Item_Name,Time_Stamp FROM " + prefix + "first_join;");
                Database.getDatabase().executeStatement("DROP TABLE " + prefix + "first_join");
                Database.getDatabase().executeStatement("CREATE TABLE " + prefix + "first_join (`Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
                Database.getDatabase().executeStatement("INSERT INTO " + prefix + "first_join SELECT Player_UUID,Item_Name,Time_Stamp FROM " + prefix + "first_join_backup;");
                Database.getDatabase().executeStatement("DROP TABLE " + prefix + "first_join_backup");
            }
            if (Database.getDatabase().tableExists(prefix + "first_world") && Database.getDatabase().columnExists("SELECT Player_Name FROM " + prefix + "first_world")) {
                Database.getDatabase().executeStatement("CREATE TEMPORARY TABLE " + prefix + "first_world_backup (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
                Database.getDatabase().executeStatement("INSERT INTO " + prefix + "first_world_backup SELECT World_Name,Player_UUID,Item_Name,Time_Stamp FROM " + prefix + "first_world;");
                Database.getDatabase().executeStatement("DROP TABLE " + prefix + "first_world");
                Database.getDatabase().executeStatement("CREATE TABLE " + prefix + "first_world (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `Time_Stamp` varchar(64));");
                Database.getDatabase().executeStatement("INSERT INTO " + prefix + "first_world SELECT World_Name,Player_UUID,Item_Name,Time_Stamp FROM " + prefix + "first_world_backup;");
                Database.getDatabase().executeStatement("DROP TABLE " + prefix + "first_world_backup");
            }
            if (Database.getDatabase().tableExists(prefix + "enabled_players")) {
                if (!Database.getDatabase().columnExists("SELECT Item_Name FROM " + prefix + "enabled_players")) {
                    Database.getDatabase().executeStatement("ALTER TABLE " + prefix + "enabled_players ADD Item_Name varchar(512);");
                }
                if (Database.getDatabase().columnExists("SELECT Player_Name FROM " + prefix + "enabled_players")) {
                    Database.getDatabase().executeStatement("CREATE TEMPORARY TABLE " + prefix + "enabled_players_backup (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `isEnabled` varchar(16), `Time_Stamp` varchar(64));");
                    Database.getDatabase().executeStatement("INSERT INTO " + prefix + "enabled_players_backup SELECT World_Name,Player_UUID,Item_Name,isEnabled,Time_Stamp FROM " + prefix + "enabled_players;");
                    Database.getDatabase().executeStatement("DROP TABLE " + prefix + "enabled_players");
                    Database.getDatabase().executeStatement("CREATE TABLE " + prefix + "enabled_players (`World_Name` varchar(512), `Player_UUID` varchar(64), `Item_Name` varchar(512), `isEnabled` varchar(16), `Time_Stamp` varchar(64));");
                    Database.getDatabase().executeStatement("INSERT INTO " + prefix + "enabled_players SELECT World_Name,Player_UUID,Item_Name,isEnabled,Time_Stamp FROM " + prefix + "enabled_players_backup;");
                    Database.getDatabase().executeStatement("DROP TABLE " + prefix + "enabled_players_backup");
                }
            }
        };
    }

    public void softReload() {
        ItemJoin.getCore().getConfiguration().reloadFiles();
        this.registerPrevent();
    }

    public void hardReload(boolean silent) {
        PluginData.getInfo().saveCooldowns();
        ItemUtilities.getUtilities().closeAnimations();
        ItemUtilities.getUtilities().delToggleCommands();
        ItemUtilities.getUtilities().clearItems();
        ItemJoin.getCore().getConfiguration().reloadFiles();
        SchedulerUtils.run(() -> PluginData.getInfo().registerClasses(silent));
    }
}

