/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.handlers;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    private static ConfigHandler config;
    private final HashMap<String, Boolean> noSource = new HashMap();
    private final Map<String, YamlConfiguration> configFiles = new HashMap<String, YamlConfiguration>();
    private boolean Generating = false;

    public static ConfigHandler getConfig() {
        if (config == null) {
            config = new ConfigHandler();
        }
        return config;
    }

    public void copyFiles() {
        Map<String, Integer> configs = Core.getCore().getData().getConfigs();
        for (String config : configs.keySet()) {
            if (config.equalsIgnoreCase("lang.yml")) {
                Core.getCore().getLang().refresh();
                this.copyFile(Core.getCore().getLang().getFile(), Core.getCore().getLang().getFile().split("-")[0] + "-Version", configs.get(config));
                continue;
            }
            this.copyFile(config, config.replace(".yml", "") + "-Version", configs.get(config));
        }
    }

    public FileConfiguration getFile(@Nonnull String path) {
        File file = new File(Core.getCore().getPlugin().getDataFolder(), path);
        boolean hasPath = false;
        for (String config : this.configFiles.keySet()) {
            if (!path.equalsIgnoreCase(config)) continue;
            hasPath = true;
            break;
        }
        if (!hasPath) {
            this.getSource(path);
        }
        try {
            return this.getLoadedConfig(file, false);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            ServerUtils.logSevere("Cannot load " + file.getName() + " from disk!");
            return null;
        }
    }

    public void getSource(@Nonnull String path) {
        File file = new File(Core.getCore().getPlugin().getDataFolder(), path);
        if (!file.exists()) {
            try {
                File dataDir = Core.getCore().getPlugin().getDataFolder();
                if (!dataDir.exists()) {
                    boolean bl = dataDir.mkdir();
                }
                InputStream source = !path.contains("lang.yml") ? Core.getCore().getPlugin().getResource("files/configs/" + path) : Core.getCore().getPlugin().getResource("files/locales/" + path);
                if (!file.exists() && source != null) {
                    Files.copy(source, file.toPath(), new CopyOption[0]);
                }
                if (!Core.getCore().getData().getUpdateConfig().isEmpty() && path.contains(Core.getCore().getData().getUpdateConfig())) {
                    this.Generating = true;
                }
            }
            catch (Exception e) {
                ServerUtils.sendSevereTrace(e);
                ServerUtils.logWarn("Cannot save " + path + " to disk!");
                this.noSource.put(path, true);
                return;
            }
        }
        try {
            YamlConfiguration config = this.getLoadedConfig(file, true);
            this.noSource.put(path, false);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            ServerUtils.logSevere("Cannot load " + file.getName() + " from disk!");
            this.noSource.put(file.getName(), true);
        }
    }

    public YamlConfiguration getLoadedConfig(@Nonnull File file, boolean commit) throws Exception {
        if (commit) {
            Map<String, Integer> configs = Core.getCore().getData().getConfigs();
            for (String config : configs.keySet()) {
                if (!config.equalsIgnoreCase(file.getName()) && (!config.contains("lang.yml") || !file.getName().contains("lang.yml"))) continue;
                YamlConfiguration configFile = new YamlConfiguration();
                configFile.load(file);
                this.configFiles.put(file.getName(), configFile);
                return configFile;
            }
        } else {
            for (String config : this.configFiles.keySet()) {
                if (!config.equalsIgnoreCase(file.getName())) continue;
                return this.configFiles.get(config);
            }
        }
        return null;
    }

    private void copyFile(@Nonnull String configFile, @Nonnull String version, int id) {
        this.getSource(configFile);
        File File2 = new File(Core.getCore().getPlugin().getDataFolder(), configFile);
        if (File2.exists() && !this.noSource.get(configFile).booleanValue() && this.getFile(configFile).getInt(version) != id) {
            InputStream source = !configFile.contains("lang.yml") ? Core.getCore().getPlugin().getResource("files/configs/" + configFile) : Core.getCore().getPlugin().getResource("files/locales/" + configFile);
            if (source != null) {
                String[] namePart = configFile.split("\\.");
                String renameFile = namePart[0] + "-old-" + StringUtils.getRandom(1, 50000) + "." + namePart[1];
                File renamedFile = new File(Core.getCore().getPlugin().getDataFolder(), renameFile);
                if (!renamedFile.exists() && File2.renameTo(renamedFile)) {
                    this.getSource(configFile);
                    ServerUtils.logWarn("Your " + configFile + " is out of date and new options are available, generating a new one!");
                }
            }
        } else if (this.noSource.get(configFile).booleanValue()) {
            ServerUtils.logSevere("Your " + configFile + " is not using proper YAML Syntax and will not be loaded!");
            ServerUtils.logSevere("Check your YAML formatting by using a YAML-PARSER such as https://yamlchecker.com/");
        }
        if (!this.noSource.get(configFile).booleanValue()) {
            if (this.Generating && !Core.getCore().getData().getUpdateConfig().isEmpty() && configFile.equalsIgnoreCase(Core.getCore().getData().getUpdateConfig())) {
                Core.getCore().getData().runUpdateConfig().run();
                this.getSource(Core.getCore().getData().getUpdateConfig());
                this.Generating = false;
            }
            this.getFile(configFile).options().copyDefaults(false);
            if (configFile.contains("lang.yml")) {
                Core.getCore().getLang().setPrefix();
            }
        }
    }

    public void saveFile(@Nonnull FileConfiguration dataFile, @Nonnull File fileFolder, @Nonnull String file) {
        try {
            dataFile.save(fileFolder);
            this.getSource(file);
            this.getFile(file).options().copyDefaults(false);
        }
        catch (Exception e) {
            ServerUtils.logSevere("Could not save data to the " + file + " data file!");
            ServerUtils.sendDebugTrace(e);
        }
    }

    public void reloadFiles() {
        config = new ConfigHandler();
        config.copyFiles();
    }
}

