/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.handlers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerEnterCreativeEvent;
import me.RockinChaos.itemjoin.core.utils.protocol.events.PlayerExitCreativeEvent;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import xyz.haoshoku.nick.api.NickAPI;

public class PlayerHandler {
    private static final HashMap<String, ItemStack[]> craftingItems = new HashMap();
    private static final HashMap<String, ItemStack[]> craftingOpenItems = new HashMap();
    private static final HashMap<String, ItemStack[]> creativeCraftingItems = new HashMap();
    private static final int PLAYER_CRAFT_INV_SIZE = 5;

    public static void safeInventoryClose(@Nonnull Player player) {
        player.openInventory(Bukkit.createInventory((InventoryHolder)player.getInventory().getHolder(), (int)9));
        player.closeInventory();
    }

    public static void setMode(@Nonnull CommandSender who, @Nullable Player altWho, @Nonnull GameMode gamemode, boolean silent, boolean doSave) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerExitCreativeEvent(who, altWho, gamemode, silent, doSave));
    }

    public static void setCreative(@Nonnull CommandSender who, @Nullable Player altWho, boolean silent) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerEnterCreativeEvent(who, altWho, false, false, silent));
    }

    public static void refreshCreative(@Nonnull CommandSender who) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerEnterCreativeEvent(who, null, true, false, true));
    }

    public static boolean isPlayer(@Nonnull Entity entity) {
        try {
            if (Core.getCore().getDependencies().citizensEnabled() && CitizensAPI.getNPCRegistry().isNPC(entity)) {
                return false;
            }
            if (!(entity instanceof Player)) {
                return false;
            }
            if (PlayerHandler.getPlayerID((Player)entity).isEmpty()) {
                return false;
            }
            if (Objects.requireNonNull(((Player)entity).getAddress()).getHostString() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void clearItems(@Nonnull Player player) {
        PlayerInventory inventory = player.getInventory();
        Inventory craftView = CompatUtils.getTopInventory(player);
        inventory.setHelmet(new ItemStack(Material.AIR));
        inventory.setChestplate(new ItemStack(Material.AIR));
        inventory.setLeggings(new ItemStack(Material.AIR));
        inventory.setBoots(new ItemStack(Material.AIR));
        player.setItemOnCursor(new ItemStack(Material.AIR));
        if (ServerUtils.hasSpecificUpdate("1_9")) {
            PlayerHandler.setOffHandItem(player, new ItemStack(Material.AIR));
        }
        inventory.clear();
        craftView.clear();
    }

    public static boolean isCraftingInv(@Nonnull Object object) {
        Object view = object instanceof Player ? CompatUtils.getOpenInventory(object) : object;
        return !CompatUtils.getInventoryType(view).name().equalsIgnoreCase("HOPPER") && !CompatUtils.getInventoryType(view).name().equalsIgnoreCase("BREWING") && CompatUtils.getTopInventory(view).getSize() == 5;
    }

    public static boolean isCreativeMode(@Nonnull Player player) {
        return player.getGameMode() == GameMode.CREATIVE;
    }

    public static boolean isAdventureMode(@Nonnull Player player) {
        return player.getGameMode() == GameMode.ADVENTURE;
    }

    public static boolean isSurvivalMode(@Nonnull Player player) {
        return player.getGameMode() == GameMode.SURVIVAL;
    }

    public static boolean isMenuClick(@Nonnull Player player, @Nonnull Action action) {
        return !PlayerHandler.isCraftingInv(player) && (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK);
    }

    @Nonnull
    public static ItemStack[] getTopContents(@Nonnull Player player) {
        ItemStack[] tempContents = CompatUtils.getTopInventory(player).getContents();
        ItemStack[] contents = new ItemStack[5];
        for (int i = 0; i <= 4; ++i) {
            contents[i] = tempContents[i].clone();
        }
        return contents;
    }

    public static void setHotbarSlot(@Nonnull Player player, int slot) {
        if (slot <= 8 && slot >= 0) {
            player.getInventory().setHeldItemSlot(slot);
        }
    }

    @Nonnull
    public static ItemStack getHandItem(@Nonnull Player player) {
        if (ServerUtils.hasSpecificUpdate("1_9") && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return player.getInventory().getItemInMainHand();
        }
        if (ServerUtils.hasSpecificUpdate("1_9") && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
            return player.getInventory().getItemInOffHand();
        }
        if (!ServerUtils.hasSpecificUpdate("1_9")) {
            return LegacyAPI.getInHandItem(player);
        }
        return new ItemStack(Material.AIR);
    }

    @Nonnull
    public static ItemStack getPerfectHandItem(@Nonnull Player player, @Nullable String type) {
        if (ServerUtils.hasSpecificUpdate("1_9") && type != null && type.equalsIgnoreCase("HAND")) {
            return player.getInventory().getItemInMainHand();
        }
        if (ServerUtils.hasSpecificUpdate("1_9") && type != null && type.equalsIgnoreCase("OFF_HAND")) {
            return player.getInventory().getItemInOffHand();
        }
        if (!ServerUtils.hasSpecificUpdate("1_9")) {
            return LegacyAPI.getInHandItem(player);
        }
        return new ItemStack(Material.AIR);
    }

    @Nonnull
    public static ItemStack getMainHandItem(@Nonnull Player player) {
        if (ServerUtils.hasSpecificUpdate("1_9")) {
            return player.getInventory().getItemInMainHand();
        }
        if (!ServerUtils.hasSpecificUpdate("1_9")) {
            return LegacyAPI.getInHandItem(player);
        }
        return new ItemStack(Material.AIR);
    }

    @Nonnull
    public static ItemStack getOffHandItem(@Nonnull Player player) {
        if (ServerUtils.hasSpecificUpdate("1_9")) {
            return player.getInventory().getItemInOffHand();
        }
        if (!ServerUtils.hasSpecificUpdate("1_9")) {
            return LegacyAPI.getInHandItem(player);
        }
        return new ItemStack(Material.AIR);
    }

    public static void setMainHandItem(@Nonnull Player player, @Nonnull ItemStack item) {
        if (ServerUtils.hasSpecificUpdate("1_9")) {
            player.getInventory().setItemInMainHand(item);
        } else if (!ServerUtils.hasSpecificUpdate("1_9")) {
            LegacyAPI.setInHandItem(player, item);
        }
    }

    public static void setOffHandItem(@Nonnull Player player, @Nonnull ItemStack item) {
        if (ServerUtils.hasSpecificUpdate("1_9")) {
            player.getInventory().setItemInOffHand(item);
        } else if (!ServerUtils.hasSpecificUpdate("1_9")) {
            LegacyAPI.setInHandItem(player, item);
        }
    }

    public static void updateExperienceLevels(@Nonnull Player player) {
        SchedulerUtils.runLater(1L, () -> {
            player.setExp(player.getExp());
            player.setLevel(player.getLevel());
        });
    }

    public static void updateInventory(@Nonnull Player player) {
        PlayerHandler.updateInventory(player, null, 0L);
    }

    public static void updateInventory(@Nonnull Player player, long delay) {
        PlayerHandler.updateInventory(player, null, delay);
    }

    public static void updateInventory(@Nonnull Player player, @Nullable ItemStack item, long delay) {
        SchedulerUtils.runAsyncLater(delay, () -> {
            block11: {
                try {
                    ItemStack invItem;
                    int i;
                    for (i = 0; i < 36; ++i) {
                        invItem = player.getInventory().getItem(i);
                        if (item != null && (invItem == null || !invItem.clone().isSimilar(item))) continue;
                        ReflectionUtils.sendPacketPlayOutSetSlot(player, invItem, i < 9 ? i + 36 : i, 0);
                    }
                    if (ServerUtils.hasSpecificUpdate("1_9") && (item == null || PlayerHandler.getOffHandItem(player).clone().isSimilar(item))) {
                        ReflectionUtils.sendPacketPlayOutSetSlot(player, PlayerHandler.getOffHandItem(player), 45, 0);
                    }
                    if (PlayerHandler.isCraftingInv(player)) {
                        for (i = 4; i >= 0; --i) {
                            invItem = CompatUtils.getTopInventory(player).getItem(i);
                            if (item != null && (invItem == null || !invItem.clone().isSimilar(item))) continue;
                            ReflectionUtils.sendPacketPlayOutSetSlot(player, invItem, i, 0);
                        }
                        for (i = 0; i <= 3; ++i) {
                            invItem = player.getInventory().getItem(i);
                            if (item != null && (invItem == null || !invItem.clone().isSimilar(item))) continue;
                            ReflectionUtils.sendPacketPlayOutSetSlot(player, player.getInventory().getItem(i + 36), 8 - i, 0);
                        }
                        break block11;
                    }
                    try {
                        Object container;
                        Object handle = ReflectionUtils.getEntity(player);
                        if (handle != null && (container = handle.getClass().getField(ReflectionUtils.MinecraftField.ActiveContainer.getField()).get(handle)) != null) {
                            for (int i2 = CompatUtils.getTopInventory(player).getSize() - 1; i2 >= 0; --i2) {
                                ItemStack invItem2 = CompatUtils.getTopInventory(player).getItem(i2);
                                if (item != null && (invItem2 == null || !invItem2.clone().isSimilar(item))) continue;
                                ReflectionUtils.sendPacketPlayOutSetSlot(player, invItem2, i2, (Integer)container.getClass().getField(ReflectionUtils.MinecraftField.windowId.getField()).get(container));
                            }
                        }
                    }
                    catch (Exception e) {
                        ServerUtils.sendDebugTrace(e);
                    }
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
            }
        });
    }

    @Nonnull
    public static String getSkullOwner(@Nonnull ItemStack item) {
        if (item.hasItemMeta()) {
            String owner;
            ItemMeta itemMeta = item.getItemMeta();
            if (ServerUtils.hasSpecificUpdate("1_12") && itemMeta != null && ItemHandler.isSkull(item.getType()) && ((SkullMeta)itemMeta).hasOwner() && ItemHandler.usesOwningPlayer()) {
                OfflinePlayer owner2 = ((SkullMeta)itemMeta).getOwningPlayer();
                if (owner2 != null && owner2.getName() != null) {
                    return owner2.getName();
                }
            } else if (itemMeta != null && ItemHandler.isSkull(item.getType()) && ((SkullMeta)itemMeta).hasOwner() && (owner = LegacyAPI.getSkullOwner((SkullMeta)itemMeta)) != null) {
                return owner;
            }
        }
        return "NULL";
    }

    @Nullable
    public static Player getPlayerString(@Nonnull String playerName) {
        Player args = null;
        try {
            args = Bukkit.getPlayer((UUID)UUID.fromString(playerName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Core.getCore().getDependencies().nickAPIEnabled()) {
            if (NickAPI.isNicked((Player)NickAPI.getPlayerOfNickedName((String)playerName))) {
                return NickAPI.getPlayerOfNickedName((String)playerName);
            }
            return LegacyAPI.getPlayer(playerName);
        }
        if (args == null) {
            return LegacyAPI.getPlayer(playerName);
        }
        return args;
    }

    @Nonnull
    public static String getPlayerName(@Nonnull Player player) {
        try {
            if (Core.getCore().getDependencies().nickAPIEnabled()) {
                if (NickAPI.isNicked((Player)player)) {
                    return NickAPI.getOriginalName((Player)player);
                }
                return player.getName();
            }
            return player.getName();
        }
        catch (Exception e) {
            return player.getName();
        }
    }

    @Nonnull
    public static String getPlayerID(@Nullable Player player) {
        if (player == null) {
            return "";
        }
        try {
            if (Core.getCore().getDependencies().nickAPIEnabled()) {
                if (NickAPI.isNicked((Player)player)) {
                    return NickAPI.getOriginalName((Player)player);
                }
                return player.getName();
            }
            return player.getUniqueId().toString();
        }
        catch (Exception e) {
            return player.getName();
        }
    }

    @Nonnull
    public static String getOfflinePlayerID(@Nullable OfflinePlayer player) {
        if (player == null) {
            return "";
        }
        String playerName = player.getName();
        if (playerName != null) {
            try {
                if (Core.getCore().getDependencies().nickAPIEnabled()) {
                    if (NickAPI.isNickedName((String)playerName)) {
                        return NickAPI.getOriginalName((Player)NickAPI.getPlayerOfNickedName((String)playerName));
                    }
                    return playerName;
                }
                return player.getUniqueId().toString();
            }
            catch (Exception e) {
                return playerName;
            }
        }
        return "";
    }

    public static void quickCraftSave(@Nonnull Player player) {
        if (PlayerHandler.isCraftingInv(player)) {
            ItemStack[] contents = new ItemStack[5];
            for (int i = 0; i <= 4; ++i) {
                contents[i] = CompatUtils.getTopInventory(player).getContents()[i].clone();
            }
            craftingItems.put(PlayerHandler.getPlayerID(player), contents);
        }
    }

    public static void dropItem(@Nonnull Player player, @Nonnull ItemStack item) {
        Location location = player.getLocation();
        location.setY(location.getY() + 1.0);
        Item dropped = player.getWorld().dropItem(location, item);
        dropped.setVelocity(location.getDirection().multiply(0.3));
    }

    @Nonnull
    public static HashMap<String, ItemStack[]> getCraftItems() {
        return craftingItems;
    }

    public static void addCraftItems(@Nonnull Player player, @Nonnull ItemStack[] items) {
        craftingItems.put(PlayerHandler.getPlayerID(player), items);
    }

    @Nonnull
    public static HashMap<String, ItemStack[]> getCreativeCraftItems() {
        return creativeCraftingItems;
    }

    public static void addCreativeCraftItems(@Nonnull Player player, @Nonnull ItemStack[] items) {
        creativeCraftingItems.put(PlayerHandler.getPlayerID(player), items);
    }

    public static void removeCreativeCraftItems(@Nonnull Player player) {
        creativeCraftingItems.remove(PlayerHandler.getPlayerID(player));
    }

    @Nonnull
    public static HashMap<String, ItemStack[]> getOpenCraftItems() {
        return craftingOpenItems;
    }

    public static void addOpenCraftItems(@Nonnull Player player, @Nonnull ItemStack[] items) {
        craftingOpenItems.put(PlayerHandler.getPlayerID(player), items);
    }

    public static void removeOpenCraftItems(@Nonnull Player player) {
        craftingOpenItems.remove(PlayerHandler.getPlayerID(player));
    }

    public static void cycleCrafting() {
        SchedulerUtils.runAsyncAtInterval(15L, 0L, () -> PlayerHandler.forOnlinePlayers(player -> {
            if (player.isOnline() && PlayerHandler.isCraftingInv(player)) {
                ItemStack[] contents = PlayerHandler.getTopContents(player);
                craftingItems.put(PlayerHandler.getPlayerID(player), contents);
            } else {
                craftingItems.remove(PlayerHandler.getPlayerID(player));
            }
        }));
    }

    @Nullable
    public static Block getTargetBlock(@Nonnull Player player, int range) {
        Block block = null;
        try {
            HashSet<Material> ignore = new HashSet<Material>();
            if (ServerUtils.hasSpecificUpdate("1_13")) {
                ignore.addAll(Arrays.asList(Material.AIR, Material.WATER, Material.LAVA));
            } else {
                ignore.addAll(Arrays.asList(Material.AIR, ItemHandler.getMaterial("STATIONARY_WATER", null), ItemHandler.getMaterial("FLOWING_WATER", null), Material.WATER, ItemHandler.getMaterial("STATIONARY_LAVA", null), ItemHandler.getMaterial("FLOWING_LAVA", null), Material.LAVA));
            }
            block = player.getTargetBlock(ignore, range);
        }
        catch (Throwable t1) {
            try {
                HashSet<Byte> ignore = new HashSet<Byte>(Arrays.asList((byte)0, (byte)8, (byte)9, (byte)10, (byte)11));
                block = (Block)player.getClass().getMethod("getTargetBlock", HashSet.class, Integer.TYPE).invoke((Object)player, ignore, range);
            }
            catch (Exception e) {
                ServerUtils.sendSevereTrace(e);
            }
        }
        return block;
    }

    @Nonnull
    public static String getNearbyPlayer(@Nonnull Player player, int range) {
        if (SchedulerUtils.isMainThread()) {
            if (ServerUtils.hasSpecificUpdate("1_14")) {
                Location eyeLocation = player.getEyeLocation();
                Vector direction = eyeLocation.getDirection().normalize();
                double closestDistanceSquared = Double.MAX_VALUE;
                Player targetPlayer = null;
                for (Entity entity : player.getNearbyEntities((double)range, (double)range, (double)range)) {
                    double distanceSquared;
                    RayTraceResult result;
                    Player nearbyPlayer;
                    if (!(entity instanceof Player) || (nearbyPlayer = (Player)entity).equals(player) || (result = nearbyPlayer.getBoundingBox().rayTrace(eyeLocation.toVector(), direction, (double)range)) == null || !((distanceSquared = eyeLocation.distanceSquared(result.getHitPosition().toLocation(player.getWorld()))) < closestDistanceSquared)) continue;
                    closestDistanceSquared = distanceSquared;
                    targetPlayer = nearbyPlayer;
                }
                if (targetPlayer != null) {
                    return targetPlayer.getName();
                }
            } else {
                List lineOfSight = player.getLineOfSight(null, range);
                for (Block block : lineOfSight) {
                    Location blockLocation = block.getLocation();
                    for (Entity entity : player.getWorld().getNearbyEntities(blockLocation, 0.5, 0.5, 0.5)) {
                        Player nearbyPlayer;
                        if (!(entity instanceof Player) || (nearbyPlayer = (Player)entity).equals(player)) continue;
                        return nearbyPlayer.getName();
                    }
                }
            }
        }
        return !Core.getCore().getLang().getLangMessage("placeholders.PLAYER_INTERACT").isEmpty() ? Core.getCore().getLang().getLangMessage("placeholders.PLAYER_INTERACT") : "INVALID";
    }

    public static void forSelectedEntities(@Nonnull CommandSender sender, @Nullable String entities, @Nonnull Consumer<Player> input) {
        try {
            if (entities == null) {
                input.accept(null);
            } else {
                List targets = Bukkit.selectEntities((CommandSender)sender, (String)entities);
                if (targets.isEmpty()) {
                    input.accept(null);
                } else {
                    for (Entity target : targets) {
                        if (!(target instanceof Player)) continue;
                        input.accept((Player)target);
                    }
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            input.accept(null);
        }
    }

    public static void forOnlinePlayers(@Nonnull Consumer<Player> input) {
        try {
            if (Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).getReturnType() == Collection.class) {
                for (Object objPlayer : (Collection)Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    input.accept((Player)objPlayer);
                }
            } else {
                for (Player player : (Player[])Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    input.accept(player);
                }
            }
        }
        catch (Exception e) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                input.accept(player);
            }
        }
    }

    public static void forOfflinePlayers(@Nonnull Consumer<OfflinePlayer> input) {
        try {
            if (Bukkit.class.getMethod("getOfflinePlayers", new Class[0]).getReturnType() == Collection.class) {
                for (Object objPlayer : (Collection)Bukkit.class.getMethod("getOfflinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    input.accept((OfflinePlayer)objPlayer);
                }
            } else {
                for (OfflinePlayer player : (OfflinePlayer[])Bukkit.class.getMethod("getOfflinePlayers", new Class[0]).invoke(null, new Object[0])) {
                    input.accept(player);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
    }
}

