/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.ChatComponent;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class UpdateHandler {
    private static UpdateHandler updater;
    private final String NAME;
    private final String HOST;
    private final String DEV_HOST;
    private String latestVersion;
    private final String versionExact;
    private final String localeVersion;
    private final boolean betaVersion;
    private final boolean devVersion;
    private final String buildNumber;
    private String latestDev;
    private String latestBuild;
    private String artifactPath;
    private final File jarRef;
    private final boolean updatesAllowed;

    public UpdateHandler(@Nonnull JavaPlugin plugin, @Nonnull File pluginFile, boolean updatesAllowed) {
        this.NAME = plugin.getName();
        this.jarRef = pluginFile;
        this.HOST = "https://api.github.com/repos/RockinChaos/" + this.NAME + "/releases/latest";
        this.DEV_HOST = "https://ci-dev.craftationgaming.com/job/" + this.NAME + "/lastSuccessfulBuild";
        this.versionExact = plugin.getDescription().getVersion();
        this.localeVersion = this.versionExact.split("-")[0];
        this.betaVersion = this.versionExact.contains("-SNAPSHOT") || this.versionExact.contains("-EXPERIMENTAL") || this.versionExact.contains("-BETA") || this.versionExact.contains("-ALPHA");
        this.devVersion = this.localeVersion.equals("${project.version}");
        this.buildNumber = this.versionExact.split("-b")[1];
        this.updatesAllowed = updatesAllowed;
        SchedulerUtils.runAsync(() -> this.checkUpdates((CommandSender)plugin.getServer().getConsoleSender(), true));
    }

    @Nonnull
    public static UpdateHandler getUpdater(@Nonnull JavaPlugin plugin, @Nonnull File pluginFile, boolean updatesAllowed) {
        if (updater == null) {
            updater = new UpdateHandler(plugin, pluginFile, updatesAllowed);
        }
        return updater;
    }

    public void forceUpdates(@Nonnull CommandSender sender) {
        Update update = this.updateNeeded(sender, true);
        if (update.updateNeeded) {
            String uri;
            String updateSuccess;
            ServerUtils.messageSender(sender, "&aAn update has been found!", true);
            if (update == Update.BETA) {
                ServerUtils.messageSender(sender, "&aAttempting to update from &ev" + this.versionExact + " &ato the new &ev" + this.latestDev + "&a.", true);
                updateSuccess = this.latestDev;
                uri = this.DEV_HOST + "/artifact/" + this.artifactPath + "?_=" + System.currentTimeMillis();
            } else {
                ServerUtils.messageSender(sender, "&aAttempting to update from &ev" + this.versionExact + " &ato the new &ev" + this.latestVersion + "-RELEASE&a.", true);
                updateSuccess = this.latestVersion + "-RELEASE";
                uri = this.HOST.replace("repos/", "").replace("api.", "").replace("latest", "download/v" + this.latestVersion + "/" + this.NAME.toLowerCase() + ".jar") + "?_=" + System.currentTimeMillis();
            }
            File upgradeFile = new File(Core.getCore().getPlugin().getDataFolder() + "/" + this.NAME + ".jar.tmp");
            SchedulerUtils.runAsync(() -> {
                block38: {
                    try {
                        HttpURLConnection httpConnection = (HttpURLConnection)new URL(uri).openConnection();
                        httpConnection.setRequestProperty("User-Agent", "Mozilla/5.0...");
                        httpConnection.setConnectTimeout(30000);
                        httpConnection.setReadTimeout(30000);
                        int BYTE_SIZE = 2048;
                        long hostFileSize = httpConnection.getContentLength();
                        if (hostFileSize <= 0L) {
                            throw new Exception("Invalid file size from the host server.");
                        }
                        try (InputStream in = new BufferedInputStream(httpConnection.getInputStream());
                             FileOutputStream fos = new FileOutputStream(upgradeFile);
                             BufferedOutputStream bout = new BufferedOutputStream(fos, 2048);){
                            int bytesRead;
                            String progressBar = "&a::::::::::::::::::::::::::::::";
                            int currentProgress = -1;
                            byte[] data = new byte[2048];
                            long fetchedSize = 0L;
                            while ((bytesRead = ((BufferedInputStream)in).read(data, 0, 2048)) >= 0) {
                                bout.write(data, 0, bytesRead);
                                int updateProgress = (int)((double)(fetchedSize += (long)bytesRead) / (double)hostFileSize * 30.0);
                                if (fetchedSize * 100L / hostFileSize % 25L != 0L || updateProgress <= 10) continue;
                                if (currentProgress != updateProgress) {
                                    ServerUtils.messageSender(sender, "&c" + "&a::::::::::::::::::::::::::::::".substring(0, updateProgress + 2), true);
                                }
                                currentProgress = updateProgress;
                            }
                            bout.flush();
                        }
                        if (upgradeFile.length() != hostFileSize) {
                            throw new Exception("Downloaded file size does not match expected size.");
                        }
                        if (!upgradeFile.renameTo(this.jarRef)) {
                            in = Files.newInputStream(upgradeFile.toPath(), new OpenOption[0]);
                            try (OutputStream out = Files.newOutputStream(this.jarRef.toPath(), new OpenOption[0]);){
                                int bytesRead;
                                byte[] buffer = new byte[2048];
                                while ((bytesRead = in.read(buffer)) != -1) {
                                    out.write(buffer, 0, bytesRead);
                                }
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            if (!upgradeFile.delete()) {
                                ServerUtils.logSevere("Failed to delete upgrade file " + upgradeFile.getAbsolutePath());
                            }
                        }
                        ServerUtils.messageSender(sender, "&aSuccessfully updated to &ev" + updateSuccess + "&a!", true);
                        ServerUtils.messageSender(sender, "&aYou must restart your server for this to take effect.", true);
                    }
                    catch (Exception e) {
                        ServerUtils.messageSender(sender, "&cAn error has occurred while trying to update the plugin " + this.jarRef.getName() + ".", true);
                        ServerUtils.messageSender(sender, "&cPlease try again later. If you continue to see this, please contact the plugin developer.", true);
                        ServerUtils.logSevere("An error has occurred while trying to update the plugin " + this.jarRef.getName() + ".");
                        ServerUtils.sendDebugTrace(e);
                        if (!upgradeFile.exists() || upgradeFile.delete()) break block38;
                        ServerUtils.logSevere("Failed to delete upgrade file " + upgradeFile.getAbsolutePath());
                    }
                }
            });
        } else if (this.updatesAllowed) {
            if (this.betaVersion) {
                ServerUtils.messageSender(sender, "&aYou are running a SNAPSHOT!", true);
                ServerUtils.messageSender(sender, "&aIf you find any bugs please report them!", true);
            }
            ServerUtils.messageSender(sender, "&aYou are up to date!", true);
        }
    }

    public void checkUpdates(@Nonnull CommandSender sender, boolean messages) {
        Update update = this.updateNeeded(sender, messages);
        if (update.updateNeeded && this.updatesAllowed) {
            if (update == Update.BETA) {
                ServerUtils.messageSender(sender, "&cYour current version: &bv" + this.versionExact, true);
                ServerUtils.messageSender(sender, "&cA new snapshot build is available: &av" + this.latestDev, true);
                ServerUtils.messageSender(sender, "&aGet it from: " + this.DEV_HOST, true);
                ServerUtils.messageSender(sender, "&aIf you wish to auto update, please type /" + this.NAME + " Upgrade", true);
            } else {
                if (this.betaVersion) {
                    ServerUtils.messageSender(sender, "&cYour current version: &bv" + this.localeVersion + "-SNAPSHOT", true);
                    ServerUtils.messageSender(sender, "&cThis &bSNAPSHOT &cis outdated and a release version is now available.", true);
                } else {
                    ServerUtils.messageSender(sender, "&cYour current version: &bv" + this.localeVersion + "-RELEASE", true);
                }
                ServerUtils.messageSender(sender, "&cA new version is available: &av" + this.latestVersion + "-RELEASE", true);
                ServerUtils.messageSender(sender, "&aGet it from: https://github.com/RockinChaos/" + this.NAME.toLowerCase() + "/releases/latest", true);
                ServerUtils.messageSender(sender, "&aIf you wish to auto update, please type /" + this.NAME + " Upgrade", true);
            }
            this.sendNotifications(update);
        } else if (this.updatesAllowed) {
            if (this.betaVersion) {
                ServerUtils.messageSender(sender, "&aYou are running a SNAPSHOT!", true);
                ServerUtils.messageSender(sender, "&aIf you find any bugs please report them!", true);
            } else if (this.devVersion) {
                ServerUtils.messageSender(sender, "&aYou are running a DEVELOPER SNAPSHOT!", true);
                ServerUtils.messageSender(sender, "&aIf you find any bugs please report them!", true);
                ServerUtils.messageSender(sender, "&aYou will not receive any updates requiring you to manually update.", true);
            }
            ServerUtils.messageSender(sender, "&aYou are up to date!", true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Update updateNeeded(@Nonnull CommandSender sender, boolean messages) {
        if (this.updatesAllowed) {
            if (messages) {
                ServerUtils.messageSender(sender, "&aChecking for updates...", true);
            }
            try {
                int localeNumber;
                URLConnection connection = new URL(this.HOST + "?_=" + System.currentTimeMillis()).openConnection();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String JsonString = StringUtils.toString(reader);
                JSONObject objectReader = (JSONObject)JSONValue.parseWithException((String)JsonString);
                String gitVersion = objectReader.get((Object)"tag_name").toString();
                reader.close();
                if (gitVersion.length() > 7) return Update.UP_TO_DATE;
                this.latestVersion = gitVersion.replaceAll("[a-z]", "").replace("-SNAPSHOT", "").replace("-BETA", "").replace("-ALPHA", "").replace("-RELEASE", "");
                int latestNumber = !this.devVersion ? Integer.parseInt(this.latestVersion.replaceAll("[^0-9]", "")) : 0;
                int n = localeNumber = !this.devVersion ? Integer.parseInt(this.localeVersion.replaceAll("[^0-9]", "")) : 0;
                if (this.devVersion) {
                    return Update.DEV;
                }
                if (latestNumber > localeNumber || this.betaVersion && latestNumber == localeNumber) {
                    return Update.RELEASE;
                }
                if (!this.betaVersion) return Update.UP_TO_DATE;
                try {
                    URLConnection devConnection = new URL(this.DEV_HOST + "/api/json?_=" + System.currentTimeMillis()).openConnection();
                    devConnection.setConnectTimeout(15000);
                    devConnection.setReadTimeout(15000);
                    BufferedReader devReader = new BufferedReader(new InputStreamReader(devConnection.getInputStream()));
                    String devJsonString = StringUtils.toString(devReader);
                    JSONObject devObjectReader = (JSONObject)JSONValue.parseWithException((String)devJsonString);
                    String devVersion = ((JSONObject)((JSONArray)devObjectReader.get((Object)"artifacts")).get(0)).get((Object)"fileName").toString().replace(this.NAME + "-", "").replace(".jar", "");
                    String buildVersion = devObjectReader.get((Object)"id").toString();
                    if (StringUtils.isInt(this.buildNumber) && Integer.parseInt(this.buildNumber) < Integer.parseInt(buildVersion)) {
                        String artifactPath = ((JSONObject)((JSONArray)devObjectReader.get((Object)"artifacts")).get(0)).get((Object)"relativePath").toString();
                        this.latestDev = devVersion;
                        this.latestBuild = buildVersion;
                        this.artifactPath = artifactPath;
                        reader.close();
                        return Update.BETA;
                    }
                    reader.close();
                    return Update.UP_TO_DATE;
                }
                catch (Exception e) {
                    ServerUtils.messageSender(sender, "&c&l[403] &cFailed to check for updates, Craftation Labs has detected too many access requests, try again later.", true);
                    ServerUtils.sendDebugTrace(e);
                }
                return Update.UP_TO_DATE;
            }
            catch (FileNotFoundException e) {
                return Update.UP_TO_DATE;
            }
            catch (Exception e) {
                if (messages) {
                    ServerUtils.messageSender(sender, "&c&l[403] &cFailed to check for updates, GitHub has detected too many access requests, try again later.", true);
                }
                ServerUtils.sendDebugTrace(e);
                return Update.UP_TO_DATE;
            }
        } else {
            if (!messages) return Update.UP_TO_DATE;
            ServerUtils.messageSender(sender, "&cUpdate checking is currently disabled in the config.yml", true);
            ServerUtils.messageSender(sender, "&cIf you wish to use the auto update feature, you will need to enable it.", true);
        }
        return Update.UP_TO_DATE;
    }

    private void sendNotifications(Update update) {
        PlayerHandler.forOnlinePlayers(player -> {
            if (player.isOp()) {
                if (update == Update.BETA) {
                    Core.getCore().getLang().dispatchMessage((CommandSender)player, "%prefix% &eA new snapshot build is available!", "&eClick to go to the download page.", this.DEV_HOST, ChatComponent.ClickAction.OPEN_URL);
                    Core.getCore().getLang().dispatchMessage((CommandSender)player, "%prefix% &ePlease update to the &a&lv" + this.latestDev + "&e.", "&eClick to go to the download page.", this.DEV_HOST, ChatComponent.ClickAction.OPEN_URL);
                } else {
                    Core.getCore().getLang().dispatchMessage((CommandSender)player, "%prefix% &eAn update has been found!", "&eClick to go to the download page.", "https://github.com/RockinChaos/" + this.NAME.toLowerCase() + "/releases/latest", ChatComponent.ClickAction.OPEN_URL);
                    Core.getCore().getLang().dispatchMessage((CommandSender)player, "%prefix% &ePlease update to the &a&lv" + this.latestVersion + "-RELEASE&e.", "&eClick to go to the download page.", "https://github.com/RockinChaos/" + this.NAME.toLowerCase() + "/releases/latest", ChatComponent.ClickAction.OPEN_URL);
                }
            }
        });
    }

    public boolean isDevVersion() {
        return this.betaVersion || this.devVersion;
    }

    @Nonnull
    public String getVersion() {
        return this.versionExact;
    }

    @Nonnull
    public File getJarReference() {
        return this.jarRef;
    }

    public static enum Update {
        DEV(false),
        BETA(true),
        RELEASE(true),
        UP_TO_DATE(false);

        public final boolean updateNeeded;

        private Update(boolean bool) {
            this.updateNeeded = bool;
        }
    }
}

