/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ReflectionUtils {
    private static final Map<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static final String OBC_PREFIX = Bukkit.getServer().getClass().getPackage().getName();
    private static final String NMS_PREFIX = OBC_PREFIX.replace("org.bukkit.craftbukkit", "net.minecraft.server");
    private static final String MC_PREFIX = "net.minecraft";
    private static final String VERSION = OBC_PREFIX.replace("org.bukkit.craftbukkit", "").replace(".", "");
    private static final boolean MC_REMAPPED = ServerUtils.hasPreciseUpdate("1_17_0");
    private static final Pattern MATCH_VARIABLE = Pattern.compile("\\{([^}]+)}");
    private static final boolean MC_DEOBFUSCATION = ReflectionUtils.isPaperObfuscation();

    @Nonnull
    public static <T> FieldAccessor<T> getField(@Nonnull Class<?> target, @Nonnull String name) {
        return ReflectionUtils.getField(target, name, null, 0);
    }

    @Nonnull
    public static <T> FieldAccessor<T> getField(@Nonnull Class<?> target, @Nullable String name, @Nonnull Class<T> fieldType) {
        return ReflectionUtils.getField(target, name, fieldType, 0);
    }

    @Nonnull
    public static <T> FieldAccessor<T> getField(@Nonnull String className, @Nonnull String name, @Nonnull Class<T> fieldType) {
        return ReflectionUtils.getField(ReflectionUtils.getClass(className), name, fieldType, 0);
    }

    @Nonnull
    public static <T> FieldAccessor<T> getField(@Nonnull Class<?> target, @Nonnull Class<T> fieldType, int index) {
        return ReflectionUtils.getField(target, null, fieldType, index);
    }

    @Nonnull
    public static <T> FieldAccessor<T> getField(@Nonnull String className, @Nonnull Class<T> fieldType, int index) {
        return ReflectionUtils.getField(ReflectionUtils.getClass(className), fieldType, index);
    }

    @Nonnull
    private static <T> FieldAccessor<T> getField(@Nonnull Class<?> target, @Nullable String name, @Nullable Class<T> fieldType, int index) {
        for (final Field field : target.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || fieldType != null && !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot access reflection.", e);
                    }
                }

                @Override
                public boolean hasField(Object target) {
                    return field.getDeclaringClass().isAssignableFrom(target.getClass());
                }
            };
        }
        if (target.getSuperclass() != null) {
            return ReflectionUtils.getField(target.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + fieldType);
    }

    @Nonnull
    public static Object getFieldValue(@Nonnull Object object, @Nonnull String name) {
        try {
            return ReflectionUtils.getField(object.getClass(), name).get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get field value " + name, e);
        }
    }

    @Nonnull
    public static MethodInvoker getMethod(@Nonnull String className, @Nonnull String methodName, Class<?> ... params) {
        return ReflectionUtils.getTypedMethod(ReflectionUtils.getClass(className), methodName, null, params);
    }

    @Nonnull
    public static MethodInvoker getMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> ... params) {
        return ReflectionUtils.getTypedMethod(clazz, methodName, null, params);
    }

    @Nonnull
    public static MethodInvoker getTypedMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nullable Class<?> returnType, Class<?> ... params) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || returnType != null && !method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), params)) continue;
            method.setAccessible(true);
            return (target, arguments) -> {
                try {
                    return method.invoke(target, arguments);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke method " + method, e);
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.getMethod(clazz.getSuperclass(), methodName, params);
        }
        throw new IllegalStateException(String.format("Unable to find method %s (%s).", methodName, Arrays.asList(params)));
    }

    @Nonnull
    public static Object getPlayerField(@Nonnull Player player, @Nonnull String field) {
        try {
            Object craftPlayer = ReflectionUtils.getEntity(player);
            return craftPlayer != null ? craftPlayer.getClass().getField(field).get(craftPlayer) : new Object();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoke player field " + field, e);
        }
    }

    @Nonnull
    public static Object invokeMethod(@Nonnull String methodName, Object ... params) {
        try {
            return ReflectionUtils.getMethod(params[0] instanceof Class ? params[0] : params[0].getClass(), methodName, new Class[0]).invoke(params[params.length - 1], new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoke method " + methodName, e);
        }
    }

    @Nonnull
    public static ConstructorInvoker getConstructor(@Nonnull String className, Class<?> ... params) {
        return ReflectionUtils.getConstructor(ReflectionUtils.getClass(className), params);
    }

    @Nonnull
    public static ConstructorInvoker getConstructor(@Nonnull Class<?> clazz, Class<?> ... params) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Arrays.equals(constructor.getParameterTypes(), params)) continue;
            constructor.setAccessible(true);
            return arguments -> {
                try {
                    return constructor.newInstance(arguments);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke constructor " + constructor, e);
                }
            };
        }
        throw new IllegalStateException(String.format("Unable to find constructor for %s (%s).", clazz, Arrays.asList(params)));
    }

    @Nonnull
    public static Class<Object> getUntypedClass(@Nonnull String lookupName) {
        return ReflectionUtils.getClass(lookupName);
    }

    @Nonnull
    public static String getServerVersion() {
        return VERSION;
    }

    @Nonnull
    public static Class<?> getClass(@Nonnull String lookupName) {
        return ReflectionUtils.getCanonicalClass(ReflectionUtils.expandVariables(lookupName));
    }

    @Nonnull
    public static Class<?> getMinecraftClass(@Nonnull String name) {
        if (MC_REMAPPED) {
            try {
                return ReflectionUtils.getMinecraftTag(name);
            }
            catch (Exception e) {
                return ReflectionUtils.getCanonicalClass(NMS_PREFIX + "." + name);
            }
        }
        return ReflectionUtils.getCanonicalClass(NMS_PREFIX + "." + name);
    }

    @Nonnull
    public static Class<?> getCraftBukkitClass(@Nonnull String name) {
        return ReflectionUtils.getCanonicalClass(OBC_PREFIX + "." + name);
    }

    @Nonnull
    public static Class<?> getBukkitClass(@Nonnull String name) {
        return ReflectionUtils.getCanonicalClass("org.bukkit." + name);
    }

    @Nonnull
    public static Class<?> getCanonicalClass(@Nonnull String canonicalName) {
        Class clazz = CLASS_CACHE.computeIfAbsent(canonicalName, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException e) {
                return ReflectionUtils.class;
            }
        });
        if (clazz != ReflectionUtils.class) {
            return clazz;
        }
        throw new IllegalArgumentException("Cannot find " + canonicalName);
    }

    public static void setBasePotionData(@Nonnull PotionMeta tempMeta, @Nonnull PotionType potionType) {
        try {
            Class<?> potionDataClass = ReflectionUtils.getCanonicalClass("org.bukkit.potion.PotionData");
            Constructor<?> potionDataConstructor = potionDataClass.getConstructor(ReflectionUtils.getCanonicalClass("org.bukkit.potion.PotionType"));
            Object potionData = potionDataConstructor.newInstance(potionType);
            Class<?> itemMetaClass = ReflectionUtils.getCanonicalClass("org.bukkit.inventory.meta.PotionMeta");
            Method setBasePotionDataMethod = itemMetaClass.getMethod("setBasePotionData", potionDataClass);
            setBasePotionDataMethod.invoke((Object)tempMeta, potionData);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    public static void setBasePotionData(@Nonnull PotionMeta tempMeta, @Nonnull PotionType potionType, boolean extended, boolean upgraded) {
        try {
            Class<?> potionDataClass = ReflectionUtils.getCanonicalClass("org.bukkit.potion.PotionData");
            Constructor<?> potionDataConstructor = potionDataClass.getConstructor(ReflectionUtils.getCanonicalClass("org.bukkit.potion.PotionType"), Boolean.TYPE, Boolean.TYPE);
            Object potionData = potionDataConstructor.newInstance(potionType, extended, upgraded);
            Class<?> itemMetaClass = ReflectionUtils.getCanonicalClass("org.bukkit.inventory.meta.PotionMeta");
            Method setBasePotionDataMethod = itemMetaClass.getMethod("setBasePotionData", potionDataClass);
            setBasePotionDataMethod.invoke((Object)tempMeta, potionData);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
        }
    }

    public static void sendPacketPlayOutSetSlot(@Nonnull Player player, @Nullable ItemStack item, int index, int windowId) throws Exception {
        Object packet;
        Class<?> itemStack = ReflectionUtils.getMinecraftClass("ItemStack");
        Object nms = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
        Class<?> playOutSlot = ReflectionUtils.getMinecraftClass("PacketPlayOutSetSlot");
        if (MC_REMAPPED) {
            try {
                packet = playOutSlot.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, itemStack).newInstance(windowId, 0, index, itemStack.cast(nms));
            }
            catch (NoSuchMethodException e) {
                packet = playOutSlot.getConstructor(Integer.TYPE, Integer.TYPE, itemStack).newInstance(0, index, itemStack.cast(nms));
            }
        } else {
            packet = playOutSlot.getConstructor(Integer.TYPE, Integer.TYPE, itemStack).newInstance(0, index, itemStack.cast(nms));
        }
        ReflectionUtils.sendPacket(player, packet);
    }

    public static void sendPacket(@Nonnull Player player, @Nonnull Object packet) throws Exception {
        Object nmsPlayer = ReflectionUtils.getEntity(player);
        if (nmsPlayer == null) {
            return;
        }
        if (ServerUtils.hasPreciseUpdate("1_21_7") && ServerUtils.isPaper) {
            Object connection = nmsPlayer.getClass().getField("connection").get(nmsPlayer);
            Class<?> packetClass = ReflectionUtils.getMinecraftClass("Packet");
            Method sendMethod = connection.getClass().getMethod("send", packetClass);
            sendMethod.invoke(connection, packet);
        } else {
            Object playerHandle = nmsPlayer.getClass().getField(MinecraftField.PlayerConnection.getField()).get(nmsPlayer);
            Class<?> packetClass = ReflectionUtils.getMinecraftClass("Packet");
            playerHandle.getClass().getMethod(MinecraftMethod.sendPacket.getMethod(), packetClass).invoke(playerHandle, packet);
        }
    }

    @Nullable
    public static Object literalChatComponent(@Nonnull String content) {
        try {
            if (ServerUtils.hasSpecificUpdate("1_19")) {
                return ReflectionUtils.getMinecraftClass("IChatBaseComponent").getMethod("b", String.class).invoke(null, content);
            }
            return ReflectionUtils.getMinecraftClass("ChatComponentText").getConstructor(String.class).newInstance(content);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    @Nullable
    public static Object jsonChatComponent(@Nonnull String json) {
        try {
            return ReflectionUtils.getMinecraftClass("IChatBaseComponent").getMethod("a", String.class).invoke(null, json);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    @Nullable
    public static Object getEntity(@Nonnull Player player) {
        try {
            return ReflectionUtils.invokeMethod("getHandle", player);
        }
        catch (Exception e) {
            ServerUtils.sendSevereTrace(e);
            return null;
        }
    }

    @Nonnull
    private static String expandVariables(@Nonnull String name) {
        StringBuffer output = new StringBuffer();
        Matcher matcher = MATCH_VARIABLE.matcher(name);
        while (matcher.find()) {
            String replacement;
            block13: {
                String variable = matcher.group(1);
                if ("nms".equalsIgnoreCase(variable)) {
                    if (MC_REMAPPED) {
                        try {
                            String forClass = ReflectionUtils.getMinecraftClass("PlayerConnection").getCanonicalName();
                            if (forClass != null) {
                                replacement = MC_PREFIX;
                                break block13;
                            }
                            replacement = NMS_PREFIX;
                        }
                        catch (Exception e) {
                            replacement = NMS_PREFIX;
                        }
                    } else {
                        replacement = NMS_PREFIX;
                    }
                } else if ("obc".equalsIgnoreCase(variable)) {
                    replacement = OBC_PREFIX;
                } else if ("version".equalsIgnoreCase(variable)) {
                    replacement = VERSION;
                } else {
                    throw new IllegalArgumentException("Unknown variable: " + variable);
                }
            }
            if (!replacement.isEmpty() && matcher.end() < name.length() && name.charAt(matcher.end()) != '.') {
                replacement = replacement + ".";
            }
            matcher.appendReplacement(output, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    @Nonnull
    public static Class<?> getMinecraftTag(@Nonnull String name) {
        for (MinecraftTags tag : MinecraftTags.values()) {
            if (!tag.name().equalsIgnoreCase(name)) continue;
            return ReflectionUtils.getCanonicalClass(MC_PREFIX + tag.tag + "." + name);
        }
        return ReflectionUtils.getCanonicalClass(NMS_PREFIX + "." + name);
    }

    public static boolean isPaperObfuscation() {
        if (ServerUtils.hasPreciseUpdate("1_20_5")) {
            try {
                ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("EntityHuman"), MinecraftField.DefaultContainer.getField());
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public static boolean obfuscated() {
        return MC_REMAPPED && !MC_DEOBFUSCATION;
    }

    public static void refresh() {
        CLASS_CACHE.clear();
    }

    public static interface FieldAccessor<T> {
        public T get(Object var1);

        public void set(Object var1, Object var2);

        public boolean hasField(Object var1);
    }

    public static interface MethodInvoker {
        public Object invoke(@Nonnull Object var1, Object ... var2);
    }

    public static interface ConstructorInvoker {
        public Object invoke(Object ... var1);
    }

    public static enum MinecraftField {
        PlayerConnection("playerConnection", "connection", ServerUtils.hasPreciseUpdate("1_21_6") ? "g" : (ServerUtils.hasPreciseUpdate("1_21_2") ? "f" : (ServerUtils.hasSpecificUpdate("1_20") ? "c" : "b"))),
        ActiveContainer("activeContainer", "containerMenu", ServerUtils.hasPreciseUpdate("1_21_9") ? "cl" : (ServerUtils.hasPreciseUpdate("1_21_6") ? "cn" : (ServerUtils.hasPreciseUpdate("1_21_5") ? "bR" : (ServerUtils.hasSpecificUpdate("1_21") ? "cd" : (ServerUtils.hasPreciseUpdate("1_20_5") ? "cb" : (ServerUtils.hasPreciseUpdate("1_20_2") ? "bS" : (ServerUtils.hasSpecificUpdate("1_20") ? "bR" : (ServerUtils.hasPreciseUpdate("1_19_3") ? "bP" : (ServerUtils.hasSpecificUpdate("1_19") ? "bU" : (ServerUtils.hasPreciseUpdate("1_18_2") ? "bV" : (ServerUtils.hasSpecificUpdate("1_18") ? "bW" : "bV"))))))))))),
        DefaultContainer("defaultContainer", "inventoryMenu", ServerUtils.hasPreciseUpdate("1_21_9") ? "ck" : (ServerUtils.hasPreciseUpdate("1_21_6") ? "cm" : (ServerUtils.hasPreciseUpdate("1_21_5") ? "bQ" : (ServerUtils.hasSpecificUpdate("1_21") ? "cc" : (ServerUtils.hasPreciseUpdate("1_20_5") ? "ca" : (ServerUtils.hasPreciseUpdate("1_20_2") ? "bR" : (ServerUtils.hasSpecificUpdate("1_20") ? "bQ" : (ServerUtils.hasPreciseUpdate("1_19_3") ? "bO" : (ServerUtils.hasSpecificUpdate("1_19") ? "bT" : (ServerUtils.hasPreciseUpdate("1_18_2") ? "bU" : (ServerUtils.hasSpecificUpdate("1_18") ? "bV" : "bU"))))))))))),
        Anvil("ANVIL", "ANVIL", ServerUtils.hasPreciseUpdate("1_20_3") ? "i" : "h"),
        RenameText("renameText", "renameText", "v"),
        CustomName("CUSTOM_NAME", "CUSTOM_NAME", "g"),
        GetSlot("getSlot", "getSlot", ServerUtils.hasPreciseUpdate("1_18_2") ? "b" : (ServerUtils.hasSpecificUpdate("1_18") ? "a" : "getSlot")),
        HasItem("hasItem", "hasItem", ServerUtils.hasPreciseUpdate("1_20_3") ? "h" : (ServerUtils.hasSpecificUpdate("1_18") ? "f" : "hasItem")),
        GetItem("getItem", "getItem", ServerUtils.hasPreciseUpdate("1_20_3") ? "g" : (ServerUtils.hasSpecificUpdate("1_18") ? "e" : "getItem")),
        CustomData("CUSTOM_DATA", "CUSTOM_DATA", "b"),
        CanPlaceOn("CAN_PLACE_ON", "CAN_PLACE_ON", "m"),
        CanBreak("CAN_BREAK", "CAN_BREAK", "n"),
        TooltipDisplay("TOOLTIP_DISPLAY", "TOOLTIP_DISPLAY", "q"),
        TooltipStyle("TOOLTIP_STYLE", "TOOLTIP_STYLE", "G"),
        RepairCost("REPAIR_COST", "REPAIR_COST", "r"),
        UseCooldown("USE_COOLDOWN", "USE_COOLDOWN", "y"),
        Equippable("EQUIPPABLE", "EQUIPPABLE", "D"),
        Repairable("REPAIRABLE", "REPAIRABLE", "E"),
        windowId("windowId", "windowId", ServerUtils.hasPreciseUpdate("1_21_3") ? "l" : "j"),
        WrittenBookContent("WRITTEN_BOOK_CONTENT", "WRITTEN_BOOK_CONTENT", "J"),
        NetworkManager("networkManager", "networkManager", ServerUtils.hasSpecificUpdate("1_19") ? "b" : "a");

        public final String legacy;
        public final String original;
        public final String remapped;

        private MinecraftField(String legacy, String original, String remapped) {
            this.legacy = legacy;
            this.original = original;
            this.remapped = remapped;
        }

        @Nonnull
        public String getField() {
            try {
                return ReflectionUtils.obfuscated() ? this.remapped : (MC_REMAPPED ? this.original : this.legacy);
            }
            catch (Exception e) {
                return this.original;
            }
        }
    }

    public static enum MinecraftMethod {
        valueOf("valueOf", "valueOf", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "valueOf"),
        add("add", "add", ServerUtils.hasSpecificUpdate("1_18") ? "c" : "add"),
        set("set", "set", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "set"),
        get("get", "get", "a"),
        getBase("get", "get", "c"),
        of("of", "of", "a"),
        setInt("setInt", "setInt", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "setInt"),
        getPage("a", "a", "a"),
        getTag("getTag", "getTag", ServerUtils.hasSpecificUpdate("1_19") ? "v" : (ServerUtils.hasPreciseUpdate("1_18_2") ? "t" : (ServerUtils.hasSpecificUpdate("1_18") ? "s" : "getTag"))),
        setTag("setTag", "setTag", ServerUtils.hasSpecificUpdate("1_18") ? "c" : "setTag"),
        addTag("addTag", "addTag", ServerUtils.hasSpecificUpdate("1_18") ? "d" : "addTag"),
        setCompound("setCompound", "put", "a"),
        getKeys(ServerUtils.hasSpecificUpdate("1_13") ? "getKeys" : "c", ServerUtils.hasPreciseUpdate("1_21_7") ? "keySet" : "getAllKeys", ServerUtils.hasSpecificUpdate("1_20") ? "e" : "d"),
        getTypeId("getTypeId", "getId", ServerUtils.hasSpecificUpdate("1_20") ? "b" : "a"),
        setString("setString", "putString", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "setString"),
        getString("getString", ServerUtils.hasPreciseUpdate("1_21_5") ? "getStringOr" : "getString", ServerUtils.hasPreciseUpdate("1_21_5") ? "b" : (ServerUtils.hasSpecificUpdate("1_18") ? "l" : "getString")),
        setDouble("setDouble", "setDouble", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "setDouble"),
        put("set", "put", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "put"),
        build("build", "build", "a"),
        builder("builder", "builder", "a"),
        copyTag("copyTag", "copyTag", ServerUtils.hasPreciseUpdate("1_21_9") ? "b" : (ServerUtils.hasPreciseUpdate("1_21_4") ? "d" : "c")),
        getServer("getServer", "getServer", "b"),
        registryAccess("registryAccess", "registryAccess", "bc"),
        At("at", "create", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "at"),
        AddSlotListener("addSlotListener", "initMenu", ServerUtils.hasSpecificUpdate("1_18") ? "a" : "initMenu"),
        PlayerInventory("inventory", "getInventory", ServerUtils.hasPreciseUpdate("1_21_9") ? "gB" : (ServerUtils.hasPreciseUpdate("1_21_6") ? "gs" : (ServerUtils.hasPreciseUpdate("1_21_5") ? "gj" : (ServerUtils.hasPreciseUpdate("1_21_2") ? "gi" : (ServerUtils.hasSpecificUpdate("1_21") ? "fY" : (ServerUtils.hasPreciseUpdate("1_20_5") ? "gc" : (ServerUtils.hasPreciseUpdate("1_20_3") ? "fS" : (ServerUtils.hasPreciseUpdate("1_20_2") ? "fR" : (ServerUtils.hasSpecificUpdate("1_20") ? "fN" : (ServerUtils.hasPreciseUpdate("1_19_3") ? "fJ" : (ServerUtils.hasPreciseUpdate("1_19_3") ? "fE" : (ServerUtils.hasSpecificUpdate("1_19") ? "fB" : (ServerUtils.hasPreciseUpdate("1_18_2") ? "fr" : (ServerUtils.hasSpecificUpdate("1_18") ? "fq" : "getInventory")))))))))))))),
        withReplacedPages("withReplacedPages", "withReplacedPages", "b"),
        getComponents("getComponents", "getComponents", "a"),
        applyComponentsAndValidate("applyComponentsAndValidate", "applyComponentsAndValidate", "a"),
        sendPacket("sendPacket", "sendPacket", ServerUtils.hasPreciseUpdate("1_20_2") ? "b" : (ServerUtils.hasSpecificUpdate("1_18") ? "a" : "sendPacket"));

        public final String legacy;
        public final String original;
        public final String remapped;

        private MinecraftMethod(String legacy, String original, String remapped) {
            this.legacy = legacy;
            this.original = original;
            this.remapped = remapped;
        }

        @Nonnull
        public String getMethod() {
            try {
                return ReflectionUtils.obfuscated() ? this.remapped : (MC_REMAPPED ? this.original : this.legacy);
            }
            catch (Exception e) {
                return this.original;
            }
        }
    }

    public static enum MinecraftTags {
        NBTTagCompound(".nbt"),
        NBTTagList(".nbt"),
        NBTTagString(".nbt"),
        NBTBase(".nbt"),
        ItemStack(".world.item"),
        Packet(".network.protocol"),
        PacketLoginInStart(".network.protocol.login"),
        PacketPlayOutSetSlot(".network.protocol.game"),
        PacketPlayOutOpenWindow(".network.protocol.game"),
        PacketPlayOutCloseWindow(".network.protocol.game"),
        PlayerConnection(".server.network"),
        EntityPlayer(".server.level"),
        NetworkManager(".network"),
        MinecraftServer(".server"),
        ServerConnection(".server.network"),
        IChatBaseComponent(".network.chat"),
        IChatBaseComponent$ChatSerializer(".network.chat"),
        HolderLookup$a(".core"),
        PacketPlayOutChat(".network.protocol.game"),
        ClientboundSystemChatPacket(".network.protocol.game"),
        ChatMessageType(".network.chat"),
        ChatMessage(".server"),
        HolderSet(".core"),
        BuiltInRegistries(".core.registries"),
        CriterionConditionBlock(".advancements.critereon"),
        BlockPosition(".core"),
        Block(".world.level.block"),
        Blocks(".world.level.block"),
        ContainerAnvil(".world.inventory"),
        EntityHuman(".world.entity.player"),
        ICrafting(".world.inventory"),
        ContainerAccess(".world.inventory"),
        Containers(".world.inventory"),
        Container(".world.inventory"),
        ContainerProperty(".world.inventory"),
        ChatComponentText(".network.chat"),
        World(".world.level"),
        PlayerInventory(".world.entity.player"),
        DataComponents(".core.component"),
        DataComponentPatch(".core.component"),
        DataComponentType(".core.component"),
        DataComponentGetter(".core.component"),
        DataComponentMap(".core.component"),
        MinecraftKey(".resources"),
        CustomData(".world.item.component"),
        AdventureModePredicate(".world.item"),
        TooltipDisplay(".world.item.component"),
        UseCooldown(".world.item.component"),
        Equippable(".world.item.equipment"),
        Repairable(".world.item.enchantment"),
        BookContent(".world.item.component"),
        WrittenBookContent(".world.item.component");

        public final String tag;

        private MinecraftTags(String tag) {
            this.tag = tag;
        }
    }
}

