/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SchedulerUtils {
    private static final Object globalScheduler = ServerUtils.isFolia ? ReflectionUtils.invokeMethod("getGlobalRegionScheduler", Bukkit.class, Bukkit.getServer()) : null;
    private static final Object asyncScheduler = ServerUtils.isFolia ? ReflectionUtils.invokeMethod("getAsyncScheduler", Bukkit.class, Bukkit.getServer()) : null;
    private static final HashMap<Integer, Object> scheduledTasks = new HashMap();
    private static final List<Runnable> SINGLE_QUEUE = new ArrayList<Runnable>();
    private static boolean SINGLE_ACTIVE = false;

    public static boolean isMainThread() {
        if (ServerUtils.isFolia) {
            try {
                boolean isRegionThread = Thread.currentThread().getName().contains("Region Scheduler");
                return isRegionThread != (Boolean)ReflectionUtils.invokeMethod("isGlobalTickThread", Bukkit.class, Bukkit.getServer());
            }
            catch (Exception e) {
                ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to identify if this is not a asynchronous thread.");
                ServerUtils.sendSevereTrace(e);
                return false;
            }
        }
        return Bukkit.isPrimaryThread();
    }

    public static void run(@Nonnull Runnable runnable) {
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runMethod = globalScheduler.getClass().getMethod("run", Plugin.class, Consumer.class);
                    runMethod.invoke(globalScheduler, Core.getCore().getPlugin(), task -> runnable.run());
                    return;
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run task.");
                    ServerUtils.sendSevereTrace(e);
                }
            }
            Bukkit.getScheduler().runTask((Plugin)Core.getCore().getPlugin(), runnable);
        }
    }

    public static void runLater(long delay, @Nonnull Runnable runnable) {
        if (delay <= 0L) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                SchedulerUtils.run(runnable);
            }
            return;
        }
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runDelayedMethod = globalScheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE);
                    runDelayedMethod.invoke(globalScheduler, Core.getCore().getPlugin(), task -> runnable.run(), delay);
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run task later.");
                    ServerUtils.sendSevereTrace(e);
                }
                return;
            }
            Bukkit.getScheduler().runTaskLater((Plugin)Core.getCore().getPlugin(), runnable, delay);
        }
    }

    public static void runRepeatingTask(long delay, long interval, @Nonnull Runnable runnable) {
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runAtFixedRateMethod = globalScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
                    runAtFixedRateMethod.invoke(globalScheduler, Core.getCore().getPlugin(), task -> runnable.run(), delay, interval == 0L ? 1L : interval);
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run repeating task.");
                    ServerUtils.sendSevereTrace(e);
                }
                return;
            }
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Core.getCore().getPlugin(), runnable, delay, interval);
        }
    }

    public static void runAsync(@Nonnull Runnable runnable) {
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runMethod = asyncScheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class);
                    runMethod.invoke(asyncScheduler, Core.getCore().getPlugin(), task -> runnable.run());
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run task asynchronously.");
                    ServerUtils.sendSevereTrace(e);
                }
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getCore().getPlugin(), runnable);
        }
    }

    public static void runAsyncLater(long delay, @Nonnull Runnable runnable) {
        if (delay <= 0L) {
            SchedulerUtils.runAsync(runnable);
            return;
        }
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runDelayedMethod = asyncScheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class);
                    runDelayedMethod.invoke(asyncScheduler, new Object[]{Core.getCore().getPlugin(), task -> runnable.run(), StringUtils.ticksToMillis(delay), TimeUnit.MILLISECONDS});
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run task later asynchronously.");
                    ServerUtils.sendSevereTrace(e);
                }
                return;
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Core.getCore().getPlugin(), runnable, delay);
        }
    }

    public static int runAsyncAtInterval(long delay, long interval, @Nonnull Runnable runnable) {
        if (Core.getCore().getPlugin().isEnabled()) {
            if (ServerUtils.isFolia) {
                try {
                    Method runAtFixedRateMethod = asyncScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class);
                    Object uniqueTask = runAtFixedRateMethod.invoke(asyncScheduler, new Object[]{Core.getCore().getPlugin(), task -> runnable.run(), StringUtils.ticksToMillis(delay), StringUtils.ticksToMillis(interval == 0L ? 1L : interval), TimeUnit.MILLISECONDS});
                    try {
                        return (Integer)uniqueTask.getClass().getMethod("getTaskId", new Class[0]).invoke(uniqueTask, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        int id = StringUtils.getRandom(0, 100000000);
                        scheduledTasks.put(id, uniqueTask);
                        return id;
                    }
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run interval task asynchronously.");
                    ServerUtils.sendSevereTrace(e);
                }
            }
            return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Core.getCore().getPlugin(), runnable, delay, interval).getTaskId();
        }
        return 0;
    }

    public static void runSingleAsync(@Nonnull Runnable runnable) {
        SINGLE_QUEUE.add(runnable);
        if (!SINGLE_ACTIVE) {
            SINGLE_ACTIVE = true;
            SchedulerUtils.cycleAsync();
        }
    }

    public static void cycleAsync() {
        if (Core.getCore().getPlugin().isEnabled()) {
            if (!SINGLE_QUEUE.isEmpty()) {
                Runnable runnable = SINGLE_QUEUE.get(0);
                Consumer<Runnable> runnableConsumer = task -> {
                    runnable.run();
                    SINGLE_QUEUE.remove(runnable);
                    SchedulerUtils.cycleAsync();
                };
                if (ServerUtils.isFolia) {
                    try {
                        Method runNowMethod = asyncScheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class);
                        runNowMethod.invoke(asyncScheduler, Core.getCore().getPlugin(), runnableConsumer);
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to run single task asynchronously.");
                        ServerUtils.sendSevereTrace(e);
                    }
                    return;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getCore().getPlugin(), () -> runnableConsumer.accept(runnable));
            } else {
                SINGLE_ACTIVE = false;
            }
        }
    }

    public static void cancelTask(int taskId) {
        if (ServerUtils.isFolia) {
            try {
                try {
                    Method cancelTaskMethod = globalScheduler.getClass().getMethod("cancelTask", Integer.TYPE);
                    Method cancelAsyncTaskMethod = asyncScheduler.getClass().getMethod("cancelTask", Integer.TYPE);
                    cancelTaskMethod.invoke(globalScheduler, taskId);
                    cancelAsyncTaskMethod.invoke(asyncScheduler, taskId);
                }
                catch (NoSuchMethodException e) {
                    Object uniqueTask = scheduledTasks.remove(taskId);
                    if (uniqueTask != null) {
                        Method cancelMethod = uniqueTask.getClass().getDeclaredMethod("cancel", new Class[0]);
                        cancelMethod.setAccessible(true);
                        cancelMethod.invoke(uniqueTask, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to cancel scheduled task with the id " + taskId + ".");
                ServerUtils.sendSevereTrace(e);
            }
            return;
        }
        Bukkit.getScheduler().cancelTask(taskId);
    }

    public static void cancelTasks() {
        if (ServerUtils.isFolia) {
            try {
                Method cancelTasksMethod = globalScheduler.getClass().getMethod("cancelTasks", Plugin.class);
                Method cancelAsyncTasksMethod = asyncScheduler.getClass().getMethod("cancelTasks", Plugin.class);
                cancelTasksMethod.invoke(globalScheduler, Core.getCore().getPlugin());
                cancelAsyncTasksMethod.invoke(asyncScheduler, Core.getCore().getPlugin());
            }
            catch (Exception e) {
                ServerUtils.logSevere("{SchedulerUtils (Folia)} Failed to cancel all scheduled tasks.");
                ServerUtils.sendSevereTrace(e);
            }
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)Core.getCore().getPlugin());
    }
}

