/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.SimplePluginManager;

public class ServerUtils {
    private static final String packageVersion = Bukkit.getServer().getBukkitVersion();
    private static final String packageSub = packageVersion.substring(0, packageVersion.indexOf(45)).replace(".", "_");
    private static final String serverVersion = packageSub.replace("_", "").replaceAll("[a-z]", "");
    private static final String serverPreciseVersion = packageSub.replace("_", "").replaceAll("[a-z]", "") + (StringUtils.countCharacters(packageSub, "_") == 1 ? Integer.valueOf(0) : "");
    private static final List<String> errorStatements = new ArrayList<String>();
    private static final String devPlayer = "ad6e8c0e-6c47-4e7a-a23d-8a2266d7baee";
    private static boolean devListening = false;
    public static boolean isFolia = ServerUtils.isFolia();
    public static boolean isPaper = ServerUtils.isPaper();

    @Nonnull
    public static String getVersion() {
        return packageSub.split("-")[0].replace(".", "_").replace("R", "").replaceAll("[a-z]", "");
    }

    public static boolean hasSpecificUpdate(@Nonnull String versionString) {
        return Integer.parseInt(serverVersion) >= Integer.parseInt(versionString.replace("_", "") + (StringUtils.countCharacters(packageSub, "_") > 1 ? Integer.valueOf(0) : ""));
    }

    public static boolean hasPreciseUpdate(@Nonnull String versionString) {
        return Integer.parseInt(serverPreciseVersion) >= Integer.parseInt(versionString.replace("_", "") + (StringUtils.countCharacters(versionString, "_") == 1 ? Integer.valueOf(0) : ""));
    }

    public static boolean isFolia() {
        try {
            ReflectionUtils.getCanonicalClass("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isPaper() {
        try {
            ReflectionUtils.getCanonicalClass("com.destroystokyo.paper.Title");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void logInfo(@Nonnull String message) {
        String prefix = "[" + Core.getCore().getPlugin().getName() + "] ";
        message = prefix + message;
        Bukkit.getServer().getLogger().info(message);
    }

    public static void logWarn(@Nonnull String message) {
        String prefix = "[" + Core.getCore().getPlugin().getName() + "_WARN] ";
        message = prefix + message;
        Bukkit.getServer().getLogger().warning(message);
    }

    public static void logDev(@Nonnull String message) {
        String prefix = "[" + Core.getCore().getPlugin().getName() + "_DEVELOPER] ";
        message = prefix + message;
        Bukkit.getServer().getLogger().warning(message);
    }

    public static void logSevere(@Nonnull String message) {
        String prefix = "[" + Core.getCore().getPlugin().getName() + "_ERROR] ";
        if (message.isEmpty()) {
            message = "";
        }
        Bukkit.getServer().getLogger().severe(prefix + message);
        if (!errorStatements.contains(message)) {
            errorStatements.add(message);
        }
    }

    public static void logDebug(@Nonnull String message) {
        if (Core.getCore().getData().debugEnabled()) {
            Player player;
            String prefix = "[" + Core.getCore().getPlugin().getName() + "_DEBUG] ";
            message = prefix + message;
            Bukkit.getServer().getLogger().info(message);
            if (devListening && (player = PlayerHandler.getPlayerString(devPlayer)) != null && player.isOnline()) {
                player.sendMessage(message);
            }
        }
    }

    public static void sendDebugTrace(Exception e) {
        if (Core.getCore().getData().debugEnabled()) {
            Player player;
            e.printStackTrace();
            if (devListening && (player = PlayerHandler.getPlayerString(devPlayer)) != null && player.isOnline()) {
                player.sendMessage(e.toString());
            }
        }
    }

    public static void sendSevereTrace(Exception e) {
        e.printStackTrace();
    }

    public static void sendSevereThrowable(Throwable e) {
        e.printStackTrace();
    }

    public static void messageSender(@Nonnull CommandSender sender, @Nonnull String message, boolean prefix) {
        String pluginPrefix = prefix ? Core.getCore().getData().getPluginPrefix() + " " : "";
        message = pluginPrefix + message;
        if ((message = ChatColor.translateAlternateColorCodes((char)'&', (String)message)).contains("blankmessage") || message.isEmpty()) {
            message = "";
        }
        if (sender instanceof ConsoleCommandSender) {
            message = ChatColor.stripColor((String)message);
        }
        sender.sendMessage(message);
    }

    public static void sendErrorStatements(@Nullable Player player) {
        if (player != null && player.isOp() && Core.getCore().getData().ignoreErrors()) {
            SchedulerUtils.runLater(60L, () -> {
                for (String statement : errorStatements) {
                    player.sendMessage(StringUtils.translateLayout(Core.getCore().getData().getPluginPrefix() + " &c" + statement, player, new PlaceHolder[0]));
                }
            });
        } else if (Core.getCore().getData().ignoreErrors()) {
            for (String statement : errorStatements) {
                PlayerHandler.forOnlinePlayers(player_2 -> {
                    if (player_2 != null && player_2.isOp()) {
                        player_2.sendMessage(StringUtils.translateLayout(Core.getCore().getData().getPluginPrefix() + " &c" + statement, player_2, new PlaceHolder[0]));
                    }
                });
            }
        }
    }

    public static void clearErrorStatements() {
        errorStatements.clear();
    }

    public static boolean devListening() {
        devListening = !devListening;
        return devListening;
    }

    public static void registerCommands(@Nonnull List<PluginCommand> commands) {
        try {
            CommandMap commandMap = null;
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field f = SimplePluginManager.class.getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
            }
            if (commandMap != null) {
                for (PluginCommand command : commands) {
                    commandMap.register(Core.getCore().getPlugin().getDescription().getName(), (Command)command);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
    }

    public static void unregisterCommands(@Nonnull List<PluginCommand> commands) {
        Field commandMap = null;
        Field knownCommands = null;
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                commandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                commandMap.setAccessible(true);
                knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommands.setAccessible(true);
            }
            if (knownCommands != null) {
                for (PluginCommand command : commands) {
                    ((Map)knownCommands.get(commandMap.get(Bukkit.getServer()))).remove(command.getName());
                    command.unregister((CommandMap)commandMap.get(Bukkit.getServer()));
                }
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
    }
}

