/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeAPI
implements PluginMessageListener {
    private static BungeeAPI bungee;
    private final String PLUGIN_CHANNEL = "plugin:cloudsync";
    private boolean detectFailure = false;

    public BungeeAPI() {
        Messenger messenger = Core.getCore().getPlugin().getServer().getMessenger();
        if (!messenger.isOutgoingChannelRegistered((Plugin)Core.getCore().getPlugin(), this.PLUGIN_CHANNEL)) {
            messenger.registerOutgoingPluginChannel((Plugin)Core.getCore().getPlugin(), this.PLUGIN_CHANNEL);
            messenger.registerOutgoingPluginChannel((Plugin)Core.getCore().getPlugin(), "BungeeCord");
        }
        if (!messenger.isIncomingChannelRegistered((Plugin)Core.getCore().getPlugin(), this.PLUGIN_CHANNEL)) {
            messenger.registerIncomingPluginChannel((Plugin)Core.getCore().getPlugin(), this.PLUGIN_CHANNEL, (PluginMessageListener)this);
            messenger.registerIncomingPluginChannel((Plugin)Core.getCore().getPlugin(), "BungeeCord", (PluginMessageListener)this);
        }
    }

    @Nonnull
    public static BungeeAPI getBungee() {
        if (bungee == null) {
            bungee = new BungeeAPI();
        }
        return bungee;
    }

    public void SwitchServers(@Nonnull Player player, @Nonnull String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        player.sendPluginMessage((Plugin)Core.getCore().getPlugin(), "BungeeCord", out.toByteArray());
    }

    public void ExecuteCommand(@Nonnull Player player, @Nonnull String command) {
        if (StringUtils.containsIgnoreCase(player.getListeningPluginChannels().toString(), "plugin:cloudsync")) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            try {
                out.writeUTF(player.getName());
                out.writeUTF(command);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
            player.sendPluginMessage((Plugin)Core.getCore().getPlugin(), this.PLUGIN_CHANNEL, out.toByteArray());
        } else if (!this.detectFailure) {
            ServerUtils.logSevere("Tried to execute the Bungee command /" + command + " but, CloudSync was not detected on your BungeeCord server.");
            this.detectFailure = true;
        }
    }

    public void onPluginMessageReceived(@Nonnull String channel, @Nonnull Player player, @Nonnull byte[] message) {
        if (!channel.equals(this.PLUGIN_CHANNEL)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        if (subChannel.equals("ConnectOther") || subChannel.equals("Connect")) {
            player.sendMessage(subChannel + " " + in.readByte());
        }
    }

    public void refresh() {
        bungee = new BungeeAPI();
    }
}

