/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class ChanceAPI {
    private static ChanceAPI chance;
    private final Map<Object, Integer> probabilityItems = new HashMap<Object, Integer>();
    private List<Chance> chances;
    private int sum;
    private Random random;

    @Nonnull
    public static ChanceAPI getChances() {
        if (chance == null) {
            chance = new ChanceAPI();
        }
        return chance;
    }

    public void newChance() {
        this.random = new Random();
        this.chances = new ArrayList<Chance>();
        this.sum = 0;
    }

    public void newChance(long seed) {
        this.random = new Random(seed);
        this.chances = new ArrayList<Chance>();
        this.sum = 0;
    }

    public void addChance(@Nonnull Object element, int percentile) {
        boolean hasChance = false;
        for (Chance chance : this.chances) {
            if (!chance.getElement().equals(element)) continue;
            hasChance = true;
            break;
        }
        if (!hasChance) {
            this.chances.add(new Chance(element, this.sum, this.sum + percentile));
            this.sum += percentile;
        }
    }

    @Nullable
    public Object getRandomElement() {
        int index = this.random.nextInt(this.sum);
        List<Chance> chanceList = this.chances;
        for (Chance chanceFound : chanceList) {
            if (chanceFound == null || chanceFound.getLowerLimit() > index || chanceFound.getUpperLimit() <= index) continue;
            return chanceFound.getElement();
        }
        return null;
    }

    public int getOptions() {
        return this.sum;
    }

    @Nonnull
    public Map<Object, Integer> getItems() {
        return this.probabilityItems;
    }

    public void putItem(@Nonnull Object probabilityMap, int i) {
        this.probabilityItems.put(probabilityMap, i);
    }

    @Nullable
    public Object getRandom(@Nonnull Player player) {
        this.newChance();
        if (!this.probabilityItems.isEmpty()) {
            for (Object probabilityMap : this.probabilityItems.keySet()) {
                if (this.probabilityItems.get(probabilityMap) == null) continue;
                this.addChance(probabilityMap, this.probabilityItems.get(probabilityMap));
            }
            return this.getRandomElement();
        }
        return null;
    }

    private static class Chance {
        private final int upperLimit;
        private final int lowerLimit;
        private final Object element;

        private Chance(@Nonnull Object element, int lowerLimit, int upperLimit) {
            this.element = element;
            this.upperLimit = upperLimit;
            this.lowerLimit = lowerLimit;
        }

        private int getUpperLimit() {
            return this.upperLimit;
        }

        private int getLowerLimit() {
            return this.lowerLimit;
        }

        @Nonnull
        public Object getElement() {
            return this.element;
        }

        @Nonnull
        public String toString() {
            return "[" + this.lowerLimit + "|" + this.upperLimit + "]: " + this.element;
        }
    }
}

