/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import fr.xephi.authme.api.v3.AuthMeApi;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.GuardAPI;
import me.RockinChaos.itemjoin.core.utils.api.MetricsAPI;
import me.RockinChaos.itemjoin.core.utils.api.VaultAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class DependAPI {
    private static DependAPI depends;
    private boolean proxySkins = false;
    private Class<?> skinsNetty;
    private Object skinsRestorer;
    private boolean registrationForced = false;

    public DependAPI() {
        GuardAPI.getGuard(true);
        VaultAPI.getVault(true);
    }

    @Nonnull
    public static DependAPI getDepends() {
        if (depends == null) {
            depends = new DependAPI();
        }
        return depends;
    }

    @Nonnull
    public String getIgnoreList() {
        String ignoreList = Core.getCore().getConfig("config.yml").getString("General.ignoreDepend");
        if (ignoreList != null) {
            return ignoreList;
        }
        return "";
    }

    public boolean exploitFixerEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("ExploitFixer") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "ExploitFixer");
    }

    public boolean hyperVerseEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Hyperverse") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "Hyperverse");
    }

    public boolean coreEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Multiverse-Core") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "Multiverse-Core");
    }

    public boolean inventoryEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Multiverse-Inventories") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "Multiverse-Inventories");
    }

    public boolean placeHolderEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "PlaceholderAPI");
    }

    public boolean perPluginsEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("PerWorldPlugins") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "PerWorldInventory");
    }

    public boolean perInventoryEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("PerWorldInventory") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "PerWorldInventory");
    }

    public boolean nickAPIEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("NickAPI") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "NickAPI");
    }

    public boolean authMeEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("AuthMe") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "AuthMe");
    }

    public boolean isAuthenticated(Player player) {
        return !this.authMeEnabled() || this.authMeEnabled() && (AuthMeApi.getInstance().isAuthenticated(player) || this.isRegistrationForced());
    }

    private boolean isRegistrationForced() {
        if (this.registrationForced) {
            return true;
        }
        try {
            return AuthMeApi.getInstance().getPlugin().getConfig().getString("settings.registration.force") != null && !AuthMeApi.getInstance().getPlugin().getConfig().getBoolean("settings.registration.force");
        }
        catch (Throwable ignored) {
            this.registrationForced = true;
            return true;
        }
    }

    public boolean myWorldsEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("My_Worlds") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "My_Worlds");
    }

    public boolean xInventoryEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("xInventories") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "xInventories");
    }

    public boolean tokenEnchantEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("TokenEnchant") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "TokenEnchant");
    }

    public boolean databaseEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("HeadDatabase") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "HeadDatabase");
    }

    public boolean skinsRestorerEnabled() {
        boolean skinsEnabled;
        boolean bl = skinsEnabled = Bukkit.getServer().getPluginManager().isPluginEnabled("SkinsRestorer") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "SkinsRestorer");
        if (skinsEnabled && this.skinsRestorer == null) {
            this.initSkins();
        }
        return !this.proxySkins && skinsEnabled && this.skinsRestorer != null;
    }

    private void initSkins() {
        block20: {
            String skinsVersion;
            try {
                this.skinsNetty = ReflectionUtils.getClass("net.skinsrestorer.api.SkinsRestorerProvider");
            }
            catch (Exception e1) {
                skinsVersion = Objects.requireNonNull(Bukkit.getServer().getPluginManager().getPlugin("SkinsRestorer")).getDescription().getVersion();
                if (StringUtils.containsIgnoreCase(e1.getMessage(), "SkinsRestorerAPI is not initialized yet!") || StringUtils.containsIgnoreCase(e1.getMessage(), "SkinsRestorer API is not initialized yet!")) {
                    return;
                }
                try {
                    this.skinsNetty = ReflectionUtils.getClass("net.skinsrestorer.api.SkinsRestorerAPI");
                }
                catch (Exception e2) {
                    try {
                        this.skinsNetty = ReflectionUtils.getClass("net.skinsrestorer.bukkit.SkinsRestorer");
                    }
                    catch (Exception e3) {
                        try {
                            this.skinsNetty = ReflectionUtils.getClass("skinsrestorer.bukkit.SkinsRestorer");
                        }
                        catch (Exception e4) {
                            ServerUtils.sendDebugTrace(e4);
                            ServerUtils.logSevere("{DependAPI} [1] Unsupported SkinsRestorer version " + skinsVersion + " detected (THIS IS NOT A BUG), disabling SkinsRestorer support.");
                            ServerUtils.logSevere("{DependAPI} [1] If you are using the latest version of SkinsRestorer, consider downgrading until an fix is implemented and make sure you are running the latest version of " + Core.getCore().getPlugin().getName() + ".");
                        }
                    }
                }
            }
            if (this.skinsNetty != null) {
                try {
                    Object skinsInstance = this.skinsNetty.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                    this.skinsRestorer = skinsInstance.getClass().getMethod("getPlayerStorage", new Class[0]).invoke(skinsInstance, new Object[0]);
                }
                catch (Exception e1) {
                    skinsVersion = Objects.requireNonNull(Bukkit.getServer().getPluginManager().getPlugin("SkinsRestorer")).getDescription().getVersion();
                    try {
                        Object skinsInstance = this.skinsNetty.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                        this.skinsRestorer = skinsInstance.getClass().getMethod("getSkinsRestorerBukkitAPI", new Class[0]).invoke(skinsInstance, new Object[0]);
                    }
                    catch (Exception e2) {
                        try {
                            this.skinsRestorer = this.skinsNetty.getMethod("getApi", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception e3) {
                            block19: {
                                try {
                                    this.isSkinsProxy(e1.getCause());
                                    this.isSkinsProxy(e2.getCause());
                                    this.isSkinsProxy(e3.getCause());
                                }
                                catch (NullPointerException e4) {
                                    if (StringUtils.containsIgnoreCase(e4.getMessage(), "Cannot invoke \"java.lang.Throwable.getMessage()\" because \"cause\" is null")) {
                                        ServerUtils.logSevere("{DependAPI} [1] An unknown issue occurred when checking SkinsRestorer " + skinsVersion + " for proxy mode.");
                                        ServerUtils.sendSevereTrace(e1);
                                        ServerUtils.sendSevereTrace(e2);
                                        ServerUtils.sendSevereTrace(e3);
                                        break block19;
                                    }
                                    ServerUtils.sendSevereTrace(e4);
                                }
                            }
                            if (this.proxySkins) break block20;
                            ServerUtils.logSevere("{DependAPI} [2] Unsupported SkinsRestorer version " + skinsVersion + " detected (THIS IS NOT A BUG), disabling SkinsRestorer support.");
                            ServerUtils.logSevere("{DependAPI} [2] If you are using the latest version of SkinsRestorer, consider downgrading until an fix is implemented and make sure you are running the latest version of " + Core.getCore().getPlugin().getName() + ".");
                        }
                    }
                }
            }
        }
    }

    private void isSkinsProxy(@Nonnull Throwable cause) {
        if (!(this.proxySkins || StringUtils.containsIgnoreCase(cause.getMessage(), "SkinsRestorerAPI is not initialized yet!") || StringUtils.containsIgnoreCase(cause.getMessage(), "SkinsRestorer API is not initialized yet!") || StringUtils.containsIgnoreCase(cause.getMessage(), "SkinsRestorerAPI is not enabled!") || StringUtils.containsIgnoreCase(cause.getMessage(), "SkinsRestorer API is not enabled!") || StringUtils.containsIgnoreCase(cause.getMessage(), "proxymode") || StringUtils.containsIgnoreCase(cause.getMessage(), "proxy mode"))) {
            ServerUtils.sendSevereThrowable(cause);
        } else {
            this.proxySkins = true;
        }
    }

    public String getSkinValue(@Nonnull UUID uuid, @Nonnull String owner) {
        try {
            Object playerData = this.skinsRestorer.getClass().getMethod("getSkinForPlayer", UUID.class, String.class).invoke(this.skinsRestorer, uuid, owner);
            Object skinData = playerData.getClass().getMethod("get", new Class[0]).invoke(playerData, new Object[0]);
            return (String)skinData.getClass().getMethod("getValue", new Class[0]).invoke(skinData, new Object[0]);
        }
        catch (Exception e1) {
            String skinsVersion = Objects.requireNonNull(Bukkit.getServer().getPluginManager().getPlugin("SkinsRestorer")).getDescription().getVersion();
            try {
                Object playerData = this.skinsRestorer.getClass().getMethod("getSkinName", String.class).invoke(this.skinsRestorer, owner);
                String ownerData = playerData != null ? (String)playerData : owner;
                Object skinData = this.skinsRestorer.getClass().getMethod("getSkinData", String.class).invoke(this.skinsRestorer, ownerData);
                return skinData != null ? (String)skinData.getClass().getMethod("getValue", new Class[0]).invoke(skinData, new Object[0]) : null;
            }
            catch (Exception e2) {
                try {
                    Object playerData = this.skinsRestorer.getClass().getMethod("getSkinName", String.class).invoke(this.skinsRestorer, owner);
                    String ownerData = playerData != null ? (String)playerData : owner;
                    Object skinData = this.skinsRestorer.getClass().getMethod("getSkinData", String.class).invoke(this.skinsRestorer, ownerData);
                    return skinData != null ? (String)skinData.getClass().getMethod("getValue", new Class[0]).invoke(skinData, new Object[0]) : null;
                }
                catch (Exception e3) {
                    ServerUtils.logDebug("Start of the first trace.");
                    ServerUtils.sendDebugTrace(e1);
                    ServerUtils.logDebug("Start of the second trace.");
                    ServerUtils.sendDebugTrace(e2);
                    ServerUtils.logDebug("Start of the third trace.");
                    ServerUtils.sendDebugTrace(e3);
                    ServerUtils.logSevere("{DependAPI} [3] Unsupported SkinsRestorer version " + skinsVersion + " detected (THIS IS NOT A BUG), unable to set the skull owner " + owner + ".");
                    ServerUtils.logSevere("{DependAPI} [3] If you are using the latest version of SkinsRestorer, consider downgrading until an fix is implemented and make sure you are running the latest version of " + Core.getCore().getPlugin().getName() + ".");
                    return null;
                }
            }
        }
    }

    public boolean citizensEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Citizens") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "Citizens");
    }

    public boolean chestSortEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("ChestSort") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "ChestSort");
    }

    public boolean protocolEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("ProtocolLib") && !StringUtils.containsIgnoreCase(this.getIgnoreList(), "ProtocolLib");
    }

    @Nonnull
    public GuardAPI getGuard() {
        return GuardAPI.getGuard(false);
    }

    @Nonnull
    public VaultAPI getVault() {
        return VaultAPI.getVault(false);
    }

    public void sendUtilityDepends() {
        String enabledPlugins = (this.authMeEnabled() ? "AuthMe, " : "") + (this.nickAPIEnabled() ? "NickAPI, " : "") + (this.exploitFixerEnabled() ? "ExploitFixer, " : "") + (this.hyperVerseEnabled() ? "Hyperverse, " : "") + (this.coreEnabled() ? "Multiverse-Core, " : "") + (this.inventoryEnabled() ? "Multiverse-Inventories, " : "") + (this.myWorldsEnabled() ? "My Worlds, " : "") + (this.perInventoryEnabled() ? "PerWorldInventory, " : "") + (this.perPluginsEnabled() ? "PerWorldPlugins, " : "") + (this.tokenEnchantEnabled() ? "TokenEnchant, " : "") + (this.getGuard().guardEnabled() ? "WorldGuard, " : "") + (this.databaseEnabled() ? "HeadDatabase, " : "") + (this.xInventoryEnabled() ? "xInventories, " : "") + (this.placeHolderEnabled() ? "PlaceholderAPI, " : "") + (this.protocolEnabled() ? "ProtocolLib, " : "") + (this.skinsRestorerEnabled() ? "SkinsRestorer, " : "") + (this.citizensEnabled() ? "Citizens, " : "") + (this.chestSortEnabled() ? "ChestSort, " : "") + (this.getVault().vaultEnabled() ? "Vault, " : "");
        if (!enabledPlugins.isEmpty()) {
            ServerUtils.logInfo("Hooked into { " + enabledPlugins.substring(0, enabledPlugins.length() - 2) + " }");
        }
        if (!(this.getIgnoreList().isEmpty() || StringUtils.containsIgnoreCase(this.getIgnoreList(), "NONE") || StringUtils.containsIgnoreCase(this.getIgnoreList(), "DISABLED") || StringUtils.containsIgnoreCase(this.getIgnoreList(), "DISABLE"))) {
            ServerUtils.logInfo("The following plugins will be ignored { " + this.getIgnoreList() + " }");
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("Vault") && !this.getVault().vaultEnabled()) {
            ServerUtils.logDebug("{VaultAPI} An error has occurred while setting up enabling Vault support, no economy plugin detected.");
        }
    }

    public void addCustomCharts(@Nonnull MetricsAPI metrics) {
        metrics.addCustomChart(new MetricsAPI.SimplePie("language", () -> Core.getCore().getLang().getLanguage()));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.authMeEnabled() ? "AuthMe" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.nickAPIEnabled() ? "NickAPI" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.exploitFixerEnabled() ? "ExploitFixer" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.hyperVerseEnabled() ? "HeadDatabase" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.hyperVerseEnabled() ? "Hyperverse" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.coreEnabled() ? "Multiverse-Core" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.inventoryEnabled() ? "Multiverse-Inventories" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.myWorldsEnabled() ? "My Worlds" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.perInventoryEnabled() ? "PerWorldInventory" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.perPluginsEnabled() ? "PerWorldPlugins" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.placeHolderEnabled() ? "PlaceholderAPI" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.protocolEnabled() ? "ProtocolLib" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.skinsRestorerEnabled() ? "SkinsRestorer" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.citizensEnabled() ? "Citizens" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.chestSortEnabled() ? "ChestSort" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.tokenEnchantEnabled() ? "TokenEnchant" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.getVault().vaultEnabled() ? "Vault" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.getGuard().guardEnabled() ? "WorldGuard" : ""));
        metrics.addCustomChart(new MetricsAPI.SimplePie("softDepend", () -> this.xInventoryEnabled() ? "xInventories" : ""));
    }

    public void refresh() {
        depends = new DependAPI();
    }
}

