/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class GuardAPI {
    private static GuardAPI guard;
    private final List<String> localeRegions = new ArrayList<String>();
    private Object worldGuard = null;
    private WorldGuardPlugin worldGuardPlugin = null;
    private Object regionContainer = null;
    private Method getRegionContainer = null;
    private Method getWorldAdapter = null;
    private Method getRegionManager = null;
    private Constructor<?> vectorConstructor = null;
    private Method getVector = null;
    private int guardVersion = 0;

    public GuardAPI() {
        this.setPlatform();
    }

    public static GuardAPI getGuard(boolean regen) {
        if (guard == null || regen) {
            guard = new GuardAPI();
        }
        return guard;
    }

    private void setPlatform() {
        if (Core.getCore().isStarted()) {
            if (this.guardEnabled()) {
                this.enableGuard();
                if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") instanceof WorldGuardPlugin) {
                    this.worldGuardPlugin = (WorldGuardPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
                    try {
                        Class<?> worldGuard = ReflectionUtils.getCanonicalClass("com.sk89q.worldguard.WorldGuard");
                        Method getInstance = worldGuard.getMethod("getInstance", new Class[0]);
                        this.worldGuard = getInstance.invoke(null, new Object[0]);
                    }
                    catch (Exception worldGuard) {
                        // empty catch block
                    }
                }
                if (this.worldGuard != null) {
                    try {
                        Method getPlatForm = this.worldGuard.getClass().getMethod("getPlatform", new Class[0]);
                        Object platform = getPlatForm.invoke(this.worldGuard, new Object[0]);
                        Method getRegionContainer = platform.getClass().getMethod("getRegionContainer", new Class[0]);
                        this.regionContainer = getRegionContainer.invoke(platform, new Object[0]);
                        Class<?> getWorldEditWorld = ReflectionUtils.getCanonicalClass("com.sk89q.worldedit.world.World");
                        Class<?> getWorldEditAdapter = ReflectionUtils.getCanonicalClass("com.sk89q.worldedit.bukkit.BukkitAdapter");
                        this.getWorldAdapter = getWorldEditAdapter.getMethod("adapt", World.class);
                        this.getRegionContainer = this.regionContainer.getClass().getMethod("get", getWorldEditWorld);
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{GuardAPI} Failed to bind to WorldGuard, integration will not work!");
                        ServerUtils.sendDebugTrace(e);
                        this.regionContainer = null;
                        return;
                    }
                }
                try {
                    Method getRegionContainer = this.worldGuardPlugin.getClass().getMethod("getRegionContainer", new Class[0]);
                    this.regionContainer = getRegionContainer.invoke((Object)this.worldGuardPlugin, new Object[0]);
                    this.getRegionContainer = this.regionContainer.getClass().getMethod("get", World.class);
                }
                catch (Exception e) {
                    ServerUtils.logSevere("{GuardAPI} Failed to bind to WorldGuard, integration will not work!");
                    ServerUtils.sendDebugTrace(e);
                    this.regionContainer = null;
                    return;
                }
                try {
                    Class<?> vectorClass = ReflectionUtils.getCanonicalClass("com.sk89q.worldedit.Vector");
                    this.vectorConstructor = vectorClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                    this.getRegionManager = RegionManager.class.getMethod("getApplicableRegions", vectorClass);
                }
                catch (Exception e) {
                    try {
                        Class<?> vectorClass = ReflectionUtils.getCanonicalClass("com.sk89q.worldedit.math.BlockVector3");
                        this.getVector = vectorClass.getMethod("at", Double.TYPE, Double.TYPE, Double.TYPE);
                        this.getRegionManager = RegionManager.class.getMethod("getApplicableRegions", vectorClass);
                    }
                    catch (Exception e2) {
                        ServerUtils.logSevere("{GuardAPI} Failed to bind to WorldGuard (no Vector class?), integration will not work!");
                        ServerUtils.sendDebugTrace(e);
                        this.regionContainer = null;
                        return;
                    }
                }
                if (this.regionContainer == null) {
                    ServerUtils.logSevere("{GuardAPI} Failed to find RegionContainer, WorldGuard integration will not function!");
                }
            }
        } else {
            SchedulerUtils.runLater(1L, this::setPlatform);
        }
    }

    private void enableGuard() {
        try {
            this.guardVersion = Integer.parseInt(Objects.requireNonNull(Bukkit.getServer().getPluginManager().getPlugin("WorldGuard")).getDescription().getVersion().replace(".", "").substring(0, 3));
        }
        catch (Exception e) {
            this.guardVersion = 622;
        }
    }

    public boolean guardEnabled() {
        boolean isHookable;
        boolean pluginEnabled = Bukkit.getServer().getPluginManager().isPluginEnabled("WorldEdit") && Bukkit.getServer().getPluginManager().isPluginEnabled("WorldGuard");
        boolean pluginExists = Bukkit.getServer().getPluginManager().getPlugin("WorldEdit") != null && Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null;
        boolean bl = isHookable = !StringUtils.containsIgnoreCase(Core.getCore().getDependencies().getIgnoreList(), "WorldEdit") && !StringUtils.containsIgnoreCase(Core.getCore().getDependencies().getIgnoreList(), "WorldGuard");
        return (Core.getCore().isStarted() ? pluginEnabled : pluginExists) && isHookable;
    }

    public int guardVersion() {
        return this.guardVersion;
    }

    @Nonnull
    public Map<String, ProtectedRegion> getRegions(@Nonnull World world) {
        return Objects.requireNonNull(this.getRegionManager(world)).getRegions();
    }

    @Nonnull
    public String getRegionAtLocation(@Nonnull Location location) {
        ApplicableRegionSet set = null;
        StringBuilder regionSet = new StringBuilder();
        try {
            set = this.getRegionSet(location);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        if (set == null) {
            return regionSet.toString();
        }
        for (ProtectedRegion r : set) {
            if (regionSet.length() == 0) {
                regionSet.append(r.getId());
                continue;
            }
            regionSet.append(", ").append(r.getId());
        }
        return regionSet.toString();
    }

    @Nullable
    private ApplicableRegionSet getRegionSet(@Nonnull Location location) {
        RegionManager regionManager = this.getRegionManager(Objects.requireNonNull(location.getWorld()));
        if (regionManager == null || !this.guardEnabled()) {
            return null;
        }
        try {
            Object vector = this.getVector == null ? this.vectorConstructor.newInstance(location.getX(), location.getY(), location.getZ()) : this.getVector.invoke(null, location.getX(), location.getY(), location.getZ());
            return (ApplicableRegionSet)this.getRegionManager.invoke((Object)regionManager, vector);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{GuardAPI} An error occurred looking up a WorldGuard ApplicableRegionSet.");
            ServerUtils.sendDebugTrace(e);
            return null;
        }
    }

    @Nullable
    private RegionManager getRegionManager(@Nonnull World world) {
        if (this.regionContainer == null || this.getRegionContainer == null) {
            return null;
        }
        RegionManager regionManager = null;
        try {
            if (this.getWorldAdapter != null) {
                Object worldEditWorld = this.getWorldAdapter.invoke(null, world);
                regionManager = (RegionManager)this.getRegionContainer.invoke(this.regionContainer, worldEditWorld);
            } else {
                regionManager = (RegionManager)this.getRegionContainer.invoke(this.regionContainer, world);
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{GuardAPI} An error occurred looking up a WorldGuard RegionManager.");
            ServerUtils.sendDebugTrace(e);
        }
        return regionManager;
    }

    private boolean isLocaleRegion(@Nonnull String checkRegion) {
        for (String region : this.localeRegions) {
            if (!region.equalsIgnoreCase(checkRegion) && !region.equalsIgnoreCase("UNDEFINED")) continue;
            return true;
        }
        return false;
    }

    public void addLocaleRegion(@Nonnull String region) {
        if (!this.isLocaleRegion(region)) {
            this.localeRegions.add(region);
        }
    }
}

