/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.ChatComponent;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class LanguageAPI {
    private static LanguageAPI lang;
    private Lang langType = Lang.ENGLISH;
    private String langPrefix = Core.getCore().getPlugin().getName();

    @Nonnull
    public static LanguageAPI getLang() {
        if (lang == null) {
            lang = new LanguageAPI();
            lang.langFile();
        }
        return lang;
    }

    public void dispatchMessage(@Nonnull CommandSender sender, @Nonnull String langMessage) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        langMessage = StringUtils.translateLayout(langMessage, player, new PlaceHolder[0]);
        if (sender instanceof ConsoleCommandSender) {
            langMessage = ChatColor.stripColor((String)langMessage);
        }
        sender.sendMessage(langMessage);
    }

    public void dispatchMessage(@Nonnull CommandSender sender, @Nonnull String langMessage, @Nonnull String hoverMessage, @Nonnull String clickMessage, @Nonnull ChatComponent.ClickAction action) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        langMessage = new PlaceHolder().setPlaceholders(langMessage);
        langMessage = StringUtils.translateLayout(langMessage, player, new PlaceHolder[0]);
        hoverMessage = StringUtils.translateLayout(hoverMessage, player, new PlaceHolder[0]);
        clickMessage = StringUtils.translateLayout(clickMessage, player, new PlaceHolder[0]);
        if (sender instanceof ConsoleCommandSender) {
            langMessage = ChatColor.stripColor((String)langMessage);
            sender.sendMessage(langMessage);
        } else if (ServerUtils.hasPreciseUpdate("1_8_8")) {
            ChatComponent.TextSection textComponent = ChatComponent.of(langMessage);
            ChatComponent.HoverEvent hoverEvent = new ChatComponent.HoverEvent(ChatComponent.of(hoverMessage));
            textComponent.hoverEvent(hoverEvent);
            ChatComponent.ClickEvent clickEvent = new ChatComponent.ClickEvent();
            clickEvent.action(action);
            clickEvent.click(clickMessage);
            textComponent.clickEvent(clickEvent);
            ChatComponent.sendTo(textComponent, player);
        } else {
            sender.sendMessage(langMessage);
        }
    }

    public void sendLangMessage(@Nonnull String nodeLocation, @Nonnull CommandSender sender, PlaceHolder ... placeHolder) {
        String langMessage;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        String string = sender.isPermissionSet(Core.getCore().getPlugin().getName().toLowerCase() + ".lang." + nodeLocation) ? (sender.hasPermission(Core.getCore().getPlugin().getName().toLowerCase() + ".lang." + nodeLocation) ? this.getLangMessage(nodeLocation) : null) : (langMessage = this.getLangMessage(nodeLocation));
        if (langMessage != null && !langMessage.isEmpty()) {
            String[] langLines;
            langMessage = placeHolder.length > 0 ? placeHolder[0].setPlaceholders(langMessage) : langMessage;
            langMessage = StringUtils.translateLayout(langMessage, player, new PlaceHolder[0]).replace(" \\n ", " \\n").replace(" /n ", " \\n").replace(" /n", " \\n");
            String[] stringArray = langLines = langMessage.split(Pattern.quote(" \\n"));
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String langLine;
                String langStrip = langLine = stringArray[i];
                if (sender instanceof ConsoleCommandSender) {
                    langStrip = ChatColor.stripColor((String)langStrip);
                }
                if (this.isConsoleMessage(nodeLocation)) {
                    ServerUtils.logInfo(ChatColor.stripColor((String)langLine));
                    continue;
                }
                sender.sendMessage(langStrip);
            }
        }
    }

    @Nonnull
    public String getLangMessage(@Nonnull String nodeLocation) {
        String message = Core.getCore().getConfig(this.langType.nodeLocation()).getString(nodeLocation);
        return message != null && !message.isEmpty() ? message : "";
    }

    @Nonnull
    public String getString(@Nonnull String nodeLocation) {
        return this.getLangMessage(nodeLocation);
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String nodeLocation) {
        Object value = Core.getCore().getConfig(this.langType.nodeLocation()).get(nodeLocation);
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> result = new ArrayList<String>();
            for (Object obj : list) {
                if (!(obj instanceof String)) continue;
                result.add((String)obj);
            }
            return result.isEmpty() ? Collections.singletonList("") : result;
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        return Collections.singletonList("");
    }

    private boolean isConsoleMessage(@Nonnull String nodeLocation) {
        return nodeLocation.equalsIgnoreCase("Commands.Updates.checking") || nodeLocation.equalsIgnoreCase("Commands.Updates.forcing");
    }

    @Nonnull
    public String getLanguage() {
        return this.langType.name().substring(0, 1).toUpperCase() + this.langType.name().substring(1).toLowerCase();
    }

    public void setLanguage(@Nonnull String lang) {
        if (lang.equalsIgnoreCase("tw")) {
            this.langType = Lang.TWCHINESE;
        } else if (lang.equalsIgnoreCase("cn")) {
            this.langType = Lang.CNCHINESE;
        } else if (lang.equalsIgnoreCase("en")) {
            this.langType = Lang.ENGLISH;
        } else if (lang.equalsIgnoreCase("es")) {
            this.langType = Lang.SPANISH;
        } else if (lang.equalsIgnoreCase("ru")) {
            this.langType = Lang.RUSSIAN;
        } else if (lang.equalsIgnoreCase("fr")) {
            this.langType = Lang.FRENCH;
        } else if (lang.equalsIgnoreCase("nl")) {
            this.langType = Lang.DUTCH;
        } else if (lang.equalsIgnoreCase("pt")) {
            this.langType = Lang.PORTUGUESE;
        } else if (lang.equalsIgnoreCase("pl")) {
            this.langType = Lang.POLISH;
        } else if (lang.equalsIgnoreCase("it")) {
            this.langType = Lang.ITALIAN;
        } else if (lang.equalsIgnoreCase("de")) {
            this.langType = Lang.GERMAN;
        }
    }

    @Nonnull
    public String getFile() {
        return this.langType.nodeLocation();
    }

    public void setPrefix() {
        String prefix = Core.getCore().getConfig(this.langType.nodeLocation()).getString("Prefix");
        this.langPrefix = StringUtils.colorFormat(prefix == null ? "" : prefix);
    }

    public String getPrefix() {
        return this.langPrefix;
    }

    public void langFile() {
        String lang = Core.getCore().getConfig("config.yml").getString("Language");
        if (lang != null) {
            lang = lang.replace(" ", "");
            if (StringUtils.containsValue(Core.getCore().getData().getLanguages(), lang)) {
                if (lang.equalsIgnoreCase("TraditionalChinese") || lang.equalsIgnoreCase("TwChinese")) {
                    this.setLanguage("tw");
                } else if (lang.equalsIgnoreCase("SimplifiedChinese") || lang.equalsIgnoreCase("CnChinese") || lang.equalsIgnoreCase("Chinese")) {
                    this.setLanguage("cn");
                } else if (StringUtils.containsIgnoreCase(lang, "Chinese")) {
                    this.setLanguage("cn");
                } else if (lang.equalsIgnoreCase("Spanish")) {
                    this.setLanguage("es");
                } else if (lang.equalsIgnoreCase("Russian")) {
                    this.setLanguage("ru");
                } else if (lang.equalsIgnoreCase("French")) {
                    this.setLanguage("fr");
                } else if (lang.equalsIgnoreCase("Dutch")) {
                    this.setLanguage("nl");
                } else if (lang.equalsIgnoreCase("Portuguese")) {
                    this.setLanguage("pt");
                } else if (lang.equalsIgnoreCase("Polish")) {
                    this.setLanguage("pl");
                } else if (lang.equalsIgnoreCase("Italian")) {
                    this.setLanguage("it");
                } else if (lang.equalsIgnoreCase("German")) {
                    this.setLanguage("de");
                } else {
                    this.setLanguage("en");
                }
            } else {
                ServerUtils.logSevere("{Lang} The language " + lang + " was specified but could not be found!");
                ServerUtils.logSevere("{Lang} Please check the language specified in the config.yml for proper spelling");
                ServerUtils.logSevere("{Lang} Defaulting to the English language ...");
                this.setLanguage("en");
            }
        } else {
            this.setLanguage("en");
        }
    }

    public void refresh() {
        lang = new LanguageAPI();
        lang.langFile();
    }

    private static enum Lang {
        DEFAULT("en-lang.yml", 0),
        ENGLISH("en-lang.yml", 1),
        SPANISH("es-lang.yml", 2),
        TWCHINESE("tw-lang.yml", 3),
        CNCHINESE("cn-lang.yml", 4),
        RUSSIAN("ru-lang.yml", 5),
        FRENCH("fr-lang.yml", 6),
        DUTCH("nl-lang.yml", 7),
        PORTUGUESE("pt-lang.yml", 8),
        POLISH("pl-lang.yml", 9),
        ITALIAN("it-lang.yml", 10),
        GERMAN("de-lang.yml", 11);

        private final String nodeLocation;

        private Lang(String nodeLocation, int i) {
            this.nodeLocation = nodeLocation;
        }

        private String nodeLocation() {
            return this.nodeLocation;
        }
    }
}

