/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.api;

import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultAPI {
    private static VaultAPI vault;
    private Economy econ = null;

    public VaultAPI() {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.setupEconomy();
        }
    }

    @Nonnull
    public static VaultAPI getVault(boolean regen) {
        if (vault == null || regen) {
            vault = new VaultAPI();
        }
        return vault;
    }

    private void setupEconomy() {
        try {
            if (!Bukkit.getServer().getPluginManager().isPluginEnabled("Vault")) {
                if (!Core.getCore().isStarted()) {
                    SchedulerUtils.runLater(1L, this::setupEconomy);
                }
            } else {
                RegisteredServiceProvider rsp = Core.getCore().getPlugin().getServer().getServicesManager().getRegistration(Economy.class);
                if (rsp == null) {
                    return;
                }
                this.econ = (Economy)rsp.getProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nonnull
    public Economy getEconomy() {
        return this.econ;
    }

    public boolean vaultEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("Vault") && this.econ != null;
    }

    public double getBalance(@Nonnull Player player) {
        return this.econ.getBalance((OfflinePlayer)player);
    }

    public void withdrawBalance(@Nonnull Player player, double cost) {
        this.econ.withdrawPlayer((OfflinePlayer)player, cost);
    }
}

