/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.interfaces;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.interfaces.types.Container;
import me.RockinChaos.itemjoin.core.utils.protocol.ProtocolManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Query {
    private final Player player;
    private final Executor mainThreadExecutor;
    private final Object titleComponent;
    private final ItemStack[] initialContents;
    private final boolean preventClose;
    private final Set<Integer> interactableSlots;
    private final Consumer<StateSnapshot> closeListener;
    private final boolean concurrentClickHandlerExecution;
    private final ClickHandler clickHandler;
    private final AnvilInventory inventoryListener = new AnvilInventory();
    private final PrepareAnvil typingListener = new PrepareAnvil();
    private final PrepareAnvil_LEGACY typingListener_LEGACY = new PrepareAnvil_LEGACY();
    private Inventory inventory;
    private boolean open;
    private Container container;

    private Query(Player player, Executor mainThreadExecutor, Object titleComponent, ItemStack[] initialContents, boolean preventClose, Set<Integer> interactableSlots, Consumer<StateSnapshot> closeListener, boolean concurrentClickHandlerExecution, ClickHandler clickHandler) {
        this.player = player;
        this.mainThreadExecutor = mainThreadExecutor;
        this.titleComponent = titleComponent;
        this.initialContents = initialContents;
        this.preventClose = preventClose;
        this.interactableSlots = Collections.unmodifiableSet(interactableSlots);
        this.closeListener = closeListener;
        this.concurrentClickHandlerExecution = concurrentClickHandlerExecution;
        this.clickHandler = clickHandler;
    }

    private void openInventory() {
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)Core.getCore().getPlugin());
        if (ServerUtils.hasSpecificUpdate("1_13")) {
            Bukkit.getPluginManager().registerEvents((Listener)this.typingListener, (Plugin)Core.getCore().getPlugin());
        } else {
            if (ProtocolManager.isDead()) {
                ProtocolManager.handleProtocols();
            }
            Bukkit.getPluginManager().registerEvents((Listener)this.typingListener_LEGACY, (Plugin)Core.getCore().getPlugin());
        }
        this.container = new Container(this.player, this.titleComponent, this.initialContents[this.initialContents.length - 1]);
        this.container.handleInventoryCloseEvent(this.player);
        this.container.setActiveContainerDefault(this.player);
        this.inventory = this.container.getBukkitInventory();
        for (int i = 0; i < this.initialContents.length; ++i) {
            this.inventory.setItem(i, this.initialContents[i]);
        }
        this.container.sendPacketOpenWindow(this.player, this.titleComponent);
        this.container.setActiveContainer(this.player);
        this.container.setActiveContainerId();
        this.container.addActiveContainerSlotListener(this.player);
        this.open = true;
    }

    public void closeInventory() {
        this.closeInventory(true);
    }

    private void closeInventory(boolean sendClosePacket) {
        if (!this.open) {
            return;
        }
        this.open = false;
        HandlerList.unregisterAll((Listener)this.inventoryListener);
        if (ServerUtils.hasSpecificUpdate("1_11")) {
            HandlerList.unregisterAll((Listener)this.typingListener);
        } else {
            HandlerList.unregisterAll((Listener)this.typingListener_LEGACY);
        }
        if (sendClosePacket) {
            this.container.handleInventoryCloseEvent(this.player);
            this.container.setActiveContainerDefault(this.player);
            this.container.sendPacketCloseWindow(this.player);
        }
        if (this.closeListener != null) {
            this.closeListener.accept(StateSnapshot.fromQuery(this));
        }
    }

    public void setTitle(String literalTitle, boolean preserveRenameText) {
        Validate.notNull((Object)literalTitle, (String)"literalTitle cannot be null");
        this.setTitle(ReflectionUtils.literalChatComponent(literalTitle), preserveRenameText);
    }

    public void setJsonTitle(String json, boolean preserveRenameText) {
        Validate.notNull((Object)json, (String)"json cannot be null");
        this.setTitle(ReflectionUtils.jsonChatComponent(json), preserveRenameText);
    }

    private void setTitle(Object title, boolean preserveRenameText) {
        if (!ServerUtils.hasSpecificUpdate("1_14")) {
            return;
        }
        String renameText = this.container.getRenameText();
        this.container.sendPacketOpenWindow(this.player, title);
        if (preserveRenameText) {
            this.container.setRenameText(renameText);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @FunctionalInterface
    public static interface ClickHandler
    extends BiFunction<Integer, StateSnapshot, CompletableFuture<List<ResponseAction>>> {
    }

    private class AnvilInventory
    implements Listener {
        private boolean clickHandlerRunning = false;

        private AnvilInventory() {
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (!event.getInventory().equals(Query.this.inventory)) {
                return;
            }
            Player clicker = (Player)event.getWhoClicked();
            Inventory clickedInventory = event.getClickedInventory();
            if (clickedInventory != null && clickedInventory.equals(clicker.getInventory()) && event.getClick().equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
                return;
            }
            int rawSlot = event.getRawSlot();
            if (rawSlot < 3 || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                event.setCancelled(!Query.this.interactableSlots.contains(rawSlot));
                if (this.clickHandlerRunning && !Query.this.concurrentClickHandlerExecution) {
                    return;
                }
                CompletableFuture actionsFuture = (CompletableFuture)Query.this.clickHandler.apply(rawSlot, StateSnapshot.fromQuery(Query.this));
                Consumer<List> actionsConsumer = actions -> {
                    for (ResponseAction action : actions) {
                        action.accept(Query.this, clicker);
                    }
                };
                if (actionsFuture.isDone()) {
                    ((CompletableFuture)actionsFuture.thenAccept(actionsConsumer)).join();
                } else {
                    this.clickHandlerRunning = true;
                    ((CompletableFuture)actionsFuture.thenAcceptAsync(actionsConsumer, Query.this.mainThreadExecutor)).handle((results, exception) -> {
                        if (exception != null) {
                            ServerUtils.logSevere("An exception occurred in the Query clickHandler");
                            ServerUtils.sendSevereThrowable(exception);
                        }
                        this.clickHandlerRunning = false;
                        return null;
                    });
                }
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent event) {
            if (event.getInventory().equals(Query.this.inventory)) {
                for (int slot : Slot.values()) {
                    if (!event.getRawSlots().contains(slot)) continue;
                    event.setCancelled(!Query.this.interactableSlots.contains(slot));
                    break;
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (Query.this.open && event.getInventory().equals(Query.this.inventory)) {
                Query.this.closeInventory(false);
                for (ItemStack item : event.getInventory().getContents()) {
                    event.getInventory().remove(item);
                }
                if (Query.this.preventClose) {
                    Query.this.mainThreadExecutor.execute(() -> Query.this.openInventory());
                }
            }
        }
    }

    private class PrepareAnvil
    implements Listener {
        private PrepareAnvil() {
        }

        @EventHandler
        public final void onPrepareAnvil(PrepareAnvilEvent event) {
            String renameText;
            if (event.getInventory().equals(Query.this.inventory) && (renameText = (String)CompatUtils.resolveByVersion("1_21", () -> event.getView().getRenameText(), () -> LegacyAPI.getRenameText(event))) != null) {
                Query.this.container.handleTyping(renameText);
                event.setResult(Query.this.container.getResult(CompatUtils.getPlayer(event), renameText));
                Query.this.container.removeCost(event);
                Query.this.container.setAction(false);
            }
        }
    }

    private class PrepareAnvil_LEGACY
    implements Listener {
        private PrepareAnvil_LEGACY() {
        }

        @EventHandler
        public final void onPrepareAnvil_LEGACY(me.RockinChaos.itemjoin.core.utils.protocol.events.PrepareAnvilEvent event) {
            if (event.getInventory().equals(Query.this.inventory)) {
                String renameText = event.getRenameText();
                Query.this.container.handleTyping(renameText);
                SchedulerUtils.runAsync(() -> {
                    event.setResult(Query.this.container.getResult(event.getPlayer(), renameText));
                    Query.this.container.setAction(false);
                    LegacyAPI.updateInventory(event.getPlayer());
                });
            }
        }
    }

    public static final class StateSnapshot {
        private final ItemStack leftItem;
        private final ItemStack rightItem;
        private final ItemStack outputItem;
        private final Player player;

        public StateSnapshot(@Nonnull ItemStack leftItem, @Nonnull ItemStack rightItem, @Nonnull ItemStack outputItem, @Nonnull Player player) {
            this.leftItem = leftItem;
            this.rightItem = rightItem;
            this.outputItem = outputItem;
            this.player = player;
        }

        @Nonnull
        private static StateSnapshot fromQuery(@Nonnull Query query) {
            Inventory inventory = query.getInventory();
            ItemStack inputLeft = inventory.getItem(0);
            ItemStack inputRight = inventory.getItem(1);
            ItemStack output = inventory.getItem(2);
            return new StateSnapshot(inputLeft != null ? inputLeft.clone() : new ItemStack(Material.AIR), inputRight != null ? inputRight.clone() : new ItemStack(Material.AIR), output != null ? output.clone() : new ItemStack(Material.AIR), query.player);
        }

        @Nonnull
        public ItemStack getLeftItem() {
            return this.leftItem;
        }

        @Nonnull
        public ItemStack getRightItem() {
            return this.rightItem;
        }

        @Nonnull
        public ItemStack getOutputItem() {
            return this.outputItem;
        }

        @Nonnull
        public Player getPlayer() {
            return this.player;
        }

        @Nonnull
        public String getText() {
            ItemMeta itemMeta;
            String displayName = "";
            ItemStack stackFetch = this.leftItem;
            if (stackFetch.hasItemMeta() && (itemMeta = stackFetch.getItemMeta()) != null) {
                displayName = displayName.substring((displayName = itemMeta.getDisplayName()).startsWith("--> ") ? 4 : (displayName.startsWith("-->") ? 3 : (displayName.startsWith("-> ") ? 3 : (displayName.startsWith("->") ? 2 : (displayName.startsWith("--") ? 2 : (displayName.startsWith("-") ? 1 : 0))))));
                displayName = displayName.trim();
            }
            return displayName;
        }
    }

    public static class Slot {
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;
        private static final int[] values = new int[]{0, 1, 2};

        public static int[] values() {
            return values;
        }
    }

    @Deprecated
    public static class Response {
        @Deprecated
        public static List<ResponseAction> close() {
            return Collections.singletonList(ResponseAction.close());
        }

        @Deprecated
        public static List<ResponseAction> text(String text) {
            return Collections.singletonList(ResponseAction.replaceInputText(text));
        }

        @Deprecated
        public static List<ResponseAction> openInventory(Inventory inventory) {
            return Collections.singletonList(ResponseAction.openInventory(inventory));
        }
    }

    public static class Builder {
        private Executor mainThreadExecutor;
        private Consumer<StateSnapshot> closeListener;
        private boolean concurrentClickHandlerExecution = false;
        private ClickHandler clickHandler;
        private boolean preventClose = false;
        private Set<Integer> interactableSlots = Collections.emptySet();
        private Object titleComponent = ReflectionUtils.literalChatComponent("Repair & Name");
        private String itemText;
        private ItemStack itemLeft;
        private ItemStack itemRight;
        private ItemStack itemOutput;

        public Builder mainThreadExecutor(Executor executor) {
            Validate.notNull((Object)executor, (String)"Executor cannot be null");
            this.mainThreadExecutor = executor;
            return this;
        }

        public Builder preventClose() {
            this.preventClose = true;
            return this;
        }

        public Builder interactableSlots(int ... slots) {
            HashSet<Integer> newValue = new HashSet<Integer>();
            for (int slot : slots) {
                newValue.add(slot);
            }
            this.interactableSlots = newValue;
            return this;
        }

        public Builder onClose(Consumer<StateSnapshot> closeListener) {
            Validate.notNull(closeListener, (String)"closeListener cannot be null");
            this.closeListener = closeListener;
            return this;
        }

        public Builder onClickAsync(ClickHandler clickHandler) {
            Validate.notNull((Object)clickHandler, (String)"click function cannot be null");
            this.clickHandler = clickHandler;
            return this;
        }

        public Builder allowConcurrentClickHandlerExecution() {
            this.concurrentClickHandlerExecution = true;
            return this;
        }

        public Builder onClick(BiFunction<Integer, StateSnapshot, List<ResponseAction>> clickHandler) {
            Validate.notNull(clickHandler, (String)"click function cannot be null");
            this.clickHandler = (slot, stateSnapshot) -> CompletableFuture.completedFuture((List)clickHandler.apply((Integer)slot, (StateSnapshot)stateSnapshot));
            return this;
        }

        public Builder text(String text) {
            Validate.notNull((Object)text, (String)"Text cannot be null");
            this.itemText = "->" + text;
            return this;
        }

        public Builder title(String title) {
            Validate.notNull((Object)title, (String)"title cannot be null");
            this.titleComponent = ReflectionUtils.literalChatComponent(title);
            return this;
        }

        public Builder jsonTitle(String json) {
            Validate.notNull((Object)json, (String)"json cannot be null");
            this.titleComponent = ReflectionUtils.jsonChatComponent(json);
            return this;
        }

        public Builder itemLeft(ItemStack item) {
            Validate.notNull((Object)item, (String)"item cannot be null");
            this.itemLeft = item;
            return this;
        }

        public Builder itemRight(ItemStack item) {
            this.itemRight = item;
            return this;
        }

        public Builder itemOutput(ItemStack item) {
            this.itemOutput = item;
            return this;
        }

        public Query open(Player player) {
            Validate.notNull((Object)this.clickHandler, (String)"click handler cannot be null");
            Validate.notNull((Object)player, (String)"Player cannot be null");
            if (this.itemText != null) {
                ItemMeta paperMeta;
                if (this.itemLeft == null) {
                    this.itemLeft = new ItemStack(Material.PAPER);
                }
                if ((paperMeta = this.itemLeft.getItemMeta()) != null) {
                    paperMeta.setDisplayName(this.itemText);
                    this.itemLeft.setItemMeta(paperMeta);
                }
            }
            if (this.mainThreadExecutor == null) {
                this.mainThreadExecutor = SchedulerUtils::run;
            }
            Query query = new Query(player, this.mainThreadExecutor, this.titleComponent, new ItemStack[]{this.itemLeft, this.itemRight, this.itemOutput}, this.preventClose, this.interactableSlots, this.closeListener, this.concurrentClickHandlerExecution, this.clickHandler);
            query.openInventory();
            return query;
        }
    }

    @FunctionalInterface
    public static interface ResponseAction
    extends BiConsumer<Query, Player> {
        public static ResponseAction replaceInputText(String text) {
            Validate.notNull((Object)text, (String)"text cannot be null");
            String inputText = "-->" + text;
            return (query, player) -> {
                ((Query)query).container.setLeftText(text);
                ItemStack item = query.getInventory().getItem(0);
                if (item == null) {
                    item = query.getInventory().getItem(2);
                }
                if (item == null) {
                    throw new IllegalStateException("replaceInputText can only be used if slots OUTPUT or INPUT_LEFT are not empty");
                }
                ItemStack cloned = item.clone();
                ItemMeta meta = cloned.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(inputText);
                    cloned.setItemMeta(meta);
                }
                ((Query)query).container.setAction(true);
                query.getInventory().setItem(0, cloned);
            };
        }

        public static ResponseAction replaceInputText(String inputText, String outText) {
            Validate.notNull((Object)inputText, (String)"inputText cannot be null");
            Validate.notNull((Object)outText, (String)"outText cannot be null");
            String leftText = "-->" + inputText;
            return (query, player) -> {
                ((Query)query).container.setLeftText(inputText);
                ((Query)query).container.setOutText(outText);
                ItemStack leftItem = query.getInventory().getItem(0);
                ItemStack outItem = query.getInventory().getItem(2);
                if (leftItem == null) {
                    leftItem = query.getInventory().getItem(2);
                }
                if (outItem == null) {
                    outItem = query.getInventory().getItem(0);
                }
                if (leftItem == null) {
                    throw new IllegalStateException("replaceInputText can only be used if slots OUTPUT or INPUT_LEFT are not empty");
                }
                ItemStack leftItemCloned = leftItem.clone();
                ItemMeta leftMeta = leftItemCloned.getItemMeta();
                if (leftMeta != null) {
                    leftMeta.setDisplayName(leftText);
                    leftItemCloned.setItemMeta(leftMeta);
                }
                ((Query)query).container.setAction(true);
                query.getInventory().setItem(0, leftItemCloned);
                if (!ServerUtils.hasSpecificUpdate("1_11") && outItem != null) {
                    ItemStack outItemCloned = outItem.clone();
                    ItemMeta outMeta = outItemCloned.getItemMeta();
                    if (outMeta != null) {
                        outMeta.setDisplayName(outText + ((Query)query).container.getSpacers());
                        outItemCloned.setItemMeta(outMeta);
                    }
                    query.getInventory().setItem(2, outItemCloned);
                }
            };
        }

        public static ResponseAction updateTitle(String literalTitle, boolean preserveRenameText) {
            Validate.notNull((Object)literalTitle, (String)"literalTitle cannot be null");
            return (query, player) -> query.setTitle(literalTitle, preserveRenameText);
        }

        public static ResponseAction updateJsonTitle(String json, boolean preserveRenameText) {
            Validate.notNull((Object)json, (String)"json cannot be null");
            return (query, player) -> query.setJsonTitle(json, preserveRenameText);
        }

        public static ResponseAction openInventory(Inventory otherInventory) {
            Validate.notNull((Object)otherInventory, (String)"otherInventory cannot be null");
            return (query, player) -> player.openInventory(otherInventory);
        }

        public static ResponseAction close() {
            return (query, player) -> query.closeInventory();
        }

        public static ResponseAction run(Runnable runnable) {
            Validate.notNull((Object)runnable, (String)"runnable cannot be null");
            return (query, player) -> runnable.run();
        }
    }
}

