/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.interfaces.types;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.Core;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.interfaces.Query;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public class Button {
    private final ItemStack itemStack;
    private int counter = 0;
    private final int ID = this.counter++;
    private Consumer<InventoryClickEvent> clickAction;
    private Consumer<AsyncPlayerChatEvent> chatAction;
    private Consumer<Query.Builder> typingAction;
    private Query activeQuery;

    public Button(@Nonnull ItemStack itemStack) {
        this(itemStack, event -> {});
    }

    public Button(@Nonnull ItemStack itemStack, @Nonnull Consumer<InventoryClickEvent> clickAction) {
        this.itemStack = itemStack;
        this.clickAction = clickAction;
    }

    public Button(@Nonnull ItemStack itemStack, @Nonnull Consumer<InventoryClickEvent> clickAction, @Nonnull Consumer<AsyncPlayerChatEvent> chatAction) {
        this.itemStack = itemStack;
        this.clickAction = clickAction;
        this.chatAction = chatAction;
    }

    public Button(@Nonnull ItemStack itemStack, @Nonnull Consumer<InventoryClickEvent> clickAction, @Nonnull Consumer<Query.Builder> typingAction, int placeholder) {
        this.itemStack = itemStack;
        this.clickAction = clickAction;
        this.typingAction = typingAction;
    }

    public Button(@Nonnull ItemStack itemStack, boolean tempIdentifier, @Nonnull Consumer<InventoryClickEvent> clickAction) {
        this.itemStack = itemStack;
        this.clickAction = clickAction;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setClickAction(@Nonnull Consumer<InventoryClickEvent> clickAction) {
        this.clickAction = clickAction;
    }

    public void setChatAction(@Nonnull Consumer<AsyncPlayerChatEvent> chatAction) {
        this.chatAction = chatAction;
    }

    public void setTypingAction(@Nonnull Consumer<Query.Builder> typingAction) {
        this.typingAction = typingAction;
    }

    public void onClick(@Nonnull InventoryClickEvent event) {
        if (Core.getCore().getPlugin().isEnabled()) {
            SchedulerUtils.run(() -> this.clickAction.accept(event));
        }
    }

    public void onChat(@Nonnull AsyncPlayerChatEvent event) {
        if (Core.getCore().getPlugin().isEnabled()) {
            SchedulerUtils.run(() -> this.chatAction.accept(event));
        }
    }

    public void onTyping(@Nonnull Player player) {
        if (Core.getCore().getPlugin().isEnabled()) {
            Query.Builder builder = new Query.Builder().text(" ");
            SchedulerUtils.run(() -> {
                this.typingAction.accept(builder);
                this.activeQuery = builder.open(player);
            });
        }
    }

    public void closeQuery() {
        this.activeQuery.closeInventory();
    }

    public boolean chatEvent() {
        return this.chatAction != null;
    }

    public boolean typingEvent() {
        return this.typingAction != null;
    }

    public boolean equals(@Nonnull Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Button)) {
            return false;
        }
        Button button = (Button)obj;
        return this.ID == button.ID;
    }

    public int hashCode() {
        return Objects.hash(this.ID);
    }
}

