/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.protocol.packet.PacketContainer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public abstract class TinyProtocol {
    protected final Plugin plugin;
    private final AtomicInteger ID = new AtomicInteger(0);
    private final ReflectionUtils.MethodInvoker getPlayerHandle = ReflectionUtils.getMethod("{obc}.entity.CraftPlayer", "getHandle", new Class[0]);
    private final ReflectionUtils.FieldAccessor<Object> getConnection = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("EntityPlayer").getCanonicalName(), ReflectionUtils.MinecraftField.PlayerConnection.getField(), Object.class);
    private final ReflectionUtils.FieldAccessor<?> getManager = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("PlayerConnection"), null, ReflectionUtils.getMinecraftClass("NetworkManager"));
    private final ReflectionUtils.FieldAccessor<Channel> getChannel = ReflectionUtils.getField(ReflectionUtils.getMinecraftClass("NetworkManager").getCanonicalName(), Channel.class, 0);
    private final Class<Object> minecraftServerClass = ReflectionUtils.getUntypedClass(ReflectionUtils.getMinecraftClass("MinecraftServer").getCanonicalName());
    private final Class<Object> serverConnectionClass = ReflectionUtils.getUntypedClass(ReflectionUtils.getMinecraftClass("ServerConnection").getCanonicalName());
    private final ReflectionUtils.FieldAccessor<Object> getMinecraftServer = ReflectionUtils.getField("{obc}.CraftServer", this.minecraftServerClass, 0);
    private final ReflectionUtils.FieldAccessor<Object> getServerConnection = ReflectionUtils.getField(this.minecraftServerClass, this.serverConnectionClass, 0);
    private final ReflectionUtils.FieldAccessor<?> getNetworkMarkers = ReflectionUtils.getField(this.serverConnectionClass, List.class, 1);
    private final Class<?> PACKET_LOGIN_IN_START = ReflectionUtils.getMinecraftClass("PacketLoginInStart");
    private final Map<String, Channel> channelLookup = new MapMaker().weakValues().makeMap();
    private final Set<Channel> uninjectedChannels = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private final List<Channel> serverChannels = Lists.newArrayList();
    private final String handlerName;
    protected volatile boolean closed;
    private Listener listener;
    private List<Object> networkManagers;
    private ChannelInboundHandlerAdapter serverChannelHandler;
    private ChannelInitializer<Channel> beginInitProtocol;
    private ChannelInitializer<Channel> endInitProtocol;

    public TinyProtocol(@Nonnull Plugin plugin) {
        this.plugin = plugin;
        this.handlerName = this.getHandlerName();
        this.registerBukkitEvents();
        try {
            this.registerChannelHandler();
            this.registerPlayers(plugin);
        }
        catch (IllegalArgumentException ex) {
            plugin.getLogger().info("[TinyProtocol] Delaying server channel injection due to late bind.");
            SchedulerUtils.runAsync(() -> {
                this.registerChannelHandler();
                this.registerPlayers(plugin);
                plugin.getLogger().info("[TinyProtocol] Late bind injection successful.");
            });
        }
    }

    private void createServerChannelHandler() {
        final List<Object> syncManager = this.networkManagers;
        this.endInitProtocol = new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initChannel(Channel channel) {
                try {
                    List list = syncManager;
                    synchronized (list) {
                        if (!TinyProtocol.this.closed) {
                            channel.eventLoop().submit(() -> TinyProtocol.this.injectChannelInternal(channel));
                        }
                    }
                }
                catch (Exception e) {
                    TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Cannot inject incoming channel " + channel, e);
                }
            }
        };
        this.beginInitProtocol = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{TinyProtocol.this.endInitProtocol});
            }
        };
        this.serverChannelHandler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                Channel channel = (Channel)msg;
                channel.pipeline().addFirst(new ChannelHandler[]{TinyProtocol.this.beginInitProtocol});
                ctx.fireChannelRead(msg);
            }
        };
    }

    private void registerBukkitEvents() {
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerLogin(PlayerLoginEvent event) {
                if (TinyProtocol.this.closed) {
                    return;
                }
                try {
                    Channel channel = TinyProtocol.this.getChannel(event.getPlayer());
                    if (!TinyProtocol.this.uninjectedChannels.contains(channel)) {
                        TinyProtocol.this.injectPlayer(event.getPlayer());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @EventHandler
            public void onPluginDisable(PluginDisableEvent e) {
                if (e.getPlugin().equals(TinyProtocol.this.plugin)) {
                    TinyProtocol.this.close();
                }
            }
        };
        this.plugin.getServer().getPluginManager().registerEvents(this.listener, this.plugin);
    }

    private void registerChannelHandler() {
        Object mcServer = this.getMinecraftServer.get(Bukkit.getServer());
        Object serverConnection = this.getServerConnection.get(mcServer);
        boolean looking = true;
        this.networkManagers = (List)this.getNetworkMarkers.get(serverConnection);
        this.createServerChannelHandler();
        int i = 0;
        while (looking) {
            Object item;
            List list = ReflectionUtils.getField(serverConnection.getClass(), List.class, i).get(serverConnection);
            Iterator iterator = list.iterator();
            if (iterator.hasNext() && (item = iterator.next()) instanceof ChannelFuture) {
                Channel serverChannel = ((ChannelFuture)item).channel();
                this.serverChannels.add(serverChannel);
                serverChannel.pipeline().addFirst(new ChannelHandler[]{this.serverChannelHandler});
                looking = false;
            }
            ++i;
        }
    }

    private void unregisterChannelHandler() {
        if (this.serverChannelHandler == null) {
            return;
        }
        for (Channel serverChannel : this.serverChannels) {
            ChannelPipeline pipeline = serverChannel.pipeline();
            serverChannel.eventLoop().execute(() -> {
                try {
                    pipeline.remove((ChannelHandler)this.serverChannelHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private void registerPlayers(@Nonnull Plugin plugin) {
        PlayerHandler.forOnlinePlayers(this::injectPlayer);
    }

    public Object onPacketOutAsync(Player receiver, Channel channel, Object packet) {
        return packet;
    }

    public Object onPacketInAsync(Player sender, Channel channel, Object packet) {
        return packet;
    }

    public void sendPacket(@Nonnull Player player, @Nonnull Object packet) {
        this.sendPacket(this.getChannel(player), packet);
    }

    public void sendPacket(@Nonnull Channel channel, @Nonnull Object packet) {
        channel.pipeline().writeAndFlush(packet);
    }

    public void receivePacket(@Nonnull Player player, @Nonnull Object packet) {
        this.receivePacket(this.getChannel(player), packet);
    }

    public void receivePacket(@Nonnull Channel channel, @Nonnull Object packet) {
        channel.pipeline().context("encoder").fireChannelRead(packet);
    }

    @Nonnull
    protected String getHandlerName() {
        return "tiny-" + this.plugin.getName() + "-" + this.ID.incrementAndGet();
    }

    public void injectPlayer(@Nonnull Player player) {
        this.injectChannelInternal((Channel)this.getChannel((Player)player)).player = player;
    }

    public void injectChannel(@Nonnull Channel channel) {
        this.injectChannelInternal(channel);
    }

    @Nonnull
    private PacketInterceptor injectChannelInternal(@Nonnull Channel channel) {
        try {
            PacketInterceptor interceptor = (PacketInterceptor)channel.pipeline().get(this.handlerName);
            if (interceptor == null) {
                interceptor = new PacketInterceptor();
                try {
                    channel.pipeline().addBefore("packet_handler", this.handlerName, (ChannelHandler)interceptor);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                this.uninjectedChannels.remove(channel);
            }
            return interceptor;
        }
        catch (IllegalArgumentException e) {
            return (PacketInterceptor)channel.pipeline().get(this.handlerName);
        }
        catch (ClassCastException e) {
            channel.pipeline().remove(this.handlerName);
            return this.injectChannelInternal(channel);
        }
    }

    @Nonnull
    public Channel getChannel(@Nonnull Player player) {
        Channel channel = this.channelLookup.get(player.getName());
        if (channel == null) {
            Object connection = this.getConnection.get(this.getPlayerHandle.invoke(player, new Object[0]));
            Object manager = this.getManager.get(connection);
            channel = this.getChannel.get(manager);
            this.channelLookup.put(player.getName(), channel);
        }
        return channel;
    }

    public void uninjectPlayer(@Nonnull Player player) {
        this.uninjectChannel(this.getChannel(player));
    }

    public void uninjectChannel(@Nonnull Channel channel) {
        try {
            if (!this.closed) {
                this.uninjectedChannels.add(channel);
            }
            channel.eventLoop().execute(() -> {
                if (channel.pipeline().get(this.handlerName) != null) {
                    channel.pipeline().remove(this.handlerName);
                }
            });
        }
        catch (NoClassDefFoundError | NoSuchElementException throwable) {
            // empty catch block
        }
    }

    public boolean hasInjected(@Nonnull Player player) {
        return this.hasInjected(this.getChannel(player));
    }

    public boolean hasInjected(@Nonnull Channel channel) {
        return channel.pipeline().get(this.handlerName) != null;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.uninjectPlayer(player);
            }
            HandlerList.unregisterAll((Listener)this.listener);
            this.unregisterChannelHandler();
        }
    }

    @Nonnull
    public PacketContainer getContainer(@Nonnull Object packet) {
        return new PacketContainer(packet);
    }

    private final class PacketInterceptor
    extends ChannelDuplexHandler {
        public volatile Player player;

        private PacketInterceptor() {
        }

        public void channelRead(@Nonnull ChannelHandlerContext ctx, @Nonnull Object msg) throws Exception {
            Channel channel = ctx.channel();
            this.handleLoginStart(channel, msg);
            try {
                msg = TinyProtocol.this.onPacketInAsync(this.player, channel, msg);
            }
            catch (Exception e) {
                TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Error in onPacketInAsync().", e);
            }
            if (msg != null) {
                super.channelRead(ctx, msg);
            }
        }

        public void write(@Nonnull ChannelHandlerContext ctx, @Nonnull Object msg, @Nonnull ChannelPromise promise) throws Exception {
            try {
                msg = TinyProtocol.this.onPacketOutAsync(this.player, ctx.channel(), msg);
            }
            catch (Exception e) {
                TinyProtocol.this.plugin.getLogger().log(Level.SEVERE, "Error in onPacketOutAsync().", e);
            }
            if (msg != null) {
                super.write(ctx, msg, promise);
            }
        }

        private void handleLoginStart(@Nonnull Channel channel, @Nonnull Object packet) {
            if (TinyProtocol.this.PACKET_LOGIN_IN_START.isInstance(packet)) {
                GameProfile profile = ServerUtils.hasSpecificUpdate("1_19") ? new GameProfile(UUID.randomUUID(), ReflectionUtils.getField(TinyProtocol.this.PACKET_LOGIN_IN_START, String.class, 0).get(packet)) : ReflectionUtils.getField(TinyProtocol.this.PACKET_LOGIN_IN_START, GameProfile.class, 0).get(packet);
                TinyProtocol.this.channelLookup.put(CompatUtils.getName(profile), channel);
            }
        }
    }
}

