/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol.events;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerEvent;

public class PlayerCloneItemEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected final int slot;
    protected final ClickType clickType;
    private Event.Result useClone;

    public PlayerCloneItemEvent(@Nonnull Player who, int slot, @Nullable ClickType clickType) {
        super(who);
        this.slot = slot;
        this.clickType = clickType;
        this.useClone = clickType == null ? Event.Result.DENY : Event.Result.ALLOW;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.useClone() == Event.Result.DENY;
    }

    public void setCancelled(boolean cancel) {
        this.useClone(cancel ? Event.Result.DENY : (this.useClone() == Event.Result.DENY ? Event.Result.DEFAULT : this.useClone()));
    }

    public int getSlot() {
        return this.slot;
    }

    @Nonnull
    public ClickType getClick() {
        return this.clickType == null ? ClickType.UNKNOWN : this.clickType;
    }

    @Nonnull
    public Object getView() {
        return CompatUtils.getOpenInventory(this.player);
    }

    @Nonnull
    public InventoryType getInventoryType() {
        return CompatUtils.getInventoryType(CompatUtils.getOpenInventory(this.player));
    }

    @Nonnull
    public Event.Result useClone() {
        return this.useClone;
    }

    public void useClone(@Nonnull Event.Result useClone) {
        this.useClone = useClone;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

