/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol.events;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;

public class PlayerExitCreativeEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final CommandSender who;
    private final GameMode gamemode;
    private final boolean silent;
    private final boolean doSave;
    private Event.Result result;

    public PlayerExitCreativeEvent(@Nonnull CommandSender who, @Nullable Player altWho, @Nonnull GameMode gamemode, boolean silent, boolean doSave) {
        super(altWho != null ? altWho : (Player)who);
        this.who = who;
        this.gamemode = gamemode;
        this.silent = silent;
        this.doSave = doSave;
        this.result = Event.Result.ALLOW;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.returnResult() == Event.Result.DENY;
    }

    public void setCancelled(boolean cancel) {
        this.getResult(cancel ? Event.Result.DENY : (this.returnResult() == Event.Result.DENY ? Event.Result.DEFAULT : this.returnResult()));
    }

    @Nonnull
    public Event.Result returnResult() {
        return this.result;
    }

    public void getResult(@Nonnull Event.Result exitCreative) {
        this.result = exitCreative;
    }

    @Nonnull
    public CommandSender getSender() {
        return this.who;
    }

    @Nonnull
    public GameMode getGameMode() {
        return this.gamemode;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isDoSave() {
        return this.doSave;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

