/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.core.utils.protocol.events;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerPickItemEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected Inventory inventory;
    private boolean clonedInventory = false;
    private Event.Result usePickItem;

    public PlayerPickItemEvent(@Nonnull Player who, @Nullable Inventory inventory) {
        super(who);
        this.inventory = inventory;
        this.usePickItem = inventory == null ? Event.Result.DENY : Event.Result.ALLOW;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.usePickItem() == Event.Result.DENY;
    }

    public void setCancelled(boolean cancel) {
        this.usePickItem(cancel ? Event.Result.DENY : (this.usePickItem() == Event.Result.DENY ? Event.Result.DEFAULT : this.usePickItem()));
    }

    public int getPickSlot() {
        PlayerInventory inventory = super.getPlayer().getInventory();
        Block targetBlock = this.getTargetBlock();
        if (targetBlock != null) {
            for (int i = 8; i < 36; ++i) {
                if (this.inventory.getContents()[i] == null || this.inventory.getContents()[i].getType() == Material.AIR || !this.inventory.getContents()[i].getType().equals((Object)targetBlock.getType()) || (inventory.getContents()[i] == null || inventory.getContents()[i].getType() == Material.AIR || inventory.getContents()[i].getType().equals((Object)targetBlock.getType())) && inventory.getContents()[i] != null && inventory.getContents()[i].getType() != Material.AIR) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    public Block getTargetBlock() {
        this.cloneInventory();
        Block targetBlock = null;
        try {
            targetBlock = super.getPlayer().getTargetBlock(null, 200);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return targetBlock;
    }

    @Nonnull
    public ItemStack getPickHand() {
        this.cloneInventory();
        return PlayerHandler.getHandItem(super.getPlayer());
    }

    @Nonnull
    public ItemStack[] getContents() {
        this.cloneInventory();
        return this.inventory.getContents();
    }

    @Nonnull
    public Event.Result usePickItem() {
        return this.usePickItem;
    }

    public void usePickItem(@Nonnull Event.Result usePickItem) {
        this.usePickItem = usePickItem;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }

    public void cloneInventory() {
        if (!this.clonedInventory) {
            Inventory cloneInventory = Bukkit.createInventory((InventoryHolder)super.getPlayer(), (int)36);
            for (int i = 0; i < 36; ++i) {
                if (this.inventory.getContents()[i] == null || this.inventory.getContents()[i].getType() == Material.AIR) continue;
                cloneInventory.setItem(i, this.inventory.getContents()[i]);
            }
            this.inventory = cloneInventory;
            this.clonedInventory = true;
        }
    }
}

