/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ItemCommand {
    private final long delay;
    private final Executor executorType;
    private final Action actionType;
    private final ItemMap itemMap;
    private final List<Player> playerVoid = new ArrayList<Player>();
    private final List<Player> playerPending = new ArrayList<Player>();
    private int cycleTask = 0;
    private String command;
    private String listSection;

    private ItemCommand(String command, Action action, Executor executorType, ItemMap itemMap, long delay, String listSection) {
        this.command = command;
        this.actionType = action;
        this.executorType = executorType;
        this.itemMap = itemMap;
        this.delay = delay;
        this.listSection = listSection;
    }

    private static Action getExactAction(String config) {
        Action exactAction = Action.DEFAULT;
        for (Action action : Action.values()) {
            if (!action.hasConfig(config)) continue;
            exactAction = action;
            break;
        }
        return exactAction;
    }

    public static ItemCommand fromString(String input, Action action, ItemMap itemMap, long delay, String listSection) {
        if (input == null || input.isEmpty()) {
            return new ItemCommand("", Action.DEFAULT, Executor.DEFAULT, null, 0L, null);
        }
        input = input.trim();
        Executor type = Executor.DEFAULT;
        if (input.startsWith("default:")) {
            input = input.substring(8);
        } else if (input.startsWith("console:")) {
            input = input.substring(8);
            type = Executor.CONSOLE;
        } else if (input.startsWith("op:")) {
            input = input.substring(3);
            type = Executor.OP;
        } else if (input.startsWith("player:")) {
            input = input.substring(7);
            type = Executor.PLAYER;
        } else if (input.startsWith("server:")) {
            input = input.substring(7);
            type = Executor.SERVERSWITCH;
        } else if (input.startsWith("bungee:")) {
            input = input.substring(7);
            type = Executor.BUNGEE;
        } else if (input.startsWith("message:")) {
            input = input.substring(8);
            type = Executor.MESSAGE;
        } else if (input.startsWith("damage:")) {
            input = input.substring(7);
            type = Executor.DAMAGE;
        } else if (input.startsWith("swap-item:")) {
            input = input.substring(10);
            type = Executor.SWAPITEM;
        } else if (input.startsWith("delay:")) {
            input = input.substring(6);
            type = Executor.DELAY;
        }
        input = input.trim();
        return new ItemCommand(input, action, type, itemMap, delay, listSection);
    }

    public static ItemCommand[] arrayFromString(ItemMap itemMap, boolean isList) {
        if (ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(Objects.requireNonNull(itemMap.getNodeLocation().getCurrentPath())) == null) {
            return new ItemCommand[]{new ItemCommand("", Action.DEFAULT, Executor.DEFAULT, null, 0L, null)};
        }
        return ItemCommand.fromConfig(itemMap, isList);
    }

    private static ItemCommand[] fromConfig(ItemMap itemMap, boolean isList) {
        ConfigurationSection commandsList = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(Objects.requireNonNull(itemMap.getNodeLocation().getCurrentPath()));
        if (commandsList != null) {
            ArrayList<ItemCommand> arrayCommands = new ArrayList<ItemCommand>();
            for (String definition : commandsList.getKeys(false)) {
                if (!ItemCommand.isAction(definition)) continue;
                ConfigurationSection commandSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + "." + definition);
                if (isList && commandSection != null) {
                    for (String internalCommands : commandSection.getKeys(false)) {
                        arrayCommands.addAll(ItemCommand.arrayFromConfig(itemMap, definition, internalCommands));
                    }
                    continue;
                }
                arrayCommands.addAll(ItemCommand.arrayFromConfig(itemMap, definition, null));
            }
            ItemCommand[] commands = new ItemCommand[arrayCommands.size()];
            for (int i = 0; i < arrayCommands.size(); ++i) {
                commands[i] = (ItemCommand)arrayCommands.get(i);
            }
            return commands;
        }
        return null;
    }

    private static List<ItemCommand> arrayFromConfig(ItemMap itemMap, String definition, String internalCommands) {
        long delay = 0L;
        List commandsList = itemMap.getNodeLocation().getStringList("." + definition + (internalCommands != null ? "." + internalCommands : ""));
        ArrayList<ItemCommand> arrayCommands = new ArrayList<ItemCommand>();
        for (String s : commandsList) {
            if (s.trim().startsWith("delay:")) {
                delay += (long)ItemHandler.getDelay(s.trim());
            }
            arrayCommands.add(ItemCommand.fromString(s.trim(), ItemCommand.getExactAction(definition), itemMap, delay, internalCommands));
        }
        return arrayCommands;
    }

    private static boolean isAction(String definition) {
        for (Action action : Action.values()) {
            if (!action.hasConfig(definition.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean execute(Player player, Player altPlayer, String action, String clickType, String slot, ItemMap itemMap) {
        if (this.command == null || this.command.isEmpty() || this.actionType.hasClickType(clickType) || this.actionType.hasAction(action)) {
            return false;
        }
        if (this.actionType.equals((Object)Action.ON_HOLD)) {
            int cooldown = itemMap.getCommandCooldown() * 20;
            if (cooldown == 0) {
                cooldown += 20;
            }
            this.taskOnHold(player, altPlayer, slot, cooldown, itemMap);
        } else if (this.actionType.equals((Object)Action.ON_RECEIVE)) {
            int cooldown = itemMap.getCommandCooldown() * 20;
            if (cooldown == 0) {
                cooldown += 20;
            }
            int receive = itemMap.getCommandReceive();
            this.sendDispatch(player, altPlayer, this.executorType, slot);
            if (receive >= 2) {
                this.taskOnReceive(player, altPlayer, slot, cooldown, receive - 1);
            }
        } else {
            this.sendDispatch(player, altPlayer, this.executorType, slot);
        }
        return true;
    }

    private void taskOnHold(Player player, Player altPlayer, String slot, int cooldown, ItemMap itemMap) {
        this.cycleTask = SchedulerUtils.runAsyncAtInterval(cooldown, 0L, () -> {
            if (itemMap.isSimilar(player, PlayerHandler.getMainHandItem(player)) || itemMap.isSimilar(player, PlayerHandler.getOffHandItem(player))) {
                SchedulerUtils.run(() -> this.sendDispatch(player, altPlayer, this.executorType, slot));
            } else {
                this.cancelTask();
            }
        });
    }

    private void cancelTask() {
        SchedulerUtils.cancelTask(this.cycleTask);
    }

    private void taskOnReceive(Player player, Player altPlayer, String slot, int cooldown, int receive) {
        Runnable runnable = () -> {
            if (receive != 0) {
                this.sendDispatch(player, altPlayer, this.executorType, slot);
                this.taskOnReceive(player, altPlayer, slot, cooldown, receive - 1);
            }
        };
        if (cooldown <= 0) {
            runnable.run();
        } else {
            SchedulerUtils.runLater(cooldown, runnable);
        }
    }

    public boolean canExecute(String action, String clickType) {
        return this.command != null && !this.command.isEmpty() && !this.actionType.hasClickType(clickType) && !this.actionType.hasAction(action);
    }

    public boolean matchAction(Action action) {
        return this.actionType.equals((Object)action);
    }

    public Action getAction() {
        return this.actionType;
    }

    public String getSection() {
        return this.listSection;
    }

    public void setSection(String section) {
        this.listSection = section;
    }

    public String getRawCommand() {
        return this.executorType.getName() + this.command;
    }

    public void setCommand(String input) {
        this.command = input = input.trim();
    }

    private boolean getExecute(Player player) {
        return this.playerVoid.contains(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecute(Player player, boolean bool) {
        String string = "IJ_VOID";
        synchronized ("IJ_VOID") {
            if (bool) {
                this.playerVoid.add(player);
            } else {
                this.playerVoid.remove(player);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private boolean getPending(Player player) {
        return this.playerPending.contains(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPending(Player player, boolean bool) {
        String string = "IJ_PENDING";
        synchronized ("IJ_PENDING") {
            if (bool) {
                this.playerPending.add(player);
            } else {
                this.playerPending.remove(player);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void allowDispatch(Player player, World world) {
        SchedulerUtils.runAsyncLater(20L, () -> {
            String string = "IJ_ALLOW";
            synchronized ("IJ_ALLOW") {
                if (this.getPending(player)) {
                    if (!this.actionType.equals((Object)Action.ON_DEATH) && player.isDead() || !player.isOnline() || player.getWorld() != world) {
                        this.setExecute(player, true);
                        this.setPending(player, false);
                    } else {
                        this.allowDispatch(player, world);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
    }

    private void sendDispatch(Player player, Player altPlayer, Executor cmdType, String slot) {
        World world = player.getWorld();
        this.setPending(player, true);
        Runnable runnable = () -> {
            String string = "IJ_DISPATCH";
            synchronized ("IJ_DISPATCH") {
                this.allowDispatch(player, world);
                this.setPending(player, false);
                if ((this.actionType.equals((Object)Action.ON_DEATH) || !player.isDead()) && (this.itemMap != null && (this.actionType.equals((Object)Action.ON_HOLD) && this.itemMap.isReal(PlayerHandler.getMainHandItem(player)) || this.actionType.equals((Object)Action.ON_RECEIVE) && this.itemMap.hasItem(player, true)) || !this.actionType.equals((Object)Action.ON_HOLD) && !this.actionType.equals((Object)Action.ON_RECEIVE)) && (Objects.requireNonNull(this.itemMap).getCommandSequence() == CommandSequence.REMAIN && cmdType != Executor.SWAPITEM && cmdType != Executor.DELAY && this.itemMap.hasItem(player, true) || this.itemMap.getCommandSequence() == CommandSequence.REMAIN && (cmdType == Executor.SWAPITEM || cmdType == Executor.DELAY) || this.itemMap.getCommandSequence() != CommandSequence.REMAIN) && player.isOnline() && (player.getWorld() == world || this.itemMap.inWorld(world)) && !this.getExecute(player)) {
                    switch (cmdType) {
                        case CONSOLE: {
                            this.dispatchConsoleCommands(player, altPlayer);
                            break;
                        }
                        case OP: {
                            this.dispatchOpCommands(player, altPlayer);
                            break;
                        }
                        case MESSAGE: {
                            this.dispatchMessageCommands(player, altPlayer);
                            break;
                        }
                        case DAMAGE: {
                            this.dispatchDamageCommands(player, slot);
                            break;
                        }
                        case SERVERSWITCH: {
                            this.dispatchServerCommands(player, altPlayer);
                            break;
                        }
                        case BUNGEE: {
                            this.dispatchBungeeCordCommands(player, altPlayer);
                            break;
                        }
                        case SWAPITEM: {
                            this.dispatchSwapItem(player, slot);
                            break;
                        }
                        case DELAY: {
                            break;
                        }
                        default: {
                            this.dispatchPlayerCommands(player, altPlayer);
                            break;
                        }
                    }
                } else if (this.getExecute(player)) {
                    this.setExecute(player, false);
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        };
        if (this.delay <= 0L) {
            runnable.run();
        } else {
            SchedulerUtils.runLater(this.delay, runnable);
        }
    }

    private void dispatchConsoleCommands(Player player, Player altPlayer) {
        try {
            if (StringUtils.containsIgnoreCase(this.command, "[close]")) {
                PlayerHandler.safeInventoryClose(player);
            } else {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
                PluginData.getInfo().setLoggable("/" + StringUtils.translateLayout(this.command, player, placeHolders));
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), StringUtils.translateLayout(this.command, player, placeHolders));
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command as console, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchOpCommands(Player player, Player altPlayer) {
        block11: {
            try {
                if (StringUtils.containsIgnoreCase(this.command, "[close]")) {
                    PlayerHandler.safeInventoryClose(player);
                    break block11;
                }
                if (!player.isOp()) {
                    try {
                        player.setOp(true);
                        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
                        String cmd = StringUtils.translateLayout(this.command, player, placeHolders);
                        PluginData.getInfo().setLoggable("/" + cmd);
                        if (StringUtils.invalidASCII(cmd)) {
                            Bukkit.getServer().dispatchCommand((CommandSender)player, cmd);
                        } else {
                            player.chat("/" + cmd);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        ServerUtils.sendDebugTrace(e);
                        player.setOp(false);
                        ServerUtils.logSevere("{ItemCommand} An critical error has occurred while setting " + player.getName() + " status on the OP list, to maintain server security they have been removed as an OP.");
                        break block11;
                    }
                    finally {
                        player.setOp(false);
                    }
                }
                this.dispatchPlayerCommands(player, altPlayer);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command as an op, if this continues report it to the developer.");
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private void dispatchPlayerCommands(Player player, Player altPlayer) {
        try {
            if (StringUtils.containsIgnoreCase(this.command, "[close]")) {
                PlayerHandler.safeInventoryClose(player);
            } else {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
                String cmd = StringUtils.translateLayout(this.command, player, placeHolders);
                PluginData.getInfo().setLoggable("/" + cmd);
                if (StringUtils.invalidASCII(cmd)) {
                    Bukkit.getServer().dispatchCommand((CommandSender)player, cmd);
                } else {
                    player.chat("/" + cmd);
                }
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command as a player, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void dispatchMessageCommands(Player player, Player altPlayer) {
        try {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
            String jsonMessage = StringUtils.translateLayout(PluginData.getInfo().getJSONMessage(this.command, this.itemMap.getConfigName()), player, placeHolders);
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "minecraft:tellraw " + player.getName() + " " + jsonMessage);
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command to send a message, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void dispatchDamageCommands(Player player, String slot) {
        try {
            if (StringUtils.isInt(this.command)) {
                this.itemMap.damageItem(player, slot, Integer.parseInt(this.command));
            } else {
                ServerUtils.logSevere("{ItemCommand} The ItemMap " + this.itemMap.getConfigName() + " specified an invalid damage value of " + this.command + ".");
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command to damage an item, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void dispatchServerCommands(Player player, Player altPlayer) {
        try {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
            ItemJoin.getCore().getBungee().SwitchServers(player, StringUtils.translateLayout(this.command, player, placeHolders));
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command to switch servers, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void dispatchBungeeCordCommands(Player player, Player altPlayer) {
        try {
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.PLAYER_HIT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.PLAYER_INTERACT, altPlayer != null ? altPlayer.getName() : "").with(PlaceHolder.Holder.TARGET_PLAYER, altPlayer != null ? altPlayer.getName() : "");
            ItemJoin.getCore().getBungee().ExecuteCommand(player, StringUtils.translateLayout(this.command, player, placeHolders));
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command to BungeeCord, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void dispatchSwapItem(Player player, String slot) {
        try {
            ArrayList<ItemMap> mapDisposable = new ArrayList<ItemMap>();
            for (ItemMap item : ItemUtilities.getUtilities().getItems()) {
                if (!item.getConfigName().equalsIgnoreCase(this.command) || slot == null) continue;
                boolean itemExists = this.itemMap.getCommandSequence() != CommandSequence.REMAIN || this.itemMap.hasItem(player, true);
                mapDisposable.add(this.itemMap);
                for (ItemCommand command : this.itemMap.getCommands()) {
                    ItemMap commandMap;
                    if (command.executorType != Executor.SWAPITEM || !this.matchAction(command.actionType) || (commandMap = ItemUtilities.getUtilities().getItemMap(command.command)) == null) continue;
                    if (!itemExists) {
                        itemExists = commandMap.hasItem(player, true);
                    }
                    mapDisposable.add(commandMap);
                }
                if (itemExists) {
                    item.swapItem(player, slot);
                    for (ItemMap commandMap : mapDisposable) {
                        if (item.getConfigName().equalsIgnoreCase(commandMap.getConfigName())) continue;
                        commandMap.removeDisposable(player, commandMap, commandMap.getItem(player), true);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemCommand} There was an error executing an item's command to swap an items attributes, if this continues report it to the developer.");
            ServerUtils.sendDebugTrace(e);
        }
    }

    public static enum Action {
        DEFAULT("", "", ""),
        INTERACT_ALL(".interact", "LEFT_CLICK_BLOCK, LEFT_CLICK_AIR, RIGHT_CLICK_BLOCK, RIGHT_CLICK_AIR", "LEFT, RIGHT"),
        INTERACT_AIR(".interact-air", "LEFT_CLICK_AIR, RIGHT_CLICK_AIR", "LEFT, RIGHT"),
        INTERACT_BLOCK(".interact-block", "LEFT_CLICK_BLOCK, RIGHT_CLICK_BLOCK", "LEFT, RIGHT"),
        INTERACT_LEFT_ALL(".interact-left", "LEFT_CLICK_AIR, LEFT_CLICK_BLOCK", "LEFT"),
        INTERACT_LEFT_AIR(".interact-air-left", "LEFT_CLICK_AIR", "LEFT"),
        INTERACT_LEFT_BLOCK(".interact-block-left", "LEFT_CLICK_BLOCK", "LEFT"),
        INTERACT_RIGHT_ALL(".interact-right", "RIGHT_CLICK_AIR, RIGHT_CLICK_BLOCK", "RIGHT"),
        INTERACT_RIGHT_AIR(".interact-air-right", "RIGHT_CLICK_AIR", "RIGHT"),
        INTERACT_RIGHT_BLOCK(".interact-block-right", "RIGHT_CLICK_BLOCK", "RIGHT"),
        INVENTORY_ALL(".inventory", "NOTHING, PICKUP_ALL, PLACE_ALL, PLACE_SOME, PICKUP_HALF, PLACE_ONE, MOVE_TO_OTHER_INVENTORY", "MIDDLE, LEFT, RIGHT, SHIFT_LEFT, SHIFT_RIGHT"),
        INVENTORY_MIDDLE(".inventory-middle", "NOTHING", "MIDDLE"),
        INVENTORY_CREATIVE(".inventory-creative", "PICKUP_ALL, PLACE_ALL, PLACE_SOME, PICKUP_HALF, PLACE_ONE, CLONE_STACK", "CREATIVE"),
        INVENTORY_LEFT(".inventory-left", "PICKUP_ALL, PLACE_ALL, PLACE_SOME", "LEFT"),
        INVENTORY_RIGHT(".inventory-right", "PICKUP_HALF, PLACE_ONE", "RIGHT"),
        INVENTORY_SHIFT_LEFT(".inventory-shift-left", "MOVE_TO_OTHER_INVENTORY", "SHIFT_LEFT"),
        INVENTORY_SHIFT_RIGHT(".inventory-shift-right", "MOVE_TO_OTHER_INVENTORY", "SHIFT_RIGHT"),
        INVENTORY_SWAP_CURSOR(".inventory-swap-cursor", "SWAP_WITH_CURSOR", "LEFT, RIGHT"),
        ON_HOLD(".on-hold", "ON_HOLD", "HELD"),
        ON_EQUIP(".on-equip", "ON_EQUIP", "EQUIPPED"),
        UN_EQUIP(".un-equip", "UN_EQUIP", "UNEQUIPPED"),
        ON_KILL(".on-kill", "ON_KILL", "KILLER"),
        ON_DEATH(".on-death", "ON_DEATH", "DEAD"),
        ON_DAMAGE(".on-damage", "ON_DAMAGE", "DAMAGED"),
        ON_HIT(".on-hit", "ON_HIT", "HIT"),
        ON_FIRE(".on-fire", "ON_FIRE", "FIRE"),
        ON_CONSUME(".on-consume", "ON_CONSUME", "CONSUME"),
        ON_DROP(".on-drop", "ON_DROP", "DROP"),
        ON_RECEIVE(".on-receive", "ON_RECEIVE", "RECEIVED"),
        ON_JOIN(".on-join", "ON_JOIN", "JOINED"),
        PHYSICAL(".physical", "PHYSICAL", "INTERACTED");

        public final String config;
        private final String actions;
        private final String clickType;

        private Action(String Config, String Actions, String ClickType2) {
            this.config = Config;
            this.actions = Actions;
            this.clickType = ClickType2;
        }

        public String config() {
            return this.config;
        }

        public boolean hasConfig(String Config) {
            return this.config.contains(Config);
        }

        public boolean hasAction(String Action2) {
            return !StringUtils.splitIgnoreCase(this.actions, Action2, ",");
        }

        public boolean hasClickType(String ClickType2) {
            return !StringUtils.splitIgnoreCase(this.clickType, ClickType2, ",");
        }
    }

    public static enum Executor {
        DEFAULT("default: "),
        CONSOLE("console: "),
        OP("op: "),
        PLAYER("player: "),
        SERVERSWITCH("server: "),
        MESSAGE("message: "),
        BUNGEE("bungee: "),
        SWAPITEM("swap-item: "),
        DELAY("delay: "),
        DAMAGE("damage: "),
        FIRSTJOIN("first-join:");

        private final String name;

        private Executor(String name) {
            this.name = name;
        }

        private String getName() {
            return this.name;
        }
    }

    public static enum CommandSequence {
        RANDOM,
        RANDOM_SINGLE,
        RANDOM_LIST,
        REMAIN,
        SEQUENTIAL,
        ALL;

    }
}

