/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemRecipe;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.RockinChaos.itemjoin.listeners.Recipes;
import me.RockinChaos.itemjoin.utils.images.Renderer;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemDesigner {
    public ItemDesigner() {
        if (ItemJoin.getCore().isStarted()) {
            SchedulerUtils.runAsyncLater(2L, this::registerItems);
        } else {
            SchedulerUtils.run(this::registerItems);
        }
    }

    public void registerItems() {
        ConfigurationSection itemsList = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection("items");
        if (itemsList != null) {
            for (String internalName : itemsList.getKeys(false)) {
                String[] slots;
                ConfigurationSection itemNode;
                if (!this.isConfigurable(internalName, itemNode = itemsList.getConfigurationSection(internalName)) || itemNode == null) continue;
                String itemSlot = itemNode.getString(".slot");
                String slotList = itemSlot != null && !itemSlot.isEmpty() ? itemSlot : "ARBITRARY";
                for (String slot : slots = slotList.replace(" ", "").split(",")) {
                    if (!this.isDefinable(internalName, slot)) continue;
                    ItemMap itemMap = new ItemMap(internalName, slot);
                    this.setMaterial(itemMap);
                    this.setSkullDatabase(itemMap);
                    this.setUnbreaking(itemMap);
                    this.durabilityBar(itemMap);
                    this.setMapImage(itemMap);
                    this.setJSONBookPages(itemMap);
                    this.setNBTData(itemMap);
                    this.setName(itemMap);
                    this.setLore(itemMap);
                    this.setDurability(itemMap);
                    this.setData(itemMap);
                    this.setModelData(itemMap);
                    this.setSkull(itemMap);
                    this.setSkullTexture(itemMap);
                    this.setConsumableEffects(itemMap);
                    this.setPotionEffects(itemMap);
                    this.setTippedArrows(itemMap);
                    this.setBanners(itemMap);
                    this.setTrim(itemMap);
                    this.setFireworks(itemMap);
                    this.setFireChargeColor(itemMap);
                    this.setDye(itemMap);
                    this.setBookAuthor(itemMap);
                    this.setBookTitle(itemMap);
                    this.setBookGeneration(itemMap);
                    this.setAttributes(itemMap);
                    this.setAttributeFlags(itemMap);
                    this.setEnchantmentFlags(itemMap);
                    this.setFlags(itemMap);
                    this.setProbability(itemMap);
                    this.setMobsDrop(itemMap);
                    this.setBlocksDrop(itemMap);
                    this.setRecipe(itemMap);
                    itemMap.setContents();
                    ItemUtilities.getUtilities().addItem(itemMap);
                    ItemUtilities.getUtilities().addRecipeItem(itemMap);
                    ItemUtilities.getUtilities().addCraftingItem(itemMap);
                    PluginData.getInfo().registerListeners(itemMap);
                }
            }
            SchedulerUtils.runLater(8L, () -> ItemUtilities.getUtilities().updateItems());
        } else {
            ServerUtils.logWarn("{ItemDesigner} There are no items detected in the items.yml.");
            ServerUtils.logWarn("{ItemDesigner} Try adding an item to the items section in the items.yml.");
        }
    }

    private boolean isConfigurable(String internalName, ConfigurationSection itemNode) {
        String id = this.getMaterial(itemNode);
        String dataValue = null;
        if (id != null) {
            if (id.contains(":")) {
                String[] parts = id.split(":");
                id = parts[0];
                dataValue = parts[1];
                if (ServerUtils.hasSpecificUpdate("1_13")) {
                    ServerUtils.logWarn("{ItemDesigner} The item " + internalName + " is using a Legacy Material which is no longer supported as of Minecraft 1.13.");
                    ServerUtils.logWarn("{ItemDesigner} This will cause issues, please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html for a list of material names.");
                }
            }
            if (!ServerUtils.hasSpecificUpdate("1_9") && id.equalsIgnoreCase("TIPPED_ARROW") || id.equalsIgnoreCase("440") || id.equalsIgnoreCase("0440")) {
                ServerUtils.logSevere("{ItemDesigner} Your server is running MC " + ReflectionUtils.getServerVersion() + " and this version of Minecraft does not have the item TIPPED_ARROW.");
                ServerUtils.logWarn("{ItemDesigner} You are receiving this notice because the item(s) exists in your items.yml and will not be set, please remove the item(s) or update your server.");
                return false;
            }
            if (!ServerUtils.hasSpecificUpdate("1_9") && id.equalsIgnoreCase("LINGERING_POTION") || id.equalsIgnoreCase("441") || id.equalsIgnoreCase("0441")) {
                ServerUtils.logSevere("{ItemDesigner} Your server is running MC " + ReflectionUtils.getServerVersion() + " and this version of Minecraft does not have the item LINGERING_POTION.");
                ServerUtils.logWarn("{ItemDesigner} You are receiving this notice because the item(s) exists in your items.yml and will not be set, please remove the item(s) or update your server.");
                return false;
            }
            if (ItemHandler.getMaterial(id, dataValue) == Material.AIR) {
                ServerUtils.logSevere("{ItemDesigner} The Item " + internalName + "'s Material 'ID' is invalid or does not exist.");
                ServerUtils.logWarn("{ItemDesigner} The Item " + internalName + " will not be set!");
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(id)) {
                    ServerUtils.logSevere("{ItemDesigner} If you are using a numerical id and a numerical dataValue.");
                    ServerUtils.logSevere("{ItemDesigner} Include quotations or apostrophes at the beginning and the end or this error will persist, the id should look like '160:15' or \"160:15\".");
                }
                return false;
            }
        } else {
            ServerUtils.logSevere("{ItemDesigner} The Item" + internalName + " does not have a Material ID defined.");
            ServerUtils.logWarn("{ItemDesigner} The Item " + internalName + " will not be set!");
            return false;
        }
        return true;
    }

    private boolean isDefinable(String internalName, String slot) {
        if (!me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(slot) && !ItemHandler.isCustomSlot(slot)) {
            ServerUtils.logSevere("{ItemDesigner} The Item " + internalName + "'s slot is invalid or does not exist.");
            ServerUtils.logWarn("{ItemDesigner} The Item " + internalName + " will not be set!");
            return false;
        }
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(slot)) {
            int parseSlot = Integer.parseInt(slot);
            if (parseSlot < 0 || parseSlot > 35) {
                ServerUtils.logSevere("{ItemDesigner} The Item " + internalName + "'s slot must be between 0 and 35.");
                ServerUtils.logWarn("{ItemDesigner} The Item " + internalName + " will not be set!");
                return false;
            }
        } else if (!ServerUtils.hasSpecificUpdate("1_9") && slot.equalsIgnoreCase("Offhand")) {
            ServerUtils.logWarn("{ItemDesigner} Your server is running MC " + ReflectionUtils.getServerVersion() + " and this version of Minecraft does not have OFFHAND support!");
            return false;
        }
        return true;
    }

    public String getMaterial(ConfigurationSection itemNode) {
        ConfigurationSection matList = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemNode.getCurrentPath() + ".id");
        String material = ItemHandler.cutDelay(itemNode.getString(".id"));
        if (matList != null) {
            material = ItemHandler.cutDelay(itemNode.getString(".id." + (String)matList.getKeys(false).iterator().next()));
            return material;
        }
        return material;
    }

    private void setMaterial(ItemMap itemMap) {
        Material material = this.getActualMaterial(itemMap);
        itemMap.setMaterial(material);
        itemMap.renderItemStack();
    }

    private Material getActualMaterial(ItemMap itemMap) {
        ConfigurationSection matList = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".id");
        String material = ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".id"));
        if (matList != null) {
            ArrayList<String> materials = new ArrayList<String>();
            for (String materialKey : matList.getKeys(false)) {
                String materialList = itemMap.getNodeLocation().getString(".id." + materialKey);
                if (materialList == null) continue;
                materials.add(materialList);
            }
            itemMap.setDynamicMaterials(materials);
            material = ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".id." + (String)matList.getKeys(false).iterator().next()));
            Material mat = ItemHandler.getMaterial(material, null);
            if (material.contains(":") && !mat.name().equalsIgnoreCase("PLAYER_HEAD")) {
                String[] parts = material.split(":");
                itemMap.setDataValue((short)Integer.parseInt(parts[1]));
            }
            return mat;
        }
        Material mat = ItemHandler.getMaterial(material, null);
        if (material.contains(":") && !mat.name().equalsIgnoreCase("PLAYER_HEAD")) {
            String[] parts = material.split(":");
            itemMap.setDataValue((short)Integer.parseInt(parts[1]));
        }
        return mat;
    }

    private void setSkullDatabase(ItemMap itemMap) {
        if (ItemJoin.getCore().getDependencies().databaseEnabled() && itemMap.getNodeLocation().getString(".skull-texture") != null && (itemMap.getMaterial().toString().equalsIgnoreCase("SKULL_ITEM") || itemMap.getMaterial().toString().equalsIgnoreCase("PLAYER_HEAD"))) {
            if (itemMap.getNodeLocation().getString(".skull-owner") != null) {
                ServerUtils.logWarn("{ItemDesigner} You cannot define a skull owner and a skull texture at the same time, remove one from the item.");
                return;
            }
            String skullTexture = this.getActualTexture(itemMap);
            if (skullTexture.contains("hdb-")) {
                try {
                    itemMap.setSkullTexture(skullTexture.replace("hdb-", ""));
                    itemMap.setHeadDatabase(true);
                }
                catch (NullPointerException e) {
                    ServerUtils.logSevere("{ItemDesigner} HeadDatabaseAPI could not find #" + skullTexture + ", this head does not exist.");
                    ServerUtils.sendDebugTrace(e);
                }
            }
        }
    }

    private String getActualTexture(ItemMap itemMap) {
        ConfigurationSection textureSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".skull-texture");
        String texture = ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".skull-texture"));
        if (textureSection != null) {
            ArrayList<String> textures = new ArrayList<String>();
            for (String textureKey : textureSection.getKeys(false)) {
                String textureList = itemMap.getNodeLocation().getString(".skull-texture." + textureKey);
                if (textureList == null) continue;
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(textureList, "url-")) {
                    String delay = ItemHandler.getDelayFormat(textureList) != null ? ItemHandler.getDelayFormat(textureList) : "";
                    textureList = delay + me.RockinChaos.itemjoin.core.utils.StringUtils.toTexture64(textureList);
                }
                textures.add(textureList);
            }
            itemMap.setDynamicTextures(textures);
            return ItemHandler.cutDelay((String)textures.get(0));
        }
        if (!texture.isEmpty()) {
            if (itemMap.isDynamic() || itemMap.isAnimated()) {
                ArrayList<String> textures = new ArrayList<String>();
                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(texture, "url-")) {
                    String delay = ItemHandler.getDelayFormat(texture) != null ? ItemHandler.getDelayFormat(texture) : "";
                    texture = delay + me.RockinChaos.itemjoin.core.utils.StringUtils.toTexture64(texture);
                }
                textures.add(texture);
                itemMap.setDynamicTextures(textures);
            } else if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(texture, "url-")) {
                String delay = ItemHandler.getDelayFormat(texture) != null ? ItemHandler.getDelayFormat(texture) : "";
                texture = delay + me.RockinChaos.itemjoin.core.utils.StringUtils.toTexture64(texture);
            }
        }
        return texture;
    }

    private void setUnbreaking(ItemMap itemMap) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getItemFlags(), "unbreakable")) {
            try {
                itemMap.setUnbreakable(true);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private void durabilityBar(ItemMap itemMap) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getItemFlags(), "hide-durability")) {
            try {
                itemMap.setDurabilityBar(true);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private void setMapImage(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".custom-map-image") != null && me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getMaterial().toString(), "MAP")) {
            if (itemMap.getNodeLocation().getString(".map-id") != null && me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(itemMap.getNodeLocation().getString(".map-id"))) {
                itemMap.setMapID(itemMap.getNodeLocation().getInt(".map-id"));
            }
            itemMap.setMapImage(itemMap.getNodeLocation().getString(".custom-map-image"));
            if (itemMap.getMapImage().equalsIgnoreCase("default.jpg") || new File(ItemJoin.getCore().getPlugin().getDataFolder(), itemMap.getMapImage()).exists()) {
                DataObject dataObject = (DataObject)ItemJoin.getCore().getSQL().getData(new DataObject(DataObject.Table.MAP_IDS, null, null, itemMap.getMapImage(), null));
                if (dataObject != null && (itemMap.getMapID() == -1 || itemMap.getMapID() == Integer.parseInt(dataObject.getMapID()))) {
                    int mapID = Integer.parseInt(dataObject.getMapID());
                    MapRenderer imgPlatform = this.createRenderer(itemMap.getMapImage(), mapID);
                    MapView view = ItemHandler.existingView(mapID);
                    itemMap.setMapID(mapID);
                    itemMap.setMapView(view);
                    try {
                        view.removeRenderer((MapRenderer)view.getRenderers().get(0));
                    }
                    catch (NullPointerException e) {
                        ServerUtils.sendDebugTrace(e);
                    }
                    try {
                        view.addRenderer(imgPlatform);
                    }
                    catch (NullPointerException e) {
                        ServerUtils.sendDebugTrace(e);
                    }
                } else {
                    MapView view = LegacyAPI.createMapView();
                    try {
                        view.removeRenderer((MapRenderer)view.getRenderers().get(0));
                    }
                    catch (NullPointerException e) {
                        ServerUtils.sendDebugTrace(e);
                    }
                    int mapID = itemMap.getMapID() != -1 ? itemMap.getMapID() : (int)LegacyAPI.getMapID(view);
                    MapRenderer imgPlatform = this.createRenderer(itemMap.getMapImage(), mapID);
                    itemMap.setMapID(mapID);
                    itemMap.setMapView(view);
                    try {
                        view.addRenderer(imgPlatform);
                    }
                    catch (NullPointerException e) {
                        ServerUtils.sendDebugTrace(e);
                    }
                    ItemJoin.getCore().getSQL().saveData(new DataObject(DataObject.Table.MAP_IDS, null, null, itemMap.getMapImage(), Integer.toString(itemMap.getMapID())));
                }
            }
        } else if (itemMap.getNodeLocation().getString(".map-id") != null && me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(itemMap.getNodeLocation().getString(".map-id")) && me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getMaterial().toString(), "MAP")) {
            itemMap.setMapID(itemMap.getNodeLocation().getInt(".map-id"));
            MapView view = ItemHandler.existingView(itemMap.getMapID());
            itemMap.setMapView(view);
        }
    }

    public MapRenderer createRenderer(String image, int imageID) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(image, ".GIF")) {
            return new Renderer(image, 0, -1);
        }
        return new Renderer(image, imageID);
    }

    private void setNBTData(ItemMap itemMap) {
        if (ItemJoin.getCore().getData().dataTagsEnabled() && !itemMap.isVanilla() && !itemMap.isVanillaControl() && !itemMap.isVanillaStatus()) {
            try {
                Object tag = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(tag, "ItemJoin Name", itemMap.getConfigName());
                String itemProperties = itemMap.getNodeLocation().getString(".properties");
                if (itemProperties != null && !itemProperties.isEmpty()) {
                    String[] properties;
                    HashMap<Object, Object> tagValues = new HashMap<Object, Object>();
                    for (String property : properties = itemProperties.split(",")) {
                        String identifier;
                        String[] propertyParts = property.split(":");
                        String tagName = identifier = propertyParts[0].startsWith(" ") ? propertyParts[0].substring(1) : propertyParts[0];
                        if (identifier.contains(".")) {
                            tagName = identifier.split("\\.")[1];
                        }
                        Object tagList = null;
                        StringBuilder value = new StringBuilder(propertyParts[1]);
                        for (int i = 2; i < propertyParts.length; ++i) {
                            value.append(":").append(propertyParts[i]);
                        }
                        if (value.toString().startsWith("[")) {
                            value = new StringBuilder(value.toString().replace("[", "").replace("]", ""));
                            String[] valueParts = value.toString().split("#");
                            ArrayList<String> listNBT = new ArrayList<String>(Arrays.asList(valueParts));
                            tagList = ReflectionUtils.getMinecraftClass("NBTTagList").getConstructor(new Class[0]).newInstance(new Object[0]);
                            for (String nbt : listNBT) {
                                Object tagString = ReflectionUtils.getMinecraftClass("NBTTagString").getMethod(ReflectionUtils.MinecraftMethod.valueOf.getMethod(), String.class).invoke(null, nbt);
                                tagList.getClass().getMethod(ServerUtils.hasSpecificUpdate("1_21") ? ReflectionUtils.MinecraftMethod.addTag.getMethod() : ReflectionUtils.MinecraftMethod.add.getMethod(), Integer.TYPE, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(tagList, 0, tagString);
                            }
                        }
                        Object propertyTag = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                        propertyTag.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(propertyTag, tagName, value.toString());
                        if (tagList == null) {
                            tagValues.put(identifier, value.toString());
                            continue;
                        }
                        tagValues.put(identifier, tagList);
                    }
                    itemMap.setNBTProperties(tagValues);
                }
            }
            catch (Exception e) {
                ServerUtils.logSevere("{ItemDesigner} An error has occurred when setting NBTData to an item.");
                ServerUtils.sendDebugTrace(e);
            }
        } else {
            itemMap.setLegacySecret(itemMap.getNBTFormat());
        }
    }

    private void setJSONBookPages(ItemMap itemMap) {
        ConfigurationSection pagesSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".pages");
        if (itemMap.getMaterial().toString().equalsIgnoreCase("WRITTEN_BOOK") && itemMap.getNodeLocation().getString(".pages") != null && pagesSection != null) {
            ArrayList<String> JSONPages = new ArrayList<String>();
            ArrayList<List<String>> rawPages = new ArrayList<List<String>>();
            for (String pageString : pagesSection.getKeys(false)) {
                List pageList = itemMap.getNodeLocation().getStringList(".pages." + pageString);
                rawPages.add(pageList);
                StringBuilder textBuilder = new StringBuilder("{\"text\":\"\",\"extra\":[");
                boolean firstIn = true;
                for (String string : pageList) {
                    HashMap<Integer, String> JSONBuilder = new HashMap<Integer, String>();
                    String formatLine = string.replace("\n", "\\n");
                    if (ItemHandler.containsJSONEvent(formatLine)) {
                        while (ItemHandler.containsJSONEvent(formatLine)) {
                            for (ItemHandler.JSONEvent jsonType : ItemHandler.JSONEvent.values()) {
                                Matcher matchPattern = java.util.regex.Pattern.compile(jsonType.matchType + "(.*?)>").matcher(formatLine);
                                if (!matchPattern.find()) continue;
                                String inputResult = matchPattern.group(1);
                                JSONBuilder.put(JSONBuilder.size(), jsonType != ItemHandler.JSONEvent.TEXT && jsonType != ItemHandler.JSONEvent.COLOR ? ",\"" + jsonType.event + "\":{\"action\":\"" + jsonType.action + "\",\"value\":\"" + inputResult + "\"}" : "," + (jsonType != ItemHandler.JSONEvent.COLOR ? "{" : "") + "\"" + jsonType.action + "\":\"" + inputResult + "\"");
                                formatLine = formatLine.replace(jsonType.matchType + inputResult + ">", "<JSONEvent>");
                                ItemHandler.safetyCheckURL(itemMap.getConfigName(), jsonType, inputResult);
                            }
                        }
                        if (formatLine.isEmpty() || formatLine.trim().isEmpty()) continue;
                        boolean definingText = false;
                        String[] JSONEvents = formatLine.split("<JSONEvent>");
                        if (StringUtils.countMatches((String)formatLine, (String)"<JSONEvent>") > JSONEvents.length) {
                            StringBuilder adjustLine = new StringBuilder();
                            for (String s : formatLine.split("JSONEvent>")) {
                                adjustLine.append(s).append("JSONEvent> ");
                            }
                            JSONEvents = adjustLine.toString().split("<JSONEvent>");
                        }
                        for (int i = 0; i < JSONEvents.length; ++i) {
                            if (!JSONEvents[i].isEmpty() && !JSONEvents[i].trim().isEmpty()) {
                                textBuilder.append(i == 0 ? "," : "},").append("{\"").append("text").append("\":\"").append(JSONEvents[i]).append(JSONBuilder.get(i) != null && ((String)JSONBuilder.get(i)).contains("\"text\"") ? "\"}" : "\"").append(JSONBuilder.get(i) != null ? (String)JSONBuilder.get(i) : "");
                                continue;
                            }
                            if (JSONBuilder.get(i) == null) continue;
                            if (((String)JSONBuilder.get(i)).contains("\"text\"") && !definingText) {
                                textBuilder.append((String)JSONBuilder.get(i));
                                definingText = true;
                                continue;
                            }
                            if (((String)JSONBuilder.get(i)).contains("\"text\"") && definingText) {
                                textBuilder.append("}").append((String)JSONBuilder.get(i));
                                definingText = false;
                                continue;
                            }
                            textBuilder.append((String)JSONBuilder.get(i));
                        }
                        textBuilder.append("},{\"text\":\"\\n\"}");
                        firstIn = false;
                        continue;
                    }
                    if (formatLine.contains("raw:")) {
                        String format = (!firstIn ? "," : "") + formatLine.replace("raw: ", "").replace("raw:", "").replace("[\"\",", "").replace("[\"\"", "").replace("\"bold\":false}]", "\"bold\":false}").replace("\"bold\":true}]", "\"bold\":true}");
                        if (format.endsWith("]")) {
                            format = me.RockinChaos.itemjoin.core.utils.StringUtils.replaceLast(format, "]", "");
                        }
                        textBuilder.append(format).append(",{\"text\":\"\\n\"}");
                        firstIn = false;
                        continue;
                    }
                    textBuilder.append(!firstIn ? "," : "").append("{\"text\":\"").append(formatLine).append("\"},{\"text\":\"\\n\"}");
                    firstIn = false;
                }
                JSONPages.add(textBuilder + "]}");
            }
            itemMap.setPages(JSONPages);
            itemMap.setListPages(rawPages);
        }
    }

    private void setName(ItemMap itemMap) {
        String name = this.getActualName(itemMap);
        if (ItemJoin.getCore().getData().dataTagsEnabled() || itemMap.isVanilla()) {
            itemMap.setCustomName(name);
        } else {
            itemMap.setCustomName("\u00a7f" + name);
        }
    }

    private String getActualName(ItemMap itemMap) {
        ConfigurationSection nameSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".name");
        String name = itemMap.getNodeLocation().getString(".name");
        try {
            ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nameSection != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (String nameKey : nameSection.getKeys(false)) {
                String nameList = itemMap.getNodeLocation().getString(".name." + nameKey);
                if (nameList == null) continue;
                names.add(nameList);
            }
            itemMap.setDynamicNames(names);
            return ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".name." + (String)nameSection.getKeys(false).iterator().next()));
        }
        if (name == null || name.isEmpty()) {
            return ItemHandler.getMaterialName(itemMap.getTempItem());
        }
        if (itemMap.isDynamic() || itemMap.isAnimated()) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            itemMap.setDynamicNames(names);
        }
        return ItemHandler.cutDelay(name);
    }

    private void setLore(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".lore") != null) {
            List<String> lore = this.getActualLore(itemMap);
            itemMap.setCustomLore(lore);
        }
    }

    private List<String> getActualLore(ItemMap itemMap) {
        ConfigurationSection loreSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".lore");
        List lore = itemMap.getNodeLocation().getStringList(".lore");
        if (loreSection != null) {
            ArrayList<List<String>> lores = new ArrayList<List<String>>();
            for (String loreKey : loreSection.getKeys(false)) {
                List loreList = itemMap.getNodeLocation().getStringList(".lore." + loreKey);
                lores.add(loreList);
            }
            itemMap.setDynamicLores(lores);
            return itemMap.getNodeLocation().getStringList(".lore." + (String)loreSection.getKeys(false).iterator().next());
        }
        if (!lore.isEmpty() && (itemMap.isDynamic() || itemMap.isAnimated())) {
            ArrayList<List<String>> lores = new ArrayList<List<String>>();
            lores.add(lore);
            itemMap.setDynamicLores(lores);
        }
        return lore;
    }

    private void setDurability(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".data") == null || itemMap.getNodeLocation().getInt(".data") == 0) {
            if (itemMap.getNodeLocation().getString(".skull-owner") != null) {
                itemMap.setDurability((short)3);
            } else if (itemMap.getNodeLocation().getString(".durability") != null) {
                int durability = itemMap.getNodeLocation().getInt(".durability");
                itemMap.setDurability((short)durability);
            }
        }
    }

    private void setData(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".data") != null) {
            itemMap.setData(itemMap.getNodeLocation().getInt(".data"));
            itemMap.setAttributesInfo(true);
            itemMap.setUnbreakable(true);
        }
    }

    private void setModelData(ItemMap itemMap) {
        if (ServerUtils.hasSpecificUpdate("1_14") && itemMap.getNodeLocation().getString(".model-data") != null) {
            itemMap.setModelData(itemMap.getNodeLocation().getString(".model-data"));
        } else if (ServerUtils.hasPreciseUpdate("1_21_4") && itemMap.getNodeLocation().getString(".model-components") != null) {
            itemMap.setModelComponents(Arrays.asList(itemMap.getNodeLocation().getString(".model-components.strings"), itemMap.getNodeLocation().getString(".model-components.colors"), itemMap.getNodeLocation().getString(".model-components.flags"), itemMap.getNodeLocation().getString(".model-components.floats")));
        }
    }

    private void setProbability(ItemMap itemMap) {
        String probability = itemMap.getNodeLocation().getString(".probability");
        if (probability != null) {
            String percentageString = probability.replace("%", "").replace("-", "").replace(" ", "");
            int percentage = Integer.parseInt(percentageString);
            if (!ItemJoin.getCore().getChances().getItems().containsKey(itemMap)) {
                ItemJoin.getCore().getChances().putItem(itemMap, percentage);
            }
            itemMap.setProbability(percentage);
            if (itemMap.getProbability() == 100) {
                ServerUtils.logWarn("{ItemDesigner} An item cannot be defined with 100 percent probability, please check the wiki on this usage.");
                ServerUtils.logWarn("{ItemDesigner} Please change the probability of the item, or remove it entirely, items may not function.");
            }
        }
    }

    private void setMobsDrop(ItemMap itemMap) {
        HashMap<EntityType, Double> mobsDrop = new HashMap<EntityType, Double>();
        if (itemMap.getNodeLocation().getString(".mobs-drop") != null) {
            List mobs = itemMap.getNodeLocation().getStringList(".mobs-drop");
            for (String mobsLine : mobs) {
                String[] mobsParts = mobsLine.replace(" ", "").split(":");
                if (mobsParts[0] != null && mobsParts[1] != null && me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(mobsParts[1])) {
                    EntityType mob = EntityType.valueOf((String)mobsParts[0].toUpperCase());
                    mobsDrop.put(mob, Double.parseDouble(mobsParts[1]));
                    continue;
                }
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(mobsParts[1])) {
                    ServerUtils.logWarn("{ItemDesigner} The percentage value for the mob " + mobsParts[0] + " is not a valid number, please check the wiki on this usage.");
                    continue;
                }
                ServerUtils.logWarn("{ItemDesigner} An error has occurred when trying to set mobs drop for " + itemMap.getConfigName() + ", please check your formatting.");
            }
            itemMap.setMobsDrop(mobsDrop);
        }
    }

    private void setBlocksDrop(ItemMap itemMap) {
        HashMap<Material, Double> blocksDrop = new HashMap<Material, Double>();
        if (itemMap.getNodeLocation().getString(".blocks-drop") != null) {
            List blocks = itemMap.getNodeLocation().getStringList(".blocks-drop");
            for (String blocksLine : blocks) {
                String[] blocksParts = blocksLine.replace(" ", "").split(":");
                if (blocksParts[0] != null && blocksParts[1] != null && me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(blocksParts[1])) {
                    Material block = ItemHandler.getMaterial(blocksParts[0].toUpperCase(), null);
                    if (block != Material.AIR) {
                        blocksDrop.put(block, Double.parseDouble(blocksParts[1]));
                        continue;
                    }
                    ServerUtils.logWarn("{ItemDesigner} The material " + blocksParts[0] + " is not a valid material type, please check the wiki on this usage.");
                    continue;
                }
                if (!me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(blocksParts[1])) {
                    ServerUtils.logWarn("{ItemDesigner} The percentage value for the material " + blocksParts[0] + " is not a valid number, please check the wiki on this usage.");
                    continue;
                }
                ServerUtils.logWarn("{ItemDesigner} An error has occurred when trying to set blocks drop for " + itemMap.getConfigName() + ", please check your formatting.");
            }
            itemMap.setBlocksDrop(blocksDrop);
        }
    }

    private void setRecipe(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".recipe") != null) {
            ConfigurationSection recipeSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".recipe");
            HashMap<Character, ItemRecipe> ingredientList = new HashMap<Character, ItemRecipe>();
            List recipe = itemMap.getNodeLocation().getStringList(".recipe");
            if (recipeSection != null) {
                for (String recipeKey : recipeSection.getKeys(false)) {
                    List recipeList = itemMap.getNodeLocation().getStringList(".recipe." + recipeKey);
                    if (recipeList.isEmpty()) continue;
                    this.addRecipe(itemMap, recipeList, "-" + recipeKey, ingredientList);
                }
            } else {
                this.addRecipe(itemMap, recipe, "-1", ingredientList);
            }
            itemMap.setIngredients(ingredientList);
        } else {
            itemMap.setRecipe(Arrays.asList(Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf('X')));
        }
    }

    private void addRecipe(ItemMap itemMap, List<String> recipe, String identifier, Map<Character, ItemRecipe> ingredientList) {
        ShapedRecipe shapedRecipe = ServerUtils.hasSpecificUpdate("1_12") ? new ShapedRecipe(new NamespacedKey((Plugin)ItemJoin.getCore().getPlugin(), itemMap.getConfigName() + identifier), itemMap.getItem(null)) : LegacyAPI.newShapedRecipe(itemMap.getItem(null));
        String[] shape = itemMap.trimRecipe(recipe);
        shapedRecipe.shape(shape);
        if (itemMap.getNodeLocation().getString(".ingredients") != null) {
            List ingredients = itemMap.getNodeLocation().getStringList(".ingredients");
            for (String ingredient : ingredients) {
                String[] ingredientParts = ingredient.split(":");
                int getCount = 1;
                int getData = 0;
                if (ingredientParts.length > 2 && ingredientParts[2].startsWith("#")) {
                    try {
                        getCount = Integer.parseInt(ingredientParts[2].replace("#", ""));
                    }
                    catch (Exception e) {
                        ServerUtils.logWarn("{ItemDesigner} [1] " + ingredientParts[2].replace("#", "") + " is not a valid count!");
                    }
                } else if (ingredientParts.length > 3 && ingredientParts[3].startsWith("#")) {
                    try {
                        getCount = Integer.parseInt(ingredientParts[3].replace("#", ""));
                    }
                    catch (Exception e) {
                        ServerUtils.logWarn("{ItemDesigner} [2] " + ingredientParts[3].replace("#", "") + " is not a valid count!");
                    }
                    try {
                        getData = Integer.parseInt(ingredientParts[2]);
                    }
                    catch (Exception e) {
                        ServerUtils.logWarn("{ItemDesigner} [3] " + ingredientParts[2] + " is not a valid item data!");
                    }
                } else if (ingredientParts.length > 2 && !ingredientParts[2].startsWith("#")) {
                    try {
                        getData = Integer.parseInt(ingredientParts[2]);
                    }
                    catch (Exception e) {
                        ServerUtils.logWarn("{ItemDesigner} [4] " + ingredientParts[2] + " is not a valid item data!");
                    }
                }
                int count = getCount;
                int itemData = getData;
                Material material = ItemHandler.getMaterial(ingredientParts[1], String.valueOf(itemData));
                ConfigurationSection itemsPath = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection("items");
                if (material != Material.AIR && count >= 1) {
                    try {
                        char character = 'X';
                        try {
                            character = ingredientParts[0].charAt(0);
                        }
                        catch (Exception e) {
                            ServerUtils.logWarn("{ItemDesigner} The character " + ingredientParts[0] + " for the custom recipe defined for the item " + itemMap.getConfigName() + " is not a valid character!");
                        }
                        if (itemData <= 0) {
                            shapedRecipe.setIngredient(character, material);
                        } else {
                            LegacyAPI.setIngredient(shapedRecipe, character, material, (byte)itemData);
                        }
                        ingredientList.put(Character.valueOf(character), new ItemRecipe(null, material, (byte)itemData, count));
                    }
                    catch (IllegalArgumentException e) {
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(e.getMessage(), "Symbol does not appear")) continue;
                        ServerUtils.sendSevereTrace(e);
                    }
                    continue;
                }
                if (itemsPath != null && itemsPath.getConfigurationSection(ingredientParts[1]) != null && count >= 1) {
                    SchedulerUtils.runLater(40L, () -> {
                        block8: {
                            try {
                                ItemMap tempMap = ItemUtilities.getUtilities().getItemMap(ingredientParts[1]);
                                if (tempMap != null) {
                                    ItemStack itemStack = tempMap.getItem(null);
                                    int mapData = Integer.parseInt(tempMap.getDataValue() + "");
                                    char character = 'X';
                                    try {
                                        character = ingredientParts[0].charAt(0);
                                    }
                                    catch (Exception e) {
                                        ServerUtils.logWarn("{ItemDesigner} The character " + ingredientParts[0] + " for the custom recipe defined for the item " + itemMap.getConfigName() + " is not a valid character!");
                                    }
                                    if (mapData <= 0) {
                                        shapedRecipe.setIngredient(character, itemStack.getType());
                                    } else {
                                        LegacyAPI.setIngredient(shapedRecipe, character, itemStack.getType(), (byte)mapData);
                                    }
                                    ingredientList.put(Character.valueOf(character), new ItemRecipe(ingredientParts[1], null, (byte)mapData, count));
                                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.isRegistered(Recipes.class.getSimpleName())) {
                                        ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new Recipes(), (Plugin)ItemJoin.getCore().getPlugin());
                                    }
                                    break block8;
                                }
                                ServerUtils.logWarn("{ItemDesigner} The material " + ingredientParts[1] + " for the custom recipe defined for the item " + itemMap.getConfigName() + " is not a proper material type OR custom item node!");
                            }
                            catch (IllegalArgumentException e) {
                                if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(e.getMessage(), "Symbol does not appear")) break block8;
                                ServerUtils.sendSevereTrace(e);
                            }
                        }
                    });
                    continue;
                }
                ServerUtils.logWarn("{ItemDesigner} The material " + ingredientParts[1] + " for the custom recipe defined for the item " + itemMap.getConfigName() + " is not a proper material type OR custom item node!");
            }
            SchedulerUtils.runLater(45L, () -> {
                block4: {
                    try {
                        try {
                            Bukkit.getServer().addRecipe((Recipe)shapedRecipe);
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    catch (NullPointerException e2) {
                        if (e2.getMessage() == null || e2.getMessage().isEmpty() || !e2.getMessage().contains("registry")) break block4;
                        ServerUtils.logWarn("{ItemDesigner} Magma has been detected on the server which currently doesn't support ShapedRecipes.");
                        ServerUtils.logWarn("{ItemDesigner} The recipe for " + itemMap.getConfigName() + " may still continue to function in limited capacity.");
                        ServerUtils.sendDebugTrace(e2);
                    }
                }
            });
        } else {
            ServerUtils.logWarn("{ItemDesigner} There is a custom recipe defined for the item " + itemMap.getConfigName() + " but it still needs ingredients defined!");
        }
    }

    private void setSkull(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".skull-owner") != null && (itemMap.getMaterial().toString().equalsIgnoreCase("SKULL_ITEM") || itemMap.getMaterial().toString().equalsIgnoreCase("PLAYER_HEAD"))) {
            if (itemMap.getNodeLocation().getString(".skull-texture") != null) {
                ServerUtils.logWarn("{ItemDesigner} You cannot define a skull owner and a skull texture at the same time, remove one from the item.");
                return;
            }
            String owner = this.getActualOwner(itemMap);
            itemMap.setSkull(owner);
        }
    }

    private String getActualOwner(ItemMap itemMap) {
        ConfigurationSection ownerSection = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection(itemMap.getNodeLocation().getCurrentPath() + ".skull-owner");
        String owner = ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".skull-owner"));
        if (ownerSection != null) {
            ArrayList<String> owners = new ArrayList<String>();
            for (String ownerKey : ownerSection.getKeys(false)) {
                String ownerList = itemMap.getNodeLocation().getString(".skull-owner." + ownerKey);
                if (ownerList == null) continue;
                owners.add(ownerList);
            }
            itemMap.setDynamicOwners(owners);
            return ItemHandler.cutDelay(itemMap.getNodeLocation().getString(".skull-owner." + (String)ownerSection.getKeys(false).iterator().next()));
        }
        if (!owner.isEmpty() && (itemMap.isDynamic() || itemMap.isAnimated())) {
            ArrayList<String> owners = new ArrayList<String>();
            owners.add(owner);
            itemMap.setDynamicOwners(owners);
        }
        return owner;
    }

    private void setSkullTexture(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".skull-texture") != null && (itemMap.getMaterial().toString().equalsIgnoreCase("SKULL_ITEM") || itemMap.getMaterial().toString().equalsIgnoreCase("PLAYER_HEAD"))) {
            if (itemMap.getNodeLocation().getString(".skull-owner") != null) {
                ServerUtils.logWarn("{ItemDesigner} You cannot define a skull owner and a skull texture at the same time, remove one from the item.");
                return;
            }
            String texture = this.getActualTexture(itemMap);
            if (!me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(texture, "hdb-")) {
                itemMap.setSkullTexture(texture);
            }
        }
    }

    private void setConsumableEffects(ItemMap itemMap) {
        String potionEffect;
        String string = potionEffect = itemMap.getNodeLocation().getString(".potion-effect") != null ? itemMap.getNodeLocation().getString(".potion-effect") : itemMap.getNodeLocation().getString(".potion-effects");
        if (potionEffect != null && (itemMap.getMaterial().isEdible() || ItemHandler.isSkull(itemMap.getMaterial()))) {
            String potionList = potionEffect.replace(" ", "");
            ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
            for (String potion : potionList.split(",")) {
                String[] potionSection = potion.split(":");
                PotionEffectType type = LegacyAPI.getEffectByName(potionSection[0]);
                if (type != null) {
                    try {
                        int amplifier = 1;
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(potion, ":")) {
                            amplifier = Integer.parseInt(potionSection[1]) == 1 || Integer.parseInt(potionSection[1]) == 2 || Integer.parseInt(potionSection[1]) == 3 ? Integer.parseInt(potionSection[1]) - 1 : Integer.parseInt(potionSection[1]);
                        }
                        potionEffectList.add(new PotionEffect(type, Integer.parseInt(potionSection[2]) * 20, amplifier));
                    }
                    catch (NumberFormatException e) {
                        ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + potionSection[1] + " is not a number and a number was expected.");
                        ServerUtils.logWarn("{ItemDesigner} Consumable Potion: " + potionSection[0] + " will now be set to level 1.");
                        ServerUtils.sendDebugTrace(e);
                    }
                    continue;
                }
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + potionSection[0] + " is an incorrect potion effect for the consumable.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html for a list of correct potion effects.");
            }
            itemMap.setCustomConsumable(true);
            itemMap.setPotionEffect(potionEffectList);
        }
    }

    private void setPotionEffects(ItemMap itemMap) {
        String potionEffect;
        String string = potionEffect = itemMap.getNodeLocation().getString(".potion-effect") != null ? itemMap.getNodeLocation().getString(".potion-effect") : itemMap.getNodeLocation().getString(".potion-effects");
        if (potionEffect != null && (itemMap.getMaterial().toString().equalsIgnoreCase("POTION") || itemMap.getMaterial().toString().equalsIgnoreCase("SPLASH_POTION") || ServerUtils.hasSpecificUpdate("1_9") && itemMap.getMaterial().toString().equalsIgnoreCase("LINGERING_POTION"))) {
            String potionList = potionEffect.replace(" ", "");
            ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
            for (String potion : potionList.split(",")) {
                String[] potionSection = potion.split(":");
                PotionEffectType type = LegacyAPI.getEffectByName(potionSection[0]);
                if (type != null) {
                    try {
                        int amplifier = 1;
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(potion, ":")) {
                            amplifier = Integer.parseInt(potionSection[1]) == 1 || Integer.parseInt(potionSection[1]) == 2 || Integer.parseInt(potionSection[1]) == 3 ? Integer.parseInt(potionSection[1]) - 1 : Integer.parseInt(potionSection[1]);
                        }
                        potionEffectList.add(new PotionEffect(type, Integer.parseInt(potionSection[2]) * 20, amplifier));
                    }
                    catch (NumberFormatException e) {
                        ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + potionSection[1] + " is not a number and a number was expected.");
                        ServerUtils.logWarn("{ItemDesigner} Custom Potion: " + potionSection[0] + " will now be set to level 1.");
                        ServerUtils.sendDebugTrace(e);
                    }
                    continue;
                }
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + potionSection[0] + " is an incorrect potion effect for the custom potion.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html for a list of correct potion effects.");
            }
            itemMap.setPotionEffect(potionEffectList);
        }
    }

    private void setTippedArrows(ItemMap itemMap) {
        String potionEffect;
        String string = potionEffect = itemMap.getNodeLocation().getString(".potion-effect") != null ? itemMap.getNodeLocation().getString(".potion-effect") : itemMap.getNodeLocation().getString(".potion-effects");
        if (potionEffect != null && ServerUtils.hasSpecificUpdate("1_9") && !ItemJoin.getCore().getPlugin().getServer().getVersion().contains("(MC: 1.9)") && itemMap.getMaterial().toString().equalsIgnoreCase("TIPPED_ARROW")) {
            String effectList = potionEffect.replace(" ", "");
            ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
            for (String effect : effectList.split(",")) {
                String[] tippedSection = effect.split(":");
                PotionEffectType type = LegacyAPI.getEffectByName(tippedSection[0]);
                if (type != null) {
                    try {
                        int level = 1;
                        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(effect, ":")) {
                            level = Integer.parseInt(tippedSection[1]) == 1 || Integer.parseInt(tippedSection[1]) == 2 || Integer.parseInt(tippedSection[1]) == 3 ? Integer.parseInt(tippedSection[1]) - 1 : Integer.parseInt(tippedSection[1]);
                        }
                        int duration = Integer.parseInt(tippedSection[2]);
                        potionEffectList.add(new PotionEffect(type, duration * 160, level));
                    }
                    catch (NumberFormatException e) {
                        ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + tippedSection[1] + " is not a number and a number was expected.");
                        ServerUtils.logWarn("{ItemDesigner} Tipped Effect: " + tippedSection[0] + " will now be set to level 1.");
                        ServerUtils.sendDebugTrace(e);
                    }
                    continue;
                }
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + tippedSection[0] + " is an incorrect potion effect for the tipped arrow.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html for a list of correct potion effects.");
            }
            itemMap.setPotionEffect(potionEffectList);
        }
    }

    private void setBanners(ItemMap itemMap) {
        String bannerMeta = itemMap.getNodeLocation().getString(".banner-meta");
        if (bannerMeta != null && me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getMaterial().toString(), "BANNER")) {
            String bannerList = bannerMeta.replace(" ", "");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String banner : bannerList.split(",")) {
                String[] bannerSection = banner.split(":");
                DyeColor Color2 = null;
                PatternType Pattern2 = null;
                try {
                    Color2 = DyeColor.valueOf((String)bannerSection[0].toUpperCase());
                    if (ServerUtils.hasPreciseUpdate("1_20_6")) {
                        NamespacedKey key = NamespacedKey.minecraft((String)bannerSection[1].toLowerCase());
                        Pattern2 = (PatternType)Registry.BANNER_PATTERN.get(key);
                    } else {
                        Pattern2 = LegacyAPI.getPattern(bannerSection[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Color2 != null && Pattern2 != null) {
                    patterns.add(new Pattern(Color2, Pattern2));
                    continue;
                }
                if (Color2 == null) {
                    ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + bannerSection[0] + " is an incorrect dye color.");
                    ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/DyeColor.html for a list of correct dye colors.");
                    continue;
                }
                if (!banner.contains(":")) continue;
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + bannerSection[1] + " is an incorrect pattern type.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/block/banner/PatternType.html for a list of correct pattern types.");
            }
            itemMap.setBannerPatterns(patterns);
        }
    }

    private void setTrim(ItemMap itemMap) {
        String trimMeta = itemMap.getNodeLocation().getString(".trim-meta");
        if (trimMeta != null && ServerUtils.hasSpecificUpdate("1_20") && ItemHandler.isArmor(itemMap.getMaterial().toString())) {
            String armorTrim = trimMeta.replace(" ", "");
            String[] armorSection = armorTrim.split(":");
            TrimMaterial Material2 = ItemHandler.getTrimMaterial(armorSection[0].toUpperCase());
            TrimPattern Pattern2 = ItemHandler.getTrimPattern(armorSection[1].toUpperCase());
            HashMap<String, String> trimPattern = new HashMap<String, String>();
            if (Material2 != null && Pattern2 != null) {
                trimPattern.put(armorSection[0].toUpperCase(), armorSection[1].toUpperCase());
            } else if (Material2 == null) {
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + armorSection[0] + " is an incorrect armor trim material.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/inventory/meta/trim/TrimMaterial.html for a list of correct material types.");
            } else if (armorTrim.contains(":")) {
                ServerUtils.logSevere("{ItemDesigner} An error occurred in the config, " + armorSection[1] + " is an incorrect armor trim pattern.");
                ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/inventory/meta/trim/TrimPattern.html for a list of correct pattern types.");
            }
            itemMap.setTrimPattern(trimPattern);
        }
    }

    private void setFireworks(ItemMap itemMap) {
        if (itemMap.getNodeLocation().getString(".firework") != null && (itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK") || itemMap.getMaterial().toString().equalsIgnoreCase("FIREWORK_ROCKET"))) {
            int power;
            String fireType = itemMap.getNodeLocation().getString(".firework.type");
            String fireColors = itemMap.getNodeLocation().getString(".firework.colors");
            if (fireType != null) {
                String stringType = fireType.toUpperCase();
                boolean flicker = itemMap.getNodeLocation().getBoolean(".firework.flicker");
                boolean trail = itemMap.getNodeLocation().getBoolean(".firework.trail");
                FireworkEffect.Type buildType = FireworkEffect.Type.valueOf((String)stringType);
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<DyeColor> saveColors = new ArrayList<DyeColor>();
                if (fireColors != null) {
                    String colorList = fireColors.replace(" ", "");
                    for (String color : colorList.split(",")) {
                        try {
                            colors.add(DyeColor.valueOf((String)color.toUpperCase()).getFireworkColor());
                            saveColors.add(DyeColor.valueOf((String)color.toUpperCase()));
                        }
                        catch (Exception e) {
                            ServerUtils.logSevere("{ItemDesigner} The item " + itemMap.getConfigName() + " has the incorrect dye color " + color.toUpperCase() + " and does not exist.");
                            ServerUtils.logWarn("{ItemDesigner} Please see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/DyeColor.html for a list of correct dye color names.");
                        }
                    }
                } else if (itemMap.getNodeLocation().getString(".firework.colors") == null) {
                    colors.add(DyeColor.valueOf((String)"WHITE").getFireworkColor());
                    saveColors.add(DyeColor.valueOf((String)"WHITE"));
                }
                FireworkEffect effect = FireworkEffect.builder().trail(trail).flicker(flicker).withColor(colors).withFade(colors).with(buildType).build();
                itemMap.setFirework(effect);
                itemMap.setFireworkType(buildType);
                itemMap.setFireworkColor(saveColors);
                itemMap.setFireworkTrail(trail);
                itemMap.setFireworkFlicker(flicker);
            }
            if ((power = itemMap.getNodeLocation().getInt(".firework.power")) == 0) {
                power = 1;
            }
            itemMap.setFireworkPower(power);
        }
    }

    private void setFireChargeColor(ItemMap itemMap) {
        String chargeColor = itemMap.getNodeLocation().getString(".charge-color");
        if (chargeColor != null && (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getMaterial().toString(), "CHARGE") || me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getMaterial().toString(), "STAR"))) {
            itemMap.setChargeColor(DyeColor.valueOf((String)chargeColor.toUpperCase()));
        }
    }

    private void setDye(ItemMap itemMap) {
        String leatherColor = itemMap.getNodeLocation().getString(".leather-color");
        if (leatherColor != null && itemMap.getMaterial().toString().contains("LEATHER_") && (ServerUtils.hasSpecificUpdate("1_14") || !itemMap.getMaterial().toString().equalsIgnoreCase("LEATHER_HORSE_ARMOR"))) {
            boolean isPlaceholder = leatherColor.startsWith("%");
            leatherColor = leatherColor.replace(" ", "");
            try {
                if (leatherColor.startsWith("#")) {
                    itemMap.setLeatherHex(leatherColor);
                } else if (!isPlaceholder) {
                    boolean hexValue = true;
                    for (DyeColor color : DyeColor.values()) {
                        if (!color.name().replace(" ", "").equalsIgnoreCase(leatherColor)) continue;
                        itemMap.setLeatherColor(leatherColor.toUpperCase());
                        hexValue = false;
                        break;
                    }
                    if (hexValue) {
                        itemMap.setLeatherHex(leatherColor);
                    }
                } else {
                    itemMap.setLeatherColor(leatherColor);
                }
            }
            catch (Exception ex) {
                ServerUtils.logSevere("{ItemDesigner} The leather-color: " + leatherColor + " is not a valid color for the item " + itemMap.getConfigName() + ".");
                ServerUtils.logWarn("{ItemDesigner} Use hex-color or see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/DyeColor.html for valid bukkit colors.");
            }
        }
    }

    private void setBookAuthor(ItemMap itemMap) {
        if (itemMap.getMaterial().toString().equalsIgnoreCase("WRITTEN_BOOK")) {
            if (itemMap.getNodeLocation().getString(".author") != null) {
                itemMap.setAuthor(itemMap.getNodeLocation().getString(".author"));
            } else {
                itemMap.setAuthor("&f");
            }
        }
    }

    private void setBookTitle(ItemMap itemMap) {
        if (itemMap.getMaterial().toString().equalsIgnoreCase("WRITTEN_BOOK")) {
            if (itemMap.getNodeLocation().getString(".title") != null) {
                itemMap.setTitle(itemMap.getNodeLocation().getString(".title"));
            } else {
                itemMap.setTitle("&f");
            }
        }
    }

    private void setBookGeneration(ItemMap itemMap) {
        if (ServerUtils.hasSpecificUpdate("1_10") && itemMap.getMaterial().toString().equalsIgnoreCase("WRITTEN_BOOK")) {
            if (itemMap.getNodeLocation().getString(".generation") != null) {
                itemMap.setGeneration(BookMeta.Generation.valueOf((String)itemMap.getNodeLocation().getString(".generation")));
            } else {
                itemMap.setGeneration(BookMeta.Generation.ORIGINAL);
            }
        }
    }

    private void setAttributes(ItemMap itemMap) {
        String[] attributes = null;
        String val = itemMap.getNodeLocation().getString(".attributes");
        if (val != null && val.contains("{") && val.contains("}")) {
            attributes = val.split(",");
        }
        if (attributes != null && attributes.length != 0) {
            try {
                HashMap<String, Double> attributesList = new HashMap<String, Double>();
                for (String value : attributes) {
                    String[] valueParts = value.replace("{", "").replace("}", "").replace(" ", "").split(":");
                    if (me.RockinChaos.itemjoin.core.utils.StringUtils.isInt(valueParts[1]) || me.RockinChaos.itemjoin.core.utils.StringUtils.isDouble(valueParts[1])) {
                        attributesList.put(valueParts[0], Double.parseDouble(valueParts[1]));
                        continue;
                    }
                    ServerUtils.logSevere("{ItemDesigner} There was an issue setting the custom attribute " + valueParts[0] + " for " + itemMap.getConfigName() + ".");
                    ServerUtils.logSevere("{ItemDesigner} The value " + valueParts[1] + " is not an integer or double value.");
                }
                itemMap.setAttributes(attributesList);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{ItemDesigner} An error has occurred when setting custom attributes for " + itemMap.getConfigName() + ".");
                ServerUtils.logSevere("{ItemDesigner} The attributes should look like '{GENERIC_ARMOR:10}, {GENERIC_ARMOR_TOUGHNESS:8}' or \"{GENERIC_ARMOR:10}, {GENERIC_ARMOR_TOUGHNESS:8}\".");
            }
        }
    }

    private void setAttributeFlags(ItemMap itemMap) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getItemFlags(), "hide-attributes")) {
            itemMap.setAttributesInfo(true);
        }
    }

    private void setEnchantmentFlags(ItemMap itemMap) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getItemFlags(), "hide-enchants")) {
            itemMap.setEnchantmentsInfo(true);
        }
    }

    private void setFlags(ItemMap itemMap) {
        if (me.RockinChaos.itemjoin.core.utils.StringUtils.containsIgnoreCase(itemMap.getItemFlags(), "hide-flags")) {
            itemMap.setFlagsInfo(true);
        }
    }
}

