/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.item;

import com.vk2gpz.tokenenchant.api.TokenEnchantAPI;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import me.RockinChaos.itemjoin.ChatToggleExecutor;
import me.RockinChaos.itemjoin.ChatToggleTab;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PermissionsHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemAnimation;
import me.RockinChaos.itemjoin.item.ItemCommand;
import me.RockinChaos.itemjoin.item.ItemRecipe;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import me.RockinChaos.itemjoin.listeners.Interact;
import me.RockinChaos.itemjoin.utils.api.EffectAPI;
import me.RockinChaos.itemjoin.utils.menus.Menu;
import me.RockinChaos.itemjoin.utils.sql.DataObject;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ItemMap
implements Cloneable {
    private final Map<String, Long> playersOnInteractCooldown = new HashMap<String, Long>();
    private final HashMap<String, Long> storedSpammedPlayers = new HashMap();
    private final List<Player> warmPending = new ArrayList<Player>();
    private final Map<String, Long> playersOnCooldown = new HashMap<String, Long>();
    private final HashMap<String, Long> playersOnCooldownTick = new HashMap();
    private final List<PluginCommand> togglePlugins = new ArrayList<PluginCommand>();
    private String configName;
    private ConfigurationSection nodeLocation;
    private Integer probability = -1;
    private ItemStack tempItem = null;
    private ItemMeta tempMeta = null;
    private Material material = Material.AIR;
    private Short dataValue = 0;
    private String customName = null;
    private List<String> customLore = new ArrayList<String>();
    private List<String> AllSlots = new ArrayList<String>();
    private Integer InvSlot = 0;
    private String CustomSlot = null;
    private boolean craftingItem = false;
    private boolean giveNext = false;
    private boolean moveNext = false;
    private boolean dropFull = false;
    private String count = "1";
    private Map<String, Double> attributes = new HashMap<String, Double>();
    private Short durability = null;
    private Integer data = null;
    private String modelData = null;
    private List<String> modelComponents = null;
    private String author;
    private String title;
    private Object generation;
    private List<String> bookPages = new ArrayList<String>();
    private List<List<String>> listPages = new ArrayList<List<String>>();
    private short mapId = (short)-1;
    private MapView mapView = null;
    private String customMapImage = null;
    private FireworkEffect firework = null;
    private FireworkEffect.Type fireworkType = null;
    private boolean fireworkFlicker = false;
    private boolean fireworkTrail = false;
    private Integer power = 0;
    private List<DyeColor> fireworkColor = new ArrayList<DyeColor>();
    private DyeColor chargeColor = null;
    private String skullOwner = null;
    private String skullTexture = null;
    private boolean headDatabase = false;
    private List<PotionEffect> effect = new ArrayList<PotionEffect>();
    private List<Pattern> bannerPatterns = new ArrayList<Pattern>();
    private Map<String, String> trimPattern = new HashMap<String, String>();
    private Map<Character, ItemRecipe> ingredients = new HashMap<Character, ItemRecipe>();
    private List<List<Character>> recipe = new ArrayList<List<Character>>();
    private String leatherColor;
    private String leatherHex;
    private String teleportEffect;
    private String teleportSound;
    private Double teleportSoundVolume = 1.0;
    private Double teleportSoundPitch = 1.0;
    private Integer interactCooldown = 0;
    private boolean customConsumable = false;
    private Map<String, Integer> enchants = new HashMap<String, Integer>();
    private Map<Object, Object> nbtProperty = new HashMap<Object, Object>();
    private Map<EntityType, Double> mobsDrop = new HashMap<EntityType, Double>();
    private Map<Material, Double> blocksDrop = new HashMap<Material, Double>();
    private String legacySecret;
    private List<String> dynamicNames = new ArrayList<String>();
    private List<List<String>> dynamicLores = new ArrayList<List<String>>();
    private List<String> dynamicMaterials = new ArrayList<String>();
    private List<String> dynamicOwners = new ArrayList<String>();
    private List<String> dynamicTextures = new ArrayList<String>();
    private boolean materialAnimated = false;
    private Map<Player, ItemAnimation> localeAnimations = new HashMap<Player, ItemAnimation>();
    private ItemCommand[] commands = new ItemCommand[0];
    private Integer cooldownSeconds = 0;
    private Integer commandsReceive = 0;
    private String cooldownMessage;
    private String commandSound;
    private Double commandSoundVolume = 1.0;
    private Double commandSoundPitch = 1.0;
    private String commandParticle;
    private String itemCost;
    private String cost = "0";
    private Integer warmDelay = 0;
    private boolean subjectRemoval = false;
    private ItemCommand.CommandSequence sequence;
    private List<String> disposableConditions = new ArrayList<String>();
    private List<String> triggerConditions = new ArrayList<String>();
    private Map<String, List<String>> commandConditions = new HashMap<String, List<String>>();
    private Map<String, List<String>> commandPermissions = new HashMap<String, List<String>>();
    private String disposableMessage = null;
    private String triggerMessage = null;
    private Map<String, String> commandMessages = new HashMap<String, String>();
    private String itemflags;
    private boolean vanillaItem = false;
    private boolean vanillaStatus = false;
    private boolean vanillaControl = false;
    private boolean unbreakable = false;
    private boolean countLock = false;
    private boolean teleportArrow = false;
    private boolean cancelEvents = false;
    private boolean itemStore = false;
    private boolean itemModify = false;
    private boolean noCrafting = false;
    private boolean noRepairing = false;
    private boolean animate = false;
    private boolean dynamic = false;
    private boolean dynamicCount = false;
    private boolean glowing = false;
    private boolean overwritable = false;
    private boolean blockPlacement = false;
    private boolean hideAttributes = false;
    private boolean hideEnchantments = false;
    private boolean hideFlags = false;
    private boolean hideDurability = false;
    private boolean blockEquip = false;
    private boolean blockMovement = false;
    private boolean closeInventory = false;
    private boolean selfDroppable = false;
    private boolean deathDroppable = false;
    private boolean eraseDroppable = false;
    private boolean deathKeepable = false;
    private boolean disposable = false;
    private boolean itemChangeable = false;
    private boolean alwaysGive = false;
    private boolean autoRemove = false;
    private boolean stackable = false;
    private boolean notHat = false;
    private boolean noClear = false;
    private boolean selectable = false;
    private int selectableDelay = 0;
    private boolean splittable = false;
    private boolean CreativeBypass = false;
    private boolean AllowOpBypass = false;
    private boolean onlyFirstJoin = false;
    private boolean onlyFirstLife = false;
    private boolean onlyFirstWild = false;
    private boolean onlyFirstWorld = false;
    private boolean ipLimited = false;
    private boolean giveOnDisabled = false;
    private boolean giveOnJoin = false;
    private boolean giveOnTeleport = false;
    private boolean giveOnRespawn = false;
    private boolean giveOnRespawnWild = false;
    private boolean giveOnRespawnPoint = false;
    private boolean giveOnWorldSwitch = false;
    private boolean giveOnPermissionSwitch = false;
    private boolean giveOnRegionEnter = false;
    private boolean giveOnRegionLeave = false;
    private boolean giveOnRegionAccess = false;
    private boolean giveOnRegionEgress = false;
    private boolean useOnLimitSwitch = false;
    private String triggers = null;
    private String limitModes = null;
    private String toggleNode = null;
    private String toggleMessage = null;
    private List<String> toggleCommands = new ArrayList<String>();
    private String permissionNode = null;
    private boolean permissionNeeded = false;
    private boolean opPermissionNeeded = false;
    private boolean cmdPermissionNeeded = false;
    private List<String> contents = new ArrayList<String>();
    private List<String> enabledRegions = new ArrayList<String>();
    private List<String> disabledRegions = new ArrayList<String>();
    private List<String> enabledWorlds = new ArrayList<String>();
    private List<String> disabledWorlds = new ArrayList<String>();

    public ItemMap(String internalName, String slot) {
        ConfigurationSection itemsPath = ItemJoin.getCore().getConfig("items.yml").getConfigurationSection("items");
        this.nodeLocation = itemsPath != null ? itemsPath.getConfigurationSection(internalName) : ItemJoin.getCore().getConfig("items.yml").createSection("items").getConfigurationSection(internalName);
        this.configName = internalName;
        this.setSlot(slot);
        if (ItemHandler.isCraftingSlot(slot)) {
            this.craftingItem = true;
        }
        if (this.nodeLocation != null) {
            this.setMultipleSlots();
            this.setCount(this.nodeLocation.getString(".count"));
            this.setCommandCost();
            this.setCommandReceive();
            this.setCommandWarmDelay();
            this.setCommandSound();
            this.setCommandParticle();
            this.setCommandCooldown();
            this.setCommandSequence();
            this.setCommandPermissions();
            this.setCommands(ItemCommand.arrayFromString(this, this.sequence == ItemCommand.CommandSequence.RANDOM_LIST));
            this.setToggleCommands(this.nodeLocation.getString(".toggle"));
            this.setConditions();
            this.setInteractCooldown();
            this.setPlayersOnCooldown();
            this.setTeleportArrow();
            this.setLimitModes();
            this.setTriggers();
            this.setItemflags();
            this.setWorlds();
            this.setRegions();
            this.setTogglePerm(this.nodeLocation.getString(".toggle-permission"));
            this.setToggleMessage(this.nodeLocation.getString(".toggle-message"));
            this.setPerm(this.nodeLocation.getString(".permission-node"));
            this.setPermissionNeeded(this.permissionNode != null || ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items"));
            this.setOPPermissionNeeded(this.permissionNode != null || ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Obtain-Items-OP"));
            this.setCMDPermissionNeeded(this.permissionNode != null || ItemJoin.getCore().getConfig("config.yml").getBoolean("Permissions.Commands-Get"));
        }
    }

    public ItemMap() {
    }

    private void setMultipleSlots() {
        String itemSlot = this.nodeLocation.getString(".slot");
        if (itemSlot != null && itemSlot.contains(",")) {
            String[] slots;
            for (String slot : slots = itemSlot.replace(" ", "").split(",")) {
                this.AllSlots.add(slot);
            }
        }
    }

    private void setCommandCost() {
        String commandItem = this.nodeLocation.getString("commands-item");
        if (commandItem != null && !commandItem.isEmpty()) {
            this.itemCost = commandItem;
        }
        this.setCommandCost(this.nodeLocation.getString("commands-cost"));
    }

    private void setCommandReceive() {
        if (this.nodeLocation.getString("commands-receive") != null && StringUtils.isInt(this.nodeLocation.getString("commands-receive"))) {
            this.commandsReceive = this.nodeLocation.getInt("commands-receive");
        }
    }

    private void setCommandWarmDelay() {
        if (this.nodeLocation.getString("commands-warmup") != null && StringUtils.isInt(this.nodeLocation.getString("commands-warmup"))) {
            this.warmDelay = this.nodeLocation.getInt("commands-warmup");
        }
    }

    private void setCommandSound() {
        try {
            String sound = this.nodeLocation.getString(".commands-sound");
            if (sound != null) {
                if (sound.contains(":")) {
                    String[] soundParts = sound.split(":");
                    this.commandSound = soundParts[0];
                    try {
                        this.commandSoundVolume = Double.valueOf(soundParts[1]);
                        this.commandSoundPitch = Double.valueOf(soundParts[2]);
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{ItemMap} The formatting for the item " + this.configName + " commands-sound is incorrect and will not be set!");
                        ServerUtils.sendDebugTrace(e);
                    }
                } else {
                    this.commandSound = sound;
                }
            }
        }
        catch (Exception e) {
            ServerUtils.logSevere("{ItemMap} Your server is running MC " + ReflectionUtils.getServerVersion() + " and this version of Minecraft does not have the defined command-sound " + this.nodeLocation.getString(".commands-sound") + ".");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void setCommandParticle() {
        if (this.nodeLocation.getString(".commands-particle") != null) {
            this.commandParticle = this.nodeLocation.getString(".commands-particle");
        }
    }

    private void setCommandCooldown() {
        boolean useCooldown;
        boolean bl = useCooldown = this.nodeLocation.getString("commands-cooldown") != null;
        if (useCooldown) {
            this.cooldownSeconds = this.nodeLocation.getInt("commands-cooldown");
        }
        this.cooldownMessage = this.nodeLocation.getString("cooldown-message");
    }

    private void setCommandSequence() {
        if (this.nodeLocation.getString("commands-sequence") != null) {
            if (StringUtils.containsIgnoreCase(this.nodeLocation.getString("commands-sequence"), "SEQUENTIAL")) {
                this.sequence = ItemCommand.CommandSequence.SEQUENTIAL;
            } else if (StringUtils.containsIgnoreCase(this.nodeLocation.getString("commands-sequence"), "RANDOM_SINGLE")) {
                this.sequence = ItemCommand.CommandSequence.RANDOM_SINGLE;
            } else if (StringUtils.containsIgnoreCase(this.nodeLocation.getString("commands-sequence"), "RANDOM_LIST")) {
                this.sequence = ItemCommand.CommandSequence.RANDOM_LIST;
            } else if (StringUtils.containsIgnoreCase(this.nodeLocation.getString("commands-sequence"), "RANDOM")) {
                this.sequence = ItemCommand.CommandSequence.RANDOM;
            } else if (StringUtils.containsIgnoreCase(this.nodeLocation.getString("commands-sequence"), "REMAIN")) {
                this.sequence = ItemCommand.CommandSequence.REMAIN;
            }
        }
    }

    private void setCommandPermissions() {
        for (ItemCommand.Action action : ItemCommand.Action.values()) {
            String actionPermissions = this.nodeLocation.getString(action.config() + "-permission");
            List actionPermissionsList = this.nodeLocation.getStringList(action.config() + "-permission");
            if (!actionPermissionsList.isEmpty()) {
                this.commandPermissions.put(action.config(), actionPermissionsList);
                continue;
            }
            if (actionPermissions == null || actionPermissions.isEmpty()) continue;
            ArrayList<String> commandCond = new ArrayList<String>();
            commandCond.add(actionPermissions);
            this.commandPermissions.put(action.config(), commandCond);
        }
    }

    private void setInteractCooldown() {
        if (this.nodeLocation.getString(".use-cooldown") != null) {
            this.interactCooldown = this.nodeLocation.getInt(".use-cooldown");
        }
    }

    private void setTeleportArrow() {
        this.teleportEffect = this.nodeLocation.getString(".teleport-effect");
        String sound = this.nodeLocation.getString(".teleport-sound");
        if (sound != null && sound.contains(":")) {
            String[] soundParts = sound.split(":");
            this.teleportSound = soundParts[0];
            try {
                this.teleportSoundVolume = Double.valueOf(soundParts[1]);
                this.teleportSoundPitch = Double.valueOf(soundParts[2]);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{ItemMap} The formatting for the item " + this.configName + " teleport-sound is incorrect and will not be set!");
                ServerUtils.sendDebugTrace(e);
            }
        } else {
            this.teleportSound = sound;
        }
    }

    private void setItemflags() {
        if (this.nodeLocation.getString(".itemflags") != null) {
            this.itemflags = this.nodeLocation.getString(".itemflags");
            this.vanillaItem = StringUtils.splitIgnoreCase(this.itemflags, "vanilla", ",");
            this.vanillaStatus = StringUtils.splitIgnoreCase(this.itemflags, "vanilla-status", ",");
            this.vanillaControl = StringUtils.splitIgnoreCase(this.itemflags, "vanilla-control", ",");
            this.disposable = StringUtils.splitIgnoreCase(this.itemflags, "disposable", ",");
            this.blockPlacement = StringUtils.splitIgnoreCase(this.itemflags, "placement", ",");
            this.blockMovement = StringUtils.splitIgnoreCase(this.itemflags, "inventory-modify", ",") || StringUtils.splitIgnoreCase(this.itemflags, "inventory-close", ",");
            this.blockEquip = StringUtils.splitIgnoreCase(this.itemflags, "cancel-equip", ",");
            this.closeInventory = StringUtils.splitIgnoreCase(this.itemflags, "inventory-close", ",");
            this.itemChangeable = StringUtils.splitIgnoreCase(this.itemflags, "item-changeable", ",");
            this.alwaysGive = StringUtils.splitIgnoreCase(this.itemflags, "always-give", ",");
            this.autoRemove = StringUtils.splitIgnoreCase(this.itemflags, "auto-remove", ",");
            this.stackable = StringUtils.splitIgnoreCase(this.itemflags, "stackable", ",");
            this.notHat = StringUtils.splitIgnoreCase(this.itemflags, "not-hat", ",");
            this.noClear = StringUtils.splitIgnoreCase(this.itemflags, "no-clear", ",");
            this.selectable = StringUtils.splitIgnoreCase(this.itemflags, "selectable", ",");
            this.selectableDelay = this.nodeLocation.getString(".selectable-delay") != null ? this.nodeLocation.getInt(".selectable-delay") : 0;
            this.splittable = StringUtils.splitIgnoreCase(this.itemflags, "splittable", ",");
            this.animate = StringUtils.splitIgnoreCase(this.itemflags, "animate", ",");
            this.dynamic = StringUtils.splitIgnoreCase(this.itemflags, "dynamic", ",");
            this.dynamicCount = StringUtils.splitIgnoreCase(this.itemflags, "dynamic-count", ",");
            this.glowing = StringUtils.splitIgnoreCase(this.itemflags, "glowing", ",");
            this.giveNext = StringUtils.splitIgnoreCase(this.itemflags, "give-next", ",");
            this.moveNext = StringUtils.splitIgnoreCase(this.itemflags, "move-next", ",");
            this.dropFull = StringUtils.splitIgnoreCase(this.itemflags, "drop-full", ",");
            this.itemStore = StringUtils.splitIgnoreCase(this.itemflags, "item-store", ",");
            this.itemModify = StringUtils.splitIgnoreCase(this.itemflags, "item-modifiable", ",");
            this.noCrafting = StringUtils.splitIgnoreCase(this.itemflags, "item-craftable", ",");
            this.noRepairing = StringUtils.splitIgnoreCase(this.itemflags, "item-repairable", ",");
            this.cancelEvents = StringUtils.splitIgnoreCase(this.itemflags, "cancel-events", ",");
            this.countLock = StringUtils.splitIgnoreCase(this.itemflags, "count-lock", ",");
            this.teleportArrow = StringUtils.splitIgnoreCase(this.itemflags, "teleport", ",");
            this.overwritable = StringUtils.splitIgnoreCase(this.itemflags, "overwrite", ",");
            this.ipLimited = StringUtils.splitIgnoreCase(this.itemflags, "ip-limit", ",");
            this.deathKeepable = StringUtils.splitIgnoreCase(this.itemflags, "death-keep", ",");
            this.deathDroppable = StringUtils.splitIgnoreCase(this.itemflags, "death-drops", ",");
            this.selfDroppable = StringUtils.splitIgnoreCase(this.itemflags, "self-drops", ",");
            this.eraseDroppable = StringUtils.splitIgnoreCase(this.itemflags, "erase-drops", ",");
            this.setOnlyFirstJoin(StringUtils.splitIgnoreCase(this.itemflags, "first-join", ",") || this.onlyFirstJoin, new boolean[0]);
            this.setOnlyFirstLife(StringUtils.splitIgnoreCase(this.itemflags, "first-life", ",") || this.onlyFirstLife, new boolean[0]);
            this.setOnlyFirstWild(StringUtils.splitIgnoreCase(this.itemflags, "first-wild", ",") || this.onlyFirstWild, new boolean[0]);
            this.setOnlyFirstWorld(StringUtils.splitIgnoreCase(this.itemflags, "first-world", ",") || this.onlyFirstWorld, new boolean[0]);
            this.AllowOpBypass = StringUtils.splitIgnoreCase(this.itemflags, "AllowOpBypass", ",") || this.AllowOpBypass;
            this.CreativeBypass = StringUtils.splitIgnoreCase(this.itemflags, "CreativeBypass", ",") || this.CreativeBypass;
        }
    }

    private void setLimitModes() {
        this.limitModes = this.nodeLocation.getString(".limit-modes");
    }

    private void setTriggers() {
        String defaultTriggers = ItemJoin.getCore().getConfig("config.yml").getString("Settings.Default-Triggers");
        this.triggers = this.nodeLocation.getString("triggers") != null ? this.nodeLocation.getString("triggers") : (defaultTriggers != null && !defaultTriggers.isEmpty() ? defaultTriggers : "JOIN");
        this.giveOnDisabled = StringUtils.splitIgnoreCase(this.triggers, "DISABLED", ",");
        this.giveOnJoin = StringUtils.splitIgnoreCase(this.triggers, "JOIN", ",");
        this.giveOnTeleport = StringUtils.splitIgnoreCase(this.triggers, "TELEPORT", ",");
        this.giveOnRespawn = StringUtils.splitIgnoreCase(this.triggers, "RESPAWN", ",");
        this.giveOnRespawnWild = StringUtils.splitIgnoreCase(this.triggers, "RESPAWN-WILD", ",");
        this.giveOnRespawnPoint = StringUtils.splitIgnoreCase(this.triggers, "RESPAWN-POINT", ",");
        this.giveOnWorldSwitch = StringUtils.splitIgnoreCase(this.triggers, "WORLD-CHANGE", ",") || StringUtils.splitIgnoreCase(this.triggers, "WORLD-SWITCH", ",");
        this.giveOnPermissionSwitch = StringUtils.splitIgnoreCase(this.triggers, "PERMISSION-CHANGE", ",") || StringUtils.splitIgnoreCase(this.triggers, "PERMISSION-SWITCH", ",") || StringUtils.splitIgnoreCase(this.triggers, "PERMISSIONS-CHANGE", ",") || StringUtils.splitIgnoreCase(this.triggers, "PERMISSIONS-SWITCH", ",");
        this.giveOnRegionEnter = StringUtils.splitIgnoreCase(this.triggers, "REGION-ENTER", ",");
        this.giveOnRegionLeave = StringUtils.splitIgnoreCase(this.triggers, "REGION-REMOVE", ",") || StringUtils.splitIgnoreCase(this.triggers, "REGION-EXIT", ",") || StringUtils.splitIgnoreCase(this.triggers, "REGION-LEAVE", ",");
        this.giveOnRegionAccess = StringUtils.splitIgnoreCase(this.triggers, "REGION-ACCESS", ",");
        this.giveOnRegionEgress = StringUtils.splitIgnoreCase(this.triggers, "REGION-EGRESS", ",");
        if (this.giveOnRegionAccess || this.giveOnRegionEgress) {
            this.giveOnRegionEnter = false;
            this.giveOnRegionLeave = false;
            this.giveOnWorldSwitch = false;
        }
        if (this.giveOnRegionEnter || this.giveOnRegionLeave) {
            this.giveOnWorldSwitch = false;
        }
        this.useOnLimitSwitch = StringUtils.splitIgnoreCase(this.triggers, "GAMEMODE-SWITCH", ",");
        this.setOnlyFirstJoin(StringUtils.splitIgnoreCase(this.triggers, "FIRST-JOIN", ","), new boolean[0]);
        this.setOnlyFirstLife(StringUtils.splitIgnoreCase(this.triggers, "FIRST-LIFE", ","), new boolean[0]);
        this.setOnlyFirstWild(StringUtils.splitIgnoreCase(this.triggers, "FIRST-WILD", ","), new boolean[0]);
        this.setOnlyFirstWorld(StringUtils.splitIgnoreCase(this.triggers, "FIRST-WORLD", ","), new boolean[0]);
    }

    public void setContents() {
        if (this.material != null && StringUtils.containsIgnoreCase(this.getMaterial().toString(), "SHULKER") && this.nodeLocation.getString(".contents") != null && !this.nodeLocation.getStringList(".contents").isEmpty()) {
            this.contents = this.nodeLocation.getStringList(".contents");
        } else if (this.material != null && !StringUtils.containsIgnoreCase(this.getMaterial().toString(), "SHULKER") && this.nodeLocation.getString(".contents") != null) {
            this.nodeLocation.getStringList(".contents");
            if (!this.nodeLocation.getStringList(".contents").isEmpty()) {
                ServerUtils.logWarn("{ItemMap} The item " + this.getConfigName() + " cannot have contents set as it does not support it.");
            }
        }
    }

    private void setRegions() {
        String disabledRegions;
        String enabledRegions = this.nodeLocation.getString(".enabled-regions");
        if (enabledRegions != null && !enabledRegions.isEmpty()) {
            String[] enabledParts;
            for (String region : enabledParts = enabledRegions.replaceAll("\\s*,\\s*", ",").split(",")) {
                this.enabledRegions.add(region);
                ItemJoin.getCore().getDependencies().getGuard().addLocaleRegion(region);
            }
        } else if (this.isGiveOnRegionEnter() || this.isGiveOnRegionLeave()) {
            ItemJoin.getCore().getDependencies().getGuard().addLocaleRegion("UNDEFINED");
            this.enabledRegions.add("UNDEFINED");
        }
        if ((disabledRegions = this.nodeLocation.getString(".disabled-regions")) != null && !disabledRegions.isEmpty()) {
            String[] disabledParts;
            for (String region : disabledParts = disabledRegions.replaceAll("\\s*,\\s*", ",").split(",")) {
                this.disabledRegions.add(region);
                ItemJoin.getCore().getDependencies().getGuard().addLocaleRegion(region);
            }
        }
    }

    private void setConditions() {
        String triggerMessage = this.nodeLocation.getString(".trigger-fail-message");
        String triggerConditions = this.nodeLocation.getString(".trigger-conditions");
        List triggerConditionsList = this.nodeLocation.getStringList(".trigger-conditions");
        String disposableMessage = this.nodeLocation.getString(".disposable-fail-message");
        String disposableConditions = this.nodeLocation.getString(".disposable-conditions");
        List disposableConditionsList = this.nodeLocation.getStringList(".disposable-conditions");
        if (triggerMessage != null && !triggerMessage.isEmpty()) {
            this.triggerMessage = triggerMessage;
        }
        if (!triggerConditionsList.isEmpty()) {
            this.triggerConditions = triggerConditionsList;
        } else if (triggerConditions != null && !triggerConditions.isEmpty()) {
            this.triggerConditions.add(triggerConditions);
        }
        if (disposableMessage != null && !disposableMessage.isEmpty()) {
            this.disposableMessage = disposableMessage;
        }
        if (!disposableConditionsList.isEmpty()) {
            this.disposableConditions = disposableConditionsList;
        } else if (disposableConditions != null && !disposableConditions.isEmpty()) {
            this.disposableConditions.add(disposableConditions);
        }
        for (ItemCommand.Action action : ItemCommand.Action.values()) {
            String actionMessage = this.nodeLocation.getString(action.config() + "-fail-message");
            String actionConditions = this.nodeLocation.getString(action.config() + "-conditions");
            List actionConditionsList = this.nodeLocation.getStringList(action.config() + "-conditions");
            if (actionMessage != null && !actionMessage.isEmpty()) {
                this.commandMessages.put(action.config(), actionMessage);
            }
            if (!actionConditionsList.isEmpty()) {
                this.commandConditions.put(action.config(), actionConditionsList);
                continue;
            }
            if (actionConditions == null || actionConditions.isEmpty()) continue;
            ArrayList<String> commandCond = new ArrayList<String>();
            commandCond.add(actionConditions);
            this.commandConditions.put(action.config(), commandCond);
        }
    }

    private void setWorlds() {
        SchedulerUtils.run(() -> {
            String enabledWorlds = this.nodeLocation.getString(".enabled-worlds");
            if (enabledWorlds != null && !enabledWorlds.isEmpty()) {
                String[] enabledParts;
                for (String enabledWorld : enabledParts = enabledWorlds.replaceAll("\\s*,\\s*", ",").split(",")) {
                    if (enabledWorld.equalsIgnoreCase("ALL") || enabledWorld.equalsIgnoreCase("GLOBAL")) {
                        this.enabledWorlds.add("ALL");
                    }
                    if (enabledWorld.equalsIgnoreCase("DISABLED") || enabledWorld.equalsIgnoreCase("DISABLE")) {
                        this.enabledWorlds.add("DISABLED");
                        continue;
                    }
                    for (World world : Bukkit.getServer().getWorlds()) {
                        if (enabledWorld.equalsIgnoreCase(world.getName())) {
                            this.enabledWorlds.add(world.getName());
                            continue;
                        }
                        if (!enabledWorld.contains("*") || !world.getName().toUpperCase().startsWith(enabledWorld.split("\\*")[0].toUpperCase())) continue;
                        this.enabledWorlds.add(enabledWorld);
                    }
                }
            } else {
                this.enabledWorlds.add("ALL");
            }
            String disabledWorlds = this.nodeLocation.getString(".disabled-worlds");
            if (disabledWorlds != null && !disabledWorlds.isEmpty()) {
                String[] disabledParts;
                for (String disabledWorld : disabledParts = disabledWorlds.replaceAll("\\s*,\\s*", ",").split(",")) {
                    if (disabledWorld.equalsIgnoreCase("ALL") || disabledWorld.equalsIgnoreCase("GLOBAL")) {
                        this.disabledWorlds.add("ALL");
                        continue;
                    }
                    for (World world : Bukkit.getServer().getWorlds()) {
                        if (disabledWorld.equalsIgnoreCase(world.getName())) {
                            this.disabledWorlds.add(world.getName());
                            continue;
                        }
                        if (!disabledWorld.contains("*") || !world.getName().toUpperCase().startsWith(disabledWorld.split("\\*")[0].toUpperCase())) continue;
                        this.disabledWorlds.add(disabledWorld);
                    }
                }
            }
        });
    }

    private void setPlayersOnCooldown() {
        if (this.cooldownSeconds > 0) {
            List<Object> dataList = ItemJoin.getCore().getSQL().getDataList(new DataObject(DataObject.Table.ON_COOLDOWN, null, null, this.getConfigName(), String.valueOf(this.getCommandCooldown()), null));
            for (Object dataObject : dataList) {
                if (dataObject == null) continue;
                this.playersOnCooldown.put(((DataObject)dataObject).getPlayerId(), Long.parseLong(((DataObject)dataObject).getDuration()));
                ItemJoin.getCore().getSQL().removeData(new DataObject(DataObject.Table.ON_COOLDOWN, null, null, this.getConfigName(), String.valueOf(this.getCommandCooldown()), null), new boolean[0]);
            }
        }
    }

    public void renderItemStack() {
        this.tempItem = this.dataValue != null ? LegacyAPI.newItemStack(this.material, 1, this.dataValue) : new ItemStack(this.material, 1);
    }

    public void removeFromAnimationHandler(Player player) {
        this.localeAnimations.remove(player);
    }

    public void setCount(String count) {
        this.count = count == null || count.isEmpty() ? "1" : count;
    }

    private void addWarmPending(Player player) {
        if (!this.warmPending.contains(player)) {
            this.warmPending.add(player);
        }
    }

    private void delWarmPending(Player player) {
        this.warmPending.remove(player);
    }

    public void addRecipe(List<Character> recipe) {
        this.recipe.add(recipe);
    }

    public void setPerm(String permission) {
        this.permissionNode = permission == null || permission.isEmpty() ? null : permission;
    }

    public void setTogglePerm(String permission) {
        this.toggleNode = permission == null || permission.isEmpty() ? null : permission;
    }

    public void setAnimate(boolean bool) {
        this.animate = bool;
    }

    public void setCloseInventory(boolean bool) {
        this.closeInventory = bool;
    }

    public void setMapView(MapView view) {
        this.mapView = view;
    }

    public Map<Object, Object> getNBTProperties() {
        return this.nbtProperty;
    }

    public void setNBTProperties(Map<Object, Object> tagValues) {
        this.nbtProperty = tagValues;
    }

    public void delToggleCommands() {
        if (!this.togglePlugins.isEmpty()) {
            ServerUtils.unregisterCommands(this.togglePlugins);
        }
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    private void setCustomName(Player player) {
        if (this.customName != null && !this.customName.equalsIgnoreCase(ItemHandler.getMaterialName(this.tempItem))) {
            if (this.legacySecret != null && !ServerUtils.hasSpecificUpdate("1_14")) {
                String itemData = this.tempMeta.getDisplayName();
                this.tempMeta.setDisplayName(StringUtils.translateLayout(ItemHandler.cutDelay(this.customName), player, new PlaceHolder[0]) + '\u00a7' + "r" + itemData);
            } else {
                this.tempMeta.setDisplayName(StringUtils.translateLayout(ItemHandler.cutDelay(this.customName), player, new PlaceHolder[0]));
            }
        }
    }

    public List<String> getDynamicNames() {
        return this.dynamicNames;
    }

    public void setDynamicNames(List<String> names) {
        this.dynamicNames = names;
    }

    public List<String> getCustomLore() {
        return this.customLore;
    }

    public void setCustomLore(List<String> customLore) {
        this.customLore = new ArrayList<String>();
        this.customLore.addAll(customLore);
    }

    private void setCustomLore(Player player) {
        if (this.customLore != null && !this.customLore.isEmpty()) {
            List<String> loreList = this.customLore;
            ArrayList<String> loreFormatList = new ArrayList<String>();
            for (String s : loreList) {
                String formatLore = ItemHandler.cutDelay(s);
                formatLore = StringUtils.translateLayout(formatLore, player, new PlaceHolder[0]);
                loreFormatList.add(formatLore);
            }
            this.tempMeta.setLore(loreFormatList);
        }
    }

    public List<List<String>> getDynamicLores() {
        return this.dynamicLores;
    }

    public void setDynamicLores(List<List<String>> lores) {
        this.dynamicLores = lores;
    }

    public List<String> getDynamicMaterials() {
        return this.dynamicMaterials;
    }

    public void setDynamicMaterials(List<String> mats) {
        this.dynamicMaterials = mats;
        this.materialAnimated = true;
    }

    public List<String> getDynamicOwners() {
        return this.dynamicOwners;
    }

    public void setDynamicOwners(List<String> owners) {
        this.dynamicOwners = owners;
    }

    public List<String> getDynamicTextures() {
        return this.dynamicTextures;
    }

    public void setDynamicTextures(List<String> textures) {
        this.dynamicTextures = textures;
    }

    public Map<Player, ItemAnimation> getAnimationHandler() {
        if (this.localeAnimations == null) {
            this.localeAnimations = new HashMap<Player, ItemAnimation>();
        }
        return this.localeAnimations;
    }

    public String getSlot() {
        if (this.CustomSlot != null) {
            return this.CustomSlot;
        }
        if (this.InvSlot != null) {
            return this.InvSlot.toString();
        }
        return null;
    }

    public void setSlot(String slot) {
        if (ItemHandler.isCustomSlot(slot)) {
            this.CustomSlot = slot;
            this.InvSlot = null;
        } else if (StringUtils.isInt(slot)) {
            this.InvSlot = Integer.parseInt(slot);
            this.CustomSlot = null;
        }
    }

    public String getUISlot() {
        if (this.CustomSlot != null && !this.CustomSlot.contains("%")) {
            return this.CustomSlot;
        }
        if (this.CustomSlot != null) {
            return "0";
        }
        if (this.InvSlot != null) {
            return this.InvSlot.toString();
        }
        return null;
    }

    public List<String> getMultipleSlots() {
        return this.AllSlots;
    }

    public void setMultipleSlots(List<String> slots) {
        this.AllSlots = slots;
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public void setDisabledWorlds(List<String> worlds) {
        this.disabledWorlds = worlds;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public void setEnabledWorlds(List<String> worlds) {
        this.enabledWorlds = worlds;
    }

    public List<String> getDisabledRegions() {
        return this.disabledRegions;
    }

    public void setDisabledRegions(List<String> regions) {
        this.disabledRegions = regions;
    }

    public List<String> getEnabledRegions() {
        return this.enabledRegions;
    }

    public void setEnabledRegions(List<String> regions) {
        this.enabledRegions = regions;
    }

    public List<String> getContents() {
        return this.contents;
    }

    public void setContents(List<String> contents) {
        this.contents = contents;
    }

    private void setContents(Player player) {
        if (this.contents != null && !this.contents.isEmpty() && ServerUtils.hasSpecificUpdate("1_11")) {
            ShulkerBox box = (ShulkerBox)((BlockStateMeta)this.tempMeta).getBlockState();
            box.getInventory().clear();
            for (String node : this.contents) {
                boolean isNull = true;
                for (ItemMap item : ItemUtilities.getUtilities().getItems()) {
                    if (item == null || !item.getConfigName().equalsIgnoreCase(node)) continue;
                    isNull = false;
                    if (StringUtils.isInt(item.getSlot()) && Integer.parseInt(item.getSlot()) <= 26) {
                        box.getInventory().setItem(Integer.parseInt(item.getSlot()), item.getItemStack(player));
                        continue;
                    }
                    if (item.getSlot().equalsIgnoreCase("ARBITRARY")) {
                        box.getInventory().addItem(new ItemStack[]{item.getItemStack(player)});
                        continue;
                    }
                    if (StringUtils.isInt(item.getSlot()) && Integer.parseInt(item.getSlot()) > 26) {
                        ServerUtils.logWarn("{ItemMap} The item " + node + " cannot have the slot " + item.getSlot() + " as the slot cannot be higher than 26 to be set as contents for the item " + this.getConfigName() + ", the item will not be set.");
                        continue;
                    }
                    if (StringUtils.isInt(item.getSlot())) continue;
                    ServerUtils.logWarn("{ItemMap} The item " + node + " cannot have the slot " + item.getSlot() + " as the item " + this.getConfigName() + " does not support it, the item will not be set.");
                }
                if (!isNull) continue;
                ServerUtils.logWarn("{ItemMap} The item " + node + " does not exist and will not be set as contents for " + this.getConfigName() + ".");
            }
            ((BlockStateMeta)this.tempMeta).setBlockState((BlockState)box);
            box.update();
        }
    }

    public Map<String, Integer> getEnchantments() {
        return this.enchants;
    }

    public void setEnchantments(Map<String, Integer> enchantments) {
        this.enchants = enchantments;
    }

    private void setEnchantments(Player player) {
        Map<String, Integer> enchantStats;
        Map<String, Integer> map = enchantStats = player != null ? ItemUtilities.getUtilities().getStatistics(player).getEnchantments(this) : null;
        if (enchantStats != null && !enchantStats.isEmpty()) {
            for (Map.Entry<String, Integer> enchantments : enchantStats.entrySet()) {
                if (enchantments.getKey() == null && ItemJoin.getCore().getDependencies().tokenEnchantEnabled() && TokenEnchantAPI.getInstance().getEnchantment(enchantments.getKey()) != null) {
                    TokenEnchantAPI.getInstance().enchant(player, this.tempItem, enchantments.getKey(), enchantments.getValue().intValue(), true, 0.0, true);
                    continue;
                }
                this.tempItem.addUnsafeEnchantment(Objects.requireNonNull(ItemHandler.getEnchantByName(enchantments.getKey())), enchantments.getValue().intValue());
            }
        }
    }

    public Integer getCount(Player player) {
        int countParse = 1;
        if (this.count != null && !this.count.isEmpty()) {
            try {
                String translateCount = StringUtils.translateLayout(this.count, player, new PlaceHolder[0]).replaceAll("[^\\d.]", "").replace("-", "").replace(".", "").replace(" ", "");
                if (countParse > 127) {
                    for (countParse = Integer.parseInt(translateCount); countParse > 127; countParse -= 127) {
                    }
                }
                if (countParse == 0) {
                    countParse = 1;
                }
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
                ServerUtils.logSevere("{ItemMap} The count set for the item " + this.configName + " is set to " + this.count + " but this is not a valid integer!");
                ServerUtils.logSevere("{ItemMap} Check that the set value is an integer or placeholder that parses to an integer.");
                ServerUtils.logSevere("{ItemMap} The count for the item " + this.configName + " will now default to 1.");
            }
        }
        return countParse;
    }

    public String getRawCount() {
        return this.count;
    }

    public Map<String, Double> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Double> attributeList) {
        if (attributeList != null && !attributeList.isEmpty()) {
            this.attributes = attributeList;
        }
    }

    public String getItemFlags() {
        return this.itemflags;
    }

    public void setItemFlags(String itemflags) {
        this.itemflags = itemflags;
    }

    public String getTriggers() {
        return this.triggers;
    }

    public void setTriggers(String triggers) {
        this.triggers = triggers;
    }

    public String getPermissionNode() {
        return this.permissionNode;
    }

    public String getToggleNode() {
        return this.toggleNode;
    }

    public String getToggleMessage() {
        return this.toggleMessage;
    }

    public void setToggleMessage(String message) {
        this.toggleMessage = message;
    }

    public Short getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(Short dataValue) {
        if (dataValue == null || dataValue == 0) {
            this.dataValue = null;
            return;
        }
        this.dataValue = dataValue;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material mat) {
        this.material = mat;
    }

    public Short getDurability() {
        if (this.durability != null) {
            return this.durability;
        }
        return (short)0;
    }

    public void setDurability(Short durability) {
        this.durability = durability;
    }

    public Integer getData() {
        if (this.data != null) {
            return this.data;
        }
        return 0;
    }

    public void setData(Integer data) {
        this.data = data;
    }

    public List<String> getModelComponents() {
        if (this.modelComponents != null) {
            return this.modelComponents;
        }
        return null;
    }

    public void setModelComponents(List<String> data) {
        this.modelComponents = data;
    }

    public String getModelData() {
        if (this.modelData != null) {
            return this.modelData;
        }
        return null;
    }

    public void setModelData(String data) {
        this.modelData = data;
    }

    private void setModelData(Player player) {
        if (this.modelData != null) {
            if (StringUtils.isInt(this.modelData)) {
                int modelData = Integer.parseInt(StringUtils.translateLayout(this.modelData, player, new PlaceHolder[0]));
                if (modelData != 0) {
                    if (ServerUtils.hasSpecificUpdate("1_14")) {
                        this.tempMeta.setCustomModelData(Integer.valueOf(modelData));
                    } else {
                        ServerUtils.logWarn("{ItemMap} The item " + this.getConfigName() + " is using Custom Model Data which is not supported until Minecraft 1.14+.");
                    }
                }
            } else if (ServerUtils.hasPreciseUpdate("1_21_3")) {
                this.tempMeta.setItemModel(NamespacedKey.fromString((String)StringUtils.translateLayout(this.modelData, player, new PlaceHolder[0])));
            } else {
                ServerUtils.logWarn("{ItemMap} The item " + this.getConfigName() + " is using Custom Model Data that is not an integer, item model names are not supported until Minecraft 1.21.4+.");
            }
        } else {
            this.setModelComponents(player);
        }
    }

    private void setModelComponents(Player player) {
        if (this.modelComponents != null && ServerUtils.hasPreciseUpdate("1_21_4")) {
            CustomModelDataComponent component = this.tempMeta.getCustomModelDataComponent();
            if (this.modelComponents.get(0) != null) {
                ArrayList<String> strings = new ArrayList<String>();
                for (String string : this.modelComponents.get(0).replaceAll("\\s*,\\s*", ",").split(",")) {
                    strings.add(StringUtils.translateLayout(string.trim(), player, new PlaceHolder[0]));
                }
                component.setStrings(strings);
            }
            if (this.modelComponents.get(1) != null) {
                ArrayList<Color> colors = new ArrayList<Color>();
                for (String color : this.modelComponents.get(1).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        colors.add(DyeColor.valueOf((String)StringUtils.translateLayout(color, player, new PlaceHolder[0]).toUpperCase()).getColor());
                    }
                    catch (IllegalArgumentException e) {
                        ServerUtils.logSevere("{ItemMap} Invalid Model Component Color: " + color + " for " + this.getConfigName() + ".");
                        ServerUtils.sendDebugTrace(e);
                    }
                }
                component.setColors(colors);
            }
            if (this.modelComponents.get(2) != null) {
                ArrayList<Boolean> flags = new ArrayList<Boolean>();
                for (String bool : this.modelComponents.get(2).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        flags.add(Boolean.parseBoolean(StringUtils.translateLayout(bool, player, new PlaceHolder[0]).trim()));
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{ItemMap} Invalid Model Component Flag: " + bool + " for " + this.getConfigName() + ".");
                        ServerUtils.sendDebugTrace(e);
                    }
                }
                component.setFlags(flags);
            }
            if (this.modelComponents.get(3) != null) {
                ArrayList<Float> floats = new ArrayList<Float>();
                for (String _float : this.modelComponents.get(3).replaceAll("\\s*,\\s*", ",").split(",")) {
                    try {
                        floats.add(Float.valueOf(Float.parseFloat(StringUtils.translateLayout(_float, player, new PlaceHolder[0]).trim())));
                    }
                    catch (NumberFormatException e) {
                        ServerUtils.logSevere("{ItemMap} Invalid Model Component Float: " + _float + " for " + this.getConfigName() + ".");
                        ServerUtils.sendDebugTrace(e);
                    }
                }
                component.setFloats(floats);
            }
            this.tempMeta.setCustomModelDataComponent(component);
        }
    }

    public Map<EntityType, Double> getMobsDrop() {
        return this.mobsDrop;
    }

    public void setMobsDrop(Map<EntityType, Double> mobsDrop) {
        this.mobsDrop = mobsDrop;
    }

    public boolean mobsDrop() {
        return this.mobsDrop != null && !this.mobsDrop.isEmpty();
    }

    public Map<Material, Double> getBlocksDrop() {
        return this.blocksDrop;
    }

    public void setBlocksDrop(Map<Material, Double> blocksDrop) {
        this.blocksDrop = blocksDrop;
    }

    public boolean blocksDrop() {
        return this.blocksDrop != null && !this.blocksDrop.isEmpty();
    }

    public Integer getProbability() {
        return this.probability != null ? this.probability : 0;
    }

    public void setProbability(Integer probability) {
        this.probability = probability;
    }

    public String getCommandSound() {
        return this.commandSound;
    }

    public void setCommandSound(String sound) {
        this.commandSound = sound;
    }

    public Double getCommandVolume() {
        return this.commandSoundVolume;
    }

    public void setCommandVolume(Double volume) {
        this.commandSoundVolume = volume;
    }

    public Double getCommandPitch() {
        return this.commandSoundPitch;
    }

    public void setCommandPitch(Double pitch) {
        this.commandSoundPitch = pitch;
    }

    public Integer getWarmDelay() {
        return this.warmDelay;
    }

    public void setWarmDelay(Integer delay) {
        this.warmDelay = delay;
    }

    private boolean getWarmPending(Player player) {
        return this.warmPending.contains(player);
    }

    public ItemStack getItemStack(Player player) {
        this.updateItem(player, new boolean[0]);
        return this.tempItem.clone();
    }

    public ItemStack getTempItem() {
        return this.tempItem;
    }

    public void setTempItem(ItemStack temp) {
        this.tempItem = temp;
    }

    public String getConfigName() {
        return this.configName;
    }

    public List<Pattern> getBannerPatterns() {
        return this.bannerPatterns;
    }

    public void setBannerPatterns(List<Pattern> patterns) {
        this.bannerPatterns = patterns;
    }

    public Map<String, String> getTrimPattern() {
        return this.trimPattern;
    }

    public void setTrimPattern(Map<String, String> pattern) {
        this.trimPattern = pattern;
    }

    public Map<Character, ItemRecipe> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(Map<Character, ItemRecipe> ingredientList) {
        this.ingredients = ingredientList;
    }

    public boolean isRecipe() {
        return !this.ingredients.isEmpty() && !this.getRecipe().isEmpty();
    }

    public List<List<Character>> getRecipe() {
        return this.recipe;
    }

    public void setRecipe(List<Character> recipe) {
        this.recipe = new ArrayList<List<Character>>();
        this.recipe.add(recipe);
    }

    public ConfigurationSection getNodeLocation() {
        return this.nodeLocation;
    }

    public String getLimitModes() {
        if (this.limitModes != null) {
            return this.limitModes;
        }
        return "NONE";
    }

    public void setLimitModes(String str) {
        this.limitModes = str;
    }

    public ItemCommand[] getCommands() {
        return this.commands;
    }

    public void setCommands(ItemCommand[] commands) {
        this.commands = commands;
    }

    public List<String> getToggleCommands() {
        return this.toggleCommands;
    }

    private void setToggleCommands(String toggleSingle) {
        ArrayList<String> commandList = new ArrayList<String>();
        if (toggleSingle != null && !this.nodeLocation.getStringList(".toggle").isEmpty() || toggleSingle == null && this.toggleCommands != null && !this.toggleCommands.isEmpty()) {
            for (String command : toggleSingle != null ? this.nodeLocation.getStringList(".toggle") : this.toggleCommands) {
                PluginCommand cmd = null;
                try {
                    Constructor pluginCommand = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                    pluginCommand.setAccessible(true);
                    cmd = (PluginCommand)pluginCommand.newInstance(command.contains(" ") ? command.split(" ")[0] : command, ItemJoin.getCore().getPlugin());
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
                if (cmd == null) continue;
                cmd.setDescription(this.configName);
                cmd.setExecutor((CommandExecutor)new ChatToggleExecutor());
                cmd.setTabCompleter((TabCompleter)new ChatToggleTab());
                this.togglePlugins.add(cmd);
                commandList.add(command);
            }
        } else if (toggleSingle != null && !toggleSingle.isEmpty() && !toggleSingle.equalsIgnoreCase(" ")) {
            PluginCommand cmd = null;
            try {
                Constructor pluginCommand = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                pluginCommand.setAccessible(true);
                cmd = (PluginCommand)pluginCommand.newInstance(toggleSingle.contains(" ") ? toggleSingle.split(" ")[0] : toggleSingle, ItemJoin.getCore().getPlugin());
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
            if (cmd != null) {
                cmd.setDescription(this.configName);
                cmd.setExecutor((CommandExecutor)new ChatToggleExecutor());
                cmd.setTabCompleter((TabCompleter)new ChatToggleTab());
                this.togglePlugins.add(cmd);
                commandList.add(toggleSingle);
            }
        }
        ServerUtils.registerCommands(this.togglePlugins);
        this.toggleCommands = commandList;
    }

    public void setToggleCommands(List<String> commands) {
        this.toggleCommands = commands;
        this.setToggleCommands((String)null);
    }

    public Integer getCommandCooldown() {
        return this.cooldownSeconds;
    }

    public void setCommandCooldown(int i) {
        this.cooldownSeconds = i;
    }

    public double getCommandCost(Player player) {
        double costParse = 0.0;
        if (this.cost != null && !this.cost.isEmpty()) {
            try {
                String translateCost = StringUtils.translateLayout(this.cost, player, new PlaceHolder[0]).replaceAll("[^\\d.]", "").replace("-", "").replace(".", "").replace(" ", "");
                costParse = Double.parseDouble(translateCost);
                if (costParse < 0.0) {
                    costParse = 0.0;
                }
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
                ServerUtils.logSevere("{ItemMap} The commands-cost set for the item " + this.configName + " is set to " + this.cost + " but this is not a valid integer!");
                ServerUtils.logSevere("{ItemMap} Check that the set value is an integer or placeholder that parses to an integer.");
                ServerUtils.logSevere("{ItemMap} The commands-cost for the item " + this.configName + " will now default to 0.");
            }
        }
        return costParse;
    }

    public String getRawCost() {
        return this.cost;
    }

    public void setCommandCost(String cost) {
        this.cost = cost == null || cost.isEmpty() ? "0" : cost;
    }

    public Integer getCommandReceive() {
        return this.commandsReceive;
    }

    public void setCommandReceive(Integer val) {
        this.commandsReceive = val;
    }

    public String getItemCost() {
        return this.itemCost;
    }

    public void setItemCost(String itemCost) {
        this.itemCost = itemCost;
    }

    public String getCommandParticle() {
        return this.commandParticle;
    }

    public void setCommandParticle(String s) {
        this.commandParticle = s;
    }

    public ItemCommand.CommandSequence getCommandSequence() {
        return this.sequence;
    }

    public void setCommandSequence(ItemCommand.CommandSequence sequence) {
        this.sequence = sequence;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String auth) {
        this.author = auth;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BookMeta.Generation getGeneration() {
        return (BookMeta.Generation)this.generation;
    }

    public void setGeneration(BookMeta.Generation gen) {
        this.generation = gen;
    }

    public List<String> getPages() {
        return this.bookPages;
    }

    public void setPages(List<String> pages) {
        this.bookPages = pages;
    }

    public List<List<String>> getListPages() {
        return this.listPages;
    }

    public void setListPages(List<List<String>> pages) {
        this.listPages = pages;
    }

    public int getMapID() {
        return this.mapId;
    }

    public void setMapID(int id) {
        this.mapId = (short)id;
    }

    public String getMapImage() {
        return this.customMapImage;
    }

    public void setMapImage(String mapIMG) {
        this.customMapImage = mapIMG;
    }

    public FireworkEffect getFirework() {
        return this.firework;
    }

    public void setFirework(FireworkEffect fire) {
        this.firework = fire;
    }

    public FireworkEffect.Type getFireworkType() {
        return this.fireworkType;
    }

    public void setFireworkType(FireworkEffect.Type buildType) {
        this.fireworkType = buildType;
    }

    public int getFireworkPower() {
        return this.power;
    }

    public void setFireworkPower(int power) {
        this.power = power;
    }

    public List<DyeColor> getFireworkColor() {
        return this.fireworkColor;
    }

    public void setFireworkColor(List<DyeColor> colors) {
        this.fireworkColor = colors;
    }

    public boolean getFireworkTrail() {
        return this.fireworkTrail;
    }

    public void setFireworkTrail(boolean bool) {
        this.fireworkTrail = bool;
    }

    public boolean getFireworkFlicker() {
        return this.fireworkFlicker;
    }

    public void setFireworkFlicker(boolean bool) {
        this.fireworkFlicker = bool;
    }

    public DyeColor getChargeColor() {
        return this.chargeColor;
    }

    public void setChargeColor(DyeColor dyeColor) {
        this.chargeColor = dyeColor;
    }

    public String getSkull() {
        return this.skullOwner;
    }

    public String getSkullTexture() {
        return this.skullTexture;
    }

    public void setSkullTexture(String skull) {
        this.skullTexture = skull;
    }

    public List<PotionEffect> getPotionEffect() {
        return this.effect;
    }

    public void setPotionEffect(List<PotionEffect> potion) {
        this.effect = potion;
    }

    public String getLeatherColor() {
        return this.leatherColor;
    }

    public void setLeatherColor(String color) {
        this.leatherColor = color;
    }

    public String getLeatherHex() {
        return this.leatherHex;
    }

    public void setLeatherHex(String hex) {
        this.leatherHex = hex;
    }

    public String getLegacySecret() {
        if (!ItemJoin.getCore().getData().dataTagsEnabled()) {
            return this.legacySecret;
        }
        return null;
    }

    public void setLegacySecret(String nbt) {
        this.legacySecret = nbt;
    }

    public int getInteractCooldown() {
        return this.interactCooldown;
    }

    public void setInteractCooldown(int cooldown) {
        this.interactCooldown = cooldown;
    }

    public String getTeleportEffect() {
        return this.teleportEffect;
    }

    public void setTeleportEffect(String name) {
        this.teleportEffect = name;
    }

    public String getTeleportSound() {
        return this.teleportSound;
    }

    public void setTeleportSound(String name) {
        this.teleportSound = name;
    }

    public Double getTeleportVolume() {
        return this.teleportSoundVolume;
    }

    public void setTeleportVolume(Double volume) {
        this.teleportSoundVolume = volume;
    }

    public Double getTeleportPitch() {
        return this.teleportSoundPitch;
    }

    public void setTeleportPitch(Double pitch) {
        this.teleportSoundPitch = pitch;
    }

    public String getCooldownMessage() {
        return this.cooldownMessage;
    }

    public void setCooldownMessage(String s) {
        this.cooldownMessage = s;
    }

    public String getTriggerMessage() {
        return this.triggerMessage;
    }

    public void setTriggerMessage(String s) {
        this.triggerMessage = s;
    }

    public List<String> getTriggerConditions() {
        return this.triggerConditions;
    }

    public void setTriggerConditions(List<String> s) {
        this.triggerConditions = s;
    }

    public String getDisposableMessage() {
        return this.disposableMessage;
    }

    public void setDisposableMessage(String s) {
        this.disposableMessage = s;
    }

    public List<String> getDisposableConditions() {
        return this.disposableConditions;
    }

    public void setDisposableConditions(List<String> s) {
        this.disposableConditions = s;
    }

    public Map<String, String> getCommandMessages() {
        return this.commandMessages;
    }

    public void setCommandMessages(Map<String, String> messages) {
        this.commandMessages = messages;
    }

    public Map<String, List<String>> getCommandPermissions() {
        return this.commandPermissions;
    }

    public void setCommandPermissions(Map<String, List<String>> permissions) {
        this.commandPermissions = permissions;
    }

    public Map<String, List<String>> getCommandConditions() {
        return this.commandConditions;
    }

    public void setCommandConditions(Map<String, List<String>> conditions) {
        this.commandConditions = conditions;
    }

    public String getNBTFormat() {
        return this.getConfigName();
    }

    public boolean isCustomConsumable() {
        return this.customConsumable;
    }

    public void setCustomConsumable(boolean bool) {
        this.customConsumable = bool;
    }

    public boolean hasPermission(Player player, World world) {
        boolean hasCustomPermission;
        String customPerm = PermissionsHandler.customPermissions(this.permissionNode, world.getName() + "." + this.configName);
        boolean isNeeded = !customPerm.startsWith("!");
        String permissionString = isNeeded ? customPerm : customPerm.substring(1);
        boolean hasPermission = player.isPermissionSet(permissionString) && player.hasPermission(permissionString);
        boolean bl = hasCustomPermission = !isNeeded && !hasPermission || isNeeded && hasPermission;
        if (!this.isPermissionNeeded() && !player.isOp() || !this.isOPPermissionNeeded() && player.isOp()) {
            return true;
        }
        if (this.isOPPermissionNeeded() && player.isOp()) {
            return hasCustomPermission || player.isPermissionSet("itemjoin." + world.getName() + ".*") && player.hasPermission("itemjoin." + world.getName() + ".*");
        }
        return player.isPermissionSet("itemjoin." + world.getName() + ".*") && player.hasPermission("itemjoin." + world.getName() + ".*") || hasCustomPermission;
    }

    public boolean isCraftingItem() {
        return this.craftingItem;
    }

    public boolean isHeadDatabase() {
        return this.headDatabase;
    }

    public void setHeadDatabase(boolean head) {
        this.headDatabase = head;
    }

    public boolean isGiveOnJoin() {
        return this.giveOnJoin;
    }

    public void setGiveOnJoin(boolean bool) {
        this.giveOnJoin = bool;
    }

    public boolean isGiveOnTeleport() {
        return this.giveOnTeleport;
    }

    public void setGiveOnTeleport(boolean bool) {
        this.giveOnTeleport = bool;
    }

    public boolean isGiveOnWorldSwitch() {
        return this.giveOnWorldSwitch;
    }

    public void setGiveOnWorldSwitch(boolean bool) {
        this.giveOnWorldSwitch = bool;
    }

    public boolean isGiveOnPermissionSwitch() {
        return this.giveOnPermissionSwitch;
    }

    public void setGiveOnPermissionSwitch(boolean bool) {
        this.giveOnPermissionSwitch = bool;
    }

    public boolean isGiveOnRespawn() {
        return this.giveOnRespawn;
    }

    public void setGiveOnRespawn(boolean bool) {
        this.giveOnRespawn = bool;
    }

    public boolean isGiveOnRespawnWild() {
        return this.giveOnRespawnWild;
    }

    public void setGiveOnRespawnWild(boolean bool) {
        this.giveOnRespawnWild = bool;
    }

    public boolean isGiveOnRespawnPoint() {
        return this.giveOnRespawnPoint;
    }

    public void setGiveOnRespawnPoint(boolean bool) {
        this.giveOnRespawnPoint = bool;
    }

    public boolean isGiveOnRegionEnter() {
        return this.giveOnRegionEnter;
    }

    public void setGiveOnRegionEnter(boolean bool) {
        this.giveOnRegionEnter = bool;
    }

    public boolean isGiveOnRegionLeave() {
        return this.giveOnRegionLeave;
    }

    public void setGiveOnRegionLeave(boolean bool) {
        this.giveOnRegionLeave = bool;
    }

    public boolean isGiveOnRegionAccess() {
        return this.giveOnRegionAccess;
    }

    public void setGiveOnRegionAccess(boolean bool) {
        this.giveOnRegionAccess = bool;
    }

    public boolean isGiveOnRegionEgress() {
        return this.giveOnRegionEgress;
    }

    public void setGiveOnRegionEgress(boolean bool) {
        this.giveOnRegionEgress = bool;
    }

    public boolean isGiveOnDisabled() {
        return this.giveOnDisabled;
    }

    public void setGiveOnDisabled(boolean bool) {
        this.giveOnDisabled = bool;
    }

    public boolean isOnlyFirstJoin() {
        return this.onlyFirstJoin;
    }

    public void setOnlyFirstJoin(boolean bool, boolean ... unset) {
        this.onlyFirstJoin = bool;
        if (!(!bool || this.giveOnRegionEnter || this.giveOnRegionLeave || this.giveOnRegionAccess || this.giveOnRegionEgress)) {
            this.giveOnJoin = true;
            this.giveOnRespawn = false;
            this.giveOnRespawnWild = false;
            this.giveOnRespawnPoint = false;
            this.giveOnTeleport = false;
        } else if (!bool && unset.length > 0 && unset[0]) {
            this.giveOnJoin = false;
        }
    }

    public boolean isOnlyFirstLife() {
        return this.onlyFirstLife;
    }

    public void setOnlyFirstLife(boolean bool, boolean ... unset) {
        this.onlyFirstLife = bool;
        if (!(!bool || this.giveOnRegionEnter || this.giveOnRegionLeave || this.giveOnRegionAccess || this.giveOnRegionEgress)) {
            this.giveOnJoin = true;
            this.giveOnRespawn = true;
            this.giveOnTeleport = false;
        } else if (!bool && unset.length > 0 && unset[0]) {
            this.giveOnJoin = false;
            this.giveOnRespawn = false;
        }
    }

    public boolean isOnlyFirstWild() {
        return this.onlyFirstWild;
    }

    public void setOnlyFirstWild(boolean bool, boolean ... unset) {
        this.onlyFirstWild = bool;
        if (!(!bool || this.giveOnRegionEnter || this.giveOnRegionLeave || this.giveOnRegionAccess || this.giveOnRegionEgress)) {
            this.giveOnJoin = true;
            this.giveOnRespawnWild = true;
            this.giveOnTeleport = false;
        } else if (!bool && unset.length > 0 && unset[0]) {
            this.giveOnJoin = false;
            this.giveOnRespawnWild = false;
        }
    }

    public boolean isOnlyFirstWorld() {
        return this.onlyFirstWorld;
    }

    public void setOnlyFirstWorld(boolean bool, boolean ... unset) {
        this.onlyFirstWorld = bool;
        if (!(!bool || this.giveOnRegionEnter || this.giveOnRegionLeave || this.giveOnRegionAccess || this.giveOnRegionEgress)) {
            this.giveOnJoin = true;
            this.giveOnWorldSwitch = true;
            this.giveOnRespawn = false;
            this.giveOnRespawnWild = false;
            this.giveOnRespawnPoint = false;
            this.giveOnTeleport = false;
        } else if (!bool && unset.length > 0 && unset[0]) {
            this.giveOnJoin = false;
            this.giveOnWorldSwitch = false;
        }
    }

    public boolean isIpLimited() {
        return this.ipLimited;
    }

    public void setIpLimited(boolean bool) {
        this.ipLimited = bool;
    }

    public boolean isUseOnLimitSwitch() {
        return this.useOnLimitSwitch;
    }

    public void setUseOnLimitSwitch(boolean bool) {
        this.useOnLimitSwitch = bool;
    }

    public boolean isLimitMode(GameMode newMode) {
        if (this.limitModes != null) {
            return StringUtils.containsIgnoreCase(this.limitModes, newMode.name());
        }
        return true;
    }

    public Boolean inRegion(String region) {
        if ((this.enabledRegions == null || this.enabledRegions.isEmpty()) && (this.disabledRegions == null || this.disabledRegions.isEmpty())) {
            return true;
        }
        if (this.enabledRegions != null && !this.enabledRegions.isEmpty()) {
            for (String compareRegion : this.enabledRegions) {
                if (!compareRegion.equalsIgnoreCase(region) && !compareRegion.equalsIgnoreCase("UNDEFINED")) continue;
                return !this.isDisabledRegion(region);
            }
        } else {
            return !this.isDisabledRegion(region);
        }
        return false;
    }

    public Boolean inRegion(List<String> regions) {
        if ((this.enabledRegions == null || this.enabledRegions.isEmpty()) && (this.disabledRegions == null || this.disabledRegions.isEmpty())) {
            return true;
        }
        int inRegion = 0;
        for (String region : regions) {
            if (this.enabledRegions != null) {
                for (String compareRegion : this.enabledRegions) {
                    if (!compareRegion.equalsIgnoreCase(region) && !compareRegion.equalsIgnoreCase("UNDEFINED") || inRegion == 2) continue;
                    inRegion = 1;
                }
            }
            if (this.disabledRegions == null) continue;
            for (String compareRegion : this.disabledRegions) {
                if (!compareRegion.equalsIgnoreCase(region) && !compareRegion.equalsIgnoreCase("UNDEFINED")) continue;
                if (this.enabledRegions == null || this.enabledRegions.isEmpty()) {
                    inRegion = 1;
                    continue;
                }
                if (inRegion == 2) continue;
                inRegion = !this.isDisabledRegion(compareRegion) ? inRegion : 2;
            }
        }
        return inRegion == 1;
    }

    public boolean isDisabledRegion(String region) {
        boolean isDisabled = false;
        if (this.disabledRegions != null) {
            for (String disabledRegion : this.disabledRegions) {
                if (!disabledRegion.equalsIgnoreCase(region)) continue;
                isDisabled = true;
                break;
            }
        }
        return isDisabled;
    }

    public boolean isPermissionNeeded() {
        return this.permissionNeeded;
    }

    public void setPermissionNeeded(boolean bool) {
        this.permissionNeeded = bool;
    }

    public boolean isOPPermissionNeeded() {
        return this.opPermissionNeeded;
    }

    public void setOPPermissionNeeded(boolean bool) {
        this.opPermissionNeeded = bool;
    }

    public boolean isCMDPermissionNeeded() {
        return this.cmdPermissionNeeded;
    }

    public void setCMDPermissionNeeded(boolean bool) {
        this.cmdPermissionNeeded = bool;
    }

    public boolean isVanilla() {
        return this.vanillaItem;
    }

    public void setVanilla(boolean bool) {
        this.vanillaItem = bool;
    }

    public boolean isVanillaStatus() {
        return this.vanillaStatus;
    }

    public void setVanillaStatus(boolean bool) {
        this.vanillaStatus = bool;
    }

    public boolean isVanillaControl() {
        return this.vanillaControl;
    }

    public void setVanillaControl(boolean bool) {
        this.vanillaControl = bool;
    }

    public boolean isGiveNext() {
        return this.giveNext;
    }

    public void setGiveNext(boolean bool) {
        this.giveNext = bool;
    }

    public boolean isMoveNext() {
        return this.moveNext;
    }

    public void setMoveNext(boolean bool) {
        this.moveNext = bool;
    }

    public boolean isDropFull() {
        return this.dropFull;
    }

    public void setDropFull(boolean bool) {
        this.dropFull = bool;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean bool) {
        this.unbreakable = bool;
    }

    public boolean isCountLock() {
        return this.countLock;
    }

    public void setCountLock(boolean bool) {
        this.countLock = bool;
    }

    public boolean isTeleport() {
        return this.teleportArrow;
    }

    public void setTeleport(boolean bool) {
        this.teleportArrow = bool;
    }

    public boolean isCancelEvents() {
        return this.cancelEvents;
    }

    public void setCancelEvents(boolean bool) {
        this.cancelEvents = bool;
    }

    public boolean isItemStore() {
        return this.itemStore;
    }

    public void setItemStore(boolean bool) {
        this.itemStore = bool;
    }

    public boolean isItemModify() {
        return this.itemModify;
    }

    public void setItemModify(boolean bool) {
        this.itemModify = bool;
    }

    public boolean isItemCraftable() {
        return this.noCrafting;
    }

    public void setItemCraftable(boolean bool) {
        this.noCrafting = bool;
    }

    public boolean isItemRepairable() {
        return this.noRepairing;
    }

    public void setItemRepairable(boolean bool) {
        this.noRepairing = bool;
    }

    public boolean isItemChangeable() {
        return this.itemChangeable;
    }

    public void setItemChangeable(boolean bool) {
        this.itemChangeable = bool;
    }

    public boolean isAlwaysGive() {
        return this.alwaysGive;
    }

    public void setAlwaysGive(boolean bool) {
        this.alwaysGive = bool;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(boolean bool) {
        this.autoRemove = bool;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public void setStackable(boolean bool) {
        this.stackable = bool;
    }

    public boolean isNotHat() {
        return this.notHat;
    }

    public void setNotHat(boolean bool) {
        this.notHat = bool;
    }

    public boolean isNoClear() {
        return this.noClear;
    }

    public void setNoClear(boolean bool) {
        this.noClear = bool;
    }

    public long getSelectableDelay() {
        return this.selectableDelay != 0 ? (long)this.selectableDelay * 10L : 0L;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bool) {
        this.selectable = bool;
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public void setSplittable(boolean bool) {
        this.splittable = bool;
    }

    public boolean isAnimated() {
        return this.animate;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bool) {
        this.dynamic = bool;
    }

    public boolean isDynamicCount() {
        return this.dynamicCount;
    }

    public void setDynamicCount(boolean bool) {
        this.dynamicCount = bool;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bool) {
        this.glowing = bool;
    }

    public boolean isOverwritable() {
        return this.overwritable;
    }

    public void setOverwritable(boolean bool) {
        this.overwritable = bool;
    }

    public boolean isPlaceable() {
        return this.blockPlacement;
    }

    public void setPlaceable(boolean bool) {
        this.blockPlacement = bool;
    }

    public boolean isAttributesInfo() {
        return this.hideAttributes;
    }

    public void setAttributesInfo(boolean bool) {
        this.hideAttributes = bool;
    }

    public boolean isEnchantmentsInfo() {
        return this.hideEnchantments;
    }

    public void setEnchantmentsInfo(boolean bool) {
        this.hideEnchantments = bool;
    }

    public boolean isFlagsInfo() {
        return this.hideFlags;
    }

    public void setFlagsInfo(boolean bool) {
        this.hideFlags = bool;
    }

    public boolean isDurabilityBar() {
        return this.hideDurability;
    }

    public void setDurabilityBar(boolean bool) {
        this.hideDurability = bool;
    }

    public boolean isMovement() {
        return this.blockMovement;
    }

    public void setMovement(boolean bool) {
        this.blockMovement = bool;
    }

    public boolean isEquip() {
        return this.blockEquip;
    }

    public void setEquip(boolean bool) {
        this.blockEquip = bool;
    }

    public boolean isInventoryClose() {
        return this.closeInventory;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean bool) {
        this.disposable = bool;
    }

    public boolean isSelfDroppable() {
        return this.selfDroppable;
    }

    public void setSelfDroppable(boolean bool) {
        this.selfDroppable = bool;
    }

    public boolean isEraseDroppable() {
        return this.eraseDroppable;
    }

    public void setEraseDroppable(boolean bool) {
        this.eraseDroppable = bool;
    }

    public boolean isDeathDroppable() {
        return this.deathDroppable;
    }

    public void setDeathDroppable(boolean bool) {
        this.deathDroppable = bool;
    }

    public boolean isDeathKeepable() {
        return this.deathKeepable;
    }

    public void setDeathKeepable(boolean bool) {
        this.deathKeepable = bool;
    }

    public boolean isCreativeBypass() {
        return this.CreativeBypass;
    }

    public void setCreativeBypass(boolean bool) {
        this.CreativeBypass = bool;
    }

    public boolean isOpBypass() {
        return this.AllowOpBypass;
    }

    public void setOpBypass(boolean bool) {
        this.AllowOpBypass = bool;
    }

    private boolean isSubjectRemoval() {
        return this.subjectRemoval;
    }

    private void setSubjectRemoval(boolean bool) {
        this.subjectRemoval = bool;
    }

    public boolean containsWorld(String world, boolean isDisabled) {
        for (String worldString : isDisabled ? this.getDisabledWorlds() : this.getEnabledWorlds()) {
            if (!worldString.equalsIgnoreCase(world) && !worldString.equalsIgnoreCase("ALL") && !worldString.equalsIgnoreCase("GLOBAL")) continue;
            return true;
        }
        return false;
    }

    public boolean containsRegion(String region, boolean isDisabled) {
        for (String enabledRegion : isDisabled ? this.getDisabledRegions() : this.getEnabledRegions()) {
            if (!enabledRegion.equalsIgnoreCase(region) && !enabledRegion.equalsIgnoreCase("UNDEFINED")) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedItem(Player player, ItemStack item, String findFlag) {
        if (!Menu.isOpen(player) && this.isSimilar(player, item)) {
            if (this.AllowOpBypass && player.isOp() || this.CreativeBypass && player.getGameMode() == GameMode.CREATIVE || findFlag.equalsIgnoreCase("inventory-modify") && player.hasPermission("itemjoin.bypass.inventorymodify") && ItemJoin.getCore().getPlugin().getConfig().getBoolean("Permissions.Movement-Bypass")) {
                return false;
            }
            if (findFlag.equals("cancel-events")) {
                return this.cancelEvents;
            }
            if (findFlag.equals("self-drops")) {
                return this.selfDroppable;
            }
            if (findFlag.equals("erase-drops")) {
                return this.eraseDroppable;
            }
            if (findFlag.equals("death-drops")) {
                return this.deathDroppable;
            }
            if (findFlag.equals("death-keep")) {
                return this.deathKeepable;
            }
            if (findFlag.equals("cancel-equip")) {
                return this.blockEquip;
            }
            if (findFlag.equals("inventory-modify")) {
                return this.blockMovement;
            }
            if (findFlag.equals("inventory-close")) {
                return this.closeInventory;
            }
            if (findFlag.equals("item-store")) {
                return this.itemStore;
            }
            if (findFlag.equals("disposable")) {
                return this.disposable;
            }
            if (findFlag.equals("stackable")) {
                return this.stackable;
            }
            if (findFlag.equals("not-hat")) {
                return this.notHat;
            }
            if (findFlag.equals("no-clear")) {
                return this.noClear;
            }
            if (findFlag.equals("selectable")) {
                return this.selectable;
            }
            if (findFlag.equals("splittable")) {
                return this.splittable;
            }
            if (findFlag.equals("item-modifiable")) {
                return this.itemModify;
            }
            if (findFlag.equals("item-craftable")) {
                return this.noCrafting;
            }
            if (findFlag.equals("item-repairable")) {
                return this.noRepairing;
            }
            if (findFlag.equals("placement")) {
                return this.blockPlacement;
            }
            if (findFlag.equals("count-lock")) {
                return this.countLock;
            }
            if (findFlag.equals("teleport")) {
                return this.teleportArrow;
            }
        }
        return false;
    }

    public boolean isReal(ItemStack item) {
        String nbtData = ItemHandler.getNBTData(item, PluginData.getInfo().getNBTList());
        return item != null && item.getType() != Material.AIR && (this.vanillaControl || this.vanillaStatus || ItemJoin.getCore().getData().dataTagsEnabled() && nbtData != null && nbtData.equalsIgnoreCase(this.getConfigName()) || this.legacySecret != null && item.hasItemMeta() && (ServerUtils.hasSpecificUpdate("1_14") || !ServerUtils.hasSpecificUpdate("1_14") && Objects.requireNonNull(item.getItemMeta()).hasDisplayName()) && Objects.requireNonNull(StringUtils.colorDecode(item)).contains(this.legacySecret));
    }

    public boolean isSimilar(Player player, ItemStack item) {
        if ((item != null && item.getType() != Material.AIR && item.getType() == this.material || this.materialAnimated && item != null && item.getType() != Material.AIR && this.isMaterial(item)) && (this.vanillaControl || this.vanillaStatus || ItemJoin.getCore().getData().dataTagsEnabled() && ItemHandler.getNBTData(item, PluginData.getInfo().getNBTList()) != null && Objects.requireNonNull(ItemHandler.getNBTData(item, PluginData.getInfo().getNBTList())).equalsIgnoreCase(this.getConfigName()) || this.legacySecret != null && item.hasItemMeta() && (ServerUtils.hasSpecificUpdate("1_14") || !ServerUtils.hasSpecificUpdate("1_14") && Objects.requireNonNull(item.getItemMeta()).hasDisplayName()) && Objects.requireNonNull(StringUtils.colorDecode(item)).contains(this.legacySecret)) && (this.isEnchantSimilar(player, item) || !Objects.requireNonNull(item.getItemMeta()).hasEnchants() && this.enchants.isEmpty() || this.isItemChangeable()) && (this.material.toString().toUpperCase().contains("BOOK") && (this.isBookMeta(player, item) && ((BookMeta)Objects.requireNonNull(item.getItemMeta())).getPages().equals(((BookMeta)Objects.requireNonNull(this.tempItem.getItemMeta())).getPages()) || this.isDynamic()) || this.material.toString().toUpperCase().contains("BOOK") && !this.isBookMeta(player, item) || !this.material.toString().toUpperCase().contains("BOOK") || this.isItemChangeable())) {
            return !this.vanillaControl || this.displayMeta(item);
        }
        return false;
    }

    public boolean isSkull() {
        return this.material.toString().equalsIgnoreCase("PLAYER_HEAD") || this.material.toString().equalsIgnoreCase("SKULL_ITEM");
    }

    public void setSkull(String skull) {
        this.skullOwner = skull;
    }

    private void setSkull(Player player) {
        if (this.skullOwner != null) {
            this.tempMeta = ItemHandler.setSkullOwner(this.tempMeta, player, StringUtils.translateLayout(this.skullOwner, player, new PlaceHolder[0]));
        } else if (this.skullTexture != null && !this.headDatabase) {
            this.tempMeta = ItemHandler.setSkullTexture(player, this.tempMeta, StringUtils.toTextureUUID(player, this.configName, this.skullTexture));
        }
    }

    private boolean displayMeta(ItemStack item) {
        if (item.hasItemMeta() && Objects.requireNonNull(item.getItemMeta()).hasDisplayName() && this.tempMeta != null && this.tempMeta.hasDisplayName() && item.getItemMeta().hasLore() && this.tempMeta.hasLore()) {
            return item.getItemMeta().getDisplayName().equalsIgnoreCase(this.tempMeta.getDisplayName()) && Objects.requireNonNull(item.getItemMeta().getLore()).toString().equalsIgnoreCase(Objects.requireNonNull(this.tempMeta.getLore()).toString());
        }
        if (item.hasItemMeta() && Objects.requireNonNull(item.getItemMeta()).hasDisplayName() && this.tempMeta != null && this.tempMeta.hasDisplayName() && !item.getItemMeta().hasLore() && !this.tempMeta.hasLore()) {
            return item.getItemMeta().getDisplayName().equalsIgnoreCase(this.tempMeta.getDisplayName());
        }
        if (item.hasItemMeta() && !Objects.requireNonNull(item.getItemMeta()).hasDisplayName() && this.tempMeta != null && !this.tempMeta.hasDisplayName() && item.getItemMeta().hasLore() && this.tempMeta.hasLore()) {
            return Objects.requireNonNull(item.getItemMeta().getLore()).toString().equalsIgnoreCase(Objects.requireNonNull(this.tempMeta.getLore()).toString());
        }
        return this.tempMeta == null || !item.hasItemMeta() && !this.tempMeta.hasDisplayName() && !this.tempMeta.hasLore();
    }

    private boolean isEnchantSimilar(Player player, ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (player != null && itemMeta != null && itemMeta.hasEnchants()) {
            ItemStack checkItem = new ItemStack(item.getType());
            Map<String, Integer> enchantList = ItemUtilities.getUtilities().getStatistics(player).getEnchantments(this);
            if (enchantList != null && !enchantList.isEmpty()) {
                for (Map.Entry<String, Integer> enchantments : enchantList.entrySet()) {
                    if (enchantments.getKey() == null && ItemJoin.getCore().getDependencies().tokenEnchantEnabled() && TokenEnchantAPI.getInstance().getEnchantment(enchantments.getKey()) != null) {
                        TokenEnchantAPI.getInstance().enchant(null, checkItem, enchantments.getKey(), enchantments.getValue().intValue(), true, 0.0, true);
                        continue;
                    }
                    checkItem.addUnsafeEnchantment(Objects.requireNonNull(ItemHandler.getEnchantByName(enchantments.getKey())), enchantments.getValue().intValue());
                }
            }
            return this.glowing || checkItem.getItemMeta() != null && itemMeta.getEnchants().equals(checkItem.getItemMeta().getEnchants());
        }
        return true;
    }

    private boolean isBookMeta(Player player, ItemStack item) {
        try {
            boolean bookMeta = ((BookMeta)Objects.requireNonNull(item.getItemMeta())).hasPages();
            if (bookMeta && this.material.toString().toUpperCase().contains("BOOK")) {
                this.setJSONBookPages(player);
            }
            return bookMeta;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCountSimilar(Player player, ItemStack item) {
        return item.getAmount() == this.getCount(player).intValue() || !ItemJoin.getCore().getConfig("items.yml").getBoolean("items-RestrictCount") || this.isItemChangeable();
    }

    private boolean isMaterial(ItemStack item) {
        for (String material : this.dynamicMaterials) {
            material = ItemHandler.cutDelay(material);
            String dataValue = null;
            if (material.contains(":")) {
                String[] parts = material.split(":");
                dataValue = parts[1];
            }
            if (item.getType() != ItemHandler.getMaterial(material, dataValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasItem(Player player, boolean ignoreCount) {
        int arbitrary = ItemUtilities.getUtilities().getArbitrary(this);
        int count = 0;
        for (ItemStack inPlayerInventory : player.getInventory().getContents()) {
            if (!this.isSimilar(player, inPlayerInventory) || !ignoreCount && !this.isCountSimilar(player, inPlayerInventory)) continue;
            if (this.getSlot().equalsIgnoreCase("ARBITRARY")) {
                if (arbitrary != ++count) continue;
                return true;
            }
            return true;
        }
        for (ItemStack equipInventory : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
            if (!this.isSimilar(player, equipInventory) || !ignoreCount && !this.isCountSimilar(player, equipInventory)) continue;
            return true;
        }
        if (ServerUtils.hasSpecificUpdate("1_9") && this.isSimilar(player, player.getInventory().getItemInOffHand()) && (ignoreCount || this.isCountSimilar(player, player.getInventory().getItemInOffHand()))) {
            return true;
        }
        if (PlayerHandler.isCraftingInv(player)) {
            for (ItemStack craftInventory : CompatUtils.getTopInventory(player)) {
                if (!this.isSimilar(player, craftInventory) || !ignoreCount && !this.isCountSimilar(player, craftInventory)) continue;
                return true;
            }
        }
        return player.getItemOnCursor().getType() != Material.AIR && this.isSimilar(player, player.getItemOnCursor()) && (ignoreCount || this.isCountSimilar(player, player.getItemOnCursor()));
    }

    public ItemStack getItem(Player player) {
        return this.updateItem(player, new boolean[0]).getTempItem();
    }

    public ItemMap updateItem(Player player, boolean ... caughtError) {
        try {
            if (this.tempItem != null) {
                this.setSkullDatabase();
                this.setUnbreaking();
                this.setEnchantments(player);
                this.setGlowing();
                this.setMapImage();
                this.setJSONBookPages(player);
                this.setNBTData();
                ItemMeta itemMeta = this.tempMeta = this.tempItem != null ? this.tempItem.getItemMeta() : null;
            }
            if (this.tempMeta != null) {
                this.setCustomName(player);
                this.setCustomLore(player);
                this.setSkull(player);
                this.setDurability();
                this.setData();
                this.setModelData(player);
                this.setPotionEffects();
                this.setBanners();
                this.setArmorTrim();
                this.setFireworks();
                this.setFireChargeColor();
                this.setDye(player);
                this.setBookInfo(player);
                this.setUnbreakable();
                this.setAttributes();
                this.setAttributeFlags();
                this.setEnchantmentsFlags();
                this.setFlags();
                this.setContents(player);
                this.tempItem.setItemMeta(this.tempMeta);
                this.tempItem.setAmount(this.getCount(player).intValue());
                this.setTempItem(LegacyAPI.setAttributes(this.tempItem, this.configName, this.attributes));
            }
        }
        catch (Exception e) {
            if (caughtError.length <= 0) {
                this.renderItemStack();
                return this.updateItem(player, true);
            }
            ServerUtils.logSevere("{ItemMap} Failed to update the custom item: " + this.nodeLocation + ".");
            ServerUtils.sendSevereTrace(e);
        }
        return this;
    }

    private void setGlowing() {
        if (this.glowing) {
            ItemHandler.setGlowing(this.tempItem);
        }
    }

    private void setSkullDatabase() {
        if (this.headDatabase && this.skullTexture != null) {
            HeadDatabaseAPI api = new HeadDatabaseAPI();
            ItemStack sk = api.getItemHead(this.skullTexture);
            this.tempItem = sk != null ? sk : this.tempItem.clone();
        }
    }

    private void setUnbreaking() {
        if (!ServerUtils.hasPreciseUpdate("1_20_5") && (this.isUnbreakable() || this.hideDurability)) {
            try {
                Class<?> craftItemStack = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack");
                Object nms = craftItemStack.getMethod("asNMSCopy", ItemStack.class).invoke(null, this.tempItem);
                Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
                Object tag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0]);
                if (tag == null) {
                    tag = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.setInt.getMethod(), String.class, Integer.TYPE).invoke(tag, "Unbreakable", 1);
                nms.getClass().getMethod(ReflectionUtils.MinecraftMethod.setTag.getMethod(), tag.getClass()).invoke(nms, tag);
                ItemStack item = (ItemStack)craftItemStack.getMethod("asCraftMirror", nms.getClass()).invoke(null, nms);
                this.tempItem = item != null ? item : this.tempItem.clone();
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private void setUnbreakable() {
        if (ServerUtils.hasPreciseUpdate("1_20_5") && (this.isUnbreakable() || this.hideDurability)) {
            this.tempMeta.setUnbreakable(true);
        }
    }

    private void setAttributes() {
        if (ServerUtils.hasSpecificUpdate("1_13") && this.attributes != null && !this.attributes.isEmpty()) {
            try {
                for (String attrib : this.attributes.keySet()) {
                    Attribute attribute = (Attribute)CompatUtils.valueOf(Attribute.class, attrib.toUpperCase());
                    if (attribute == null) {
                        ServerUtils.logSevere("{ItemMap} Your server is running MC " + ReflectionUtils.getServerVersion() + " and this version of Minecraft does not have the defined attribute " + attrib + ".");
                        if (ServerUtils.hasPreciseUpdate("1_21_3")) {
                            ServerUtils.logSevere("{ItemMap} See the Minecraft Wiki for a list of attributes https://minecraft.fandom.com/wiki/Attribute");
                        }
                        return;
                    }
                    double value = this.attributes.get(attrib);
                    EquipmentSlot slot = ItemHandler.getDesignatedSlot(this.material).equalsIgnoreCase("noslot") ? EquipmentSlot.HAND : EquipmentSlot.valueOf((String)ItemHandler.getDesignatedSlot(this.material).toUpperCase());
                    AttributeModifier modifier = (AttributeModifier)CompatUtils.resolveByVersion("1_21", () -> new AttributeModifier(CompatUtils.getKey(attribute), value, AttributeModifier.Operation.ADD_NUMBER, slot.getGroup()), () -> LegacyAPI.getAttribute(this.configName + attrib, attrib, value, slot));
                    if (this.tempMeta.getAttributeModifiers() != null && this.tempMeta.getAttributeModifiers().containsValue((Object)modifier)) continue;
                    this.tempMeta.addAttributeModifier(attribute, modifier);
                }
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    private void setMapImage() {
        if (this.customMapImage != null || this.mapId != -1) {
            if (ServerUtils.hasSpecificUpdate("1_13")) {
                MapMeta mapmeta = (MapMeta)this.tempItem.getItemMeta();
                try {
                    if (mapmeta != null && this.mapView != null) {
                        try {
                            mapmeta.setMapView(this.mapView);
                        }
                        catch (NullPointerException e) {
                            ServerUtils.sendDebugTrace(e);
                            ServerUtils.logWarn("{ItemMap} There was an issue rendering the custom map image for " + this.configName + ".");
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                    LegacyAPI.setMapID(mapmeta, this.mapId);
                }
                this.tempItem.setItemMeta((ItemMeta)mapmeta);
            } else {
                LegacyAPI.setDurability(this.tempItem, this.mapId);
            }
        }
    }

    public void setJSONBookPages(Player player) {
        if (this.tempItem.getType().toString().equalsIgnoreCase("WRITTEN_BOOK") && this.bookPages != null && !this.bookPages.isEmpty()) {
            ItemStack item = this.setJSONBookPages(player, this.tempItem, this.bookPages);
            this.tempItem = item != null ? item : this.tempItem.clone();
        }
    }

    public ItemStack setJSONBookPages(Player player, ItemStack item, List<String> pages) {
        if (item.getType().toString().equalsIgnoreCase("WRITTEN_BOOK") && pages != null && !pages.isEmpty()) {
            ArrayList<String> copyPages = new ArrayList<String>(pages);
            copyPages.set(0, ItemHandler.cutDelay((String)copyPages.get(0)));
            Object localePages = null;
            try {
                localePages = ReflectionUtils.getMinecraftClass("NBTTagList").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
            if (ServerUtils.hasPreciseUpdate("1_20_5")) {
                return this.set1_20_5JSONPages(player, item, copyPages);
            }
            if (ServerUtils.hasSpecificUpdate("1_15")) {
                return this.set1_15JSONPages(player, item, localePages, copyPages);
            }
            if (ServerUtils.hasSpecificUpdate("1_14")) {
                return this.set1_14JSONPages(player, item, localePages, copyPages);
            }
            return this.set1_13JSONPages(player, item, localePages, copyPages);
        }
        return item;
    }

    private ItemStack set1_13JSONPages(Player player, ItemStack item, Object localePages, List<String> pages) {
        for (String textComponent : pages) {
            try {
                textComponent = StringUtils.translateLayout(textComponent, player, new PlaceHolder[0]);
                Object TagString = ReflectionUtils.getMinecraftClass("NBTTagString").getConstructor(String.class).newInstance(textComponent);
                Class<?> baseClass = ReflectionUtils.getMinecraftClass("NBTBase");
                localePages.getClass().getMethod(ReflectionUtils.MinecraftMethod.add.getMethod(), baseClass).invoke(localePages, TagString);
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
        try {
            return this.invokePages(item, localePages);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            return item;
        }
    }

    private ItemStack set1_14JSONPages(Player player, ItemStack item, Object localePages, List<String> pages) {
        for (int i = pages.size() - 1; i >= 0; --i) {
            String textComponent = pages.get(i);
            try {
                textComponent = StringUtils.translateLayout(textComponent, player, new PlaceHolder[0]);
                Object TagString = ReflectionUtils.getMinecraftClass("NBTTagString").getConstructor(String.class).newInstance(textComponent);
                Class<?> baseClass = ReflectionUtils.getMinecraftClass("NBTBase");
                localePages.getClass().getMethod(ReflectionUtils.MinecraftMethod.add.getMethod(), Integer.TYPE, baseClass).invoke(localePages, 0, TagString);
                continue;
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
        try {
            return this.invokePages(item, localePages);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            return item;
        }
    }

    private ItemStack set1_15JSONPages(Player player, ItemStack item, Object localePages, List<String> pages) {
        for (int i = pages.size() - 1; i >= 0; --i) {
            String textComponent = pages.get(i);
            try {
                textComponent = StringUtils.translateLayout(textComponent, player, new PlaceHolder[0]);
                Class<?> stringClass = ReflectionUtils.getMinecraftClass("NBTTagString");
                Class<?> baseClass = ReflectionUtils.getMinecraftClass("NBTBase");
                Object TagString = stringClass.getMethod(ReflectionUtils.MinecraftMethod.getPage.getMethod(), String.class).invoke(null, textComponent);
                localePages.getClass().getMethod(ReflectionUtils.MinecraftMethod.add.getMethod(), Integer.TYPE, baseClass).invoke(localePages, 0, TagString);
                continue;
            }
            catch (Exception e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
        try {
            return this.invokePages(item, localePages);
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            return item;
        }
    }

    private ItemStack set1_20_5JSONPages(Player player, ItemStack item, List<String> copyPages) {
        try {
            ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>();
            BookMeta tempMeta = (BookMeta)item.getItemMeta();
            for (String jsonComponent : copyPages) {
                pages.add(ComponentSerializer.parse((String)StringUtils.translateLayout(jsonComponent, player, new PlaceHolder[0])));
            }
            if (tempMeta != null) {
                tempMeta.spigot().setPages(pages);
                item.setItemMeta((ItemMeta)tempMeta);
            }
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
        }
        return item;
    }

    private ItemStack invokePages(ItemStack item, Object pages) throws Exception {
        Class<?> craftItemStack = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack");
        Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
        Class<?> baseClass = ReflectionUtils.getMinecraftClass("NBTBase");
        Object nms = craftItemStack.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
        Object tag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0]);
        if (tag == null) {
            tag = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        tag.getClass().getMethod(ReflectionUtils.MinecraftMethod.set.getMethod(), String.class, baseClass).invoke(tag, "pages", pages);
        nms.getClass().getMethod(ReflectionUtils.MinecraftMethod.setTag.getMethod(), tag.getClass()).invoke(nms, tag);
        return (ItemStack)craftItemStack.getMethod("asCraftMirror", nms.getClass()).invoke(null, nms);
    }

    private void setNBTData() {
        if (ItemJoin.getCore().getData().dataTagsEnabled() && !this.isVanilla() && !this.isVanillaControl() && !this.isVanillaStatus()) {
            try {
                ItemStack item;
                Object cacheTag;
                Class<?> itemClass = ReflectionUtils.getMinecraftClass("ItemStack");
                Object nms = ReflectionUtils.getCraftBukkitClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, this.tempItem);
                Object tagInstance = ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!ServerUtils.hasPreciseUpdate("1_20_5") && (cacheTag = itemClass.getMethod(ReflectionUtils.MinecraftMethod.getTag.getMethod(), new Class[0]).invoke(nms, new Object[0])) != null) {
                    tagInstance = cacheTag;
                }
                tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(tagInstance, "ItemJoin Name", this.getConfigName());
                HashMap packages = new HashMap();
                if (this.nbtProperty != null && !this.nbtProperty.isEmpty()) {
                    for (Object tag : this.nbtProperty.keySet()) {
                        String castTag = (String)tag;
                        Object property = this.nbtProperty.get(tag);
                        String packageName = null;
                        String tagName = castTag;
                        if (castTag.contains(".")) {
                            String[] packageParts = castTag.split("\\.");
                            packageName = packageParts[0];
                            tagName = packageParts[1];
                        }
                        try {
                            if (packageName != null) {
                                Object customPackage;
                                Object object = customPackage = packages.get(packageName) != null ? packages.get(packageName) : ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                                if (property instanceof String) {
                                    String castProperty = (String)property;
                                    customPackage.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(customPackage, tagName, castProperty);
                                } else {
                                    customPackage.getClass().getMethod(ReflectionUtils.MinecraftMethod.put.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(customPackage, tagName, property);
                                }
                                packages.put(packageName, customPackage);
                                tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.setCompound.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(tagInstance, packageName, customPackage);
                                continue;
                            }
                            if (property instanceof String) {
                                String castProperty = (String)property;
                                tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.setString.getMethod(), String.class, String.class).invoke(tagInstance, tagName, castProperty);
                                continue;
                            }
                            tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.put.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(tagInstance, tagName, property);
                        }
                        catch (Exception e) {
                            if (packageName != null) {
                                Object customPackage = packages.get(packageName) != null ? packages.get(packageName) : ReflectionUtils.getMinecraftClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
                                customPackage.getClass().getMethod(ReflectionUtils.MinecraftMethod.set.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(customPackage, tagName, property);
                                packages.put(packageName, customPackage);
                                tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.setCompound.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(tagInstance, packageName, customPackage);
                                continue;
                            }
                            tagInstance.getClass().getMethod(ReflectionUtils.MinecraftMethod.set.getMethod(), String.class, ReflectionUtils.getMinecraftClass("NBTBase")).invoke(tagInstance, tagName, property);
                        }
                    }
                }
                this.tempItem = (item = ItemHandler.setNBTData(this.tempItem, tagInstance)) != null ? item : this.tempItem.clone();
            }
            catch (Exception e) {
                ServerUtils.logSevere("{ItemMap} An error has occurred when setting NBTData to an item.");
                ServerUtils.sendDebugTrace(e);
            }
        } else if (!ItemJoin.getCore().getData().dataTagsEnabled() && this.legacySecret != null && !this.legacySecret.isEmpty()) {
            StringUtils.colorEncode(this.tempItem, this.legacySecret);
        }
    }

    private void setDurability() {
        if (this.durability != null && (this.data == null || this.data == 0)) {
            if (ServerUtils.hasSpecificUpdate("1_13")) {
                ((Damageable)this.tempMeta).setDamage((int)this.durability.shortValue());
            } else {
                LegacyAPI.setDurability(this.tempItem, this.durability);
            }
        }
    }

    private void setData() {
        if (this.data != null && this.data > 0) {
            if (ServerUtils.hasSpecificUpdate("1_13")) {
                ((Damageable)this.tempMeta).setDamage(this.data.intValue());
            } else {
                LegacyAPI.setDurability(this.tempItem, Short.parseShort(this.data + ""));
            }
        }
    }

    private void setPotionEffects() {
        if (this.effect != null && !this.effect.isEmpty() && !this.customConsumable) {
            for (PotionEffect potion : this.effect) {
                if (ServerUtils.hasPreciseUpdate("1_20_3")) {
                    ((PotionMeta)this.tempMeta).setBasePotionType(PotionType.WATER);
                } else if (ServerUtils.hasSpecificUpdate("1_9")) {
                    LegacyAPI.setPotionData((PotionMeta)this.tempMeta, PotionType.WATER);
                }
                ((PotionMeta)this.tempMeta).addCustomEffect(potion, true);
            }
        } else if (ServerUtils.hasSpecificUpdate("1_9") && (this.getMaterial().toString().equalsIgnoreCase("POTION") || this.getMaterial().toString().equalsIgnoreCase("SPLASH_POTION") || this.getMaterial().toString().equalsIgnoreCase("LINGERING_POTION"))) {
            if (ServerUtils.hasPreciseUpdate("1_20_3")) {
                ((PotionMeta)this.tempMeta).setBasePotionType(PotionType.WATER);
            } else if (ServerUtils.hasSpecificUpdate("1_9")) {
                LegacyAPI.setPotionData((PotionMeta)this.tempMeta, PotionType.WATER);
            }
        }
    }

    private void setBanners() {
        if (this.bannerPatterns != null && !this.bannerPatterns.isEmpty()) {
            ((BannerMeta)this.tempMeta).setPatterns(this.bannerPatterns);
        }
    }

    private void setArmorTrim() {
        if (this.trimPattern != null && !this.trimPattern.isEmpty()) {
            Map.Entry<String, String> entry = this.trimPattern.entrySet().iterator().next();
            TrimMaterial trimMaterial = ItemHandler.getTrimMaterial(entry.getKey());
            TrimPattern trimPattern = ItemHandler.getTrimPattern(entry.getValue());
            if (trimMaterial != null && trimPattern != null) {
                ((ArmorMeta)this.tempMeta).setTrim(new ArmorTrim(trimMaterial, trimPattern));
            }
        }
    }

    private void setFireworks() {
        if (this.firework != null) {
            ((FireworkMeta)this.tempMeta).clearEffects();
            ((FireworkMeta)this.tempMeta).addEffect(this.firework);
        }
        if (this.power != null && this.power != 0) {
            ((FireworkMeta)this.tempMeta).setPower(this.power.intValue());
        }
    }

    private void setFireChargeColor() {
        if (this.chargeColor != null) {
            ((FireworkEffectMeta)this.tempMeta).setEffect(FireworkEffect.builder().withColor(this.chargeColor.getColor()).build());
        }
    }

    private void setDye(Player player) {
        if (this.leatherColor != null) {
            if (this.leatherColor.startsWith("%")) {
                String newColor = StringUtils.translateLayout(this.leatherColor, player, new PlaceHolder[0]);
                if (newColor.startsWith("#")) {
                    ((LeatherArmorMeta)this.tempMeta).setColor(StringUtils.getColorFromHexColor(newColor));
                } else {
                    try {
                        ((LeatherArmorMeta)this.tempMeta).setColor(DyeColor.valueOf((String)newColor).getFireworkColor());
                    }
                    catch (Exception e) {
                        try {
                            ((LeatherArmorMeta)this.tempMeta).setColor(StringUtils.getColorFromHexColor(newColor));
                        }
                        catch (Exception e2) {
                            ServerUtils.logSevere("{ItemMap} Unable to find the defined color: " + newColor + " for the item " + this.configName);
                            ServerUtils.sendSevereTrace(e2);
                        }
                    }
                }
            } else {
                ((LeatherArmorMeta)this.tempMeta).setColor(DyeColor.valueOf((String)this.leatherColor).getFireworkColor());
            }
        } else if (this.leatherHex != null) {
            ((LeatherArmorMeta)this.tempMeta).setColor(StringUtils.getColorFromHexColor(this.leatherHex));
        }
    }

    private void setBookInfo(Player player) {
        if (this.author != null) {
            this.author = StringUtils.translateLayout(this.author, player, new PlaceHolder[0]);
            ((BookMeta)this.tempMeta).setAuthor(this.author);
        }
        if (this.title != null) {
            this.title = StringUtils.translateLayout(this.title, player, new PlaceHolder[0]);
            ((BookMeta)this.tempMeta).setTitle(this.title);
        }
        if (this.generation != null && ServerUtils.hasSpecificUpdate("1_10")) {
            ((BookMeta)this.tempMeta).setGeneration((BookMeta.Generation)this.generation);
        }
    }

    private void setAttributeFlags() {
        if (this.hideAttributes) {
            CompatUtils.setDummyAttributes(this.tempMeta);
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
    }

    private void setEnchantmentsFlags() {
        if (this.hideEnchantments) {
            CompatUtils.setDummyAttributes(this.tempMeta);
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
    }

    private void setFlags() {
        if (this.hideFlags || this.glowing) {
            CompatUtils.setDummyAttributes(this.tempMeta);
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.hideFlags) {
            CompatUtils.setDummyAttributes(this.tempMeta);
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            if (!ServerUtils.hasPreciseUpdate("1_20_5")) {
                this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS")});
            } else {
                this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }
            if (ServerUtils.hasSpecificUpdate("1_20")) {
                this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
            }
            if (ServerUtils.hasSpecificUpdate("1_17")) {
                this.tempMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inWorld(World world) {
        if (this.enabledWorlds == null && this.disabledWorlds == null) {
            return true;
        }
        if (this.enabledWorlds != null) {
            List<String> enabledWorlds;
            List<String> list = enabledWorlds = this.enabledWorlds;
            synchronized (list) {
                for (String enabledWorld : enabledWorlds) {
                    if (!enabledWorld.equalsIgnoreCase(world.getName()) && !enabledWorld.equalsIgnoreCase("ALL") && !enabledWorld.equalsIgnoreCase("GLOBAL") && (!enabledWorld.contains("*") || !world.getName().toUpperCase().startsWith(enabledWorld.split("\\*")[0].toUpperCase()))) continue;
                    return !this.isDisabledWorld(world);
                }
            }
        }
        return false;
    }

    public boolean isDisabledWorld(World world) {
        boolean isDisabled = false;
        for (String disabledWorld : this.disabledWorlds) {
            if (!disabledWorld.equalsIgnoreCase(world.getName()) && !disabledWorld.equalsIgnoreCase("ALL") && !disabledWorld.equalsIgnoreCase("GLOBAL") && (!disabledWorld.contains("*") || !world.getName().toUpperCase().startsWith(disabledWorld.split("\\*")[0].toUpperCase()))) continue;
            isDisabled = true;
        }
        return isDisabled;
    }

    private boolean hasCommandPermissions(Player player, String action, boolean doCheck, boolean silent) {
        List<String> permissions = this.commandPermissions.get(action);
        if (permissions != null && !permissions.isEmpty() && doCheck) {
            for (String permission : permissions) {
                boolean hasPermission;
                boolean isNeeded = !permission.startsWith("!");
                String permissionString = isNeeded ? permission : permission.substring(1);
                boolean bl = hasPermission = player.isPermissionSet(permissionString) && player.hasPermission(permissionString);
                if ((!isNeeded || hasPermission) && (isNeeded || !hasPermission)) continue;
                if (!silent) {
                    player.sendMessage(StringUtils.translateLayout(this.getFailMessage(action), player, new PlaceHolder[0]));
                    ServerUtils.logDebug("{ItemMap} " + player.getName() + " has not met any of the " + action + "-permission(s), for the item: " + this.getConfigName() + ".");
                }
                return false;
            }
        }
        return true;
    }

    private List<String> getConditions(String action) {
        if (action.equalsIgnoreCase("disposable-conditions")) {
            return this.disposableConditions;
        }
        if (action.equalsIgnoreCase("trigger-conditions")) {
            return this.triggerConditions;
        }
        return this.commandConditions.get(action.replace("-conditions", ""));
    }

    private String getFailMessage(String action) {
        if (action.replace("conditions", "fail-message").equalsIgnoreCase("disposable-fail-message")) {
            return this.disposableMessage;
        }
        if (action.replace("conditions", "fail-message").equalsIgnoreCase("trigger-fail-message")) {
            return this.triggerMessage;
        }
        return this.commandMessages.get(action.replace("-conditions", ""));
    }

    public boolean conditionMet(Player player, String conditions, boolean doCheck, boolean silent) {
        if (this.getConditions(conditions) != null && !this.getConditions(conditions).isEmpty()) {
            if (doCheck) {
                for (String condition : this.getConditions(conditions)) {
                    String[] parts;
                    String[] stringArray = parts = condition != null ? StringUtils.translateLayout(condition, player, new PlaceHolder[0]).split(":") : null;
                    if (parts != null && parts.length == 3) {
                        String value1 = parts[0];
                        String operand = parts[1];
                        String value2 = parts[2];
                        boolean conditionMet = StringUtils.conditionMet(value1, operand, value2);
                        if (!(conditionMet || silent || this.getFailMessage(conditions) == null || this.getFailMessage(conditions).isEmpty())) {
                            player.sendMessage(StringUtils.translateLayout(this.getFailMessage(conditions), player, new PlaceHolder[0]));
                            ServerUtils.logDebug("{ItemMap} " + player.getName() + " has not met any of the " + conditions + "(s), for the item: " + this.getConfigName() + ".");
                        }
                        return conditionMet;
                    }
                    ServerUtils.logSevere("{ItemMap} The item " + this.getConfigName() + " has a " + conditions + " defined incorrectly!");
                    ServerUtils.logWarn("{ItemMap} The condition " + condition + " is not the proper format CONDITION:OPERAND:VALUE, the item may not function properly.");
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public void removeFrom(Player player, int ... amount) {
        block26: {
            int k;
            ItemStack[] craftingContents;
            ItemStack[] contents;
            Inventory topInventory;
            PlayerInventory inv;
            block25: {
                int k2;
                if (amount.length == 0) {
                    amount = new int[]{0};
                }
                inv = player.getInventory();
                topInventory = CompatUtils.getTopInventory(player);
                contents = inv.getContents();
                craftingContents = topInventory.getContents();
                this.updateItem(player, new boolean[0]);
                if (amount[0] != 0) break block25;
                if (this.isAnimated() && this.getAnimationHandler().get(player) != null || this.isDynamic() && this.getAnimationHandler().get(player) != null) {
                    this.localeAnimations.get(player).closeAnimation(player);
                    this.localeAnimations.remove(player);
                }
                for (k2 = 0; k2 < contents.length; ++k2) {
                    if (!this.isSimilar(player, contents[k2])) continue;
                    inv.setItem(k2, new ItemStack(Material.AIR));
                }
                if (this.isSimilar(player, inv.getHelmet())) {
                    inv.setHelmet(new ItemStack(Material.AIR));
                }
                if (this.isSimilar(player, inv.getChestplate())) {
                    inv.setChestplate(new ItemStack(Material.AIR));
                }
                if (this.isSimilar(player, inv.getLeggings())) {
                    inv.setLeggings(new ItemStack(Material.AIR));
                }
                if (this.isSimilar(player, inv.getBoots())) {
                    inv.setBoots(new ItemStack(Material.AIR));
                }
                if (this.isSimilar(player, player.getItemOnCursor())) {
                    player.setItemOnCursor(new ItemStack(Material.AIR));
                }
                if (ServerUtils.hasSpecificUpdate("1_9") && this.isSimilar(player, PlayerHandler.getOffHandItem(player))) {
                    PlayerHandler.setOffHandItem(player, new ItemStack(Material.AIR));
                }
                if (!PlayerHandler.isCraftingInv(player)) break block26;
                for (k2 = 0; k2 < craftingContents.length; ++k2) {
                    if (!this.isSimilar(player, craftingContents[k2])) continue;
                    topInventory.setItem(k2, new ItemStack(Material.AIR));
                }
                break block26;
            }
            for (k = 0; k < contents.length; ++k) {
                if (!this.isSimilar(player, contents[k])) continue;
                inv.setItem(k, ItemHandler.modifyItem(inv.getItem(k), false, amount[0]));
                return;
            }
            if (this.isSimilar(player, inv.getHelmet())) {
                inv.setHelmet(ItemHandler.modifyItem(inv.getHelmet(), false, amount[0]));
            } else if (this.isSimilar(player, inv.getChestplate())) {
                inv.setChestplate(ItemHandler.modifyItem(inv.getChestplate(), false, amount[0]));
            } else if (this.isSimilar(player, inv.getLeggings())) {
                inv.setLeggings(ItemHandler.modifyItem(inv.getLeggings(), false, amount[0]));
            } else if (this.isSimilar(player, inv.getBoots())) {
                inv.setBoots(ItemHandler.modifyItem(inv.getBoots(), false, amount[0]));
            } else if (this.isSimilar(player, player.getItemOnCursor())) {
                player.setItemOnCursor(ItemHandler.modifyItem(player.getItemOnCursor(), false, amount[0]));
            } else if (ServerUtils.hasSpecificUpdate("1_9") && this.isSimilar(player, PlayerHandler.getOffHandItem(player))) {
                PlayerHandler.setOffHandItem(player, ItemHandler.modifyItem(PlayerHandler.getOffHandItem(player), false, amount[0]));
            } else if (PlayerHandler.isCraftingInv(player)) {
                for (k = 0; k < craftingContents.length; ++k) {
                    if (!this.isSimilar(player, craftingContents[k])) continue;
                    topInventory.setItem(k, ItemHandler.modifyItem(CompatUtils.getItem(player, k), false, amount[0]));
                    return;
                }
            }
        }
    }

    public void giveTo(Player player, int ... amount) {
        if (amount.length == 0) {
            amount = new int[]{0};
        }
        ItemUtilities.getUtilities().setStatistics(player);
        if (this.CustomSlot != null && !this.CustomSlot.contains("%")) {
            int customAmount = amount[0];
            if (!ServerUtils.hasSpecificUpdate("1_10")) {
                SchedulerUtils.runLater(2L, () -> ItemUtilities.getUtilities().setCustomSlots(player, this, customAmount));
            } else {
                ItemUtilities.getUtilities().setCustomSlots(player, this, customAmount);
            }
        } else {
            ItemUtilities.getUtilities().setInvSlots(player, this, amount[0]);
        }
        this.setAnimations(player);
        if (this.getMultipleSlots() != null && !this.getMultipleSlots().isEmpty()) {
            if (this.getSlot().equalsIgnoreCase(this.getMultipleSlots().get(0))) {
                this.executeCommands(player, null, this.tempItem, "ON_RECEIVE", "RECEIVED", this.getSlot());
            }
        } else {
            this.executeCommands(player, null, this.tempItem, "ON_RECEIVE", "RECEIVED", this.getSlot());
        }
        SchedulerUtils.runLater(6L, () -> {
            ItemStack item = this.getItem(player).clone();
            int slot = player.getInventory().getHeldItemSlot();
            if (Objects.equals(PlayerHandler.getMainHandItem(player), item) && !Interact.setSelectSlot(player, slot, true)) {
                Interact.setSelectSlot(player, slot, false);
            }
        });
    }

    public void damageItem(Player player, String slot, int damage) {
        if (StringUtils.containsIgnoreCase(slot, "CRAFTING")) {
            int actualSlot = StringUtils.getSlotConversion(slot);
            Inventory topInventory = CompatUtils.getTopInventory(player);
            ItemStack item = topInventory.getItem(actualSlot);
            if (item != null && this.isSimilar(player, item)) {
                ItemMeta itemMeta = item.getItemMeta();
                if (ServerUtils.hasSpecificUpdate("1_13") && itemMeta != null) {
                    int newDamage = ((Damageable)itemMeta).getDamage() + damage;
                    if (item.getType().getMaxDurability() > newDamage) {
                        ((Damageable)itemMeta).setDamage(newDamage);
                        item.setItemMeta(itemMeta);
                    } else {
                        topInventory.setItem(Integer.parseInt(slot), new ItemStack(Material.AIR));
                    }
                } else if (itemMeta != null) {
                    int newDurability = LegacyAPI.getDurability(item) - damage;
                    if (newDurability > 0) {
                        LegacyAPI.setDurability(item, (short)newDurability);
                    } else {
                        topInventory.setItem(Integer.parseInt(slot), new ItemStack(Material.AIR));
                    }
                }
                PlayerHandler.updateInventory(player, 1L);
            }
        } else if (slot.equalsIgnoreCase("OFFHAND") || StringUtils.isInt(slot)) {
            ItemStack item;
            ItemStack itemStack = item = slot.equalsIgnoreCase("OFFHAND") ? PlayerHandler.getOffHandItem(player) : player.getInventory().getItem(Integer.parseInt(slot));
            if (item != null && this.isSimilar(player, item)) {
                ItemMeta itemMeta = item.getItemMeta();
                if (ServerUtils.hasSpecificUpdate("1_13") && itemMeta != null) {
                    int newDamage = ((Damageable)itemMeta).getDamage() + damage;
                    if (item.getType().getMaxDurability() > newDamage) {
                        ((Damageable)itemMeta).setDamage(newDamage);
                        item.setItemMeta(itemMeta);
                    } else if (slot.equalsIgnoreCase("OFFHAND")) {
                        PlayerHandler.setOffHandItem(player, new ItemStack(Material.AIR));
                    } else {
                        player.getInventory().setItem(Integer.parseInt(slot), new ItemStack(Material.AIR));
                    }
                } else if (itemMeta != null) {
                    int newDurability = LegacyAPI.getDurability(item) - damage;
                    if (newDurability > 0) {
                        LegacyAPI.setDurability(item, (short)newDurability);
                    } else if (slot.equalsIgnoreCase("OFFHAND")) {
                        PlayerHandler.setOffHandItem(player, new ItemStack(Material.AIR));
                    } else {
                        player.getInventory().setItem(Integer.parseInt(slot), new ItemStack(Material.AIR));
                    }
                }
                PlayerHandler.updateInventory(player, 1L);
            }
        }
    }

    public void swapItem(Player player, String slot) {
        ItemStack itemStack = this.getItem(player);
        if (!slot.startsWith("CH") && slot.startsWith("C") || StringUtils.isInt(slot)) {
            if (StringUtils.containsIgnoreCase(slot, "CRAFTING")) {
                Inventory topInventory = CompatUtils.getTopInventory(player);
                if (StringUtils.getSlotConversion(slot) == 0) {
                    SchedulerUtils.runLater(1L, () -> {
                        if (PlayerHandler.isCraftingInv(player)) {
                            topInventory.setItem(StringUtils.getSlotConversion(slot), itemStack);
                            PlayerHandler.updateInventory(player, 1L);
                        }
                    });
                } else {
                    topInventory.setItem(StringUtils.getSlotConversion(slot), itemStack);
                }
            } else {
                player.getInventory().setItem(Integer.parseInt(slot), itemStack);
            }
        } else if (slot.equalsIgnoreCase("OFFHAND")) {
            PlayerHandler.setOffHandItem(player, itemStack);
        } else if (Objects.requireNonNull(PlayerHandler.getMainHandItem(player)).getType() == Material.AIR) {
            PlayerHandler.setMainHandItem(player, itemStack);
        } else {
            player.getInventory().addItem(new ItemStack[]{itemStack});
        }
        this.setAnimations(player);
        this.executeCommands(player, null, this.tempItem, "ON_RECEIVE", "RECEIVED", slot);
    }

    public void setAnimations(Player player) {
        if (this.isAnimated() && this.getAnimationHandler().get(player) == null || this.isDynamic() && this.getAnimationHandler().get(player) == null) {
            ItemAnimation Animator = new ItemAnimation(this);
            Animator.openAnimation(player);
            this.localeAnimations.put(player, Animator);
        }
    }

    public void executeCommands(Player player, Player altPlayer, ItemStack itemCopy, String action, String clickType, String slot) {
        if (this.commands != null && this.commands.length > 0 && ItemJoin.getCore().getDependencies().isAuthenticated(player) && !Menu.isOpen(player) && !this.getWarmPending(player) && this.isExecutable(player, action, clickType) && !this.onCooldown(player) && this.isPlayerChargeable(player, this.itemCost != null && !this.itemCost.isEmpty())) {
            this.warmCycle(player, altPlayer, this, this.getWarmDelay(), player.getLocation(), itemCopy, action, clickType, slot);
        }
    }

    private void warmCycle(Player player, Player altPlayer, ItemMap itemMap, int warmCount, Location location, ItemStack itemCopy, String action, String clickType, String slot) {
        if (warmCount != 0) {
            if (itemMap.warmDelay == warmCount) {
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TIME_LEFT, String.valueOf(warmCount)).with(PlaceHolder.Holder.WORLD, player.getWorld().getName()).with(PlaceHolder.Holder.ITEM, StringUtils.translateLayout(itemMap.getCustomName(), player, new PlaceHolder[0]));
                ItemJoin.getCore().getLang().sendLangMessage("general.warmingUp", (CommandSender)player, placeHolders);
                itemMap.addWarmPending(player);
            }
            SchedulerUtils.runLater(20L, () -> {
                if (itemMap.warmLocation(player, location, action)) {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TIME_LEFT, String.valueOf(warmCount)).with(PlaceHolder.Holder.WORLD, player.getWorld().getName()).with(PlaceHolder.Holder.ITEM, StringUtils.translateLayout(itemMap.getCustomName(), player, new PlaceHolder[0]));
                    ItemJoin.getCore().getLang().sendLangMessage("general.warmingTime", (CommandSender)player, placeHolders);
                    itemMap.warmCycle(player, altPlayer, itemMap, warmCount - 1, location, itemCopy, action, clickType, slot);
                } else {
                    itemMap.delWarmPending(player);
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TIME_LEFT, String.valueOf(warmCount)).with(PlaceHolder.Holder.WORLD, player.getWorld().getName()).with(PlaceHolder.Holder.ITEM, StringUtils.translateLayout(itemMap.getCustomName(), player, new PlaceHolder[0]));
                    ItemJoin.getCore().getLang().sendLangMessage("general.warmingHalted", (CommandSender)player, placeHolders);
                }
            });
        } else {
            long delay = 0L;
            if (itemMap.warmDelay != 0) {
                delay = 20L;
            }
            Runnable runnable = () -> {
                if ((!player.isDead() || action.equalsIgnoreCase("ON_DEATH")) && player.isOnline()) {
                    if (this.isExecuted(player, altPlayer, action, clickType, slot)) {
                        if (itemMap.itemCost == null || itemMap.itemCost.isEmpty()) {
                            itemMap.withdrawBalance(player);
                        } else {
                            itemMap.withdrawItemCost(player);
                        }
                        itemMap.playSound(player);
                        itemMap.playParticle(player);
                        itemMap.removeDisposable(player, itemMap, itemCopy, false);
                        itemMap.addPlayerOnCooldown(player);
                    }
                } else {
                    PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TIME_LEFT, String.valueOf(warmCount)).with(PlaceHolder.Holder.WORLD, player.getWorld().getName()).with(PlaceHolder.Holder.ITEM, StringUtils.translateLayout(itemMap.getCustomName(), player, new PlaceHolder[0]));
                    ItemJoin.getCore().getLang().sendLangMessage("general.warmingHalted", (CommandSender)player, placeHolders);
                }
                if (itemMap.warmDelay != 0) {
                    itemMap.delWarmPending(player);
                }
            };
            if (delay <= 0L) {
                runnable.run();
            } else {
                SchedulerUtils.runLater(delay, runnable);
            }
        }
    }

    private boolean warmLocation(Player player, Location location, String action) {
        return !(!Objects.equals(player.getLocation().getWorld(), location.getWorld()) || player.getLocation().distance(location) >= 1.0 || !action.equalsIgnoreCase("ON_DEATH") && player.isDead());
    }

    private boolean isExecutable(Player player, String action, String clickType) {
        ItemCommand[] itemCommands;
        boolean playerSuccess = false;
        boolean silentLimit = false;
        for (ItemCommand itemCommand : itemCommands = this.commands) {
            boolean restrictionLimited;
            if (playerSuccess) break;
            playerSuccess = itemCommand.canExecute(action, clickType);
            boolean bl = restrictionLimited = !this.hasCommandPermissions(player, itemCommand.getAction().config, playerSuccess, silentLimit) || !this.conditionMet(player, itemCommand.getAction().config + "-conditions", playerSuccess, silentLimit);
            if (!restrictionLimited) continue;
            silentLimit = true;
            playerSuccess = false;
        }
        return playerSuccess;
    }

    private boolean getRandomMap(ArrayList<ItemCommand> randomCommands, ItemCommand[] itemCommands, Player player, Player altPlayer, String action, String clickType, String slot) {
        ItemCommand dedicatedMap = (ItemCommand)StringUtils.randomEntry(randomCommands);
        if (player != null && action != null && clickType != null && slot != null && itemCommands != null && !dedicatedMap.execute(player, altPlayer, action, clickType, slot, this)) {
            return this.getRandomMap(randomCommands, itemCommands, player, altPlayer, action, clickType, slot);
        }
        return true;
    }

    private boolean getRandomAll(ArrayList<ItemCommand> randomCommands, ItemCommand[] itemCommands, Player player, Player altPlayer, String action, String clickType, String slot) {
        ItemCommand dedicatedMap = (ItemCommand)StringUtils.randomEntry(randomCommands);
        if (player != null && action != null && slot != null && itemCommands != null && !dedicatedMap.execute(player, altPlayer, action, clickType, slot, this)) {
            randomCommands.remove(dedicatedMap);
            return this.getRandomAll(randomCommands, itemCommands, player, altPlayer, action, clickType, slot);
        }
        randomCommands.remove(dedicatedMap);
        if (player != null && action != null && slot != null && itemCommands != null && !randomCommands.isEmpty()) {
            this.getRandomAll(randomCommands, itemCommands, player, altPlayer, action, clickType, slot);
        }
        return true;
    }

    private String getRandomList(ItemCommand[] itemCommands) {
        if (this.sequence == ItemCommand.CommandSequence.RANDOM_LIST) {
            ArrayList<String> listIndent = new ArrayList<String>();
            for (ItemCommand itemCommand : itemCommands) {
                if (listIndent.contains("+" + itemCommand.getSection() + "+")) continue;
                listIndent.add("+" + itemCommand.getSection() + "+");
            }
            return (String)StringUtils.randomEntry(listIndent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean isExecuted(Player player, Player altPlayer, String action, String clickType, String slot) {
        boolean playerSuccess = false;
        ItemCommand[] itemCommands = this.commands;
        String chosenIndent = this.getRandomList(itemCommands);
        ArrayList<ItemCommand> randomCommands = new ArrayList<ItemCommand>();
        if (this.subjectRemoval) return playerSuccess;
        for (ItemCommand itemCommand : itemCommands) {
            if (this.sequence == ItemCommand.CommandSequence.RANDOM || this.sequence == ItemCommand.CommandSequence.RANDOM_SINGLE) {
                randomCommands.add(itemCommand);
                continue;
            }
            if (this.sequence == ItemCommand.CommandSequence.RANDOM_LIST) {
                if (chosenIndent == null || itemCommand.getSection() == null || !itemCommand.getSection().equalsIgnoreCase(chosenIndent.replace("+", ""))) continue;
                if (!playerSuccess) {
                    playerSuccess = itemCommand.execute(player, altPlayer, action, clickType, slot, this);
                    continue;
                }
                itemCommand.execute(player, altPlayer, action, clickType, slot, this);
                continue;
            }
            Class<ItemCommand> clazz = ItemCommand.class;
            // MONITORENTER : me.RockinChaos.itemjoin.item.ItemCommand.class
            if (!playerSuccess) {
                playerSuccess = itemCommand.execute(player, altPlayer, action, clickType, slot, this);
            } else {
                itemCommand.execute(player, altPlayer, action, clickType, slot, this);
            }
            // MONITOREXIT : clazz
        }
        if (this.sequence == ItemCommand.CommandSequence.RANDOM) {
            return this.getRandomAll(randomCommands, itemCommands, player, altPlayer, action, clickType, slot);
        }
        if (this.sequence != ItemCommand.CommandSequence.RANDOM_SINGLE) return playerSuccess;
        return this.getRandomMap(randomCommands, itemCommands, player, altPlayer, action, clickType, slot);
    }

    private boolean isPlayerChargeable(Player player, boolean materialCost) {
        if (ItemJoin.getCore().getDependencies().getVault().vaultEnabled() && !materialCost && !(this.getCommandCost(player) < 0.0)) {
            boolean balCost;
            double commandCost = this.getCommandCost(player);
            double balance = 0.0;
            try {
                balance = commandCost > 0.0 ? ItemJoin.getCore().getDependencies().getVault().getBalance(player) : 0.0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            boolean bl = balCost = balance >= commandCost;
            if (balCost) {
                return true;
            }
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.COST, String.valueOf(commandCost)).with(PlaceHolder.Holder.BALANCE, String.valueOf(balance));
            ItemJoin.getCore().getLang().sendLangMessage("general.econFailed", (CommandSender)player, placeHolders);
            return false;
        }
        if (materialCost) {
            int commandCost = (int)Math.ceil(this.getCommandCost(player));
            Material mat = ItemHandler.getMaterial(this.itemCost, null);
            int foundAmount = 0;
            for (ItemStack playerInventory : player.getInventory().getContents()) {
                if (playerInventory == null || playerInventory.getType() != mat) continue;
                if (playerInventory.getAmount() >= commandCost) {
                    return true;
                }
                if ((foundAmount += playerInventory.getAmount()) < commandCost) continue;
                return true;
            }
            for (ItemStack equipInventory : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
                if (equipInventory == null || equipInventory.getType() != mat) continue;
                if (equipInventory.getAmount() >= commandCost) {
                    return true;
                }
                if ((foundAmount += equipInventory.getAmount()) < commandCost) continue;
                return true;
            }
            if (ServerUtils.hasSpecificUpdate("1_9") && player.getInventory().getItemInOffHand().getType() == mat) {
                if (player.getInventory().getItemInOffHand().getAmount() >= commandCost) {
                    return true;
                }
                if ((foundAmount += player.getInventory().getItemInOffHand().getAmount()) >= commandCost) {
                    return true;
                }
            }
            if (PlayerHandler.isCraftingInv(player)) {
                for (ItemStack craftInventory : CompatUtils.getTopInventory(player)) {
                    if (craftInventory == null || craftInventory.getType() != mat || craftInventory.getAmount() < commandCost) continue;
                    if (craftInventory.getAmount() >= commandCost) {
                        return true;
                    }
                    if ((foundAmount += craftInventory.getAmount()) < commandCost) continue;
                    return true;
                }
            }
            StringBuilder formatCost = new StringBuilder();
            for (String str : this.itemCost.toLowerCase().split("_")) {
                formatCost.append(str.substring(0, 1).toUpperCase()).append(str.substring(1)).append(" ");
            }
            formatCost = new StringBuilder(formatCost.substring(0, formatCost.length() - 1));
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM_TYPE, formatCost.toString()).with(PlaceHolder.Holder.COST, String.valueOf(commandCost == 0 ? 1 : commandCost)).with(PlaceHolder.Holder.BALANCE, String.valueOf(foundAmount));
            ItemJoin.getCore().getLang().sendLangMessage("general.itemFailed", (CommandSender)player, placeHolders);
            return false;
        }
        return true;
    }

    private void withdrawItemCost(Player player) {
        ItemStack item;
        Material costMaterial = ItemHandler.getMaterial(this.itemCost, null);
        int commandCost = (int)Math.ceil(this.getCommandCost(player));
        int removeAmount = commandCost == 0 ? 1 : commandCost;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack item2 = player.getInventory().getItem(i);
            if (item2 == null || item2.getType() != costMaterial) continue;
            if (item2.getAmount() < removeAmount) {
                removeAmount -= item2.getAmount();
                player.getInventory().setItem(i, ItemHandler.modifyItem(item2, false, item2.getAmount()));
                continue;
            }
            player.getInventory().setItem(i, ItemHandler.modifyItem(player.getInventory().getItem(i), false, removeAmount));
            break;
        }
        if (ServerUtils.hasSpecificUpdate("1_9") && (item = player.getInventory().getItemInOffHand()).getType() == costMaterial) {
            if (item.getAmount() < removeAmount) {
                removeAmount -= item.getAmount();
                PlayerHandler.setOffHandItem(player, ItemHandler.modifyItem(item, false, item.getAmount()));
            } else {
                PlayerHandler.setOffHandItem(player, ItemHandler.modifyItem(item, false, removeAmount));
            }
            PlayerHandler.setOffHandItem(player, ItemHandler.modifyItem(item, false, removeAmount));
        }
        if (PlayerHandler.isCraftingInv(player)) {
            Inventory topInventory = CompatUtils.getTopInventory(player);
            for (int i = 0; i < topInventory.getSize(); ++i) {
                ItemStack item3 = topInventory.getItem(i);
                if (item3 == null || item3.getType() != costMaterial) continue;
                if (item3.getAmount() < removeAmount) {
                    removeAmount -= item3.getAmount();
                    topInventory.setItem(i, ItemHandler.modifyItem(item3, false, item3.getAmount()));
                    continue;
                }
                topInventory.setItem(i, ItemHandler.modifyItem(item3, false, removeAmount));
                break;
            }
        }
        StringBuilder formatCost = new StringBuilder();
        for (String str : this.itemCost.toLowerCase().split("_")) {
            formatCost.append(str.substring(0, 1).toUpperCase()).append(str.substring(1)).append(" ");
        }
        formatCost = new StringBuilder(formatCost.substring(0, formatCost.length() - 1));
        PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.ITEM_TYPE, formatCost.toString()).with(PlaceHolder.Holder.COST, String.valueOf(commandCost == 0 ? 1 : commandCost));
        ItemJoin.getCore().getLang().sendLangMessage("general.itemSuccess", (CommandSender)player, placeHolders);
    }

    private void withdrawBalance(Player player) {
        if (ItemJoin.getCore().getDependencies().getVault().vaultEnabled()) {
            double commandCost = this.getCommandCost(player);
            double balance = 0.0;
            try {
                balance = commandCost > 0.0 ? ItemJoin.getCore().getDependencies().getVault().getBalance(player) : 0.0;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (balance >= commandCost && commandCost > 0.0) {
                try {
                    ItemJoin.getCore().getDependencies().getVault().withdrawBalance(player, commandCost);
                }
                catch (NullPointerException e) {
                    ServerUtils.sendDebugTrace(e);
                }
                PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.COST, String.valueOf(commandCost)).with(PlaceHolder.Holder.BALANCE, String.valueOf(balance));
                ItemJoin.getCore().getLang().sendLangMessage("general.econSuccess", (CommandSender)player, placeHolders);
            }
        }
    }

    private void playSound(Player player) {
        block9: {
            if (this.commandSound != null && !this.commandSound.isEmpty()) {
                try {
                    player.playSound(player.getLocation(), (Sound)CompatUtils.valueOf(Sound.class, this.commandSound), (float)this.commandSoundVolume.doubleValue(), (float)this.commandSoundPitch.doubleValue());
                }
                catch (Exception e) {
                    try {
                        player.playSound(player.getLocation(), this.commandSound, (float)this.commandSoundVolume.doubleValue(), (float)this.commandSoundPitch.doubleValue());
                    }
                    catch (Exception e2) {
                        try {
                            player.playSound(player.getLocation(), this.commandSound.toLowerCase(), (float)this.commandSoundVolume.doubleValue(), (float)this.commandSoundPitch.doubleValue());
                        }
                        catch (Exception e3) {
                            try {
                                player.playSound(player.getLocation(), this.commandSound.toUpperCase(), (float)this.commandSoundVolume.doubleValue(), (float)this.commandSoundPitch.doubleValue());
                            }
                            catch (Exception e4) {
                                ServerUtils.logSevere("{ItemMap} The defined commands-sound " + this.commandSound + " for the item " + this.configName + " is not valid in Minecraft" + ReflectionUtils.getServerVersion() + ". NOTE: Custom sounds are case-sensitive!");
                                if (!ServerUtils.hasPreciseUpdate("1_21_3")) break block9;
                                ServerUtils.logSevere("{ItemMap} See the Minecraft Wiki for a list of command sounds https://minecraft.fandom.com/wiki/Sounds.json/Java_Edition_values");
                            }
                        }
                    }
                }
            }
        }
    }

    private void playParticle(Player player) {
        if (this.commandParticle != null) {
            EffectAPI.spawnParticle(player, this.commandParticle);
        }
    }

    public void removeDisposable(Player player, ItemMap itemMap, ItemStack itemCopy, boolean allItems) {
        if (this.disposable && this.conditionMet(player, "disposable-conditions", true, false) || allItems) {
            if (!allItems) {
                this.setSubjectRemoval(true);
            }
            SchedulerUtils.runLater(1L, () -> {
                block5: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    if (PlayerHandler.isCreativeMode(player)) {
                                        player.closeInventory();
                                    }
                                    if (!itemMap.isSimilar(player, player.getItemOnCursor())) break block4;
                                    player.setItemOnCursor(ItemHandler.modifyItem(player.getItemOnCursor(), allItems, 1));
                                    if (allItems) break block5;
                                    this.setSubjectRemoval(false);
                                    break block5;
                                }
                                int itemSlot = player.getInventory().getHeldItemSlot();
                                if (!itemMap.isSimilar(player, player.getInventory().getItem(itemSlot))) break block6;
                                player.getInventory().setItem(itemSlot, ItemHandler.modifyItem(player.getInventory().getItem(itemSlot), allItems, 1));
                                if (allItems) break block7;
                                this.setSubjectRemoval(false);
                                break block7;
                            }
                            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                                if (!itemMap.isSimilar(player, player.getInventory().getItem(i))) continue;
                                player.getInventory().setItem(i, ItemHandler.modifyItem(player.getInventory().getItem(i), allItems, 1));
                                if (allItems) break;
                                this.setSubjectRemoval(false);
                                break;
                            }
                        }
                        if (!this.isSubjectRemoval() || !PlayerHandler.isCreativeMode(player)) break block8;
                        player.getInventory().addItem(new ItemStack[]{ItemHandler.modifyItem(itemCopy, allItems, 1)});
                        player.setItemOnCursor(new ItemStack(Material.AIR));
                        if (allItems) break block5;
                        this.setSubjectRemoval(false);
                        break block5;
                    }
                    if (this.isSubjectRemoval()) {
                        Inventory topInventory = CompatUtils.getTopInventory(player);
                        for (int i = 0; i < topInventory.getSize(); ++i) {
                            if (!itemMap.isSimilar(player, topInventory.getItem(i))) continue;
                            topInventory.setItem(i, ItemHandler.modifyItem(CompatUtils.getTopInventory(player).getItem(i), allItems, 1));
                            if (allItems) break;
                            this.setSubjectRemoval(false);
                            break;
                        }
                    }
                }
            });
        }
    }

    public boolean onInteractCooldown(Player player, ItemStack item) {
        long playersCooldownList = 0L;
        if (this.playersOnInteractCooldown.containsKey(PlayerHandler.getPlayerID(player) + ".items." + this.configName)) {
            playersCooldownList = this.playersOnInteractCooldown.get(PlayerHandler.getPlayerID(player) + ".items." + this.configName);
        }
        if (System.currentTimeMillis() - playersCooldownList >= (long)(this.interactCooldown * 1000)) {
            this.playersOnInteractCooldown.put(PlayerHandler.getPlayerID(player) + ".items." + this.configName, System.currentTimeMillis());
            if (ServerUtils.hasPreciseUpdate("1_21_3")) {
                ItemStack cloneStack = item.clone();
                SchedulerUtils.run(() -> player.setCooldown(cloneStack, this.interactCooldown * 20));
            }
            return false;
        }
        if (this.onSpamCooldown(player)) {
            this.storedSpammedPlayers.put(PlayerHandler.getPlayerID(player) + ".items." + this.configName, System.currentTimeMillis());
            if (this.cooldownMessage != null && !this.cooldownMessage.isEmpty()) {
                int timeLeft = (int)((long)this.interactCooldown.intValue() - (System.currentTimeMillis() - playersCooldownList) / 1000L);
                player.sendMessage(StringUtils.translateLayout(this.cooldownMessage.replace("%timeleft%", String.valueOf(timeLeft)).replace("%item%", this.customName), player, new PlaceHolder[0]));
            }
        }
        return true;
    }

    private boolean onSpamCooldown(Player player) {
        boolean interactSpam = ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Spamming");
        if (!interactSpam) {
            long playersCooldownList = 0L;
            if (this.storedSpammedPlayers.containsKey(PlayerHandler.getPlayerID(player) + ".items." + this.configName)) {
                playersCooldownList = this.storedSpammedPlayers.get(PlayerHandler.getPlayerID(player) + ".items." + this.configName);
            }
            int spamTime = 1;
            return System.currentTimeMillis() - playersCooldownList >= (long)(spamTime * 1000);
        }
        return true;
    }

    private boolean onCooldown(Player player) {
        long playersCooldownList = 0L;
        if (this.playersOnCooldown.containsKey(PlayerHandler.getPlayerID(player))) {
            playersCooldownList = this.playersOnCooldown.get(PlayerHandler.getPlayerID(player));
        }
        if (this.cooldownSeconds != 0) {
            if (System.currentTimeMillis() - playersCooldownList >= (long)(this.cooldownSeconds * 1000)) {
                return false;
            }
            if (this.onCooldownTick(player)) {
                String cooldownMsg;
                String string = cooldownMsg = this.cooldownMessage != null ? this.cooldownMessage.replace("%timeleft%", String.valueOf((long)this.cooldownSeconds.intValue() - (System.currentTimeMillis() - playersCooldownList) / 1000L)).replace("%item%", this.customName).replace("%itemraw%", Objects.requireNonNull(ItemHandler.getMaterialName(this.tempItem))) : null;
                if (cooldownMsg != null && !this.cooldownMessage.isEmpty()) {
                    cooldownMsg = StringUtils.translateLayout(cooldownMsg, player, new PlaceHolder[0]);
                    player.sendMessage(cooldownMsg);
                }
                this.addPlayerOnCooldownTick(player);
            }
        } else if (this.onCooldownTick(player)) {
            this.addPlayerOnCooldownTick(player);
            return false;
        }
        return true;
    }

    private boolean onCooldownTick(Player player) {
        if (!ItemJoin.getCore().getConfig("items.yml").getBoolean("items-Spamming")) {
            long playersCooldownList = 0L;
            if (this.playersOnCooldownTick.containsKey(PlayerHandler.getPlayerID(player))) {
                playersCooldownList = this.playersOnCooldownTick.get(PlayerHandler.getPlayerID(player));
            }
            return System.currentTimeMillis() - playersCooldownList >= 1000L;
        }
        return true;
    }

    private void addPlayerOnCooldownTick(Player player) {
        this.playersOnCooldownTick.put(PlayerHandler.getPlayerID(player), System.currentTimeMillis());
    }

    private void addPlayerOnCooldown(Player player) {
        this.playersOnCooldown.put(PlayerHandler.getPlayerID(player), System.currentTimeMillis());
    }

    public Map<String, Long> getPlayersOnCooldown() {
        return this.playersOnCooldown;
    }

    public Map<String, List<String>> addMapCommand(Map<String, List<String>> map, ItemCommand command) {
        String commandSection;
        String string = commandSection = command.getSection() != null ? command.getSection() : "DEFAULT";
        if (map.get(commandSection) != null) {
            List<String> s1 = map.get(commandSection);
            s1.add(command.getRawCommand());
            map.put(commandSection, s1);
        } else {
            ArrayList<String> s1 = new ArrayList<String>();
            s1.add(command.getRawCommand());
            map.put(commandSection, s1);
        }
        return map;
    }

    public void setMapCommand(FileConfiguration itemData, Map<String, List<String>> map, String section) {
        for (Map.Entry<String, List<String>> mapElement : map.entrySet()) {
            String mapKey = mapElement.getKey();
            mapKey = mapKey.equalsIgnoreCase("DEFAULT") && map.size() <= 1 ? "" : "." + mapKey;
            itemData.set("items." + this.configName + "." + section + mapKey, mapElement.getValue());
        }
    }

    public String[] trimRecipe(List<String> list) {
        ArrayList<Character> recipe = new ArrayList<Character>();
        String[] recipeShape = new String[]{"XXX", "XXX", "XXX"};
        String[] shape = new String[]{"", "", ""};
        for (int i = 0; i < list.size(); ++i) {
            int charSize = 0;
            for (String character : list.get(i).split("(?<!^)")) {
                StringBuilder sb = new StringBuilder(recipeShape[i]);
                sb.setCharAt(charSize, character.charAt(0));
                recipeShape[i] = sb.toString();
                ++charSize;
            }
            for (String character : recipeShape[i].split("(?<!^)")) {
                recipe.add(Character.valueOf(character.charAt(0)));
            }
            shape[i] = list.get(i).replace("X", " ");
        }
        this.addRecipe(recipe);
        String substring = shape[1].substring(0, shape[1].length() - 1);
        String substring1 = shape[0].substring(0, shape[0].length() - 1);
        if (shape[2].length() == 3 && shape[2].charAt(0) == ' ' && shape[2].charAt(1) == ' ' && shape[2].charAt(2) == ' ' || shape[2].isEmpty()) {
            shape = shape[0].length() == 3 && shape[0].charAt(2) == ' ' && shape[1].length() == 3 && shape[1].charAt(2) == ' ' ? new String[]{substring1, substring} : (shape[0].length() == 3 && shape[0].charAt(0) == ' ' && shape[0].charAt(1) == ' ' && shape[0].charAt(2) == ' ' ? new String[]{shape[1]} : (shape[1].length() == 3 && shape[1].charAt(0) == ' ' && shape[1].charAt(1) == ' ' && shape[1].charAt(2) == ' ' ? new String[]{shape[0]} : new String[]{shape[0], shape[1]}));
        } else if (shape[0].length() < 3 && shape[1].length() < 3 && shape[2].length() == 3 && shape[2].charAt(0) == ' ' && shape[2].charAt(1) == ' ' && shape[2].charAt(2) == ' ') {
            shape = new String[]{shape[0], shape[1]};
        } else if (shape[0].length() == 3 && shape[1].length() == 3 && shape[2].length() == 3 && shape[0].charAt(2) == ' ' && shape[1].charAt(2) == ' ' && shape[2].charAt(2) == ' ') {
            shape = new String[]{substring1, substring, shape[2].substring(0, shape[2].length() - 1)};
        }
        return shape;
    }

    public void removeFromConfig() {
        File itemFile = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
        YamlConfiguration itemData = YamlConfiguration.loadConfiguration((File)itemFile);
        if (ItemJoin.getCore().getConfig("items.yml").getString("items." + this.configName) != null) {
            itemData.set("items." + this.configName, null);
        }
        try {
            itemData.save(itemFile);
            ItemJoin.getCore().getConfiguration().getSource("items.yml");
            ItemJoin.getCore().getConfig("items.yml").options().copyDefaults(false);
        }
        catch (Exception e) {
            ItemJoin.getCore().getPlugin().getServer().getLogger().severe("Could not remove the custom item " + this.configName + " from the items.yml data file!");
            ServerUtils.sendDebugTrace(e);
        }
    }

    private void parseData_1(FileConfiguration itemData) {
        boolean nonNull;
        boolean bl = nonNull = this.dynamicMaterials != null && !this.dynamicMaterials.isEmpty();
        if (!nonNull) {
            itemData.set("items." + this.configName + ".id", (Object)(this.material.toString().toUpperCase() + (this.dataValue != null && this.dataValue != 0 ? ":" + this.dataValue : "")));
        } else {
            for (int i = 0; i < this.dynamicMaterials.size(); ++i) {
                itemData.set("items." + this.configName + ".id." + (i + 1), (Object)this.dynamicMaterials.get(i));
            }
        }
        if (this.AllSlots != null && !this.AllSlots.isEmpty()) {
            StringBuilder saveSlots = new StringBuilder();
            for (String slot : this.AllSlots) {
                saveSlots.append(slot).append(", ");
            }
            if (!saveSlots.substring(0, saveSlots.length() - 2).equalsIgnoreCase("ARBITRARY")) {
                itemData.set("items." + this.configName + ".slot", (Object)saveSlots.substring(0, saveSlots.length() - 2));
            }
        } else if (this.CustomSlot == null) {
            itemData.set("items." + this.configName + ".slot", (Object)this.InvSlot);
        } else if (!this.CustomSlot.equalsIgnoreCase("ARBITRARY")) {
            itemData.set("items." + this.configName + ".slot", (Object)this.CustomSlot);
        }
        if (this.getCount(null) > 1 || this.count != null && this.count.contains("%")) {
            itemData.set("items." + this.configName + ".count", (Object)this.count);
        }
        if (this.durability != null && this.durability > 0) {
            itemData.set("items." + this.configName + ".durability", (Object)this.durability);
        }
        if (this.data != null && this.data > 0) {
            itemData.set("items." + this.configName + ".data", (Object)this.data);
        }
        if (this.modelData != null && !this.modelData.isEmpty()) {
            itemData.set("items." + this.configName + ".model-data", (Object)this.modelData);
        }
        if (this.modelComponents != null && !this.modelComponents.isEmpty()) {
            if (this.modelComponents.get(0) != null) {
                itemData.set("items." + this.configName + ".model-components.strings", (Object)this.modelComponents.get(0));
            }
            if (this.modelComponents.get(1) != null) {
                itemData.set("items." + this.configName + ".model-components.colors", (Object)this.modelComponents.get(1));
            }
            if (this.modelComponents.get(2) != null) {
                itemData.set("items." + this.configName + ".model-components.flags", (Object)this.modelComponents.get(2));
            }
            if (this.modelComponents.get(3) != null) {
                itemData.set("items." + this.configName + ".model-components.floats", (Object)this.modelComponents.get(3));
            }
        }
        if (this.author != null && !this.author.isEmpty()) {
            itemData.set("items." + this.configName + ".author", (Object)this.author.replace('\u00a7', '&'));
        }
        if (this.customName != null && !this.customName.isEmpty() && (this.dynamicNames == null || this.dynamicNames.isEmpty())) {
            String setName;
            if (this.legacySecret != null && !ServerUtils.hasSpecificUpdate("1_14")) {
                ItemMeta itemMeta = this.tempItem.getItemMeta();
                if (itemMeta != null) {
                    itemMeta.setDisplayName("");
                    this.tempItem.setItemMeta(itemMeta);
                }
                StringUtils.colorEncode(this.tempItem, this.legacySecret);
                String itemInfo = Objects.requireNonNull(this.tempItem.getItemMeta()).getDisplayName();
                setName = this.customName.replace(itemInfo, "").replace('\u00a7', '&');
            } else {
                setName = this.customName.replace('\u00a7', '&');
            }
            if (setName.startsWith("&f") && !ItemJoin.getCore().getData().dataTagsEnabled()) {
                setName = setName.substring(2);
            }
            if (!Objects.requireNonNull(ItemHandler.getMaterialName(this.tempItem)).equalsIgnoreCase(setName)) {
                itemData.set("items." + this.configName + ".name", (Object)setName);
            }
        } else if (this.dynamicNames != null && !this.dynamicNames.isEmpty()) {
            for (int i = 0; i < this.dynamicNames.size(); ++i) {
                itemData.set("items." + this.configName + ".name." + (i + 1), (Object)this.dynamicNames.get(i).replace('\u00a7', '&'));
            }
        }
        if (this.customLore != null && !this.customLore.isEmpty() && (this.dynamicLores == null || this.dynamicLores.isEmpty())) {
            itemData.set("items." + this.configName + ".lore", this.customLore);
        } else if (this.dynamicLores != null && !this.dynamicLores.isEmpty()) {
            for (int i = 0; i < this.dynamicLores.size(); ++i) {
                ArrayList<String> lores = new ArrayList<String>();
                for (String lore : this.dynamicLores.get(i)) {
                    lores.add(lore.replace('\u00a7', '&'));
                }
                itemData.set("items." + this.configName + ".lore." + (i + 1), lores);
            }
        }
        if (this.listPages != null && !this.listPages.isEmpty()) {
            for (int i = 0; i < this.listPages.size(); ++i) {
                ArrayList<String> pages = new ArrayList<String>();
                for (String page : this.listPages.get(i)) {
                    pages.add(page.replace('\u00a7', '&'));
                }
                itemData.set("items." + this.configName + ".pages." + (i + 1), pages);
            }
        }
        if (this.probability != null && this.probability != -1 && this.probability != 0) {
            itemData.set("items." + this.configName + ".probability", (Object)this.probability);
        }
    }

    private void parseData_2(FileConfiguration itemData) {
        if (this.commands != null && this.commands.length > 0) {
            Map<String, List<String>> interactAll = new HashMap<String, List<String>>();
            Map<String, List<String>> interactLeft = new HashMap<String, List<String>>();
            Map<String, List<String>> interactRight = new HashMap<String, List<String>>();
            Map<String, List<String>> interactAir = new HashMap<String, List<String>>();
            Map<String, List<String>> interactBlock = new HashMap<String, List<String>>();
            Map<String, List<String>> interactLeftAir = new HashMap<String, List<String>>();
            Map<String, List<String>> interactLeftBlock = new HashMap<String, List<String>>();
            Map<String, List<String>> interactRightAir = new HashMap<String, List<String>>();
            Map<String, List<String>> interactRightBlock = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryAll = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryMiddle = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryCreative = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryLeft = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryShiftLeft = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryRight = new HashMap<String, List<String>>();
            Map<String, List<String>> inventoryShiftRight = new HashMap<String, List<String>>();
            Map<String, List<String>> inventorySwapCursor = new HashMap<String, List<String>>();
            Map<String, List<String>> onEquip = new HashMap<String, List<String>>();
            Map<String, List<String>> unEquip = new HashMap<String, List<String>>();
            Map<String, List<String>> onHold = new HashMap<String, List<String>>();
            Map<String, List<String>> onJoin = new HashMap<String, List<String>>();
            Map<String, List<String>> onDeath = new HashMap<String, List<String>>();
            Map<String, List<String>> onKill = new HashMap<String, List<String>>();
            Map<String, List<String>> onDamage = new HashMap<String, List<String>>();
            Map<String, List<String>> onHit = new HashMap<String, List<String>>();
            Map<String, List<String>> onFire = new HashMap<String, List<String>>();
            Map<String, List<String>> onConsume = new HashMap<String, List<String>>();
            Map<String, List<String>> onDrop = new HashMap<String, List<String>>();
            Map<String, List<String>> onReceive = new HashMap<String, List<String>>();
            Map<String, List<String>> physical = new HashMap<String, List<String>>();
            for (ItemCommand command : this.commands) {
                if (command.matchAction(ItemCommand.Action.INTERACT_ALL)) {
                    interactAll = this.addMapCommand(interactAll, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_AIR)) {
                    interactAir = this.addMapCommand(interactAir, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_BLOCK)) {
                    interactBlock = this.addMapCommand(interactBlock, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_RIGHT_ALL)) {
                    interactRight = this.addMapCommand(interactRight, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_RIGHT_AIR)) {
                    interactRightAir = this.addMapCommand(interactRightAir, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_RIGHT_BLOCK)) {
                    interactRightBlock = this.addMapCommand(interactRightBlock, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_LEFT_ALL)) {
                    interactLeft = this.addMapCommand(interactLeft, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_LEFT_AIR)) {
                    interactLeftAir = this.addMapCommand(interactLeftAir, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INTERACT_LEFT_BLOCK)) {
                    interactLeftBlock = this.addMapCommand(interactLeftBlock, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_ALL)) {
                    inventoryAll = this.addMapCommand(inventoryAll, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_MIDDLE)) {
                    inventoryMiddle = this.addMapCommand(inventoryMiddle, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_CREATIVE)) {
                    inventoryCreative = this.addMapCommand(inventoryCreative, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_LEFT)) {
                    inventoryLeft = this.addMapCommand(inventoryLeft, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_SHIFT_LEFT)) {
                    inventoryShiftLeft = this.addMapCommand(inventoryShiftLeft, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_RIGHT)) {
                    inventoryRight = this.addMapCommand(inventoryRight, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_SHIFT_RIGHT)) {
                    inventoryShiftRight = this.addMapCommand(inventoryShiftRight, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.INVENTORY_SWAP_CURSOR)) {
                    inventorySwapCursor = this.addMapCommand(inventorySwapCursor, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_EQUIP)) {
                    onEquip = this.addMapCommand(onEquip, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.UN_EQUIP)) {
                    unEquip = this.addMapCommand(unEquip, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_HOLD)) {
                    onHold = this.addMapCommand(onHold, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_JOIN)) {
                    onJoin = this.addMapCommand(onJoin, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_DEATH)) {
                    onDeath = this.addMapCommand(onDeath, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_KILL)) {
                    onKill = this.addMapCommand(onKill, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_DAMAGE)) {
                    onDamage = this.addMapCommand(onDamage, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_HIT)) {
                    onHit = this.addMapCommand(onHit, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_FIRE)) {
                    onFire = this.addMapCommand(onFire, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_CONSUME)) {
                    onConsume = this.addMapCommand(onConsume, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_DROP)) {
                    onDrop = this.addMapCommand(onDrop, command);
                    continue;
                }
                if (command.matchAction(ItemCommand.Action.ON_RECEIVE)) {
                    onReceive = this.addMapCommand(onReceive, command);
                    continue;
                }
                if (!command.matchAction(ItemCommand.Action.PHYSICAL)) continue;
                physical = this.addMapCommand(physical, command);
            }
            if (!interactAll.isEmpty()) {
                this.setMapCommand(itemData, interactAll, "interact");
            }
            if (!interactAir.isEmpty()) {
                this.setMapCommand(itemData, interactAir, "interact-air");
            }
            if (!interactBlock.isEmpty()) {
                this.setMapCommand(itemData, interactBlock, "interact-block");
            }
            if (!interactRight.isEmpty()) {
                this.setMapCommand(itemData, interactRight, "interact-right");
            }
            if (!interactRightAir.isEmpty()) {
                this.setMapCommand(itemData, interactRightAir, "interact-air-right");
            }
            if (!interactRightBlock.isEmpty()) {
                this.setMapCommand(itemData, interactRightBlock, "interact-block-right");
            }
            if (!interactLeft.isEmpty()) {
                this.setMapCommand(itemData, interactLeft, "interact-left");
            }
            if (!interactLeftAir.isEmpty()) {
                this.setMapCommand(itemData, interactLeftAir, "interact-air-left");
            }
            if (!interactLeftBlock.isEmpty()) {
                this.setMapCommand(itemData, interactLeftBlock, "interact-block-left");
            }
            if (!inventoryAll.isEmpty()) {
                this.setMapCommand(itemData, inventoryAll, "inventory");
            }
            if (!inventoryMiddle.isEmpty()) {
                this.setMapCommand(itemData, inventoryMiddle, "inventory-middle");
            }
            if (!inventoryCreative.isEmpty()) {
                this.setMapCommand(itemData, inventoryCreative, "inventory-creative");
            }
            if (!inventoryLeft.isEmpty()) {
                this.setMapCommand(itemData, inventoryLeft, "inventory-left");
            }
            if (!inventoryShiftLeft.isEmpty()) {
                this.setMapCommand(itemData, inventoryShiftLeft, "inventory-shift-left");
            }
            if (!inventoryRight.isEmpty()) {
                this.setMapCommand(itemData, inventoryRight, "inventory-right");
            }
            if (!inventoryShiftRight.isEmpty()) {
                this.setMapCommand(itemData, inventoryShiftRight, "inventory-shift-right");
            }
            if (!inventorySwapCursor.isEmpty()) {
                this.setMapCommand(itemData, inventorySwapCursor, "inventory-swap-cursor");
            }
            if (!onEquip.isEmpty()) {
                this.setMapCommand(itemData, onEquip, "on-equip");
            }
            if (!unEquip.isEmpty()) {
                this.setMapCommand(itemData, unEquip, "un-equip");
            }
            if (!onHold.isEmpty()) {
                this.setMapCommand(itemData, onHold, "on-hold");
            }
            if (!onJoin.isEmpty()) {
                this.setMapCommand(itemData, onJoin, "on-join");
            }
            if (!onDeath.isEmpty()) {
                this.setMapCommand(itemData, onDeath, "on-death");
            }
            if (!onKill.isEmpty()) {
                this.setMapCommand(itemData, onKill, "on-kill");
            }
            if (!onDamage.isEmpty()) {
                this.setMapCommand(itemData, onDamage, "on-damage");
            }
            if (!onHit.isEmpty()) {
                this.setMapCommand(itemData, onHit, "on-hit");
            }
            if (!onFire.isEmpty()) {
                this.setMapCommand(itemData, onFire, "on-fire");
            }
            if (!onConsume.isEmpty()) {
                this.setMapCommand(itemData, onConsume, "on-consume");
            }
            if (!onDrop.isEmpty()) {
                this.setMapCommand(itemData, onDrop, "on-drop");
            }
            if (!onReceive.isEmpty()) {
                this.setMapCommand(itemData, onReceive, "on-receive");
            }
            if (!physical.isEmpty()) {
                this.setMapCommand(itemData, physical, "physical");
            }
        }
    }

    private void parseData_3(FileConfiguration itemData) {
        if (this.toggleCommands != null && !this.getToggleCommands().isEmpty()) {
            itemData.set("items." + this.configName + ".toggle", this.toggleCommands);
        }
        if (this.commandSound != null) {
            itemData.set("items." + this.configName + ".commands-sound", (Object)(this.commandSound + (this.commandSoundVolume != 1.0 && this.commandSoundPitch != 1.0 ? ":" + this.commandSoundVolume + ":" + this.commandSoundPitch : "")));
        }
        if (this.commandParticle != null && !this.commandParticle.isEmpty()) {
            itemData.set("items." + this.configName + ".commands-particle", (Object)this.commandParticle);
        }
        if (this.sequence != null && this.sequence != ItemCommand.CommandSequence.SEQUENTIAL) {
            itemData.set("items." + this.configName + ".commands-sequence", (Object)this.sequence.name());
        }
        if (this.itemCost != null && !this.itemCost.isEmpty()) {
            itemData.set("items." + this.configName + ".commands-item", (Object)this.itemCost);
        }
        if (this.getCommandCost(null) > 0.0 || this.cost != null && this.cost.contains("%")) {
            itemData.set("items." + this.configName + ".commands-cost", (Object)this.cost);
        }
        if (this.commandsReceive != null && this.commandsReceive != 0) {
            itemData.set("items." + this.configName + ".commands-receive", (Object)this.commandsReceive);
        }
        if (this.warmDelay != null && this.warmDelay != 0) {
            itemData.set("items." + this.configName + ".commands-warmup", (Object)this.warmDelay);
        }
        if (this.cooldownSeconds != null && this.cooldownSeconds != 0) {
            itemData.set("items." + this.configName + ".commands-cooldown", (Object)this.cooldownSeconds);
        }
        if (this.cooldownMessage != null && !this.cooldownMessage.isEmpty()) {
            itemData.set("items." + this.configName + ".cooldown-message", (Object)this.cooldownMessage);
        }
        if (this.toggleMessage != null && !this.toggleMessage.isEmpty()) {
            itemData.set("items." + this.configName + ".toggle-message", (Object)this.toggleMessage);
        }
        if (this.enchants != null && !this.enchants.isEmpty()) {
            StringBuilder enchantList = new StringBuilder();
            for (Map.Entry<String, Integer> entry : this.enchants.entrySet()) {
                enchantList.append(entry.getKey()).append(":").append(entry.getValue()).append(", ");
            }
            itemData.set("items." + this.configName + ".enchantments", (Object)enchantList.substring(0, enchantList.length() - 2));
        }
        if (this.fireworkType != null) {
            itemData.set("items." + this.configName + ".firework.type", (Object)this.fireworkType.name());
        }
        if (this.power != null && this.power != 0) {
            itemData.set("items." + this.configName + ".firework.power", (Object)this.power);
        }
        if (this.fireworkFlicker) {
            itemData.set("items." + this.configName + ".firework.flicker", (Object)true);
        }
        if (this.fireworkTrail) {
            itemData.set("items." + this.configName + ".firework.trail", (Object)true);
        }
        if (this.fireworkColor != null && !this.fireworkColor.isEmpty()) {
            StringBuilder colorList = new StringBuilder();
            for (DyeColor dyeColor : this.fireworkColor) {
                colorList.append(dyeColor.name()).append(", ");
            }
            itemData.set("items." + this.configName + ".firework.colors", (Object)colorList.substring(0, colorList.length() - 2));
        }
        if (this.interactCooldown != null && this.interactCooldown != 0) {
            itemData.set("items." + this.configName + ".use-cooldown", (Object)this.interactCooldown);
        }
        if (this.teleportEffect != null && !this.teleportEffect.isEmpty()) {
            itemData.set("items." + this.configName + ".teleport-effect", (Object)this.teleportEffect);
        }
        if (this.teleportSound != null && !this.teleportSound.isEmpty()) {
            itemData.set("items." + this.configName + ".teleport-sound", (Object)(this.teleportSound + (this.teleportSoundVolume != 1.0 && this.teleportSoundPitch != 1.0 ? ":" + this.teleportSoundVolume + ":" + this.teleportSoundPitch : "")));
        }
        if (this.itemflags != null && !this.itemflags.isEmpty()) {
            itemData.set("items." + this.configName + ".itemflags", (Object)this.itemflags);
        }
        if (this.triggers != null && !this.triggers.isEmpty()) {
            String defaultTriggers = ItemJoin.getCore().getConfig("config.yml").getString("Settings.Default-Triggers");
            StringBuilder saveTriggers = new StringBuilder();
            for (String trigger : this.triggers.replace(" ", "").split(",")) {
                if (defaultTriggers != null && defaultTriggers.toUpperCase().contains(trigger.toUpperCase())) continue;
                saveTriggers.append(trigger).append(", ");
            }
            if (!StringUtils.isEmpty(saveTriggers) || saveTriggers.toString().equals(this.triggers)) {
                itemData.set("items." + this.configName + ".triggers", (Object)this.triggers);
            }
        }
        if (this.limitModes != null && !this.limitModes.isEmpty()) {
            itemData.set("items." + this.configName + ".limit-modes", (Object)this.limitModes);
        }
        if (this.toggleNode != null && !this.toggleNode.isEmpty()) {
            itemData.set("items." + this.configName + ".toggle-permission", (Object)this.toggleNode);
        }
        if (this.permissionNode != null && !this.permissionNode.isEmpty()) {
            itemData.set("items." + this.configName + ".permission-node", (Object)this.permissionNode);
        }
        if (this.leatherColor != null && !this.leatherColor.isEmpty()) {
            itemData.set("items." + this.configName + ".leather-color", (Object)this.leatherColor);
        } else if (this.leatherHex != null && !this.leatherHex.isEmpty()) {
            itemData.set("items." + this.configName + ".leather-color", (Object)this.leatherHex);
        }
        if (this.customMapImage != null && !this.customMapImage.isEmpty()) {
            itemData.set("items." + this.configName + ".custom-map-image", (Object)this.customMapImage);
        }
        if (this.mapId != -1) {
            itemData.set("items." + this.configName + ".map-id", (Object)this.mapId);
        }
        if (this.skullTexture != null && !this.skullTexture.isEmpty() && (this.dynamicTextures == null || this.dynamicTextures.isEmpty())) {
            itemData.set("items." + this.configName + ".skull-texture", (Object)this.skullTexture);
        } else if (this.dynamicTextures != null && !this.dynamicTextures.isEmpty()) {
            for (int i = 0; i < this.dynamicTextures.size(); ++i) {
                itemData.set("items." + this.configName + ".skull-texture." + (i + 1), (Object)this.dynamicTextures.get(i));
            }
        }
        if (this.skullOwner != null && !this.skullOwner.isEmpty() && (this.dynamicOwners == null || this.dynamicOwners.isEmpty())) {
            itemData.set("items." + this.configName + ".skull-owner", (Object)this.skullOwner);
        } else if (this.dynamicOwners != null && !this.dynamicOwners.isEmpty()) {
            for (int i = 0; i < this.dynamicOwners.size(); ++i) {
                itemData.set("items." + this.configName + ".skull-owner." + (i + 1), (Object)this.dynamicOwners.get(i));
            }
        }
        if (this.chargeColor != null) {
            itemData.set("items." + this.configName + ".charge-color", (Object)this.chargeColor.name());
        }
        if (this.bannerPatterns != null && !this.bannerPatterns.isEmpty()) {
            StringBuilder bannerList = new StringBuilder();
            for (Pattern pattern : this.bannerPatterns) {
                bannerList.append(pattern.getColor().name()).append(ItemHandler.getPatternName(pattern)).append(", ");
            }
            itemData.set("items." + this.configName + ".banner-meta", (Object)bannerList.substring(0, bannerList.length() - 2));
        }
        if (this.trimPattern != null && !this.trimPattern.isEmpty()) {
            Map.Entry<String, String> entry = this.trimPattern.entrySet().iterator().next();
            itemData.set("items." + this.configName + ".trim-meta", (Object)(entry.getKey().toUpperCase() + ":" + entry.getValue().toUpperCase()));
        }
        if (this.recipe != null && !this.recipe.isEmpty() && this.ingredients != null && !this.ingredients.isEmpty()) {
            ArrayList<String> ingredientList = new ArrayList<String>();
            ArrayList<String> recipeTempList = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Character ingredient : this.ingredients.keySet()) {
                ItemRecipe itemRecipe = this.ingredients.get(ingredient);
                ingredientList.add(ingredient + ":" + (itemRecipe.getMaterial() != null ? itemRecipe.getMaterial().name() : itemRecipe.getMap()) + (itemRecipe.getData() > 0 ? ":" + itemRecipe.getData() : "") + (itemRecipe.getCount() > 1 ? ":#" + itemRecipe.getCount() : ""));
            }
            String recipeLine = "";
            for (Character recipeCharacter : this.recipe.get(0)) {
                if (StringUtils.countCharacters(recipeLine = recipeLine + recipeCharacter) != 3) continue;
                recipeTempList.add(recipeLine);
                recipeLine = "";
            }
            if (!recipeLine.isEmpty()) {
                while (StringUtils.countCharacters((String)recipeTempList.get(0)) != StringUtils.countCharacters(recipeLine)) {
                    recipeLine = recipeLine + "X";
                }
                recipeTempList.add(recipeLine);
            }
            for (String str : this.trimRecipe(recipeTempList)) {
                arrayList.add(str.replace(" ", "X"));
            }
            itemData.set("items." + this.configName + ".recipe", arrayList);
            itemData.set("items." + this.configName + ".ingredients", ingredientList);
        }
    }

    private void parseData_4(FileConfiguration itemData) {
        StringBuilder worldList;
        StringBuilder regionList;
        if (this.mobsDrop()) {
            ArrayList<String> mobsList = new ArrayList<String>();
            for (EntityType mobs : this.mobsDrop.keySet()) {
                mobsList.add(mobs.name() + ":" + this.mobsDrop.get(mobs).toString());
            }
            itemData.set("items." + this.configName + ".mobs-drop", mobsList);
        }
        if (this.blocksDrop()) {
            ArrayList<String> blocksList = new ArrayList<String>();
            for (Material blocks : this.blocksDrop.keySet()) {
                blocksList.add(blocks.name() + ":" + this.blocksDrop.get(blocks).toString());
            }
            itemData.set("items." + this.configName + ".blocks-drop", blocksList);
        }
        if (this.effect != null && !this.effect.isEmpty()) {
            StringBuilder effectList = new StringBuilder();
            for (PotionEffect effects : this.effect) {
                effectList.append(CompatUtils.getName(effects)).append(":").append(effects.getAmplifier()).append(":").append(effects.getDuration()).append(", ");
            }
            itemData.set("items." + this.configName + ".potion-effects", (Object)effectList.substring(0, effectList.length() - 2));
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            StringBuilder attributeList = new StringBuilder();
            for (String attribute : this.attributes.keySet()) {
                attributeList.append("{").append(attribute).append(":").append(this.attributes.get(attribute)).append("}, ");
            }
            itemData.set("items." + this.configName + ".attributes", (Object)attributeList.substring(0, attributeList.length() - 2));
        }
        if (this.contents != null && !this.contents.isEmpty()) {
            itemData.set("items." + this.configName + ".contents", this.contents);
        }
        if (this.nbtProperty != null && !this.nbtProperty.isEmpty()) {
            Iterator<String> propertyList = new StringJoiner(", ");
            for (Object property : this.nbtProperty.keySet()) {
                String value = this.nbtProperty.get(property).toString().replace("\"", "");
                if (value.matches("\\[.*?,.*?\\]")) {
                    value = value.replace(",", "#").replace("[", "").replace("]", "");
                    value = "[" + value + "]";
                }
                ((StringJoiner)((Object)propertyList)).add(property + ":" + value);
            }
            itemData.set("items." + this.configName + ".properties", (Object)((StringJoiner)((Object)propertyList)).toString());
        }
        if (this.disposableConditions != null && !this.disposableConditions.isEmpty()) {
            if (this.disposableConditions.size() == 1) {
                itemData.set("items." + this.configName + ".disposable-conditions", (Object)this.disposableConditions.get(0));
            } else if (!this.triggerConditions.isEmpty()) {
                itemData.set("items." + this.configName + ".disposable-conditions", this.disposableConditions);
            }
        }
        if (this.disposableMessage != null && !this.disposableMessage.isEmpty()) {
            itemData.set("items." + this.configName + ".disposable-fail-message", (Object)this.disposableMessage);
        }
        if (this.triggerConditions != null && !this.triggerConditions.isEmpty()) {
            if (this.triggerConditions.size() == 1) {
                itemData.set("items." + this.configName + ".trigger-conditions", (Object)this.triggerConditions.get(0));
            } else {
                itemData.set("items." + this.configName + ".trigger-conditions", this.triggerConditions);
            }
        }
        if (this.triggerMessage != null && !this.triggerMessage.isEmpty()) {
            itemData.set("items." + this.configName + ".trigger-fail-message", (Object)this.triggerMessage);
        }
        if (this.commandConditions != null && !this.commandConditions.isEmpty()) {
            for (String property : this.commandConditions.keySet()) {
                if (this.commandConditions.get(property).size() == 1) {
                    itemData.set("items." + this.configName + property + "-conditions", (Object)this.commandConditions.get(property).get(0));
                    continue;
                }
                if (this.commandConditions.get(property).isEmpty()) continue;
                itemData.set("items." + this.configName + property + "-conditions", this.commandConditions.get(property));
            }
        }
        if (this.commandPermissions != null && !this.commandPermissions.isEmpty()) {
            for (String property : this.commandPermissions.keySet()) {
                if (this.commandPermissions.get(property).size() == 1) {
                    itemData.set("items." + this.configName + property + "-permission", (Object)this.commandPermissions.get(property).get(0));
                    continue;
                }
                if (this.commandPermissions.get(property).isEmpty()) continue;
                itemData.set("items." + this.configName + property + "-permission", this.commandPermissions.get(property));
            }
        }
        if (this.commandMessages != null && !this.commandMessages.isEmpty()) {
            for (String property : this.commandMessages.keySet()) {
                itemData.set("items." + this.configName + property + "-fail-message", (Object)this.commandMessages.get(property));
            }
        }
        if (this.enabledRegions != null && !this.enabledRegions.isEmpty()) {
            regionList = new StringBuilder();
            for (String region : this.enabledRegions) {
                regionList.append(region).append(", ");
            }
            itemData.set("items." + this.configName + ".enabled-regions", (Object)regionList.substring(0, regionList.length() - 2));
        }
        if (this.disabledRegions != null && !this.disabledRegions.isEmpty()) {
            regionList = new StringBuilder();
            for (String region : this.disabledRegions) {
                regionList.append(region).append(", ");
            }
            itemData.set("items." + this.configName + ".disabled-regions", (Object)regionList.substring(0, regionList.length() - 2));
        }
        if (this.enabledWorlds != null && !this.enabledWorlds.isEmpty()) {
            worldList = new StringBuilder();
            for (String world : this.enabledWorlds) {
                worldList.append(world).append(", ");
            }
            if (!worldList.toString().startsWith("ALL") && !worldList.toString().startsWith("GLOBAL")) {
                itemData.set("items." + this.configName + ".enabled-worlds", (Object)worldList.substring(0, worldList.length() - 2));
            }
        }
        if (this.disabledWorlds != null && !this.disabledWorlds.isEmpty()) {
            worldList = new StringBuilder();
            for (String world : this.disabledWorlds) {
                worldList.append(world).append(", ");
            }
            if (!worldList.toString().startsWith("DISABLED") || !worldList.toString().startsWith("DISABLE")) {
                itemData.set("items." + this.configName + ".disabled-worlds", (Object)worldList.substring(0, worldList.length() - 2));
            }
        }
    }

    public void saveToConfig() {
        File itemFile = new File(ItemJoin.getCore().getPlugin().getDataFolder(), "items.yml");
        YamlConfiguration itemData = YamlConfiguration.loadConfiguration((File)itemFile);
        this.renderItemStack();
        if (ItemJoin.getCore().getConfig("items.yml").getString("items." + this.configName) != null) {
            itemData.set("items." + this.configName, null);
        }
        this.parseData_1((FileConfiguration)itemData);
        this.parseData_2((FileConfiguration)itemData);
        this.parseData_3((FileConfiguration)itemData);
        this.parseData_4((FileConfiguration)itemData);
        try {
            itemData.save(itemFile);
            ItemJoin.getCore().getConfiguration().getSource("items.yml");
            ItemJoin.getCore().getConfig("items.yml").options().copyDefaults(false);
        }
        catch (Exception e) {
            ItemJoin.getCore().getPlugin().getServer().getLogger().severe("Could not save the new custom item " + this.configName + " to the items.yml data file!");
            ServerUtils.sendDebugTrace(e);
        }
    }

    public ItemMap clone() {
        try {
            ItemMap clone = (ItemMap)super.clone();
            for (Field field : this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                field.set(clone, field.get(this));
            }
            return clone;
        }
        catch (Exception e) {
            ServerUtils.sendDebugTrace(e);
            return this;
        }
    }
}

