/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.HashMap;
import java.util.Objects;
import me.RockinChaos.itemjoin.core.handlers.ItemHandler;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class Interact
implements Listener {
    private final HashMap<ItemStack, Long> interactLock = new HashMap();

    @EventHandler(priority=EventPriority.LOW)
    private void onInteractCancel(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        if (!PlayerHandler.isMenuClick(player, event.getAction()) && (event.hasItem() && event.getAction() != Action.PHYSICAL && !ItemUtilities.getUtilities().isAllowed(player, item, "cancel-events") || event.getAction() != Action.PHYSICAL && event.getAction() != Action.LEFT_CLICK_AIR && ServerUtils.hasSpecificUpdate("1_9") && event.getHand() != null && event.getHand().toString().equalsIgnoreCase("OFF_HAND") && !ItemUtilities.getUtilities().isAllowed(player, PlayerHandler.getMainHandItem(event.getPlayer()), "cancel-events"))) {
            if (item != null && ItemHandler.isBookQuill(item) || ItemHandler.isBookQuill(PlayerHandler.getMainHandItem(event.getPlayer()))) {
                player.closeInventory();
            }
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteractCooldown(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item != null && (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR)) {
            switch (item.getType().name()) {
                case "LAVA_BUCKET": 
                case "WATER_BUCKET": 
                case "MILK_BUCKET": 
                case "COD_BUCKET": 
                case "SALMON_BUCKET": 
                case "PUFFERFISH_BUCKET": 
                case "TROPICAL_FISH_BUCKET": {
                    this.handleUseCooldown(event.getPlayer(), item, (Cancellable)event);
                    break;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBowShootCooldown(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            this.handleUseCooldown((Player)event.getEntity(), event.getBow(), (Cancellable)event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsumeCooldown(PlayerItemConsumeEvent event) {
        this.handleUseCooldown(event.getPlayer(), event.getItem(), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlaceCooldown(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        this.handleUseCooldown(player, PlayerHandler.getPerfectHandItem(player, ServerUtils.hasSpecificUpdate("1_9") ? event.getHand().name() : ""), (Cancellable)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunchCooldown(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            ItemStack item = PlayerHandler.getMainHandItem(player).getType() != Material.AIR && StringUtils.containsIgnoreCase(PlayerHandler.getMainHandItem(player).getType().name(), event.getEntity().getType().name()) ? PlayerHandler.getMainHandItem(player) : (PlayerHandler.getOffHandItem(player).getType() != Material.AIR && StringUtils.containsIgnoreCase(PlayerHandler.getOffHandItem(player).getType().name(), event.getEntity().getType().name()) ? PlayerHandler.getOffHandItem(player) : PlayerHandler.getMainHandItem(player));
            this.handleUseCooldown(player, item, (Cancellable)event);
        }
    }

    private void handleUseCooldown(Player player, ItemStack item, Cancellable event) {
        ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(item);
        if (itemMap != null && itemMap.getInteractCooldown() > 0) {
            long lockDuration = !this.interactLock.isEmpty() && this.interactLock.get(item) != null ? System.currentTimeMillis() - this.interactLock.get(item) : -1L;
            this.interactLock.put(item, System.currentTimeMillis());
            if (itemMap.onInteractCooldown(player, item) && (lockDuration == -1L || lockDuration > 30L)) {
                event.setCancelled(true);
                PlayerHandler.updateInventory(player);
            }
        }
    }

    @EventHandler
    private void onMoveToSelectItem(InventoryClickEvent event) {
        int slot;
        ItemStack item;
        Player player = (Player)event.getWhoClicked();
        ItemStack itemStack = StringUtils.containsIgnoreCase(event.getAction().name(), "HOTBAR") ? (event.getCurrentItem() != null ? event.getCurrentItem().clone() : event.getCurrentItem()) : (item = event.getCursor() != null ? event.getCursor().clone() : event.getCursor());
        int n = event.getSlot() <= 8 ? event.getSlot() : (slot = event.getHotbarButton() >= 0 ? event.getHotbarButton() : 9);
        if (slot <= 8 && !ItemUtilities.getUtilities().isAllowed(player, item, "selectable")) {
            SchedulerUtils.run(() -> {
                if (Objects.equals(PlayerHandler.getMainHandItem(player), item) && !Interact.setSelectSlot(player, slot, true)) {
                    Interact.setSelectSlot(player, slot, false);
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSelectItem(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getNewSlot());
        int newSlot = event.getNewSlot();
        int oldSlot = event.getPreviousSlot();
        if (!ItemUtilities.getUtilities().isAllowed(player, item, "selectable")) {
            ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(item);
            SchedulerUtils.runLater(itemMap.getSelectableDelay(), () -> {
                if (Objects.equals(PlayerHandler.getMainHandItem(player), item) && !Interact.setSelectSlot(player, newSlot, newSlot > oldSlot)) {
                    Interact.setSelectSlot(player, newSlot, newSlot <= oldSlot);
                }
            });
        }
    }

    public static boolean setSelectSlot(Player player, int slot, boolean forward) {
        int i = slot;
        while (forward ? i < 9 : i >= 0) {
            if (ItemUtilities.getUtilities().isAllowed(player, player.getInventory().getItem(i), "selectable")) {
                PlayerHandler.setHotbarSlot(player, i);
                return true;
            }
            if (forward) {
                ++i;
                continue;
            }
            --i;
        }
        return false;
    }
}

