/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.Objects;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class Placement
implements Listener {
    @EventHandler(ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        Player player = event.getPlayer();
        if (!ItemUtilities.getUtilities().isAllowed(player, item, "placement")) {
            event.setCancelled(true);
            PlayerHandler.updateInventory(player, 1L);
        }
    }

    @EventHandler
    private void onCountLock(PlayerInteractEvent event) {
        ItemStack item = event.getItem() != null ? event.getItem().clone() : event.getItem();
        Player player = event.getPlayer();
        int slot = player.getInventory().getHeldItemSlot();
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK && !PlayerHandler.isCreativeMode(player)) && !ItemUtilities.getUtilities().isAllowed(player, item, "count-lock")) {
            ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(item);
            item.setAmount(itemMap.getCount(player).intValue());
            SchedulerUtils.run(() -> {
                boolean isCraftingInv = PlayerHandler.isCraftingInv(player);
                if (StringUtils.containsIgnoreCase(item.getType().name(), "WATER") || StringUtils.containsIgnoreCase(item.getType().name(), "LAVA") || item.getType().name().equalsIgnoreCase("BUCKET") || StringUtils.containsIgnoreCase(item.getType().name(), "POTION")) {
                    if (player.getInventory().getHeldItemSlot() == slot) {
                        PlayerHandler.setMainHandItem(player, item);
                    } else if (isCraftingInv) {
                        player.getInventory().setItem(slot, item);
                    }
                } else {
                    ItemStack heldItem = PlayerHandler.getHandItem(player);
                    if (heldItem.getAmount() <= 1) {
                        if (ServerUtils.hasSpecificUpdate("1_9")) {
                            if (Objects.equals(event.getHand(), EquipmentSlot.HAND)) {
                                if (player.getInventory().getHeldItemSlot() == slot) {
                                    PlayerHandler.setMainHandItem(player, item);
                                } else if (isCraftingInv) {
                                    player.getInventory().setItem(slot, item);
                                }
                            } else if (Objects.equals(event.getHand(), EquipmentSlot.OFF_HAND)) {
                                PlayerHandler.setOffHandItem(player, item);
                            }
                        } else if (player.getInventory().getHeldItemSlot() == slot) {
                            PlayerHandler.setMainHandItem(player, item);
                        } else if (isCraftingInv) {
                            player.getInventory().setItem(slot, item);
                        }
                    } else if (itemMap.isSimilar(player, heldItem)) {
                        heldItem.setAmount(itemMap.getCount(player).intValue());
                    }
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onFramePlace(PlayerInteractEntityEvent event) {
        block5: {
            try {
                if (!(event.getRightClicked() instanceof ItemFrame)) break block5;
                try {
                    ItemStack item = ServerUtils.hasSpecificUpdate("1_9") ? PlayerHandler.getPerfectHandItem(event.getPlayer(), event.getHand().toString()) : PlayerHandler.getPerfectHandItem(event.getPlayer(), "");
                    Player player = event.getPlayer();
                    if (!ItemUtilities.getUtilities().isAllowed(player, item, "placement")) {
                        event.setCancelled(true);
                        PlayerHandler.updateInventory(player, 1L);
                    }
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    private void onFrameLock(PlayerInteractEntityEvent event) {
        block13: {
            try {
                if (!(event.getRightClicked() instanceof ItemFrame)) break block13;
                try {
                    ItemMap itemMap;
                    ItemStack item = ServerUtils.hasSpecificUpdate("1_9") ? PlayerHandler.getPerfectHandItem(event.getPlayer(), event.getHand().toString()) : PlayerHandler.getPerfectHandItem(event.getPlayer(), "");
                    Player player = event.getPlayer();
                    if (PlayerHandler.isCreativeMode(player) && !ItemUtilities.getUtilities().isAllowed(player, item, "count-lock") && (itemMap = ItemUtilities.getUtilities().getItemMap(item)) != null) {
                        ItemStack heldItem = PlayerHandler.getHandItem(player);
                        if (heldItem.getAmount() <= 1) {
                            if (ServerUtils.hasSpecificUpdate("1_9")) {
                                if (event.getHand().equals((Object)EquipmentSlot.HAND)) {
                                    PlayerHandler.setMainHandItem(player, item);
                                } else if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
                                    PlayerHandler.setOffHandItem(player, item);
                                }
                            } else {
                                PlayerHandler.setMainHandItem(player, item);
                            }
                        } else if (itemMap.isSimilar(player, heldItem)) {
                            heldItem.setAmount(itemMap.getCount(player).intValue());
                        }
                    }
                }
                catch (Exception e) {
                    ServerUtils.sendDebugTrace(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

