/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.Objects;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.types.Clear;
import me.RockinChaos.itemjoin.core.utils.types.Hats;
import me.RockinChaos.itemjoin.core.utils.types.PlaceHolder;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.ItemStack;

public class Processes
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHat(PlayerCommandPreprocessEvent event) {
        ItemMap itemMap;
        String command = event.getMessage();
        Player player = event.getPlayer();
        ItemStack item = PlayerHandler.getHandItem(player);
        if (item.getType() != Material.AIR && Hats.isHat(command) && (itemMap = ItemUtilities.getUtilities().getItemMap(item)) != null && itemMap.isNotHat()) {
            event.setMessage("itemjoin_blocked");
            event.setCancelled(true);
            ServerUtils.logDebug("{Processes} " + player.getName() + " tried to perform the command " + command + " on the item " + itemMap.getConfigName() + " but was blocked by the itemflag no-hat.");
            PlaceHolder placeHolders = new PlaceHolder().with(PlaceHolder.Holder.TARGET_PLAYER, player.getName()).with(PlaceHolder.Holder.ITEM, itemMap.getConfigName()).with(PlaceHolder.Holder.COMMAND, command);
            ItemJoin.getCore().getLang().sendLangMessage("commands.item.badCommand", (CommandSender)player, placeHolders);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String command = event.getMessage();
        Player player = event.getPlayer();
        if (Clear.isClear(command)) {
            for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(player.getInventory().getItem(slot));
                if (itemMap == null || !itemMap.isAllowedItem(player, player.getInventory().getItem(slot), "no-clear")) continue;
                ItemStack keepItem = Objects.requireNonNull(player.getInventory().getItem(slot)).clone();
                int setSlot = slot;
                SchedulerUtils.run(() -> {
                    player.getInventory().setItem(setSlot, keepItem);
                    ServerUtils.logDebug("{Processes} " + player.getName() + " has triggered the NO-CLEAR itemflag for " + ItemUtilities.getUtilities().getItemMap(keepItem).getConfigName() + ".");
                });
            }
        }
    }
}

