/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.HashMap;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ReflectionUtils;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class Projectile
implements Listener {
    private final HashMap<Integer, ItemStack> projectileList = new HashMap();

    @EventHandler(ignoreCancelled=true)
    private void onProjectileFire(EntityShootBowEvent event) {
        LivingEntity entity = event.getEntity();
        if (ServerUtils.hasSpecificUpdate("1_16") && entity instanceof Player && event.getBow() != null) {
            ItemStack consumable = event.getConsumable() != null ? event.getConsumable().clone() : event.getConsumable();
            Player player = (Player)event.getEntity();
            this.projectileList.put(event.getProjectile().getEntityId(), consumable);
            if (!event.getBow().getType().name().equalsIgnoreCase("CROSSBOW") && !ItemUtilities.getUtilities().isAllowed(player, consumable, "count-lock")) {
                SchedulerUtils.runLater(1L, () -> {
                    boolean setConsumable = false;
                    for (ItemStack item : player.getInventory()) {
                        if (item == null || !item.isSimilar(consumable)) continue;
                        item.setAmount(item.getAmount() + consumable.getAmount());
                        setConsumable = true;
                        ServerUtils.logDebug("{Projectile} Added " + consumable.getAmount() + "x of " + consumable.getType() + " to existing stack in " + player.getName() + "'s inventory.");
                        break;
                    }
                    if (!setConsumable) {
                        ItemUtilities.getUtilities().getItemMap(consumable).giveTo(player, new int[0]);
                    }
                });
            }
        } else if (entity instanceof Player) {
            HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
            Player player = (Player)event.getEntity();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                ItemStack item = player.getInventory().getItem(i);
                if (item == null || item.getType() != Material.ARROW || !event.getProjectile().getType().name().equalsIgnoreCase("ARROW")) continue;
                ItemStack cloneStack = item.clone();
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(item);
                if (itemMap != null) {
                    cloneStack.setAmount(itemMap.getCount(player).intValue());
                }
                map.put(i, cloneStack);
            }
            SchedulerUtils.runLater(2L, () -> {
                for (Integer key : map.keySet()) {
                    ItemStack item = player.getInventory().getItem(key.intValue());
                    if (item != null && item.getAmount() == ((ItemStack)map.get(key)).getAmount()) continue;
                    this.projectileList.put(event.getProjectile().getEntityId(), (ItemStack)map.get(key));
                    if (ItemUtilities.getUtilities().isAllowed(player, (ItemStack)map.get(key), "count-lock")) continue;
                    player.getInventory().setItem(key.intValue(), (ItemStack)map.get(key));
                }
                PlayerHandler.updateInventory(player, 1L);
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onProjectileHit(ProjectileHitEvent event) {
        org.bukkit.entity.Projectile projectile = event.getEntity();
        if (projectile.getShooter() instanceof Player && this.projectileList.get(projectile.getEntityId()) != null && !ItemUtilities.getUtilities().isAllowed((Player)projectile.getShooter(), this.projectileList.get(projectile.getEntityId()), "teleport")) {
            block13: {
                String teleportSound;
                Player player = (Player)projectile.getShooter();
                Location location = projectile.getLocation();
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(this.projectileList.get(projectile.getEntityId()));
                location.setPitch(player.getLocation().getPitch());
                location.setYaw(player.getLocation().getYaw());
                player.teleport(location);
                if (itemMap.getTeleportEffect() != null) {
                    try {
                        projectile.getWorld().playEffect(projectile.getLocation(), Effect.valueOf((String)itemMap.getTeleportEffect()), 15);
                    }
                    catch (Exception e) {
                        ServerUtils.logSevere("{Projectile} The defined teleport-effect " + itemMap.getTeleportEffect() + " for the item " + itemMap.getConfigName() + " is not valid!");
                    }
                }
                if ((teleportSound = itemMap.getTeleportSound()) != null && !teleportSound.isEmpty()) {
                    float teleportVolume = (float)itemMap.getTeleportVolume().doubleValue();
                    float teleportPitch = (float)itemMap.getTeleportPitch().doubleValue();
                    try {
                        projectile.getWorld().playSound(projectile.getLocation(), (Sound)CompatUtils.valueOf(Sound.class, teleportSound), teleportVolume, teleportPitch);
                    }
                    catch (Exception e) {
                        try {
                            projectile.getWorld().playSound(projectile.getLocation(), teleportSound, teleportVolume, teleportPitch);
                        }
                        catch (Exception e2) {
                            try {
                                projectile.getWorld().playSound(projectile.getLocation(), teleportSound.toLowerCase(), teleportVolume, teleportPitch);
                            }
                            catch (Exception e3) {
                                try {
                                    projectile.getWorld().playSound(projectile.getLocation(), teleportSound.toUpperCase(), teleportVolume, teleportPitch);
                                }
                                catch (Exception e4) {
                                    ServerUtils.logSevere("{Projectile} The defined teleport-sound " + teleportSound + " for the item " + itemMap.getConfigName() + " is not valid in Minecraft" + ReflectionUtils.getServerVersion() + ". NOTE: Custom sounds are case-sensitive!");
                                    if (!ServerUtils.hasPreciseUpdate("1_21_3")) break block13;
                                    ServerUtils.logSevere("{ItemMap} See the Minecraft Wiki for a list of command sounds https://minecraft.fandom.com/wiki/Sounds.json/Java_Edition_values");
                                }
                            }
                        }
                    }
                }
            }
            projectile.remove();
        }
    }

    @EventHandler
    private void onCrossbow(PlayerInteractEvent event) {
        ItemStack item = event.getItem() != null ? event.getItem().clone() : event.getItem();
        Player player = event.getPlayer();
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && item != null && item.getType().name().equalsIgnoreCase("CROSSBOW") && !PlayerHandler.isCreativeMode(player)) {
            HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                ItemStack invItem = player.getInventory().getItem(i);
                if (invItem == null || invItem.getType() != Material.ARROW) continue;
                ItemStack cloneStack = invItem.clone();
                ItemMap itemMap = ItemUtilities.getUtilities().getItemMap(player.getInventory().getItem(i));
                if (itemMap != null) {
                    cloneStack.setAmount(itemMap.getCount(player).intValue());
                }
                map.put(i, cloneStack);
            }
            this.crossyAction(player, map, 10);
        }
    }

    public void crossyAction(Player player, HashMap<Integer, ItemStack> map, int tries) {
        if (tries != 0) {
            SchedulerUtils.runLater(26L, () -> {
                boolean projectileReturned = false;
                for (Integer key : map.keySet()) {
                    ItemStack item = player.getInventory().getItem(key.intValue());
                    if (item != null && item.getAmount() == ((ItemStack)map.get(key)).getAmount() || ItemUtilities.getUtilities().isAllowed(player, (ItemStack)map.get(key), "count-lock")) continue;
                    player.getInventory().setItem(key.intValue(), (ItemStack)map.get(key));
                    projectileReturned = true;
                }
                if (projectileReturned) {
                    PlayerHandler.updateInventory(player, 1L);
                } else {
                    this.crossyAction(player, map, tries - 1);
                }
            });
        }
    }
}

