/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.CompatUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.core.utils.StringUtils;
import me.RockinChaos.itemjoin.core.utils.api.LegacyAPI;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemRecipe;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Crafter;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Recipes
implements Listener {
    public Recipes() {
        if (ServerUtils.hasSpecificUpdate("1_21") && StringUtils.isRegistered(CrafterRecipes.class.getSimpleName())) {
            ItemJoin.getCore().getPlugin().getServer().getPluginManager().registerEvents((Listener)new CrafterRecipes(), (Plugin)ItemJoin.getCore().getPlugin());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onPlayerCraft(PrepareItemCraftEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Player) {
            Player player = (Player)holder;
            Inventory topInventory = CompatUtils.getTopInventory(player);
            for (int i = 0; i < topInventory.getSize(); ++i) {
                ItemStack item = topInventory.getItem(i);
                if (item == null || item.getType() == Material.AIR || ItemUtilities.getUtilities().isAllowed(player, item, "item-craftable")) continue;
                ItemStack reAdd = item.clone();
                topInventory.setItem(i, null);
                player.getInventory().addItem(new ItemStack[]{reAdd});
                PlayerHandler.updateInventory(player, 1L);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onRepairAnvil(InventoryClickEvent event) {
        boolean isAnvil = event.getInventory().getType().toString().contains("ANVIL");
        boolean isGrindstone = event.getInventory().getType().toString().contains("GRINDSTONE");
        if (isAnvil || isGrindstone) {
            Player player = (Player)event.getWhoClicked();
            int rSlot = event.getSlot();
            ItemStack invItem = event.getInventory().getItem(1);
            if (rSlot == 2 && invItem != null && invItem.getType() != Material.AIR) {
                ItemStack item = event.getInventory().getItem(2);
                if ((isGrindstone || !StringUtils.containsIgnoreCase(invItem.getType().toString(), "PAPER") && !StringUtils.containsIgnoreCase(invItem.getType().toString(), "NAME_TAG")) && !ItemUtilities.getUtilities().isAllowed(player, item, "item-repairable") || !ItemUtilities.getUtilities().isAllowed(player, invItem, "item-repairable")) {
                    event.setCancelled(true);
                    PlayerHandler.updateExperienceLevels(player);
                    PlayerHandler.updateInventory(player, 1L);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPrepareRecipe(PrepareItemCraftEvent event) {
        ItemStack result;
        ItemStack itemStack = result = event.getRecipe() != null ? event.getRecipe().getResult() : event.getInventory().getResult();
        if (result != null && result.getType() != Material.AIR) {
            Player player = CompatUtils.getPlayer(event.getView());
            ArrayList<ItemMap> mapList = new ArrayList<ItemMap>();
            ItemMap checkMap = ItemUtilities.getUtilities().getItemMap(result);
            if (checkMap == null || !checkMap.isRecipe()) {
                return;
            }
            mapList.add(checkMap);
            for (ItemMap itemMap : ItemUtilities.getUtilities().getItems()) {
                if (itemMap == null || !itemMap.isRecipe()) continue;
                mapList.add(itemMap);
            }
            Inventory inventoryClone = Bukkit.createInventory(null, (int)9);
            int setSlot = 0;
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (setSlot >= 9) break;
                if (i <= 0 && checkMap.isSimilar(player, item)) continue;
                if (item != null) {
                    inventoryClone.setItem(setSlot, item);
                }
                ++setSlot;
            }
            if (!mapList.isEmpty()) {
                ItemMap itemMap;
                Iterator iterator = mapList.iterator();
                while (iterator.hasNext() && !Recipes.handleRecipe(itemMap = (ItemMap)iterator.next(), event.getInventory(), inventoryClone, player, false, false, null)) {
                }
            } else {
                Recipes.handleRecipe(checkMap, event.getInventory(), inventoryClone, player, false, false, null);
            }
        }
    }

    @EventHandler
    public void onCraftRecipe(CraftItemEvent event) {
        ItemMap checkMap = ItemUtilities.getUtilities().getItemMap(event.getRecipe().getResult());
        if (checkMap != null && checkMap.isRecipe()) {
            Inventory inventoryClone = Bukkit.createInventory(null, (int)18);
            int setSlot = 0;
            for (int i = 0; i < event.getInventory().getSize(); ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (setSlot >= 9) break;
                if (checkMap.isSimilar(CompatUtils.getPlayer(event.getView()), item)) continue;
                if (item != null) {
                    inventoryClone.setItem(setSlot, item.clone());
                }
                ++setSlot;
            }
            Recipes.handleRecipe(checkMap, event.getInventory(), inventoryClone, CompatUtils.getPlayer(event.getView()), true, event.isShiftClick(), (Cancellable)event);
        }
    }

    private static boolean handleRecipe(ItemMap itemMap, CraftingInventory craftInventory, Inventory inventoryClone, Player player, boolean isCrafted, boolean isShiftClick, Cancellable event) {
        if (player != null && !itemMap.hasPermission(player, player.getWorld())) {
            craftInventory.setResult(new ItemStack(Material.AIR));
        } else {
            boolean isLegacy;
            boolean isCrafter;
            boolean bl = isCrafter = event != null && event.getClass().getSimpleName().equalsIgnoreCase("CrafterCraftEvent");
            ItemStack result = craftInventory != null && craftInventory.getResult() != null ? craftInventory.getResult().clone() : (isCrafter ? ((CrafterCraftEvent)event).getResult() : new ItemStack(Material.AIR));
            boolean bl2 = isLegacy = !ServerUtils.hasSpecificUpdate("1_13");
            CraftingInventory craftedInventory = craftInventory != null ? craftInventory : (isCrafter ? ((Crafter)((CrafterCraftEvent)event).getBlock().getState()).getInventory() : null);
            boolean success = false;
            for (List<Character> tempRecipe : itemMap.getRecipe()) {
                if (success) continue;
                boolean removed = false;
                int resultSize = 0;
                int ingredientSize = 0;
                int confirmations = 0;
                for (Character character : tempRecipe) {
                    if (character.charValue() == 'X') continue;
                    ++ingredientSize;
                }
                if (!isCrafted) {
                    confirmations = Recipes.getConfirmations(itemMap, player, inventoryClone);
                } else if (craftedInventory != null) {
                    boolean cycleShift = true;
                    while (Recipes.getConfirmations(itemMap, player, inventoryClone) == ingredientSize && cycleShift) {
                        cycleShift = isShiftClick;
                        for (int i = 0; i < inventoryClone.getSize(); ++i) {
                            ItemStack item = inventoryClone.getItem(i);
                            if (item == null) continue;
                            for (Character ingredient : itemMap.getIngredients().keySet()) {
                                ItemRecipe itemRecipe = itemMap.getIngredients().get(ingredient);
                                ItemMap ingredMap = ItemUtilities.getUtilities().getItemMap(itemRecipe.getMap());
                                if ((ingredMap != null || !itemRecipe.getMaterial().equals((Object)item.getType()) || isLegacy && LegacyAPI.getDataValue(item) != itemRecipe.getData()) && (ingredMap == null || !ingredMap.isSimilar(player, item)) || item.getAmount() < itemRecipe.getCount()) continue;
                                int removal = item.getAmount() - itemRecipe.getCount();
                                if (removal <= 0) {
                                    craftedInventory.setItem(isCrafter ? i : i + 1, new ItemStack(Material.AIR));
                                    inventoryClone.setItem(i, new ItemStack(Material.AIR));
                                } else {
                                    ItemStack craftItem = craftedInventory.getItem(isCrafter ? i : i + 1);
                                    if (craftItem != null) {
                                        craftItem.setAmount(removal + (isCrafter ? 1 : 0));
                                        item.setAmount(removal + (isCrafter ? 1 : 0));
                                    }
                                }
                                removed = true;
                            }
                        }
                        ++resultSize;
                    }
                }
                if (!isCrafted && confirmations == ingredientSize) {
                    if (craftInventory != null) {
                        craftInventory.setResult(itemMap.getItem(player));
                    } else if (isCrafter) {
                        ((CrafterCraftEvent)event).setResult(itemMap.getItem(player));
                    }
                    return true;
                }
                if (!isCrafted) {
                    if (craftInventory != null) {
                        craftInventory.setResult(new ItemStack(Material.AIR));
                        continue;
                    }
                    if (!isCrafter) continue;
                    ((CrafterCraftEvent)event).setResult(new ItemStack(Material.AIR));
                    continue;
                }
                if (removed) {
                    if (resultSize > 0 && isShiftClick) {
                        result.setAmount(resultSize);
                    }
                    if (player == null || event == null) continue;
                    event.setCancelled(true);
                    if (isShiftClick) {
                        success = true;
                        player.getInventory().addItem(new ItemStack[]{result});
                        continue;
                    }
                    if (CompatUtils.getCursor(player).getType() != Material.AIR && CompatUtils.getCursor(player).isSimilar(result)) {
                        success = true;
                        CompatUtils.getCursor(player).setAmount(CompatUtils.getCursor(player).getAmount() + result.getAmount());
                        continue;
                    }
                    success = true;
                    CompatUtils.setCursor(player, result);
                    continue;
                }
                if (!isCrafter || event == null) continue;
                event.setCancelled(true);
            }
        }
        return false;
    }

    private static int getConfirmations(ItemMap itemMap, Player player, Inventory inventoryClone) {
        int confirmations = 0;
        for (int i = 0; i < inventoryClone.getSize(); ++i) {
            ItemStack item = inventoryClone.getItem(i);
            if (item == null) continue;
            for (Character ingredient : itemMap.getIngredients().keySet()) {
                ItemRecipe itemRecipe = itemMap.getIngredients().get(ingredient);
                ItemMap ingredMap = ItemUtilities.getUtilities().getItemMap(itemRecipe.getMap());
                if ((ingredMap != null || !itemRecipe.getMaterial().equals((Object)item.getType())) && (ingredMap == null || !ingredMap.isSimilar(player, item)) || item.getAmount() < itemRecipe.getCount()) continue;
                ++confirmations;
            }
        }
        return confirmations;
    }

    public static class CrafterRecipes
    implements Listener {
        @EventHandler
        public void onCrafterRecipe(CrafterCraftEvent event) {
            ItemMap checkMap = ItemUtilities.getUtilities().getItemMap(event.getRecipe().getResult());
            if (checkMap != null && checkMap.isRecipe()) {
                Inventory inventoryClone = Bukkit.createInventory(null, (int)18);
                Inventory crafterInventory = ((Crafter)event.getBlock().getState()).getInventory();
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = crafterInventory.getItem(i);
                    if (item == null || checkMap.isSimilar(null, item)) continue;
                    inventoryClone.setItem(i, item.clone());
                }
                Recipes.handleRecipe(checkMap, null, inventoryClone, null, true, false, (Cancellable)event);
            }
        }
    }
}

