/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners;

import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.item.ItemMap;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

public class Splittable
implements Listener {
    @EventHandler(ignoreCancelled=true)
    private void onClickSplit(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryAction action = event.getAction();
        ItemStack currentItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        boolean isCreative = PlayerHandler.isCreativeMode(player);
        if (currentItem != null && currentItem.getType() != Material.AIR) {
            ItemMap itemMap;
            if (action.equals((Object)InventoryAction.PICKUP_HALF)) {
                ItemMap itemMap2 = ItemUtilities.getUtilities().getItemMap(currentItem);
                if (itemMap2 != null && itemMap2.isSimilar(player, currentItem) && !ItemUtilities.getUtilities().isAllowed(player, currentItem, "splittable")) {
                    event.setCancelled(true);
                }
            } else if (action.equals((Object)InventoryAction.PLACE_ALL) && isCreative && cursorItem != null && cursorItem.getType() != Material.AIR && (itemMap = ItemUtilities.getUtilities().getItemMap(currentItem)) != null && itemMap.isSimilar(player, currentItem) && itemMap.isSimilar(player, cursorItem) && currentItem.getAmount() / 2 == cursorItem.getAmount() && !ItemUtilities.getUtilities().isAllowed(player, currentItem, "splittable")) {
                event.setCancelled(true);
                player.closeInventory();
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDragSplit(InventoryDragEvent event) {
        ItemMap itemMap;
        Player player = (Player)event.getWhoClicked();
        ItemStack cursorItem = event.getOldCursor();
        if (cursorItem.getType() != Material.AIR && (itemMap = ItemUtilities.getUtilities().getItemMap(cursorItem)) != null && itemMap.isSimilar(player, cursorItem) && !ItemUtilities.getUtilities().isAllowed(player, cursorItem, "splittable")) {
            event.setCancelled(true);
        }
    }
}

