/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.listeners.triggers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.PluginData;
import me.RockinChaos.itemjoin.core.handlers.PlayerHandler;
import me.RockinChaos.itemjoin.core.utils.SchedulerUtils;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.item.ItemUtilities;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerGuard
implements Listener {
    private final HashMap<Player, String> fromRegions = new HashMap();
    private final List<Player> movementCooldown = new ArrayList<Player>();
    private final List<Player> changeCooldown = new ArrayList<Player>();

    @EventHandler(ignoreCancelled=true)
    private void setRegionItems(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getTo() != null && event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && Objects.equals(event.getFrom().getWorld(), event.getTo().getWorld())) {
            return;
        }
        SchedulerUtils.runAsync(() -> {
            if (PlayerHandler.isPlayer((Entity)player) && !this.onMovementCooldown(player) && PluginData.getInfo().isEnabled(player, "ALL")) {
                this.handleRegions(player, player.getLocation(), true, event.getFrom());
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    private void setRegionItems(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (PlayerHandler.isPlayer((Entity)player) && PluginData.getInfo().isEnabled(player, "ALL")) {
            this.handleRegions(player, event.getTo(), false, event.getFrom());
        }
        ServerUtils.logDebug("{ItemMap} " + player.getName() + " has performed A REGION trigger by teleporting.");
    }

    private void handleRegions(Player player, Location location, boolean async, Location fromLocation) {
        String regionList = ItemJoin.getCore().getDependencies().getGuard().getRegionAtLocation(location);
        List<String> regions = Arrays.asList((regionList + ", GLOBAL").replace(" ", "").split(","));
        List<String> prevRegions = this.fromRegions.get(player) != null ? Arrays.asList(this.fromRegions.get(player).replace(" ", "").split(",")) : Collections.emptyList();
        if (!(regionList.equals(this.fromRegions.get(player) != null ? this.fromRegions.get(player) : "") && this.onChangedCooldown(player) && async)) {
            if (!prevRegions.isEmpty()) {
                for (String region : prevRegions) {
                    if (region.isEmpty()) continue;
                    this.runAuth(async, player, fromLocation.getWorld(), ItemUtilities.TriggerType.REGION_LEAVE, region, regions);
                }
            }
            for (String region : regions) {
                if (region.isEmpty()) continue;
                this.runAuth(async, player, location.getWorld(), ItemUtilities.TriggerType.REGION_ENTER, region, regions);
            }
            this.fromRegions.put(player, regionList);
        }
    }

    private void runAuth(boolean async, Player player, World world, ItemUtilities.TriggerType type, String region, List<String> regions) {
        if (async) {
            SchedulerUtils.run(() -> ItemUtilities.getUtilities().setAuthenticating(player, world, type, player.getGameMode(), region, regions));
        } else {
            ItemUtilities.getUtilities().setAuthenticating(player, world, type, player.getGameMode(), region, regions);
        }
    }

    private boolean onMovementCooldown(Player player) {
        if (!this.movementCooldown.contains(player)) {
            this.movementCooldown.add(player);
            SchedulerUtils.runLater(10L, () -> this.movementCooldown.remove(player));
            return false;
        }
        return true;
    }

    private boolean onChangedCooldown(Player player) {
        if (!this.changeCooldown.contains(player)) {
            this.changeCooldown.add(player);
            SchedulerUtils.runLater(160L, () -> this.changeCooldown.remove(player));
            return false;
        }
        return true;
    }
}

