/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.utils.images;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;

public class GIF {
    private final List<Frame> frames;

    public GIF(String image) {
        GIFDecoder decoder = new GIFDecoder(ItemJoin.getCore().getPlugin().getDataFolder(), image);
        List frames = IntStream.range(0, decoder.getFrameCount()).mapToObj(i -> new Frame(decoder.getFrame(i), decoder.getDelay(i))).collect(Collectors.toList());
        this.frames = Collections.unmodifiableList(frames);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Frame get(int index) {
        return this.frames.get(index);
    }

    public static class GIFDecoder {
        private final int STATUS_OK = 0;
        private final int STATUS_FORMAT_ERROR = 1;
        private final byte[] block = new byte[256];
        private final ArrayList<Frame> frames;
        private BufferedInputStream in;
        private int status = this.STATUS_OK;
        private int width;
        private int height;
        private boolean gctFlag;
        private int gctSize;
        private int[] gct = null;
        private int[] lct = null;
        private int[] act;
        private int bgIndex;
        private int bgColor;
        private int lastBgColor;
        private boolean interlace;
        private int ix;
        private int iy;
        private int iw;
        private int ih;
        private Rectangle lastRect;
        private BufferedImage image;
        private BufferedImage lastImage;
        private int blockSize = 0;
        private int dispose = 0;
        private int lastDispose = 0;
        private boolean transparency = false;
        private int delay = 0;
        private int transIndex;
        private short[] prefix;
        private byte[] suffix;
        private byte[] pixelStack;
        private byte[] pixels;
        private int frameCount = 0;

        private GIFDecoder(File folder, String image) {
            this.frames = new ArrayList();
            FileInputStream fileStream = null;
            try {
                fileStream = new FileInputStream(new File(folder, image));
            }
            catch (FileNotFoundException e) {
                ServerUtils.sendSevereTrace(e);
            }
            BufferedInputStream bufferedStream = null;
            if (fileStream != null) {
                this.in = bufferedStream = new BufferedInputStream(fileStream);
                this.readHeader();
                if (this.status == this.STATUS_OK) {
                    this.readContents();
                    if (this.frameCount < 0) {
                        this.status = this.STATUS_FORMAT_ERROR;
                    }
                }
            } else {
                this.status = 2;
            }
            try {
                if (fileStream != null) {
                    fileStream.close();
                    bufferedStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private int getDelay(int n) {
            this.delay = -1;
            if (n >= 0 && n < this.frameCount) {
                this.delay = this.frames.get(n).delay;
            }
            return this.delay;
        }

        private int getFrameCount() {
            return this.frameCount;
        }

        private void setPixels() {
            int[] dataBuffer = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            if (this.lastDispose > 0) {
                if (this.lastDispose == 3) {
                    int n = this.frameCount - 2;
                    this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
                }
                if (this.lastImage != null) {
                    int[] prev = ((DataBufferInt)this.lastImage.getRaster().getDataBuffer()).getData();
                    System.arraycopy(prev, 0, dataBuffer, 0, this.width * this.height);
                    if (this.lastDispose == 2) {
                        Graphics2D g = this.image.createGraphics();
                        Color c = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                        g.setColor(c);
                        g.setComposite(AlphaComposite.Src);
                        g.fill(this.lastRect);
                        g.dispose();
                    }
                }
            }
            int pass = 1;
            int inc = 8;
            int inline = 0;
            for (int i = 0; i < this.ih; ++i) {
                int line = i;
                if (this.interlace) {
                    if (inline >= this.ih) {
                        switch (++pass) {
                            case 2: {
                                inline = 4;
                                break;
                            }
                            case 3: {
                                inline = 2;
                                inc = 4;
                                break;
                            }
                            case 4: {
                                inline = 1;
                                inc = 2;
                            }
                        }
                    }
                    line = inline;
                    inline += inc;
                }
                if ((line += this.iy) >= this.height) continue;
                int k = line * this.width;
                int dx = k + this.ix;
                int dlm = dx + this.iw;
                if (k + this.width < dlm) {
                    dlm = k + this.width;
                }
                int sx = i * this.iw;
                while (dx < dlm) {
                    int index;
                    int c;
                    if ((c = this.act[index = this.pixels[sx++] & 0xFF]) != 0) {
                        dataBuffer[dx] = c;
                    }
                    ++dx;
                }
            }
        }

        private BufferedImage getFrame(int n) {
            BufferedImage im = null;
            if (n >= 0 && n < this.frameCount) {
                im = this.frames.get(n).image;
            }
            return im;
        }

        private void decodeImageData() {
            int code;
            int NullCode = -1;
            int nPix = this.iw * this.ih;
            if (this.pixels == null || this.pixels.length < nPix) {
                this.pixels = new byte[nPix];
            }
            int maxStackSize = 4096;
            if (this.prefix == null) {
                this.prefix = new short[maxStackSize];
            }
            if (this.suffix == null) {
                this.suffix = new byte[maxStackSize];
            }
            if (this.pixelStack == null) {
                this.pixelStack = new byte[maxStackSize + 1];
            }
            int data_size = this.read();
            int clear = 1 << data_size;
            int end_of_information = clear + 1;
            int available = clear + 2;
            int old_code = NullCode;
            int code_size = data_size + 1;
            int code_mask = (1 << code_size) - 1;
            for (code = 0; code < clear; ++code) {
                this.prefix[code] = 0;
                this.suffix[code] = (byte)code;
            }
            int bi = 0;
            int pi = 0;
            int top = 0;
            int first = 0;
            int count = 0;
            int bits = 0;
            int datum = 0;
            int i = 0;
            while (i < nPix) {
                if (top == 0) {
                    if (bits < code_size) {
                        if (count == 0) {
                            count = this.readBlock();
                            if (count <= 0) break;
                            bi = 0;
                        }
                        datum += (this.block[bi] & 0xFF) << bits;
                        bits += 8;
                        ++bi;
                        --count;
                        continue;
                    }
                    code = datum & code_mask;
                    datum >>= code_size;
                    bits -= code_size;
                    if (code > available || code == end_of_information) break;
                    if (code == clear) {
                        code_size = data_size + 1;
                        code_mask = (1 << code_size) - 1;
                        available = clear + 2;
                        old_code = NullCode;
                        continue;
                    }
                    if (old_code == NullCode) {
                        this.pixelStack[top++] = this.suffix[code];
                        old_code = code;
                        first = code;
                        continue;
                    }
                    int in_code = code;
                    if (code == available) {
                        this.pixelStack[top++] = (byte)first;
                        code = old_code;
                    }
                    while (code > clear) {
                        this.pixelStack[top++] = this.suffix[code];
                        code = this.prefix[code];
                    }
                    first = this.suffix[code] & 0xFF;
                    if (available >= maxStackSize) {
                        this.pixelStack[top++] = (byte)first;
                        continue;
                    }
                    this.pixelStack[top++] = (byte)first;
                    this.prefix[available] = (short)old_code;
                    this.suffix[available] = (byte)first;
                    if ((++available & code_mask) == 0 && available < maxStackSize) {
                        ++code_size;
                        code_mask += available;
                    }
                    old_code = in_code;
                }
                this.pixels[pi++] = this.pixelStack[--top];
                ++i;
            }
            for (i = pi; i < nPix; ++i) {
                this.pixels[i] = 0;
            }
        }

        private int read() {
            int curByte = 0;
            try {
                curByte = this.in.read();
            }
            catch (IOException e) {
                this.status = this.STATUS_FORMAT_ERROR;
            }
            return curByte;
        }

        private int readBlock() {
            int n;
            this.blockSize = this.read();
            if (this.blockSize > 0) {
                try {
                    int count;
                    for (n = 0; n < this.blockSize && (count = this.in.read(this.block, n, this.blockSize - n)) != -1; n += count) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n < this.blockSize) {
                    this.status = this.STATUS_FORMAT_ERROR;
                }
            }
            return n;
        }

        private int[] readColorTable(int nColors) {
            int nBytes = 3 * nColors;
            int[] tab = null;
            byte[] c = new byte[nBytes];
            int n = 0;
            try {
                n = this.in.read(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < nBytes) {
                this.status = this.STATUS_FORMAT_ERROR;
            } else {
                tab = new int[256];
                int i = 0;
                int j = 0;
                while (i < nColors) {
                    int r = c[j++] & 0xFF;
                    int g = c[j++] & 0xFF;
                    int b = c[j++] & 0xFF;
                    tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
                }
            }
            return tab;
        }

        private void readContents() {
            boolean done = false;
            block10: while (!done && this.status == this.STATUS_OK) {
                int code = this.read();
                switch (code) {
                    case 44: {
                        this.readImage();
                        continue block10;
                    }
                    case 33: {
                        code = this.read();
                        switch (code) {
                            case 249: {
                                this.readGraphicControlExtension();
                                continue block10;
                            }
                            case 255: {
                                this.readBlock();
                                StringBuilder app = new StringBuilder();
                                for (int i = 0; i < 11; ++i) {
                                    app.append((char)this.block[i]);
                                }
                                if (app.toString().equals("NETSCAPE2.0")) {
                                    this.readExtension();
                                    continue block10;
                                }
                                this.skip();
                                continue block10;
                            }
                        }
                        this.skip();
                        continue block10;
                    }
                    case 59: {
                        done = true;
                        continue block10;
                    }
                    case 0: {
                        continue block10;
                    }
                }
                this.status = this.STATUS_FORMAT_ERROR;
            }
        }

        private void readGraphicControlExtension() {
            this.read();
            int packed = this.read();
            this.dispose = (packed & 0x1C) >> 2;
            if (this.dispose == 0) {
                this.dispose = 1;
            }
            this.transparency = (packed & 1) != 0;
            this.delay = this.readShort() * 10;
            this.transIndex = this.read();
            this.read();
        }

        private void readHeader() {
            StringBuilder id = new StringBuilder();
            for (int i = 0; i < 6; ++i) {
                id.append((char)this.read());
            }
            if (!id.toString().startsWith("GIF")) {
                this.status = this.STATUS_FORMAT_ERROR;
                return;
            }
            this.readLSD();
            if (this.gctFlag && this.status == this.STATUS_OK) {
                this.gct = this.readColorTable(this.gctSize);
                this.bgColor = this.gct[this.bgIndex];
            }
        }

        private void readImage() {
            this.ix = this.readShort();
            this.iy = this.readShort();
            this.iw = this.readShort();
            this.ih = this.readShort();
            int save = 0;
            int packed = this.read();
            boolean lctFlag = (packed & 0x80) != 0;
            this.interlace = (packed & 0x40) != 0;
            int lctSize = 2 << (packed & 7);
            if (lctFlag) {
                this.lct = this.readColorTable(lctSize);
                this.act = this.lct;
            } else {
                this.act = this.gct;
                if (this.bgIndex == this.transIndex) {
                    this.bgColor = 0;
                }
            }
            if (this.transparency) {
                save = this.act[this.transIndex];
                this.act[this.transIndex] = 0;
            }
            if (this.act == null) {
                this.status = this.STATUS_FORMAT_ERROR;
            }
            if (this.status != this.STATUS_OK) {
                return;
            }
            this.decodeImageData();
            this.skip();
            if (this.status != this.STATUS_OK) {
                return;
            }
            ++this.frameCount;
            this.image = new BufferedImage(this.width, this.height, 3);
            this.setPixels();
            this.frames.add(new Frame(this.image, this.delay));
            if (this.transparency) {
                this.act[this.transIndex] = save;
            }
            this.resetFrame();
        }

        private void readLSD() {
            this.width = this.readShort();
            this.height = this.readShort();
            int packed = this.read();
            this.gctFlag = (packed & 0x80) != 0;
            this.gctSize = 2 << (packed & 7);
            this.bgIndex = this.read();
            this.read();
        }

        private void readExtension() {
            do {
                this.readBlock();
            } while (this.blockSize > 0 && this.status == this.STATUS_OK);
        }

        private int readShort() {
            return this.read() | this.read() << 8;
        }

        private void resetFrame() {
            this.lastDispose = this.dispose;
            this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
            this.lastImage = this.image;
            this.lastBgColor = this.bgColor;
            this.lct = null;
        }

        private void skip() {
            do {
                this.readBlock();
            } while (this.blockSize > 0 && this.status == this.STATUS_OK);
        }
    }

    public static class Frame {
        private final BufferedImage image;
        private final int delay;

        private Frame(BufferedImage image, int delay) {
            this.image = image;
            this.delay = delay;
            if (image == null) {
                ServerUtils.logSevere("{GIF} Image must not be null.");
            }
            if (delay <= 0) {
                ServerUtils.logSevere("{GIF} Duration must be positive.");
            }
        }

        public int getDelay() {
            return this.delay;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

