/*
 * Decompiled with CFR 0.152.
 */
package me.RockinChaos.itemjoin.utils.images;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import me.RockinChaos.itemjoin.ItemJoin;
import me.RockinChaos.itemjoin.core.utils.ServerUtils;
import me.RockinChaos.itemjoin.utils.images.GIF;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class Renderer
extends MapRenderer {
    private final List<Integer> Rendered = new ArrayList<Integer>();
    private GIF gifImage = null;
    private boolean repeatForever = false;
    private int currentFrame = 0;
    private int toRepeat = 0;
    private int ticksToWait = 0;
    private boolean stopRendering = false;
    private int id = 0;
    private String staticImage = null;
    private BufferedImage imgCache = null;

    public Renderer(String image, int imageID) {
        this.id = imageID;
        this.staticImage = image;
        if (image != null && !image.equalsIgnoreCase("default.jpg")) {
            try {
                this.imgCache = ImageIO.read(new File(ItemJoin.getCore().getPlugin().getDataFolder(), image));
            }
            catch (IOException e) {
                ServerUtils.sendDebugTrace(e);
            }
        } else if (image != null && image.equalsIgnoreCase("default.jpg") && ItemJoin.getCore().getPlugin().getResource("files/generated/default.jpg") != null) {
            try {
                this.imgCache = ImageIO.read(Objects.requireNonNull(ItemJoin.getCore().getPlugin().getResource("files/generated/default.jpg")));
            }
            catch (IOException e) {
                ServerUtils.sendDebugTrace(e);
            }
        }
    }

    public Renderer(String image, int startFrame, int repeat) {
        this.gifImage = new GIF(image);
        this.currentFrame = startFrame;
        this.toRepeat = repeat;
        this.ticksToWait = this.gifImage.get(this.currentFrame).getDelay() / 1000 * 20;
        boolean bl = this.repeatForever = this.toRepeat < 0;
        if (this.gifImage == null) {
            ServerUtils.logSevere("{Renderer} GIF image must not be null.");
        }
        if (startFrame < 0 || startFrame >= this.gifImage.getFrameCount()) {
            ServerUtils.logSevere("{Renderer} Frame index out of bounds.");
        }
        ServerUtils.logDebug("{Renderer} Rendering custom-map-image; " + image + " with the id " + this.id);
    }

    public void render(@Nonnull MapView mapView, @Nonnull MapCanvas mapCanvas, @Nonnull Player player) {
        if (this.gifImage != null) {
            if (this.ticksToWait-- > 0 || this.stopRendering) {
                return;
            }
            if (this.currentFrame >= this.gifImage.getFrameCount()) {
                this.currentFrame = 0;
                if (!this.repeatForever && --this.toRepeat == 0) {
                    this.stopRendering = true;
                    return;
                }
            }
            GIF.Frame frame = this.gifImage.get(this.currentFrame++);
            mapCanvas.drawImage(0, 0, (Image)frame.getImage());
            this.ticksToWait = frame.getDelay() / 1000 * 20;
        } else if (this.Rendered.isEmpty() || !this.Rendered.contains(this.id)) {
            try {
                this.Rendered.add(this.id);
                mapView.setScale(MapView.Scale.NORMAL);
                mapCanvas.drawImage(0, 0, (Image)this.imgCache);
                ServerUtils.logDebug("{Renderer} Rendering custom-map-image; " + this.staticImage + " with the id " + this.id);
            }
            catch (Exception e) {
                ServerUtils.logSevere("{Renderer} There was a problem rending your map(s)!");
                ServerUtils.logWarn("{Renderer} Please check and make sure your image size is no larger than 128x128 pixels.");
                ServerUtils.sendDebugTrace(e);
            }
        }
    }
}

