#version 120
#include "/lib/properties.glsl"

#ifdef HAND_VISIBLE
    /*
        XorDev's "Default Shaderpack"

        This was put together by @XorDev to make it easier for anyone to make their own shaderpacks in Minecraft (Optifine).
        You can do whatever you want with this code! Credit is not necessary, but always appreciated!

        You can find more information about shaders in Optfine here:
        https://github.com/sp614x/optifine/blob/master/OptiFineDoc/doc/shaders.txt

    */
    //Get Entity id.
    attribute float mc_Entity;

    //Model * view matrix and it's inverse.
    uniform mat4 gbufferModelView;
    uniform mat4 gbufferModelViewInverse;

    //Pass vertex information to fragment shader.
    varying vec4 color;
    varying vec2 coord0;
    varying vec2 coord1;

    void main() {
        //Calculate world space position.
        vec3 pos = (gl_ModelViewMatrix * gl_Vertex).xyz;
        pos = (gbufferModelViewInverse * vec4(pos,1)).xyz;

        //Output position and fog to fragment shader.
        gl_Position = gl_ProjectionMatrix * gbufferModelView * vec4(pos,1);
        gl_FogFragCoord = length(pos);

        //Calculate view space normal.
        vec3 normal = gl_NormalMatrix * gl_Normal;
        //Use flat for flat "blocks" or world space normal for solid blocks.
        normal = (mc_Entity==1.) ? vec3(0,1,0) : (gbufferModelViewInverse * vec4(normal,0)).xyz;

        //Calculate simple lighting. Thanks to @PepperCode1
        float light = min(normal.x * normal.x * 0.6f + normal.y * normal.y * 0.25f * (3.0f + normal.y) + normal.z * normal.z * 0.8f, 1.0f);

        //Output color with lighting to fragment shader.
        color = vec4(gl_Color.rgb * light, gl_Color.a);
        //Output diffuse and lightmap texture coordinates to fragment shader.
        coord0 = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
        coord1 = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    }
#else
    void main() {}
#endif