package io.github.fishstiz.fidgetz.gui.components;

import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4069;

public interface ContainerEventHandlerPatch extends class_4069 {
    /**
     * In newer versions of minecraft, {@link class_4069#method_25402(double, double, int)}
     * always returns {@code true} if {@link class_4069#method_19355(double, double)} is present.
     * <p>
     * This code is copied from the 1.21.1 version of {@link class_4069#method_25402(double, double, int)}
     */
    @Override
    default boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 guieventlistener : this.method_25396()) {
            if (guieventlistener.method_25402(mouseX, mouseY, button)) {
                this.method_25395(guieventlistener);
                if (button == 0) {
                    this.method_25398(true);
                }

                return true;
            }
        }
        return false;
    }

    /**
     * {@link class_4069#method_25402(double, double, int)}, except it only
     * returns true if mouse click is actually handled instead of when child is present.
     */
    default boolean mouseClickedAt(double mouseX, double mouseY, int button) {
        return this.method_19355(mouseX, mouseY).map(child -> {
            if (child.method_25402(mouseX, mouseY, button)) {
                this.method_25395(child);
                if (button == class_3675.field_32000) this.method_25398(true);
                return true;
            }
            return false;
        }).orElse(false);
    }
}
