package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.*;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5244;

import static io.github.fishstiz.fidgetz.util.DrawUtil.DEMO_BACKGROUND;
import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.SPACING;

public class Sidebar extends ToggleableDialog<LayoutWrapper<FlexLayout>> implements ContextMenuContainer {
    private static final int MIN_WIDTH = 100;

    public <S extends class_437 & ToggleableDialogContainer> Sidebar(S screen) {
        super(createBuilder(screen));

        this.root().setPadding(SPACING);
        this.root().setMinWidth(MIN_WIDTH);
    }

    private static <S extends class_437 & ToggleableDialogContainer> Builder<LayoutWrapper<FlexLayout>, ?> createBuilder(S screen) {
        FlexLayout layout = FlexLayout.vertical(() -> getMaxHeight(screen)).spacing(SPACING);
        return builder(screen, new LayoutWrapper<>(layout)).setBackground(DEMO_BACKGROUND);
    }

    public void init(class_2561 title, Runnable onClose, int maxWidth) {
        final FidgetzButton<Void> closeButton = FidgetzButton.<Void>builder()
                .makeSquare()
                .setMessage(class_5244.field_24334)
                .setSprite(GuiConstants.CROSS_SPRITE)
                .setOnPress(() -> this.setOpen(false))
                .addListener(onClose)
                .build();
        final FidgetzText<Void> titleWidget = FidgetzText.<Void>builder()
                .setMessage(title)
                .setOffsetY(1)
                .alignLeft()
                .build();

        final FlexLayout header = FlexLayout.horizontal(() -> maxWidth).spacing(SPACING);
        header.addChild(closeButton);
        header.addFlexChild(titleWidget);

        this.root().layout().addChild(header);
    }

    public void repositionElements() {
        this.root().setMinHeight(getMaxHeight(this.screen));
        this.root().method_48222();
        this.root().method_48229(0, 0);
    }

    private static int getMaxHeight(class_437 screen) {
        return screen.field_22790 - SPACING * 2;
    }
}
