package io.github.fishstiz.fidgetz.util.debounce;

import java.util.function.Consumer;
import net.minecraft.class_156;

public class SimplePollingDebouncer<T> extends PollingDebouncer<T> {
    private boolean pending = false;
    private long lastCallTime = 0;
    private T lastArg = null;

    public SimplePollingDebouncer(Consumer<T> task, long delay) {
        super(task, delay);
    }

    public SimplePollingDebouncer(Runnable task, long delay) {
        super(task, delay);
    }

    @Override
    public void accept(T t) {
        this.lastCallTime = class_156.method_658();
        this.pending = true;
        this.lastArg = t;
    }

    @Override
    public void abort() {
        this.pending = false;
    }

    @Override
    public void poll() {
        if (this.pending && class_156.method_658() - this.lastCallTime >= this.delay) {
            try {
                this.task.accept(this.lastArg);
            } finally {
                this.pending = false;
            }
        }
    }
}